/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.db2client;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.SqlConnection;
import io.vertx.sqlclient.PreparedStatement;

@RxGen(value=io.vertx.db2client.DB2Connection.class)
public class DB2Connection
extends SqlConnection {
    public static final TypeArg<DB2Connection> __TYPE_ARG = new TypeArg<DB2Connection>(obj -> new DB2Connection((io.vertx.db2client.DB2Connection)obj), DB2Connection::getDelegate);
    private final io.vertx.db2client.DB2Connection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DB2Connection that = (DB2Connection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DB2Connection(io.vertx.db2client.DB2Connection delegate) {
        super((io.vertx.sqlclient.SqlConnection)delegate);
        this.delegate = delegate;
    }

    public DB2Connection(Object delegate) {
        super((io.vertx.sqlclient.SqlConnection)((io.vertx.db2client.DB2Connection)delegate));
        this.delegate = (io.vertx.db2client.DB2Connection)delegate;
    }

    public io.vertx.db2client.DB2Connection getDelegate() {
        return this.delegate;
    }

    public static void connect(io.vertx.reactivex.core.Vertx vertx, DB2ConnectOptions connectOptions, final Handler<AsyncResult<DB2Connection>> handler) {
        io.vertx.db2client.DB2Connection.connect((Vertx)vertx.getDelegate(), (DB2ConnectOptions)connectOptions, (Handler)new Handler<AsyncResult<io.vertx.db2client.DB2Connection>>(){

            @Override
            public void handle(AsyncResult<io.vertx.db2client.DB2Connection> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(DB2Connection.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public static Single<DB2Connection> rxConnect(io.vertx.reactivex.core.Vertx vertx, DB2ConnectOptions connectOptions) {
        return AsyncResultSingle.toSingle(handler -> DB2Connection.connect(vertx, connectOptions, (Handler<AsyncResult<DB2Connection>>)handler));
    }

    public static void connect(io.vertx.reactivex.core.Vertx vertx, String connectionUri, final Handler<AsyncResult<DB2Connection>> handler) {
        io.vertx.db2client.DB2Connection.connect((Vertx)vertx.getDelegate(), (String)connectionUri, (Handler)new Handler<AsyncResult<io.vertx.db2client.DB2Connection>>(){

            @Override
            public void handle(AsyncResult<io.vertx.db2client.DB2Connection> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(DB2Connection.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
    }

    public static Single<DB2Connection> rxConnect(io.vertx.reactivex.core.Vertx vertx, String connectionUri) {
        return AsyncResultSingle.toSingle(handler -> DB2Connection.connect(vertx, connectionUri, (Handler<AsyncResult<DB2Connection>>)handler));
    }

    @Override
    public DB2Connection prepare(String sql, final Handler<AsyncResult<io.vertx.reactivex.sqlclient.PreparedStatement>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<PreparedStatement>>(){

            @Override
            public void handle(AsyncResult<PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(io.vertx.reactivex.sqlclient.PreparedStatement.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public Single<io.vertx.reactivex.sqlclient.PreparedStatement> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.prepare(sql, (Handler)handler));
    }

    @Override
    public DB2Connection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public DB2Connection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public DB2Connection ping(Handler<AsyncResult<Void>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public Completable rxPing() {
        return AsyncResultCompletable.toCompletable(handler -> this.ping((Handler<AsyncResult<Void>>)handler));
    }

    public DB2Connection debug(Handler<AsyncResult<Void>> handler) {
        this.delegate.debug(handler);
        return this;
    }

    public Completable rxDebug() {
        return AsyncResultCompletable.toCompletable(handler -> this.debug((Handler<AsyncResult<Void>>)handler));
    }

    public static DB2Connection newInstance(io.vertx.db2client.DB2Connection arg) {
        return arg != null ? new DB2Connection(arg) : null;
    }
}

