/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.sql;

import io.reactivex.Completable;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleTransformer;
import io.reactivex.exceptions.Exceptions;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.sql.SQLConnection;
import io.vertx.reactivex.ext.sql.impl.InTransactionCompletable;
import io.vertx.reactivex.ext.sql.impl.InTransactionFlowable;
import io.vertx.reactivex.ext.sql.impl.InTransactionMaybe;
import io.vertx.reactivex.ext.sql.impl.InTransactionObservable;
import io.vertx.reactivex.ext.sql.impl.InTransactionSingle;
import java.util.function.Function;

public class SQLClientHelper {
    public static <T> FlowableTransformer<T, T> txFlowableTransformer(SQLConnection sqlConnection) {
        return new InTransactionFlowable(sqlConnection);
    }

    public static <T> Flowable<T> inTransactionFlowable(SQLClient client, Function<SQLConnection, Flowable<T>> sourceSupplier) {
        return SQLClientHelper.usingConnectionFlowable(client, conn -> ((Flowable)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txFlowableTransformer(conn)));
    }

    public static <T> ObservableTransformer<T, T> txObservableTransformer(SQLConnection sqlConnection) {
        return new InTransactionObservable(sqlConnection);
    }

    public static <T> Observable<T> inTransactionObservable(SQLClient client, Function<SQLConnection, Observable<T>> sourceSupplier) {
        return SQLClientHelper.usingConnectionObservable(client, conn -> ((Observable)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txObservableTransformer(conn)));
    }

    public static <T> SingleTransformer<T, T> txSingleTransformer(SQLConnection sqlConnection) {
        return new InTransactionSingle(sqlConnection);
    }

    public static <T> Single<T> inTransactionSingle(SQLClient client, Function<SQLConnection, Single<T>> sourceSupplier) {
        return SQLClientHelper.usingConnectionSingle(client, conn -> ((Single)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txSingleTransformer(conn)));
    }

    public static <T> MaybeTransformer<T, T> txMaybeTransformer(SQLConnection sqlConnection) {
        return new InTransactionMaybe(sqlConnection);
    }

    public static <T> Maybe<T> inTransactionMaybe(SQLClient client, Function<SQLConnection, Maybe<T>> sourceSupplier) {
        return SQLClientHelper.usingConnectionMaybe(client, conn -> ((Maybe)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txMaybeTransformer(conn)));
    }

    public static CompletableTransformer txCompletableTransformer(SQLConnection sqlConnection) {
        return new InTransactionCompletable(sqlConnection);
    }

    public static Completable inTransactionCompletable(SQLClient client, Function<SQLConnection, Completable> sourceSupplier) {
        return SQLClientHelper.usingConnectionCompletable(client, conn -> ((Completable)sourceSupplier.apply((SQLConnection)conn)).compose(SQLClientHelper.txCompletableTransformer(conn)));
    }

    public static <T> Flowable<T> usingConnectionFlowable(SQLClient client, Function<SQLConnection, Flowable<T>> sourceSupplier) {
        return client.rxGetConnection().flatMapPublisher(conn -> {
            try {
                return ((Flowable)sourceSupplier.apply((SQLConnection)conn)).doFinally(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                conn.close();
                return Flowable.error(t);
            }
        });
    }

    public static <T> Observable<T> usingConnectionObservable(SQLClient client, Function<SQLConnection, Observable<T>> sourceSupplier) {
        return client.rxGetConnection().flatMapObservable(conn -> {
            try {
                return ((Observable)sourceSupplier.apply((SQLConnection)conn)).doFinally(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                conn.close();
                return Observable.error(t);
            }
        });
    }

    public static <T> Single<T> usingConnectionSingle(SQLClient client, Function<SQLConnection, Single<T>> sourceSupplier) {
        return client.rxGetConnection().flatMap(conn -> {
            try {
                return ((Single)sourceSupplier.apply((SQLConnection)conn)).doFinally(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                conn.close();
                return Single.error(t);
            }
        });
    }

    public static <T> Maybe<T> usingConnectionMaybe(SQLClient client, Function<SQLConnection, Maybe<T>> sourceSupplier) {
        return client.rxGetConnection().flatMapMaybe(conn -> {
            try {
                return ((Maybe)sourceSupplier.apply((SQLConnection)conn)).doFinally(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                conn.close();
                return Maybe.error(t);
            }
        });
    }

    public static Completable usingConnectionCompletable(SQLClient client, Function<SQLConnection, Completable> sourceSupplier) {
        return client.rxGetConnection().flatMapCompletable(conn -> {
            try {
                return ((Completable)sourceSupplier.apply((SQLConnection)conn)).doFinally(conn::close);
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal(t);
                conn.close();
                return Completable.error(t);
            }
        });
    }

    private SQLClientHelper() {
    }
}

