/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.sqlclient;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.sqlclient.PreparedStatement;
import io.vertx.reactivex.sqlclient.SqlClient;

@RxGen(value=io.vertx.sqlclient.Transaction.class)
public class Transaction
extends SqlClient {
    public static final TypeArg<Transaction> __TYPE_ARG = new TypeArg<Transaction>(obj -> new Transaction((io.vertx.sqlclient.Transaction)obj), Transaction::getDelegate);
    private final io.vertx.sqlclient.Transaction delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Transaction(io.vertx.sqlclient.Transaction delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public Transaction(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.Transaction)delegate));
        this.delegate = (io.vertx.sqlclient.Transaction)delegate;
    }

    public io.vertx.sqlclient.Transaction getDelegate() {
        return this.delegate;
    }

    public Transaction prepare(String sql, final Handler<AsyncResult<PreparedStatement>> handler) {
        this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            @Override
            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(PreparedStatement.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<PreparedStatement> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.prepare(sql, (Handler<AsyncResult<PreparedStatement>>)handler));
    }

    public void commit() {
        this.delegate.commit();
    }

    public void commit(Handler<AsyncResult<Void>> handler) {
        this.delegate.commit(handler);
    }

    public Completable rxCommit() {
        return AsyncResultCompletable.toCompletable(handler -> this.commit((Handler<AsyncResult<Void>>)handler));
    }

    public void rollback() {
        this.delegate.rollback();
    }

    public void rollback(Handler<AsyncResult<Void>> handler) {
        this.delegate.rollback(handler);
    }

    public Completable rxRollback() {
        return AsyncResultCompletable.toCompletable(handler -> this.rollback((Handler<AsyncResult<Void>>)handler));
    }

    public Transaction abortHandler(Handler<Void> handler) {
        this.delegate.abortHandler(handler);
        return this;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public static Transaction newInstance(io.vertx.sqlclient.Transaction arg) {
        return arg != null ? new Transaction(arg) : null;
    }
}

