/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.jsonstructure;

import java.util.Iterator;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.jsonstructure.JsonStructureIterator;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonObjectIterator
extends JsonStructureIterator {
    private final JsonObject jsonObject;
    private final Iterator<String> keyIterator;
    private String currentKey;
    private State state = State.START;

    JsonObjectIterator(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
        this.keyIterator = jsonObject.keySet().iterator();
    }

    private void nextKey() {
        if (!this.keyIterator.hasNext()) {
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Object is empty"));
        }
        this.currentKey = this.keyIterator.next();
    }

    @Override
    public JsonParser.Event next() {
        switch (this.state) {
            case START: {
                if (this.keyIterator.hasNext()) {
                    this.nextKey();
                    this.setState(State.KEY);
                    return JsonParser.Event.KEY_NAME;
                }
                this.setState(State.END);
                return JsonParser.Event.END_OBJECT;
            }
            case KEY: {
                this.setState(State.VALUE);
                JsonValue value = this.getValue();
                return this.getValueEvent(value);
            }
            case VALUE: {
                if (this.keyIterator.hasNext()) {
                    this.nextKey();
                    this.setState(State.KEY);
                    return JsonParser.Event.KEY_NAME;
                }
                this.setState(State.END);
                return JsonParser.Event.END_OBJECT;
            }
        }
        throw new JsonbException("Illegal state");
    }

    @Override
    public boolean hasNext() {
        return this.state != State.END;
    }

    @Override
    public JsonValue getValue() {
        return (JsonValue)this.jsonObject.get(this.currentKey);
    }

    @Override
    String getString() {
        if (this.state == State.KEY) {
            return this.currentKey;
        }
        return super.getString();
    }

    @Override
    JsonbException createIncompatibleValueError() {
        return new JsonbException(Messages.getMessage(MessageKeys.NUMBER_INCOMPATIBLE_VALUE_TYPE_OBJECT, new Object[]{this.getValue().getValueType(), this.currentKey}));
    }

    private void setState(State state) {
        this.state = state;
    }

    public String getKey() {
        return this.currentKey;
    }

    public static enum State {
        START,
        KEY,
        VALUE,
        END;

    }
}

