/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.model.CreatorModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonbCreator {
    private final Executable executable;
    private final CreatorModel[] params;

    public JsonbCreator(Executable executable, CreatorModel[] creatorModels) {
        this.executable = executable;
        this.params = creatorModels;
    }

    public <T> T call(Object[] params, Class<T> on) {
        try {
            if (this.executable instanceof Constructor) {
                return ((Constructor)this.executable).newInstance(params);
            }
            return (T)((Method)this.executable).invoke(on, params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonbException(Messages.getMessage(MessageKeys.ERROR_CALLING_JSONB_CREATOR, on), e);
        }
    }

    public boolean contains(String paramName) {
        return this.findByName(paramName) != null;
    }

    public CreatorModel findByName(String paramName) {
        for (CreatorModel param : this.params) {
            if (!param.getName().equals(paramName)) continue;
            return param;
        }
        return null;
    }

    public CreatorModel[] getParams() {
        return this.params;
    }
}

