/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.util.MediaTypeHelper;

public class MediaTypeMap<T> {
    private static final Pattern COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+(.+)");
    public static final Pattern COMPOSITE_SUBTYPE_WILDCARD_PATTERN = Pattern.compile("\\*\\+(.+)");
    public static final Pattern WILD_SUBTYPE_COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+\\*");
    private volatile Map<String, SubtypeMap<T>> index;
    private volatile Map<CachedMediaTypeAndClass, List<T>> classCache;
    private volatile List<Entry<T>> wildcards;
    private volatile List<Entry<T>> everything;
    private boolean lockSnapshots;
    public static boolean useCache = true;

    public static String compositeWildSubtype(String subtype) {
        Matcher matcher = COMPOSITE_SUBTYPE_WILDCARD_PATTERN.matcher(subtype);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String wildCompositeSubtype(String subtype) {
        Matcher matcher = WILD_SUBTYPE_COMPOSITE_PATTERN.matcher(subtype);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    static <A> List<A> copyAndAdd(List<A> a, A entry) {
        ArrayList<A> newList = new ArrayList<A>(a.size() + 1);
        newList.add(entry);
        newList.addAll(0, a);
        return newList;
    }

    public MediaTypeMap() {
        this.index = new HashMap<String, SubtypeMap<T>>();
        this.wildcards = new ArrayList<Entry<T>>();
        this.everything = new ArrayList<Entry<T>>();
    }

    public MediaTypeMap(MediaTypeMap<T> mediaTypeMap) {
        this.lockSnapshots = true;
        this.index = mediaTypeMap.index;
        this.wildcards = mediaTypeMap.wildcards;
        this.everything = mediaTypeMap.everything;
        this.classCache = mediaTypeMap.classCache;
    }

    public void lockSnapshots() {
        this.lockSnapshots = true;
    }

    public synchronized void add(MediaType type, T obj) {
        MediaType newType = new MediaType(type.getType().toLowerCase(), type.getSubtype().toLowerCase(), type.getParameters());
        Entry entry = new Entry(newType, obj);
        this.add(entry);
    }

    public synchronized void add(String mediaType, T obj) {
        MediaType newType = MediaTypeHeaderDelegate.parse(mediaType.toLowerCase());
        Entry entry = new Entry(newType, obj);
        this.add(entry);
    }

    public synchronized void addWildcard(T obj) {
        Entry entry = new Entry(MediaType.WILDCARD_TYPE, obj);
        this.addWildcard(entry);
    }

    protected void add(Entry<T> entry) {
        if (entry.mediaType.isWildcardType()) {
            this.addWildcard(entry);
        } else {
            Map<String, SubtypeMap<T>> newIndex = this.copyIndex();
            newIndex.putIfAbsent(entry.mediaType.getType(), new SubtypeMap());
            ((SubtypeMap)newIndex.get(entry.mediaType.getType())).add(entry);
            this.index = newIndex;
            this.mergeEverything(entry);
        }
    }

    private Map<String, SubtypeMap<T>> copyIndex() {
        Map<String, SubtypeMap<T>> newIndex = this.index;
        if (this.lockSnapshots) {
            HashMap<String, SubtypeMap<T>> finalIndex = new HashMap<String, SubtypeMap<T>>();
            newIndex = finalIndex;
            this.index.forEach((key, value) -> finalIndex.put((String)key, new SubtypeMap((SubtypeMap)value)));
        }
        return newIndex;
    }

    private void addWildcard(Entry<T> entry) {
        if (this.lockSnapshots) {
            this.wildcards = MediaTypeMap.copyAndAdd(this.wildcards, entry);
        } else {
            this.wildcards.add(entry);
        }
        this.mergeEverything(entry);
    }

    public synchronized void addRegular(MediaType mediaType, T obj) {
        Entry entry = new Entry(mediaType, obj);
        Map<String, SubtypeMap<T>> newIndex = this.copyIndex();
        newIndex.putIfAbsent(entry.mediaType.getType(), new SubtypeMap());
        SubtypeMap<T> subtypeMap = newIndex.get(entry.mediaType.getType());
        ((SubtypeMap)subtypeMap).addRegular(entry);
        this.index = newIndex;
        this.mergeEverything(entry);
    }

    public synchronized void addCompositeWild(MediaType mediaType, T obj, String baseSubtype) {
        Entry entry = new Entry(mediaType, obj);
        Map<String, SubtypeMap<T>> newIndex = this.copyIndex();
        newIndex.putIfAbsent(entry.mediaType.getType(), new SubtypeMap());
        SubtypeMap<T> subtypeMap = newIndex.get(entry.mediaType.getType());
        ((SubtypeMap)subtypeMap).addCompositeWild(entry, baseSubtype);
        this.index = newIndex;
        this.mergeEverything(entry);
    }

    public synchronized void addWildComposite(MediaType mediaType, T obj, String baseSubtype) {
        Entry entry = new Entry(mediaType, obj);
        Map<String, SubtypeMap<T>> newIndex = this.copyIndex();
        newIndex.putIfAbsent(entry.mediaType.getType(), new SubtypeMap());
        SubtypeMap<T> subtypeMap = newIndex.get(entry.mediaType.getType());
        ((SubtypeMap)subtypeMap).addWildComposite(entry, baseSubtype);
        this.index = newIndex;
        this.mergeEverything(entry);
    }

    public synchronized void addWildSubtype(MediaType mediaType, T obj) {
        Entry entry = new Entry(mediaType, obj);
        Map<String, SubtypeMap<T>> newIndex = this.copyIndex();
        newIndex.putIfAbsent(entry.mediaType.getType(), new SubtypeMap());
        SubtypeMap<T> subtypeMap = newIndex.get(entry.mediaType.getType());
        ((SubtypeMap)subtypeMap).addWildcard(entry);
        this.index = newIndex;
        this.mergeEverything(entry);
    }

    private void mergeEverything(Entry<T> entry) {
        List<Entry<T>> newAll = this.everything;
        if (this.lockSnapshots) {
            newAll = MediaTypeMap.copyAndAdd(this.everything, entry);
            Collections.sort(newAll);
            this.everything = newAll;
        } else {
            this.everything.add(entry);
            Collections.sort(this.everything);
        }
        this.classCache = null;
    }

    private static <T> List<T> convert(List<Entry<T>> list) {
        ArrayList newList = new ArrayList(list.size());
        for (Entry<T> entry : list) {
            newList.add(entry.object);
        }
        return newList;
    }

    public List<T> getPossible(MediaType accept) {
        accept = new MediaType(accept.getType().toLowerCase(), accept.getSubtype().toLowerCase(), accept.getParameters());
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            return MediaTypeMap.convert(this.everything);
        }
        SubtypeMap<T> indexed = this.index.get(accept.getType());
        if (indexed != null) {
            matches.addAll(((SubtypeMap)indexed).getPossible(accept));
        }
        matches.addAll(this.wildcards);
        Collections.sort(matches);
        return MediaTypeMap.convert(matches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getPossible(MediaType accept, Class<?> type) {
        List<T> cached = null;
        CachedMediaTypeAndClass cacheEntry = null;
        if (useCache) {
            cacheEntry = new CachedMediaTypeAndClass(type, accept);
            if (this.classCache != null && (cached = this.classCache.get(cacheEntry)) != null) {
                return cached;
            }
        }
        accept = new MediaType(accept.getType().toLowerCase(), accept.getSubtype().toLowerCase(), accept.getParameters());
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            matches.addAll(this.everything);
        } else {
            SubtypeMap<T> indexed = this.index.get(accept.getType());
            if (indexed != null) {
                matches.addAll(((SubtypeMap)indexed).getPossible(accept));
            }
            matches.addAll(this.wildcards);
        }
        Collections.sort(matches, new TypedEntryComparator(type));
        cached = MediaTypeMap.convert(matches);
        if (useCache) {
            Map<CachedMediaTypeAndClass, List<T>> cache = this.classCache;
            if (cache == null) {
                MediaTypeMap mediaTypeMap = this;
                synchronized (mediaTypeMap) {
                    if (this.classCache == null) {
                        this.classCache = new HashMap<CachedMediaTypeAndClass, List<T>>();
                    }
                    cache = this.classCache;
                }
            }
            cache.put(cacheEntry, cached);
        }
        return cached;
    }

    private static class CachedMediaTypeAndClass {
        private WeakReference<Class<?>> clazz;
        private MediaType mediaType;
        private final int hash;

        private CachedMediaTypeAndClass(Class clazz, MediaType mediaType) {
            this.clazz = new WeakReference<Class>(clazz);
            this.mediaType = mediaType;
            int result = clazz.hashCode();
            this.hash = result = 31 * result + (mediaType.getType() != null ? mediaType.getType().hashCode() : 0) + (mediaType.getSubtype() != null ? mediaType.getSubtype().hashCode() : 0);
        }

        private Class<?> getClazz() {
            return (Class)this.clazz.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedMediaTypeAndClass that = (CachedMediaTypeAndClass)o;
            Class<?> clazz = this.getClazz();
            if (clazz == null || that.getClazz() == null) {
                return false;
            }
            if (!clazz.equals(that.getClazz())) {
                return false;
            }
            if (this.mediaType.getType() != null ? !this.mediaType.getType().equals(that.mediaType.getType()) : this.mediaType.getType() != that.mediaType.getType()) {
                return false;
            }
            return !(this.mediaType.getSubtype() != null ? !this.mediaType.getSubtype().equals(that.mediaType.getSubtype()) : this.mediaType.getSubtype() != that.mediaType.getSubtype());
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private class SubtypeMap<T> {
        private volatile Map<String, List<Entry<T>>> index;
        private volatile Map<String, List<Entry<T>>> compositeIndex;
        private volatile Map<String, List<Entry<T>>> wildCompositeIndex;
        private volatile List<Entry<T>> wildcards;
        private volatile List<Entry<T>> all;

        private SubtypeMap() {
            this.index = new HashMap<String, List<Entry<T>>>();
            this.compositeIndex = new HashMap<String, List<Entry<T>>>();
            this.wildCompositeIndex = new HashMap<String, List<Entry<T>>>();
            this.wildcards = new ArrayList<Entry<T>>();
            this.all = new ArrayList<Entry<T>>();
        }

        private SubtypeMap(SubtypeMap<T> subtypeMap) {
            this.index = subtypeMap.index;
            this.compositeIndex = subtypeMap.compositeIndex;
            this.wildCompositeIndex = subtypeMap.wildCompositeIndex;
            this.wildcards = subtypeMap.wildcards;
            this.all = subtypeMap.all;
        }

        private void add(Entry<T> entry) {
            Matcher matcher = COMPOSITE_SUBTYPE_WILDCARD_PATTERN.matcher(entry.mediaType.getSubtype());
            Matcher wildCompositeMatcher = WILD_SUBTYPE_COMPOSITE_PATTERN.matcher(entry.mediaType.getSubtype());
            if (entry.mediaType.isWildcardSubtype()) {
                this.addWildcard(entry);
            } else if (matcher.matches()) {
                String baseSubType = matcher.group(1);
                this.addCompositeWild(entry, baseSubType);
            } else if (wildCompositeMatcher.matches()) {
                String base = wildCompositeMatcher.group(1);
                this.addWildComposite(entry, base);
            } else {
                this.addRegular(entry);
            }
        }

        private void addRegular(Entry<T> entry) {
            Map<String, List<Entry<T>>> newIndex = this.index;
            if (MediaTypeMap.this.lockSnapshots) {
                newIndex = this.copy(this.index);
            }
            this.add(newIndex, entry.mediaType.getSubtype(), entry);
            this.index = newIndex;
            this.merge(entry);
        }

        private void addWildComposite(Entry<T> entry, String base) {
            Map<String, List<Entry<T>>> newWildCompositeIndex = this.wildCompositeIndex;
            if (MediaTypeMap.this.lockSnapshots) {
                newWildCompositeIndex = this.wildCompositeIndex;
            }
            this.add(newWildCompositeIndex, base, entry);
            this.wildCompositeIndex = newWildCompositeIndex;
            this.merge(entry);
        }

        private void addCompositeWild(Entry<T> entry, String baseSubType) {
            Map<String, List<Entry<T>>> newCompositeIndex = this.compositeIndex;
            if (MediaTypeMap.this.lockSnapshots) {
                newCompositeIndex = this.copy(this.compositeIndex);
            }
            this.add(newCompositeIndex, baseSubType, entry);
            this.compositeIndex = newCompositeIndex;
            this.merge(entry);
        }

        private void addWildcard(Entry<T> entry) {
            if (MediaTypeMap.this.lockSnapshots) {
                this.wildcards = MediaTypeMap.copyAndAdd(this.wildcards, entry);
            } else {
                this.wildcards.add(entry);
            }
            this.merge(entry);
        }

        private void merge(Entry<T> entry) {
            if (MediaTypeMap.this.lockSnapshots) {
                this.all = MediaTypeMap.copyAndAdd(this.all, entry);
            } else {
                this.all.add(entry);
            }
        }

        private Map<String, List<Entry<T>>> copy(Map<String, List<Entry<T>>> original) {
            HashMap copy = new HashMap(original.size());
            original.forEach((key, value) -> copy.put((String)key, new ArrayList(value)));
            return copy;
        }

        private void add(Map<String, List<Entry<T>>> map, String key, Entry<T> entry) {
            map.putIfAbsent(key, new CopyOnWriteArrayList());
            map.get(key).add(entry);
        }

        private List<Entry<T>> getPossible(MediaType accept) {
            List<Entry<T>> indexed2;
            if (accept.isWildcardSubtype()) {
                return this.all;
            }
            ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
            List<Entry<T>> indexed = this.index.get(accept.getSubtype());
            if (indexed != null) {
                matches.addAll(indexed);
            }
            Matcher matcher = COMPOSITE_PATTERN.matcher(accept.getSubtype());
            String compositeKey = accept.getSubtype();
            if (matcher.matches()) {
                String wildCompositeKey = matcher.group(1);
                List<Entry<T>> windex = this.wildCompositeIndex.get(wildCompositeKey);
                if (windex != null) {
                    matches.addAll(windex);
                }
                compositeKey = matcher.group(2);
            }
            if ((indexed2 = this.compositeIndex.get(compositeKey)) != null) {
                matches.addAll(indexed2);
            }
            matches.addAll(this.wildcards);
            return matches;
        }
    }

    private static class Entry<T>
    implements Comparable<Entry<?>> {
        public MediaType mediaType;
        public T object;

        private Entry(MediaType mediaType, T object) {
            this.mediaType = mediaType;
            this.object = object;
        }

        @Override
        public int compareTo(Entry<?> entry) {
            int val = MediaTypeHelper.compareWeight(this.mediaType, entry.mediaType);
            if (val == 0 && this.object instanceof Comparable && entry.object instanceof Comparable) {
                return ((Comparable)this.object).compareTo(entry.object);
            }
            return val;
        }
    }

    private static class TypedEntryComparator
    implements Comparator<Entry<?>>,
    Serializable {
        private static final long serialVersionUID = -8815419198743440920L;
        private Class<?> type;

        TypedEntryComparator(Class<?> type) {
            this.type = type;
        }

        private boolean isAssignableFrom(Typed typed) {
            if (typed.getType() == null) {
                return false;
            }
            return typed.getType().isAssignableFrom(this.type);
        }

        private int compareTypes(Entry<?> entry, Entry<?> entry1) {
            int val = 0;
            if (entry.object instanceof Typed && entry1.object instanceof Typed && this.type != null) {
                boolean twoTyped;
                Typed one = (Typed)entry.object;
                Typed two = (Typed)entry1.object;
                boolean oneTyped = this.isAssignableFrom(one);
                val = oneTyped == (twoTyped = this.isAssignableFrom(two)) && !oneTyped && !twoTyped ? 0 : (oneTyped == twoTyped ? (one.getType().equals(two.getType()) ? 0 : (one.getType().isAssignableFrom(two.getType()) ? 1 : -1)) : (oneTyped ? -1 : 1));
            }
            return val;
        }

        @Override
        public int compare(Entry<?> entry, Entry<?> entry1) {
            int val = this.compareTypes(entry, entry1);
            if (val == 0) {
                val = entry.compareTo(entry1);
            }
            return val;
        }
    }

    public static interface Typed {
        public Class<?> getType();
    }
}

