/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker00;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker08;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker13;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.impl.headers.HeadersAdaptor;
import java.net.URI;
import java.nio.charset.StandardCharsets;

class WebSocketHandshakeInboundHandler
extends ChannelInboundHandlerAdapter {
    private final Handler<AsyncResult<HeadersAdaptor>> wsHandler;
    private final WebSocketClientHandshaker handshaker;
    private ChannelHandlerContext chctx;
    private FullHttpResponse response;

    WebSocketHandshakeInboundHandler(WebSocketClientHandshaker handshaker, Handler<AsyncResult<HeadersAdaptor>> wsHandler) {
        this.handshaker = handshaker;
        this.wsHandler = wsHandler;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.wsHandler.handle(Future.failedFuture(new WebSocketHandshakeException("Connection closed while handshake in process")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse resp = (HttpResponse)msg;
            this.response = new DefaultFullHttpResponse(resp.protocolVersion(), resp.status());
            this.response.headers().add(resp.headers());
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            try {
                if (this.response != null) {
                    this.response.content().writeBytes(content.content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        ChannelPipeline pipeline = this.chctx.pipeline();
                        pipeline.remove(this);
                        HttpContentDecompressor handler = pipeline.get(HttpContentDecompressor.class);
                        if (handler != null) {
                            ctx.pipeline().remove(handler);
                        }
                        Future<HeadersAdaptor> fut = this.handshakeComplete(this.response);
                        this.wsHandler.handle(fut);
                    }
                }
            }
            finally {
                content.release();
            }
        }
    }

    private Future<HeadersAdaptor> handshakeComplete(FullHttpResponse response) {
        int sc = response.status().code();
        if (sc != 101) {
            String msg = "WebSocket upgrade failure: " + sc;
            ByteBuf content = response.content();
            if (content != null && content.readableBytes() > 0) {
                msg = msg + " (" + content.toString(StandardCharsets.UTF_8) + ")";
            }
            UpgradeRejectedException failure = new UpgradeRejectedException(msg, sc);
            return Future.failedFuture(failure);
        }
        try {
            this.handshaker.finishHandshake(this.chctx.channel(), response);
            return Future.succeededFuture(new HeadersAdaptor(response.headers()));
        }
        catch (WebSocketHandshakeException e) {
            return Future.failedFuture(e);
        }
    }

    static WebSocketClientHandshaker newHandshaker(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking) {
        final WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().expectMaskedFrames(false).allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(false).closeOnProtocolViolation(false).build();
        if (version == WebSocketVersion.V13) {
            return new WebSocketClientHandshaker13(webSocketURL, WebSocketVersion.V13, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                @Override
                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket13FrameDecoder(config);
                }
            };
        }
        if (version == WebSocketVersion.V08) {
            return new WebSocketClientHandshaker08(webSocketURL, WebSocketVersion.V08, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                @Override
                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket08FrameDecoder(config);
                }
            };
        }
        if (version == WebSocketVersion.V07) {
            return new WebSocketClientHandshaker07(webSocketURL, WebSocketVersion.V07, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, false, -1L){

                @Override
                protected WebSocketFrameDecoder newWebsocketDecoder() {
                    return new WebSocket07FrameDecoder(config);
                }
            };
        }
        if (version == WebSocketVersion.V00) {
            return new WebSocketClientHandshaker00(webSocketURL, WebSocketVersion.V00, subprotocol, customHeaders, maxFramePayloadLength, -1L);
        }
        throw new WebSocketHandshakeException("Protocol version " + (Object)((Object)version) + " not supported.");
    }
}

