/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ImmutableList;
import io.quarkus.qute.ParameterDeclarationNode;
import io.quarkus.qute.Parser;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SectionNode;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.TextNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class SectionBlock {
    public final TemplateNode.Origin origin;
    public final String id;
    public final String label;
    public final Map<String, String> parameters;
    public final Map<String, Expression> expressions;
    List<TemplateNode> nodes;

    public SectionBlock(TemplateNode.Origin origin, String id, String label, Map<String, String> parameters, Map<String, Expression> expressions, List<TemplateNode> nodes) {
        this.origin = origin;
        this.id = id;
        this.label = label;
        this.parameters = parameters;
        this.expressions = expressions;
        this.nodes = ImmutableList.copyOf(nodes);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    List<Expression> getExpressions() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.addAll(this.expressions.values());
        for (TemplateNode node : this.nodes) {
            expressions.addAll(node.getExpressions());
        }
        return expressions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SectionBlock [origin=").append(this.origin).append(", id=").append(this.id).append(", label=").append(this.label).append("]");
        return builder.toString();
    }

    void optimizeNodes(Set<TemplateNode> nodesToRemove) {
        ArrayList<TemplateNode> effectiveNodes = new ArrayList<TemplateNode>();
        for (TemplateNode node : this.nodes) {
            if (node instanceof SectionNode) {
                effectiveNodes.add(node);
                ((SectionNode)node).optimizeNodes(nodesToRemove);
                continue;
            }
            if (node == Parser.COMMENT_NODE || node instanceof ParameterDeclarationNode || !nodesToRemove.isEmpty() && nodesToRemove.contains(node)) continue;
            effectiveNodes.add(node);
        }
        ArrayList<TemplateNode> finalNodes = new ArrayList<TemplateNode>();
        ArrayList<TextNode> group = null;
        for (TemplateNode node : effectiveNodes) {
            if (node instanceof TextNode) {
                if (group == null) {
                    group = new ArrayList<TextNode>();
                }
                group.add((TextNode)node);
                continue;
            }
            if (group != null) {
                this.collapseGroup(group, finalNodes);
                group = null;
            }
            finalNodes.add(node);
        }
        if (group != null) {
            this.collapseGroup(group, finalNodes);
        }
        this.nodes = ImmutableList.copyOf(finalNodes);
    }

    private void collapseGroup(List<TextNode> group, List<TemplateNode> finalNodes) {
        if (group.size() > 1) {
            StringBuilder val = new StringBuilder();
            for (TextNode textNode : group) {
                val.append(textNode.getValue());
            }
            finalNodes.add(new TextNode(val.toString(), group.get(0).getOrigin()));
        } else {
            finalNodes.add(group.get(0));
        }
    }

    static Builder builder(String id, Function<String, Expression> expressionFunc, Function<String, TemplateException> errorFun) {
        return new Builder(id, expressionFunc, errorFun).setLabel(id);
    }

    static class Builder
    implements SectionHelperFactory.BlockInfo {
        private final String id;
        private TemplateNode.Origin origin;
        private String label;
        private final Map<String, String> parameters;
        private final List<TemplateNode> nodes;
        private final Map<String, Expression> expressions;
        private final Function<String, Expression> expressionFun;
        private final Function<String, TemplateException> errorFun;

        public Builder(String id, Function<String, Expression> expressionFun, Function<String, TemplateException> errorFun) {
            this.id = id;
            this.parameters = new LinkedHashMap<String, String>();
            this.nodes = new ArrayList<TemplateNode>();
            this.expressions = new LinkedHashMap<String, Expression>();
            this.expressionFun = expressionFun;
            this.errorFun = errorFun;
        }

        Builder setOrigin(TemplateNode.Origin origin) {
            this.origin = origin;
            return this;
        }

        Builder addNode(TemplateNode node) {
            this.nodes.add(node);
            return this;
        }

        Builder addNodes(TemplateNode ... nodes) {
            Collections.addAll(this.nodes, nodes);
            return this;
        }

        Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        Builder addParameter(String name, String value) {
            this.parameters.put(name, value);
            return this;
        }

        @Override
        public Expression addExpression(String param, String value) {
            Expression expression = this.expressionFun.apply(value);
            this.expressions.put(param, expression);
            return expression;
        }

        @Override
        public Map<String, String> getParameters() {
            return Collections.unmodifiableMap(this.parameters);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public TemplateException createParserError(String message) {
            return this.errorFun.apply(message);
        }

        SectionBlock build() {
            return new SectionBlock(this.origin, this.id, this.label, this.parameters, this.expressions, this.nodes);
        }
    }
}

