/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class AbstractSubscriber<T>
implements Subscriber<T>,
Subscription {
    private final long upfrontRequest;
    private AtomicReference<Subscription> upstream = new AtomicReference();

    public AbstractSubscriber() {
        this.upfrontRequest = 0L;
    }

    public AbstractSubscriber(long req) {
        this.upfrontRequest = req;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (this.upstream.compareAndSet(null, s)) {
            if (this.upfrontRequest > 0L) {
                s.request(this.upfrontRequest);
            }
        } else {
            throw new IllegalStateException("We already have a subscription");
        }
    }

    @Override
    public void onNext(T t) {
    }

    @Override
    public void onError(Throwable t) {
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void request(long n) {
        Subscription subscription = this.upstream.get();
        if (subscription == null) {
            throw new IllegalStateException("No subscription");
        }
        subscription.request(n);
    }

    @Override
    public void cancel() {
        Subscription subscription = this.upstream.get();
        if (subscription == null) {
            throw new IllegalStateException("No subscription");
        }
        subscription.cancel();
    }
}

