/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.InstanceCreator;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.JsonbRiParser;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.serializer.AbstractContainerDeserializer;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;

public class MapDeserializer<T extends Map<?, ?>>
extends AbstractContainerDeserializer<T>
implements EmbeddedItem {
    private final Type mapValueRuntimeType = this.getRuntimeType() instanceof ParameterizedType ? ReflectionUtils.resolveType(this, ((ParameterizedType)this.getRuntimeType()).getActualTypeArguments()[1]) : Object.class;
    private final T instance;

    protected MapDeserializer(DeserializerBuilder builder) {
        super(builder);
        this.instance = this.createInstance(builder);
    }

    private T createInstance(DeserializerBuilder builder) {
        Map map;
        Class<?> rawType = ReflectionUtils.getRawType(this.getRuntimeType());
        if (rawType.isInterface()) {
            map = this.getMapImpl(rawType, builder);
        } else {
            builder.getJsonbContext().getInstanceCreator();
            map = (Map)InstanceCreator.createInstance(rawType);
        }
        return (T)map;
    }

    private Map getMapImpl(Class ifcType, DeserializerBuilder builder) {
        if (ConcurrentMap.class.isAssignableFrom(ifcType)) {
            if (SortedMap.class.isAssignableFrom(ifcType) || NavigableMap.class.isAssignableFrom(ifcType)) {
                return new ConcurrentSkipListMap();
            }
            return new ConcurrentHashMap();
        }
        if (SortedMap.class.isAssignableFrom(ifcType)) {
            Map map;
            Class<?> defaultMapImplType = builder.getJsonbContext().getConfigProperties().getDefaultMapImplType();
            if (SortedMap.class.isAssignableFrom(defaultMapImplType)) {
                builder.getJsonbContext().getInstanceCreator();
                map = (Map)InstanceCreator.createInstance(defaultMapImplType);
            } else {
                map = new TreeMap();
            }
            return map;
        }
        return new HashMap();
    }

    @Override
    public T getInstance(Unmarshaller unmarshaller) {
        return this.instance;
    }

    @Override
    public void appendResult(Object result) {
        this.appendCaptor(this.getParserContext().getLastKeyName(), this.convertNullToOptionalEmpty(this.mapValueRuntimeType, result));
    }

    private <V> void appendCaptor(String key, V value) {
        this.getInstance(null).put(key, value);
    }

    @Override
    protected void deserializeNext(JsonParser parser, Unmarshaller context) {
        JsonbDeserializer<?> deserializer = this.newCollectionOrMapItem(this.mapValueRuntimeType, context.getJsonbContext());
        this.appendResult(deserializer.deserialize(parser, context, this.mapValueRuntimeType));
    }

    @Override
    protected JsonbRiParser.LevelContext moveToFirst(JsonbParser parser) {
        parser.moveTo(JsonParser.Event.START_OBJECT);
        return parser.getCurrentLevel();
    }
}

