/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.DevModeMediator;
import io.quarkus.bootstrap.runner.SerializedApplication;
import io.quarkus.bootstrap.runner.Timing;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.logmanager.LogManager;

public class QuarkusEntryPoint {
    public static final String QUARKUS_APPLICATION_DAT = "quarkus/quarkus-application.dat";
    public static final String LIB_DEPLOYMENT_DEPLOYMENT_CLASS_PATH_DAT = "lib/deployment/deployment-class-path.dat";

    public static void main(String ... args) throws Throwable {
        System.setProperty("java.util.logging.manager", LogManager.class.getName());
        Timing.staticInitStarted();
        QuarkusEntryPoint.doRun(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRun(Object args) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String path = QuarkusEntryPoint.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedPath = URLDecoder.decode(path, "UTF-8");
        Path appRoot = new File(decodedPath).toPath().getParent().getParent().getParent();
        if (Boolean.parseBoolean(System.getenv("QUARKUS_LAUNCH_DEVMODE"))) {
            DevModeMediator.doDevMode(appRoot);
        } else if (Boolean.getBoolean("quarkus.launch.rebuild")) {
            QuarkusEntryPoint.doReaugment(appRoot);
        } else {
            SerializedApplication app;
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(appRoot.resolve(QUARKUS_APPLICATION_DAT), new OpenOption[0]), 24576);){
                app = SerializedApplication.read(in, appRoot);
            }
            try {
                Thread.currentThread().setContextClassLoader(app.getRunnerClassLoader());
                Class<?> mainClass = app.getRunnerClassLoader().loadClass(app.getMainClass());
                mainClass.getMethod("main", String[].class).invoke(null, args);
            }
            finally {
                app.getRunnerClassLoader().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReaugment(Path appRoot) throws IOException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(appRoot.resolve(LIB_DEPLOYMENT_DEPLOYMENT_CLASS_PATH_DAT), new OpenOption[0]));){
            List paths = (List)in.readObject();
            try (URLClassLoader loader = new URLClassLoader((URL[])paths.stream().map(s -> {
                try {
                    return appRoot.resolve((String)s).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(URL[]::new));){
                loader.loadClass("io.quarkus.deployment.mutability.ReaugmentTask").getDeclaredMethod("main", Path.class).invoke(null, appRoot);
            }
        }
    }
}

