/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineImpl;
import io.quarkus.qute.IfSectionHelper;
import io.quarkus.qute.IncludeSectionHelper;
import io.quarkus.qute.InsertSectionHelper;
import io.quarkus.qute.LoopSectionHelper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.SetSectionHelper;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.WhenSectionHelper;
import io.quarkus.qute.WithSectionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public final class EngineBuilder {
    final Map<String, SectionHelperFactory<?>> sectionHelperFactories = new HashMap();
    final List<ValueResolver> valueResolvers = new ArrayList<ValueResolver>();
    final List<NamespaceResolver> namespaceResolvers = new ArrayList<NamespaceResolver>();
    final List<TemplateLocator> locators = new ArrayList<TemplateLocator>();
    final List<ResultMapper> resultMappers = new ArrayList<ResultMapper>();
    Function<String, SectionHelperFactory<?>> sectionHelperFunc;
    final List<ParserHook> parserHooks = new ArrayList<ParserHook>();
    boolean removeStandaloneLines;

    EngineBuilder() {
    }

    public EngineBuilder addSectionHelper(SectionHelperFactory<?> factory) {
        for (String alias : factory.getDefaultAliases()) {
            this.sectionHelperFactories.put(alias, factory);
        }
        return this;
    }

    public EngineBuilder addSectionHelpers(SectionHelperFactory<?> ... factories) {
        for (SectionHelperFactory<?> factory : factories) {
            this.addSectionHelper(factory);
        }
        return this;
    }

    public EngineBuilder addSectionHelper(String name, SectionHelperFactory<?> factory) {
        this.addSectionHelper(factory);
        this.sectionHelperFactories.put(name, factory);
        return this;
    }

    public EngineBuilder addDefaultSectionHelpers() {
        return this.addSectionHelpers(new IfSectionHelper.Factory(), new LoopSectionHelper.Factory(), new WithSectionHelper.Factory(), new IncludeSectionHelper.Factory(), new InsertSectionHelper.Factory(), new SetSectionHelper.Factory(), new WhenSectionHelper.Factory());
    }

    public EngineBuilder addValueResolver(Supplier<ValueResolver> resolverSupplier) {
        return this.addValueResolver(resolverSupplier.get());
    }

    public EngineBuilder addValueResolvers(ValueResolver ... resolvers) {
        for (ValueResolver valueResolver : resolvers) {
            this.addValueResolver(valueResolver);
        }
        return this;
    }

    public EngineBuilder addValueResolver(ValueResolver resolver) {
        this.valueResolvers.add(resolver);
        return this;
    }

    public EngineBuilder addDefaultValueResolvers() {
        return this.addValueResolvers(ValueResolvers.mapResolver(), ValueResolvers.mapperResolver(), ValueResolvers.mapEntryResolver(), ValueResolvers.collectionResolver(), ValueResolvers.listResolver(), ValueResolvers.thisResolver(), ValueResolvers.orResolver(), ValueResolvers.trueResolver(), ValueResolvers.logicalAndResolver(), ValueResolvers.logicalOrResolver());
    }

    public EngineBuilder addDefaults() {
        return this.addDefaultSectionHelpers().addDefaultValueResolvers();
    }

    public EngineBuilder addNamespaceResolver(NamespaceResolver resolver) {
        for (NamespaceResolver namespaceResolver : this.namespaceResolvers) {
            if (!namespaceResolver.getNamespace().equals(resolver.getNamespace())) continue;
            throw new IllegalArgumentException(String.format("Namespace %s is already handled by %s", resolver.getNamespace(), namespaceResolver));
        }
        this.namespaceResolvers.add(resolver);
        return this;
    }

    public EngineBuilder addLocator(TemplateLocator locator) {
        this.locators.add(locator);
        return this;
    }

    public EngineBuilder addParserHook(ParserHook parserHook) {
        this.parserHooks.add(parserHook);
        return this;
    }

    public EngineBuilder addResultMapper(ResultMapper mapper) {
        this.resultMappers.add(mapper);
        return this;
    }

    public EngineBuilder computeSectionHelper(Function<String, SectionHelperFactory<?>> func) {
        this.sectionHelperFunc = func;
        return this;
    }

    public EngineBuilder removeStandaloneLines(boolean value) {
        this.removeStandaloneLines = value;
        return this;
    }

    public Engine build() {
        return new EngineImpl(this);
    }
}

