/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.net.SocketAddress;

class HttpClientRequestPushPromise
extends HttpClientRequestBase {
    private final Http2ClientConnection conn;
    private final Http2ClientConnection.Http2ClientStream stream;
    private final String rawMethod;
    private final MultiMap headers;
    private Handler<HttpClientResponse> respHandler;

    public HttpClientRequestPushPromise(Http2ClientConnection conn, Http2Stream stream, HttpClientImpl client, boolean ssl, HttpMethod method, String rawMethod, String uri, String host, int port, MultiMap headers) {
        super(client, ssl, method, SocketAddress.inetSocketAddress(port, host), host, port, uri);
        this.conn = conn;
        this.stream = new Http2ClientConnection.Http2ClientStream(conn, this, stream, false);
        this.rawMethod = rawMethod;
        this.headers = headers;
    }

    Http2ClientConnection.Http2ClientStream getStream() {
        return this.stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleResponse(HttpClientResponse resp, long timeoutMs) {
        Handler<HttpClientResponse> handler;
        HttpClientRequestPushPromise httpClientRequestPushPromise = this;
        synchronized (httpClientRequestPushPromise) {
            handler = this.respHandler;
            if (handler == null) {
                return;
            }
        }
        handler.handle(resp);
    }

    @Override
    public synchronized HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        this.respHandler = handler;
        return this;
    }

    @Override
    public HttpConnection connection() {
        return this.conn;
    }

    @Override
    public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
        return this;
    }

    @Override
    boolean reset(Throwable cause) {
        this.stream.reset(cause);
        return true;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String getRawMethod() {
        return this.rawMethod;
    }

    @Override
    public HttpClientRequest setRawMethod(String method) {
        throw new IllegalStateException();
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String getHost() {
        return this.server.host();
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public HttpClientRequest write(Buffer data) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setFollowRedirects(boolean followRedirect) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setMaxRedirects(int maxRedirects) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setChunked(boolean chunked) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest setHost(String host) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(String name, String value) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest write(String chunk) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest write(String chunk, String enc) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest write(Buffer data, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest write(String chunk, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest continueHandler(@Nullable Handler<Void> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest sendHead() {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        throw new IllegalStateException();
    }

    @Override
    public void end(String chunk) {
        throw new IllegalStateException();
    }

    @Override
    public void end(String chunk, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public void end(String chunk, String enc) {
        throw new IllegalStateException();
    }

    @Override
    public void end(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public void end(Buffer chunk) {
        throw new IllegalStateException();
    }

    @Override
    public void end(Buffer chunk, Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        throw new IllegalStateException();
    }

    @Override
    public void end() {
        throw new IllegalStateException();
    }

    @Override
    public void end(Handler<AsyncResult<Void>> handler) {
        throw new IllegalStateException();
    }

    @Override
    public boolean writeQueueFull() {
        throw new IllegalStateException();
    }

    @Override
    public StreamPriority getStreamPriority() {
        return this.stream.priority();
    }

    @Override
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        throw new UnsupportedOperationException("Cannot write frame with HTTP/1.x ");
    }
}

