/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.rbac;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2RBAC;

@VertxGen
public interface MicroProfileRBAC {
    public static OAuth2RBAC create() {
        return (user, authority, handler) -> {
            JsonObject accessToken = user.accessToken();
            if (accessToken == null) {
                handler.handle(Future.failedFuture("AccessToken is not a valid JWT"));
                return;
            }
            JsonArray groups = accessToken.getJsonArray("groups");
            if (groups == null || groups.size() == 0) {
                handler.handle(Future.succeededFuture(false));
                return;
            }
            handler.handle(Future.succeededFuture(groups.contains(authority)));
        };
    }
}

