/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.streams;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

class ReadStreamImpl<T>
implements ReadStream<T> {
    private final io.vertx.core.streams.ReadStream<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private Multi<T> multi;

    @Override
    public io.vertx.core.streams.ReadStream getDelegate() {
        return this.delegate;
    }

    ReadStreamImpl() {
        this.delegate = null;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate, TypeArg<T> typeArg_0) {
        this.delegate = delegate;
        this.__typeArg_0 = typeArg_0;
    }

    @Override
    public synchronized Multi<T> toMulti() {
        if (this.multi == null) {
            Function<Object, Object> conv = this.__typeArg_0.wrap;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<T> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<T> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    private ReadStream<T> __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public ReadStream<T> exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    private ReadStream<T> __handler(final Handler<T> handler) {
        this.delegate.handler(new Handler<T>(){

            @Override
            public void handle(T event) {
                handler.handle(ReadStreamImpl.this.__typeArg_0.wrap(event));
            }
        });
        return this;
    }

    @Override
    public ReadStream<T> handler(Consumer<T> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    @Override
    public ReadStream<T> pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public ReadStream<T> resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public ReadStream<T> fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private ReadStream<T> __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    @Override
    public ReadStream<T> endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    @Override
    public Pipe<T> pipe() {
        Pipe<T> ret = Pipe.newInstance(this.delegate.pipe(), this.__typeArg_0);
        return ret;
    }

    private void __pipeTo(WriteStream<T> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(WriteStream<T> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<T> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    public void pipeToAndForget(WriteStream<T> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }
}

