/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.jsonstructure;

import java.util.Iterator;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

abstract class JsonStructureIterator
implements Iterator<JsonParser.Event> {
    JsonStructureIterator() {
    }

    abstract JsonValue getValue();

    abstract JsonbException createIncompatibleValueError();

    String getString() {
        JsonValue value = this.getValue();
        if (value instanceof JsonString) {
            return ((JsonString)value).getString();
        }
        return value.toString();
    }

    JsonParser.Event getValueEvent(JsonValue value) {
        switch (value.getValueType()) {
            case NUMBER: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case STRING: 
            case TRUE: 
            case FALSE: {
                return JsonParser.Event.VALUE_STRING;
            }
            case OBJECT: {
                return JsonParser.Event.START_OBJECT;
            }
            case ARRAY: {
                return JsonParser.Event.START_ARRAY;
            }
            case NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "unknown json value: " + (Object)((Object)value.getValueType())));
    }
}

