/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.formatters;

import java.io.Serializable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

class StackTraceFormatter {
    private static final String CAUSED_BY_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private final Set<Throwable> seen = Collections.newSetFromMap(new IdentityHashMap());
    private final StringBuilder builder;
    private final int suppressedDepth;
    private int suppressedCount;

    private StackTraceFormatter(StringBuilder builder, int suppressedDepth) {
        this.builder = builder;
        this.suppressedDepth = suppressedDepth;
    }

    static void renderStackTrace(StringBuilder builder, Throwable t, int suppressedDepth) {
        new StackTraceFormatter(builder, suppressedDepth).renderStackTrace(t);
    }

    private void renderStackTrace(Throwable t) {
        Throwable ourCause;
        this.suppressedCount = 0;
        this.builder.append(": ").append(t);
        this.newLine();
        StackTraceElement[] stackTrace = t.getStackTrace();
        for (StackTraceElement stackTraceElement : stackTrace) {
            this.renderTrivial("", stackTraceElement);
        }
        if (this.suppressedDepth != 0) {
            for (Serializable serializable : t.getSuppressed()) {
                if (this.suppressedDepth >= 0 && this.suppressedDepth <= this.suppressedCount++) continue;
                this.renderStackTrace(stackTrace, (Throwable)serializable, SUPPRESSED_CAPTION, "\t");
            }
        }
        if ((ourCause = t.getCause()) != null) {
            this.renderStackTrace(stackTrace, ourCause, CAUSED_BY_CAPTION, "");
        }
    }

    private void renderStackTrace(StackTraceElement[] parentStack, Throwable child, String caption, String prefix) {
        if (this.seen.contains(child)) {
            this.builder.append("\t[CIRCULAR REFERENCE:").append(child).append(']');
            this.newLine();
        } else {
            Throwable ourCause;
            this.seen.add(child);
            StackTraceElement[] causeStack = child.getStackTrace();
            int m = causeStack.length - 1;
            for (int n = parentStack.length - 1; m >= 0 && n >= 0 && causeStack[m].equals(parentStack[n]); --m, --n) {
            }
            int framesInCommon = causeStack.length - 1 - m;
            this.builder.append(prefix).append(caption).append(child);
            this.newLine();
            for (int i = 0; i <= m; ++i) {
                this.renderTrivial(prefix, causeStack[i]);
            }
            if (framesInCommon != 0) {
                this.builder.append(prefix).append("\t... ").append(framesInCommon).append(" more");
                this.newLine();
            }
            if (this.suppressedDepth != 0) {
                for (Throwable se : child.getSuppressed()) {
                    if (this.suppressedDepth >= 0 && this.suppressedDepth <= this.suppressedCount++) continue;
                    this.renderStackTrace(causeStack, se, SUPPRESSED_CAPTION, prefix + "\t");
                }
            }
            if ((ourCause = child.getCause()) != null) {
                this.renderStackTrace(causeStack, ourCause, CAUSED_BY_CAPTION, prefix);
            }
        }
    }

    private void renderTrivial(String prefix, StackTraceElement element) {
        this.builder.append(prefix).append("\tat ").append(element);
        this.newLine();
    }

    private void newLine() {
        this.builder.append(System.lineSeparator());
    }
}

