/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.interception.jaxrs.SuspendableContainerRequestContext;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class PreMatchContainerRequestContext
implements SuspendableContainerRequestContext {
    protected final HttpRequest httpRequest;
    protected Response response;
    private ContainerRequestFilter[] requestFilters;
    private int currentFilter;
    private boolean suspended;
    private boolean filterReturnIsMeaningful = true;
    private Supplier<BuiltResponse> continuation;
    private Map<Class<?>, Object> contextDataMap;
    private boolean inFilter;
    private Throwable throwable;
    private boolean startedContinuation;

    @Deprecated
    public PreMatchContainerRequestContext(HttpRequest request) {
        this(request, new ContainerRequestFilter[0], null);
    }

    public PreMatchContainerRequestContext(HttpRequest request, ContainerRequestFilter[] requestFilters, Supplier<BuiltResponse> continuation) {
        this.httpRequest = request;
        this.requestFilters = requestFilters;
        this.continuation = continuation;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Response getResponseAbortedWith() {
        return this.response;
    }

    @Override
    public Object getProperty(String name) {
        return this.httpRequest.getAttribute(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> enames = this.httpRequest.getAttributeNames();
        while (enames.hasMoreElements()) {
            names.add(enames.nextElement());
        }
        return names;
    }

    @Override
    public void setProperty(String name, Object object) {
        this.httpRequest.setAttribute(name, object);
    }

    @Override
    public void removeProperty(String name) {
        this.httpRequest.removeAttribute(name);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.httpRequest.getUri();
    }

    @Override
    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.httpRequest.setRequestUri(requestUri);
    }

    @Override
    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.httpRequest.setRequestUri(baseUri, requestUri);
    }

    @Override
    public String getMethod() {
        return this.httpRequest.getHttpMethod();
    }

    @Override
    public void setMethod(String method) {
        this.httpRequest.setHttpMethod(method);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return ((ResteasyHttpHeaders)this.httpRequest.getHttpHeaders()).getMutableHeaders();
    }

    @Override
    public Date getDate() {
        return this.httpRequest.getHttpHeaders().getDate();
    }

    @Override
    public Locale getLanguage() {
        return this.httpRequest.getHttpHeaders().getLanguage();
    }

    @Override
    public int getLength() {
        return this.httpRequest.getHttpHeaders().getLength();
    }

    @Override
    public MediaType getMediaType() {
        return this.httpRequest.getHttpHeaders().getMediaType();
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpRequest.getHttpHeaders().getAcceptableMediaTypes();
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        return this.httpRequest.getHttpHeaders().getAcceptableLanguages();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.httpRequest.getHttpHeaders().getCookies();
    }

    @Override
    public boolean hasEntity() {
        return this.getMediaType() != null;
    }

    @Override
    public InputStream getEntityStream() {
        return this.httpRequest.getInputStream();
    }

    @Override
    public void setEntityStream(InputStream entityStream) {
        this.httpRequest.setInputStream(entityStream);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return ResteasyContext.getContextData(SecurityContext.class);
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        ResteasyContext.pushContext(SecurityContext.class, context);
    }

    @Override
    public Request getRequest() {
        return ResteasyContext.getContextData(Request.class);
    }

    @Override
    public String getHeaderString(String name) {
        return this.httpRequest.getHttpHeaders().getHeaderString(name);
    }

    @Override
    public synchronized void suspend() {
        if (this.continuation == null) {
            throw new RuntimeException("Suspend not supported yet");
        }
        this.suspended = true;
    }

    @Override
    public synchronized void abortWith(Response response) {
        if (this.suspended && !this.inFilter) {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                this.httpRequest.getAsyncContext().getAsyncResponse().resume(response);
            }
        } else {
            this.response = response;
            this.suspended = false;
        }
    }

    @Override
    public synchronized void resume() {
        if (!this.suspended) {
            throw new RuntimeException("Cannot resume: not suspended");
        }
        if (this.inFilter) {
            this.suspended = false;
            return;
        }
        try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
            this.filter();
        }
        catch (Throwable t) {
            this.writeException(t);
        }
    }

    @Override
    public synchronized void resume(Throwable t) {
        if (!this.suspended) {
            throw new RuntimeException("Cannot resume: not suspended");
        }
        if (this.inFilter) {
            this.throwable = t;
            this.suspended = false;
        } else {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                this.writeException(t);
            }
        }
    }

    private void writeException(Throwable t) {
        this.httpRequest.getAsyncContext().getAsyncResponse().resume(t);
    }

    public synchronized BuiltResponse filter() {
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(this.httpRequest);
        long totalTimestamp = tracingLogger.timestamp("REQUEST_FILTER_SUMMARY");
        while (this.requestFilters != null && this.currentFilter < this.requestFilters.length) {
            ContainerRequestFilter filter = this.requestFilters[this.currentFilter++];
            try {
                this.suspended = false;
                this.response = null;
                this.throwable = null;
                this.inFilter = true;
                long timestamp = tracingLogger.timestamp("REQUEST_FILTER");
                filter.filter(this);
                tracingLogger.logDuration("REQUEST_FILTER", timestamp, filter);
            }
            catch (IOException e) {
                throw new ApplicationException(e);
            }
            finally {
                this.inFilter = false;
            }
            if (this.suspended) {
                if (!this.httpRequest.getAsyncContext().isSuspended()) {
                    this.httpRequest.getAsyncContext().suspend();
                }
                this.filterReturnIsMeaningful = false;
                this.response = null;
                return null;
            }
            BuiltResponse serverResponse = (BuiltResponse)this.getResponseAbortedWith();
            if (serverResponse != null) {
                if (this.filterReturnIsMeaningful) {
                    return serverResponse;
                }
                this.httpRequest.getAsyncContext().getAsyncResponse().resume(serverResponse);
                return null;
            }
            if (this.throwable == null) continue;
            if (this.filterReturnIsMeaningful) {
                SynchronousDispatcher.rethrow(this.throwable);
                continue;
            }
            this.writeException(this.throwable);
            return null;
        }
        tracingLogger.logDuration("REQUEST_FILTER_SUMMARY", totalTimestamp, this.requestFilters == null ? 0 : this.requestFilters.length);
        this.startedContinuation = true;
        if (this.continuation == null) {
            return null;
        }
        return this.continuation.get();
    }

    public boolean startedContinuation() {
        return this.startedContinuation;
    }
}

