/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.health.HealthLogging;
import io.smallrye.health.HealthMessages;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

@ApplicationScoped
public class AsyncHealthCheckFactory {
    private static final String ROOT_CAUSE = "rootCause";
    private static final String STACK_TRACE = "stackTrace";
    @Inject
    @ConfigProperty(name="io.smallrye.health.uncheckedExceptionDataStyle", defaultValue="rootCause")
    String uncheckedExceptionDataStyle;

    public Uni<HealthCheckResponse> callAsync(AsyncHealthCheck asyncHealthCheck) {
        return this.withRecovery(asyncHealthCheck.getClass().getName(), Uni.createFrom().deferred(asyncHealthCheck::call));
    }

    public Uni<HealthCheckResponse> callSync(HealthCheck healthCheck) {
        return this.withRecovery(healthCheck.getClass().getName(), Uni.createFrom().item(healthCheck::call));
    }

    private Uni<HealthCheckResponse> withRecovery(String name, Uni<HealthCheckResponse> uni) {
        return uni.onFailure().recoverWithItem(e -> this.handleFailure(name, (Throwable)e)).onItem().ifNull().continueWith(() -> this.handleFailure(name, HealthMessages.msg.healthCheckNull()));
    }

    private HealthCheckResponse handleFailure(String name, Throwable e) {
        HealthLogging.log.healthCheckError(e);
        HealthCheckResponseBuilder response = HealthCheckResponse.named(name).down();
        if (null != this.uncheckedExceptionDataStyle) {
            switch (this.uncheckedExceptionDataStyle) {
                case "rootCause": {
                    response.withData(ROOT_CAUSE, AsyncHealthCheckFactory.getRootCause(e).getMessage());
                    break;
                }
                case "stackTrace": {
                    response.withData(STACK_TRACE, AsyncHealthCheckFactory.getStackTrace(e));
                    break;
                }
            }
        }
        return response.build();
    }

    private static String getStackTrace(Throwable t) {
        StringWriter string = new StringWriter();
        try (PrintWriter pw = new PrintWriter(string);){
            t.printStackTrace(pw);
        }
        return string.toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t.getCause();
        if (cause == null || cause == t) {
            return t;
        }
        return AsyncHealthCheckFactory.getRootCause(cause);
    }

    public void setUncheckedExceptionDataStyle(String uncheckedExceptionDataStyle) {
        this.uncheckedExceptionDataStyle = uncheckedExceptionDataStyle;
    }
}

