/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiBroadcast;
import io.smallrye.mutiny.groups.MultiCollect;
import io.smallrye.mutiny.groups.MultiConvert;
import io.smallrye.mutiny.groups.MultiGroup;
import io.smallrye.mutiny.groups.MultiOnCancel;
import io.smallrye.mutiny.groups.MultiOnCompletion;
import io.smallrye.mutiny.groups.MultiOnEvent;
import io.smallrye.mutiny.groups.MultiOnFailure;
import io.smallrye.mutiny.groups.MultiOnItem;
import io.smallrye.mutiny.groups.MultiOnRequest;
import io.smallrye.mutiny.groups.MultiOnSubscribe;
import io.smallrye.mutiny.groups.MultiOnTerminate;
import io.smallrye.mutiny.groups.MultiOverflow;
import io.smallrye.mutiny.groups.MultiSelect;
import io.smallrye.mutiny.groups.MultiSkip;
import io.smallrye.mutiny.groups.MultiSubscribe;
import io.smallrye.mutiny.groups.MultiTransform;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.StrictMultiSubscriber;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.multi.MultiCacheOp;
import io.smallrye.mutiny.operators.multi.MultiEmitOnOp;
import io.smallrye.mutiny.operators.multi.MultiSubscribeOnOp;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;

public abstract class AbstractMulti<T>
implements Multi<T> {
    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.subscribe(Infrastructure.onMultiSubscription(this, subscriber));
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber is `null`");
        StrictMultiSubscriber<? super T> actual = subscriber instanceof MultiSubscriber ? (StrictMultiSubscriber<? super T>)subscriber : new StrictMultiSubscriber<T>(subscriber);
        this.subscribe((MultiSubscriber<? super T>)actual);
    }

    @Override
    public MultiOnItem<T> onItem() {
        return new MultiOnItem(this);
    }

    @Override
    public MultiSubscribe<T> subscribe() {
        return new MultiSubscribe(this);
    }

    @Override
    public Uni<T> toUni() {
        return Uni.createFrom().publisher(this);
    }

    @Override
    public MultiOnFailure<T> onFailure() {
        return new MultiOnFailure(this, null);
    }

    @Override
    public MultiOnFailure<T> onFailure(Predicate<? super Throwable> predicate) {
        return new MultiOnFailure(this, predicate);
    }

    @Override
    public MultiOnFailure<T> onFailure(Class<? extends Throwable> typeOfFailure) {
        return new MultiOnFailure(this, typeOfFailure::isInstance);
    }

    @Override
    public MultiOnEvent<T> on() {
        return new MultiOnEvent(this);
    }

    @Override
    public Multi<T> cache() {
        return Infrastructure.onMultiCreation(new MultiCacheOp(this));
    }

    @Override
    public Multi<T> emitOn(Executor executor) {
        return Infrastructure.onMultiCreation(new MultiEmitOnOp(this, ParameterValidation.nonNull(executor, "executor")));
    }

    @Override
    public Multi<T> runSubscriptionOn(Executor executor) {
        return Infrastructure.onMultiCreation(new MultiSubscribeOnOp(this, executor));
    }

    @Override
    public MultiOnCompletion<T> onCompletion() {
        return new MultiOnCompletion(this);
    }

    @Override
    public MultiTransform<T> transform() {
        return new MultiTransform(this);
    }

    @Override
    public MultiSelect<T> select() {
        return new MultiSelect(this);
    }

    @Override
    public MultiSkip<T> skip() {
        return new MultiSkip(this);
    }

    @Override
    public MultiOverflow<T> onOverflow() {
        return new MultiOverflow(this);
    }

    @Override
    public MultiOnSubscribe<T> onSubscribe() {
        return new MultiOnSubscribe(this);
    }

    @Override
    public MultiBroadcast<T> broadcast() {
        return new MultiBroadcast(this);
    }

    @Override
    public MultiConvert<T> convert() {
        return new MultiConvert(this);
    }

    @Override
    public MultiOnTerminate<T> onTermination() {
        return new MultiOnTerminate(this);
    }

    @Override
    public MultiOnCancel<T> onCancellation() {
        return new MultiOnCancel(this);
    }

    @Override
    public MultiOnRequest<T> onRequest() {
        return new MultiOnRequest(this);
    }

    @Override
    public MultiCollect<T> collect() {
        return new MultiCollect(this);
    }

    @Override
    public MultiGroup<T> group() {
        return new MultiGroup(this);
    }

    @Override
    public Multi<T> toHotStream() {
        BroadcastProcessor processor = BroadcastProcessor.create();
        this.subscribe(processor);
        return processor;
    }
}

