/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.jsonstructure;

import java.util.Iterator;
import javax.json.JsonArray;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.stream.JsonParser;
import org.eclipse.yasson.internal.jsonstructure.JsonStructureIterator;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonArrayIterator
extends JsonStructureIterator {
    private final Iterator<JsonValue> valueIterator;
    private JsonValue currentValue;

    public JsonArrayIterator(JsonArray jsonArray) {
        this.valueIterator = jsonArray.iterator();
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public JsonParser.Event next() {
        if (this.valueIterator.hasNext()) {
            this.currentValue = this.valueIterator.next();
            return this.getValueEvent(this.currentValue);
        }
        return JsonParser.Event.END_ARRAY;
    }

    @Override
    JsonValue getValue() {
        return this.currentValue;
    }

    @Override
    JsonbException createIncompatibleValueError() {
        return new JsonbException(Messages.getMessage(MessageKeys.NUMBER_INCOMPATIBLE_VALUE_TYPE_ARRAY, new Object[]{this.getValue().getValueType()}));
    }

    @Override
    String getString() {
        if (this.currentValue instanceof JsonString) {
            return ((JsonString)this.currentValue).getString();
        }
        return this.currentValue.toString();
    }
}

