/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.json.bind.Jsonb;
import javax.ws.rs.Consumes;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.input.ProxyInputStream;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.providers.jsonb.AbstractJsonBindingProvider;
import org.jboss.resteasy.plugins.providers.jsonb.i18n.Messages;
import org.jboss.resteasy.spi.AsyncMessageBodyWriter;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.util.DelegatingOutputStream;

@Provider
@Produces(value={"application/json", "application/*+json", "text/json"})
@Consumes(value={"application/json", "application/*+json", "text/json"})
@Priority(value=4900)
public class JsonBindingProvider
extends AbstractJsonBindingProvider
implements MessageBodyReader<Object>,
AsyncMessageBodyWriter<Object> {
    private final boolean disabled;

    public JsonBindingProvider() {
        ResteasyConfiguration context = ResteasyContext.getContextData(ResteasyConfiguration.class);
        this.disabled = context == null ? Boolean.getBoolean("resteasy.preferJacksonOverJsonB") : Boolean.parseBoolean(context.getParameter("resteasy.preferJacksonOverJsonB")) || Boolean.parseBoolean(context.getParameter("resteasy.jsonp.enable"));
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.disabled) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType);
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        EmptyCheckInputStream is = new EmptyCheckInputStream(entityStream);
        try {
            return jsonb.fromJson((InputStream)is, genericType);
        }
        catch (Throwable e) {
            if (is.isEmpty()) {
                return null;
            }
            throw new ProcessingException(Messages.MESSAGES.jsonBDeserializationError(e.toString()), e);
        }
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.disabled) {
            return false;
        }
        return JsonBindingProvider.isSupportedMediaType(mediaType);
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Jsonb jsonb = this.getJsonb(type);
        try {
            entityStream = new DelegatingOutputStream(entityStream){

                @Override
                public void flush() throws IOException {
                }
            };
            entityStream.write(jsonb.toJson(t).getBytes(JsonBindingProvider.getCharset(mediaType)));
            entityStream.flush();
        }
        catch (Throwable e) {
            throw new ProcessingException(Messages.MESSAGES.jsonBSerializationError(e.toString()), e);
        }
    }

    @Override
    public CompletionStage<Void> asyncWriteTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, AsyncOutputStream entityStream) {
        Jsonb jsonb = this.getJsonb(type);
        try {
            return entityStream.asyncWrite(jsonb.toJson(t).getBytes(JsonBindingProvider.getCharset(mediaType)));
        }
        catch (Throwable e) {
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new ProcessingException(Messages.MESSAGES.jsonBSerializationError(e.toString()), e));
            return ret;
        }
    }

    private class EmptyCheckInputStream
    extends ProxyInputStream {
        boolean read;
        boolean empty;

        EmptyCheckInputStream(InputStream proxy) {
            super(proxy);
            this.read = false;
            this.empty = false;
        }

        @Override
        protected synchronized void afterRead(int n) throws IOException {
            if (!this.read && n <= 0) {
                this.empty = true;
            }
            this.read = true;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

