/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 99005:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   E2: () => (/* binding */ parser),
/* harmony export */   KZ: () => (/* binding */ getApolloContext),
/* harmony export */   ZV: () => (/* binding */ resetApolloContext),
/* harmony export */   ab: () => (/* binding */ ApolloConsumer),
/* harmony export */   eT: () => (/* binding */ ApolloProvider),
/* harmony export */   mw: () => (/* binding */ operationName),
/* harmony export */   n_: () => (/* binding */ DocumentType)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29901);
/* harmony import */ var ts_invariant__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7323);



var apolloContext;
function getApolloContext() {
    if (!apolloContext) {
        apolloContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({});
    }
    return apolloContext;
}
function resetApolloContext() {
    apolloContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({});
}

var ApolloProvider = function (_a) {
    var client = _a.client, children = _a.children;
    var ApolloContext = getApolloContext();
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ApolloContext.Consumer, null, function (context) {
        if (context === void 0) { context = {}; }
        if (client && context.client !== client) {
            context = Object.assign({}, context, { client: client });
        }
         true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_1__/* .invariant */ .kG)(context.client, 5) : 0;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(ApolloContext.Provider, { value: context }, children));
    });
};

var ApolloConsumer = function (props) {
    var ApolloContext = getApolloContext();
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(ApolloContext.Consumer, null, function (context) {
         true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_1__/* .invariant */ .kG)(context && context.client, 6) : 0;
        return props.children(context.client);
    });
};

var DocumentType;
(function (DocumentType) {
    DocumentType[DocumentType["Query"] = 0] = "Query";
    DocumentType[DocumentType["Mutation"] = 1] = "Mutation";
    DocumentType[DocumentType["Subscription"] = 2] = "Subscription";
})(DocumentType || (DocumentType = {}));
var cache = new Map();
function operationName(type) {
    var name;
    switch (type) {
        case DocumentType.Query:
            name = 'Query';
            break;
        case DocumentType.Mutation:
            name = 'Mutation';
            break;
        case DocumentType.Subscription:
            name = 'Subscription';
            break;
    }
    return name;
}
function parser(document) {
    var cached = cache.get(document);
    if (cached)
        return cached;
    var variables, type, name;
     true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_1__/* .invariant */ .kG)(!!document && !!document.kind, 1) : 0;
    var fragments = document.definitions.filter(function (x) { return x.kind === 'FragmentDefinition'; });
    var queries = document.definitions.filter(function (x) {
        return x.kind === 'OperationDefinition' && x.operation === 'query';
    });
    var mutations = document.definitions.filter(function (x) {
        return x.kind === 'OperationDefinition' && x.operation === 'mutation';
    });
    var subscriptions = document.definitions.filter(function (x) {
        return x.kind === 'OperationDefinition' && x.operation === 'subscription';
    });
     true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_1__/* .invariant */ .kG)(!fragments.length ||
        (queries.length || mutations.length || subscriptions.length), 2) : 0;
     true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_1__/* .invariant */ .kG)(queries.length + mutations.length + subscriptions.length <= 1, 3) : 0;
    type = queries.length ? DocumentType.Query : DocumentType.Mutation;
    if (!queries.length && !mutations.length)
        type = DocumentType.Subscription;
    var definitions = queries.length
        ? queries
        : mutations.length
            ? mutations
            : subscriptions;
     true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_1__/* .invariant */ .kG)(definitions.length === 1, 4) : 0;
    var definition = definitions[0];
    variables = definition.variableDefinitions || [];
    if (definition.name && definition.name.kind === 'Name') {
        name = definition.name.value;
    }
    else {
        name = 'data';
    }
    var payload = { name: name, type: type, variables: variables };
    cache.set(document, payload);
    return payload;
}


//# sourceMappingURL=react-common.esm.js.map


/***/ }),

/***/ 31738:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ApolloConsumer: () => (/* reexport safe */ _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__.ab),
/* harmony export */   ApolloProvider: () => (/* reexport safe */ _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__.eT),
/* harmony export */   RenderPromises: () => (/* binding */ RenderPromises),
/* harmony export */   getApolloContext: () => (/* reexport safe */ _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__.KZ),
/* harmony export */   resetApolloContext: () => (/* reexport safe */ _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__.ZV),
/* harmony export */   useApolloClient: () => (/* binding */ useApolloClient),
/* harmony export */   useLazyQuery: () => (/* binding */ useLazyQuery),
/* harmony export */   useMutation: () => (/* binding */ useMutation),
/* harmony export */   useQuery: () => (/* binding */ useQuery),
/* harmony export */   useSubscription: () => (/* binding */ useSubscription)
/* harmony export */ });
/* harmony import */ var _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99005);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33569);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29901);
/* harmony import */ var apollo_client__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3276);
/* harmony import */ var _wry_equality__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31917);
/* harmony import */ var ts_invariant__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7323);








var OperationData = (function () {
    function OperationData(options, context) {
        this.isMounted = false;
        this.previousOptions = {};
        this.context = {};
        this.options = {};
        this.options = options || {};
        this.context = context || {};
    }
    OperationData.prototype.getOptions = function () {
        return this.options;
    };
    OperationData.prototype.setOptions = function (newOptions, storePrevious) {
        if (storePrevious === void 0) { storePrevious = false; }
        if (storePrevious && !(0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(this.options, newOptions)) {
            this.previousOptions = this.options;
        }
        this.options = newOptions;
    };
    OperationData.prototype.unmount = function () {
        this.isMounted = false;
    };
    OperationData.prototype.refreshClient = function () {
        var client = (this.options && this.options.client) ||
            (this.context && this.context.client);
         true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_3__/* .invariant */ .kG)(!!client, 2) : 0;
        var isNew = false;
        if (client !== this.client) {
            isNew = true;
            this.client = client;
            this.cleanup();
        }
        return {
            client: this.client,
            isNew: isNew
        };
    };
    OperationData.prototype.verifyDocumentType = function (document, type) {
        var operation = (0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .parser */ .E2)(document);
        var requiredOperationName = (0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .operationName */ .mw)(type);
        var usedOperationName = (0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .operationName */ .mw)(operation.type);
         true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_3__/* .invariant */ .kG)(operation.type === type, 3) : 0;
    };
    return OperationData;
}());

var QueryData = (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(QueryData, _super);
    function QueryData(_a) {
        var options = _a.options, context = _a.context, onNewData = _a.onNewData;
        var _this = _super.call(this, options, context) || this;
        _this.previousData = {};
        _this.currentObservable = {};
        _this.runLazy = false;
        _this.runLazyQuery = function (options) {
            _this.cleanup();
            _this.runLazy = true;
            _this.lazyOptions = options;
            _this.onNewData();
        };
        _this.getExecuteResult = function () {
            var result = _this.getQueryResult();
            _this.startQuerySubscription();
            return result;
        };
        _this.obsRefetch = function (variables) {
            return _this.currentObservable.query.refetch(variables);
        };
        _this.obsFetchMore = function (fetchMoreOptions) { return _this.currentObservable.query.fetchMore(fetchMoreOptions); };
        _this.obsUpdateQuery = function (mapFn) { return _this.currentObservable.query.updateQuery(mapFn); };
        _this.obsStartPolling = function (pollInterval) {
            _this.currentObservable &&
                _this.currentObservable.query &&
                _this.currentObservable.query.startPolling(pollInterval);
        };
        _this.obsStopPolling = function () {
            _this.currentObservable &&
                _this.currentObservable.query &&
                _this.currentObservable.query.stopPolling();
        };
        _this.obsSubscribeToMore = function (options) { return _this.currentObservable.query.subscribeToMore(options); };
        _this.onNewData = onNewData;
        return _this;
    }
    QueryData.prototype.execute = function () {
        this.refreshClient();
        var _a = this.getOptions(), skip = _a.skip, query = _a.query;
        if (skip || query !== this.previousData.query) {
            this.removeQuerySubscription();
            this.previousData.query = query;
        }
        this.updateObservableQuery();
        if (this.isMounted)
            this.startQuerySubscription();
        return this.getExecuteSsrResult() || this.getExecuteResult();
    };
    QueryData.prototype.executeLazy = function () {
        return !this.runLazy
            ? [
                this.runLazyQuery,
                {
                    loading: false,
                    networkStatus: apollo_client__WEBPACK_IMPORTED_MODULE_5__.NetworkStatus.ready,
                    called: false,
                    data: undefined,
                },
            ]
            : [this.runLazyQuery, this.execute()];
    };
    QueryData.prototype.fetchData = function () {
        var options = this.getOptions();
        if (options.skip || options.ssr === false)
            return false;
        var obs = this.currentObservable.query;
        var currentResult = obs.getCurrentResult();
        return currentResult.loading ? obs.result() : false;
    };
    QueryData.prototype.afterExecute = function (_a) {
        var _b = (_a === void 0 ? {} : _a).lazy, lazy = _b === void 0 ? false : _b;
        this.isMounted = true;
        if (!lazy || this.runLazy) {
            this.handleErrorOrCompleted();
        }
        this.previousOptions = this.getOptions();
        return this.unmount.bind(this);
    };
    QueryData.prototype.cleanup = function () {
        this.removeQuerySubscription();
        delete this.currentObservable.query;
        delete this.previousData.result;
    };
    QueryData.prototype.getOptions = function () {
        var options = _super.prototype.getOptions.call(this);
        if (this.lazyOptions) {
            options.variables = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, options.variables), this.lazyOptions.variables);
            options.context = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, options.context), this.lazyOptions.context);
        }
        if (this.runLazy) {
            delete options.skip;
        }
        return options;
    };
    QueryData.prototype.ssrInitiated = function () {
        return this.context && this.context.renderPromises;
    };
    QueryData.prototype.getExecuteSsrResult = function () {
        var ssrDisabled = this.getOptions().ssr === false;
        var fetchDisabled = this.refreshClient().client.disableNetworkFetches;
        var ssrLoading = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({ loading: true, networkStatus: apollo_client__WEBPACK_IMPORTED_MODULE_5__.NetworkStatus.loading, called: true, data: undefined, stale: false, client: this.client }, this.observableQueryFields());
        if (ssrDisabled && (this.ssrInitiated() || fetchDisabled)) {
            this.previousData.result = ssrLoading;
            return ssrLoading;
        }
        var result;
        if (this.ssrInitiated()) {
            result =
                this.context.renderPromises.addQueryPromise(this, this.getExecuteResult) || ssrLoading;
        }
        return result;
    };
    QueryData.prototype.prepareObservableQueryOptions = function () {
        var options = this.getOptions();
        this.verifyDocumentType(options.query, _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .DocumentType */ .n_.Query);
        var displayName = options.displayName || 'Query';
        if (this.ssrInitiated() &&
            (options.fetchPolicy === 'network-only' ||
                options.fetchPolicy === 'cache-and-network')) {
            options.fetchPolicy = 'cache-first';
        }
        return (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, options), { displayName: displayName, context: options.context, metadata: { reactComponent: { displayName: displayName } } });
    };
    QueryData.prototype.initializeObservableQuery = function () {
        var _a, _b;
        if (this.ssrInitiated()) {
            this.currentObservable.query = this.context.renderPromises.getSSRObservable(this.getOptions());
        }
        if (!this.currentObservable.query) {
            var observableQueryOptions = this.prepareObservableQueryOptions();
            this.previousData.observableQueryOptions = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, observableQueryOptions), { children: null });
            this.currentObservable.query = this.refreshClient().client.watchQuery((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, observableQueryOptions));
            if (this.ssrInitiated()) {
                (_b = (_a = this.context) === null || _a === void 0 ? void 0 : _a.renderPromises) === null || _b === void 0 ? void 0 : _b.registerSSRObservable(this.currentObservable.query, observableQueryOptions);
            }
        }
    };
    QueryData.prototype.updateObservableQuery = function () {
        if (!this.currentObservable.query) {
            this.initializeObservableQuery();
            return;
        }
        var newObservableQueryOptions = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, this.prepareObservableQueryOptions()), { children: null });
        if (!(0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(newObservableQueryOptions, this.previousData.observableQueryOptions)) {
            this.previousData.observableQueryOptions = newObservableQueryOptions;
            this.currentObservable
                .query.setOptions(newObservableQueryOptions)
                .catch(function () { });
        }
    };
    QueryData.prototype.startQuerySubscription = function () {
        var _this = this;
        if (this.currentObservable.subscription || this.getOptions().skip)
            return;
        var obsQuery = this.currentObservable.query;
        this.currentObservable.subscription = obsQuery.subscribe({
            next: function (_a) {
                var loading = _a.loading, networkStatus = _a.networkStatus, data = _a.data;
                var previousResult = _this.previousData.result;
                if (previousResult &&
                    previousResult.loading === loading &&
                    previousResult.networkStatus === networkStatus &&
                    (0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(previousResult.data, data)) {
                    return;
                }
                _this.onNewData();
            },
            error: function (error) {
                _this.resubscribeToQuery();
                if (!error.hasOwnProperty('graphQLErrors'))
                    throw error;
                var previousResult = _this.previousData.result;
                if ((previousResult && previousResult.loading) ||
                    !(0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(error, _this.previousData.error)) {
                    _this.previousData.error = error;
                    _this.onNewData();
                }
            },
        });
    };
    QueryData.prototype.resubscribeToQuery = function () {
        this.removeQuerySubscription();
        var lastError = this.currentObservable.query.getLastError();
        var lastResult = this.currentObservable.query.getLastResult();
        this.currentObservable.query.resetLastResults();
        this.startQuerySubscription();
        Object.assign(this.currentObservable.query, {
            lastError: lastError,
            lastResult: lastResult,
        });
    };
    QueryData.prototype.getQueryResult = function () {
        var result = this.observableQueryFields();
        var options = this.getOptions();
        if (options.skip) {
            result = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, result), { data: undefined, error: undefined, loading: false, called: true });
        }
        else {
            var currentResult = this.currentObservable.query.getCurrentResult();
            var loading = currentResult.loading, partial = currentResult.partial, networkStatus = currentResult.networkStatus, errors = currentResult.errors;
            var error = currentResult.error, data = currentResult.data;
            if (errors && errors.length > 0) {
                error = new apollo_client__WEBPACK_IMPORTED_MODULE_5__.ApolloError({ graphQLErrors: errors });
            }
            result = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, result), { loading: loading,
                networkStatus: networkStatus,
                error: error, called: true });
            if (loading) {
                var previousData = this.previousData.result && this.previousData.result.data;
                result.data =
                    previousData && data
                        ? (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, previousData), data) : previousData || data;
            }
            else if (error) {
                Object.assign(result, {
                    data: (this.currentObservable.query.getLastResult() || {})
                        .data,
                });
            }
            else {
                var fetchPolicy = this.currentObservable.query.options.fetchPolicy;
                var partialRefetch = options.partialRefetch;
                if (partialRefetch &&
                    !data &&
                    partial &&
                    fetchPolicy !== 'cache-only') {
                    Object.assign(result, {
                        loading: true,
                        networkStatus: apollo_client__WEBPACK_IMPORTED_MODULE_5__.NetworkStatus.loading,
                    });
                    result.refetch();
                    return result;
                }
                result.data = data;
            }
        }
        result.client = this.client;
        this.previousData.loading =
            (this.previousData.result && this.previousData.result.loading) || false;
        this.previousData.result = result;
        this.currentObservable.query &&
            this.currentObservable.query.resetQueryStoreErrors();
        return result;
    };
    QueryData.prototype.handleErrorOrCompleted = function () {
        var obsQuery = this.currentObservable.query;
        if (!obsQuery || !this.previousData.result)
            return;
        var _a = this.previousData.result, data = _a.data, loading = _a.loading, error = _a.error;
        if (!loading) {
            var _b = this.getOptions(), query = _b.query, variables = _b.variables, onCompleted = _b.onCompleted, onError = _b.onError;
            if (this.previousOptions &&
                !this.previousData.loading &&
                (0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(this.previousOptions.query, query) &&
                (0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(this.previousOptions.variables, variables)) {
                return;
            }
            if (onCompleted && !error) {
                onCompleted(data);
            }
            else if (onError && error) {
                onError(error);
            }
        }
    };
    QueryData.prototype.removeQuerySubscription = function () {
        if (this.currentObservable.subscription) {
            this.currentObservable.subscription.unsubscribe();
            delete this.currentObservable.subscription;
        }
    };
    QueryData.prototype.observableQueryFields = function () {
        var observable = this.currentObservable.query;
        return {
            variables: observable.variables,
            refetch: this.obsRefetch,
            fetchMore: this.obsFetchMore,
            updateQuery: this.obsUpdateQuery,
            startPolling: this.obsStartPolling,
            stopPolling: this.obsStopPolling,
            subscribeToMore: this.obsSubscribeToMore,
        };
    };
    return QueryData;
}(OperationData));

function useDeepMemo(memoFn, key) {
    var ref = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    if (!ref.current || !(0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(key, ref.current.key)) {
        ref.current = { key: key, value: memoFn() };
    }
    return ref.current.value;
}

function useBaseQuery(query, options, lazy) {
    if (lazy === void 0) { lazy = false; }
    var context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)((0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .getApolloContext */ .KZ)());
    var _a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useReducer)(function (x) { return x + 1; }, 0), tick = _a[0], forceUpdate = _a[1];
    var updatedOptions = options ? (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, options), { query: query }) : { query: query };
    var queryDataRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    var queryData = queryDataRef.current ||
        new QueryData({
            options: updatedOptions,
            context: context,
            onNewData: function () {
                if (!queryData.ssrInitiated()) {
                    Promise.resolve().then(forceUpdate);
                }
                else {
                    forceUpdate();
                }
            },
        });
    queryData.setOptions(updatedOptions);
    queryData.context = context;
    if (queryData.ssrInitiated() && !queryDataRef.current) {
        queryDataRef.current = queryData;
    }
    var memo = {
        options: (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, updatedOptions), { onError: undefined, onCompleted: undefined }),
        context: context,
        tick: tick,
    };
    var result = useDeepMemo(function () { return (lazy ? queryData.executeLazy() : queryData.execute()); }, memo);
    var queryResult = lazy
        ? result[1]
        : result;
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () {
        if (!queryDataRef.current) {
            queryDataRef.current = queryData;
        }
        return function () { return queryData.cleanup(); };
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () { return queryData.afterExecute({ lazy: lazy }); }, [
        queryResult.loading,
        queryResult.networkStatus,
        queryResult.error,
        queryResult.data,
    ]);
    return result;
}

function useQuery(query, options) {
    return useBaseQuery(query, options, false);
}

function useLazyQuery(query, options) {
    return useBaseQuery(query, options, true);
}

var MutationData = (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(MutationData, _super);
    function MutationData(_a) {
        var options = _a.options, context = _a.context, result = _a.result, setResult = _a.setResult;
        var _this = _super.call(this, options, context) || this;
        _this.runMutation = function (mutationFunctionOptions) {
            if (mutationFunctionOptions === void 0) { mutationFunctionOptions = {}; }
            _this.onMutationStart();
            var mutationId = _this.generateNewMutationId();
            return _this.mutate(mutationFunctionOptions)
                .then(function (response) {
                _this.onMutationCompleted(response, mutationId);
                return response;
            })
                .catch(function (error) {
                _this.onMutationError(error, mutationId);
                if (!_this.getOptions().onError)
                    throw error;
            });
        };
        _this.verifyDocumentType(options.mutation, _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .DocumentType */ .n_.Mutation);
        _this.result = result;
        _this.setResult = setResult;
        _this.mostRecentMutationId = 0;
        return _this;
    }
    MutationData.prototype.execute = function (result) {
        this.isMounted = true;
        this.verifyDocumentType(this.getOptions().mutation, _apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .DocumentType */ .n_.Mutation);
        result.client = this.refreshClient().client;
        return [this.runMutation, result];
    };
    MutationData.prototype.afterExecute = function () {
        this.isMounted = true;
        return this.unmount.bind(this);
    };
    MutationData.prototype.cleanup = function () {
    };
    MutationData.prototype.mutate = function (mutationFunctionOptions) {
        var _a = this.getOptions(), mutation = _a.mutation, variables = _a.variables, optimisticResponse = _a.optimisticResponse, update = _a.update, _b = _a.context, mutationContext = _b === void 0 ? {} : _b, _c = _a.awaitRefetchQueries, awaitRefetchQueries = _c === void 0 ? false : _c, fetchPolicy = _a.fetchPolicy;
        var mutateOptions = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, mutationFunctionOptions);
        var mutateVariables = Object.assign({}, variables, mutateOptions.variables);
        delete mutateOptions.variables;
        return this.refreshClient().client.mutate((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({ mutation: mutation,
            optimisticResponse: optimisticResponse, refetchQueries: mutateOptions.refetchQueries || this.getOptions().refetchQueries, awaitRefetchQueries: awaitRefetchQueries,
            update: update, context: mutationContext, fetchPolicy: fetchPolicy, variables: mutateVariables }, mutateOptions));
    };
    MutationData.prototype.onMutationStart = function () {
        if (!this.result.loading && !this.getOptions().ignoreResults) {
            this.updateResult({
                loading: true,
                error: undefined,
                data: undefined,
                called: true
            });
        }
    };
    MutationData.prototype.onMutationCompleted = function (response, mutationId) {
        var _a = this.getOptions(), onCompleted = _a.onCompleted, ignoreResults = _a.ignoreResults;
        var data = response.data, errors = response.errors;
        var error = errors && errors.length > 0
            ? new apollo_client__WEBPACK_IMPORTED_MODULE_5__.ApolloError({ graphQLErrors: errors })
            : undefined;
        var callOncomplete = function () {
            return onCompleted ? onCompleted(data) : null;
        };
        if (this.isMostRecentMutation(mutationId) && !ignoreResults) {
            this.updateResult({
                called: true,
                loading: false,
                data: data,
                error: error
            });
        }
        callOncomplete();
    };
    MutationData.prototype.onMutationError = function (error, mutationId) {
        var onError = this.getOptions().onError;
        if (this.isMostRecentMutation(mutationId)) {
            this.updateResult({
                loading: false,
                error: error,
                data: undefined,
                called: true
            });
        }
        if (onError) {
            onError(error);
        }
    };
    MutationData.prototype.generateNewMutationId = function () {
        return ++this.mostRecentMutationId;
    };
    MutationData.prototype.isMostRecentMutation = function (mutationId) {
        return this.mostRecentMutationId === mutationId;
    };
    MutationData.prototype.updateResult = function (result) {
        if (this.isMounted &&
            (!this.previousResult || !(0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(this.previousResult, result))) {
            this.setResult(result);
            this.previousResult = result;
        }
    };
    return MutationData;
}(OperationData));

function useMutation(mutation, options) {
    var context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)((0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .getApolloContext */ .KZ)());
    var _a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({ called: false, loading: false }), result = _a[0], setResult = _a[1];
    var updatedOptions = options ? (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, options), { mutation: mutation }) : { mutation: mutation };
    var mutationDataRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    function getMutationDataRef() {
        if (!mutationDataRef.current) {
            mutationDataRef.current = new MutationData({
                options: updatedOptions,
                context: context,
                result: result,
                setResult: setResult
            });
        }
        return mutationDataRef.current;
    }
    var mutationData = getMutationDataRef();
    mutationData.setOptions(updatedOptions);
    mutationData.context = context;
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () { return mutationData.afterExecute(); });
    return mutationData.execute(result);
}

var SubscriptionData = (function (_super) {
    (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__extends)(SubscriptionData, _super);
    function SubscriptionData(_a) {
        var options = _a.options, context = _a.context, setResult = _a.setResult;
        var _this = _super.call(this, options, context) || this;
        _this.currentObservable = {};
        _this.setResult = setResult;
        _this.initialize(options);
        return _this;
    }
    SubscriptionData.prototype.execute = function (result) {
        if (this.getOptions().skip === true) {
            this.cleanup();
            return {
                loading: false,
                error: undefined,
                data: undefined,
                variables: this.getOptions().variables
            };
        }
        var currentResult = result;
        if (this.refreshClient().isNew) {
            currentResult = this.getLoadingResult();
        }
        var shouldResubscribe = this.getOptions().shouldResubscribe;
        if (typeof shouldResubscribe === 'function') {
            shouldResubscribe = !!shouldResubscribe(this.getOptions());
        }
        if (shouldResubscribe !== false &&
            this.previousOptions &&
            Object.keys(this.previousOptions).length > 0 &&
            (this.previousOptions.subscription !== this.getOptions().subscription ||
                !(0,_wry_equality__WEBPACK_IMPORTED_MODULE_2__/* .equal */ .D)(this.previousOptions.variables, this.getOptions().variables) ||
                this.previousOptions.skip !== this.getOptions().skip)) {
            this.cleanup();
            currentResult = this.getLoadingResult();
        }
        this.initialize(this.getOptions());
        this.startSubscription();
        this.previousOptions = this.getOptions();
        return (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, currentResult), { variables: this.getOptions().variables });
    };
    SubscriptionData.prototype.afterExecute = function () {
        this.isMounted = true;
    };
    SubscriptionData.prototype.cleanup = function () {
        this.endSubscription();
        delete this.currentObservable.query;
    };
    SubscriptionData.prototype.initialize = function (options) {
        if (this.currentObservable.query || this.getOptions().skip === true)
            return;
        this.currentObservable.query = this.refreshClient().client.subscribe({
            query: options.subscription,
            variables: options.variables,
            fetchPolicy: options.fetchPolicy
        });
    };
    SubscriptionData.prototype.startSubscription = function () {
        if (this.currentObservable.subscription)
            return;
        this.currentObservable.subscription = this.currentObservable.query.subscribe({
            next: this.updateCurrentData.bind(this),
            error: this.updateError.bind(this),
            complete: this.completeSubscription.bind(this)
        });
    };
    SubscriptionData.prototype.getLoadingResult = function () {
        return {
            loading: true,
            error: undefined,
            data: undefined
        };
    };
    SubscriptionData.prototype.updateResult = function (result) {
        if (this.isMounted) {
            this.setResult(result);
        }
    };
    SubscriptionData.prototype.updateCurrentData = function (result) {
        var onSubscriptionData = this.getOptions().onSubscriptionData;
        this.updateResult({
            data: result.data,
            loading: false,
            error: undefined
        });
        if (onSubscriptionData) {
            onSubscriptionData({
                client: this.refreshClient().client,
                subscriptionData: result
            });
        }
    };
    SubscriptionData.prototype.updateError = function (error) {
        this.updateResult({
            error: error,
            loading: false
        });
    };
    SubscriptionData.prototype.completeSubscription = function () {
        var onSubscriptionComplete = this.getOptions().onSubscriptionComplete;
        if (onSubscriptionComplete)
            onSubscriptionComplete();
        this.endSubscription();
    };
    SubscriptionData.prototype.endSubscription = function () {
        if (this.currentObservable.subscription) {
            this.currentObservable.subscription.unsubscribe();
            delete this.currentObservable.subscription;
        }
    };
    return SubscriptionData;
}(OperationData));

function useSubscription(subscription, options) {
    var context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)((0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .getApolloContext */ .KZ)());
    var updatedOptions = options
        ? (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)((0,tslib__WEBPACK_IMPORTED_MODULE_4__.__assign)({}, options), { subscription: subscription }) : { subscription: subscription };
    var _a = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({
        loading: !updatedOptions.skip,
        error: undefined,
        data: undefined
    }), result = _a[0], setResult = _a[1];
    var subscriptionDataRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    function getSubscriptionDataRef() {
        if (!subscriptionDataRef.current) {
            subscriptionDataRef.current = new SubscriptionData({
                options: updatedOptions,
                context: context,
                setResult: setResult
            });
        }
        return subscriptionDataRef.current;
    }
    var subscriptionData = getSubscriptionDataRef();
    subscriptionData.setOptions(updatedOptions, true);
    subscriptionData.context = context;
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () { return subscriptionData.afterExecute(); });
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(function () { return subscriptionData.cleanup.bind(subscriptionData); }, []);
    return subscriptionData.execute(result);
}

function useApolloClient() {
    var client = react__WEBPACK_IMPORTED_MODULE_1__.useContext((0,_apollo_react_common__WEBPACK_IMPORTED_MODULE_0__/* .getApolloContext */ .KZ)()).client;
     true ? (0,ts_invariant__WEBPACK_IMPORTED_MODULE_3__/* .invariant */ .kG)(client, 1) : 0;
    return client;
}

function makeDefaultQueryInfo() {
    return {
        seen: false,
        observable: null
    };
}
var RenderPromises = (function () {
    function RenderPromises() {
        this.queryPromises = new Map();
        this.queryInfoTrie = new Map();
    }
    RenderPromises.prototype.registerSSRObservable = function (observable, props) {
        this.lookupQueryInfo(props).observable = observable;
    };
    RenderPromises.prototype.getSSRObservable = function (props) {
        return this.lookupQueryInfo(props).observable;
    };
    RenderPromises.prototype.addQueryPromise = function (queryInstance, finish) {
        var info = this.lookupQueryInfo(queryInstance.getOptions());
        if (!info.seen) {
            this.queryPromises.set(queryInstance.getOptions(), new Promise(function (resolve) {
                resolve(queryInstance.fetchData());
            }));
            return null;
        }
        return finish();
    };
    RenderPromises.prototype.hasPromises = function () {
        return this.queryPromises.size > 0;
    };
    RenderPromises.prototype.consumeAndAwaitPromises = function () {
        var _this = this;
        var promises = [];
        this.queryPromises.forEach(function (promise, queryInstance) {
            _this.lookupQueryInfo(queryInstance).seen = true;
            promises.push(promise);
        });
        this.queryPromises.clear();
        return Promise.all(promises);
    };
    RenderPromises.prototype.lookupQueryInfo = function (props) {
        var queryInfoTrie = this.queryInfoTrie;
        var query = props.query, variables = props.variables;
        var varMap = queryInfoTrie.get(query) || new Map();
        if (!queryInfoTrie.has(query))
            queryInfoTrie.set(query, varMap);
        var variablesString = JSON.stringify(variables);
        var info = varMap.get(variablesString) || makeDefaultQueryInfo();
        if (!varMap.has(variablesString))
            varMap.set(variablesString, info);
        return info;
    };
    return RenderPromises;
}());


//# sourceMappingURL=react-hooks.esm.js.map


/***/ }),

/***/ 26455:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NoOpSwfServiceCatalogChannelApiImpl = void 0;
var NoOpSwfServiceCatalogChannelApiImpl = (function () {
    function NoOpSwfServiceCatalogChannelApiImpl() {
    }
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_services = function () {
        return {
            defaultValue: [],
        };
    };
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_serviceRegistriesSettings = function () {
        return {
            defaultValue: {
                registries: [],
            },
        };
    };
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_refresh = function () { };
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_importFunctionFromCompletionItem = function (args) { };
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_importEventFromCompletionItem = function (args) { };
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_logInServiceRegistries = function () { };
    NoOpSwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_setupServiceRegistriesSettings = function () { };
    return NoOpSwfServiceCatalogChannelApiImpl;
}());
exports.NoOpSwfServiceCatalogChannelApiImpl = NoOpSwfServiceCatalogChannelApiImpl;
//# sourceMappingURL=NoOpSwfServiceCatalogChannelApiImpl.js.map

/***/ }),

/***/ 78273:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NoOpSwfStaticEnvelopeContentProviderChannelApiImpl = void 0;
var NoOpSwfStaticEnvelopeContentProviderChannelApiImpl = (function () {
    function NoOpSwfStaticEnvelopeContentProviderChannelApiImpl() {
    }
    NoOpSwfStaticEnvelopeContentProviderChannelApiImpl.prototype.kogitoSwfGetDiagramEditorEnvelopeContent = function () {
        return { defaultValue: "" };
    };
    NoOpSwfStaticEnvelopeContentProviderChannelApiImpl.prototype.kogitoSwfGetMermaidEnvelopeContent = function () {
        return { defaultValue: "" };
    };
    NoOpSwfStaticEnvelopeContentProviderChannelApiImpl.prototype.kogitoSwfGetTextEditorEnvelopeContent = function () {
        return { defaultValue: "" };
    };
    return NoOpSwfStaticEnvelopeContentProviderChannelApiImpl;
}());
exports.NoOpSwfStaticEnvelopeContentProviderChannelApiImpl = NoOpSwfStaticEnvelopeContentProviderChannelApiImpl;
//# sourceMappingURL=NoOpSwfStaticEnvelopeContentProviderChannelApiImpl.js.map

/***/ }),

/***/ 24040:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ServerlessWorkflowCombinedEditorEnvelopeApiImpl = void 0;
var envelope_1 = __webpack_require__(68778);
var ServerlessWorkflowCombinedEditorEnvelopeApiImpl = (function (_super) {
    __extends(ServerlessWorkflowCombinedEditorEnvelopeApiImpl, _super);
    function ServerlessWorkflowCombinedEditorEnvelopeApiImpl(serverlessWorkflowArgs, editorFactory) {
        var _this = _super.call(this, serverlessWorkflowArgs, editorFactory) || this;
        _this.serverlessWorkflowArgs = serverlessWorkflowArgs;
        return _this;
    }
    ServerlessWorkflowCombinedEditorEnvelopeApiImpl.prototype.kogitoSwfCombinedEditor_colorNodes = function (args) {
        this.getEditorOrThrowError().colorNodes(args.nodeNames, args.color, args.colorConnectedEnds);
    };
    return ServerlessWorkflowCombinedEditorEnvelopeApiImpl;
}(envelope_1.KogitoEditorEnvelopeApiImpl));
exports.ServerlessWorkflowCombinedEditorEnvelopeApiImpl = ServerlessWorkflowCombinedEditorEnvelopeApiImpl;
//# sourceMappingURL=ServerlessWorkflowCombinedEditorEnvelopeApiImpl.js.map

/***/ }),

/***/ 61544:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwfCombinedEditorChannelApiImpl = void 0;
var SwfCombinedEditorChannelApiImpl = (function () {
    function SwfCombinedEditorChannelApiImpl(defaultApiImpl, swfFeatureToggleApiImpl, swfServiceCatalogApiImpl, swfLanguageServiceChannelApiImpl, swfPreviewOptionsChannelApiImpl, swfStaticEnvelopeContentProviderChannelApi) {
        this.defaultApiImpl = defaultApiImpl;
        this.swfFeatureToggleApiImpl = swfFeatureToggleApiImpl;
        this.swfServiceCatalogApiImpl = swfServiceCatalogApiImpl;
        this.swfLanguageServiceChannelApiImpl = swfLanguageServiceChannelApiImpl;
        this.swfPreviewOptionsChannelApiImpl = swfPreviewOptionsChannelApiImpl;
        this.swfStaticEnvelopeContentProviderChannelApi = swfStaticEnvelopeContentProviderChannelApi;
    }
    SwfCombinedEditorChannelApiImpl.prototype.kogitoEditor_contentRequest = function () {
        return this.defaultApiImpl.kogitoEditor_contentRequest();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoEditor_ready = function () {
        this.defaultApiImpl.kogitoEditor_ready();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoEditor_setContentError = function (content) {
        this.defaultApiImpl.kogitoEditor_setContentError(content);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoEditor_stateControlCommandUpdate = function (command) {
        this.defaultApiImpl.kogitoEditor_stateControlCommandUpdate(command);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoI18n_getLocale = function () {
        return this.defaultApiImpl.kogitoI18n_getLocale();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoNotifications_createNotification = function (notification) {
        this.defaultApiImpl.kogitoNotifications_createNotification(notification);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoNotifications_removeNotifications = function (path) {
        this.defaultApiImpl.kogitoNotifications_removeNotifications(path);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoNotifications_setNotifications = function (path, notifications) {
        this.defaultApiImpl.kogitoNotifications_setNotifications(path, notifications);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoWorkspace_newEdit = function (edit) {
        this.defaultApiImpl.kogitoWorkspace_newEdit(edit);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoWorkspace_openFile = function (path) {
        this.defaultApiImpl.kogitoWorkspace_openFile(path);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoWorkspace_resourceContentRequest = function (request) {
        return this.defaultApiImpl.kogitoWorkspace_resourceContentRequest(request);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoWorkspace_resourceListRequest = function (request) {
        return this.defaultApiImpl.kogitoWorkspace_resourceListRequest(request);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoEditor_theme = function () {
        return this.defaultApiImpl.kogitoEditor_theme();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfServiceCatalog_services = function () {
        var _a, _b;
        return (_b = (_a = this.swfServiceCatalogApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfServiceCatalog_services()) !== null && _b !== void 0 ? _b : { defaultValue: [] };
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfServiceCatalog_refresh = function () {
        var _a;
        (_a = this.swfServiceCatalogApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfServiceCatalog_refresh();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfServiceCatalog_importFunctionFromCompletionItem = function (args) {
        var _a;
        (_a = this.swfServiceCatalogApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfServiceCatalog_importFunctionFromCompletionItem(args);
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfLanguageService__getCompletionItems = function (args) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_c) {
                return [2, (_b = (_a = this.swfLanguageServiceChannelApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfLanguageService__getCompletionItems(args)) !== null && _b !== void 0 ? _b : []];
            });
        });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfLanguageService__getCodeLenses = function (args) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_c) {
                return [2, (_b = (_a = this.swfLanguageServiceChannelApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfLanguageService__getCodeLenses(args)) !== null && _b !== void 0 ? _b : []];
            });
        });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfServiceCatalog_serviceRegistriesSettings = function () {
        var _a, _b;
        return ((_b = (_a = this.swfServiceCatalogApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfServiceCatalog_serviceRegistriesSettings()) !== null && _b !== void 0 ? _b : {
            defaultValue: { registries: [] },
        });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfServiceCatalog_logInServiceRegistries = function () {
        var _a;
        (_a = this.swfServiceCatalogApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfServiceCatalog_logInServiceRegistries();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfServiceCatalog_setupServiceRegistriesSettings = function () {
        var _a;
        (_a = this.swfServiceCatalogApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfServiceCatalog_setupServiceRegistriesSettings();
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfFeatureToggle_get = function () {
        var _a, _b;
        return ((_b = (_a = this.swfFeatureToggleApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfFeatureToggle_get()) !== null && _b !== void 0 ? _b : {
            defaultValue: { stunnerEnabled: true },
        });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfPreviewOptions_get = function () {
        var _a, _b;
        return ((_b = (_a = this.swfPreviewOptionsChannelApiImpl) === null || _a === void 0 ? void 0 : _a.kogitoSwfPreviewOptions_get()) !== null && _b !== void 0 ? _b : {
            defaultValue: { defaultWidth: "50%", editorMode: "full" },
        });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfGetDiagramEditorEnvelopeContent = function () {
        var _a, _b;
        return ((_b = (_a = this.swfStaticEnvelopeContentProviderChannelApi) === null || _a === void 0 ? void 0 : _a.kogitoSwfGetDiagramEditorEnvelopeContent()) !== null && _b !== void 0 ? _b : {
            defaultValue: "",
        });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfGetMermaidEnvelopeContent = function () {
        var _a, _b;
        return ((_b = (_a = this.swfStaticEnvelopeContentProviderChannelApi) === null || _a === void 0 ? void 0 : _a.kogitoSwfGetMermaidEnvelopeContent()) !== null && _b !== void 0 ? _b : { defaultValue: "" });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfGetTextEditorEnvelopeContent = function () {
        var _a, _b;
        return ((_b = (_a = this.swfStaticEnvelopeContentProviderChannelApi) === null || _a === void 0 ? void 0 : _a.kogitoSwfGetTextEditorEnvelopeContent()) !== null && _b !== void 0 ? _b : { defaultValue: "" });
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfCombinedEditor_moveCursorToPosition = function (_position) {
    };
    SwfCombinedEditorChannelApiImpl.prototype.kogitoSwfCombinedEditor_combinedEditorReady = function () {
    };
    return SwfCombinedEditorChannelApiImpl;
}());
exports.SwfCombinedEditorChannelApiImpl = SwfCombinedEditorChannelApiImpl;
//# sourceMappingURL=SwfCombinedEditorChannelApiImpl.js.map

/***/ }),

/***/ 11266:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwfFeatureToggleChannelApiImpl = void 0;
var SwfFeatureToggleChannelApiImpl = (function () {
    function SwfFeatureToggleChannelApiImpl(featureToggle) {
        this.featureToggle = featureToggle;
    }
    SwfFeatureToggleChannelApiImpl.prototype.kogitoSwfFeatureToggle_get = function () {
        var _a;
        return {
            defaultValue: (_a = this.featureToggle) !== null && _a !== void 0 ? _a : { stunnerEnabled: true },
        };
    };
    return SwfFeatureToggleChannelApiImpl;
}());
exports.SwfFeatureToggleChannelApiImpl = SwfFeatureToggleChannelApiImpl;
//# sourceMappingURL=SwfFeatureToggleChannelApiImpl.js.map

/***/ }),

/***/ 71649:
/***/ (function(__unused_webpack_module, exports) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwfLanguageServiceChannelApiImpl = void 0;
var SwfLanguageServiceChannelApiImpl = (function () {
    function SwfLanguageServiceChannelApiImpl(channelApi) {
        this.channelApi = channelApi;
    }
    SwfLanguageServiceChannelApiImpl.prototype.kogitoSwfLanguageService__getCompletionItems = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.channelApi.requests.kogitoSwfLanguageService__getCompletionItems(args)];
            });
        });
    };
    SwfLanguageServiceChannelApiImpl.prototype.kogitoSwfLanguageService__getCodeLenses = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2, this.channelApi.requests.kogitoSwfLanguageService__getCodeLenses(args)];
            });
        });
    };
    return SwfLanguageServiceChannelApiImpl;
}());
exports.SwfLanguageServiceChannelApiImpl = SwfLanguageServiceChannelApiImpl;
//# sourceMappingURL=SwfLanguageServiceChannelApiImpl.js.map

/***/ }),

/***/ 90071:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwfPreviewOptionsChannelApiImpl = void 0;
var SwfPreviewOptionsChannelApiImpl = (function () {
    function SwfPreviewOptionsChannelApiImpl(swfPreviewOptions) {
        this.swfPreviewOptions = swfPreviewOptions;
    }
    SwfPreviewOptionsChannelApiImpl.prototype.kogitoSwfPreviewOptions_get = function () {
        var _a;
        return {
            defaultValue: (_a = this.swfPreviewOptions) !== null && _a !== void 0 ? _a : { defaultWidth: "50%", editorMode: "full" },
        };
    };
    return SwfPreviewOptionsChannelApiImpl;
}());
exports.SwfPreviewOptionsChannelApiImpl = SwfPreviewOptionsChannelApiImpl;
//# sourceMappingURL=SwfPreviewOptionsChannelApiImpl.js.map

/***/ }),

/***/ 14855:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwfServiceCatalogChannelApiImpl = void 0;
var SwfServiceCatalogChannelApiImpl = (function () {
    function SwfServiceCatalogChannelApiImpl(channelApi, services, serviceRegistriesSettings) {
        this.channelApi = channelApi;
        this.services = services;
        this.serviceRegistriesSettings = serviceRegistriesSettings;
    }
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_services = function () {
        return {
            defaultValue: this.services,
        };
    };
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_serviceRegistriesSettings = function () {
        return {
            defaultValue: this.serviceRegistriesSettings,
        };
    };
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_refresh = function () {
        this.channelApi.notifications.kogitoSwfServiceCatalog_refresh.send();
    };
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_importFunctionFromCompletionItem = function (args) {
        this.channelApi.notifications.kogitoSwfServiceCatalog_importFunctionFromCompletionItem.send(args);
    };
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_importEventFromCompletionItem = function (args) {
        this.channelApi.notifications.kogitoSwfServiceCatalog_importEventFromCompletionItem.send(args);
    };
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_logInServiceRegistries = function () {
        this.channelApi.notifications.kogitoSwfServiceCatalog_logInServiceRegistries.send();
    };
    SwfServiceCatalogChannelApiImpl.prototype.kogitoSwfServiceCatalog_setupServiceRegistriesSettings = function () {
        this.channelApi.notifications.kogitoSwfServiceCatalog_setupServiceRegistriesSettings.send();
    };
    return SwfServiceCatalogChannelApiImpl;
}());
exports.SwfServiceCatalogChannelApiImpl = SwfServiceCatalogChannelApiImpl;
//# sourceMappingURL=SwfServiceCatalogChannelApiImpl.js.map

/***/ }),

/***/ 5114:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SwfStaticEnvelopeContentProviderChannelApiImpl = void 0;
var SwfStaticEnvelopeContentProviderChannelApiImpl = (function () {
    function SwfStaticEnvelopeContentProviderChannelApiImpl(args) {
        this.args = args;
    }
    SwfStaticEnvelopeContentProviderChannelApiImpl.prototype.kogitoSwfGetDiagramEditorEnvelopeContent = function () {
        return { defaultValue: this.args.diagramEditorEnvelopeContent };
    };
    SwfStaticEnvelopeContentProviderChannelApiImpl.prototype.kogitoSwfGetMermaidEnvelopeContent = function () {
        return { defaultValue: this.args.mermaidEnvelopeContent };
    };
    SwfStaticEnvelopeContentProviderChannelApiImpl.prototype.kogitoSwfGetTextEditorEnvelopeContent = function () {
        return { defaultValue: this.args.textEditorEnvelopeContent };
    };
    return SwfStaticEnvelopeContentProviderChannelApiImpl;
}());
exports.SwfStaticEnvelopeContentProviderChannelApiImpl = SwfStaticEnvelopeContentProviderChannelApiImpl;
//# sourceMappingURL=SwfStaticEnvelopeContentProviderChannelApiImpl.js.map

/***/ }),

/***/ 7521:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(61544), exports);
__exportStar(__webpack_require__(11266), exports);
__exportStar(__webpack_require__(71649), exports);
__exportStar(__webpack_require__(14855), exports);
__exportStar(__webpack_require__(90071), exports);
__exportStar(__webpack_require__(78273), exports);
__exportStar(__webpack_require__(5114), exports);
__exportStar(__webpack_require__(26455), exports);
__exportStar(__webpack_require__(24040), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 85594:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=Editor.js.map

/***/ }),

/***/ 81627:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=EditorContent.js.map

/***/ }),

/***/ 50011:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditorEnvelopeLocator = exports.EnvelopeMapping = exports.EnvelopeContentType = void 0;
var minimatch_1 = __webpack_require__(90239);
var EnvelopeContentType;
(function (EnvelopeContentType) {
    EnvelopeContentType[EnvelopeContentType["PATH"] = 0] = "PATH";
    EnvelopeContentType[EnvelopeContentType["CONTENT"] = 1] = "CONTENT";
})(EnvelopeContentType = exports.EnvelopeContentType || (exports.EnvelopeContentType = {}));
var EnvelopeMapping = (function () {
    function EnvelopeMapping(args) {
        this.args = args;
        this.matcher = new minimatch_1.Minimatch(args.filePathGlob, { nocase: true, dot: true });
    }
    Object.defineProperty(EnvelopeMapping.prototype, "type", {
        get: function () {
            return this.args.type;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeMapping.prototype, "filePathGlob", {
        get: function () {
            return this.args.filePathGlob;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeMapping.prototype, "resourcesPathPrefix", {
        get: function () {
            return this.args.resourcesPathPrefix;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeMapping.prototype, "envelopeContent", {
        get: function () {
            return this.args.envelopeContent;
        },
        enumerable: false,
        configurable: true
    });
    return EnvelopeMapping;
}());
exports.EnvelopeMapping = EnvelopeMapping;
var EditorEnvelopeLocator = (function () {
    function EditorEnvelopeLocator(targetOrigin, envelopeMappings) {
        this.targetOrigin = targetOrigin;
        this.envelopeMappings = envelopeMappings;
    }
    EditorEnvelopeLocator.prototype.getEnvelopeMapping = function (path) {
        return this.envelopeMappings.find(function (mapping) {
            return mapping.matcher.match(path);
        });
    };
    EditorEnvelopeLocator.prototype.hasMappingFor = function (path) {
        return this.getEnvelopeMapping(path) !== undefined;
    };
    return EditorEnvelopeLocator;
}());
exports.EditorEnvelopeLocator = EditorEnvelopeLocator;
//# sourceMappingURL=EditorEnvelopeLocator.js.map

/***/ }),

/***/ 84444:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=EditorFactory.js.map

/***/ }),

/***/ 35022:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditorTheme = void 0;
var EditorTheme;
(function (EditorTheme) {
    EditorTheme[EditorTheme["DARK"] = 0] = "DARK";
    EditorTheme[EditorTheme["LIGHT"] = 1] = "LIGHT";
    EditorTheme[EditorTheme["HIGH_CONTRAST"] = 2] = "HIGH_CONTRAST";
})(EditorTheme = exports.EditorTheme || (exports.EditorTheme = {}));
//# sourceMappingURL=EditorTheme.js.map

/***/ }),

/***/ 99435:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=KogitoEditorChannelApi.js.map

/***/ }),

/***/ 77947:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChannelType = void 0;
var ChannelType;
(function (ChannelType) {
    ChannelType["VSCODE_DESKTOP"] = "VSCODE_DESKTOP";
    ChannelType["VSCODE_WEB"] = "VSCODE_WEB";
    ChannelType["ONLINE"] = "ONLINE";
    ChannelType["GITHUB"] = "GITHUB";
    ChannelType["EMBEDDED"] = "EMBEDDED";
    ChannelType["OTHER"] = "OTHER";
    ChannelType["ONLINE_MULTI_FILE"] = "ONLINE_MULTI_FILE";
    ChannelType["STANDALONE"] = "STANDALONE";
})(ChannelType = exports.ChannelType || (exports.ChannelType = {}));
//# sourceMappingURL=KogitoEditorEnvelopeApi.js.map

/***/ }),

/***/ 40083:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useKogitoEditorEnvelopeContext = exports.KogitoEditorEnvelopeContext = void 0;
var React = __webpack_require__(29901);
var react_1 = __webpack_require__(29901);
exports.KogitoEditorEnvelopeContext = React.createContext({});
function useKogitoEditorEnvelopeContext() {
    return (0, react_1.useContext)(exports.KogitoEditorEnvelopeContext);
}
exports.useKogitoEditorEnvelopeContext = useKogitoEditorEnvelopeContext;
//# sourceMappingURL=KogitoEditorEnvelopeContext.js.map

/***/ }),

/***/ 52846:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateControlCommand = void 0;
var StateControlCommand;
(function (StateControlCommand) {
    StateControlCommand[StateControlCommand["UNDO"] = 0] = "UNDO";
    StateControlCommand[StateControlCommand["REDO"] = 1] = "REDO";
})(StateControlCommand = exports.StateControlCommand || (exports.StateControlCommand = {}));
//# sourceMappingURL=StateControlCommand.js.map

/***/ }),

/***/ 47602:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(85594), exports);
__exportStar(__webpack_require__(84444), exports);
__exportStar(__webpack_require__(40083), exports);
__exportStar(__webpack_require__(99435), exports);
__exportStar(__webpack_require__(77947), exports);
__exportStar(__webpack_require__(52846), exports);
__exportStar(__webpack_require__(81627), exports);
__exportStar(__webpack_require__(50011), exports);
__exportStar(__webpack_require__(35022), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 51079:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateControl = void 0;
var StateControl = (function () {
    function StateControl() {
        this.commandStack = [];
        this.registeredCallbacks = [];
    }
    StateControl.prototype.subscribe = function (callback) {
        this.registeredCallbacks.push(callback);
        return callback;
    };
    StateControl.prototype.unsubscribe = function (callback) {
        var index = this.registeredCallbacks.indexOf(callback);
        if (index > -1) {
            this.registeredCallbacks.splice(index, 1);
        }
        else {
            console.error("Can't unsubscribe callback because it wasn't subscribed.");
        }
    };
    StateControl.prototype.getSavedCommand = function () {
        return this.savedCommand;
    };
    StateControl.prototype.getCurrentCommand = function () {
        return this.currentCommand;
    };
    StateControl.prototype.getCommandStack = function () {
        return this.commandStack;
    };
    StateControl.prototype.getRegisteredCallbacks = function () {
        return this.registeredCallbacks;
    };
    StateControl.prototype.setSavedCommand = function () {
        this.savedCommand = this.currentCommand;
        var isDirty = this.isDirty();
        this.registeredCallbacks.forEach(function (callback) { return callback(isDirty); });
    };
    StateControl.prototype.setCurrentCommand = function (command) {
        this.currentCommand = command;
        var isDirty = this.isDirty();
        this.registeredCallbacks.forEach(function (callback) { return callback(isDirty); });
    };
    StateControl.prototype.isDirty = function () {
        return this.currentCommand !== this.savedCommand;
    };
    StateControl.prototype.undo = function () {
        var _a, _b;
        var indexOfCommandToUndo = this.commandStack.indexOf(this.currentCommand);
        var nextCurrentCommandAfterUndo;
        if (this.commandStack[indexOfCommandToUndo - 1]) {
            nextCurrentCommandAfterUndo = this.commandStack[indexOfCommandToUndo - 1];
        }
        (_b = (_a = this.currentCommand) === null || _a === void 0 ? void 0 : _a.undo) === null || _b === void 0 ? void 0 : _b.call(_a);
        this.setCurrentCommand(nextCurrentCommandAfterUndo);
    };
    StateControl.prototype.redo = function () {
        var _a;
        var indexOfCurrentCommand = this.commandStack.indexOf(this.currentCommand);
        if (this.commandStack[indexOfCurrentCommand + 1]) {
            var commandRedone = this.commandStack[indexOfCurrentCommand + 1];
            (_a = commandRedone === null || commandRedone === void 0 ? void 0 : commandRedone.redo) === null || _a === void 0 ? void 0 : _a.call(commandRedone);
            this.setCurrentCommand(commandRedone);
        }
    };
    StateControl.prototype.eraseRedoCommands = function () {
        return this.commandStack.slice(0, this.commandStack.indexOf(this.currentCommand) + 1);
    };
    StateControl.prototype.updateCommandStack = function (command) {
        var _a;
        this.commandStack = this.eraseRedoCommands();
        if (command.id !== ((_a = this.currentCommand) === null || _a === void 0 ? void 0 : _a.id)) {
            this.setCurrentCommand(command);
            this.commandStack = this.commandStack.concat(command);
        }
    };
    return StateControl;
}());
exports.StateControl = StateControl;
//# sourceMappingURL=StateControl.js.map

/***/ }),

/***/ 564:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEditorIframeProps = void 0;
var api_1 = __webpack_require__(47602);
function getEditorIframeProps(envelopeMapping) {
    if (envelopeMapping.envelopeContent.type === api_1.EnvelopeContentType.CONTENT) {
        return {
            srcDoc: envelopeMapping.envelopeContent.content,
        };
    }
    return {
        key: envelopeMapping.envelopeContent.path,
        src: envelopeMapping.envelopeContent.path,
    };
}
exports.getEditorIframeProps = getEditorIframeProps;
//# sourceMappingURL=editorIframeProps.js.map

/***/ }),

/***/ 91247:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.StateControl = void 0;
var StateControl_1 = __webpack_require__(51079);
Object.defineProperty(exports, "StateControl", ({ enumerable: true, get: function () { return StateControl_1.StateControl; } }));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 62046:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useEffectAfterFirstRender = void 0;
var react_1 = __webpack_require__(29901);
function useEffectAfterFirstRender(func, deps) {
    var firstRender = (0, react_1.useRef)(true);
    (0, react_1.useEffect)(function () {
        if (!firstRender.current) {
            func();
        }
        else {
            firstRender.current = false;
        }
    }, deps);
}
exports.useEffectAfterFirstRender = useEffectAfterFirstRender;
//# sourceMappingURL=customEffects.js.map

/***/ }),

/***/ 44419:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(62046), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 25504:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmbeddedEditor = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var React = __webpack_require__(29901);
var react_1 = __webpack_require__(29901);
var channel_1 = __webpack_require__(91247);
var common_1 = __webpack_require__(44419);
var EmbeddedEditorChannelApiImpl_1 = __webpack_require__(23620);
var channel_2 = __webpack_require__(17059);
var hooks_1 = __webpack_require__(59282);
var editorIframeProps_1 = __webpack_require__(564);
var containerStyles = {
    display: "flex",
    flex: 1,
    flexDirection: "column",
    width: "100%",
    height: "100%",
    border: "none",
    margin: 0,
    padding: 0,
    overflow: "hidden",
};
var RefForwardingEmbeddedEditor = function (props, forwardedRef) {
    var iframeRef = (0, react_1.useRef)(null);
    var stateControl = (0, react_1.useMemo)(function () { var _a; return (_a = props.stateControl) !== null && _a !== void 0 ? _a : new channel_1.StateControl(); }, [props.file.getFileContents, props.stateControl]);
    var _a = __read((0, react_1.useState)(false), 2), isReady = _a[0], setReady = _a[1];
    var envelopeMapping = (0, react_1.useMemo)(function () { var _a; return props.editorEnvelopeLocator.getEnvelopeMapping((_a = props.file.path) !== null && _a !== void 0 ? _a : props.file.fileName); }, [props.editorEnvelopeLocator, props.file]);
    var channelApiImpl = (0, react_1.useMemo)(function () {
        var _a;
        return ((_a = props.customChannelApiImpl) !== null && _a !== void 0 ? _a : new EmbeddedEditorChannelApiImpl_1.EmbeddedEditorChannelApiImpl(stateControl, props.file, props.locale, __assign(__assign({}, props), { kogitoEditor_ready: function () {
                var _a;
                setReady(true);
                (_a = props.kogitoEditor_ready) === null || _a === void 0 ? void 0 : _a.call(props);
            } })));
    }, [stateControl, props]);
    var envelopeServer = (0, react_1.useMemo)(function () {
        return new channel_2.EnvelopeServer({ postMessage: function (message) { var _a, _b; return (_b = (_a = iframeRef.current) === null || _a === void 0 ? void 0 : _a.contentWindow) === null || _b === void 0 ? void 0 : _b.postMessage(message, "*"); } }, props.editorEnvelopeLocator.targetOrigin, function (self) {
            var _a;
            return self.envelopeApi.requests.kogitoEditor_initRequest({ origin: self.origin, envelopeServerId: self.id }, {
                fileExtension: props.file.fileExtension,
                resourcesPathPrefix: (_a = envelopeMapping === null || envelopeMapping === void 0 ? void 0 : envelopeMapping.resourcesPathPrefix) !== null && _a !== void 0 ? _a : "",
                initialLocale: props.locale,
                isReadOnly: props.file.isReadOnly,
                channel: props.channelType,
            });
        });
    }, [
        props.editorEnvelopeLocator.targetOrigin,
        props.file.fileExtension,
        props.file.isReadOnly,
        props.locale,
        props.channelType,
        envelopeMapping === null || envelopeMapping === void 0 ? void 0 : envelopeMapping.resourcesPathPrefix,
    ]);
    (0, hooks_1.useConnectedEnvelopeServer)(envelopeServer, channelApiImpl);
    (0, common_1.useEffectAfterFirstRender)(function () {
        envelopeServer.envelopeApi.notifications.kogitoI18n_localeChange.send(props.locale);
    }, [props.locale]);
    (0, common_1.useEffectAfterFirstRender)(function () {
        props.file.getFileContents().then(function (content) {
            envelopeServer.envelopeApi.requests.kogitoEditor_contentChanged({ content: content, path: props.file.fileName }, { showLoadingOverlay: true });
        });
    }, [props.file.getFileContents]);
    var onKeyDown = (0, react_1.useCallback)(function (envelopeServer, ke) {
        var _a;
        var channelKeyboardEvent = {
            altKey: ke.altKey,
            ctrlKey: ke.ctrlKey,
            shiftKey: ke.shiftKey,
            metaKey: ke.metaKey,
            code: ke.code,
            type: ke.type,
            channelOriginalTargetTagName: (_a = ke.target) === null || _a === void 0 ? void 0 : _a.tagName,
        };
        console.debug("New keyboard event (".concat(JSON.stringify(channelKeyboardEvent), ")!"));
        envelopeServer.envelopeApi.notifications.kogitoKeyboardShortcuts_channelKeyboardEvent.send(channelKeyboardEvent);
    }, []);
    (0, react_1.useImperativeHandle)(forwardedRef, function () {
        var _a;
        if (!iframeRef.current) {
            return undefined;
        }
        return {
            iframeRef: iframeRef,
            isReady: (_a = props.isReady) !== null && _a !== void 0 ? _a : isReady,
            getStateControl: function () { return stateControl; },
            getEnvelopeServer: function () { return envelopeServer; },
            undo: function () { return Promise.resolve(envelopeServer.envelopeApi.notifications.kogitoEditor_editorUndo.send()); },
            redo: function () { return Promise.resolve(envelopeServer.envelopeApi.notifications.kogitoEditor_editorRedo.send()); },
            getContent: function () { return envelopeServer.envelopeApi.requests.kogitoEditor_contentRequest().then(function (c) { return c.content; }); },
            getPreview: function () { return envelopeServer.envelopeApi.requests.kogitoEditor_previewRequest(); },
            setContent: function (path, content) {
                return envelopeServer.envelopeApi.requests.kogitoEditor_contentChanged({ path: path, content: content }, { showLoadingOverlay: false });
            },
            validate: function () { return envelopeServer.envelopeApi.requests.kogitoEditor_validate(); },
            setTheme: function (theme) { return Promise.resolve(envelopeServer.shared.kogitoEditor_theme.set(theme)); },
            onKeyDown: function (ke) { return onKeyDown(envelopeServer, ke); },
        };
    }, [props.isReady, isReady, stateControl, envelopeServer, onKeyDown]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [!envelopeMapping && ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: (0, jsx_runtime_1.jsx)("span", { children: "No Editor available for '".concat(props.file.fileExtension, "' extension") }) })), envelopeMapping && ((0, jsx_runtime_1.jsx)("iframe", __assign({ ref: iframeRef, id: "kogito-iframe", "data-testid": "kogito-iframe", title: "Kogito editor", style: containerStyles, "data-envelope-channel": props.channelType }, (0, editorIframeProps_1.getEditorIframeProps)(envelopeMapping))))] }));
};
exports.EmbeddedEditor = React.forwardRef(RefForwardingEmbeddedEditor);
//# sourceMappingURL=EmbeddedEditor.js.map

/***/ }),

/***/ 23620:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmbeddedEditorChannelApiImpl = void 0;
var api_1 = __webpack_require__(47602);
var api_2 = __webpack_require__(38830);
var api_3 = __webpack_require__(47602);
var EmbeddedEditorChannelApiImpl = (function () {
    function EmbeddedEditorChannelApiImpl(stateControl, file, locale, overrides) {
        this.stateControl = stateControl;
        this.file = file;
        this.locale = locale;
        this.overrides = overrides;
    }
    EmbeddedEditorChannelApiImpl.prototype.kogitoWorkspace_newEdit = function (edit) {
        var _a, _b;
        this.stateControl.updateCommandStack({ id: edit.id });
        (_b = (_a = this.overrides).kogitoWorkspace_newEdit) === null || _b === void 0 ? void 0 : _b.call(_a, edit);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoEditor_stateControlCommandUpdate = function (command) {
        var _a, _b;
        switch (command) {
            case api_1.StateControlCommand.REDO:
                this.stateControl.redo();
                break;
            case api_1.StateControlCommand.UNDO:
                this.stateControl.undo();
                break;
            default:
                console.info("Unknown message type received: ".concat(command));
                break;
        }
        (_b = (_a = this.overrides).kogitoEditor_stateControlCommandUpdate) === null || _b === void 0 ? void 0 : _b.call(_a, command);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoEditor_contentRequest = function () {
        return __awaiter(this, void 0, void 0, function () {
            var content;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.file.getFileContents()];
                    case 1:
                        content = _a.sent();
                        return [2, { content: content !== null && content !== void 0 ? content : "", path: this.file.fileName }];
                }
            });
        });
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoWorkspace_resourceContentRequest = function (request) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_d) {
                return [2, ((_c = (_b = (_a = this.overrides).kogitoWorkspace_resourceContentRequest) === null || _b === void 0 ? void 0 : _b.call(_a, request)) !== null && _c !== void 0 ? _c : new api_2.ResourceContent(request.path, undefined))];
            });
        });
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoWorkspace_resourceListRequest = function (request) {
        var _a, _b, _c;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_d) {
                return [2, (_c = (_b = (_a = this.overrides).kogitoWorkspace_resourceListRequest) === null || _b === void 0 ? void 0 : _b.call(_a, request)) !== null && _c !== void 0 ? _c : new api_2.ResourcesList(request.pattern, [])];
            });
        });
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoWorkspace_openFile = function (path) {
        var _a, _b;
        (_b = (_a = this.overrides).kogitoWorkspace_openFile) === null || _b === void 0 ? void 0 : _b.call(_a, path);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoEditor_ready = function () {
        var _a, _b;
        (_b = (_a = this.overrides).kogitoEditor_ready) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoEditor_setContentError = function (editorContent) {
        var _a, _b;
        (_b = (_a = this.overrides).kogitoEditor_setContentError) === null || _b === void 0 ? void 0 : _b.call(_a, editorContent);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoEditor_theme = function () {
        var _a, _b, _c;
        return (_c = (_b = (_a = this.overrides).kogitoEditor_theme) === null || _b === void 0 ? void 0 : _b.call(_a)) !== null && _c !== void 0 ? _c : { defaultValue: api_3.EditorTheme.LIGHT };
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoI18n_getLocale = function () {
        return Promise.resolve(this.locale);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoNotifications_createNotification = function (notification) {
        var _a, _b;
        (_b = (_a = this.overrides).kogitoNotifications_createNotification) === null || _b === void 0 ? void 0 : _b.call(_a, notification);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoNotifications_setNotifications = function (path, notifications) {
        var _a, _b;
        (_b = (_a = this.overrides).kogitoNotifications_setNotifications) === null || _b === void 0 ? void 0 : _b.call(_a, path, notifications);
    };
    EmbeddedEditorChannelApiImpl.prototype.kogitoNotifications_removeNotifications = function (path) {
        var _a, _b;
        (_b = (_a = this.overrides).kogitoNotifications_removeNotifications) === null || _b === void 0 ? void 0 : _b.call(_a, path);
    };
    return EmbeddedEditorChannelApiImpl;
}());
exports.EmbeddedEditorChannelApiImpl = EmbeddedEditorChannelApiImpl;
//# sourceMappingURL=EmbeddedEditorChannelApiImpl.js.map

/***/ }),

/***/ 22:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmbeddedViewer = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var EmbeddedEditor_1 = __webpack_require__(25504);
var EmbeddedViewer = function (props) { return (0, jsx_runtime_1.jsx)(EmbeddedEditor_1.EmbeddedEditor, __assign({}, props)); };
exports.EmbeddedViewer = EmbeddedViewer;
//# sourceMappingURL=EmbeddedViewer.js.map

/***/ }),

/***/ 37275:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useEditorRef = void 0;
var react_1 = __webpack_require__(29901);
function useEditorRef() {
    var _a = __read((0, react_1.useState)(undefined), 2), editor = _a[0], setEditor = _a[1];
    var editorRef = (0, react_1.useCallback)(function (node) {
        if (node) {
            setEditor(node);
        }
    }, []);
    return { editor: editor, editorRef: editorRef };
}
exports.useEditorRef = useEditorRef;
//# sourceMappingURL=Hooks.js.map

/***/ }),

/***/ 18538:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmbeddedEditorChannelApiImpl = exports.useEditorRef = exports.EmbeddedViewer = exports.EmbeddedEditor = void 0;
var EmbeddedEditor_1 = __webpack_require__(25504);
Object.defineProperty(exports, "EmbeddedEditor", ({ enumerable: true, get: function () { return EmbeddedEditor_1.EmbeddedEditor; } }));
var EmbeddedViewer_1 = __webpack_require__(22);
Object.defineProperty(exports, "EmbeddedViewer", ({ enumerable: true, get: function () { return EmbeddedViewer_1.EmbeddedViewer; } }));
var Hooks_1 = __webpack_require__(37275);
Object.defineProperty(exports, "useEditorRef", ({ enumerable: true, get: function () { return Hooks_1.useEditorRef; } }));
var EmbeddedEditorChannelApiImpl_1 = __webpack_require__(23620);
Object.defineProperty(exports, "EmbeddedEditorChannelApiImpl", ({ enumerable: true, get: function () { return EmbeddedEditorChannelApiImpl_1.EmbeddedEditorChannelApiImpl; } }));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 52869:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(44419), exports);
__exportStar(__webpack_require__(18538), exports);
__exportStar(__webpack_require__(95665), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 17580:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useStateControlSubscription = exports.useDirtyState = void 0;
var react_1 = __webpack_require__(29901);
function useDirtyState(editor) {
    var _a = __read((0, react_1.useState)(false), 2), isDirty = _a[0], setIsDirty = _a[1];
    (0, react_1.useEffect)(function () {
        var _a;
        setIsDirty((_a = editor === null || editor === void 0 ? void 0 : editor.getStateControl().isDirty()) !== null && _a !== void 0 ? _a : false);
        var callback = editor === null || editor === void 0 ? void 0 : editor.getStateControl().subscribe(setIsDirty);
        return function () {
            editor === null || editor === void 0 ? void 0 : editor.getStateControl().unsubscribe(callback);
        };
    }, [editor]);
    return isDirty;
}
exports.useDirtyState = useDirtyState;
function useStateControlSubscription(editor, callback, args) {
    if (args === void 0) { args = { throttle: 0 }; }
    (0, react_1.useEffect)(function () {
        if (!(editor === null || editor === void 0 ? void 0 : editor.isReady)) {
            return;
        }
        var timeout;
        var subscription = editor === null || editor === void 0 ? void 0 : editor.getStateControl().subscribe(function (isDirty) {
            if (args.throttle <= 0) {
                callback(isDirty);
                return;
            }
            if (timeout) {
                clearTimeout(timeout);
            }
            timeout = window.setTimeout(function () {
                callback(isDirty);
            }, args.throttle);
        });
        return function () {
            if (subscription) {
                return editor === null || editor === void 0 ? void 0 : editor.getStateControl().unsubscribe(subscription);
            }
        };
    }, [editor, callback, args.throttle]);
}
exports.useStateControlSubscription = useStateControlSubscription;
//# sourceMappingURL=Hooks.js.map

/***/ }),

/***/ 95665:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(17580), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 762:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditorEnvelopeView = exports.EditorEnvelopeViewRef = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var React = __webpack_require__(29901);
var LoadingScreen_1 = __webpack_require__(64433);
var KeyBindingsHelpOverlay_1 = __webpack_require__(27710);
var react_1 = __webpack_require__(29901);
var EditorEnvelopeViewRef = function (props, forwardingRef) {
    var _a = __read((0, react_1.useState)(undefined), 2), editor = _a[0], setEditor = _a[1];
    var _b = __read((0, react_1.useState)(true), 2), loading = _b[0], setLoading = _b[1];
    (0, react_1.useImperativeHandle)(forwardingRef, function () {
        return {
            getEditor: function () { return editor; },
            setEditor: function (newEditor) { return setEditor(newEditor); },
            setLoading: function () { return setLoading(true); },
            setLoadingFinished: function () { return setLoading(false); },
            setLocale: function (locale) { return props.setLocale(locale); },
        };
    }, [props, editor]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [!loading && props.showKeyBindingsOverlay && (0, jsx_runtime_1.jsx)(KeyBindingsHelpOverlay_1.KeyBindingsHelpOverlay, {}), (0, jsx_runtime_1.jsx)(LoadingScreen_1.LoadingScreen, { loading: loading }), (0, jsx_runtime_1.jsx)("div", __assign({ style: { position: "absolute", width: "100vw", height: "100vh", top: "0", left: "0" } }, { children: editor && editor.af_isReact && editor.af_componentRoot() }))] }));
};
exports.EditorEnvelopeViewRef = EditorEnvelopeViewRef;
exports.EditorEnvelopeView = React.forwardRef(exports.EditorEnvelopeViewRef);
//# sourceMappingURL=EditorEnvelopeView.js.map

/***/ }),

/***/ 75186:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KeyBindingsHelpOverlay = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var React = __webpack_require__(29901);
var react_1 = __webpack_require__(29901);
var Text_1 = __webpack_require__(7331);
var Modal_1 = __webpack_require__(87692);
var keyboard_icon_1 = __webpack_require__(33214);
var operating_system_1 = __webpack_require__(88473);
var api_1 = __webpack_require__(47602);
var i18n_1 = __webpack_require__(81979);
function KeyBindingsHelpOverlay() {
    var _this = this;
    var _a = __read((0, react_1.useState)(false), 2), showing = _a[0], setShowing = _a[1];
    var envelopeContext = (0, api_1.useKogitoEditorEnvelopeContext)();
    var i18n = (0, i18n_1.useEditorEnvelopeI18nContext)().i18n;
    var toggle = (0, react_1.useCallback)(function () {
        setShowing(!showing);
    }, [showing]);
    var keyBindings = (0, react_1.useMemo)(function () {
        return removeDuplicatesByAttr(envelopeContext.services.keyboardShortcuts.registered(), "combination")
            .filter(function (k) { var _a; return !((_a = k.opts) === null || _a === void 0 ? void 0 : _a.hidden); })
            .map(function (k) {
            var _a, _b;
            return {
                combination: handleMacOsCombination(k.combination, envelopeContext.operatingSystem),
                category: (_a = k.label.split("|")[0]) === null || _a === void 0 ? void 0 : _a.trim(),
                label: (_b = k.label.split("|")[1]) === null || _b === void 0 ? void 0 : _b.trim(),
            };
        })
            .reduce(function (lhs, rhs) {
            if (!lhs.has(rhs.category)) {
                lhs.set(rhs.category, new Set([{ label: rhs.label, combination: rhs.combination }]));
            }
            else {
                lhs.get(rhs.category).add({ label: rhs.label, combination: rhs.combination });
            }
            return lhs;
        }, new Map());
    }, [envelopeContext.services.keyboardShortcuts.registered()]);
    (0, react_1.useEffect)(function () {
        var id = envelopeContext.services.keyboardShortcuts.registerKeyPress("shift+/", "".concat(i18n.keyBindingsHelpOverlay.categories.help, " | ").concat(i18n.keyBindingsHelpOverlay.commands.showKeyboardOverlay), function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2, setShowing(true)];
        }); }); }, { element: window });
        return function () { return envelopeContext.services.keyboardShortcuts.deregister(id); };
    }, [i18n]);
    (0, react_1.useEffect)(function () {
        if (showing) {
            var id_1 = envelopeContext.services.keyboardShortcuts.registerKeyPressOnce("esc", function () { return __awaiter(_this, void 0, void 0, function () { return __generator(this, function (_a) {
                return [2, setShowing(false)];
            }); }); }, {
                element: window,
            });
            return function () { return envelopeContext.services.keyboardShortcuts.deregister(id_1); };
        }
    }, [showing]);
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)("div", __assign({ onClick: function () { return setShowing(!showing); }, className: "kie-tools--keyboard-shortcuts kie-tools--keyboard-shortcuts-icon", "data-ouia-component-id": "keyboard-shortcuts-icon", "data-testid": "keyboard-shortcuts-help-overlay-icon" }, { children: (0, jsx_runtime_1.jsx)(keyboard_icon_1.KeyboardIcon, {}) })), (0, jsx_runtime_1.jsx)(Modal_1.Modal, __assign({ appendTo: document.body, title: i18n.keyBindingsHelpOverlay.title, isOpen: showing, width: "60%", onClose: toggle, "data-testid": "keyboard-shortcuts-help-overlay", className: "kie-tools--keyboard-shortcuts" }, { children: (0, jsx_runtime_1.jsx)(Text_1.TextContent, { children: (0, jsx_runtime_1.jsx)(Text_1.TextList, __assign({ component: Text_1.TextListVariants.dl }, { children: Array.from(keyBindings.keys()).map(function (category) { return ((0, jsx_runtime_1.jsxs)(React.Fragment, { children: [(0, jsx_runtime_1.jsx)(Text_1.Text, __assign({ component: Text_1.TextVariants.h2 }, { children: category })), Array.from(keyBindings.get(category)).map(function (keyBinding) { return ((0, jsx_runtime_1.jsxs)(React.Fragment, { children: [(0, jsx_runtime_1.jsx)(Text_1.TextListItem, __assign({ component: Text_1.TextListItemVariants.dt }, { children: formatKeyBindingCombination(keyBinding.combination) })), (0, jsx_runtime_1.jsx)(Text_1.TextListItem, __assign({ component: Text_1.TextListItemVariants.dd }, { children: keyBinding.label }))] }, keyBinding.combination)); })] }, category)); }) })) }) }))] }));
}
exports.KeyBindingsHelpOverlay = KeyBindingsHelpOverlay;
function handleMacOsCombination(combination, os) {
    if (os === operating_system_1.OperatingSystem.MACOS) {
        return combination.replace("ctrl", "cmd");
    }
    return combination;
}
function removeDuplicatesByAttr(myArr, prop) {
    return myArr.filter(function (obj, pos, arr) {
        return arr.map(function (mapObj) { return mapObj[prop]; }).indexOf(obj[prop]) === pos;
    });
}
function formatKeyBindingCombination(combination) {
    return combination
        .split("+")
        .map(function (w) { return w.replace(/^\w/, function (c) { return c.toUpperCase(); }); })
        .join(" + ");
}
//# sourceMappingURL=KeyBindingsHelpOverlay.js.map

/***/ }),

/***/ 27710:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__webpack_require__(68089);
__exportStar(__webpack_require__(75186), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 69951:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KogitoEditorEnvelope = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var api_1 = __webpack_require__(47602);
var EditorEnvelopeView_1 = __webpack_require__(762);
var ReactDOM = __webpack_require__(10571);
var React = __webpack_require__(29901);
var i18n_1 = __webpack_require__(81979);
var react_components_1 = __webpack_require__(66853);
var operating_system_1 = __webpack_require__(88473);
var KogitoEditorEnvelope = (function () {
    function KogitoEditorEnvelope(kogitoEditorEnvelopeApiFactory, keyboardShortcutsService, i18nService, envelope, context) {
        if (context === void 0) { context = {
            channelApi: envelope.channelApi,
            operatingSystem: (0, operating_system_1.getOperatingSystem)(),
            services: {
                keyboardShortcuts: keyboardShortcutsService,
                i18n: i18nService,
            },
        }; }
        this.kogitoEditorEnvelopeApiFactory = kogitoEditorEnvelopeApiFactory;
        this.keyboardShortcutsService = keyboardShortcutsService;
        this.i18nService = i18nService;
        this.envelope = envelope;
        this.context = context;
    }
    KogitoEditorEnvelope.prototype.start = function (container) {
        var _this = this;
        return this.envelope.start(function () { return _this.renderView(container); }, this.context, this.kogitoEditorEnvelopeApiFactory);
    };
    KogitoEditorEnvelope.prototype.renderView = function (container) {
        var _this = this;
        var editorEnvelopeViewRef = React.createRef();
        var app = ((0, jsx_runtime_1.jsx)(api_1.KogitoEditorEnvelopeContext.Provider, __assign({ value: this.context }, { children: (0, jsx_runtime_1.jsx)(react_components_1.I18nDictionariesProvider, __assign({ defaults: i18n_1.editorEnvelopeI18nDefaults, dictionaries: i18n_1.editorEnvelopeI18nDictionaries, ctx: i18n_1.EditorEnvelopeI18nContext, initialLocale: navigator.language }, { children: (0, jsx_runtime_1.jsx)(i18n_1.EditorEnvelopeI18nContext.Consumer, { children: function (_a) {
                        var setLocale = _a.setLocale;
                        return ((0, jsx_runtime_1.jsx)(EditorEnvelopeView_1.EditorEnvelopeView, { ref: editorEnvelopeViewRef, setLocale: setLocale, showKeyBindingsOverlay: _this.keyboardShortcutsService.isEnabled() }));
                    } }) })) })));
        return new Promise(function (res) {
            setTimeout(function () {
                ReactDOM.render(app, container, function () {
                    res(function () { return editorEnvelopeViewRef.current; });
                });
            }, 0);
        });
    };
    return KogitoEditorEnvelope;
}());
exports.KogitoEditorEnvelope = KogitoEditorEnvelope;
//# sourceMappingURL=KogitoEditorEnvelope.js.map

/***/ }),

/***/ 55824:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.KogitoEditorEnvelopeApiImpl = void 0;
var api_1 = __webpack_require__(47602);
var core_1 = __webpack_require__(71542);
var i18n_1 = __webpack_require__(81979);
var KogitoEditorEnvelopeApiImpl = (function () {
    function KogitoEditorEnvelopeApiImpl(args, editorFactory, i18n) {
        if (i18n === void 0) { i18n = new core_1.I18n(i18n_1.editorEnvelopeI18nDefaults, i18n_1.editorEnvelopeI18nDictionaries); }
        var _this = this;
        this.args = args;
        this.editorFactory = editorFactory;
        this.i18n = i18n;
        this.capturedInitRequestYet = false;
        this.kogitoEditor_initRequest = function (association, initArgs) { return __awaiter(_this, void 0, void 0, function () {
            var _a, _b, editorContent;
            var _this = this;
            var _c, _d, _e, _f, _g;
            return __generator(this, function (_h) {
                switch (_h.label) {
                    case 0:
                        this.args.envelopeClient.associate(association.origin, association.envelopeServerId);
                        if (this.hasCapturedInitRequestYet()) {
                            return [2];
                        }
                        this.ackCapturedInitRequest();
                        _a = this;
                        return [4, this.args.viewDelegate()];
                    case 1:
                        _a.view = _h.sent();
                        this.setupI18n(initArgs);
                        _b = this;
                        return [4, this.editorFactory.createEditor(this.args.envelopeContext, initArgs)];
                    case 2:
                        _b.editor = _h.sent();
                        return [4, this.view().setEditor(this.editor)];
                    case 3:
                        _h.sent();
                        (_d = (_c = this.editor).af_onStartup) === null || _d === void 0 ? void 0 : _d.call(_c);
                        (_f = (_e = this.editor).af_onOpen) === null || _f === void 0 ? void 0 : _f.call(_e);
                        this.view().setLoading();
                        return [4, this.args.envelopeContext.channelApi.requests.kogitoEditor_contentRequest()];
                    case 4:
                        editorContent = _h.sent();
                        return [4, this.editor
                                .setContent((_g = editorContent.path) !== null && _g !== void 0 ? _g : "", editorContent.content)
                                .catch(function (e) { return _this.args.envelopeContext.channelApi.notifications.kogitoEditor_setContentError.send(editorContent); })
                                .finally(function () { return _this.view().setLoadingFinished(); })];
                    case 5:
                        _h.sent();
                        this.registerDefaultShortcuts(initArgs);
                        this.args.envelopeContext.channelApi.notifications.kogitoEditor_ready.send();
                        return [2];
                }
            });
        }); };
        this.kogitoEditor_contentChanged = function (editorContent, args) {
            var _a;
            if (args.showLoadingOverlay) {
                _this.view().setLoading();
            }
            return _this.editor
                .setContent((_a = editorContent.path) !== null && _a !== void 0 ? _a : "", editorContent.content)
                .catch(function (e) {
                _this.args.envelopeContext.channelApi.notifications.kogitoEditor_setContentError.send(editorContent);
                throw e;
            })
                .finally(function () { return _this.view().setLoadingFinished(); });
        };
        this.kogitoKeyboardShortcuts_channelKeyboardEvent = function (channelKeyboardEvent) {
            window.dispatchEvent(new CustomEvent(channelKeyboardEvent.type, { detail: channelKeyboardEvent }));
        };
    }
    KogitoEditorEnvelopeApiImpl.prototype.hasCapturedInitRequestYet = function () {
        return this.capturedInitRequestYet;
    };
    KogitoEditorEnvelopeApiImpl.prototype.ackCapturedInitRequest = function () {
        this.capturedInitRequestYet = true;
    };
    KogitoEditorEnvelopeApiImpl.prototype.kogitoEditor_editorUndo = function () {
        this.editor.undo();
    };
    KogitoEditorEnvelopeApiImpl.prototype.kogitoEditor_editorRedo = function () {
        this.editor.redo();
    };
    KogitoEditorEnvelopeApiImpl.prototype.kogitoEditor_contentRequest = function () {
        return this.editor.getContent().then(function (content) { return ({ content: sanitize(content) }); });
    };
    KogitoEditorEnvelopeApiImpl.prototype.kogitoEditor_previewRequest = function () {
        return this.editor.getPreview().then(function (previewSvg) { return previewSvg !== null && previewSvg !== void 0 ? previewSvg : ""; });
    };
    KogitoEditorEnvelopeApiImpl.prototype.kogitoI18n_localeChange = function (locale) {
        return this.args.envelopeContext.services.i18n.executeOnLocaleChangeSubscriptions(locale);
    };
    KogitoEditorEnvelopeApiImpl.prototype.kogitoEditor_validate = function () {
        return this.editor.validate();
    };
    KogitoEditorEnvelopeApiImpl.prototype.setupI18n = function (initArgs) {
        var _this = this;
        this.i18n.setLocale(initArgs.initialLocale);
        this.args.envelopeContext.services.i18n.subscribeToLocaleChange(function (locale) {
            _this.i18n.setLocale(locale);
            _this.view().setLocale(locale);
        });
    };
    KogitoEditorEnvelopeApiImpl.prototype.registerDefaultShortcuts = function (initArgs) {
        var _this = this;
        if (initArgs.channel === api_1.ChannelType.VSCODE_DESKTOP ||
            initArgs.channel === api_1.ChannelType.VSCODE_WEB ||
            initArgs.isReadOnly) {
            return;
        }
        var i18n = this.i18n.getCurrent();
        var redoId = this.args.envelopeContext.services.keyboardShortcuts.registerKeyPress("shift+ctrl+z", "".concat(i18n.keyBindingsHelpOverlay.categories.edit, " | ").concat(i18n.keyBindingsHelpOverlay.commands.redo), function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.editor.redo();
                this.args.envelopeContext.channelApi.notifications.kogitoEditor_stateControlCommandUpdate.send(api_1.StateControlCommand.REDO);
                return [2];
            });
        }); });
        var undoId = this.args.envelopeContext.services.keyboardShortcuts.registerKeyPress("ctrl+z", "".concat(i18n.keyBindingsHelpOverlay.categories.edit, " | ").concat(i18n.keyBindingsHelpOverlay.commands.undo), function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.editor.undo();
                this.args.envelopeContext.channelApi.notifications.kogitoEditor_stateControlCommandUpdate.send(api_1.StateControlCommand.UNDO);
                return [2];
            });
        }); });
        var subscription = this.args.envelopeContext.services.i18n.subscribeToLocaleChange(function (locale) {
            _this.args.envelopeContext.services.keyboardShortcuts.deregister(redoId);
            _this.args.envelopeContext.services.keyboardShortcuts.deregister(undoId);
            _this.args.envelopeContext.services.i18n.unsubscribeToLocaleChange(subscription);
            _this.registerDefaultShortcuts(initArgs);
        });
    };
    KogitoEditorEnvelopeApiImpl.prototype.getEditorOrThrowError = function () {
        var editor = this.view().getEditor();
        if (!editor) {
            throw new Error("Editor not found.");
        }
        return editor;
    };
    return KogitoEditorEnvelopeApiImpl;
}());
exports.KogitoEditorEnvelopeApiImpl = KogitoEditorEnvelopeApiImpl;
function sanitize(str) {
    return str.replace(/[\u202a\u202b\u202c\u202d\u202e\u2066\u2067\u2068\u2069]/gu, "");
}
//# sourceMappingURL=KogitoEditorEnvelopeApiImpl.js.map

/***/ }),

/***/ 24186:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LoadingScreen = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var react_1 = __webpack_require__(29901);
var Spinner_1 = __webpack_require__(88394);
var Title_1 = __webpack_require__(16697);
var Bullseye_1 = __webpack_require__(55299);
var i18n_1 = __webpack_require__(81979);
function LoadingScreen(props) {
    var _a = __read((0, react_1.useState)(true), 2), mustRender = _a[0], setMustRender = _a[1];
    var i18n = (0, i18n_1.useEditorEnvelopeI18nContext)().i18n;
    var onAnimationEnd = (0, react_1.useCallback)(function (e) {
        e.preventDefault();
        e.stopPropagation();
        setMustRender(false);
    }, []);
    var loadingScreenClassName = (0, react_1.useMemo)(function () {
        if (props.loading) {
            return "";
        }
        return "loading-finished";
    }, [props.loading]);
    (0, react_1.useLayoutEffect)(function () {
        if (props.loading) {
            setMustRender(true);
        }
    }, [props.loading]);
    return ((mustRender && ((0, jsx_runtime_1.jsx)("div", __assign({ id: "loading-screen", className: "kie-tools--loading-screen" }, { children: (0, jsx_runtime_1.jsx)("div", __assign({ className: "kie-tools--loading-screen ".concat(loadingScreenClassName), onAnimationEnd: onAnimationEnd, "data-testid": "loading-screen-div" }, { children: (0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, { children: (0, jsx_runtime_1.jsxs)("div", __assign({ className: "kie-tools--loading-screen-spinner" }, { children: [(0, jsx_runtime_1.jsx)("div", { children: (0, jsx_runtime_1.jsx)(Spinner_1.Spinner, {}) }), (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ headingLevel: "h5" }, { children: i18n.loadingScreen.loading }))] })) }) })) })))) || (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {}));
}
exports.LoadingScreen = LoadingScreen;
//# sourceMappingURL=LoadingScreen.js.map

/***/ }),

/***/ 64433:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__webpack_require__(68089);
__exportStar(__webpack_require__(24186), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 92177:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=EditorEnvelopeI18n.js.map

/***/ }),

/***/ 81979:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(92177), exports);
__exportStar(__webpack_require__(26378), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 14174:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.en = void 0;
exports.en = {
    keyBindingsHelpOverlay: {
        title: "Keyboard shortcuts",
        categories: {
            edit: "Edit",
            help: "Help",
        },
        commands: {
            undo: "Undo last edit",
            redo: "Redo last edit",
            showKeyboardOverlay: "Show keyboard shortcuts",
        },
    },
    loadingScreen: {
        loading: "Loading...",
    },
};
//# sourceMappingURL=en.js.map

/***/ }),

/***/ 64173:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.en = void 0;
var en_1 = __webpack_require__(14174);
Object.defineProperty(exports, "en", ({ enumerable: true, get: function () { return en_1.en; } }));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 26378:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useEditorEnvelopeI18nContext = exports.EditorEnvelopeI18nContext = exports.editorEnvelopeI18nDictionaries = exports.editorEnvelopeI18nDefaults = void 0;
var React = __webpack_require__(29901);
var react_1 = __webpack_require__(29901);
var locales_1 = __webpack_require__(64173);
exports.editorEnvelopeI18nDefaults = { locale: "en", dictionary: locales_1.en };
exports.editorEnvelopeI18nDictionaries = new Map([["en", locales_1.en]]);
exports.EditorEnvelopeI18nContext = React.createContext({});
function useEditorEnvelopeI18nContext() {
    return (0, react_1.useContext)(exports.EditorEnvelopeI18nContext);
}
exports.useEditorEnvelopeI18nContext = useEditorEnvelopeI18nContext;
//# sourceMappingURL=setup.js.map

/***/ }),

/***/ 68778:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.initCustom = exports.init = void 0;
__webpack_require__(42479);
var KogitoEditorEnvelope_1 = __webpack_require__(69951);
var KogitoEditorEnvelopeApiImpl_1 = __webpack_require__(55824);
var envelope_1 = __webpack_require__(56215);
var envelope_2 = __webpack_require__(15517);
var envelope_3 = __webpack_require__(67162);
var operating_system_1 = __webpack_require__(88473);
function init(args) {
    initCustom({
        container: args.container,
        bus: args.bus,
        apiImplFactory: {
            create: function (createArgs) { return new KogitoEditorEnvelopeApiImpl_1.KogitoEditorEnvelopeApiImpl(createArgs, args.editorFactory); },
        },
        keyboardShortcutsService: args.keyboardShortcutsService,
    });
}
exports.init = init;
function initCustom(args) {
    var _a;
    var keyboardShortcutsService = (_a = args.keyboardShortcutsService) !== null && _a !== void 0 ? _a : new envelope_1.DefaultKeyboardShortcutsService({ os: (0, operating_system_1.getOperatingSystem)() });
    var i18nService = new envelope_2.I18nService();
    var envelope = new envelope_3.Envelope(args.bus);
    return new KogitoEditorEnvelope_1.KogitoEditorEnvelope(args.apiImplFactory, keyboardShortcutsService, i18nService, envelope).start(args.container);
}
exports.initCustom = initCustom;
__exportStar(__webpack_require__(55824), exports);
__exportStar(__webpack_require__(64433), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 96272:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvelopeBusMessageDirectSender = exports.EnvelopeBusMessagePurpose = void 0;
var EnvelopeBusMessagePurpose;
(function (EnvelopeBusMessagePurpose) {
    EnvelopeBusMessagePurpose["REQUEST"] = "request";
    EnvelopeBusMessagePurpose["RESPONSE"] = "response";
    EnvelopeBusMessagePurpose["NOTIFICATION_SUBSCRIPTION"] = "subscription";
    EnvelopeBusMessagePurpose["NOTIFICATION_UNSUBSCRIPTION"] = "unsubscription";
    EnvelopeBusMessagePurpose["NOTIFICATION"] = "notification";
    EnvelopeBusMessagePurpose["SHARED_VALUE_GET_DEFAULT"] = "shared-value-get-default";
    EnvelopeBusMessagePurpose["SHARED_VALUE_UPDATE"] = "shared-value-update";
})(EnvelopeBusMessagePurpose = exports.EnvelopeBusMessagePurpose || (exports.EnvelopeBusMessagePurpose = {}));
var EnvelopeBusMessageDirectSender;
(function (EnvelopeBusMessageDirectSender) {
    EnvelopeBusMessageDirectSender["ENVELOPE_CLIENT"] = "envelopeClient";
    EnvelopeBusMessageDirectSender["ENVELOPE_SERVER"] = "envelopeServer";
})(EnvelopeBusMessageDirectSender = exports.EnvelopeBusMessageDirectSender || (exports.EnvelopeBusMessageDirectSender = {}));
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 87864:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvelopeServer = exports.EnvelopeServerType = void 0;
var api_1 = __webpack_require__(96272);
var common_1 = __webpack_require__(48869);
var EnvelopeServerType;
(function (EnvelopeServerType) {
    EnvelopeServerType["LOCAL"] = "local";
    EnvelopeServerType["REMOTE"] = "remote";
})(EnvelopeServerType = exports.EnvelopeServerType || (exports.EnvelopeServerType = {}));
var EnvelopeServer = (function () {
    function EnvelopeServer(bus, origin, pollInit, type, manager) {
        if (type === void 0) { type = EnvelopeServerType.REMOTE; }
        if (manager === void 0) { manager = new common_1.EnvelopeBusMessageManager(function (message) {
            return bus.postMessage(__assign(__assign({}, message), { targetEnvelopeId: type === EnvelopeServerType.LOCAL ? _this.id : undefined, directSender: api_1.EnvelopeBusMessageDirectSender.ENVELOPE_SERVER }));
        }, "EnvelopeServer"); }
        var _this = this;
        this.origin = origin;
        this.pollInit = pollInit;
        this.type = type;
        this.manager = manager;
        this.id = this.generateRandomId();
    }
    Object.defineProperty(EnvelopeServer.prototype, "envelopeApi", {
        get: function () {
            return this.manager.clientApi;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(EnvelopeServer.prototype, "shared", {
        get: function () {
            return this.manager.shared;
        },
        enumerable: false,
        configurable: true
    });
    EnvelopeServer.prototype.startInitPolling = function (apiImpl) {
        var _this = this;
        this.pollInit(this).then(function () {
            _this.stopInitPolling();
        });
        this.manager.currentApiImpl = apiImpl;
        this.initialPollingSetting = setTimeout(function () {
            _this.initPolling = setInterval(function () {
                _this.pollInit(_this).then(function () { return _this.stopInitPolling(); });
            }, EnvelopeServer.INIT_POLLING_INTERVAL_IN_MS);
            _this.initPollingTimeout = setTimeout(function () {
                _this.stopInitPolling();
                console.info("Init polling timed out. Looks like the Envelope is not responding accordingly.");
            }, EnvelopeServer.INIT_POLLING_TIMEOUT_IN_MS);
        }, EnvelopeServer.INIT_POLLING_INTERVAL_IN_MS);
    };
    EnvelopeServer.prototype.stopInitPolling = function () {
        clearTimeout(this.initialPollingSetting);
        this.initialPollingSetting = undefined;
        this.manager.currentApiImpl = undefined;
        clearInterval(this.initPolling);
        this.initPolling = undefined;
        clearTimeout(this.initPollingTimeout);
        this.initPollingTimeout = undefined;
    };
    EnvelopeServer.prototype.receive = function (message, apiImpl) {
        if (message.directSender === api_1.EnvelopeBusMessageDirectSender.ENVELOPE_SERVER) {
            return;
        }
        if (message.targetEnvelopeId) {
            return;
        }
        if (message.targetEnvelopeServerId === this.id) {
            this.manager.server.receive(message, apiImpl);
        }
        else if (message.purpose === api_1.EnvelopeBusMessagePurpose.NOTIFICATION) {
            this.manager.server.receive(message, {});
        }
    };
    EnvelopeServer.prototype.generateRandomId = function () {
        var randomPart = Math.random().toString(36).substr(2, 9);
        var milliseconds = new Date().getMilliseconds();
        return "_".concat(randomPart, "_").concat(milliseconds);
    };
    EnvelopeServer.INIT_POLLING_TIMEOUT_IN_MS = 60000;
    EnvelopeServer.INIT_POLLING_INTERVAL_IN_MS = 100;
    return EnvelopeServer;
}());
exports.EnvelopeServer = EnvelopeServer;
//# sourceMappingURL=EnvelopeServer.js.map

/***/ }),

/***/ 17059:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(87864), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 84621:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvelopeBusMessageManager = void 0;
var api_1 = __webpack_require__(96272);
var EnvelopeBusMessageManager = (function () {
    function EnvelopeBusMessageManager(send, name) {
        if (name === void 0) { name = "".concat(new Date().getMilliseconds()); }
        var _this = this;
        this.send = send;
        this.name = name;
        this.requestHandlers = new Map();
        this.localNotificationsSubscriptions = new Map();
        this.remoteNotificationsSubscriptions = [];
        this.localSharedValueSubscriptions = new Map();
        this.localSharedValuesStore = new Map();
        this.clientApi = {
            requests: cachedProxy(new Map(), {
                get: function (target, name) {
                    return function () {
                        var args = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            args[_i] = arguments[_i];
                        }
                        return _this.request.apply(_this, __spreadArray([name], __read(args), false));
                    };
                },
            }),
            notifications: cachedProxy(new Map(), {
                get: function (target, name) { return ({
                    subscribe: function (callback) { return _this.subscribeToNotification(name, callback); },
                    unsubscribe: function (callback) { return _this.unsubscribeFromNotification(name, callback); },
                    send: function () {
                        var args = [];
                        for (var _i = 0; _i < arguments.length; _i++) {
                            args[_i] = arguments[_i];
                        }
                        return _this.notify.apply(_this, __spreadArray([name], __read(args), false));
                    },
                }); },
            }),
            shared: cachedProxy(new Map(), {
                get: function (target, name) { return ({
                    set: function (value) { return _this.setSharedValue(name, value); },
                    subscribe: function (callback) { return _this.subscribeToSharedValue(name, callback, { owned: false }); },
                    unsubscribe: function (callback) { return _this.unsubscribeFromSharedValue(name, callback); },
                }); },
            }),
        };
        this.shared = cachedProxy(new Map(), {
            get: function (target, name) { return ({
                set: function (value) { return _this.setSharedValue(name, value); },
                subscribe: function (callback) { return _this.subscribeToSharedValue(name, callback, { owned: true }); },
                unsubscribe: function (callback) { return _this.unsubscribeFromSharedValue(name, callback); },
            }); },
        });
        this.requestIdCounter = 0;
    }
    Object.defineProperty(EnvelopeBusMessageManager.prototype, "server", {
        get: function () {
            var _this = this;
            return {
                receive: function (m, apiImpl) {
                    console.debug(m);
                    _this.receive(m, apiImpl);
                },
            };
        },
        enumerable: false,
        configurable: true
    });
    EnvelopeBusMessageManager.prototype.setSharedValue = function (method, value) {
        var _a;
        this.localSharedValuesStore.set(method, value);
        (_a = this.localSharedValueSubscriptions.get(method)) === null || _a === void 0 ? void 0 : _a.forEach(function (callback) { return callback(value); });
        this.send({
            type: method,
            purpose: api_1.EnvelopeBusMessagePurpose.SHARED_VALUE_UPDATE,
            data: value,
        });
    };
    EnvelopeBusMessageManager.prototype.subscribeToSharedValue = function (method, callback, config) {
        var _a;
        var activeSubscriptions = (_a = this.localSharedValueSubscriptions.get(method)) !== null && _a !== void 0 ? _a : [];
        this.localSharedValueSubscriptions.set(method, __spreadArray(__spreadArray([], __read(activeSubscriptions), false), [callback], false));
        if (config.owned || this.localSharedValuesStore.get(method)) {
            callback(this.getCurrentStoredSharedValueOrDefault(method, this.currentApiImpl));
        }
        else {
            this.send({
                type: method,
                purpose: api_1.EnvelopeBusMessagePurpose.SHARED_VALUE_GET_DEFAULT,
                data: [],
            });
        }
        return callback;
    };
    EnvelopeBusMessageManager.prototype.unsubscribeFromSharedValue = function (name, callback) {
        var activeSubscriptions = this.localSharedValueSubscriptions.get(name);
        if (!activeSubscriptions) {
            return;
        }
        var index = activeSubscriptions.indexOf(callback);
        if (index < 0) {
            return;
        }
        activeSubscriptions.splice(index, 1);
    };
    EnvelopeBusMessageManager.prototype.getCurrentStoredSharedValueOrDefault = function (method, apiImpl) {
        var _a, _b;
        var m = method;
        return ((_a = this.localSharedValuesStore.get(m)) !== null && _a !== void 0 ? _a : this.localSharedValuesStore.set(m, (_b = apiImpl === null || apiImpl === void 0 ? void 0 : apiImpl[m]) === null || _b === void 0 ? void 0 : _b.apply(apiImpl).defaultValue).get(method));
    };
    EnvelopeBusMessageManager.prototype.subscribeToNotification = function (method, callback) {
        var _a;
        var activeSubscriptions = (_a = this.localNotificationsSubscriptions.get(method)) !== null && _a !== void 0 ? _a : [];
        this.localNotificationsSubscriptions.set(method, __spreadArray(__spreadArray([], __read(activeSubscriptions), false), [callback], false));
        this.send({
            type: method,
            purpose: api_1.EnvelopeBusMessagePurpose.NOTIFICATION_SUBSCRIPTION,
            data: [],
        });
        return callback;
    };
    EnvelopeBusMessageManager.prototype.unsubscribeFromNotification = function (method, callback) {
        var activeSubscriptions = this.localNotificationsSubscriptions.get(method);
        if (!activeSubscriptions) {
            return;
        }
        var index = activeSubscriptions.indexOf(callback);
        if (index < 0) {
            return;
        }
        activeSubscriptions.splice(index, 1);
        this.send({
            type: method,
            purpose: api_1.EnvelopeBusMessagePurpose.NOTIFICATION_UNSUBSCRIPTION,
            data: [],
        });
    };
    EnvelopeBusMessageManager.prototype.request = function (method) {
        var _this = this;
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var requestId = this.getNextRequestId();
        this.send({
            requestId: requestId,
            type: method,
            data: args,
            purpose: api_1.EnvelopeBusMessagePurpose.REQUEST,
        });
        return new Promise(function (resolve, reject) {
            _this.requestHandlers.set(requestId, { resolve: resolve, reject: reject });
        });
    };
    EnvelopeBusMessageManager.prototype.notify = function (method) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        this.send({
            type: method,
            data: args,
            purpose: api_1.EnvelopeBusMessagePurpose.NOTIFICATION,
        });
    };
    EnvelopeBusMessageManager.prototype.respond = function (request, data, error) {
        if (request.purpose !== api_1.EnvelopeBusMessagePurpose.REQUEST) {
            throw new Error("Cannot respond a message that is not a request");
        }
        if (!request.requestId) {
            throw new Error("Cannot respond a request without a requestId");
        }
        this.send({
            requestId: request.requestId,
            purpose: api_1.EnvelopeBusMessagePurpose.RESPONSE,
            type: request.type,
            data: data,
            error: error instanceof Error ? error.message : JSON.stringify(error),
        });
    };
    EnvelopeBusMessageManager.prototype.callback = function (response) {
        if (response.purpose !== api_1.EnvelopeBusMessagePurpose.RESPONSE) {
            throw new Error("Cannot invoke callback with a message that is not a response");
        }
        if (!response.requestId) {
            throw new Error("Cannot acknowledge a response without a requestId");
        }
        var callback = this.requestHandlers.get(response.requestId);
        if (!callback) {
            throw new Error("Callback not found for " + response);
        }
        this.requestHandlers.delete(response.requestId);
        if (!response.error) {
            callback.resolve(response.data);
        }
        else {
            callback.reject(new Error(response.error));
        }
    };
    EnvelopeBusMessageManager.prototype.receive = function (message, apiImpl) {
        var _this = this;
        var _a, _b;
        this.currentApiImpl = apiImpl;
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.RESPONSE) {
            this.callback(message);
            return;
        }
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.REQUEST) {
            var request_1 = message;
            var response = void 0;
            try {
                response = apiImpl[request_1.type].apply(apiImpl, request_1.data);
            }
            catch (err) {
                console.error(err);
                this.respond(request_1, undefined, err);
                return;
            }
            if (!(response instanceof Promise)) {
                throw new Error("Cannot make a request to '".concat(String(request_1.type), "' because it does not return a Promise"));
            }
            response
                .then(function (data) {
                _this.respond(request_1, data);
            })
                .catch(function (err) {
                console.error(err);
                _this.respond(request_1, undefined, err);
            });
            return;
        }
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.NOTIFICATION) {
            var method = message.type;
            (_a = apiImpl[method]) === null || _a === void 0 ? void 0 : _a.apply(apiImpl, message.data);
            if (this.remoteNotificationsSubscriptions.indexOf(method) >= 0) {
                this.send({
                    type: method,
                    purpose: api_1.EnvelopeBusMessagePurpose.NOTIFICATION,
                    data: message.data,
                });
            }
            var localSubscriptionMethod = message.type;
            (_b = this.localNotificationsSubscriptions.get(localSubscriptionMethod)) === null || _b === void 0 ? void 0 : _b.forEach(function (callback) {
                callback.apply(void 0, __spreadArray([], __read(message.data), false));
            });
            return;
        }
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.NOTIFICATION_SUBSCRIPTION) {
            var method = message.type;
            if (this.remoteNotificationsSubscriptions.indexOf(method) < 0) {
                this.remoteNotificationsSubscriptions.push(method);
            }
            return;
        }
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.NOTIFICATION_UNSUBSCRIPTION) {
            var method = message.type;
            var index = this.remoteNotificationsSubscriptions.indexOf(method);
            if (index >= 0) {
                this.remoteNotificationsSubscriptions.splice(index, 1);
            }
            return;
        }
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.SHARED_VALUE_GET_DEFAULT) {
            var method = message.type;
            this.send({
                type: method,
                purpose: api_1.EnvelopeBusMessagePurpose.SHARED_VALUE_UPDATE,
                data: this.getCurrentStoredSharedValueOrDefault(method, apiImpl),
            });
            return;
        }
        if (message.purpose === api_1.EnvelopeBusMessagePurpose.SHARED_VALUE_UPDATE) {
            var method = message.type;
            var subscriptions = this.localSharedValueSubscriptions.get(method);
            this.localSharedValuesStore.set(method, message.data);
            subscriptions === null || subscriptions === void 0 ? void 0 : subscriptions.forEach(function (callback) { return callback(message.data); });
            return;
        }
    };
    EnvelopeBusMessageManager.prototype.getNextRequestId = function () {
        return "".concat(this.name, "_").concat(this.requestIdCounter++);
    };
    return EnvelopeBusMessageManager;
}());
exports.EnvelopeBusMessageManager = EnvelopeBusMessageManager;
function cachedProxy(cache, p) {
    return new Proxy({}, {
        set: function (target, name, value) {
            cache.set(name, value);
            return true;
        },
        get: function (target, name) {
            var _a, _b;
            return (_a = cache.get(name)) !== null && _a !== void 0 ? _a : cache.set(name, (_b = p.get) === null || _b === void 0 ? void 0 : _b.call(p, target, name)).get(name);
        },
    });
}
//# sourceMappingURL=EnvelopeBusMessageManager.js.map

/***/ }),

/***/ 48869:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(84621), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 35830:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EnvelopeClient = void 0;
var api_1 = __webpack_require__(96272);
var common_1 = __webpack_require__(48869);
var EnvelopeClient = (function () {
    function EnvelopeClient(bus, envelopeId) {
        var _this = this;
        this.bus = bus;
        this.envelopeId = envelopeId;
        this.manager = new common_1.EnvelopeBusMessageManager(function (message) { return _this.send(message); }, "KogitoEnvelopeBus");
    }
    Object.defineProperty(EnvelopeClient.prototype, "channelApi", {
        get: function () {
            return this.manager.clientApi;
        },
        enumerable: false,
        configurable: true
    });
    EnvelopeClient.prototype.associate = function (origin, envelopeServerId) {
        this.targetOrigin = origin;
        this.associatedEnvelopeServerId = envelopeServerId;
    };
    EnvelopeClient.prototype.startListening = function (apiImpl) {
        var _this = this;
        if (this.eventListener) {
            return;
        }
        this.manager.currentApiImpl = apiImpl;
        this.eventListener = function (event) { return _this.receive(event.data, apiImpl); };
        window.addEventListener("message", this.eventListener);
    };
    EnvelopeClient.prototype.stopListening = function () {
        this.manager.currentApiImpl = undefined;
        window.removeEventListener("message", this.eventListener);
    };
    EnvelopeClient.prototype.send = function (message) {
        if (!this.targetOrigin || !this.associatedEnvelopeServerId) {
            throw new Error("Tried to send message without associated Envelope Server set");
        }
        this.bus.postMessage(__assign(__assign({}, message), { targetEnvelopeServerId: this.associatedEnvelopeServerId, directSender: api_1.EnvelopeBusMessageDirectSender.ENVELOPE_CLIENT }), this.targetOrigin);
    };
    EnvelopeClient.prototype.receive = function (message, apiImpl) {
        if (message.directSender === api_1.EnvelopeBusMessageDirectSender.ENVELOPE_CLIENT) {
            return;
        }
        if (this.envelopeId !== message.targetEnvelopeId) {
            return;
        }
        if (!message.targetEnvelopeServerId) {
            this.manager.server.receive(message, apiImpl);
        }
        else if (message.targetEnvelopeServerId && message.purpose === api_1.EnvelopeBusMessagePurpose.NOTIFICATION) {
            this.manager.server.receive(message, {});
        }
    };
    return EnvelopeClient;
}());
exports.EnvelopeClient = EnvelopeClient;
//# sourceMappingURL=EnvelopeClient.js.map

/***/ }),

/***/ 73264:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(35830), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 83703:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.useStateAsSharedValue = exports.useSharedValue = exports.useSubscriptionOnce = exports.useSubscription = exports.useConnectedEnvelopeServer = void 0;
var react_1 = __webpack_require__(29901);
function useConnectedEnvelopeServer(envelopeServer, apiImpl) {
    (0, react_1.useEffect)(function () {
        var listener = function (msg) { return envelopeServer.receive(msg.data, apiImpl); };
        window.addEventListener("message", listener, false);
        envelopeServer.startInitPolling(apiImpl);
        return function () {
            envelopeServer.stopInitPolling();
            window.removeEventListener("message", listener);
        };
    }, [envelopeServer, apiImpl]);
}
exports.useConnectedEnvelopeServer = useConnectedEnvelopeServer;
function useSubscription(notificationConsumer, callback) {
    (0, react_1.useEffect)(function () {
        var subscription = notificationConsumer.subscribe(callback);
        return function () {
            notificationConsumer.unsubscribe(subscription);
        };
    }, [notificationConsumer, callback]);
}
exports.useSubscription = useSubscription;
function useSubscriptionOnce(notificationConsumer, callback) {
    (0, react_1.useEffect)(function () {
        var unsubscribed = false;
        var subscription = notificationConsumer.subscribe(function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            callback.apply(void 0, __spreadArray([], __read(args), false));
            unsubscribed = true;
            notificationConsumer.unsubscribe(subscription);
        });
        return function () {
            if (!unsubscribed) {
                notificationConsumer.unsubscribe(subscription);
            }
        };
    }, [callback, notificationConsumer]);
}
exports.useSubscriptionOnce = useSubscriptionOnce;
function useSharedValue(sharedValue) {
    var _a = __read((0, react_1.useState)(), 2), value = _a[0], setValue = _a[1];
    (0, react_1.useEffect)(function () {
        if (!sharedValue) {
            return;
        }
        var subscription = sharedValue.subscribe(function (newValue) { return setValue(newValue); });
        return function () { return sharedValue.unsubscribe(subscription); };
    }, [sharedValue]);
    var sharedValueRef = (0, react_1.useRef)(sharedValue);
    var ret__setValue = (0, react_1.useCallback)(function (t) {
        var _a;
        (_a = sharedValueRef.current) === null || _a === void 0 ? void 0 : _a.set(t);
    }, []);
    (0, react_1.useEffect)(function () {
        sharedValueRef.current = sharedValue;
    }, [sharedValue]);
    return [value, ret__setValue];
}
exports.useSharedValue = useSharedValue;
function useStateAsSharedValue(value, setValue, sharedValue) {
    (0, react_1.useEffect)(function () {
        if (!sharedValue) {
            return;
        }
        var subscription = sharedValue.subscribe(function (newValue) { return setValue(newValue); });
        return function () { return sharedValue.unsubscribe(subscription); };
    }, [sharedValue, setValue]);
    (0, react_1.useEffect)(function () {
        sharedValue === null || sharedValue === void 0 ? void 0 : sharedValue.set(value);
    }, [sharedValue, value]);
}
exports.useStateAsSharedValue = useStateAsSharedValue;
//# sourceMappingURL=Hooks.js.map

/***/ }),

/***/ 59282:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(83703), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 18712:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Envelope = void 0;
var envelope_1 = __webpack_require__(73264);
var api_1 = __webpack_require__(81863);
var Envelope = (function () {
    function Envelope(bus, config, envelopeClient) {
        if (config === void 0) { config = { containerType: api_1.ContainerType.IFRAME }; }
        if (envelopeClient === void 0) { envelopeClient = new envelope_1.EnvelopeClient(bus, config.containerType === api_1.ContainerType.DIV ? config.envelopeId : undefined); }
        this.envelopeClient = envelopeClient;
    }
    Object.defineProperty(Envelope.prototype, "channelApi", {
        get: function () {
            return this.envelopeClient.channelApi;
        },
        enumerable: false,
        configurable: true
    });
    Envelope.prototype.start = function (viewDelegate, envelopeContext, apiFactory) {
        return __awaiter(this, void 0, void 0, function () {
            var apiImpl;
            return __generator(this, function (_a) {
                apiImpl = apiFactory.create({
                    viewDelegate: viewDelegate,
                    envelopeContext: envelopeContext,
                    envelopeClient: this.envelopeClient,
                });
                this.envelopeClient.startListening(apiImpl);
                return [2, this.envelopeClient];
            });
        });
    };
    return Envelope;
}());
exports.Envelope = Envelope;
//# sourceMappingURL=Envelope.js.map

/***/ }),

/***/ 3123:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=EnvelopeApiFactory.js.map

/***/ }),

/***/ 44991:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContainerType = void 0;
var ContainerType;
(function (ContainerType) {
    ContainerType["DIV"] = "div";
    ContainerType["IFRAME"] = "iframe";
})(ContainerType = exports.ContainerType || (exports.ContainerType = {}));
//# sourceMappingURL=ContainerType.js.map

/***/ }),

/***/ 81863:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(44991), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 37269:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmbeddedEnvelope = exports.RefForwardingEmbeddedEnvelope = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var channel_1 = __webpack_require__(17059);
var React = __webpack_require__(29901);
var react_1 = __webpack_require__(29901);
var hooks_1 = __webpack_require__(59282);
var api_1 = __webpack_require__(81863);
var containerStyles = {
    display: "flex",
    flex: 1,
    flexDirection: "column",
    width: "100%",
    height: "100%",
    border: "none",
    margin: 0,
    padding: 0,
    overflow: "hidden",
};
function RefForwardingEmbeddedEnvelope(props, forwardRef) {
    var iframeRef = (0, react_1.useRef)(null);
    var divRef = (0, react_1.useRef)(null);
    var bus = (0, react_1.useMemo)(function () { return ({
        postMessage: function (message) {
            var _a, _b;
            if (props.config.containerType === api_1.ContainerType.DIV) {
                window.postMessage(message, "*");
            }
            else {
                (_b = (_a = iframeRef.current) === null || _a === void 0 ? void 0 : _a.contentWindow) === null || _b === void 0 ? void 0 : _b.postMessage(message, "*");
            }
        },
    }); }, [props.config.containerType]);
    var envelopeServer = (0, react_1.useMemo)(function () {
        return new channel_1.EnvelopeServer(bus, props.origin, function (self) {
            return props.pollInit(self, function () {
                return props.config.containerType === api_1.ContainerType.DIV ? divRef.current : iframeRef.current;
            });
        }, props.config.containerType === api_1.ContainerType.DIV ? channel_1.EnvelopeServerType.LOCAL : channel_1.EnvelopeServerType.REMOTE);
    }, [bus, props.origin, props.pollInit, props.config.containerType]);
    (0, react_1.useImperativeHandle)(forwardRef, function () {
        return props.refDelegate(envelopeServer);
    }, [envelopeServer, props.refDelegate]);
    (0, hooks_1.useConnectedEnvelopeServer)(envelopeServer, props.apiImpl);
    if (props.config.containerType === api_1.ContainerType.DIV) {
        return (0, jsx_runtime_1.jsx)("div", { ref: divRef });
    }
    return (0, jsx_runtime_1.jsx)("iframe", { ref: iframeRef, src: props.config.envelopePath, style: containerStyles, title: "X" });
}
exports.RefForwardingEmbeddedEnvelope = RefForwardingEmbeddedEnvelope;
exports.EmbeddedEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedEnvelopeFactory.js.map

/***/ }),

/***/ 25937:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(37269), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 67162:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(18712), exports);
__exportStar(__webpack_require__(3123), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 3258:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=Dictionary.js.map

/***/ }),

/***/ 80432:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.I18n = void 0;
var immutableDeepMerge_1 = __webpack_require__(73703);
var I18n = (function () {
    function I18n(defaults, dictionaries, initialLocale) {
        if (initialLocale === void 0) { initialLocale = defaults.locale; }
        this.defaults = defaults;
        this.dictionaries = dictionaries;
        this.initialLocale = initialLocale;
        this.locale = initialLocale;
        this.updateDictionary();
    }
    I18n.prototype.setLocale = function (locale) {
        this.locale = locale;
        this.updateDictionary();
        return this;
    };
    I18n.prototype.updateDictionary = function () {
        var _a, _b;
        var selectedDictionary = (_b = (_a = this.dictionaries.get(this.locale)) !== null && _a !== void 0 ? _a : this.dictionaries.get(this.locale.split("-").shift())) !== null && _b !== void 0 ? _b : {};
        this.dictionary = (0, immutableDeepMerge_1.immutableDeepMerge)(this.defaults.dictionary, selectedDictionary);
        return this;
    };
    I18n.prototype.getCurrent = function () {
        return this.dictionary;
    };
    I18n.prototype.getLocale = function () {
        return this.locale;
    };
    return I18n;
}());
exports.I18n = I18n;
//# sourceMappingURL=I18n.js.map

/***/ }),

/***/ 11069:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.wrapped = void 0;
function wrapped(wrappedName) {
    return { name: wrappedName };
}
exports.wrapped = wrapped;
//# sourceMappingURL=Wrapped.js.map

/***/ }),

/***/ 73703:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.immutableDeepMerge = void 0;
function deepMerge(target, source) {
    Object.keys(source).forEach(function (key) {
        var sourceValue = source[key];
        if (!sourceValue) {
            return;
        }
        if (typeof sourceValue === "string" || typeof sourceValue === "function") {
            target[key] = sourceValue;
        }
        else {
            target[key] = deepMerge(createObjectCopy(target[key]), sourceValue);
        }
    });
    return target;
}
function immutableDeepMerge(target, source) {
    var targetCopy = createObjectCopy(target);
    return deepMerge(targetCopy, source);
}
exports.immutableDeepMerge = immutableDeepMerge;
function createObjectCopy(obj) {
    return Object.assign({}, obj);
}
//# sourceMappingURL=immutableDeepMerge.js.map

/***/ }),

/***/ 71542:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(80432), exports);
__exportStar(__webpack_require__(3258), exports);
__exportStar(__webpack_require__(11069), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 96338:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.I18nService = void 0;
var I18nService = (function () {
    function I18nService(onLocaleChangeSubscriptions) {
        if (onLocaleChangeSubscriptions === void 0) { onLocaleChangeSubscriptions = []; }
        this.onLocaleChangeSubscriptions = onLocaleChangeSubscriptions;
    }
    I18nService.prototype.executeOnLocaleChangeSubscriptions = function (locale) {
        this.onLocaleChangeSubscriptions.forEach(function (onLocaleChange) {
            onLocaleChange === null || onLocaleChange === void 0 ? void 0 : onLocaleChange(locale);
        });
    };
    I18nService.prototype.subscribeToLocaleChange = function (onLocaleChange) {
        this.onLocaleChangeSubscriptions.push(onLocaleChange);
        return onLocaleChange;
    };
    I18nService.prototype.unsubscribeToLocaleChange = function (onLocaleChange) {
        var index = this.onLocaleChangeSubscriptions.indexOf(onLocaleChange);
        if (index > -1) {
            this.onLocaleChangeSubscriptions.splice(index, 1);
        }
    };
    return I18nService;
}());
exports.I18nService = I18nService;
//# sourceMappingURL=I18nService.js.map

/***/ }),

/***/ 15517:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(96338), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 78710:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=I18nContext.js.map

/***/ }),

/***/ 34011:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.I18nDictionariesProvider = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var react_1 = __webpack_require__(29901);
var core_1 = __webpack_require__(71542);
var I18nDictionariesProvider = function (props) {
    var _a;
    var _b = __read((0, react_1.useState)((_a = props.initialLocale) !== null && _a !== void 0 ? _a : props.defaults.locale), 2), locale = _b[0], setLocale = _b[1];
    var i18n = (0, react_1.useMemo)(function () { return new core_1.I18n(props.defaults, props.dictionaries, locale); }, [locale, props.defaults, props.dictionaries]);
    var setNewLocale = (0, react_1.useCallback)(function (newLocale) {
        i18n.setLocale(newLocale);
        setLocale(newLocale);
    }, [i18n]);
    var value = (0, react_1.useMemo)(function () { return ({
        locale: locale,
        setLocale: setNewLocale,
        i18n: i18n.getCurrent(),
    }); }, [i18n, locale, setNewLocale]);
    return (0, jsx_runtime_1.jsx)(props.ctx.Provider, __assign({ value: value }, { children: props.children }));
};
exports.I18nDictionariesProvider = I18nDictionariesProvider;
//# sourceMappingURL=I18nDictionariesProvider.js.map

/***/ }),

/***/ 84524:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.I18nHtml = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
var I18nHtml = function (_a) {
    var children = _a.children;
    var htmlText = children;
    if (Array.isArray(htmlText)) {
        htmlText = htmlText.join("");
    }
    return (0, jsx_runtime_1.jsx)("p", { style: { display: "inline" }, dangerouslySetInnerHTML: { __html: htmlText } });
};
exports.I18nHtml = I18nHtml;
//# sourceMappingURL=I18nHtml.js.map

/***/ }),

/***/ 25541:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.I18nWrapped = void 0;
var jsx_runtime_1 = __webpack_require__(61250);
function I18nWrapped(props) {
    return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: Object.values(props.children).map(function (piece) {
            var _a;
            if (typeof piece === "string" || typeof piece === "number") {
                return piece;
            }
            return (_a = props.components) === null || _a === void 0 ? void 0 : _a[piece.name];
        }) }));
}
exports.I18nWrapped = I18nWrapped;
//# sourceMappingURL=I18nWrapped.js.map

/***/ }),

/***/ 66853:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(78710), exports);
__exportStar(__webpack_require__(34011), exports);
__exportStar(__webpack_require__(84524), exports);
__exportStar(__webpack_require__(25541), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 19231:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DefaultKeyboardShortcutsService = exports.ModKeys = void 0;
var operating_system_1 = __webpack_require__(88473);
var ModKeys;
(function (ModKeys) {
    ModKeys["CTRL"] = "ctrl";
    ModKeys["META"] = "meta";
    ModKeys["ALT"] = "alt";
    ModKeys["SHIFT"] = "shift";
})(ModKeys = exports.ModKeys || (exports.ModKeys = {}));
var MODIFIER_KEY_NAMES = new Map([
    ["AltLeft", "alt"],
    ["AltRight", "alt"],
    ["CtrlLeft", "ctrl"],
    ["CtrlRight", "ctrl"],
    ["MetaLeft", "meta"],
    ["MetaRight", "meta"],
    ["ShiftLeft", "shift"],
    ["ShiftRight", "shift"],
]);
var KEY_CODES = new Map([
    ["/", "Slash"],
    ["esc", "Escape"],
    ["delete", "Delete"],
    ["backspace", "Backspace"],
    ["right", "ArrowRight"],
    ["left", "ArrowLeft"],
    ["up", "ArrowUp"],
    ["down", "ArrowDown"],
    ["a", "KeyA"],
    ["b", "KeyB"],
    ["c", "KeyC"],
    ["d", "KeyD"],
    ["e", "KeyE"],
    ["f", "KeyF"],
    ["g", "KeyG"],
    ["h", "KeyH"],
    ["i", "KeyI"],
    ["j", "KeyJ"],
    ["k", "KeyK"],
    ["l", "KeyL"],
    ["m", "KeyM"],
    ["n", "KeyN"],
    ["o", "KeyO"],
    ["p", "KeyP"],
    ["q", "KeyQ"],
    ["r", "KeyR"],
    ["s", "KeyS"],
    ["t", "KeyT"],
    ["u", "KeyU"],
    ["v", "KeyV"],
    ["w", "KeyW"],
    ["x", "KeyX"],
    ["y", "KeyY"],
    ["z", "KeyZ"],
]);
var IGNORED_TAGS = ["INPUT", "TEXTAREA", "SELECT", "OPTION"];
var DefaultKeyboardShortcutsService = (function () {
    function DefaultKeyboardShortcutsService(args) {
        this.args = args;
        this.eventIdentifiers = 1;
        this.keyBindings = new Map();
    }
    DefaultKeyboardShortcutsService.prototype.registerKeyDownThenUp = function (combination, label, onKeyDown, onKeyUp, opts) {
        var _this = this;
        console.debug("Registering shortcut (down/up) for ".concat(combination, " - ").concat(label, ": ").concat(opts === null || opts === void 0 ? void 0 : opts.repeat));
        var keyBinding = {
            combination: combination,
            label: label,
            listener: function (event) {
                var _a;
                var keyboardEvent = getProcessableKeyboardEvent(combination, event, opts);
                if (!keyboardEvent) {
                    return true;
                }
                if (keyboardEvent.type === "keydown") {
                    if (setsEqual(_this.combinationKeySet(combination), _this.pressedKeySet(keyboardEvent))) {
                        console.debug("Fired (down) [".concat(combination, "]!"));
                        onKeyDown(keyboardEvent.target);
                        return false;
                    }
                }
                else if (keyboardEvent.type === "keyup") {
                    if (_this.combinationKeySet(combination).has((_a = MODIFIER_KEY_NAMES.get(keyboardEvent.code)) !== null && _a !== void 0 ? _a : "") ||
                        _this.combinationKeySet(combination).has(keyboardEvent.code)) {
                        console.debug("Fired (up) [".concat(combination, "]!"));
                        onKeyUp(keyboardEvent.target);
                        return false;
                    }
                }
                return true;
            },
            opts: opts,
        };
        this.keyBindings.set(this.eventIdentifiers, keyBinding);
        this.keyBindingElement(keyBinding).addEventListener("keydown", keyBinding.listener);
        this.keyBindingElement(keyBinding).addEventListener("keyup", keyBinding.listener);
        return this.eventIdentifiers++;
    };
    DefaultKeyboardShortcutsService.prototype.registerKeyPress = function (combination, label, onKeyPress, opts) {
        var _this = this;
        console.debug("Registering shortcut (press) for ".concat(combination, " - ").concat(label, ": ").concat(opts === null || opts === void 0 ? void 0 : opts.repeat));
        var keyBinding = {
            combination: combination,
            label: label,
            listener: function (event) {
                var keyboardEvent = getProcessableKeyboardEvent(combination, event, opts);
                if (!keyboardEvent) {
                    return true;
                }
                if (setsEqual(_this.combinationKeySet(combination), _this.pressedKeySet(keyboardEvent))) {
                    console.debug("Fired (press) [".concat(combination, "]!"));
                    onKeyPress(keyboardEvent.target);
                    return false;
                }
                return true;
            },
            opts: opts,
        };
        this.keyBindings.set(this.eventIdentifiers, keyBinding);
        this.keyBindingElement(keyBinding).addEventListener("keydown", keyBinding.listener);
        return this.eventIdentifiers++;
    };
    DefaultKeyboardShortcutsService.prototype.registerKeyPressOnce = function (combination, onKeyPress, opts) {
        var _this = this;
        var id = this.registerKeyPress(combination, "", function (target) { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                onKeyPress(target);
                this.deregister(id);
                return [2];
            });
        }); }, opts ? __assign(__assign({}, opts), { hidden: true }) : opts);
        return id;
    };
    DefaultKeyboardShortcutsService.prototype.deregister = function (id) {
        var keyBinding = this.keyBindings.get(id);
        if (!keyBinding) {
            console.error("Unable to de-register keyboard shortcut with id ".concat(id, " because it was not registered."));
            return;
        }
        this.keyBindingElement(keyBinding).removeEventListener("keypress", keyBinding === null || keyBinding === void 0 ? void 0 : keyBinding.listener);
        this.keyBindingElement(keyBinding).removeEventListener("keydown", keyBinding === null || keyBinding === void 0 ? void 0 : keyBinding.listener);
        this.keyBindingElement(keyBinding).removeEventListener("keyup", keyBinding === null || keyBinding === void 0 ? void 0 : keyBinding.listener);
        this.keyBindings.delete(id);
    };
    DefaultKeyboardShortcutsService.prototype.keyBindingElement = function (keyBinding) {
        var _a, _b;
        return (_b = (_a = keyBinding === null || keyBinding === void 0 ? void 0 : keyBinding.opts) === null || _a === void 0 ? void 0 : _a.element) !== null && _b !== void 0 ? _b : window;
    };
    DefaultKeyboardShortcutsService.prototype.combinationKeySet = function (combination) {
        var keys = combination
            .split("+")
            .map(function (k) { return k.toLowerCase(); })
            .map(function (k) { var _a; return (_a = KEY_CODES.get(k)) !== null && _a !== void 0 ? _a : k; });
        if (this.args.os === operating_system_1.OperatingSystem.MACOS) {
            return new Set(keys.map(function (k) { return (k === ModKeys.CTRL ? ModKeys.META : k); }));
        }
        else {
            return new Set(keys);
        }
    };
    DefaultKeyboardShortcutsService.prototype.pressedKeySet = function (e) {
        var pressedKeySet = new Set();
        if (e.ctrlKey) {
            pressedKeySet.add(ModKeys.CTRL);
        }
        if (e.metaKey) {
            pressedKeySet.add(ModKeys.META);
        }
        if (e.altKey) {
            pressedKeySet.add(ModKeys.ALT);
        }
        if (e.shiftKey) {
            pressedKeySet.add(ModKeys.SHIFT);
        }
        if (Array.from(MODIFIER_KEY_NAMES.keys()).indexOf(e.code) === -1) {
            pressedKeySet.add(e.code);
        }
        return pressedKeySet;
    };
    DefaultKeyboardShortcutsService.prototype.registered = function () {
        return Array.from(this.keyBindings.values());
    };
    DefaultKeyboardShortcutsService.prototype.isEnabled = function () {
        return true;
    };
    return DefaultKeyboardShortcutsService;
}());
exports.DefaultKeyboardShortcutsService = DefaultKeyboardShortcutsService;
function getProcessableKeyboardEvent(combination, event, opts) {
    if (event instanceof CustomEvent && IGNORED_TAGS.includes(event.detail.channelOriginalTargetTagName)) {
        console.debug("Ignoring execution (".concat(combination, ") because target is ").concat(event.detail.channelOriginalTargetTagName));
        return null;
    }
    var keyboardEvent = event instanceof CustomEvent ? new KeyboardEvent(event.detail.type, event.detail) : event;
    if (keyboardEvent.target instanceof Element && IGNORED_TAGS.includes(keyboardEvent.target.tagName)) {
        console.debug("Ignoring execution (".concat(combination, ") because target is ").concat(keyboardEvent.target.tagName));
        return null;
    }
    if (keyboardEvent.repeat && !(opts === null || opts === void 0 ? void 0 : opts.repeat)) {
        return null;
    }
    return keyboardEvent;
}
function setsEqual(lhs, rhs) {
    var e_1, _a;
    if (lhs.size !== rhs.size) {
        return false;
    }
    try {
        for (var lhs_1 = __values(lhs), lhs_1_1 = lhs_1.next(); !lhs_1_1.done; lhs_1_1 = lhs_1.next()) {
            var a = lhs_1_1.value;
            if (!rhs.has(a)) {
                return false;
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (lhs_1_1 && !lhs_1_1.done && (_a = lhs_1.return)) _a.call(lhs_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return true;
}
//# sourceMappingURL=DefaultKeyboardShortcutsService.js.map

/***/ }),

/***/ 49332:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=KeyboardShortcutRegisterOpts.js.map

/***/ }),

/***/ 26612:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=KeyboardShortcutsService.js.map

/***/ }),

/***/ 886:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NoOpKeyboardShortcutsService = void 0;
var NoOpKeyboardShortcutsService = (function () {
    function NoOpKeyboardShortcutsService() {
    }
    NoOpKeyboardShortcutsService.prototype.registerKeyDownThenUp = function (combination, label, onKeyDown, onKeyUp, opts) {
        return 0;
    };
    NoOpKeyboardShortcutsService.prototype.registerKeyPress = function (combination, label, onKeyPress, opts) {
        return 0;
    };
    NoOpKeyboardShortcutsService.prototype.registerKeyPressOnce = function (combination, onKeyPress, opts) {
        return 0;
    };
    NoOpKeyboardShortcutsService.prototype.deregister = function (id) {
    };
    NoOpKeyboardShortcutsService.prototype.registered = function () {
        return [];
    };
    NoOpKeyboardShortcutsService.prototype.isEnabled = function () {
        return false;
    };
    return NoOpKeyboardShortcutsService;
}());
exports.NoOpKeyboardShortcutsService = NoOpKeyboardShortcutsService;
//# sourceMappingURL=NoOpKeyboardShortcutsService.js.map

/***/ }),

/***/ 56215:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(19231), exports);
__exportStar(__webpack_require__(49332), exports);
__exportStar(__webpack_require__(26612), exports);
__exportStar(__webpack_require__(886), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 2777:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getOperatingSystem = exports.OperatingSystem = void 0;
var OperatingSystem;
(function (OperatingSystem) {
    OperatingSystem["MACOS"] = "MACOS";
    OperatingSystem["WINDOWS"] = "WINDOWS";
    OperatingSystem["LINUX"] = "LINUX";
})(OperatingSystem = exports.OperatingSystem || (exports.OperatingSystem = {}));
function getOperatingSystem() {
    if (navigator.appVersion.indexOf("Win") !== -1) {
        return OperatingSystem.WINDOWS;
    }
    if (navigator.appVersion.indexOf("Mac") !== -1) {
        return OperatingSystem.MACOS;
    }
    if (navigator.appVersion.indexOf("X11") !== -1) {
        return OperatingSystem.LINUX;
    }
    if (navigator.appVersion.indexOf("Linux") !== -1) {
        return OperatingSystem.LINUX;
    }
    return undefined;
}
exports.getOperatingSystem = getOperatingSystem;
//# sourceMappingURL=OperatingSystem.js.map

/***/ }),

/***/ 88473:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(2777), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 87051:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContentType = void 0;
var ContentType;
(function (ContentType) {
    ContentType["TEXT"] = "text";
    ContentType["BINARY"] = "binary";
})(ContentType = exports.ContentType || (exports.ContentType = {}));
//# sourceMappingURL=ContentType.js.map

/***/ }),

/***/ 51468:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ResourceContent = void 0;
var ContentType_1 = __webpack_require__(87051);
var ResourceContent = (function () {
    function ResourceContent(path, content, type) {
        this.path = path;
        this.content = content;
        this.type = type || ContentType_1.ContentType.TEXT;
    }
    return ResourceContent;
}());
exports.ResourceContent = ResourceContent;
//# sourceMappingURL=ResourceContent.js.map

/***/ }),

/***/ 36913:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=ResourceContentOptions.js.map

/***/ }),

/***/ 46937:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=ResourceContentRequest.js.map

/***/ }),

/***/ 68143:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=ResourceContentService.js.map

/***/ }),

/***/ 30205:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=ResourceListOptions.js.map

/***/ }),

/***/ 56071:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=ResourceListRequest.js.map

/***/ }),

/***/ 24627:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ResourcesList = void 0;
var ResourcesList = (function () {
    function ResourcesList(pattern, paths) {
        this.pattern = pattern;
        this.paths = paths;
    }
    return ResourcesList;
}());
exports.ResourcesList = ResourcesList;
//# sourceMappingURL=ResourcesList.js.map

/***/ }),

/***/ 16595:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchType = void 0;
var SearchType;
(function (SearchType) {
    SearchType["TRAVERSAL"] = "traversal";
    SearchType["ASSET_FOLDER"] = "asset-folder";
})(SearchType = exports.SearchType || (exports.SearchType = {}));
//# sourceMappingURL=SearchType.js.map

/***/ }),

/***/ 27516:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
//# sourceMappingURL=WorkspaceChannelApi.js.map

/***/ }),

/***/ 82838:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WorkspaceEdit = void 0;
var WorkspaceEdit = (function () {
    function WorkspaceEdit(id) {
        this.id = id;
    }
    return WorkspaceEdit;
}());
exports.WorkspaceEdit = WorkspaceEdit;
//# sourceMappingURL=WorkspaceEdit.js.map

/***/ }),

/***/ 38830:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(27516), exports);
__exportStar(__webpack_require__(36913), exports);
__exportStar(__webpack_require__(30205), exports);
__exportStar(__webpack_require__(16595), exports);
__exportStar(__webpack_require__(46937), exports);
__exportStar(__webpack_require__(68143), exports);
__exportStar(__webpack_require__(82838), exports);
__exportStar(__webpack_require__(24627), exports);
__exportStar(__webpack_require__(56071), exports);
__exportStar(__webpack_require__(51468), exports);
__exportStar(__webpack_require__(87051), exports);
//# sourceMappingURL=index.js.map

/***/ }),

/***/ 59161:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  ASTERISK: () => (/* reexport */ ASTERISK),
  AboutModal: () => (/* reexport */ AboutModal),
  Accordion: () => (/* reexport */ Accordion),
  AccordionContent: () => (/* reexport */ AccordionContent),
  AccordionExpandedContentBody: () => (/* reexport */ AccordionExpandedContentBody),
  AccordionItem: () => (/* reexport */ AccordionItem),
  AccordionToggle: () => (/* reexport */ AccordionToggle),
  ActionGroup: () => (/* reexport */ ActionGroup),
  ActionList: () => (/* reexport */ ActionList),
  ActionListGroup: () => (/* reexport */ ActionListGroup),
  ActionListItem: () => (/* reexport */ ActionListItem),
  Alert: () => (/* reexport */ Alert),
  AlertActionCloseButton: () => (/* reexport */ AlertActionCloseButton),
  AlertActionLink: () => (/* reexport */ AlertActionLink),
  AlertContext: () => (/* reexport */ AlertContext),
  AlertGroup: () => (/* reexport */ AlertGroup),
  AlertVariant: () => (/* reexport */ AlertVariant),
  ApplicationLauncher: () => (/* reexport */ ApplicationLauncher),
  ApplicationLauncherContent: () => (/* reexport */ ApplicationLauncherContent),
  ApplicationLauncherContext: () => (/* reexport */ ApplicationLauncherContext),
  ApplicationLauncherGroup: () => (/* reexport */ ApplicationLauncherGroup),
  ApplicationLauncherIcon: () => (/* reexport */ ApplicationLauncherIcon),
  ApplicationLauncherItem: () => (/* reexport */ ApplicationLauncherItem),
  ApplicationLauncherItemContext: () => (/* reexport */ ApplicationLauncherItemContext),
  ApplicationLauncherSeparator: () => (/* reexport */ ApplicationLauncherSeparator),
  ApplicationLauncherText: () => (/* reexport */ ApplicationLauncherText),
  Avatar: () => (/* reexport */ Avatar),
  BackToTop: () => (/* reexport */ BackToTop),
  Backdrop: () => (/* reexport */ Backdrop),
  BackgroundImage: () => (/* reexport */ BackgroundImage),
  Badge: () => (/* reexport */ Badge),
  BadgeToggle: () => (/* reexport */ BadgeToggle),
  Banner: () => (/* reexport */ Banner),
  BaseSizes: () => (/* reexport */ BaseSizes),
  Brand: () => (/* reexport */ Brand),
  Breadcrumb: () => (/* reexport */ Breadcrumb),
  BreadcrumbHeading: () => (/* reexport */ BreadcrumbHeading),
  BreadcrumbItem: () => (/* reexport */ BreadcrumbItem),
  Bullseye: () => (/* reexport */ Bullseye),
  Button: () => (/* reexport */ Button),
  ButtonType: () => (/* reexport */ ButtonType),
  ButtonVariant: () => (/* reexport */ ButtonVariant),
  CalendarMonth: () => (/* reexport */ CalendarMonth),
  Card: () => (/* reexport */ Card),
  CardActions: () => (/* reexport */ CardActions),
  CardBody: () => (/* reexport */ CardBody),
  CardContext: () => (/* reexport */ CardContext),
  CardExpandableContent: () => (/* reexport */ CardExpandableContent),
  CardFooter: () => (/* reexport */ CardFooter),
  CardHeader: () => (/* reexport */ CardHeader),
  CardHeaderMain: () => (/* reexport */ CardHeaderMain),
  CardTitle: () => (/* reexport */ CardTitle),
  Checkbox: () => (/* reexport */ Checkbox),
  Chip: () => (/* reexport */ Chip),
  ChipGroup: () => (/* reexport */ ChipGroup),
  ClipboardCopy: () => (/* reexport */ ClipboardCopy),
  ClipboardCopyAction: () => (/* reexport */ ClipboardCopyAction),
  ClipboardCopyButton: () => (/* reexport */ ClipboardCopyButton),
  ClipboardCopyVariant: () => (/* reexport */ ClipboardCopyVariant),
  CodeBlock: () => (/* reexport */ CodeBlock),
  CodeBlockAction: () => (/* reexport */ CodeBlockAction),
  CodeBlockCode: () => (/* reexport */ CodeBlockCode),
  ContextSelector: () => (/* reexport */ ContextSelector),
  ContextSelectorFooter: () => (/* reexport */ ContextSelectorFooter),
  ContextSelectorItem: () => (/* reexport */ ContextSelectorItem),
  DataList: () => (/* reexport */ DataList),
  DataListAction: () => (/* reexport */ DataListAction),
  DataListCell: () => (/* reexport */ DataListCell),
  DataListCheck: () => (/* reexport */ DataListCheck),
  DataListContent: () => (/* reexport */ DataListContent),
  DataListContext: () => (/* reexport */ DataListContext),
  DataListControl: () => (/* reexport */ DataListControl),
  DataListDragButton: () => (/* reexport */ DataListDragButton),
  DataListItem: () => (/* reexport */ DataListItem),
  DataListItemCells: () => (/* reexport */ DataListItemCells),
  DataListItemRow: () => (/* reexport */ DataListItemRow),
  DataListText: () => (/* reexport */ DataListText),
  DataListToggle: () => (/* reexport */ DataListToggle),
  DataListWrapModifier: () => (/* reexport */ DataListWrapModifier),
  DatePicker: () => (/* reexport */ DatePicker),
  DescriptionList: () => (/* reexport */ DescriptionList),
  DescriptionListDescription: () => (/* reexport */ DescriptionListDescription),
  DescriptionListGroup: () => (/* reexport */ DescriptionListGroup),
  DescriptionListTerm: () => (/* reexport */ DescriptionListTerm),
  DescriptionListTermHelpText: () => (/* reexport */ DescriptionListTermHelpText),
  DescriptionListTermHelpTextButton: () => (/* reexport */ DescriptionListTermHelpTextButton),
  DeviceSizes: () => (/* reexport */ DeviceSizes),
  Divider: () => (/* reexport */ Divider),
  DividerVariant: () => (/* reexport */ DividerVariant),
  DragDrop: () => (/* reexport */ DragDrop),
  DragDropContext: () => (/* reexport */ DragDropContext),
  Draggable: () => (/* reexport */ Draggable),
  Drawer: () => (/* reexport */ Drawer),
  DrawerActions: () => (/* reexport */ DrawerActions),
  DrawerCloseButton: () => (/* reexport */ DrawerCloseButton),
  DrawerColorVariant: () => (/* reexport */ DrawerColorVariant),
  DrawerContent: () => (/* reexport */ DrawerContent),
  DrawerContentBody: () => (/* reexport */ DrawerContentBody),
  DrawerContext: () => (/* reexport */ DrawerContext),
  DrawerHead: () => (/* reexport */ DrawerHead),
  DrawerPanelBody: () => (/* reexport */ DrawerPanelBody),
  DrawerPanelContent: () => (/* reexport */ DrawerPanelContent),
  DrawerSection: () => (/* reexport */ DrawerSection),
  DrilldownMenu: () => (/* reexport */ DrilldownMenu),
  Dropdown: () => (/* reexport */ Dropdown),
  DropdownArrowContext: () => (/* reexport */ DropdownArrowContext),
  DropdownContext: () => (/* reexport */ DropdownContext),
  DropdownDirection: () => (/* reexport */ DropdownDirection),
  DropdownGroup: () => (/* reexport */ DropdownGroup),
  DropdownItem: () => (/* reexport */ DropdownItem),
  DropdownMenu: () => (/* reexport */ DropdownMenu),
  DropdownPosition: () => (/* reexport */ DropdownPosition),
  DropdownSeparator: () => (/* reexport */ DropdownSeparator),
  DropdownToggle: () => (/* reexport */ DropdownToggle),
  DropdownToggleAction: () => (/* reexport */ DropdownToggleAction),
  DropdownToggleCheckbox: () => (/* reexport */ DropdownToggleCheckbox),
  DropdownWithContext: () => (/* reexport */ DropdownWithContext),
  Droppable: () => (/* reexport */ Droppable),
  DualListSelector: () => (/* reexport */ DualListSelector),
  DualListSelectorControl: () => (/* reexport */ DualListSelectorControl),
  DualListSelectorControlBase: () => (/* reexport */ DualListSelectorControlBase),
  DualListSelectorControlsWrapper: () => (/* reexport */ DualListSelectorControlsWrapper),
  DualListSelectorControlsWrapperBase: () => (/* reexport */ DualListSelectorControlsWrapperBase),
  DualListSelectorList: () => (/* reexport */ DualListSelectorList),
  DualListSelectorListItem: () => (/* reexport */ DualListSelectorListItem),
  DualListSelectorListItemBase: () => (/* reexport */ DualListSelectorListItemBase),
  DualListSelectorPane: () => (/* reexport */ DualListSelectorPane),
  DualListSelectorTree: () => (/* reexport */ DualListSelectorTree),
  EmptyState: () => (/* reexport */ EmptyState),
  EmptyStateBody: () => (/* reexport */ EmptyStateBody),
  EmptyStateIcon: () => (/* reexport */ EmptyStateIcon),
  EmptyStatePrimary: () => (/* reexport */ EmptyStatePrimary),
  EmptyStateSecondaryActions: () => (/* reexport */ EmptyStateSecondaryActions),
  EmptyStateVariant: () => (/* reexport */ EmptyStateVariant),
  ExpandableSection: () => (/* reexport */ ExpandableSection),
  ExpandableSectionToggle: () => (/* reexport */ ExpandableSectionToggle),
  ExpandableSectionVariant: () => (/* reexport */ ExpandableSectionVariant),
  FileUpload: () => (/* reexport */ FileUpload),
  FileUploadField: () => (/* reexport */ FileUploadField),
  Flex: () => (/* reexport */ Flex),
  FlexItem: () => (/* reexport */ FlexItem),
  FocusTrap: () => (/* reexport */ FocusTrap),
  Form: () => (/* reexport */ Form),
  FormAlert: () => (/* reexport */ FormAlert),
  FormFieldGroup: () => (/* reexport */ FormFieldGroup),
  FormFieldGroupExpandable: () => (/* reexport */ FormFieldGroupExpandable),
  FormFieldGroupHeader: () => (/* reexport */ FormFieldGroupHeader),
  FormGroup: () => (/* reexport */ FormGroup),
  FormHelperText: () => (/* reexport */ FormHelperText),
  FormSection: () => (/* reexport */ FormSection),
  FormSelect: () => (/* reexport */ FormSelect),
  FormSelectOption: () => (/* reexport */ FormSelectOption),
  FormSelectOptionGroup: () => (/* reexport */ FormSelectOptionGroup),
  Gallery: () => (/* reexport */ Gallery),
  GalleryItem: () => (/* reexport */ GalleryItem),
  GenerateId: () => (/* reexport */ GenerateId),
  Grid: () => (/* reexport */ Grid),
  GridItem: () => (/* reexport */ GridItem),
  HelperText: () => (/* reexport */ HelperText),
  HelperTextItem: () => (/* reexport */ HelperTextItem),
  Hint: () => (/* reexport */ Hint),
  HintBody: () => (/* reexport */ HintBody),
  HintFooter: () => (/* reexport */ HintFooter),
  HintTitle: () => (/* reexport */ HintTitle),
  Icon: () => (/* reexport */ Icon),
  InputGroup: () => (/* reexport */ InputGroup),
  InputGroupText: () => (/* reexport */ InputGroupText),
  InputGroupTextVariant: () => (/* reexport */ InputGroupTextVariant),
  JumpLinks: () => (/* reexport */ JumpLinks),
  JumpLinksItem: () => (/* reexport */ JumpLinksItem),
  JumpLinksList: () => (/* reexport */ JumpLinksList),
  KEYHANDLER_DIRECTION: () => (/* reexport */ KEYHANDLER_DIRECTION),
  KEY_CODES: () => (/* reexport */ KEY_CODES),
  KebabToggle: () => (/* reexport */ KebabToggle),
  KeyTypes: () => (/* reexport */ KeyTypes),
  KeyboardHandler: () => (/* reexport */ KeyboardHandler),
  Label: () => (/* reexport */ Label),
  LabelGroup: () => (/* reexport */ LabelGroup),
  Level: () => (/* reexport */ Level),
  LevelItem: () => (/* reexport */ LevelItem),
  List: () => (/* reexport */ List),
  ListComponent: () => (/* reexport */ ListComponent),
  ListItem: () => (/* reexport */ ListItem),
  ListVariant: () => (/* reexport */ ListVariant),
  Login: () => (/* reexport */ Login),
  LoginFooter: () => (/* reexport */ LoginFooter),
  LoginFooterItem: () => (/* reexport */ LoginFooterItem),
  LoginForm: () => (/* reexport */ LoginForm),
  LoginHeader: () => (/* reexport */ LoginHeader),
  LoginMainBody: () => (/* reexport */ LoginMainBody),
  LoginMainFooter: () => (/* reexport */ LoginMainFooter),
  LoginMainFooterBandItem: () => (/* reexport */ LoginMainFooterBandItem),
  LoginMainFooterLinksItem: () => (/* reexport */ LoginMainFooterLinksItem),
  LoginMainHeader: () => (/* reexport */ LoginMainHeader),
  LoginPage: () => (/* reexport */ LoginPage),
  Masthead: () => (/* reexport */ Masthead),
  MastheadBrand: () => (/* reexport */ MastheadBrand),
  MastheadContent: () => (/* reexport */ MastheadContent),
  MastheadMain: () => (/* reexport */ MastheadMain),
  MastheadToggle: () => (/* reexport */ MastheadToggle),
  Menu: () => (/* reexport */ Menu),
  MenuBreadcrumb: () => (/* reexport */ MenuBreadcrumb),
  MenuContent: () => (/* reexport */ MenuContent),
  MenuFooter: () => (/* reexport */ MenuFooter),
  MenuGroup: () => (/* reexport */ MenuGroup),
  MenuInput: () => (/* reexport */ MenuInput),
  MenuItem: () => (/* reexport */ MenuItem),
  MenuItemAction: () => (/* reexport */ MenuItemAction),
  MenuList: () => (/* reexport */ MenuList),
  MenuToggle: () => (/* reexport */ MenuToggle),
  MenuToggleAction: () => (/* reexport */ MenuToggleAction),
  MenuToggleBase: () => (/* reexport */ MenuToggleBase),
  MenuToggleCheckbox: () => (/* reexport */ MenuToggleCheckbox),
  Modal: () => (/* reexport */ Modal),
  ModalBox: () => (/* reexport */ ModalBox),
  ModalBoxBody: () => (/* reexport */ ModalBoxBody),
  ModalBoxCloseButton: () => (/* reexport */ ModalBoxCloseButton),
  ModalBoxFooter: () => (/* reexport */ ModalBoxFooter),
  ModalBoxHeader: () => (/* reexport */ ModalBoxHeader),
  ModalContent: () => (/* reexport */ ModalContent),
  ModalVariant: () => (/* reexport */ ModalVariant),
  MultipleFileUpload: () => (/* reexport */ MultipleFileUpload),
  MultipleFileUploadContext: () => (/* reexport */ MultipleFileUploadContext),
  MultipleFileUploadMain: () => (/* reexport */ MultipleFileUploadMain),
  MultipleFileUploadStatus: () => (/* reexport */ MultipleFileUploadStatus),
  MultipleFileUploadStatusItem: () => (/* reexport */ MultipleFileUploadStatusItem),
  Nav: () => (/* reexport */ Nav),
  NavContext: () => (/* reexport */ NavContext),
  NavExpandable: () => (/* reexport */ NavExpandable),
  NavGroup: () => (/* reexport */ NavGroup),
  NavItem: () => (/* reexport */ NavItem),
  NavItemSeparator: () => (/* reexport */ NavItemSeparator),
  NavList: () => (/* reexport */ NavList),
  NotificationBadge: () => (/* reexport */ NotificationBadge),
  NotificationBadgeVariant: () => (/* reexport */ NotificationBadgeVariant),
  NotificationDrawer: () => (/* reexport */ NotificationDrawer),
  NotificationDrawerBody: () => (/* reexport */ NotificationDrawerBody),
  NotificationDrawerGroup: () => (/* reexport */ NotificationDrawerGroup),
  NotificationDrawerGroupList: () => (/* reexport */ NotificationDrawerGroupList),
  NotificationDrawerHeader: () => (/* reexport */ NotificationDrawerHeader),
  NotificationDrawerList: () => (/* reexport */ NotificationDrawerList),
  NotificationDrawerListItem: () => (/* reexport */ NotificationDrawerListItem),
  NotificationDrawerListItemBody: () => (/* reexport */ NotificationDrawerListItemBody),
  NotificationDrawerListItemHeader: () => (/* reexport */ NotificationDrawerListItemHeader),
  NumberInput: () => (/* reexport */ NumberInput),
  OptionsMenu: () => (/* reexport */ OptionsMenu),
  OptionsMenuDirection: () => (/* reexport */ OptionsMenuDirection),
  OptionsMenuItem: () => (/* reexport */ OptionsMenuItem),
  OptionsMenuItemGroup: () => (/* reexport */ OptionsMenuItemGroup),
  OptionsMenuPosition: () => (/* reexport */ OptionsMenuPosition),
  OptionsMenuSeparator: () => (/* reexport */ OptionsMenuSeparator),
  OptionsMenuToggle: () => (/* reexport */ OptionsMenuToggle),
  OptionsMenuToggleWithText: () => (/* reexport */ OptionsMenuToggleWithText),
  OrderType: () => (/* reexport */ OrderType),
  OverflowMenu: () => (/* reexport */ OverflowMenu),
  OverflowMenuContent: () => (/* reexport */ OverflowMenuContent),
  OverflowMenuControl: () => (/* reexport */ OverflowMenuControl),
  OverflowMenuDropdownItem: () => (/* reexport */ OverflowMenuDropdownItem),
  OverflowMenuGroup: () => (/* reexport */ OverflowMenuGroup),
  OverflowMenuItem: () => (/* reexport */ OverflowMenuItem),
  Page: () => (/* reexport */ Page),
  PageBreadcrumb: () => (/* reexport */ PageBreadcrumb),
  PageContext: () => (/* reexport */ PageContext),
  PageContextConsumer: () => (/* reexport */ PageContextConsumer),
  PageContextProvider: () => (/* reexport */ PageContextProvider),
  PageGroup: () => (/* reexport */ PageGroup),
  PageHeader: () => (/* reexport */ PageHeader),
  PageHeaderTools: () => (/* reexport */ PageHeaderTools),
  PageHeaderToolsGroup: () => (/* reexport */ PageHeaderToolsGroup),
  PageHeaderToolsItem: () => (/* reexport */ PageHeaderToolsItem),
  PageLayouts: () => (/* reexport */ PageLayouts),
  PageNavigation: () => (/* reexport */ PageNavigation),
  PageSection: () => (/* reexport */ PageSection),
  PageSectionTypes: () => (/* reexport */ PageSectionTypes),
  PageSectionVariants: () => (/* reexport */ PageSectionVariants),
  PageSidebar: () => (/* reexport */ PageSidebar),
  PageSidebarContext: () => (/* reexport */ PageSidebarContext),
  PageToggleButton: () => (/* reexport */ PageToggleButton),
  Pagination: () => (/* reexport */ Pagination),
  PaginationVariant: () => (/* reexport */ PaginationVariant),
  Panel: () => (/* reexport */ Panel),
  PanelFooter: () => (/* reexport */ PanelFooter),
  PanelHeader: () => (/* reexport */ PanelHeader),
  PanelMain: () => (/* reexport */ PanelMain),
  PanelMainBody: () => (/* reexport */ PanelMainBody),
  Popover: () => (/* reexport */ Popover),
  PopoverPosition: () => (/* reexport */ PopoverPosition),
  Popper: () => (/* reexport */ Popper_Popper),
  Progress: () => (/* reexport */ Progress),
  ProgressBar: () => (/* reexport */ ProgressBar),
  ProgressContainer: () => (/* reexport */ ProgressContainer),
  ProgressMeasureLocation: () => (/* reexport */ ProgressMeasureLocation),
  ProgressSize: () => (/* reexport */ ProgressSize),
  ProgressStep: () => (/* reexport */ ProgressStep),
  ProgressStepVariant: () => (/* reexport */ ProgressStepVariant),
  ProgressStepper: () => (/* reexport */ ProgressStepper),
  ProgressVariant: () => (/* reexport */ ProgressVariant),
  Radio: () => (/* reexport */ Radio),
  SIDE: () => (/* reexport */ SIDE),
  SearchInput: () => (/* reexport */ SearchInput),
  Select: () => (/* reexport */ Select),
  SelectConsumer: () => (/* reexport */ SelectConsumer),
  SelectContext: () => (/* reexport */ SelectContext),
  SelectDirection: () => (/* reexport */ SelectDirection),
  SelectFooterTabbableItems: () => (/* reexport */ SelectFooterTabbableItems),
  SelectGroup: () => (/* reexport */ SelectGroup),
  SelectOption: () => (/* reexport */ SelectOption),
  SelectPosition: () => (/* reexport */ SelectPosition),
  SelectProvider: () => (/* reexport */ SelectProvider),
  SelectVariant: () => (/* reexport */ SelectVariant),
  Sidebar: () => (/* reexport */ Sidebar),
  SidebarContent: () => (/* reexport */ SidebarContent),
  SidebarPanel: () => (/* reexport */ SidebarPanel),
  SidebarPanelWidthType: () => (/* reexport */ SidebarPanelWidthType),
  SimpleList: () => (/* reexport */ SimpleList),
  SimpleListContext: () => (/* reexport */ SimpleListContext),
  SimpleListGroup: () => (/* reexport */ SimpleListGroup),
  SimpleListItem: () => (/* reexport */ SimpleListItem),
  Skeleton: () => (/* reexport */ Skeleton),
  SkipToContent: () => (/* reexport */ SkipToContent),
  Slider: () => (/* reexport */ Slider),
  Spinner: () => (/* reexport */ Spinner),
  Split: () => (/* reexport */ Split),
  SplitItem: () => (/* reexport */ SplitItem),
  Stack: () => (/* reexport */ Stack),
  StackItem: () => (/* reexport */ StackItem),
  Switch: () => (/* reexport */ Switch),
  Tab: () => (/* reexport */ Tab),
  TabAction: () => (/* reexport */ TabAction),
  TabContent: () => (/* reexport */ TabContent),
  TabContentBody: () => (/* reexport */ TabContentBody),
  TabTitleIcon: () => (/* reexport */ TabTitleIcon),
  TabTitleText: () => (/* reexport */ TabTitleText),
  Tabs: () => (/* reexport */ Tabs),
  TabsComponent: () => (/* reexport */ TabsComponent),
  TabsContext: () => (/* reexport */ TabsContext),
  TabsContextConsumer: () => (/* reexport */ TabsContextConsumer),
  TabsContextProvider: () => (/* reexport */ TabsContextProvider),
  Text: () => (/* reexport */ Text),
  TextAreResizeOrientation: () => (/* reexport */ TextAreResizeOrientation),
  TextArea: () => (/* reexport */ TextArea),
  TextAreaBase: () => (/* reexport */ TextAreaBase),
  TextAreaReadOnlyVariant: () => (/* reexport */ TextAreaReadOnlyVariant),
  TextContent: () => (/* reexport */ TextContent),
  TextInput: () => (/* reexport */ TextInput),
  TextInputBase: () => (/* reexport */ TextInputBase),
  TextInputGroup: () => (/* reexport */ TextInputGroup),
  TextInputGroupContext: () => (/* reexport */ TextInputGroupContext),
  TextInputGroupMain: () => (/* reexport */ TextInputGroupMain),
  TextInputGroupUtilities: () => (/* reexport */ TextInputGroupUtilities),
  TextInputReadOnlyVariant: () => (/* reexport */ TextInputReadOnlyVariant),
  TextInputTypes: () => (/* reexport */ TextInputTypes),
  TextList: () => (/* reexport */ TextList),
  TextListItem: () => (/* reexport */ TextListItem),
  TextListItemVariants: () => (/* reexport */ TextListItemVariants),
  TextListVariants: () => (/* reexport */ TextListVariants),
  TextVariants: () => (/* reexport */ TextVariants),
  Tile: () => (/* reexport */ Tile),
  TimePicker: () => (/* reexport */ TimePicker),
  Timestamp: () => (/* reexport */ Timestamp),
  TimestampFormat: () => (/* reexport */ TimestampFormat),
  TimestampTooltipVariant: () => (/* reexport */ TimestampTooltipVariant),
  Title: () => (/* reexport */ Title),
  TitleSizes: () => (/* reexport */ TitleSizes),
  ToggleGroup: () => (/* reexport */ ToggleGroup),
  ToggleGroupItem: () => (/* reexport */ ToggleGroupItem),
  ToggleTemplate: () => (/* reexport */ ToggleTemplate),
  Toolbar: () => (/* reexport */ Toolbar),
  ToolbarContent: () => (/* reexport */ ToolbarContent),
  ToolbarContentContext: () => (/* reexport */ ToolbarContentContext),
  ToolbarContext: () => (/* reexport */ ToolbarContext),
  ToolbarExpandIconWrapper: () => (/* reexport */ ToolbarExpandIconWrapper),
  ToolbarFilter: () => (/* reexport */ ToolbarFilter),
  ToolbarGroup: () => (/* reexport */ ToolbarGroup),
  ToolbarGroupVariant: () => (/* reexport */ ToolbarGroupVariant),
  ToolbarItem: () => (/* reexport */ ToolbarItem),
  ToolbarItemVariant: () => (/* reexport */ ToolbarItemVariant),
  ToolbarToggleGroup: () => (/* reexport */ ToolbarToggleGroup),
  Tooltip: () => (/* reexport */ Tooltip),
  TooltipPosition: () => (/* reexport */ TooltipPosition),
  TreeView: () => (/* reexport */ TreeView),
  TreeViewSearch: () => (/* reexport */ TreeViewSearch),
  Truncate: () => (/* reexport */ Truncate),
  TruncatePosition: () => (/* reexport */ TruncatePosition),
  ValidatedOptions: () => (/* reexport */ ValidatedOptions),
  Weekday: () => (/* reexport */ Weekday),
  Wizard: () => (/* reexport */ Wizard),
  WizardBody: () => (/* reexport */ WizardBody),
  WizardContext: () => (/* reexport */ WizardContext),
  WizardContextConsumer: () => (/* reexport */ WizardContextConsumer),
  WizardContextProvider: () => (/* reexport */ WizardContextProvider),
  WizardFooter: () => (/* reexport */ WizardFooter),
  WizardHeader: () => (/* reexport */ WizardHeader),
  WizardNav: () => (/* reexport */ WizardNav),
  WizardNavItem: () => (/* reexport */ WizardNavItem),
  WizardToggle: () => (/* reexport */ WizardToggle),
  canUseDOM: () => (/* reexport */ canUseDOM),
  capitalize: () => (/* reexport */ capitalize),
  clipboardCopyFunc: () => (/* reexport */ clipboardCopyFunc),
  debounce: () => (/* reexport */ debounce),
  fillTemplate: () => (/* reexport */ fillTemplate),
  findTabbableElements: () => (/* reexport */ findTabbableElements),
  formatBreakpointMods: () => (/* reexport */ formatBreakpointMods),
  getBreakpoint: () => (/* reexport */ getBreakpoint),
  getDefaultOUIAId: () => (/* reexport */ getDefaultOUIAId),
  getNextIndex: () => (/* reexport */ getNextIndex),
  getOUIAProps: () => (/* reexport */ getOUIAProps),
  getOpacityTransition: () => (/* reexport */ getOpacityTransition),
  getResizeObserver: () => (/* reexport */ getResizeObserver),
  getTextWidth: () => (/* reexport */ getTextWidth),
  getUniqueId: () => (/* reexport */ getUniqueId),
  getVerticalBreakpoint: () => (/* reexport */ getVerticalBreakpoint),
  globalBreakpoints: () => (/* reexport */ globalBreakpoints),
  globalHeightBreakpoints: () => (/* reexport */ globalHeightBreakpoints),
  globalWidthBreakpoints: () => (/* reexport */ globalWidthBreakpoints),
  handleArrows: () => (/* reexport */ handleArrows),
  innerDimensions: () => (/* reexport */ innerDimensions),
  isElementInView: () => (/* reexport */ isElementInView),
  isValidDate: () => (/* reexport */ isValidDate),
  keyHandler: () => (/* reexport */ keyHandler),
  navContextDefaults: () => (/* reexport */ navContextDefaults),
  pageContextDefaults: () => (/* reexport */ pageContextDefaults),
  pageSidebarContextDefaults: () => (/* reexport */ pageSidebarContextDefaults),
  pluralize: () => (/* reexport */ pluralize),
  preventedEvents: () => (/* reexport */ preventedEvents),
  setBreakpointCssVars: () => (/* reexport */ setBreakpointCssVars),
  setTabIndex: () => (/* reexport */ setTabIndex),
  sideElementIsOutOfView: () => (/* reexport */ sideElementIsOutOfView),
  spinnerSize: () => (/* reexport */ spinnerSize),
  toCamel: () => (/* reexport */ toCamel),
  trimLeft: () => (/* reexport */ trimLeft),
  useInterval: () => (/* reexport */ useInterval),
  useIsomorphicLayoutEffect: () => (/* reexport */ useIsomorphicLayoutEffect),
  useOUIAId: () => (/* reexport */ useOUIAId),
  useOUIAProps: () => (/* reexport */ useOUIAProps),
  variantIcons: () => (/* reexport */ NotificationDrawerListItemHeader_variantIcons),
  yyyyMMddFormat: () => (/* reexport */ yyyyMMddFormat)
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/tslib@2.6.0/node_modules/tslib/tslib.es6.mjs
var tslib_es6 = __webpack_require__(87768);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@17.0.2/node_modules/react/index.js
var react = __webpack_require__(29901);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react-dom@17.0.2_react@17.0.2/node_modules/react-dom/index.js
var react_dom = __webpack_require__(10571);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/dist/esm/index.js
var esm = __webpack_require__(36566);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Backdrop/backdrop.js
var backdrop = __webpack_require__(36093);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_breakpoint_sm.js
const global_breakpoint_sm = {
  "name": "--pf-global--breakpoint--sm",
  "value": "576px",
  "var": "var(--pf-global--breakpoint--sm)"
};
/* harmony default export */ const esm_global_breakpoint_sm = (global_breakpoint_sm);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_breakpoint_md.js
const global_breakpoint_md = {
  "name": "--pf-global--breakpoint--md",
  "value": "768px",
  "var": "var(--pf-global--breakpoint--md)"
};
/* harmony default export */ const esm_global_breakpoint_md = (global_breakpoint_md);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_breakpoint_lg.js
const global_breakpoint_lg = {
  "name": "--pf-global--breakpoint--lg",
  "value": "992px",
  "var": "var(--pf-global--breakpoint--lg)"
};
/* harmony default export */ const esm_global_breakpoint_lg = (global_breakpoint_lg);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_breakpoint_xl.js
const global_breakpoint_xl = {
  "name": "--pf-global--breakpoint--xl",
  "value": "1200px",
  "var": "var(--pf-global--breakpoint--xl)"
};
/* harmony default export */ const esm_global_breakpoint_xl = (global_breakpoint_xl);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_breakpoint_2xl.js
const global_breakpoint_2xl = {
  "name": "--pf-global--breakpoint--2xl",
  "value": "1450px",
  "var": "var(--pf-global--breakpoint--2xl)"
};
/* harmony default export */ const esm_global_breakpoint_2xl = (global_breakpoint_2xl);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_height_breakpoint_sm.js
const global_height_breakpoint_sm = {
  "name": "--pf-global--height-breakpoint--sm",
  "value": "0",
  "var": "var(--pf-global--height-breakpoint--sm)"
};
/* harmony default export */ const esm_global_height_breakpoint_sm = (global_height_breakpoint_sm);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_height_breakpoint_md.js
const global_height_breakpoint_md = {
  "name": "--pf-global--height-breakpoint--md",
  "value": "40rem",
  "var": "var(--pf-global--height-breakpoint--md)"
};
/* harmony default export */ const esm_global_height_breakpoint_md = (global_height_breakpoint_md);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_height_breakpoint_lg.js
const global_height_breakpoint_lg = {
  "name": "--pf-global--height-breakpoint--lg",
  "value": "48rem",
  "var": "var(--pf-global--height-breakpoint--lg)"
};
/* harmony default export */ const esm_global_height_breakpoint_lg = (global_height_breakpoint_lg);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_height_breakpoint_xl.js
const global_height_breakpoint_xl = {
  "name": "--pf-global--height-breakpoint--xl",
  "value": "60rem",
  "var": "var(--pf-global--height-breakpoint--xl)"
};
/* harmony default export */ const esm_global_height_breakpoint_xl = (global_height_breakpoint_xl);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/global_height_breakpoint_2xl.js
const global_height_breakpoint_2xl = {
  "name": "--pf-global--height-breakpoint--2xl",
  "value": "80rem",
  "var": "var(--pf-global--height-breakpoint--2xl)"
};
/* harmony default export */ const esm_global_height_breakpoint_2xl = (global_height_breakpoint_2xl);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/constants.js










const KEY_CODES = { ARROW_UP: 38, ARROW_DOWN: 40, ESCAPE_KEY: 27, TAB: 9, ENTER: 13, SPACE: 32 };
const SIDE = { RIGHT: 'right', LEFT: 'left', BOTH: 'both', NONE: 'none' };
const KEYHANDLER_DIRECTION = { UP: 'up', DOWN: 'down', RIGHT: 'right', LEFT: 'left' };
var ValidatedOptions;
(function (ValidatedOptions) {
    ValidatedOptions["success"] = "success";
    ValidatedOptions["error"] = "error";
    ValidatedOptions["warning"] = "warning";
    ValidatedOptions["default"] = "default";
})(ValidatedOptions || (ValidatedOptions = {}));
const KeyTypes = {
    Tab: 'Tab',
    Space: ' ',
    Escape: 'Escape',
    Enter: 'Enter',
    ArrowUp: 'ArrowUp',
    ArrowDown: 'ArrowDown',
    ArrowLeft: 'ArrowLeft',
    ArrowRight: 'ArrowRight'
};
const globalWidthBreakpoints = {
    sm: parseInt(esm_global_breakpoint_sm.value),
    md: parseInt(esm_global_breakpoint_md.value),
    lg: parseInt(esm_global_breakpoint_lg.value),
    xl: parseInt(esm_global_breakpoint_xl.value),
    '2xl': parseInt(esm_global_breakpoint_2xl.value)
};
const globalHeightBreakpoints = {
    sm: parseInt(esm_global_height_breakpoint_sm.value),
    md: parseInt(esm_global_height_breakpoint_md.value),
    lg: parseInt(esm_global_height_breakpoint_lg.value),
    xl: parseInt(esm_global_height_breakpoint_xl.value),
    '2xl': parseInt(esm_global_height_breakpoint_2xl.value)
};
//# sourceMappingURL=constants.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/util.js


/**
 * @param {string} input - String to capitalize first letter
 */
function capitalize(input) {
    return input[0].toUpperCase() + input.substring(1);
}
/**
 * @param {string} prefix - String to prefix ID with
 */
function getUniqueId(prefix = 'pf') {
    const uid = new Date().getTime() +
        Math.random()
            .toString(36)
            .slice(2);
    return `${prefix}-${uid}`;
}
/**
 * @param { any } this - "This" reference
 * @param { Function } func - Function to debounce
 * @param { number } wait - Debounce amount
 */
function debounce(func, wait) {
    let timeout;
    return (...args) => {
        clearTimeout(timeout);
        timeout = setTimeout(() => func.apply(this, args), wait);
    };
}
/** This function returns whether or not an element is within the viewable area of a container. If partial is true,
 * then this function will return true even if only part of the element is in view.
 *
 * @param {HTMLElement} container  The container to check if the element is in view of.
 * @param {HTMLElement} element    The element to check if it is view
 * @param {boolean} partial   true if partial view is allowed
 * @param {boolean} strict    true if strict mode is set, never consider the container width and element width
 *
 * @returns { boolean } True if the component is in View.
 */
function isElementInView(container, element, partial, strict = false) {
    if (!container || !element) {
        return false;
    }
    const containerBounds = container.getBoundingClientRect();
    const elementBounds = element.getBoundingClientRect();
    const containerBoundsLeft = Math.ceil(containerBounds.left);
    const containerBoundsRight = Math.floor(containerBounds.right);
    const elementBoundsLeft = Math.ceil(elementBounds.left);
    const elementBoundsRight = Math.floor(elementBounds.right);
    // Check if in view
    const isTotallyInView = elementBoundsLeft >= containerBoundsLeft && elementBoundsRight <= containerBoundsRight;
    const isPartiallyInView = (partial || (!strict && containerBounds.width < elementBounds.width)) &&
        ((elementBoundsLeft < containerBoundsLeft && elementBoundsRight > containerBoundsLeft) ||
            (elementBoundsRight > containerBoundsRight && elementBoundsLeft < containerBoundsRight));
    // Return outcome
    return isTotallyInView || isPartiallyInView;
}
/** This function returns the side the element is out of view on (right, left or both)
 *
 * @param {HTMLElement} container    The container to check if the element is in view of.
 * @param {HTMLElement} element      The element to check if it is view
 *
 * @returns {string} right if the element is of the right, left if element is off the left or both if it is off on both sides.
 */
function sideElementIsOutOfView(container, element) {
    const containerBounds = container.getBoundingClientRect();
    const elementBounds = element.getBoundingClientRect();
    const containerBoundsLeft = Math.floor(containerBounds.left);
    const containerBoundsRight = Math.floor(containerBounds.right);
    const elementBoundsLeft = Math.floor(elementBounds.left);
    const elementBoundsRight = Math.floor(elementBounds.right);
    // Check if in view
    const isOffLeft = elementBoundsLeft < containerBoundsLeft;
    const isOffRight = elementBoundsRight > containerBoundsRight;
    let side = SIDE.NONE;
    if (isOffRight && isOffLeft) {
        side = SIDE.BOTH;
    }
    else if (isOffRight) {
        side = SIDE.RIGHT;
    }
    else if (isOffLeft) {
        side = SIDE.LEFT;
    }
    // Return outcome
    return side;
}
/** Interpolates a parameterized templateString using values from a templateVars object.
 * The templateVars object should have keys and values which match the templateString's parameters.
 * Example:
 *    const templateString: 'My name is ${firstName} ${lastName}';
 *    const templateVars: {
 *      firstName: 'Jon'
 *      lastName: 'Dough'
 *    };
 *    const result = fillTemplate(templateString, templateVars);
 *    // "My name is Jon Dough"
 *
 * @param {string} templateString  The string passed by the consumer
 * @param {object} templateVars The variables passed to the string
 *
 * @returns {string} The template string literal result
 */
function fillTemplate(templateString, templateVars) {
    return templateString.replace(/\${(.*?)}/g, (_, match) => templateVars[match] || '');
}
/**
 * This function allows for keyboard navigation through dropdowns. The custom argument is optional.
 *
 * @param {number} index The index of the element you're on
 * @param {number} innerIndex Inner index number
 * @param {string} position The orientation of the dropdown
 * @param {string[]} refsCollection Array of refs to the items in the dropdown
 * @param {object[]} kids Array of items in the dropdown
 * @param {boolean} [custom] Allows for handling of flexible content
 */
function keyHandler(index, innerIndex, position, refsCollection, kids, custom = false) {
    if (!Array.isArray(kids)) {
        return;
    }
    const isMultiDimensional = refsCollection.filter(ref => ref)[0].constructor === Array;
    let nextIndex = index;
    let nextInnerIndex = innerIndex;
    if (position === 'up') {
        if (index === 0) {
            // loop back to end
            nextIndex = kids.length - 1;
        }
        else {
            nextIndex = index - 1;
        }
    }
    else if (position === 'down') {
        if (index === kids.length - 1) {
            // loop back to beginning
            nextIndex = 0;
        }
        else {
            nextIndex = index + 1;
        }
    }
    else if (position === 'left') {
        if (innerIndex === 0) {
            nextInnerIndex = refsCollection[index].length - 1;
        }
        else {
            nextInnerIndex = innerIndex - 1;
        }
    }
    else if (position === 'right') {
        if (innerIndex === refsCollection[index].length - 1) {
            nextInnerIndex = 0;
        }
        else {
            nextInnerIndex = innerIndex + 1;
        }
    }
    if (refsCollection[nextIndex] === null ||
        refsCollection[nextIndex] === undefined ||
        (isMultiDimensional &&
            (refsCollection[nextIndex][nextInnerIndex] === null || refsCollection[nextIndex][nextInnerIndex] === undefined))) {
        keyHandler(nextIndex, nextInnerIndex, position, refsCollection, kids, custom);
    }
    else if (custom) {
        if (refsCollection[nextIndex].focus) {
            refsCollection[nextIndex].focus();
        }
        // eslint-disable-next-line react/no-find-dom-node
        const element = react_dom.findDOMNode(refsCollection[nextIndex]);
        element.focus();
    }
    else if (position !== 'tab') {
        if (isMultiDimensional) {
            refsCollection[nextIndex][nextInnerIndex].focus();
        }
        else {
            refsCollection[nextIndex].focus();
        }
    }
}
/** This function returns a list of tabbable items in a container
 *
 *  @param {any} containerRef to the container
 *  @param {string} tababbleSelectors CSS selector string of tabbable items
 */
function findTabbableElements(containerRef, tababbleSelectors) {
    const tabbable = containerRef.current.querySelectorAll(tababbleSelectors);
    const list = Array.prototype.filter.call(tabbable, function (item) {
        return item.tabIndex >= '0';
    });
    return list;
}
/** This function is a helper for keyboard navigation through dropdowns.
 *
 * @param {number} index The index of the element you're on
 * @param {string} position The orientation of the dropdown
 * @param {string[]} collection Array of refs to the items in the dropdown
 */
function getNextIndex(index, position, collection) {
    let nextIndex;
    if (position === 'up') {
        if (index === 0) {
            // loop back to end
            nextIndex = collection.length - 1;
        }
        else {
            nextIndex = index - 1;
        }
    }
    else if (index === collection.length - 1) {
        // loop back to beginning
        nextIndex = 0;
    }
    else {
        nextIndex = index + 1;
    }
    if (collection[nextIndex] === undefined || collection[nextIndex][0] === null) {
        return getNextIndex(nextIndex, position, collection);
    }
    else {
        return nextIndex;
    }
}
/** This function is a helper for pluralizing strings.
 *
 * @param {number} i The quantity of the string you want to pluralize
 * @param {string} singular The singular version of the string
 * @param {string} plural The change to the string that should occur if the quantity is not equal to 1.
 *                 Defaults to adding an 's'.
 */
function pluralize(i, singular, plural) {
    if (!plural) {
        plural = `${singular}s`;
    }
    return `${i || 0} ${i === 1 ? singular : plural}`;
}
/**
 * This function is a helper for turning arrays of breakpointMod objects for flex and grid into style object
 *
 * @param {object} mods The modifiers object
 * @param {string} css-variable The appropriate css variable for the component
 */
const setBreakpointCssVars = (mods, cssVar) => Object.entries(mods || {}).reduce((acc, [breakpoint, value]) => breakpoint === 'default' ? Object.assign(Object.assign({}, acc), { [cssVar]: value }) : Object.assign(Object.assign({}, acc), { [`${cssVar}-on-${breakpoint}`]: value }), {});
/**
 * This function is a helper for turning arrays of breakpointMod objects for data toolbar and flex into classes
 *
 * @param {object} mods The modifiers object
 * @param {any} styles The appropriate styles object for the component
 */
const formatBreakpointMods = (mods, styles, stylePrefix = '', breakpoint, vertical) => {
    if (!mods) {
        return '';
    }
    if (breakpoint && !vertical) {
        if (breakpoint in mods) {
            return styles.modifiers[toCamel(`${stylePrefix}${mods[breakpoint]}`)];
        }
        // the current breakpoint is not specified in mods, so we try to find the next nearest
        const breakpointsOrder = ['2xl', 'xl', 'lg', 'md', 'sm', 'default'];
        const breakpointsIndex = breakpointsOrder.indexOf(breakpoint);
        for (let i = breakpointsIndex; i < breakpointsOrder.length; i++) {
            if (breakpointsOrder[i] in mods) {
                return styles.modifiers[toCamel(`${stylePrefix}${mods[breakpointsOrder[i]]}`)];
            }
        }
        return '';
    }
    return Object.entries(mods || {})
        .map(([breakpoint, mod]) => `${stylePrefix}${mod}${breakpoint !== 'default' ? `-on-${breakpoint}` : ''}${vertical && breakpoint !== 'default' ? '-height' : ''}`)
        .map(toCamel)
        .map(mod => mod.replace(/-?(\dxl)/gi, (_res, group) => `_${group}`))
        .map(modifierKey => styles.modifiers[modifierKey])
        .filter(Boolean)
        .join(' ');
};
/**
 * Return the breakpoint for the given height
 *
 * @param {number | null} height The height to check
 * @returns {'default' | 'sm' | 'md' | 'lg' | 'xl' | '2xl'} The breakpoint
 */
const getVerticalBreakpoint = (height) => {
    if (height === null) {
        return null;
    }
    if (height >= globalHeightBreakpoints['2xl']) {
        return '2xl';
    }
    if (height >= globalHeightBreakpoints.xl) {
        return 'xl';
    }
    if (height >= globalHeightBreakpoints.lg) {
        return 'lg';
    }
    if (height >= globalHeightBreakpoints.md) {
        return 'md';
    }
    if (height >= globalHeightBreakpoints.sm) {
        return 'sm';
    }
    return 'default';
};
/**
 * Return the breakpoint for the given width
 *
 * @param {number | null} width The width to check
 * @returns {'default' | 'sm' | 'md' | 'lg' | 'xl' | '2xl'} The breakpoint
 */
const getBreakpoint = (width) => {
    if (width === null) {
        return null;
    }
    if (width >= globalWidthBreakpoints['2xl']) {
        return '2xl';
    }
    if (width >= globalWidthBreakpoints.xl) {
        return 'xl';
    }
    if (width >= globalWidthBreakpoints.lg) {
        return 'lg';
    }
    if (width >= globalWidthBreakpoints.md) {
        return 'md';
    }
    if (width >= globalWidthBreakpoints.sm) {
        return 'sm';
    }
    return 'default';
};
const camelize = (s) => s
    .toUpperCase()
    .replace('-', '')
    .replace('_', '');
/**
 *
 * @param {string} s string to make camelCased
 */
const toCamel = (s) => s.replace(/([-_][a-z])/gi, camelize);
/**
 * Copied from exenv
 */
const canUseDOM = !!(typeof window !== 'undefined' && window.document && window.document.createElement);
/**
 * Calculate the width of the text
 * Example:
 * getTextWidth('my text', node)
 *
 * @param {string} text The text to calculate the width for
 * @param {HTMLElement} node The HTML element
 */
const getTextWidth = (text, node) => {
    const computedStyle = getComputedStyle(node);
    // Firefox returns the empty string for .font, so this function creates the .font property manually
    const getFontFromComputedStyle = () => {
        let computedFont = '';
        // Firefox uses percentages for font-stretch, but Canvas does not accept percentages
        // so convert to keywords, as listed at:
        // https://developer.mozilla.org/en-US/docs/Web/CSS/font-stretch
        const fontStretchLookupTable = {
            '50%': 'ultra-condensed',
            '62.5%': 'extra-condensed',
            '75%': 'condensed',
            '87.5%': 'semi-condensed',
            '100%': 'normal',
            '112.5%': 'semi-expanded',
            '125%': 'expanded',
            '150%': 'extra-expanded',
            '200%': 'ultra-expanded'
        };
        // If the retrieved font-stretch percentage isn't found in the lookup table, use
        // 'normal' as a last resort.
        let fontStretch;
        if (computedStyle.fontStretch in fontStretchLookupTable) {
            fontStretch = fontStretchLookupTable[computedStyle.fontStretch];
        }
        else {
            fontStretch = 'normal';
        }
        computedFont =
            computedStyle.fontStyle +
                ' ' +
                computedStyle.fontVariant +
                ' ' +
                computedStyle.fontWeight +
                ' ' +
                fontStretch +
                ' ' +
                computedStyle.fontSize +
                '/' +
                computedStyle.lineHeight +
                ' ' +
                computedStyle.fontFamily;
        return computedFont;
    };
    const canvas = document.createElement('canvas');
    const context = canvas.getContext('2d');
    context.font = computedStyle.font || getFontFromComputedStyle();
    return context.measureText(text).width;
};
/**
 * Get the inner dimensions of an element
 *
 * @param {HTMLElement} node HTML element to calculate the inner dimensions for
 */
const innerDimensions = (node) => {
    const computedStyle = getComputedStyle(node);
    let width = node.clientWidth; // width with padding
    let height = node.clientHeight; // height with padding
    height -= parseFloat(computedStyle.paddingTop) + parseFloat(computedStyle.paddingBottom);
    width -= parseFloat(computedStyle.paddingLeft) + parseFloat(computedStyle.paddingRight);
    return { height, width };
};
/**
 * This function is a helper for truncating text content on the left, leaving the right side of the content in view
 *
 * @param {HTMLElement} node HTML element
 * @param {string} value The original text value
 */
const trimLeft = (node, value) => {
    const availableWidth = innerDimensions(node).width;
    let newValue = value;
    if (getTextWidth(value, node) > availableWidth) {
        // we have text overflow, trim the text to the left and add ... in the front until it fits
        while (getTextWidth(`...${newValue}`, node) > availableWidth) {
            newValue = newValue.substring(1);
        }
        // replace text with our truncated text
        if (node.value) {
            node.value = `...${newValue}`;
        }
        else {
            node.innerText = `...${newValue}`;
        }
    }
    else {
        if (node.value) {
            node.value = value;
        }
        else {
            node.innerText = value;
        }
    }
};
/**
 * @param {string[]} events - Operations to prevent when disabled
 */
const preventedEvents = (events) => events.reduce((handlers, eventToPrevent) => (Object.assign(Object.assign({}, handlers), { [eventToPrevent]: (event) => {
        event.preventDefault();
    } })), {});
//# sourceMappingURL=util.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/layouts/Bullseye/bullseye.js
var bullseye = __webpack_require__(12258);
// EXTERNAL MODULE: ../../node_modules/.pnpm/focus-trap@6.9.2/node_modules/focus-trap/dist/focus-trap.esm.js + 1 modules
var focus_trap_esm = __webpack_require__(88642);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/FocusTrap/FocusTrap.js



class FocusTrapBase extends react.Component {
    constructor(props) {
        super(props);
        this.divRef = this.props.innerRef || react.createRef();
        if (typeof document !== 'undefined') {
            this.previouslyFocusedElement = document.activeElement;
        }
    }
    componentDidMount() {
        // We need to hijack the returnFocusOnDeactivate option,
        // because React can move focus into the element before we arrived at
        // this lifecycle hook (e.g. with autoFocus inputs). So the component
        // captures the previouslyFocusedElement in componentWillMount,
        // then (optionally) returns focus to it in componentWillUnmount.
        this.focusTrap = (0,focus_trap_esm.createFocusTrap)(this.divRef.current, Object.assign(Object.assign({}, this.props.focusTrapOptions), { returnFocusOnDeactivate: false }));
        if (this.props.active) {
            this.focusTrap.activate();
        }
        if (this.props.paused) {
            this.focusTrap.pause();
        }
    }
    componentDidUpdate(prevProps) {
        if (prevProps.active && !this.props.active) {
            this.focusTrap.deactivate();
        }
        else if (!prevProps.active && this.props.active) {
            this.focusTrap.activate();
        }
        if (prevProps.paused && !this.props.paused) {
            this.focusTrap.unpause();
        }
        else if (!prevProps.paused && this.props.paused) {
            this.focusTrap.pause();
        }
    }
    componentWillUnmount() {
        this.focusTrap.deactivate();
        if (this.props.focusTrapOptions.returnFocusOnDeactivate !== false &&
            this.previouslyFocusedElement &&
            this.previouslyFocusedElement.focus) {
            this.previouslyFocusedElement.focus({ preventScroll: this.props.preventScrollOnDeactivate });
        }
    }
    render() {
        const _a = this.props, { children, className, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        focusTrapOptions, active, paused, preventScrollOnDeactivate, innerRef } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        rest = (0,tslib_es6.__rest)(_a, ["children", "className", "focusTrapOptions", "active", "paused", "preventScrollOnDeactivate", "innerRef"]);
        return (react.createElement("div", Object.assign({ ref: this.divRef, className: className }, rest), children));
    }
}
FocusTrapBase.displayName = 'FocusTrap';
FocusTrapBase.defaultProps = {
    active: true,
    paused: false,
    focusTrapOptions: {},
    preventScrollOnDeactivate: false
};
const FocusTrap = react.forwardRef((props, ref) => (react.createElement(FocusTrapBase, Object.assign({ innerRef: ref }, props))));
//# sourceMappingURL=FocusTrap.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/AboutModalBox/about-modal-box.js
var about_modal_box = __webpack_require__(72042);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Content/content.js
var content = __webpack_require__(35300);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalBoxContent.js





const AboutModalBoxContent = (_a) => {
    var { children, className = '', trademark, id, noAboutModalBoxContentContainer = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "trademark", "id", "noAboutModalBoxContentContainer"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(about_modal_box["default"].aboutModalBoxContent, className), id: id }, props),
        react.createElement("div", { className: (0,esm.css)('pf-c-about-modal-box__body') }, noAboutModalBoxContentContainer ? children : react.createElement("div", { className: (0,esm.css)(content["default"].content) }, children)),
        react.createElement("p", { className: (0,esm.css)(about_modal_box["default"].aboutModalBoxStrapline) }, trademark)));
};
AboutModalBoxContent.displayName = 'AboutModalBoxContent';
//# sourceMappingURL=AboutModalBoxContent.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Title/title.js
var title = __webpack_require__(11570);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/OUIA/ouia.js

let uid = 0;
const ouiaPrefix = 'OUIA-Generated-';
const ouiaIdByRoute = {};
/** Get props to conform to OUIA spec
 *
 * For functional components, use the useOUIAProps function instead
 *
 * In class based components, create a state variable ouiaStateId to create a static generated ID:
 * state = {
 *  ouiaStateId: getDefaultOUIAId(Chip.displayName)
 * }
 * This generated ID should remain alive as long as the component is not unmounted.
 *
 * Then add the attributes to the component
 * {...getOUIAProps('OverflowChip', this.props.ouiaId !== undefined ? this.props.ouiaId : this.state.ouiaStateId)}
 *
 * @param {string} componentType OUIA component type
 * @param {number|string} id OUIA component id
 * @param {boolean} ouiaSafe false if in animation
 */
function getOUIAProps(componentType, id, ouiaSafe = true) {
    return {
        'data-ouia-component-type': `PF4/${componentType}`,
        'data-ouia-safe': ouiaSafe,
        'data-ouia-component-id': id
    };
}
/**
 * Hooks version of the getOUIAProps function that also memoizes the generated ID
 * Can only be used in functional components
 *
 * @param {string} componentType OUIA component type
 * @param {number|string} id OUIA component id
 * @param {boolean} ouiaSafe false if in animation
 * @param {string} variant Optional variant to add to the generated ID
 */
const useOUIAProps = (componentType, id, ouiaSafe = true, variant) => ({
    'data-ouia-component-type': `PF4/${componentType}`,
    'data-ouia-safe': ouiaSafe,
    'data-ouia-component-id': useOUIAId(componentType, id, variant)
});
/**
 * Returns the ID or the memoized generated ID
 *
 * @param {string} componentType OUIA component type
 * @param {number|string} id OUIA component id
 * @param {string} variant Optional variant to add to the generated ID
 */
const useOUIAId = (componentType, id, variant) => {
    const defaultOUIAId = (0,react.useMemo)(() => getDefaultOUIAId(componentType, variant), [componentType, variant]);
    return id !== null && id !== void 0 ? id : defaultOUIAId;
};
/**
 * Returns a generated id based on the URL location
 *
 * @param {string} componentType OUIA component type
 * @param {string} variant Optional variant to add to the generated ID
 */
function getDefaultOUIAId(componentType, variant) {
    /*
    ouiaIdByRoute = {
      [route+componentType]: [number]
    }
    */
    try {
        let key;
        if (typeof window !== 'undefined') {
            // browser environments
            key = `${window.location.href}-${componentType}-${variant || ''}`;
        }
        else {
            // node/SSR environments
            key = `${componentType}-${variant || ''}`;
        }
        if (!ouiaIdByRoute[key]) {
            ouiaIdByRoute[key] = 0;
        }
        return `${ouiaPrefix}${componentType}-${variant ? `${variant}-` : ''}${++ouiaIdByRoute[key]}`;
    }
    catch (exception) {
        return `${ouiaPrefix}${componentType}-${variant ? `${variant}-` : ''}${++uid}`;
    }
}
//# sourceMappingURL=ouia.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Title/Title.js





var TitleSizes;
(function (TitleSizes) {
    TitleSizes["md"] = "md";
    TitleSizes["lg"] = "lg";
    TitleSizes["xl"] = "xl";
    TitleSizes["2xl"] = "2xl";
    TitleSizes["3xl"] = "3xl";
    TitleSizes["4xl"] = "4xl";
})(TitleSizes || (TitleSizes = {}));
var headingLevelSizeMap;
(function (headingLevelSizeMap) {
    headingLevelSizeMap["h1"] = "2xl";
    headingLevelSizeMap["h2"] = "xl";
    headingLevelSizeMap["h3"] = "lg";
    headingLevelSizeMap["h4"] = "md";
    headingLevelSizeMap["h5"] = "md";
    headingLevelSizeMap["h6"] = "md";
})(headingLevelSizeMap || (headingLevelSizeMap = {}));
const Title = (_a) => {
    var { className = '', children = '', headingLevel: HeadingLevel, size = headingLevelSizeMap[HeadingLevel], ouiaId, ouiaSafe = true } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "headingLevel", "size", "ouiaId", "ouiaSafe"]);
    const ouiaProps = useOUIAProps(Title.displayName, ouiaId, ouiaSafe);
    return (react.createElement(HeadingLevel, Object.assign({}, ouiaProps, props, { className: (0,esm.css)(title["default"].title, size && title["default"].modifiers[size], className) }), children));
};
Title.displayName = 'Title';
//# sourceMappingURL=Title.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalBoxHeader.js





const AboutModalBoxHeader = (_a) => {
    var { className = '', productName = '', id } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "productName", "id"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(about_modal_box["default"].aboutModalBoxHeader, className) }, props),
        react.createElement(Title, { headingLevel: "h1", size: "4xl", id: id }, productName)));
};
AboutModalBoxHeader.displayName = 'AboutModalBoxHeader';
//# sourceMappingURL=AboutModalBoxHeader.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_about_modal_box__hero_sm_BackgroundImage.js
const c_about_modal_box__hero_sm_BackgroundImage = {
  "name": "--pf-c-about-modal-box__hero--sm--BackgroundImage",
  "value": "url(\"../../assets/images/pfbg_992@2x.jpg\")",
  "var": "var(--pf-c-about-modal-box__hero--sm--BackgroundImage)"
};
/* harmony default export */ const c_about_modal_box_hero_sm_BackgroundImage = (c_about_modal_box__hero_sm_BackgroundImage);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalBoxHero.js




// eslint-disable-next-line camelcase

const AboutModalBoxHero = (_a) => {
    var { className, backgroundImageSrc } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "backgroundImageSrc"]);
    return (react.createElement("div", Object.assign({ style: 
        /* eslint-disable camelcase */
        backgroundImageSrc !== ''
            ? { [c_about_modal_box_hero_sm_BackgroundImage.name]: `url(${backgroundImageSrc})` }
            : {}, className: (0,esm.css)(about_modal_box["default"].aboutModalBoxHero, className) }, props)));
};
AboutModalBoxHero.displayName = 'AboutModalBoxHero';
//# sourceMappingURL=AboutModalBoxHero.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalBoxBrand.js




const AboutModalBoxBrand = (_a) => {
    var { className = '', src = '', alt } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "src", "alt"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(about_modal_box["default"].aboutModalBoxBrand, className) }, props),
        react.createElement("img", { className: (0,esm.css)(about_modal_box["default"].aboutModalBoxBrandImage), src: src, alt: alt })));
};
AboutModalBoxBrand.displayName = 'AboutModalBoxBrand';
//# sourceMappingURL=AboutModalBoxBrand.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Button/button.js
var Button_button = __webpack_require__(68534);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Spinner/spinner.js
var spinner = __webpack_require__(75010);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Spinner/Spinner.js




var spinnerSize;
(function (spinnerSize) {
    spinnerSize["sm"] = "sm";
    spinnerSize["md"] = "md";
    spinnerSize["lg"] = "lg";
    spinnerSize["xl"] = "xl";
})(spinnerSize || (spinnerSize = {}));
const Spinner = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', size = 'xl', 'aria-valuetext': ariaValueText = 'Loading...', isSVG = false, diameter, isInline = false, 'aria-label': ariaLabel, 'aria-labelledBy': ariaLabelledBy } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "size", 'aria-valuetext', "isSVG", "diameter", "isInline", 'aria-label', 'aria-labelledBy']);
    const Component = isSVG ? 'svg' : 'span';
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(spinner["default"].spinner, isInline ? spinner["default"].modifiers.inline : spinner["default"].modifiers[size], className), role: "progressbar", "aria-valuetext": ariaValueText }, (isSVG && { viewBox: '0 0 100 100' }), (diameter && { style: { '--pf-c-spinner--diameter': diameter } }), (ariaLabel && { 'aria-label': ariaLabel }), (ariaLabelledBy && { 'aria-labelledBy': ariaLabelledBy }), (!ariaLabel && !ariaLabelledBy && { 'aria-label': 'Contents' }), props), isSVG ? (react.createElement("circle", { className: spinner["default"].spinnerPath, cx: "50", cy: "50", r: "45", fill: "none" })) : (react.createElement(react.Fragment, null,
        react.createElement("span", { className: (0,esm.css)(spinner["default"].spinnerClipper) }),
        react.createElement("span", { className: (0,esm.css)(spinner["default"].spinnerLeadBall) }),
        react.createElement("span", { className: (0,esm.css)(spinner["default"].spinnerTailBall) })))));
};
Spinner.displayName = 'Spinner';
//# sourceMappingURL=Spinner.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Badge/badge.js
var badge = __webpack_require__(95703);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Badge/Badge.js




const Badge = (_a) => {
    var { isRead = false, className = '', children = '', screenReaderText } = _a, props = (0,tslib_es6.__rest)(_a, ["isRead", "className", "children", "screenReaderText"]);
    return (react.createElement("span", Object.assign({}, props, { className: (0,esm.css)(badge["default"].badge, (isRead ? badge["default"].modifiers.read : badge["default"].modifiers.unread), className) }),
        children,
        screenReaderText && react.createElement("span", { className: "pf-screen-reader" }, screenReaderText)));
};
Badge.displayName = 'Badge';
//# sourceMappingURL=Badge.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Button/Button.js







var ButtonVariant;
(function (ButtonVariant) {
    ButtonVariant["primary"] = "primary";
    ButtonVariant["secondary"] = "secondary";
    ButtonVariant["tertiary"] = "tertiary";
    ButtonVariant["danger"] = "danger";
    ButtonVariant["warning"] = "warning";
    ButtonVariant["link"] = "link";
    ButtonVariant["plain"] = "plain";
    ButtonVariant["control"] = "control";
})(ButtonVariant || (ButtonVariant = {}));
var ButtonType;
(function (ButtonType) {
    ButtonType["button"] = "button";
    ButtonType["submit"] = "submit";
    ButtonType["reset"] = "reset";
})(ButtonType || (ButtonType = {}));
const ButtonBase = (_a) => {
    var { children = null, className = '', component = 'button', isActive = false, isBlock = false, isDisabled = false, isAriaDisabled = false, isLoading = null, isDanger = false, spinnerAriaValueText, spinnerAriaLabelledBy, spinnerAriaLabel, isSmall = false, isLarge = false, inoperableEvents = ['onClick', 'onKeyPress'], isInline = false, type = ButtonType.button, variant = ButtonVariant.primary, iconPosition = 'left', 'aria-label': ariaLabel = null, icon = null, ouiaId, ouiaSafe = true, tabIndex = null, innerRef, countOptions } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component", "isActive", "isBlock", "isDisabled", "isAriaDisabled", "isLoading", "isDanger", "spinnerAriaValueText", "spinnerAriaLabelledBy", "spinnerAriaLabel", "isSmall", "isLarge", "inoperableEvents", "isInline", "type", "variant", "iconPosition", 'aria-label', "icon", "ouiaId", "ouiaSafe", "tabIndex", "innerRef", "countOptions"]);
    const ouiaProps = useOUIAProps(Button.displayName, ouiaId, ouiaSafe, variant);
    const Component = component;
    const isButtonElement = Component === 'button';
    const isInlineSpan = isInline && Component === 'span';
    const preventedEvents = inoperableEvents.reduce((handlers, eventToPrevent) => (Object.assign(Object.assign({}, handlers), { [eventToPrevent]: (event) => {
            event.preventDefault();
        } })), {});
    const getDefaultTabIdx = () => {
        if (isDisabled) {
            return isButtonElement ? null : -1;
        }
        else if (isAriaDisabled) {
            return null;
        }
        else if (isInlineSpan) {
            return 0;
        }
    };
    return (react.createElement(Component, Object.assign({}, props, (isAriaDisabled ? preventedEvents : null), { "aria-disabled": isDisabled || isAriaDisabled, "aria-label": ariaLabel, className: (0,esm.css)(Button_button["default"].button, Button_button["default"].modifiers[variant], isBlock && Button_button["default"].modifiers.block, isDisabled && Button_button["default"].modifiers.disabled, isAriaDisabled && Button_button["default"].modifiers.ariaDisabled, isActive && Button_button["default"].modifiers.active, isInline && variant === ButtonVariant.link && Button_button["default"].modifiers.inline, isDanger && (variant === ButtonVariant.secondary || variant === ButtonVariant.link) && Button_button["default"].modifiers.danger, isLoading !== null && children !== null && Button_button["default"].modifiers.progress, isLoading && Button_button["default"].modifiers.inProgress, isSmall && Button_button["default"].modifiers.small, isLarge && Button_button["default"].modifiers.displayLg, className), disabled: isButtonElement ? isDisabled : null, tabIndex: tabIndex !== null ? tabIndex : getDefaultTabIdx(), type: isButtonElement || isInlineSpan ? type : null, role: isInlineSpan ? 'button' : null, ref: innerRef }, ouiaProps),
        isLoading && (react.createElement("span", { className: (0,esm.css)(Button_button["default"].buttonProgress) },
            react.createElement(Spinner, { size: spinnerSize.md, isInline: isInline, "aria-valuetext": spinnerAriaValueText, "aria-label": spinnerAriaLabel, "aria-labelledby": spinnerAriaLabelledBy }))),
        variant === ButtonVariant.plain && children === null && icon ? icon : null,
        variant !== ButtonVariant.plain && icon && iconPosition === 'left' && (react.createElement("span", { className: (0,esm.css)(Button_button["default"].buttonIcon, Button_button["default"].modifiers.start) }, icon)),
        children,
        variant !== ButtonVariant.plain && icon && iconPosition === 'right' && (react.createElement("span", { className: (0,esm.css)(Button_button["default"].buttonIcon, Button_button["default"].modifiers.end) }, icon)),
        countOptions && (react.createElement("span", { className: (0,esm.css)(Button_button["default"].buttonCount, countOptions.className) },
            react.createElement(Badge, { isRead: countOptions.isRead }, countOptions.count)))));
};
const Button = react.forwardRef((props, ref) => (react.createElement(ButtonBase, Object.assign({ innerRef: ref }, props))));
Button.displayName = 'Button';
//# sourceMappingURL=Button.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/tslib@1.14.1/node_modules/tslib/tslib.es6.js
var tslib_tslib_es6 = __webpack_require__(33569);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/createIcon.js


var IconSize;
(function (IconSize) {
    IconSize["sm"] = "sm";
    IconSize["md"] = "md";
    IconSize["lg"] = "lg";
    IconSize["xl"] = "xl";
})(IconSize || (IconSize = {}));
const getSize = (size) => {
    switch (size) {
        case IconSize.sm:
            return '1em';
        case IconSize.md:
            return '1.5em';
        case IconSize.lg:
            return '2em';
        case IconSize.xl:
            return '3em';
        default:
            return '1em';
    }
};
let currentId = 0;
/**
 * Factory to create Icon class components for consumers
 */
function createIcon({ name, xOffset = 0, yOffset = 0, width, height, svgPath }) {
    var _a;
    return _a = class SVGIcon extends react.Component {
            constructor() {
                super(...arguments);
                this.id = `icon-title-${currentId++}`;
            }
            render() {
                const _a = this.props, { size, color, title, noVerticalAlign } = _a, props = (0,tslib_tslib_es6.__rest)(_a, ["size", "color", "title", "noVerticalAlign"]);
                const hasTitle = Boolean(title);
                const heightWidth = getSize(size);
                const baseAlign = -0.125 * Number.parseFloat(heightWidth);
                const style = noVerticalAlign ? null : { verticalAlign: `${baseAlign}em` };
                const viewBox = [xOffset, yOffset, width, height].join(' ');
                return (react.createElement("svg", Object.assign({ style: style, fill: color, height: heightWidth, width: heightWidth, viewBox: viewBox, "aria-labelledby": hasTitle ? this.id : null, "aria-hidden": hasTitle ? null : true, role: "img" }, props),
                    hasTitle && react.createElement("title", { id: this.id }, title),
                    react.createElement("path", { d: svgPath })));
            }
        },
        _a.displayName = name,
        _a.defaultProps = {
            color: 'currentColor',
            size: IconSize.sm,
            noVerticalAlign: false
        },
        _a;
}
//# sourceMappingURL=createIcon.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/times-icon.js


const TimesIconConfig = {
  name: 'TimesIcon',
  height: 512,
  width: 352,
  svgPath: 'M242.72 256l100.07-100.07c12.28-12.28 12.28-32.19 0-44.48l-22.24-22.24c-12.28-12.28-32.19-12.28-44.48 0L176 189.28 75.93 89.21c-12.28-12.28-32.19-12.28-44.48 0L9.21 111.45c-12.28 12.28-12.28 32.19 0 44.48L109.28 256 9.21 356.07c-12.28 12.28-12.28 32.19 0 44.48l22.24 22.24c12.28 12.28 32.2 12.28 44.48 0L176 322.72l100.07 100.07c12.28 12.28 32.2 12.28 44.48 0l22.24-22.24c12.28-12.28 12.28-32.19 0-44.48L242.72 256z',
  yOffset: 0,
  xOffset: 0,
};

const TimesIcon = createIcon(TimesIconConfig);

/* harmony default export */ const times_icon = (TimesIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalBoxCloseButton.js






const AboutModalBoxCloseButton = (_a) => {
    var { className = '', onClose = () => undefined, 'aria-label': ariaLabel = 'Close Dialog' } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "onClose", 'aria-label']);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(about_modal_box["default"].aboutModalBoxClose, className) }, props),
        react.createElement(Button, { variant: "plain", onClick: onClose, "aria-label": ariaLabel },
            react.createElement(times_icon, null))));
};
AboutModalBoxCloseButton.displayName = 'AboutModalBoxCloseButton';
//# sourceMappingURL=AboutModalBoxCloseButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalBox.js




const AboutModalBox = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ role: "dialog", "aria-modal": "true", className: (0,esm.css)(about_modal_box["default"].aboutModalBox, className) }, props), children));
};
AboutModalBox.displayName = 'AboutModalBox';
//# sourceMappingURL=AboutModalBox.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Backdrop/Backdrop.js




const Backdrop = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({}, props, { className: (0,esm.css)(backdrop["default"].backdrop, className) }), children));
};
Backdrop.displayName = 'Backdrop';
//# sourceMappingURL=Backdrop.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModalContainer.js












const AboutModalContainer = (_a) => {
    var { children, className = '', isOpen = false, onClose = () => undefined, productName = '', trademark, brandImageSrc, brandImageAlt, backgroundImageSrc, closeButtonAriaLabel, aboutModalBoxHeaderId, aboutModalBoxContentId, disableFocusTrap = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "isOpen", "onClose", "productName", "trademark", "brandImageSrc", "brandImageAlt", "backgroundImageSrc", "closeButtonAriaLabel", "aboutModalBoxHeaderId", "aboutModalBoxContentId", "disableFocusTrap"]);
    if (!isOpen) {
        return null;
    }
    return (react.createElement(Backdrop, null,
        react.createElement(FocusTrap, { active: !disableFocusTrap, focusTrapOptions: { clickOutsideDeactivates: true, tabbableOptions: { displayCheck: 'none' } }, className: (0,esm.css)(bullseye["default"].bullseye) },
            react.createElement(AboutModalBox, { className: className, "aria-labelledby": aboutModalBoxHeaderId, "aria-describedby": aboutModalBoxContentId },
                react.createElement(AboutModalBoxBrand, { src: brandImageSrc, alt: brandImageAlt }),
                react.createElement(AboutModalBoxCloseButton, { "aria-label": closeButtonAriaLabel, onClose: onClose }),
                productName && react.createElement(AboutModalBoxHeader, { id: aboutModalBoxHeaderId, productName: productName }),
                react.createElement(AboutModalBoxContent, Object.assign({ trademark: trademark, id: aboutModalBoxContentId, noAboutModalBoxContentContainer: false }, props), children),
                react.createElement(AboutModalBoxHero, { backgroundImageSrc: backgroundImageSrc })))));
};
AboutModalContainer.displayName = 'AboutModalContainer';
//# sourceMappingURL=AboutModalContainer.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/AboutModal.js








class AboutModal extends react.Component {
    constructor(props) {
        super(props);
        this.id = AboutModal.currentId++;
        this.ariaLabelledBy = `pf-about-modal-title-${this.id}`;
        this.ariaDescribedBy = `pf-about-modal-content-${this.id}`;
        this.handleEscKeyClick = (event) => {
            if (event.key === KeyTypes.Escape && this.props.isOpen) {
                this.props.onClose();
            }
        };
        this.toggleSiblingsFromScreenReaders = (hide) => {
            const { appendTo } = this.props;
            const target = this.getElement(appendTo);
            const bodyChildren = target.children;
            for (const child of Array.from(bodyChildren)) {
                if (child !== this.state.container) {
                    hide ? child.setAttribute('aria-hidden', '' + hide) : child.removeAttribute('aria-hidden');
                }
            }
        };
        this.getElement = (appendTo) => {
            if (typeof appendTo === 'function') {
                return appendTo();
            }
            return appendTo || document.body;
        };
        this.state = {
            container: undefined
        };
        if (props.brandImageSrc && !props.brandImageAlt) {
            // eslint-disable-next-line no-console
            console.error('AboutModal:', 'brandImageAlt is required when a brandImageSrc is specified');
        }
    }
    componentDidMount() {
        const container = document.createElement('div');
        const target = this.getElement(this.props.appendTo);
        this.setState({ container });
        target.appendChild(container);
        target.addEventListener('keydown', this.handleEscKeyClick, false);
        if (this.props.isOpen) {
            target.classList.add((0,esm.css)(backdrop["default"].backdropOpen));
        }
        else {
            target.classList.remove((0,esm.css)(backdrop["default"].backdropOpen));
        }
    }
    componentDidUpdate() {
        const target = this.getElement(this.props.appendTo);
        if (this.props.isOpen) {
            target.classList.add((0,esm.css)(backdrop["default"].backdropOpen));
            this.toggleSiblingsFromScreenReaders(true);
        }
        else {
            target.classList.remove((0,esm.css)(backdrop["default"].backdropOpen));
            this.toggleSiblingsFromScreenReaders(false);
        }
    }
    componentWillUnmount() {
        const target = this.getElement(this.props.appendTo);
        if (this.state.container) {
            target.removeChild(this.state.container);
        }
        target.removeEventListener('keydown', this.handleEscKeyClick, false);
        target.classList.remove((0,esm.css)(backdrop["default"].backdropOpen));
    }
    render() {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _a = this.props, { appendTo } = _a, props = (0,tslib_es6.__rest)(_a, ["appendTo"]);
        const { container } = this.state;
        if (!canUseDOM || !container) {
            return null;
        }
        return react_dom.createPortal(react.createElement(AboutModalContainer, Object.assign({ aboutModalBoxHeaderId: this.ariaLabelledBy, aboutModalBoxContentId: this.ariaDescribedBy }, props)), container);
    }
}
AboutModal.displayName = 'AboutModal';
AboutModal.currentId = 0;
AboutModal.defaultProps = {
    className: '',
    isOpen: false,
    onClose: () => undefined,
    productName: '',
    trademark: '',
    backgroundImageSrc: '',
    noAboutModalBoxContentContainer: false,
    appendTo: null
};
//# sourceMappingURL=AboutModal.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AboutModal/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Accordion/accordion.js
var accordion = __webpack_require__(11895);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/AccordionContext.js

const AccordionContext = react.createContext({});
//# sourceMappingURL=AccordionContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/Accordion.js





const Accordion = (_a) => {
    var { children = null, className = '', 'aria-label': ariaLabel = '', headingLevel = 'h3', asDefinitionList = true, isBordered = false, displaySize = 'default' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", 'aria-label', "headingLevel", "asDefinitionList", "isBordered", "displaySize"]);
    const AccordionList = asDefinitionList ? 'dl' : 'div';
    return (react.createElement(AccordionList, Object.assign({ className: (0,esm.css)(accordion/* default */.Z.accordion, isBordered && accordion/* default */.Z.modifiers.bordered, displaySize === 'large' && accordion/* default */.Z.modifiers.displayLg, className), "aria-label": ariaLabel }, props),
        react.createElement(AccordionContext.Provider, { value: {
                ContentContainer: asDefinitionList ? 'dd' : 'div',
                ToggleContainer: asDefinitionList ? 'dt' : headingLevel
            } }, children)));
};
Accordion.displayName = 'Accordion';
//# sourceMappingURL=Accordion.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/AccordionExpandedContentBody.js



const AccordionExpandedContentBody = ({ children = null }) => react.createElement("div", { className: (0,esm.css)(accordion/* default */.Z.accordionExpandedContentBody) }, children);
AccordionExpandedContentBody.displayName = 'AccordionExpandedContentBody';
//# sourceMappingURL=AccordionExpandedContentBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/AccordionContent.js






const AccordionContent = (_a) => {
    var { className = '', children = null, id = '', isHidden = false, isFixed = false, isCustomContent = false, 'aria-label': ariaLabel = '', 'aria-labelledby': ariaLabelledby, component } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "id", "isHidden", "isFixed", "isCustomContent", 'aria-label', 'aria-labelledby', "component"]);
    const [hasScrollbar, setHasScrollbar] = react.useState(false);
    const containerRef = react.useRef(null);
    react.useEffect(() => {
        if ((containerRef === null || containerRef === void 0 ? void 0 : containerRef.current) && isFixed && !isHidden) {
            const { offsetHeight, scrollHeight } = containerRef.current;
            setHasScrollbar(offsetHeight < scrollHeight);
        }
        else if (!isFixed) {
            setHasScrollbar(false);
        }
    }, [containerRef, isFixed, isHidden]);
    return (react.createElement(AccordionContext.Consumer, null, ({ ContentContainer }) => {
        const Container = component || ContentContainer;
        return (react.createElement(Container, Object.assign({ ref: containerRef, id: id, className: (0,esm.css)(accordion/* default */.Z.accordionExpandedContent, isFixed && accordion/* default */.Z.modifiers.fixed, !isHidden && accordion/* default */.Z.modifiers.expanded, className), hidden: isHidden }, (ariaLabel && { 'aria-label': ariaLabel }), (ariaLabelledby && { 'aria-labelledby': ariaLabelledby }), (hasScrollbar && { tabIndex: 0 }), (hasScrollbar && Container === 'div' && { role: 'region' }), props), isCustomContent ? children : react.createElement(AccordionExpandedContentBody, null, children)));
    }));
};
AccordionContent.displayName = 'AccordionContent';
//# sourceMappingURL=AccordionContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/AccordionItem.js

const AccordionItem = ({ children = null }) => (react.createElement(react.Fragment, null, children));
AccordionItem.displayName = 'AccordionItem';
//# sourceMappingURL=AccordionItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/angle-right-icon.js


const AngleRightIconConfig = {
  name: 'AngleRightIcon',
  height: 512,
  width: 256,
  svgPath: 'M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34z',
  yOffset: 0,
  xOffset: 0,
};

const AngleRightIcon = createIcon(AngleRightIconConfig);

/* harmony default export */ const angle_right_icon = (AngleRightIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/AccordionToggle.js






const AccordionToggle = (_a) => {
    var { className = '', id, isExpanded = false, children = null, component } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "id", "isExpanded", "children", "component"]);
    return (react.createElement(AccordionContext.Consumer, null, ({ ToggleContainer }) => {
        const Container = component || ToggleContainer;
        return (react.createElement(Container, null,
            react.createElement("button", Object.assign({ id: id, className: (0,esm.css)(accordion/* default */.Z.accordionToggle, isExpanded && accordion/* default */.Z.modifiers.expanded, className), "aria-expanded": isExpanded, type: "button" }, props),
                react.createElement("span", { className: (0,esm.css)(accordion/* default */.Z.accordionToggleText) }, children),
                react.createElement("span", { className: (0,esm.css)(accordion/* default */.Z.accordionToggleIcon) },
                    react.createElement(angle_right_icon, null)))));
    }));
};
AccordionToggle.displayName = 'AccordionToggle';
//# sourceMappingURL=AccordionToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Accordion/index.js





//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/ActionList/action-list.js
var action_list = __webpack_require__(52721);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ActionList/ActionList.js




const ActionList = (_a) => {
    var { children, isIconList, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "isIconList", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(action_list/* default */.Z.actionList, isIconList && action_list/* default */.Z.modifiers.icons, className) }, props), children));
};
ActionList.displayName = 'ActionList';
//# sourceMappingURL=ActionList.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ActionList/ActionListGroup.js




const ActionListGroup = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(action_list/* default */.Z.actionListGroup, className) }, props), children));
};
ActionListGroup.displayName = 'ActionListGroup';
//# sourceMappingURL=ActionListGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ActionList/ActionListItem.js



const ActionListItem = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)('pf-c-action-list__item', className) }, props), children));
};
ActionListItem.displayName = 'ActionListItem';
//# sourceMappingURL=ActionListItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ActionList/index.js



//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Alert/alert.js
var Alert_alert = __webpack_require__(68437);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/utilities/Accessibility/accessibility.js
var accessibility = __webpack_require__(21202);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/check-circle-icon.js


const CheckCircleIconConfig = {
  name: 'CheckCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z',
  yOffset: 0,
  xOffset: 0,
};

const CheckCircleIcon = createIcon(CheckCircleIconConfig);

/* harmony default export */ const check_circle_icon = (CheckCircleIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/exclamation-circle-icon.js


const ExclamationCircleIconConfig = {
  name: 'ExclamationCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z',
  yOffset: 0,
  xOffset: 0,
};

const ExclamationCircleIcon = createIcon(ExclamationCircleIconConfig);

/* harmony default export */ const exclamation_circle_icon = (ExclamationCircleIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/exclamation-triangle-icon.js


const ExclamationTriangleIconConfig = {
  name: 'ExclamationTriangleIcon',
  height: 512,
  width: 576,
  svgPath: 'M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z',
  yOffset: 0,
  xOffset: 0,
};

const ExclamationTriangleIcon = createIcon(ExclamationTriangleIconConfig);

/* harmony default export */ const exclamation_triangle_icon = (ExclamationTriangleIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/info-circle-icon.js


const InfoCircleIconConfig = {
  name: 'InfoCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z',
  yOffset: 0,
  xOffset: 0,
};

const InfoCircleIcon = createIcon(InfoCircleIconConfig);

/* harmony default export */ const info_circle_icon = (InfoCircleIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/bell-icon.js


const BellIconConfig = {
  name: 'BellIcon',
  height: 1024,
  width: 896,
  svgPath: 'M448,0 C465.333333,0 480.333333,6.33333333 493,19 C505.666667,31.6666667 512,46.6666667 512,64 L512,106 L514.23,106.45 C587.89,121.39 648.48,157.24 696,214 C744,271.333333 768,338.666667 768,416 C768,500 780,568.666667 804,622 C818.666667,652.666667 841.333333,684 872,716 C873.773676,718.829136 875.780658,721.505113 878,724 C890,737.333333 896,752.333333 896,769 C896,785.666667 890,800.333333 878,813 C866,825.666667 850.666667,832 832,832 L63.3,832 C44.9533333,831.84 29.8533333,825.506667 18,813 C6,800.333333 0,785.666667 0,769 C0,752.333333 6,737.333333 18,724 L24,716 L25.06,714.9 C55.1933333,683.28 77.5066667,652.313333 92,622 C116,568.666667 128,500 128,416 C128,338.666667 152,271.333333 200,214 C248,156.666667 309.333333,120.666667 384,106 L384,63.31 C384.166667,46.27 390.5,31.5 403,19 C415.666667,6.33333333 430.666667,0 448,0 Z M576,896 L576,897.08 C575.74,932.6 563.073333,962.573333 538,987 C512.666667,1011.66667 482.666667,1024 448,1024 C413.333333,1024 383.333333,1011.66667 358,987 C332.666667,962.333333 320,932 320,896 L576,896 Z',
  yOffset: 0,
  xOffset: 0,
};

const BellIcon = createIcon(BellIconConfig);

/* harmony default export */ const bell_icon = (BellIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertIcon.js









const variantIcons = {
    success: check_circle_icon,
    danger: exclamation_circle_icon,
    warning: exclamation_triangle_icon,
    info: info_circle_icon,
    default: bell_icon
};
const AlertIcon = (_a) => {
    var { variant, customIcon, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["variant", "customIcon", "className"]);
    const Icon = variantIcons[variant];
    return Icon ? (react.createElement("div", Object.assign({}, props, { className: (0,esm.css)(Alert_alert/* default */.Z.alertIcon, className) }), customIcon || react.createElement(Icon, null))) : null;
};
//# sourceMappingURL=AlertIcon.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertContext.js

const AlertContext = react.createContext(null);
//# sourceMappingURL=AlertContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_alert__title_max_lines.js
const c_alert__title_max_lines = {
  "name": "--pf-c-alert__title--max-lines",
  "value": "1",
  "var": "var(--pf-c-alert__title--max-lines)"
};
/* harmony default export */ const c_alert_title_max_lines = (c_alert__title_max_lines);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Tooltip/tooltip.js
var tooltip = __webpack_require__(99887);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Tooltip/TooltipContent.js




const TooltipContent = (_a) => {
    var { className, children, isLeftAligned } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "isLeftAligned"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(tooltip["default"].tooltipContent, isLeftAligned && tooltip["default"].modifiers.textAlignLeft, className) }, props), children));
};
TooltipContent.displayName = 'TooltipContent';
//# sourceMappingURL=TooltipContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Tooltip/TooltipArrow.js




const TooltipArrow = (_a) => {
    var { className } = _a, props = (0,tslib_es6.__rest)(_a, ["className"]);
    return react.createElement("div", Object.assign({ className: (0,esm.css)(tooltip["default"].tooltipArrow, className) }, props));
};
TooltipArrow.displayName = 'TooltipArrow';
//# sourceMappingURL=TooltipArrow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_tooltip_MaxWidth.js
const c_tooltip_MaxWidth = {
  "name": "--pf-c-tooltip--MaxWidth",
  "value": "18.75rem",
  "var": "var(--pf-c-tooltip--MaxWidth)"
};
/* harmony default export */ const esm_c_tooltip_MaxWidth = (c_tooltip_MaxWidth);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getBoundingClientRect.js
/**
 * @param element
 */
function getBoundingClientRect(element) {
    const rect = element.getBoundingClientRect();
    return {
        width: rect.width,
        height: rect.height,
        top: rect.top,
        right: rect.right,
        bottom: rect.bottom,
        left: rect.left,
        x: rect.left,
        y: rect.top
    };
}
//# sourceMappingURL=getBoundingClientRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getWindow.js
// @ts-nocheck
/* :: import type { Window } from '../types'; */
/* :: declare function getWindow(node: Node | Window): Window; */
/**
 * @param node
 */
function getWindow(node) {
    if (node.toString() !== '[object Window]') {
        const ownerDocument = node.ownerDocument;
        return ownerDocument ? ownerDocument.defaultView : window;
    }
    return node;
}
//# sourceMappingURL=getWindow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getWindowScroll.js
// @ts-nocheck

/**
 * @param node
 */
function getWindowScroll(node) {
    const win = getWindow(node);
    const scrollLeft = win.pageXOffset;
    const scrollTop = win.pageYOffset;
    return {
        scrollLeft,
        scrollTop
    };
}
//# sourceMappingURL=getWindowScroll.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/instanceOf.js
// @ts-nocheck

/* :: declare function isElement(node: mixed): boolean %checks(node instanceof
  Element); */
/**
 * @param node
 */
function isElement(node) {
    const OwnElement = getWindow(node).Element;
    return node instanceof OwnElement || node instanceof Element;
}
/* :: declare function isHTMLElement(node: mixed): boolean %checks(node instanceof
  HTMLElement); */
/**
 * @param node
 */
function isHTMLElement(node) {
    const OwnElement = getWindow(node).HTMLElement;
    return node instanceof OwnElement || node instanceof HTMLElement;
}

//# sourceMappingURL=instanceOf.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getHTMLElementScroll.js
// @ts-nocheck
/**
 * @param element
 */
function getHTMLElementScroll(element) {
    return {
        scrollLeft: element.scrollLeft,
        scrollTop: element.scrollTop
    };
}
//# sourceMappingURL=getHTMLElementScroll.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getNodeScroll.js
// @ts-nocheck




/**
 * @param node
 */
function getNodeScroll(node) {
    if (node === getWindow(node) || !isHTMLElement(node)) {
        return getWindowScroll(node);
    }
    else {
        return getHTMLElementScroll(node);
    }
}
//# sourceMappingURL=getNodeScroll.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getNodeName.js
/**
 * @param element
 */
function getNodeName(element) {
    return element ? (element.nodeName || '').toLowerCase() : null;
}
//# sourceMappingURL=getNodeName.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getDocumentElement.js
// @ts-nocheck

/**
 * @param element
 */
function getDocumentElement(element) {
    // $FlowFixMe: assume body is always available
    return (isElement(element) ? element.ownerDocument : element.document).documentElement;
}
//# sourceMappingURL=getDocumentElement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getWindowScrollBarX.js
// @ts-nocheck



/**
 * @param element
 */
function getWindowScrollBarX(element) {
    // If <html> has a CSS width greater than the viewport, then this will be
    // incorrect for RTL.
    // Popper 1 is broken in this case and never had a bug report so let's assume
    // it's not an issue. I don't think anyone ever specifies width on <html>
    // anyway.
    // Browsers where the left scrollbar doesn't cause an issue report `0` for
    // this (e.g. Edge 2019, IE11, Safari)
    return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
}
//# sourceMappingURL=getWindowScrollBarX.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getComputedStyle.js
// @ts-nocheck

/**
 * @param element
 */
function getComputedStyle_getComputedStyle(element) {
    return getWindow(element).getComputedStyle(element);
}
//# sourceMappingURL=getComputedStyle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/isScrollParent.js
// @ts-nocheck

/**
 * @param element
 */
function isScrollParent(element) {
    // Firefox wants us to check `-x` and `-y` variations as well
    const { overflow, overflowX, overflowY } = getComputedStyle_getComputedStyle(element);
    return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}
//# sourceMappingURL=isScrollParent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getCompositeRect.js







// Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.
/**
 * @param elementOrVirtualElement
 * @param offsetParent
 * @param isFixed
 */
function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed = false) {
    const documentElement = getDocumentElement(offsetParent);
    const rect = getBoundingClientRect(elementOrVirtualElement);
    const isOffsetParentAnElement = isHTMLElement(offsetParent);
    let scroll = { scrollLeft: 0, scrollTop: 0 };
    let offsets = { x: 0, y: 0 };
    if (isOffsetParentAnElement || (!isOffsetParentAnElement && !isFixed)) {
        if (getNodeName(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
            isScrollParent(documentElement)) {
            scroll = getNodeScroll(offsetParent);
        }
        if (isHTMLElement(offsetParent)) {
            offsets = getBoundingClientRect(offsetParent);
            offsets.x += offsetParent.clientLeft;
            offsets.y += offsetParent.clientTop;
        }
        else if (documentElement) {
            offsets.x = getWindowScrollBarX(documentElement);
        }
    }
    return {
        x: rect.left + scroll.scrollLeft - offsets.x,
        y: rect.top + scroll.scrollTop - offsets.y,
        width: rect.width,
        height: rect.height
    };
}
//# sourceMappingURL=getCompositeRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getLayoutRect.js
// Returns the layout rect of an element relative to its offsetParent. Layout
// means it doesn't take into account transforms.
/**
 * @param element
 */
function getLayoutRect(element) {
    return {
        x: element.offsetLeft,
        y: element.offsetTop,
        width: element.offsetWidth,
        height: element.offsetHeight
    };
}
//# sourceMappingURL=getLayoutRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getParentNode.js
// @ts-nocheck


/**
 * @param element
 */
function getParentNode(element) {
    if (getNodeName(element) === 'html') {
        return element;
    }
    return (
    // $FlowFixMe: this is a quicker (but less type safe) way to save quite some bytes from the bundle
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
        element.parentNode || // DOM Element detected
        // $FlowFixMe: need a better way to handle this...
        element.host || // ShadowRoot detected
        // $FlowFixMe: HTMLElement is a Node
        getDocumentElement(element) // fallback
    );
}
//# sourceMappingURL=getParentNode.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getScrollParent.js
// @ts-nocheck




/**
 * @param node
 */
function getScrollParent(node) {
    if (['html', 'body', '#document'].indexOf(getNodeName(node)) >= 0) {
        // $FlowFixMe: assume body is always available
        return node.ownerDocument.body;
    }
    if (isHTMLElement(node) && isScrollParent(node)) {
        return node;
    }
    return getScrollParent(getParentNode(node));
}
//# sourceMappingURL=getScrollParent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/listScrollParents.js
// @ts-nocheck





/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/
/**
 * @param element
 * @param list
 */
function listScrollParents(element, list = []) {
    const scrollParent = getScrollParent(element);
    const isBody = getNodeName(scrollParent) === 'body';
    const win = getWindow(scrollParent);
    const target = isBody
        ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : [])
        : scrollParent;
    const updatedList = list.concat(target);
    return isBody
        ? updatedList // $FlowFixMe: isBody tells us target will be an HTMLElement here
        : updatedList.concat(listScrollParents(getParentNode(target)));
}
//# sourceMappingURL=listScrollParents.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/isTableElement.js
// @ts-nocheck

/**
 * @param element
 */
function isTableElement(element) {
    return ['table', 'td', 'th'].indexOf(getNodeName(element)) >= 0;
}
//# sourceMappingURL=isTableElement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getOffsetParent.js
// @ts-nocheck







/**
 * @param element
 */
function getTrueOffsetParent(element) {
    if (!isHTMLElement(element) || // https://github.com/popperjs/popper-core/issues/837
        getComputedStyle_getComputedStyle(element).position === 'fixed') {
        return null;
    }
    const offsetParent = element.offsetParent;
    if (offsetParent) {
        const html = getDocumentElement(offsetParent);
        if (getNodeName(offsetParent) === 'body' &&
            getComputedStyle_getComputedStyle(offsetParent).position === 'static' &&
            getComputedStyle_getComputedStyle(html).position !== 'static') {
            return html;
        }
    }
    return offsetParent;
}
// `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block
/**
 * @param element
 */
function getContainingBlock(element) {
    let currentNode = getParentNode(element);
    while (isHTMLElement(currentNode) && ['html', 'body'].indexOf(getNodeName(currentNode)) < 0) {
        const css = getComputedStyle_getComputedStyle(currentNode);
        // This is non-exhaustive but covers the most common CSS properties that
        // create a containing block.
        if (css.transform !== 'none' || css.perspective !== 'none' || (css.willChange && css.willChange !== 'auto')) {
            return currentNode;
        }
        else {
            currentNode = currentNode.parentNode;
        }
    }
    return null;
}
// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
/**
 * @param element
 */
function getOffsetParent(element) {
    const window = getWindow(element);
    let offsetParent = getTrueOffsetParent(element);
    while (offsetParent && isTableElement(offsetParent) && getComputedStyle_getComputedStyle(offsetParent).position === 'static') {
        offsetParent = getTrueOffsetParent(offsetParent);
    }
    if (offsetParent && getNodeName(offsetParent) === 'body' && getComputedStyle_getComputedStyle(offsetParent).position === 'static') {
        return window;
    }
    return offsetParent || getContainingBlock(element) || window;
}
//# sourceMappingURL=getOffsetParent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/enums.js
// @ts-nocheck
const enums_top = 'top';
const bottom = 'bottom';
const right = 'right';
const left = 'left';
const auto = 'auto';
const basePlacements = [enums_top, bottom, right, left];
const start = 'start';
const end = 'end';
const clippingParents = 'clippingParents';
const viewport = 'viewport';
const popper = 'popper';
const reference = 'reference';
const variationPlacements = basePlacements.reduce((acc, placement) => acc.concat([`${placement}-${start}`, `${placement}-${end}`]), []);
const enums_placements = [...basePlacements, auto].reduce((acc, placement) => acc.concat([placement, `${placement}-${start}`, `${placement}-${end}`]), []);
// modifiers that need to read the DOM
const beforeRead = 'beforeRead';
const read = 'read';
const afterRead = 'afterRead';
// pure-logic modifiers
const beforeMain = 'beforeMain';
const main = 'main';
const afterMain = 'afterMain';
// modifier with the purpose to write to the DOM (or write into a framework state)
const beforeWrite = 'beforeWrite';
const write = 'write';
const afterWrite = 'afterWrite';
const modifierPhases = [
    beforeRead,
    read,
    afterRead,
    beforeMain,
    main,
    afterMain,
    beforeWrite,
    write,
    afterWrite
];
//# sourceMappingURL=enums.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/orderModifiers.js

// source: https://stackoverflow.com/questions/49875255
/**
 * @param modifiers
 */
function order(modifiers) {
    const map = new Map();
    const visited = new Set();
    const result = [];
    modifiers.forEach(modifier => {
        map.set(modifier.name, modifier);
    });
    // On visiting object, check for its dependencies and visit them recursively
    /**
     * @param modifier
     */
    function sort(modifier) {
        visited.add(modifier.name);
        const requires = [...(modifier.requires || []), ...(modifier.requiresIfExists || [])];
        requires.forEach(dep => {
            if (!visited.has(dep)) {
                const depModifier = map.get(dep);
                if (depModifier) {
                    sort(depModifier);
                }
            }
        });
        result.push(modifier);
    }
    modifiers.forEach(modifier => {
        if (!visited.has(modifier.name)) {
            // check for visited object
            sort(modifier);
        }
    });
    return result;
}
/**
 * @param modifiers
 */
function orderModifiers(modifiers) {
    // order based on dependencies
    const orderedModifiers = order(modifiers);
    // order based on phase
    return modifierPhases.reduce((acc, phase) => acc.concat(orderedModifiers.filter(modifier => modifier.phase === phase)), []);
}
//# sourceMappingURL=orderModifiers.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/debounce.js
// @ts-nocheck
/**
 * @param fn
 */
function debounce_debounce(fn) {
    let pending;
    return () => {
        if (!pending) {
            pending = new Promise(resolve => {
                Promise.resolve().then(() => {
                    pending = undefined;
                    resolve(fn());
                });
            });
        }
        return pending;
    };
}
//# sourceMappingURL=debounce.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/mergeByName.js
/**
 * @param modifiers
 */
function mergeByName(modifiers) {
    const merged = modifiers.reduce((merged, current) => {
        const existing = merged[current.name];
        merged[current.name] = existing
            ? Object.assign(Object.assign(Object.assign({}, existing), current), { options: Object.assign(Object.assign({}, existing.options), current.options), data: Object.assign(Object.assign({}, existing.data), current.data) }) : current;
        return merged;
    }, {});
    // IE11 does not support Object.values
    return Object.keys(merged).map(key => merged[key]);
}
//# sourceMappingURL=mergeByName.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/index.js
















const INVALID_ELEMENT_ERROR = 'Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.';
const INFINITE_LOOP_ERROR = 'Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.';
const DEFAULT_OPTIONS = {
    placement: 'bottom',
    modifiers: [],
    strategy: 'absolute'
};
/**
 * @param args
 */
function areValidElements(...args) {
    return !args.some(element => !(element && typeof element.getBoundingClientRect === 'function'));
}
/**
 * @param generatorOptions
 */
function popperGenerator(generatorOptions = {}) {
    const { defaultModifiers = [], defaultOptions = DEFAULT_OPTIONS } = generatorOptions;
    return function createPopper(reference, popper, options = defaultOptions) {
        let state = {
            placement: 'bottom',
            orderedModifiers: [],
            options: Object.assign(Object.assign({}, DEFAULT_OPTIONS), defaultOptions),
            modifiersData: {},
            elements: {
                reference,
                popper
            },
            attributes: {},
            styles: {}
        };
        let effectCleanupFns = [];
        let isDestroyed = false;
        const instance = {
            state,
            setOptions(options) {
                cleanupModifierEffects();
                state.options = Object.assign(Object.assign(Object.assign({}, defaultOptions), state.options), options);
                state.scrollParents = {
                    reference: isElement(reference)
                        ? listScrollParents(reference)
                        : reference.contextElement
                            ? listScrollParents(reference.contextElement)
                            : [],
                    popper: listScrollParents(popper)
                };
                // Orders the modifiers based on their dependencies and `phase`
                // properties
                const orderedModifiers = orderModifiers(mergeByName([...defaultModifiers, ...state.options.modifiers]));
                // Strip out disabled modifiers
                state.orderedModifiers = orderedModifiers.filter(m => m.enabled);
                // Validate the provided modifiers so that the consumer will get warned
                // if one of the modifiers is invalid for any reason
                if (false /* __DEV__*/) {}
                runModifierEffects();
                return instance.update();
            },
            // Sync update – it will always be executed, even if not necessary. This
            // is useful for low frequency updates where sync behavior simplifies the
            // logic.
            // For high frequency updates (e.g. `resize` and `scroll` events), always
            // prefer the async Popper#update method
            forceUpdate() {
                if (isDestroyed) {
                    return;
                }
                const { reference, popper } = state.elements;
                // Don't proceed if `reference` or `popper` are not valid elements
                // anymore
                if (!areValidElements(reference, popper)) {
                    if (false /* __DEV__*/) {}
                    return;
                }
                // Store the reference and popper rects to be read by modifiers
                state.rects = {
                    reference: getCompositeRect(reference, getOffsetParent(popper), state.options.strategy === 'fixed'),
                    popper: getLayoutRect(popper)
                };
                // Modifiers have the ability to reset the current update cycle. The
                // most common use case for this is the `flip` modifier changing the
                // placement, which then needs to re-run all the modifiers, because the
                // logic was previously ran for the previous placement and is therefore
                // stale/incorrect
                state.reset = false;
                state.placement = state.options.placement;
                // On each update cycle, the `modifiersData` property for each modifier
                // is filled with the initial data specified by the modifier. This means
                // it doesn't persist and is fresh on each update.
                // To ensure persistent data, use `${name}#persistent`
                state.orderedModifiers.forEach(modifier => (state.modifiersData[modifier.name] = Object.assign({}, modifier.data)));
                let __debug_loops__ = 0;
                for (let index = 0; index < state.orderedModifiers.length; index++) {
                    if (false /* __DEV__*/) {}
                    if (state.reset === true) {
                        state.reset = false;
                        index = -1;
                        continue;
                    }
                    const { fn, options = {}, name } = state.orderedModifiers[index];
                    if (typeof fn === 'function') {
                        state = fn({ state, options, name, instance }) || state;
                    }
                }
            },
            // Async and optimistically optimized update – it will not be executed if
            // not necessary (debounced to run at most once-per-tick)
            update: debounce_debounce(() => new Promise(resolve => {
                instance.forceUpdate();
                resolve(state);
            })),
            destroy() {
                cleanupModifierEffects();
                isDestroyed = true;
            }
        };
        if (!areValidElements(reference, popper)) {
            if (false /* __DEV__*/) {}
            return instance;
        }
        instance.setOptions(options).then(state => {
            if (!isDestroyed && options.onFirstUpdate) {
                options.onFirstUpdate(state);
            }
        });
        // Modifiers have the ability to execute arbitrary code before the first
        // update cycle runs. They will be executed in the same order as the update
        // cycle. This is useful when a modifier adds some persistent data that
        // other modifiers need to use, but the modifier is run after the dependent
        // one.
        /**
         *
         */
        function runModifierEffects() {
            state.orderedModifiers.forEach(({ name, options = {}, effect }) => {
                if (typeof effect === 'function') {
                    const cleanupFn = effect({ state, name, instance, options });
                    const noopFn = () => { };
                    effectCleanupFns.push(cleanupFn || noopFn);
                }
            });
        }
        /**
         *
         */
        function cleanupModifierEffects() {
            effectCleanupFns.forEach(fn => fn());
            effectCleanupFns = [];
        }
        return instance;
    };
}
const createPopper = popperGenerator();
// eslint-disable-next-line import/no-unused-modules

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/eventListeners.js

const passive = { passive: true };
/**
 *
 */
function effect({ state, instance, options }) {
    const { scroll = true, resize = true } = options;
    const window = getWindow(state.elements.popper);
    const scrollParents = [...state.scrollParents.reference, ...state.scrollParents.popper];
    if (scroll) {
        scrollParents.forEach(scrollParent => {
            scrollParent.addEventListener('scroll', instance.update, passive);
        });
    }
    if (resize) {
        window.addEventListener('resize', instance.update, passive);
    }
    return () => {
        if (scroll) {
            scrollParents.forEach(scrollParent => {
                scrollParent.removeEventListener('scroll', instance.update, passive);
            });
        }
        if (resize) {
            window.removeEventListener('resize', instance.update, passive);
        }
    };
}
/* harmony default export */ const eventListeners = ({
    name: 'eventListeners',
    enabled: true,
    phase: 'write',
    fn: () => { },
    effect,
    data: {}
});
//# sourceMappingURL=eventListeners.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getBasePlacement.js
/**
 * @param placement
 */
function getBasePlacement(placement) {
    return placement.split('-')[0];
}
//# sourceMappingURL=getBasePlacement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getVariation.js
/**
 * @param placement
 */
function getVariation(placement) {
    return placement.split('-')[1];
}
//# sourceMappingURL=getVariation.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getMainAxisFromPlacement.js
/**
 * @param placement
 */
function getMainAxisFromPlacement(placement) {
    return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}
//# sourceMappingURL=getMainAxisFromPlacement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/computeOffsets.js
// @ts-nocheck




/**
 *
 */
function computeOffsets({ reference, element, placement }) {
    const basePlacement = placement ? getBasePlacement(placement) : null;
    const variation = placement ? getVariation(placement) : null;
    const commonX = reference.x + reference.width / 2 - element.width / 2;
    const commonY = reference.y + reference.height / 2 - element.height / 2;
    let offsets;
    switch (basePlacement) {
        case enums_top:
            offsets = {
                x: commonX,
                y: reference.y - element.height
            };
            break;
        case bottom:
            offsets = {
                x: commonX,
                y: reference.y + reference.height
            };
            break;
        case right:
            offsets = {
                x: reference.x + reference.width,
                y: commonY
            };
            break;
        case left:
            offsets = {
                x: reference.x - element.width,
                y: commonY
            };
            break;
        default:
            offsets = {
                x: reference.x,
                y: reference.y
            };
    }
    const mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;
    if (mainAxis != null) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        switch (variation) {
            case start:
                offsets[mainAxis] = Math.floor(offsets[mainAxis]) - Math.floor(reference[len] / 2 - element[len] / 2);
                break;
            case end:
                offsets[mainAxis] = Math.floor(offsets[mainAxis]) + Math.ceil(reference[len] / 2 - element[len] / 2);
                break;
            default:
        }
    }
    return offsets;
}
//# sourceMappingURL=computeOffsets.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/popperOffsets.js

/**
 *
 */
function popperOffsets({ state, name }) {
    // Offsets are the actual position the popper needs to have to be
    // properly positioned near its reference element
    // This is the most basic placement, and will be adjusted by
    // the modifiers in the next step
    state.modifiersData[name] = computeOffsets({
        reference: state.rects.reference,
        element: state.rects.popper,
        strategy: 'absolute',
        placement: state.placement
    });
}
/* harmony default export */ const modifiers_popperOffsets = ({
    name: 'popperOffsets',
    enabled: true,
    phase: 'read',
    fn: popperOffsets,
    data: {}
});
//# sourceMappingURL=popperOffsets.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/computeStyles.js






const unsetSides = {
    top: 'auto',
    right: 'auto',
    bottom: 'auto',
    left: 'auto'
};
// Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.
/**
 *
 */
function roundOffsets({ x, y }) {
    const win = window;
    const dpr = win.devicePixelRatio || 1;
    return {
        x: Math.round(x * dpr) / dpr || 0,
        y: Math.round(y * dpr) / dpr || 0
    };
}
/**
 *
 */
function mapToStyles({ popper, popperRect, placement, offsets, position, gpuAcceleration, adaptive }) {
    let { x, y } = roundOffsets(offsets);
    const hasX = offsets.hasOwnProperty('x');
    const hasY = offsets.hasOwnProperty('y');
    let sideX = left;
    let sideY = enums_top;
    const win = window;
    if (adaptive) {
        let offsetParent = getOffsetParent(popper);
        if (offsetParent === getWindow(popper)) {
            offsetParent = getDocumentElement(popper);
        }
        // $FlowFixMe: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it
        /* :: offsetParent = (offsetParent: Element); */
        if (placement === enums_top) {
            sideY = bottom;
            y -= offsetParent.clientHeight - popperRect.height;
            y *= gpuAcceleration ? 1 : -1;
        }
        if (placement === left) {
            sideX = right;
            x -= offsetParent.clientWidth - popperRect.width;
            x *= gpuAcceleration ? 1 : -1;
        }
    }
    const commonStyles = Object.assign({ position }, (adaptive && unsetSides));
    if (gpuAcceleration) {
        return Object.assign(Object.assign({}, commonStyles), { [sideY]: hasY ? '0' : '', [sideX]: hasX ? '0' : '', 
            // Layer acceleration can disable subpixel rendering which causes slightly
            // blurry text on low PPI displays, so we want to use 2D transforms
            // instead
            transform: (win.devicePixelRatio || 1) < 2 ? `translate(${x}px, ${y}px)` : `translate3d(${x}px, ${y}px, 0)` });
    }
    return Object.assign(Object.assign({}, commonStyles), { [sideY]: hasY ? `${y}px` : '', [sideX]: hasX ? `${x}px` : '', transform: '' });
}
/**
 *
 */
function computeStyles({ state, options }) {
    const { gpuAcceleration = true, adaptive = true } = options;
    if (false /* __DEV__*/) {}
    const commonStyles = {
        placement: getBasePlacement(state.placement),
        popper: state.elements.popper,
        popperRect: state.rects.popper,
        gpuAcceleration
    };
    if (state.modifiersData.popperOffsets != null) {
        state.styles.popper = Object.assign(Object.assign({}, state.styles.popper), mapToStyles(Object.assign(Object.assign({}, commonStyles), { offsets: state.modifiersData.popperOffsets, position: state.options.strategy, adaptive })));
    }
    if (state.modifiersData.arrow != null) {
        state.styles.arrow = Object.assign(Object.assign({}, state.styles.arrow), mapToStyles(Object.assign(Object.assign({}, commonStyles), { offsets: state.modifiersData.arrow, position: 'absolute', adaptive: false })));
    }
    state.attributes.popper = Object.assign(Object.assign({}, state.attributes.popper), { 'data-popper-placement': state.placement });
}
/* harmony default export */ const modifiers_computeStyles = ({
    name: 'computeStyles',
    enabled: true,
    phase: 'beforeWrite',
    fn: computeStyles,
    data: {}
});
//# sourceMappingURL=computeStyles.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/applyStyles.js


// This modifier takes the styles prepared by the `computeStyles` modifier
// and applies them to the HTMLElements such as popper and arrow
/**
 *
 */
function applyStyles({ state }) {
    Object.keys(state.elements).forEach(name => {
        const style = state.styles[name] || {};
        const attributes = state.attributes[name] || {};
        const element = state.elements[name];
        // arrow is optional + virtual elements
        if (!isHTMLElement(element) || !getNodeName(element)) {
            return;
        }
        // Flow doesn't support to extend this property, but it's the most
        // effective way to apply styles to an HTMLElement
        // $FlowFixMe
        Object.assign(element.style, style);
        Object.keys(attributes).forEach(name => {
            const value = attributes[name];
            if (value === false) {
                element.removeAttribute(name);
            }
            else {
                element.setAttribute(name, value === true ? '' : value);
            }
        });
    });
}
/**
 *
 */
function applyStyles_effect({ state }) {
    const initialStyles = {
        popper: {
            position: state.options.strategy,
            left: '0',
            top: '0',
            margin: '0'
        },
        arrow: {
            position: 'absolute'
        },
        reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    if (state.elements.arrow) {
        Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }
    return () => {
        Object.keys(state.elements).forEach(name => {
            const element = state.elements[name];
            const attributes = state.attributes[name] || {};
            const styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]);
            // Set all values to an empty string to unset them
            const style = styleProperties.reduce((style, property) => {
                style[property] = '';
                return style;
            }, {});
            // arrow is optional + virtual elements
            if (!isHTMLElement(element) || !getNodeName(element)) {
                return;
            }
            // Flow doesn't support to extend this property, but it's the most
            // effective way to apply styles to an HTMLElement
            // $FlowFixMe
            Object.assign(element.style, style);
            Object.keys(attributes).forEach(attribute => {
                element.removeAttribute(attribute);
            });
        });
    };
}
/* harmony default export */ const modifiers_applyStyles = ({
    name: 'applyStyles',
    enabled: true,
    phase: 'write',
    fn: applyStyles,
    effect: applyStyles_effect,
    requires: ['computeStyles']
});
//# sourceMappingURL=applyStyles.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/offset.js


/**
 * @param placement
 * @param rects
 * @param offset
 */
function distanceAndSkiddingToXY(placement, rects, offset) {
    const basePlacement = getBasePlacement(placement);
    const invertDistance = [left, enums_top].indexOf(basePlacement) >= 0 ? -1 : 1;
    let [skidding, distance] = typeof offset === 'function'
        ? offset(Object.assign(Object.assign({}, rects), { placement }))
        : offset;
    skidding = skidding || 0;
    distance = (distance || 0) * invertDistance;
    return [left, right].indexOf(basePlacement) >= 0 ? { x: distance, y: skidding } : { x: skidding, y: distance };
}
/**
 *
 */
function offset({ state, options, name }) {
    const { offset = [0, 0] } = options;
    const data = enums_placements.reduce((acc, placement) => {
        acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
        return acc;
    }, {});
    const { x, y } = data[state.placement];
    if (state.modifiersData.popperOffsets != null) {
        state.modifiersData.popperOffsets.x += x;
        state.modifiersData.popperOffsets.y += y;
    }
    state.modifiersData[name] = data;
}
/* harmony default export */ const modifiers_offset = ({
    name: 'offset',
    enabled: true,
    phase: 'main',
    requires: ['popperOffsets'],
    fn: offset
});
//# sourceMappingURL=offset.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getOppositePlacement.js
const hash = { left: 'right', right: 'left', bottom: 'top', top: 'bottom' };
/**
 * @param placement
 */
function getOppositePlacement(placement) {
    return placement.replace(/left|right|bottom|top/g, matched => hash[matched]);
}
//# sourceMappingURL=getOppositePlacement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getOppositeVariationPlacement.js
const getOppositeVariationPlacement_hash = { start: 'end', end: 'start' };
/**
 * @param placement
 */
function getOppositeVariationPlacement(placement) {
    return placement.replace(/start|end/g, matched => getOppositeVariationPlacement_hash[matched]);
}
//# sourceMappingURL=getOppositeVariationPlacement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getViewportRect.js
// @ts-nocheck



/**
 * @param element
 */
function getViewportRect(element) {
    const win = getWindow(element);
    const html = getDocumentElement(element);
    const visualViewport = win.visualViewport;
    let width = html.clientWidth;
    let height = html.clientHeight;
    let x = 0;
    let y = 0;
    // NB: This isn't supported on iOS <= 12. If the keyboard is open, the popper
    // can be obscured underneath it.
    // Also, `html.clientHeight` adds the bottom bar height in Safari iOS, even
    // if it isn't open, so if this isn't available, the popper will be detected
    // to overflow the bottom of the screen too early.
    if (visualViewport) {
        width = visualViewport.width;
        height = visualViewport.height;
        // Uses Layout Viewport (like Chrome; Safari does not currently)
        // In Chrome, it returns a value very close to 0 (+/-) but contains rounding
        // errors due to floating point numbers, so we need to check precision.
        // Safari returns a number <= 0, usually < -1 when pinch-zoomed
        // Feature detection fails in mobile emulation mode in Chrome.
        // Math.abs(win.innerWidth / visualViewport.scale - visualViewport.width) <
        // 0.001
        // Fallback here: "Not Safari" userAgent
        if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
            x = visualViewport.offsetLeft;
            y = visualViewport.offsetTop;
        }
    }
    return {
        width,
        height,
        x: x + getWindowScrollBarX(element),
        y
    };
}
//# sourceMappingURL=getViewportRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getDocumentRect.js




// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable
/**
 * @param element
 */
function getDocumentRect(element) {
    const html = getDocumentElement(element);
    const winScroll = getWindowScroll(element);
    const body = element.ownerDocument.body;
    const width = Math.max(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
    const height = Math.max(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
    let x = -winScroll.scrollLeft + getWindowScrollBarX(element);
    const y = -winScroll.scrollTop;
    if (getComputedStyle_getComputedStyle(body || html).direction === 'rtl') {
        x += Math.max(html.clientWidth, body ? body.clientWidth : 0) - width;
    }
    return { width, height, x, y };
}
//# sourceMappingURL=getDocumentRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/contains.js
// @ts-nocheck
/**
 * @param parent
 * @param child
 */
function contains(parent, child) {
    // $FlowFixMe: hasOwnProperty doesn't seem to work in tests
    const isShadow = Boolean(child.getRootNode && child.getRootNode().host);
    // First, attempt with faster native method
    if (parent.contains(child)) {
        return true;
    } // then fallback to custom implementation with Shadow DOM support
    else if (isShadow) {
        let next = child;
        do {
            if (next && parent.isSameNode(next)) {
                return true;
            }
            // $FlowFixMe: need a better way to handle this...
            next = next.parentNode || next.host;
        } while (next);
    }
    // Give up, the result is false
    return false;
}
//# sourceMappingURL=contains.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/rectToClientRect.js
/**
 * @param rect
 */
function rectToClientRect(rect) {
    return Object.assign(Object.assign({}, rect), { left: rect.x, top: rect.y, right: rect.x + rect.width, bottom: rect.y + rect.height });
}
//# sourceMappingURL=rectToClientRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/dom-utils/getClippingRect.js













/**
 * @param element
 */
function getInnerBoundingClientRect(element) {
    const rect = getBoundingClientRect(element);
    rect.top = rect.top + element.clientTop;
    rect.left = rect.left + element.clientLeft;
    rect.bottom = rect.top + element.clientHeight;
    rect.right = rect.left + element.clientWidth;
    rect.width = element.clientWidth;
    rect.height = element.clientHeight;
    rect.x = rect.left;
    rect.y = rect.top;
    return rect;
}
/**
 * @param element
 * @param clippingParent
 */
function getClientRectFromMixedType(element, clippingParent) {
    return clippingParent === viewport
        ? rectToClientRect(getViewportRect(element))
        : isHTMLElement(clippingParent)
            ? getInnerBoundingClientRect(clippingParent)
            : rectToClientRect(getDocumentRect(getDocumentElement(element)));
}
// A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`
/**
 * @param element
 */
function getClippingParents(element) {
    const clippingParents = listScrollParents(getParentNode(element));
    const canEscapeClipping = ['absolute', 'fixed'].indexOf(getComputedStyle_getComputedStyle(element).position) >= 0;
    const clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;
    if (!isElement(clipperElement)) {
        return [];
    }
    // $FlowFixMe: https://github.com/facebook/flow/issues/1414
    return clippingParents.filter(clippingParent => isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== 'body');
}
// Gets the maximum area that the element is visible in due to any number of
// clipping parents
/**
 * @param element
 * @param boundary
 * @param rootBoundary
 */
function getClippingRect(element, boundary, rootBoundary) {
    const mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
    const clippingParents = [...mainClippingParents, rootBoundary];
    const firstClippingParent = clippingParents[0];
    const clippingRect = clippingParents.reduce((accRect, clippingParent) => {
        const rect = getClientRectFromMixedType(element, clippingParent);
        accRect.top = Math.max(rect.top, accRect.top);
        accRect.right = Math.min(rect.right, accRect.right);
        accRect.bottom = Math.min(rect.bottom, accRect.bottom);
        accRect.left = Math.max(rect.left, accRect.left);
        return accRect;
    }, getClientRectFromMixedType(element, firstClippingParent));
    clippingRect.width = clippingRect.right - clippingRect.left;
    clippingRect.height = clippingRect.bottom - clippingRect.top;
    clippingRect.x = clippingRect.left;
    clippingRect.y = clippingRect.top;
    return clippingRect;
}
//# sourceMappingURL=getClippingRect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getFreshSideObject.js
/**
 *
 */
function getFreshSideObject() {
    return {
        top: 0,
        right: 0,
        bottom: 0,
        left: 0
    };
}
//# sourceMappingURL=getFreshSideObject.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/mergePaddingObject.js

/**
 * @param paddingObject
 */
function mergePaddingObject(paddingObject) {
    return Object.assign(Object.assign({}, getFreshSideObject()), paddingObject);
}
//# sourceMappingURL=mergePaddingObject.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/expandToHashMap.js
// @ts-nocheck
/**
 * @param value
 * @param keys
 */
function expandToHashMap(value, keys) {
    return keys.reduce((hashMap, key) => {
        hashMap[key] = value;
        return hashMap;
    }, {});
}
//# sourceMappingURL=expandToHashMap.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/detectOverflow.js









/**
 * @param state
 * @param options
 */
function detectOverflow(state, options = {}) {
    const { placement = state.placement, boundary = clippingParents, rootBoundary = viewport, elementContext = popper, altBoundary = false, padding = 0 } = options;
    const paddingObject = mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements));
    const altContext = elementContext === popper ? reference : popper;
    const referenceElement = state.elements.reference;
    const popperRect = state.rects.popper;
    const element = state.elements[altBoundary ? altContext : elementContext];
    const clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary);
    const referenceClientRect = getBoundingClientRect(referenceElement);
    const popperOffsets = computeOffsets({
        reference: referenceClientRect,
        element: popperRect,
        strategy: 'absolute',
        placement
    });
    const popperClientRect = rectToClientRect(Object.assign(Object.assign({}, popperRect), popperOffsets));
    const elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect;
    // positive = overflowing the clipping rect
    // 0 or negative = within the clipping rect
    const overflowOffsets = {
        top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
        bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
        left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
        right: elementClientRect.right - clippingClientRect.right + paddingObject.right
    };
    const offsetData = state.modifiersData.offset;
    // Offsets can be applied only to the popper element
    if (elementContext === popper && offsetData) {
        const offset = offsetData[placement];
        Object.keys(overflowOffsets).forEach(key => {
            const multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
            const axis = [enums_top, bottom].indexOf(key) >= 0 ? 'y' : 'x';
            overflowOffsets[key] += offset[axis] * multiply;
        });
    }
    return overflowOffsets;
}
//# sourceMappingURL=detectOverflow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/computeAutoPlacement.js




/* :: type OverflowsMap = { [ComputedPlacement]: number }; */
/* ;; type OverflowsMap = { [key in ComputedPlacement]: number }; */
/**
 * @param state
 * @param options
 */
function computeAutoPlacement(state, options = {}) {
    const { placement, boundary, rootBoundary, padding, flipVariations, allowedAutoPlacements = enums_placements } = options;
    const variation = getVariation(placement);
    const placements = variation
        ? flipVariations
            ? variationPlacements
            : variationPlacements.filter(placement => getVariation(placement) === variation)
        : basePlacements;
    // $FlowFixMe
    let allowedPlacements = placements.filter(placement => allowedAutoPlacements.indexOf(placement) >= 0);
    if (allowedPlacements.length === 0) {
        allowedPlacements = placements;
        if (false /* __DEV__*/) {}
    }
    // $FlowFixMe: Flow seems to have problems with two array unions...
    const overflows = allowedPlacements.reduce((acc, placement) => {
        acc[placement] = detectOverflow(state, {
            placement,
            boundary,
            rootBoundary,
            padding
        })[getBasePlacement(placement)];
        return acc;
    }, {});
    return Object.keys(overflows).sort((a, b) => overflows[a] - overflows[b]);
}
//# sourceMappingURL=computeAutoPlacement.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/flip.js







/**
 * @param placement
 */
function getExpandedFallbackPlacements(placement) {
    if (getBasePlacement(placement) === auto) {
        return [];
    }
    const oppositePlacement = getOppositePlacement(placement);
    return [
        getOppositeVariationPlacement(placement),
        oppositePlacement,
        getOppositeVariationPlacement(oppositePlacement)
    ];
}
/**
 *
 */
function flip({ state, options, name }) {
    if (state.modifiersData[name]._skip) {
        return;
    }
    const { mainAxis: checkMainAxis = true, altAxis: checkAltAxis = true, fallbackPlacements: specifiedFallbackPlacements, padding, boundary, rootBoundary, altBoundary, flipVariations = true, allowedAutoPlacements } = options;
    const preferredPlacement = state.options.placement;
    const basePlacement = getBasePlacement(preferredPlacement);
    const isBasePlacement = basePlacement === preferredPlacement;
    const fallbackPlacements = specifiedFallbackPlacements ||
        (isBasePlacement || !flipVariations
            ? [getOppositePlacement(preferredPlacement)]
            : getExpandedFallbackPlacements(preferredPlacement));
    const placements = [preferredPlacement, ...fallbackPlacements].reduce((acc, placement) => acc.concat(getBasePlacement(placement) === auto
        ? computeAutoPlacement(state, {
            placement,
            boundary,
            rootBoundary,
            padding,
            flipVariations,
            allowedAutoPlacements
        })
        : placement), []);
    const referenceRect = state.rects.reference;
    const popperRect = state.rects.popper;
    const checksMap = new Map();
    let makeFallbackChecks = true;
    let firstFittingPlacement = placements[0];
    for (let i = 0; i < placements.length; i++) {
        const placement = placements[i];
        const basePlacement = getBasePlacement(placement);
        const isStartVariation = getVariation(placement) === start;
        const isVertical = [enums_top, bottom].indexOf(basePlacement) >= 0;
        const len = isVertical ? 'width' : 'height';
        const overflow = detectOverflow(state, {
            placement,
            boundary,
            rootBoundary,
            altBoundary,
            padding
        });
        let mainVariationSide = isVertical ? (isStartVariation ? right : left) : isStartVariation ? bottom : enums_top;
        if (referenceRect[len] > popperRect[len]) {
            mainVariationSide = getOppositePlacement(mainVariationSide);
        }
        const altVariationSide = getOppositePlacement(mainVariationSide);
        const checks = [];
        if (checkMainAxis) {
            checks.push(overflow[basePlacement] <= 0);
        }
        if (checkAltAxis) {
            checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
        }
        if (checks.every(check => check)) {
            firstFittingPlacement = placement;
            makeFallbackChecks = false;
            break;
        }
        checksMap.set(placement, checks);
    }
    if (makeFallbackChecks) {
        // `2` may be desired in some cases – research later
        const numberOfChecks = flipVariations ? 3 : 1;
        for (let i = numberOfChecks; i > 0; i--) {
            const fittingPlacement = placements.find(placement => {
                const checks = checksMap.get(placement);
                if (checks) {
                    return checks.slice(0, i).every(check => check);
                }
            });
            if (fittingPlacement) {
                firstFittingPlacement = fittingPlacement;
                break;
            }
        }
    }
    if (state.placement !== firstFittingPlacement) {
        state.modifiersData[name]._skip = true;
        state.placement = firstFittingPlacement;
        state.reset = true;
    }
}
/* harmony default export */ const modifiers_flip = ({
    name: 'flip',
    enabled: true,
    phase: 'main',
    fn: flip,
    requiresIfExists: ['offset'],
    data: { _skip: false }
});
//# sourceMappingURL=flip.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/getAltAxis.js
// @ts-nocheck
/**
 * @param axis
 */
function getAltAxis(axis) {
    return axis === 'x' ? 'y' : 'x';
}
//# sourceMappingURL=getAltAxis.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/utils/within.js
// @ts-nocheck
/**
 * @param min
 * @param value
 * @param max
 */
function within(min, value, max) {
    return Math.max(min, Math.min(value, max));
}
//# sourceMappingURL=within.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/preventOverflow.js
// @ts-nocheck










/**
 *
 */
function preventOverflow({ state, options, name }) {
    const { mainAxis: checkMainAxis = true, altAxis: checkAltAxis = false, boundary, rootBoundary, altBoundary, padding, tether = true, tetherOffset = 0 } = options;
    const overflow = detectOverflow(state, {
        boundary,
        rootBoundary,
        padding,
        altBoundary
    });
    const basePlacement = getBasePlacement(state.placement);
    const variation = getVariation(state.placement);
    const isBasePlacement = !variation;
    const mainAxis = getMainAxisFromPlacement(basePlacement);
    const altAxis = getAltAxis(mainAxis);
    const popperOffsets = state.modifiersData.popperOffsets;
    const referenceRect = state.rects.reference;
    const popperRect = state.rects.popper;
    const tetherOffsetValue = typeof tetherOffset === 'function'
        ? tetherOffset(Object.assign(Object.assign({}, state.rects), { placement: state.placement }))
        : tetherOffset;
    const data = { x: 0, y: 0 };
    if (!popperOffsets) {
        return;
    }
    if (checkMainAxis) {
        const mainSide = mainAxis === 'y' ? enums_top : left;
        const altSide = mainAxis === 'y' ? bottom : right;
        const len = mainAxis === 'y' ? 'height' : 'width';
        const offset = popperOffsets[mainAxis];
        const min = popperOffsets[mainAxis] + overflow[mainSide];
        const max = popperOffsets[mainAxis] - overflow[altSide];
        const additive = tether ? -popperRect[len] / 2 : 0;
        const minLen = variation === start ? referenceRect[len] : popperRect[len];
        const maxLen = variation === start ? -popperRect[len] : -referenceRect[len];
        // We need to include the arrow in the calculation so the arrow doesn't go
        // outside the reference bounds
        const arrowElement = state.elements.arrow;
        const arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : { width: 0, height: 0 };
        const arrowPaddingObject = state.modifiersData['arrow#persistent']
            ? state.modifiersData['arrow#persistent'].padding
            : getFreshSideObject();
        const arrowPaddingMin = arrowPaddingObject[mainSide];
        const arrowPaddingMax = arrowPaddingObject[altSide];
        // If the reference length is smaller than the arrow length, we don't want
        // to include its full size in the calculation. If the reference is small
        // and near the edge of a boundary, the popper can overflow even if the
        // reference is not overflowing as well (e.g. virtual elements with no
        // width or height)
        const arrowLen = within(0, referenceRect[len], arrowRect[len]);
        const minOffset = isBasePlacement
            ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - tetherOffsetValue
            : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
        const maxOffset = isBasePlacement
            ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + tetherOffsetValue
            : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
        const arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
        const clientOffset = arrowOffsetParent
            ? mainAxis === 'y'
                ? arrowOffsetParent.clientTop || 0
                : arrowOffsetParent.clientLeft || 0
            : 0;
        const offsetModifierValue = state.modifiersData.offset ? state.modifiersData.offset[state.placement][mainAxis] : 0;
        const tetherMin = popperOffsets[mainAxis] + minOffset - offsetModifierValue - clientOffset;
        const tetherMax = popperOffsets[mainAxis] + maxOffset - offsetModifierValue;
        const preventedOffset = within(tether ? Math.min(min, tetherMin) : min, offset, tether ? Math.max(max, tetherMax) : max);
        popperOffsets[mainAxis] = preventedOffset;
        data[mainAxis] = preventedOffset - offset;
    }
    if (checkAltAxis) {
        const mainSide = mainAxis === 'x' ? enums_top : left;
        const altSide = mainAxis === 'x' ? bottom : right;
        const offset = popperOffsets[altAxis];
        const min = offset + overflow[mainSide];
        const max = offset - overflow[altSide];
        const preventedOffset = within(min, offset, max);
        popperOffsets[altAxis] = preventedOffset;
        data[altAxis] = preventedOffset - offset;
    }
    state.modifiersData[name] = data;
}
/* harmony default export */ const modifiers_preventOverflow = ({
    name: 'preventOverflow',
    enabled: true,
    phase: 'main',
    fn: preventOverflow,
    requiresIfExists: ['offset']
});
//# sourceMappingURL=preventOverflow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/arrow.js










/**
 *
 */
function arrow({ state, name }) {
    const arrowElement = state.elements.arrow;
    const popperOffsets = state.modifiersData.popperOffsets;
    const basePlacement = getBasePlacement(state.placement);
    const axis = getMainAxisFromPlacement(basePlacement);
    const isVertical = [left, right].indexOf(basePlacement) >= 0;
    const len = isVertical ? 'height' : 'width';
    if (!arrowElement || !popperOffsets) {
        return;
    }
    const paddingObject = state.modifiersData[`${name}#persistent`].padding;
    const arrowRect = getLayoutRect(arrowElement);
    const minProp = axis === 'y' ? enums_top : left;
    const maxProp = axis === 'y' ? bottom : right;
    const endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
    const startDiff = popperOffsets[axis] - state.rects.reference[axis];
    const arrowOffsetParent = getOffsetParent(arrowElement);
    const clientSize = arrowOffsetParent
        ? axis === 'y'
            ? arrowOffsetParent.clientHeight || 0
            : arrowOffsetParent.clientWidth || 0
        : 0;
    const centerToReference = endDiff / 2 - startDiff / 2;
    // Make sure the arrow doesn't overflow the popper if the center point is
    // outside of the popper bounds
    const min = paddingObject[minProp];
    const max = clientSize - arrowRect[len] - paddingObject[maxProp];
    const center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
    const offset = within(min, center, max);
    // Prevents breaking syntax highlighting...
    const axisProp = axis;
    state.modifiersData[name] = {
        [axisProp]: offset,
        centerOffset: offset - center
    };
}
/**
 *
 */
function arrow_effect({ state, options, name }) {
    let { element: arrowElement = '[data-popper-arrow]', padding = 0 } = options;
    if (arrowElement == null) {
        return;
    }
    // CSS selector
    if (typeof arrowElement === 'string') {
        arrowElement = state.elements.popper.querySelector(arrowElement);
        if (!arrowElement) {
            return;
        }
    }
    if (false /* __DEV__*/) {}
    if (!contains(state.elements.popper, arrowElement)) {
        if (false /* __DEV__*/) {}
        return;
    }
    state.elements.arrow = arrowElement;
    state.modifiersData[`${name}#persistent`] = {
        padding: mergePaddingObject(typeof padding !== 'number' ? padding : expandToHashMap(padding, basePlacements))
    };
}
/* harmony default export */ const modifiers_arrow = ({
    name: 'arrow',
    enabled: true,
    phase: 'main',
    fn: arrow,
    effect: arrow_effect,
    requires: ['popperOffsets'],
    requiresIfExists: ['preventOverflow']
});
//# sourceMappingURL=arrow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/modifiers/hide.js


/**
 * @param overflow
 * @param rect
 * @param preventedOffsets
 */
function getSideOffsets(overflow, rect, preventedOffsets = { x: 0, y: 0 }) {
    return {
        top: overflow.top - rect.height - preventedOffsets.y,
        right: overflow.right - rect.width + preventedOffsets.x,
        bottom: overflow.bottom - rect.height + preventedOffsets.y,
        left: overflow.left - rect.width - preventedOffsets.x
    };
}
/**
 * @param overflow
 */
function isAnySideFullyClipped(overflow) {
    return [enums_top, right, bottom, left].some(side => overflow[side] >= 0);
}
/**
 *
 */
function hide({ state, name }) {
    const referenceRect = state.rects.reference;
    const popperRect = state.rects.popper;
    const preventedOffsets = state.modifiersData.preventOverflow;
    const referenceOverflow = detectOverflow(state, {
        elementContext: 'reference'
    });
    const popperAltOverflow = detectOverflow(state, {
        altBoundary: true
    });
    const referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
    const popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
    const isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
    const hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
    state.modifiersData[name] = {
        referenceClippingOffsets,
        popperEscapeOffsets,
        isReferenceHidden,
        hasPopperEscaped
    };
    state.attributes.popper = Object.assign(Object.assign({}, state.attributes.popper), { 'data-popper-reference-hidden': isReferenceHidden, 'data-popper-escaped': hasPopperEscaped });
}
/* harmony default export */ const modifiers_hide = ({
    name: 'hide',
    enabled: true,
    phase: 'main',
    requiresIfExists: ['preventOverflow'],
    fn: hide
});
//# sourceMappingURL=hide.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/popper-core/popper.js
// @ts-nocheck











const defaultModifiers = [
    eventListeners,
    modifiers_popperOffsets,
    modifiers_computeStyles,
    modifiers_applyStyles,
    modifiers_offset,
    modifiers_flip,
    modifiers_preventOverflow,
    modifiers_arrow,
    modifiers_hide
];
const popper_createPopper = popperGenerator({ defaultModifiers });
// eslint-disable-next-line import/no-unused-modules

//# sourceMappingURL=popper.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/useIsomorphicLayout.js


/**
 * Small wrapper around `useLayoutEffect` to get rid of the warning on SSR envs
 */
const useIsomorphicLayoutEffect = canUseDOM ? react.useLayoutEffect : react.useEffect;
//# sourceMappingURL=useIsomorphicLayout.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/thirdparty/react-popper/usePopper.js
/* eslint-disable @typescript-eslint/consistent-type-definitions */



const isEqual = (a, b) => JSON.stringify(a) === JSON.stringify(b);
/**
 * Simple ponyfill for Object.fromEntries
 */
const fromEntries = (entries) => entries.reduce((acc, [key, value]) => {
    acc[key] = value;
    return acc;
}, {});
const EMPTY_MODIFIERS = [];
const usePopper = (referenceElement, popperElement, options = {}) => {
    const prevOptions = react.useRef(null);
    const optionsWithDefaults = {
        onFirstUpdate: options.onFirstUpdate,
        placement: options.placement || 'bottom',
        strategy: options.strategy || 'absolute',
        modifiers: options.modifiers || EMPTY_MODIFIERS
    };
    const [state, setState] = react.useState({
        styles: {
            popper: {
                position: optionsWithDefaults.strategy,
                left: '0',
                top: '0'
            }
        },
        attributes: {}
    });
    const updateStateModifier = react.useMemo(() => ({
        name: 'updateState',
        enabled: true,
        phase: 'write',
        // eslint-disable-next-line no-shadow
        fn: ({ state }) => {
            const elements = Object.keys(state.elements);
            setState({
                styles: fromEntries(elements.map(element => [element, state.styles[element] || {}])),
                attributes: fromEntries(elements.map(element => [element, state.attributes[element]]))
            });
        },
        requires: ['computeStyles']
    }), []);
    const popperOptions = react.useMemo(() => {
        const newOptions = {
            onFirstUpdate: optionsWithDefaults.onFirstUpdate,
            placement: optionsWithDefaults.placement,
            strategy: optionsWithDefaults.strategy,
            modifiers: [...optionsWithDefaults.modifiers, updateStateModifier, { name: 'applyStyles', enabled: false }]
        };
        if (isEqual(prevOptions.current, newOptions)) {
            return prevOptions.current || newOptions;
        }
        else {
            prevOptions.current = newOptions;
            return newOptions;
        }
    }, [
        optionsWithDefaults.onFirstUpdate,
        optionsWithDefaults.placement,
        optionsWithDefaults.strategy,
        optionsWithDefaults.modifiers,
        updateStateModifier
    ]);
    const popperInstanceRef = react.useRef();
    useIsomorphicLayoutEffect(() => {
        if (popperInstanceRef && popperInstanceRef.current) {
            popperInstanceRef.current.setOptions(popperOptions);
        }
    }, [popperOptions]);
    useIsomorphicLayoutEffect(() => {
        if (referenceElement == null || popperElement == null) {
            return;
        }
        const createPopper = options.createPopper || popper_createPopper;
        const popperInstance = createPopper(referenceElement, popperElement, popperOptions);
        popperInstanceRef.current = popperInstance;
        return () => {
            popperInstance.destroy();
            popperInstanceRef.current = null;
        };
    }, [referenceElement, popperElement, options.createPopper]);
    return {
        state: popperInstanceRef.current ? popperInstanceRef.current.state : null,
        styles: state.styles,
        attributes: state.attributes,
        update: popperInstanceRef.current ? popperInstanceRef.current.update : null,
        forceUpdate: popperInstanceRef.current ? popperInstanceRef.current.forceUpdate : null
    };
};
//# sourceMappingURL=usePopper.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/FindRefWrapper.js


/**
 * This component wraps any ReactNode and finds its ref
 * It has to be a class for findDOMNode to work
 * Ideally, all components used as triggers/toggles are either:
 * - class based components we can assign our own ref to
 * - functional components that have forwardRef implemented
 * However, there is no guarantee that is what will get passed in as trigger/toggle in the case of tooltips and popovers
 */
class FindRefWrapper extends react.Component {
    componentDidMount() {
        // eslint-disable-next-line react/no-find-dom-node
        const root = react_dom.findDOMNode(this);
        this.props.onFoundRef(root);
    }
    render() {
        return this.props.children || null;
    }
}
FindRefWrapper.displayName = 'FindRefWrapper';
//# sourceMappingURL=FindRefWrapper.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Popper/Popper.css
var Popper = __webpack_require__(25749);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/Popper/Popper.js






const Popper_hash = {
    left: 'right',
    right: 'left',
    bottom: 'top',
    top: 'bottom',
    'top-start': 'bottom-end',
    'top-end': 'bottom-start',
    'bottom-start': 'top-end',
    'bottom-end': 'top-start',
    'left-start': 'right-end',
    'left-end': 'right-start',
    'right-start': 'left-end',
    'right-end': 'left-start'
};
const Popper_getOppositePlacement = (placement) => placement.replace(/left|right|bottom|top|top-start|top-end|bottom-start|bottom-end|right-start|right-end|left-start|left-end/g, (matched) => Popper_hash[matched]);
const getOpacityTransition = (animationDuration) => `opacity ${animationDuration}ms cubic-bezier(.54, 1.5, .38, 1.11)`;
const Popper_Popper = ({ trigger, popper, popperMatchesTriggerWidth = true, direction = 'down', position = 'left', placement, appendTo = () => document.body, zIndex = 9999, isVisible = true, positionModifiers, distance = 0, onMouseEnter, onMouseLeave, onFocus, onBlur, onDocumentClick, onTriggerClick, onTriggerEnter, onPopperClick, onPopperMouseEnter, onPopperMouseLeave, onDocumentKeyDown, enableFlip = true, flipBehavior = 'flip', reference, removeFindDomNode = false, popperRef }) => {
    const [triggerElement, setTriggerElement] = react.useState(null);
    const [refElement, setRefElement] = react.useState(null);
    const [popperElement, setPopperElement] = react.useState(null);
    const [ready, setReady] = react.useState(false);
    const refOrTrigger = refElement || triggerElement;
    const onDocumentClickCallback = react.useCallback((event) => onDocumentClick(event, refOrTrigger, popperElement), [isVisible, triggerElement, refElement, popperElement, onDocumentClick]);
    react.useEffect(() => {
        setReady(true);
    }, []);
    react.useEffect(() => {
        if (reference) {
            if (reference.current) {
                setRefElement(reference.current);
            }
            else if (typeof reference === 'function') {
                setRefElement(reference());
            }
        }
    }, [reference]);
    react.useEffect(() => {
        // When the popperRef is defined or the popper visiblity changes, ensure the popper element is up to date
        if (popperRef) {
            if (popperRef.current) {
                setPopperElement(popperRef.current);
            }
            else if (typeof popperRef === 'function') {
                setPopperElement(popperRef());
            }
        }
    }, [isVisible, popperRef]);
    const addEventListener = (listener, element, event, capture = false) => {
        if (listener && element) {
            element.addEventListener(event, listener, { capture });
        }
    };
    const removeEventListener = (listener, element, event, capture = false) => {
        if (listener && element) {
            element.removeEventListener(event, listener, { capture });
        }
    };
    react.useEffect(() => {
        addEventListener(onMouseEnter, refOrTrigger, 'mouseenter');
        addEventListener(onMouseLeave, refOrTrigger, 'mouseleave');
        addEventListener(onFocus, refOrTrigger, 'focus');
        addEventListener(onBlur, refOrTrigger, 'blur');
        addEventListener(onTriggerClick, refOrTrigger, 'click');
        addEventListener(onTriggerEnter, refOrTrigger, 'keydown');
        addEventListener(onPopperClick, popperElement, 'click');
        addEventListener(onPopperMouseEnter, popperElement, 'mouseenter');
        addEventListener(onPopperMouseLeave, popperElement, 'mouseleave');
        onDocumentClick && addEventListener(onDocumentClickCallback, document, 'click', true);
        addEventListener(onDocumentKeyDown, document, 'keydown', true);
        // Trigger a Popper update when content changes.
        const observer = new MutationObserver(() => {
            update && update();
        });
        popperElement && observer.observe(popperElement, { attributes: true, childList: true, subtree: true });
        return () => {
            removeEventListener(onMouseEnter, refOrTrigger, 'mouseenter');
            removeEventListener(onMouseLeave, refOrTrigger, 'mouseleave');
            removeEventListener(onFocus, refOrTrigger, 'focus');
            removeEventListener(onBlur, refOrTrigger, 'blur');
            removeEventListener(onTriggerClick, refOrTrigger, 'click');
            removeEventListener(onTriggerEnter, refOrTrigger, 'keydown');
            removeEventListener(onPopperClick, popperElement, 'click');
            removeEventListener(onPopperMouseEnter, popperElement, 'mouseenter');
            removeEventListener(onPopperMouseLeave, popperElement, 'mouseleave');
            onDocumentClick && removeEventListener(onDocumentClickCallback, document, 'click', true);
            removeEventListener(onDocumentKeyDown, document, 'keydown', true);
            observer.disconnect();
        };
    }, [
        triggerElement,
        popperElement,
        onMouseEnter,
        onMouseLeave,
        onFocus,
        onBlur,
        onTriggerClick,
        onTriggerEnter,
        onPopperClick,
        onPopperMouseEnter,
        onPopperMouseLeave,
        onDocumentClick,
        onDocumentKeyDown,
        refElement
    ]);
    const getPlacement = () => {
        if (placement) {
            return placement;
        }
        let convertedPlacement = direction === 'up' ? 'top' : 'bottom';
        if (position !== 'center') {
            convertedPlacement = `${convertedPlacement}-${position === 'right' ? 'end' : 'start'}`;
        }
        return convertedPlacement;
    };
    const getPlacementMemo = react.useMemo(getPlacement, [direction, position, placement]);
    const getOppositePlacementMemo = react.useMemo(() => Popper_getOppositePlacement(getPlacement()), [
        direction,
        position,
        placement
    ]);
    const sameWidthMod = react.useMemo(() => ({
        name: 'sameWidth',
        enabled: popperMatchesTriggerWidth,
        phase: 'beforeWrite',
        requires: ['computeStyles'],
        fn: ({ state }) => {
            state.styles.popper.width = `${state.rects.reference.width}px`;
        },
        effect: ({ state }) => {
            state.elements.popper.style.width = `${state.elements.reference.offsetWidth}px`;
            return () => { };
        }
    }), [popperMatchesTriggerWidth]);
    const { styles: popperStyles, attributes, update, forceUpdate } = usePopper(refOrTrigger, popperElement, {
        placement: getPlacementMemo,
        modifiers: [
            {
                name: 'offset',
                options: {
                    offset: [0, distance]
                }
            },
            {
                name: 'preventOverflow',
                enabled: false
            },
            {
                // adds attribute [data-popper-reference-hidden] to the popper element which can be used to hide it using CSS
                name: 'hide',
                enabled: true
            },
            {
                name: 'flip',
                enabled: getPlacementMemo.startsWith('auto') || enableFlip,
                options: {
                    fallbackPlacements: flipBehavior === 'flip' ? [getOppositePlacementMemo] : flipBehavior
                }
            },
            sameWidthMod
        ]
    });
    react.useEffect(() => {
        forceUpdate && forceUpdate();
    }, [popper]);
    // Returns the CSS modifier class in order to place the Popper's arrow properly
    // Depends on the position of the Popper relative to the reference element
    const modifierFromPopperPosition = () => {
        if (attributes && attributes.popper && attributes.popper['data-popper-placement']) {
            const popperPlacement = attributes.popper['data-popper-placement'];
            return positionModifiers[popperPlacement];
        }
        return positionModifiers.top;
    };
    const options = Object.assign({ className: (0,esm.css)(popper.props && popper.props.className, positionModifiers && modifierFromPopperPosition()), style: Object.assign(Object.assign(Object.assign({}, ((popper.props && popper.props.style) || {})), popperStyles.popper), { zIndex }) }, attributes.popper);
    const menuWithPopper = react.cloneElement(popper, options);
    const getTarget = () => {
        if (typeof appendTo === 'function') {
            return appendTo();
        }
        return appendTo;
    };
    /**
     * To enable strict mode, the popper must either have its reference defined via the popperRef property,
     * or the removeFindDomNode flag must be present. Even if the reference is passed in, unlike the trigger,
     * the popper property must still be passed.
     * The trigger must similarly have either its reference defined via the reference property, or the
     * removeFindDomNode flag must be present. The trigger property is not required when the reference is passed.
     *
     * Strict mode may be enabled by passing both reference properties to Popper, or by passing the
     * removeFindDomNode flag with either reference property, or by solely passing the removeFindDomNode
     * flag.
     */
    let popperPortal;
    if (removeFindDomNode) {
        // If removeFindDomNode is passed, use the removeFindDomNode method of wrapping divs
        popperPortal = (react.createElement("div", { style: { display: 'contents' }, ref: node => setPopperElement(node === null || node === void 0 ? void 0 : node.firstElementChild) }, menuWithPopper));
    }
    else if (popperRef) {
        // If removeFindDomNode is not passed and popperRef is passed, use the popperRef method
        popperPortal = menuWithPopper;
    }
    else {
        // If neither removeFindDomNode and popperRef exist, use the old method of FindRefWrapper
        popperPortal = (react.createElement(FindRefWrapper, { onFoundRef: (foundRef) => setPopperElement(foundRef) }, menuWithPopper));
    }
    return (react.createElement(react.Fragment, null,
        !reference && trigger && react.isValidElement(trigger) && !removeFindDomNode && (react.createElement(FindRefWrapper, { onFoundRef: (foundRef) => setTriggerElement(foundRef) }, trigger)),
        !reference && trigger && react.isValidElement(trigger) && removeFindDomNode && (react.createElement("div", { style: { display: 'contents' }, ref: node => setTriggerElement(node === null || node === void 0 ? void 0 : node.firstElementChild) }, trigger)),
        ready && isVisible && react_dom.createPortal(popperPortal, getTarget())));
};
Popper_Popper.displayName = 'Popper';
//# sourceMappingURL=Popper.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js

/* eslint-disable no-console */








var TooltipPosition;
(function (TooltipPosition) {
    TooltipPosition["auto"] = "auto";
    TooltipPosition["top"] = "top";
    TooltipPosition["bottom"] = "bottom";
    TooltipPosition["left"] = "left";
    TooltipPosition["right"] = "right";
    TooltipPosition["topStart"] = "top-start";
    TooltipPosition["topEnd"] = "top-end";
    TooltipPosition["bottomStart"] = "bottom-start";
    TooltipPosition["bottomEnd"] = "bottom-end";
    TooltipPosition["leftStart"] = "left-start";
    TooltipPosition["leftEnd"] = "left-end";
    TooltipPosition["rightStart"] = "right-start";
    TooltipPosition["rightEnd"] = "right-end";
})(TooltipPosition || (TooltipPosition = {}));
// id for associating trigger with the content aria-describedby or aria-labelledby
let pfTooltipIdCounter = 1;
const Tooltip = (_a) => {
    var { content: bodyContent, position = 'top', trigger = 'mouseenter focus', isVisible = false, isContentLeftAligned = false, enableFlip = true, className = '', entryDelay = 300, exitDelay = 300, appendTo = () => document.body, zIndex = 9999, maxWidth = esm_c_tooltip_MaxWidth.value, distance = 15, aria = 'describedby', 
    // For every initial starting position, there are 3 escape positions
    flipBehavior = ['top', 'right', 'bottom', 'left', 'top', 'right', 'bottom'], id = `pf-tooltip-${pfTooltipIdCounter++}`, children, animationDuration = 300, reference, 'aria-live': ariaLive = reference ? 'polite' : 'off', boundary, isAppLauncher, tippyProps, removeFindDomNode = false, onTooltipHidden = () => { } } = _a, rest = (0,tslib_es6.__rest)(_a, ["content", "position", "trigger", "isVisible", "isContentLeftAligned", "enableFlip", "className", "entryDelay", "exitDelay", "appendTo", "zIndex", "maxWidth", "distance", "aria", "flipBehavior", "id", "children", "animationDuration", "reference", 'aria-live', "boundary", "isAppLauncher", "tippyProps", "removeFindDomNode", "onTooltipHidden"]);
    if (false) {}
    // could make this a prop in the future (true | false | 'toggle')
    const hideOnClick = true;
    const triggerOnMouseenter = trigger.includes('mouseenter');
    const triggerOnFocus = trigger.includes('focus');
    const triggerOnClick = trigger.includes('click');
    const triggerManually = trigger === 'manual';
    const [visible, setVisible] = react.useState(false);
    const [opacity, setOpacity] = react.useState(0);
    const transitionTimerRef = react.useRef(null);
    const showTimerRef = react.useRef(null);
    const hideTimerRef = react.useRef(null);
    const prevExitDelayRef = react.useRef();
    const clearTimeouts = (timeoutRefs) => {
        timeoutRefs.forEach(ref => {
            if (ref.current) {
                clearTimeout(ref.current);
            }
        });
    };
    // Cancel all timers on unmount
    react.useEffect(() => () => {
        clearTimeouts([transitionTimerRef, hideTimerRef, showTimerRef]);
    }, []);
    const onDocumentKeyDown = (event) => {
        if (!triggerManually) {
            if (event.key === KeyTypes.Escape && visible) {
                hide();
            }
        }
    };
    const onTriggerEnter = (event) => {
        if (event.key === KeyTypes.Enter) {
            if (!visible) {
                show();
            }
            else {
                hide();
            }
        }
    };
    react.useEffect(() => {
        if (isVisible) {
            show();
        }
        else {
            hide();
        }
    }, [isVisible]);
    react.useEffect(() => {
        if (prevExitDelayRef.current < exitDelay) {
            clearTimeouts([transitionTimerRef, hideTimerRef]);
            hideTimerRef.current = setTimeout(() => {
                setOpacity(0);
                transitionTimerRef.current = setTimeout(() => {
                    setVisible(false);
                    onTooltipHidden();
                }, animationDuration);
            }, exitDelay);
        }
        prevExitDelayRef.current = exitDelay;
    }, [exitDelay]);
    const show = () => {
        clearTimeouts([transitionTimerRef, hideTimerRef]);
        showTimerRef.current = setTimeout(() => {
            setVisible(true);
            setOpacity(1);
        }, entryDelay);
    };
    const hide = () => {
        clearTimeouts([showTimerRef]);
        hideTimerRef.current = setTimeout(() => {
            setOpacity(0);
            transitionTimerRef.current = setTimeout(() => {
                setVisible(false);
                onTooltipHidden();
            }, animationDuration);
        }, exitDelay);
    };
    const positionModifiers = {
        top: tooltip["default"].modifiers.top,
        bottom: tooltip["default"].modifiers.bottom,
        left: tooltip["default"].modifiers.left,
        right: tooltip["default"].modifiers.right,
        'top-start': tooltip["default"].modifiers.topLeft,
        'top-end': tooltip["default"].modifiers.topRight,
        'bottom-start': tooltip["default"].modifiers.bottomLeft,
        'bottom-end': tooltip["default"].modifiers.bottomRight,
        'left-start': tooltip["default"].modifiers.leftTop,
        'left-end': tooltip["default"].modifiers.leftBottom,
        'right-start': tooltip["default"].modifiers.rightTop,
        'right-end': tooltip["default"].modifiers.rightBottom
    };
    const hasCustomMaxWidth = maxWidth !== esm_c_tooltip_MaxWidth.value;
    const content = (react.createElement("div", Object.assign({ "aria-live": ariaLive, className: (0,esm.css)(tooltip["default"].tooltip, className), role: "tooltip", id: id, style: {
            maxWidth: hasCustomMaxWidth ? maxWidth : null,
            opacity,
            transition: getOpacityTransition(animationDuration)
        } }, rest),
        react.createElement(TooltipArrow, null),
        react.createElement(TooltipContent, { isLeftAligned: isContentLeftAligned }, bodyContent)));
    const onDocumentClick = (event, triggerElement) => {
        // event.currentTarget = document
        // event.target could be triggerElement or something else
        if (hideOnClick === true) {
            // hide on inside the toggle as well as on outside clicks
            if (visible) {
                hide();
            }
            else if (event.target === triggerElement) {
                show();
            }
        }
        else if (hideOnClick === 'toggle' && event.target === triggerElement) {
            // prevent outside clicks from hiding but allow it to still be toggled on toggle click
            if (visible) {
                hide();
            }
            else {
                show();
            }
        }
        else if (hideOnClick === false && !visible && event.target === triggerElement) {
            show();
        }
    };
    const addAriaToTrigger = () => {
        if (aria === 'describedby' && children && children.props && !children.props['aria-describedby']) {
            return react.cloneElement(children, { 'aria-describedby': id });
        }
        else if (aria === 'labelledby' && children.props && !children.props['aria-labelledby']) {
            return react.cloneElement(children, { 'aria-labelledby': id });
        }
        return children;
    };
    return (react.createElement(Popper_Popper, { trigger: aria !== 'none' && visible ? addAriaToTrigger() : children, reference: reference, popper: content, popperMatchesTriggerWidth: false, appendTo: appendTo, isVisible: visible, positionModifiers: positionModifiers, distance: distance, placement: position, onMouseEnter: triggerOnMouseenter && show, onMouseLeave: triggerOnMouseenter && hide, onPopperMouseEnter: triggerOnMouseenter && show, onPopperMouseLeave: triggerOnMouseenter && hide, onFocus: triggerOnFocus && show, onBlur: triggerOnFocus && hide, onDocumentClick: triggerOnClick && onDocumentClick, onDocumentKeyDown: triggerManually ? null : onDocumentKeyDown, onTriggerEnter: triggerManually ? null : onTriggerEnter, enableFlip: enableFlip, zIndex: zIndex, flipBehavior: flipBehavior, removeFindDomNode: removeFindDomNode }));
};
Tooltip.displayName = 'Tooltip';
//# sourceMappingURL=Tooltip.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertToggleExpandButton.js







const AlertToggleExpandButton = (_a) => {
    var { 'aria-label': ariaLabel = '', variantLabel, onToggleExpand, isExpanded = false } = _a, props = (0,tslib_es6.__rest)(_a, ['aria-label', "variantLabel", "onToggleExpand", "isExpanded"]);
    const { title, variantLabel: alertVariantLabel } = react.useContext(AlertContext);
    return (react.createElement(Button, Object.assign({ variant: ButtonVariant.plain, onClick: onToggleExpand, "aria-expanded": isExpanded, "aria-label": ariaLabel === '' ? `Toggle ${variantLabel || alertVariantLabel} alert: ${title}` : ariaLabel }, props),
        react.createElement("span", { className: (0,esm.css)(Alert_alert/* default */.Z.alertToggleIcon) },
            react.createElement(angle_right_icon, { "aria-hidden": "true" }))));
};
AlertToggleExpandButton.displayName = 'AlertToggleExpandButton';
//# sourceMappingURL=AlertToggleExpandButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/Alert.js












var AlertVariant;
(function (AlertVariant) {
    AlertVariant["success"] = "success";
    AlertVariant["danger"] = "danger";
    AlertVariant["warning"] = "warning";
    AlertVariant["info"] = "info";
    AlertVariant["default"] = "default";
})(AlertVariant || (AlertVariant = {}));
const Alert = (_a) => {
    var { variant = AlertVariant.default, isInline = false, isPlain = false, isLiveRegion = false, variantLabel = `${capitalize(variant)} alert:`, 'aria-label': ariaLabel = `${capitalize(variant)} Alert`, actionClose, actionLinks, title, titleHeadingLevel, component = 'h4', children = '', className = '', ouiaId, ouiaSafe = true, timeout = false, timeoutAnimation = 3000, onTimeout = () => { }, truncateTitle = 0, tooltipPosition, customIcon, isExpandable = false, toggleAriaLabel = `${capitalize(variant)} alert details`, onMouseEnter = () => { }, onMouseLeave = () => { }, id } = _a, props = (0,tslib_es6.__rest)(_a, ["variant", "isInline", "isPlain", "isLiveRegion", "variantLabel", 'aria-label', "actionClose", "actionLinks", "title", "titleHeadingLevel", "component", "children", "className", "ouiaId", "ouiaSafe", "timeout", "timeoutAnimation", "onTimeout", "truncateTitle", "tooltipPosition", "customIcon", "isExpandable", "toggleAriaLabel", "onMouseEnter", "onMouseLeave", "id"]);
    const ouiaProps = useOUIAProps(Alert.displayName, ouiaId, ouiaSafe, variant);
    const getHeadingContent = (react.createElement(react.Fragment, null,
        react.createElement("span", { className: (0,esm.css)(accessibility["default"].screenReader) }, variantLabel),
        title));
    const titleRef = react.useRef(null);
    const TitleComponent = (titleHeadingLevel || component);
    if (titleHeadingLevel !== undefined) {
        // eslint-disable-next-line no-console
        console.warn('Alert: titleHeadingLevel is deprecated, please use the newer component prop instead to set the alert title element.');
    }
    const divRef = react.useRef();
    const [isTooltipVisible, setIsTooltipVisible] = (0,react.useState)(false);
    react.useEffect(() => {
        if (!titleRef.current || !truncateTitle) {
            return;
        }
        titleRef.current.style.setProperty(c_alert_title_max_lines.name, truncateTitle.toString());
        const showTooltip = titleRef.current && titleRef.current.offsetHeight < titleRef.current.scrollHeight;
        if (isTooltipVisible !== showTooltip) {
            setIsTooltipVisible(showTooltip);
        }
    }, [titleRef, truncateTitle, isTooltipVisible]);
    const [timedOut, setTimedOut] = (0,react.useState)(false);
    const [timedOutAnimation, setTimedOutAnimation] = (0,react.useState)(true);
    const [isMouseOver, setIsMouseOver] = (0,react.useState)();
    const [containsFocus, setContainsFocus] = (0,react.useState)();
    const dismissed = timedOut && timedOutAnimation && !isMouseOver && !containsFocus;
    react.useEffect(() => {
        const calculatedTimeout = timeout === true ? 8000 : Number(timeout);
        if (calculatedTimeout > 0) {
            const timer = setTimeout(() => setTimedOut(true), calculatedTimeout);
            return () => clearTimeout(timer);
        }
    }, [timeout]);
    react.useEffect(() => {
        const onDocumentFocus = () => {
            if (divRef.current) {
                if (divRef.current.contains(document.activeElement)) {
                    setContainsFocus(true);
                    setTimedOutAnimation(false);
                }
                else if (containsFocus) {
                    setContainsFocus(false);
                }
            }
        };
        document.addEventListener('focus', onDocumentFocus, true);
        return () => document.removeEventListener('focus', onDocumentFocus, true);
    }, [containsFocus]);
    react.useEffect(() => {
        if (containsFocus === false || isMouseOver === false) {
            const timer = setTimeout(() => setTimedOutAnimation(true), timeoutAnimation);
            return () => clearTimeout(timer);
        }
    }, [containsFocus, isMouseOver, timeoutAnimation]);
    react.useEffect(() => {
        dismissed && onTimeout();
    }, [dismissed, onTimeout]);
    const [isExpanded, setIsExpanded] = (0,react.useState)(false);
    const onToggleExpand = () => {
        setIsExpanded(!isExpanded);
    };
    const myOnMouseEnter = (ev) => {
        setIsMouseOver(true);
        setTimedOutAnimation(false);
        onMouseEnter(ev);
    };
    const myOnMouseLeave = (ev) => {
        setIsMouseOver(false);
        onMouseLeave(ev);
    };
    if (dismissed) {
        return null;
    }
    const Title = (react.createElement(TitleComponent, Object.assign({}, (isTooltipVisible && { tabIndex: 0 }), { ref: titleRef, className: (0,esm.css)(Alert_alert/* default */.Z.alertTitle, truncateTitle && Alert_alert/* default */.Z.modifiers.truncate) }), getHeadingContent));
    return (react.createElement("div", Object.assign({ ref: divRef, className: (0,esm.css)(Alert_alert/* default */.Z.alert, isInline && Alert_alert/* default */.Z.modifiers.inline, isPlain && Alert_alert/* default */.Z.modifiers.plain, isExpandable && Alert_alert/* default */.Z.modifiers.expandable, isExpanded && Alert_alert/* default */.Z.modifiers.expanded, Alert_alert/* default */.Z.modifiers[variant], className), "aria-label": ariaLabel }, ouiaProps, (isLiveRegion && {
        'aria-live': 'polite',
        'aria-atomic': 'false'
    }), { onMouseEnter: myOnMouseEnter, onMouseLeave: myOnMouseLeave, id: id }, props),
        isExpandable && (react.createElement(AlertContext.Provider, { value: { title, variantLabel } },
            react.createElement("div", { className: (0,esm.css)(Alert_alert/* default */.Z.alertToggle) },
                react.createElement(AlertToggleExpandButton, { isExpanded: isExpanded, onToggleExpand: onToggleExpand, "aria-label": toggleAriaLabel })))),
        react.createElement(AlertIcon, { variant: variant, customIcon: customIcon }),
        isTooltipVisible ? (react.createElement(Tooltip, { content: getHeadingContent, position: tooltipPosition }, Title)) : (Title),
        actionClose && (react.createElement(AlertContext.Provider, { value: { title, variantLabel } },
            react.createElement("div", { className: (0,esm.css)(Alert_alert/* default */.Z.alertAction) }, actionClose))),
        children && (!isExpandable || (isExpandable && isExpanded)) && (react.createElement("div", { className: (0,esm.css)(Alert_alert/* default */.Z.alertDescription) }, children)),
        actionLinks && react.createElement("div", { className: (0,esm.css)(Alert_alert/* default */.Z.alertActionGroup) }, actionLinks)));
};
Alert.displayName = 'Alert';
//# sourceMappingURL=Alert.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertActionCloseButton.js





const AlertActionCloseButton = (_a) => {
    var { className, onClose = () => undefined, 'aria-label': ariaLabel = '', variantLabel } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "onClose", 'aria-label', "variantLabel"]);
    return (react.createElement(AlertContext.Consumer, null, ({ title, variantLabel: alertVariantLabel }) => (react.createElement(Button, Object.assign({ variant: ButtonVariant.plain, onClick: onClose, "aria-label": ariaLabel === '' ? `Close ${variantLabel || alertVariantLabel} alert: ${title}` : ariaLabel, className: className }, props),
        react.createElement(times_icon, null)))));
};
AlertActionCloseButton.displayName = 'AlertActionCloseButton';
//# sourceMappingURL=AlertActionCloseButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/AlertActionLink.js



const AlertActionLink = (_a) => {
    var { className = '', children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement(Button, Object.assign({ variant: ButtonVariant.link, isInline: true, className: className }, props), children));
};
AlertActionLink.displayName = 'AlertActionLink';
//# sourceMappingURL=AlertActionLink.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Alert/index.js




//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/AlertGroup/alert-group.js
var alert_group = __webpack_require__(93538);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroupInline.js




const AlertGroupInline = (_a) => {
    var { className, children, isToast, isLiveRegion, onOverflowClick, overflowMessage } = _a, rest = (0,tslib_es6.__rest)(_a, ["className", "children", "isToast", "isLiveRegion", "onOverflowClick", "overflowMessage"]);
    return (react.createElement("ul", Object.assign({ "aria-live": isLiveRegion ? 'polite' : null, "aria-atomic": isLiveRegion ? false : null, className: (0,esm.css)(alert_group/* default */.Z.alertGroup, className, isToast ? alert_group/* default */.Z.modifiers.toast : '') }, rest),
        react.Children.toArray(children).map((alert, index) => {
            var _a;
            return (react.createElement("li", { key: ((_a = alert.props) === null || _a === void 0 ? void 0 : _a.id) || index }, alert));
        }),
        overflowMessage && (react.createElement("li", null,
            react.createElement("button", { onClick: onOverflowClick, className: (0,esm.css)(alert_group/* default */.Z.alertGroupOverflowButton) }, overflowMessage)))));
};
AlertGroupInline.displayName = 'AlertGroupInline';
//# sourceMappingURL=AlertGroupInline.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/AlertGroup.js





class AlertGroup extends react.Component {
    constructor() {
        super(...arguments);
        this.state = {
            container: undefined
        };
    }
    componentDidMount() {
        const container = document.createElement('div');
        const target = this.getTargetElement();
        this.setState({ container });
        target.appendChild(container);
    }
    componentWillUnmount() {
        const target = this.getTargetElement();
        if (this.state.container) {
            target.removeChild(this.state.container);
        }
    }
    getTargetElement() {
        const appendTo = this.props.appendTo;
        if (typeof appendTo === 'function') {
            return appendTo();
        }
        return appendTo || document.body;
    }
    render() {
        const _a = this.props, { className, children, isToast, isLiveRegion, onOverflowClick, overflowMessage } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "isToast", "isLiveRegion", "onOverflowClick", "overflowMessage"]);
        const alertGroup = (react.createElement(AlertGroupInline, Object.assign({ onOverflowClick: onOverflowClick, className: className, isToast: isToast, isLiveRegion: isLiveRegion, overflowMessage: overflowMessage }, props), children));
        if (!this.props.isToast) {
            return alertGroup;
        }
        const container = this.state.container;
        if (!canUseDOM || !container) {
            return null;
        }
        return react_dom.createPortal(alertGroup, container);
    }
}
AlertGroup.displayName = 'AlertGroup';
//# sourceMappingURL=AlertGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/AlertGroup/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/AppLauncher/app-launcher.js
var app_launcher = __webpack_require__(69440);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/FormControl/form-control.js
var form_control = __webpack_require__(62124);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/th-icon.js


const ThIconConfig = {
  name: 'ThIcon',
  height: 512,
  width: 512,
  svgPath: 'M149.333 56v80c0 13.255-10.745 24-24 24H24c-13.255 0-24-10.745-24-24V56c0-13.255 10.745-24 24-24h101.333c13.255 0 24 10.745 24 24zm181.334 240v-80c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.256 0 24.001-10.745 24.001-24zm32-240v80c0 13.255 10.745 24 24 24H488c13.255 0 24-10.745 24-24V56c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24zm-32 80V56c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.256 0 24.001-10.745 24.001-24zm-205.334 56H24c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24zM0 376v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H24c-13.255 0-24 10.745-24 24zm386.667-56H488c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24zm0 160H488c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H386.667c-13.255 0-24 10.745-24 24v80c0 13.255 10.745 24 24 24zM181.333 376v80c0 13.255 10.745 24 24 24h101.333c13.255 0 24-10.745 24-24v-80c0-13.255-10.745-24-24-24H205.333c-13.255 0-24 10.745-24 24z',
  yOffset: 0,
  xOffset: 0,
};

const ThIcon = createIcon(ThIconConfig);

/* harmony default export */ const th_icon = (ThIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/dropdownConstants.js

var DropdownPosition;
(function (DropdownPosition) {
    DropdownPosition["right"] = "right";
    DropdownPosition["left"] = "left";
})(DropdownPosition || (DropdownPosition = {}));
var DropdownDirection;
(function (DropdownDirection) {
    DropdownDirection["up"] = "up";
    DropdownDirection["down"] = "down";
})(DropdownDirection || (DropdownDirection = {}));
const DropdownContext = react.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onSelect: (event) => undefined,
    id: '',
    toggleIndicatorClass: '',
    toggleIconClass: '',
    toggleTextClass: '',
    menuClass: '',
    itemClass: '',
    toggleClass: '',
    baseClass: '',
    baseComponent: 'div',
    sectionClass: '',
    sectionTitleClass: '',
    sectionComponent: 'section',
    disabledClass: '',
    plainTextClass: '',
    menuComponent: 'ul'
});
const DropdownArrowContext = react.createContext({
    keyHandler: null,
    sendRef: null
});
//# sourceMappingURL=dropdownConstants.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/caret-down-icon.js


const CaretDownIconConfig = {
  name: 'CaretDownIcon',
  height: 512,
  width: 320,
  svgPath: 'M31.3 192h257.3c17.8 0 26.7 21.5 14.1 34.1L174.1 354.8c-7.8 7.8-20.5 7.8-28.3 0L17.2 226.1C4.6 213.5 13.5 192 31.3 192z',
  yOffset: 0,
  xOffset: 0,
};

const CaretDownIcon = createIcon(CaretDownIconConfig);

/* harmony default export */ const caret_down_icon = (CaretDownIcon);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Dropdown/dropdown.js
var dropdown = __webpack_require__(72062);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/Toggle.js






const buttonVariantStyles = {
    default: '',
    primary: dropdown["default"].modifiers.primary,
    secondary: dropdown["default"].modifiers.secondary
};
class Toggle extends react.Component {
    constructor() {
        super(...arguments);
        this.buttonRef = react.createRef();
        this.componentDidMount = () => {
            document.addEventListener('click', this.onDocClick);
            document.addEventListener('touchstart', this.onDocClick);
            document.addEventListener('keydown', this.onEscPress);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('click', this.onDocClick);
            document.removeEventListener('touchstart', this.onDocClick);
            document.removeEventListener('keydown', this.onEscPress);
        };
        this.onDocClick = (event) => {
            const { isOpen, parentRef, onToggle, getMenuRef } = this.props;
            const menuRef = getMenuRef && getMenuRef();
            const clickedOnToggle = parentRef && parentRef.current && parentRef.current.contains(event.target);
            const clickedWithinMenu = menuRef && menuRef.contains && menuRef.contains(event.target);
            if (isOpen && !(clickedOnToggle || clickedWithinMenu)) {
                onToggle === null || onToggle === void 0 ? void 0 : onToggle(false, event);
            }
        };
        this.onEscPress = (event) => {
            var _a, _b, _c;
            const { parentRef, getMenuRef } = this.props;
            const menuRef = getMenuRef && getMenuRef();
            const escFromToggle = parentRef && parentRef.current && parentRef.current.contains(event.target);
            const escFromWithinMenu = menuRef && menuRef.contains && menuRef.contains(event.target);
            if (this.props.isOpen &&
                (event.key === KeyTypes.Escape || event.key === 'Tab') &&
                (escFromToggle || escFromWithinMenu)) {
                (_b = (_a = this.props).onToggle) === null || _b === void 0 ? void 0 : _b.call(_a, false, event);
                (_c = this.buttonRef.current) === null || _c === void 0 ? void 0 : _c.focus();
            }
        };
        this.onKeyDown = (event) => {
            var _a, _b, _c, _d, _e, _f;
            if (event.key === 'Tab' && !this.props.isOpen) {
                return;
            }
            if ((event.key === 'Tab' || event.key === 'Enter' || event.key === ' ') && this.props.isOpen) {
                if (!this.props.bubbleEvent) {
                    event.stopPropagation();
                }
                event.preventDefault();
                (_b = (_a = this.props).onToggle) === null || _b === void 0 ? void 0 : _b.call(_a, !this.props.isOpen, event);
            }
            else if ((event.key === 'Enter' || event.key === ' ') && !this.props.isOpen) {
                if (!this.props.bubbleEvent) {
                    event.stopPropagation();
                }
                event.preventDefault();
                (_d = (_c = this.props).onToggle) === null || _d === void 0 ? void 0 : _d.call(_c, !this.props.isOpen, event);
                (_f = (_e = this.props).onEnter) === null || _f === void 0 ? void 0 : _f.call(_e);
            }
        };
    }
    render() {
        const _a = this.props, { className, children, isOpen, isDisabled, isPlain, isText, isPrimary, isSplitButton, toggleVariant, onToggle, 'aria-haspopup': ariaHasPopup, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        isActive, bubbleEvent, onEnter, parentRef, getMenuRef, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        id, type } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "isOpen", "isDisabled", "isPlain", "isText", "isPrimary", "isSplitButton", "toggleVariant", "onToggle", 'aria-haspopup', "isActive", "bubbleEvent", "onEnter", "parentRef", "getMenuRef", "id", "type"]);
        return (react.createElement(DropdownContext.Consumer, null, ({ toggleClass }) => (react.createElement("button", Object.assign({}, props, { id: id, ref: this.buttonRef, className: (0,esm.css)(isSplitButton ? dropdown["default"].dropdownToggleButton : toggleClass || dropdown["default"].dropdownToggle, isActive && dropdown["default"].modifiers.active, isPlain && dropdown["default"].modifiers.plain, isText && dropdown["default"].modifiers.text, isPrimary && dropdown["default"].modifiers.primary, toggleVariant && buttonVariantStyles[toggleVariant], className), type: type || 'button', onClick: event => onToggle === null || onToggle === void 0 ? void 0 : onToggle(!isOpen, event), "aria-expanded": isOpen, "aria-haspopup": ariaHasPopup, onKeyDown: event => this.onKeyDown(event), disabled: isDisabled }), children))));
    }
}
Toggle.displayName = 'Toggle';
Toggle.defaultProps = {
    className: '',
    isOpen: false,
    isActive: false,
    isDisabled: false,
    isPlain: false,
    isText: false,
    isPrimary: false,
    isSplitButton: false,
    onToggle: () => { },
    onEnter: () => { },
    bubbleEvent: false
};
//# sourceMappingURL=Toggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggle.js








const DropdownToggle = (_a) => {
    var { id = '', children = null, className = '', isOpen = false, parentRef = null, getMenuRef = null, isDisabled = false, isPlain = false, isText = false, isPrimary = false, toggleVariant = 'default', 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    isActive = false, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToggle = (_isOpen) => undefined, icon = null, toggleIndicator: ToggleIndicator = caret_down_icon, splitButtonItems, splitButtonVariant = 'checkbox', 'aria-haspopup': ariaHasPopup, ouiaId, ouiaSafe, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref } = _a, // Types of Ref are different for React.FunctionComponent vs React.Component
    props = (0,tslib_es6.__rest)(_a, ["id", "children", "className", "isOpen", "parentRef", "getMenuRef", "isDisabled", "isPlain", "isText", "isPrimary", "toggleVariant", "isActive", "onToggle", "icon", "toggleIndicator", "splitButtonItems", "splitButtonVariant", 'aria-haspopup', "ouiaId", "ouiaSafe", "ref"]);
    const ouiaProps = useOUIAProps(DropdownToggle.displayName, ouiaId, ouiaSafe);
    const toggle = (react.createElement(DropdownContext.Consumer, null, ({ toggleTextClass, toggleIndicatorClass, toggleIconClass }) => (react.createElement(Toggle, Object.assign({}, props, { id: id, className: className, isOpen: isOpen, parentRef: parentRef, getMenuRef: getMenuRef, isActive: isActive, isDisabled: isDisabled, isPlain: isPlain, isText: isText, isPrimary: isPrimary, toggleVariant: toggleVariant, onToggle: onToggle, "aria-haspopup": ariaHasPopup }, ouiaProps, (splitButtonItems && { isSplitButton: true, 'aria-label': props['aria-label'] || 'Select' })),
        icon && react.createElement("span", { className: (0,esm.css)(toggleIconClass) }, icon),
        children && react.createElement("span", { className: ToggleIndicator && (0,esm.css)(toggleTextClass) }, children),
        ToggleIndicator && (react.createElement("span", { className: (0,esm.css)(!splitButtonItems && toggleIndicatorClass) },
            react.createElement(ToggleIndicator, null)))))));
    if (splitButtonItems) {
        return (react.createElement("div", { className: (0,esm.css)(dropdown["default"].dropdownToggle, dropdown["default"].modifiers.splitButton, splitButtonVariant === 'action' && dropdown["default"].modifiers.action, (toggleVariant === 'primary' || isPrimary) && splitButtonVariant === 'action' && dropdown["default"].modifiers.primary, toggleVariant === 'secondary' && splitButtonVariant === 'action' && dropdown["default"].modifiers.secondary, isDisabled && dropdown["default"].modifiers.disabled) },
            splitButtonItems,
            toggle));
    }
    return toggle;
};
DropdownToggle.displayName = 'DropdownToggle';
//# sourceMappingURL=DropdownToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownMenu.js







class DropdownMenu extends react.Component {
    constructor() {
        super(...arguments);
        this.refsCollection = [];
        this.componentWillUnmount = () => {
            document.removeEventListener('keydown', this.onKeyDown);
        };
        this.onKeyDown = (event) => {
            if (!this.props.isOpen ||
                !Array.from(document.activeElement.classList).find(className => DropdownMenu.validToggleClasses.concat(this.context.toggleClass).includes(className))) {
                return;
            }
            const refs = this.refsCollection;
            if (event.key === 'ArrowDown') {
                const firstFocusTargetCollection = refs.find(ref => ref && ref[0] && !ref[0].hasAttribute('disabled'));
                DropdownMenu.focusFirstRef(firstFocusTargetCollection);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowUp') {
                const collectionLength = refs.length;
                const lastFocusTargetCollection = refs.slice(collectionLength - 1, collectionLength);
                const lastFocusTarget = lastFocusTargetCollection && lastFocusTargetCollection[0];
                DropdownMenu.focusFirstRef(lastFocusTarget);
                event.stopPropagation();
            }
        };
        this.childKeyHandler = (index, innerIndex, position, custom = false) => {
            keyHandler(index, innerIndex, position, this.refsCollection, this.props.isGrouped ? this.refsCollection : react.Children.toArray(this.props.children), custom);
        };
        this.sendRef = (index, nodes, isDisabled, isSeparator) => {
            this.refsCollection[index] = [];
            nodes.map((node, innerIndex) => {
                if (!node) {
                    this.refsCollection[index][innerIndex] = null;
                }
                else if (!node.getAttribute) {
                    // eslint-disable-next-line react/no-find-dom-node
                    this.refsCollection[index][innerIndex] = react_dom.findDOMNode(node);
                }
                else if (isSeparator) {
                    this.refsCollection[index][innerIndex] = null;
                }
                else {
                    this.refsCollection[index][innerIndex] = node;
                }
            });
        };
    }
    componentDidMount() {
        document.addEventListener('keydown', this.onKeyDown);
        const { autoFocus } = this.props;
        if (autoFocus) {
            // Focus first non-disabled element
            const focusTargetCollection = this.refsCollection.find(ref => ref && ref[0] && !ref[0].hasAttribute('disabled'));
            const focusTarget = focusTargetCollection && focusTargetCollection[0];
            if (focusTarget && focusTarget.focus) {
                setTimeout(() => focusTarget.focus());
            }
        }
    }
    shouldComponentUpdate() {
        // reset refsCollection before updating to account for child removal between mounts
        this.refsCollection = [];
        return true;
    }
    extendChildren() {
        const { children, isGrouped } = this.props;
        if (isGrouped) {
            let index = 0;
            return react.Children.map(children, groupedChildren => {
                const group = groupedChildren;
                const props = {};
                if (group.props && group.props.children) {
                    if (Array.isArray(group.props.children)) {
                        props.children = react.Children.map(group.props.children, option => react.cloneElement(option, {
                            index: index++
                        }));
                    }
                    else {
                        props.children = react.cloneElement(group.props.children, {
                            index: index++
                        });
                    }
                }
                return react.cloneElement(group, props);
            });
        }
        return react.Children.map(children, (child, index) => react.cloneElement(child, {
            index
        }));
    }
    render() {
        const _a = this.props, { className, isOpen, position, children, component, isGrouped, setMenuComponentRef, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        openedOnEnter, alignments } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "isOpen", "position", "children", "component", "isGrouped", "setMenuComponentRef", "openedOnEnter", "alignments"]);
        return (react.createElement(DropdownArrowContext.Provider, { value: {
                keyHandler: this.childKeyHandler,
                sendRef: this.sendRef
            } }, component === 'div' ? (react.createElement(DropdownContext.Consumer, null, ({ onSelect, menuClass }) => (react.createElement("div", { className: (0,esm.css)(menuClass, position === DropdownPosition.right && dropdown["default"].modifiers.alignRight, formatBreakpointMods(alignments, dropdown["default"], 'align-'), className), hidden: !isOpen, onClick: event => onSelect && onSelect(event), ref: setMenuComponentRef }, children)))) : ((isGrouped && (react.createElement(DropdownContext.Consumer, null, ({ menuClass, menuComponent }) => {
            const MenuComponent = (menuComponent || 'div');
            return (react.createElement(MenuComponent, Object.assign({}, props, { className: (0,esm.css)(menuClass, position === DropdownPosition.right && dropdown["default"].modifiers.alignRight, formatBreakpointMods(alignments, dropdown["default"], 'align-'), className), hidden: !isOpen, role: "menu", ref: setMenuComponentRef }), this.extendChildren()));
        }))) || (react.createElement(DropdownContext.Consumer, null, ({ menuClass, menuComponent }) => {
            const MenuComponent = (menuComponent || component);
            return (react.createElement(MenuComponent, Object.assign({}, props, { className: (0,esm.css)(menuClass, position === DropdownPosition.right && dropdown["default"].modifiers.alignRight, formatBreakpointMods(alignments, dropdown["default"], 'align-'), className), hidden: !isOpen, role: "menu", ref: setMenuComponentRef }), this.extendChildren()));
        })))));
    }
}
DropdownMenu.displayName = 'DropdownMenu';
DropdownMenu.defaultProps = {
    className: '',
    isOpen: true,
    openedOnEnter: false,
    autoFocus: true,
    position: DropdownPosition.left,
    component: 'ul',
    isGrouped: false,
    setMenuComponentRef: null
};
DropdownMenu.validToggleClasses = [dropdown["default"].dropdownToggle, dropdown["default"].dropdownToggleButton];
DropdownMenu.focusFirstRef = (refCollection) => {
    if (refCollection && refCollection[0] && refCollection[0].focus) {
        setTimeout(() => refCollection[0].focus());
    }
};
DropdownMenu.contextType = DropdownContext;
//# sourceMappingURL=DropdownMenu.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownWithContext.js








class DropdownWithContext extends react.Component {
    constructor(props) {
        super(props);
        this.openedOnEnter = false;
        this.baseComponentRef = react.createRef();
        this.menuComponentRef = react.createRef();
        this.onEnter = () => {
            this.openedOnEnter = true;
        };
        this.setMenuComponentRef = (element) => {
            this.menuComponentRef = element;
        };
        this.getMenuComponentRef = () => this.menuComponentRef;
        if (props.dropdownItems && props.dropdownItems.length > 0 && props.children) {
            // eslint-disable-next-line no-console
            console.error('Children and dropdownItems props have been provided. Only the dropdownItems prop items will be rendered');
        }
    }
    componentDidUpdate() {
        if (!this.props.isOpen) {
            this.openedOnEnter = false;
        }
    }
    render() {
        const _a = this.props, { children, className, direction, dropdownItems, isOpen, isPlain, isText, isGrouped, isFullHeight, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        onSelect, position, toggle, autoFocus, menuAppendTo, isFlipEnabled, removeFindDomNode, zIndex } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "direction", "dropdownItems", "isOpen", "isPlain", "isText", "isGrouped", "isFullHeight", "onSelect", "position", "toggle", "autoFocus", "menuAppendTo", "isFlipEnabled", "removeFindDomNode", "zIndex"]);
        const id = toggle.props.id || `pf-dropdown-toggle-id-${DropdownWithContext.currentId++}`;
        let component;
        let renderedContent;
        let ariaHasPopup = false;
        if (dropdownItems && dropdownItems.length > 0) {
            component = 'ul';
            renderedContent = dropdownItems;
            ariaHasPopup = true;
        }
        else {
            component = 'div';
            renderedContent = react.Children.toArray(children);
        }
        const openedOnEnter = this.openedOnEnter;
        const isStatic = isFlipEnabled && menuAppendTo !== 'inline';
        return (react.createElement(DropdownContext.Consumer, null, ({ baseClass, baseComponent, id: contextId, ouiaId, ouiaComponentType, ouiaSafe, alignments }) => {
            const BaseComponent = baseComponent;
            const menuContainer = (react.createElement(DropdownMenu, { className: (0,esm.css)(isStatic && dropdown["default"].modifiers.static), setMenuComponentRef: this.setMenuComponentRef, component: component, isOpen: isOpen, position: position, "aria-labelledby": contextId ? `${contextId}-toggle` : id, isGrouped: isGrouped, autoFocus: openedOnEnter && autoFocus, alignments: alignments }, renderedContent));
            const popperContainer = (react.createElement("div", { className: (0,esm.css)(baseClass, direction === DropdownDirection.up && dropdown["default"].modifiers.top, position === DropdownPosition.right && dropdown["default"].modifiers.alignRight, isOpen && dropdown["default"].modifiers.expanded, className) }, isOpen && menuContainer));
            const mainContainer = (react.createElement(BaseComponent, Object.assign({}, props, { className: (0,esm.css)(baseClass, direction === DropdownDirection.up && dropdown["default"].modifiers.top, position === DropdownPosition.right && dropdown["default"].modifiers.alignRight, isOpen && dropdown["default"].modifiers.expanded, isFullHeight && dropdown["default"].modifiers.fullHeight, className), ref: this.baseComponentRef }, getOUIAProps(ouiaComponentType, ouiaId, ouiaSafe)),
                react.Children.map(toggle, oneToggle => react.cloneElement(oneToggle, {
                    parentRef: this.baseComponentRef,
                    getMenuRef: this.getMenuComponentRef,
                    isOpen,
                    id,
                    isPlain,
                    isText,
                    'aria-haspopup': ariaHasPopup,
                    onEnter: () => {
                        this.onEnter();
                        oneToggle.props.onEnter && oneToggle.props.onEnter();
                    }
                })),
                menuAppendTo === 'inline' && isOpen && menuContainer));
            const getParentElement = () => {
                if (this.baseComponentRef && this.baseComponentRef.current) {
                    return this.baseComponentRef.current.parentElement;
                }
                return null;
            };
            return menuAppendTo === 'inline' ? (mainContainer) : (react.createElement(Popper_Popper, { trigger: mainContainer, popper: popperContainer, direction: direction, position: position, appendTo: menuAppendTo === 'parent' ? getParentElement() : menuAppendTo, isVisible: isOpen, removeFindDomNode: removeFindDomNode, zIndex: zIndex, popperMatchesTriggerWidth: false }));
        }));
    }
}
DropdownWithContext.displayName = 'DropdownWithContext';
// seed for the aria-labelledby ID
DropdownWithContext.currentId = 0;
DropdownWithContext.defaultProps = {
    className: '',
    dropdownItems: [],
    isOpen: false,
    isPlain: false,
    isText: false,
    isGrouped: false,
    position: DropdownPosition.left,
    direction: DropdownDirection.down,
    onSelect: () => undefined,
    autoFocus: true,
    menuAppendTo: 'inline',
    isFlipEnabled: true
};
//# sourceMappingURL=DropdownWithContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownGroup.js




const DropdownGroup = (_a) => {
    var { children = null, className = '', label = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "label"]);
    return (react.createElement(DropdownContext.Consumer, null, ({ sectionClass, sectionTitleClass, sectionComponent }) => {
        const SectionComponent = sectionComponent;
        return (react.createElement(SectionComponent, Object.assign({ className: (0,esm.css)(sectionClass, className) }, props),
            label && (react.createElement("h1", { className: (0,esm.css)(sectionTitleClass), "aria-hidden": true }, label)),
            react.createElement("ul", { role: "none" }, children)));
    }));
};
DropdownGroup.displayName = 'DropdownGroup';
//# sourceMappingURL=DropdownGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherGroup.js



const ApplicationLauncherGroup = (_a) => {
    var { children } = _a, props = (0,tslib_es6.__rest)(_a, ["children"]);
    return react.createElement(DropdownGroup, Object.assign({}, props), children);
};
ApplicationLauncherGroup.displayName = 'ApplicationLauncherGroup';
//# sourceMappingURL=ApplicationLauncherGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/InternalDropdownItem.js








class InternalDropdownItem extends react.Component {
    constructor() {
        super(...arguments);
        this.ref = react.createRef();
        this.additionalRef = react.createRef();
        this.getInnerNode = (node) => (node && node.childNodes && node.childNodes.length ? node.childNodes[0] : node);
        this.onKeyDown = (event) => {
            var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
            // Detected key press on this item, notify the menu parent so that the appropriate item can be focused
            const innerIndex = event.target === this.ref.current ? 0 : 1;
            if (!this.props.customChild) {
                event.preventDefault();
            }
            if (event.key === 'ArrowUp') {
                (_b = (_a = this.props.context) === null || _a === void 0 ? void 0 : _a.keyHandler) === null || _b === void 0 ? void 0 : _b.call(_a, this.props.index, innerIndex, KEYHANDLER_DIRECTION.UP);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowDown') {
                (_d = (_c = this.props.context) === null || _c === void 0 ? void 0 : _c.keyHandler) === null || _d === void 0 ? void 0 : _d.call(_c, this.props.index, innerIndex, KEYHANDLER_DIRECTION.DOWN);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowRight') {
                (_f = (_e = this.props.context) === null || _e === void 0 ? void 0 : _e.keyHandler) === null || _f === void 0 ? void 0 : _f.call(_e, this.props.index, innerIndex, KEYHANDLER_DIRECTION.RIGHT);
                event.stopPropagation();
            }
            else if (event.key === 'ArrowLeft') {
                (_h = (_g = this.props.context) === null || _g === void 0 ? void 0 : _g.keyHandler) === null || _h === void 0 ? void 0 : _h.call(_g, this.props.index, innerIndex, KEYHANDLER_DIRECTION.LEFT);
                event.stopPropagation();
            }
            else if (event.key === 'Enter' || event.key === ' ') {
                event.target.click();
                this.props.enterTriggersArrowDown &&
                    ((_k = (_j = this.props.context) === null || _j === void 0 ? void 0 : _j.keyHandler) === null || _k === void 0 ? void 0 : _k.call(_j, this.props.index, innerIndex, KEYHANDLER_DIRECTION.DOWN));
            }
        };
        this.componentRef = (element) => {
            this.ref.current = element;
            const { component } = this.props;
            const ref = component.ref;
            if (ref) {
                if (typeof ref === 'function') {
                    ref(element);
                }
                else {
                    ref.current = element;
                }
            }
        };
    }
    componentDidMount() {
        var _a;
        const { context, index, isDisabled, role, customChild, autoFocus } = this.props;
        const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
        (_a = context === null || context === void 0 ? void 0 : context.sendRef) === null || _a === void 0 ? void 0 : _a.call(context, index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
        autoFocus && setTimeout(() => customRef.focus());
    }
    componentDidUpdate() {
        var _a;
        const { context, index, isDisabled, role, customChild } = this.props;
        const customRef = customChild ? this.getInnerNode(this.ref.current) : this.ref.current;
        (_a = context === null || context === void 0 ? void 0 : context.sendRef) === null || _a === void 0 ? void 0 : _a.call(context, index, [customRef, customChild ? customRef : this.additionalRef.current], isDisabled, role === 'separator');
    }
    extendAdditionalChildRef() {
        const { additionalChild } = this.props;
        return react.cloneElement(additionalChild, {
            ref: this.additionalRef
        });
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { className, children, context, onClick, component, role, isDisabled, isAriaDisabled, isPlainText, index, href, tooltip, tooltipProps, id, componentID, listItemClassName, additionalChild, customChild, enterTriggersArrowDown, icon, autoFocus, styleChildren, description, inoperableEvents } = _a, additionalProps = (0,tslib_es6.__rest)(_a, ["className", "children", "context", "onClick", "component", "role", "isDisabled", "isAriaDisabled", "isPlainText", "index", "href", "tooltip", "tooltipProps", "id", "componentID", "listItemClassName", "additionalChild", "customChild", "enterTriggersArrowDown", "icon", "autoFocus", "styleChildren", "description", "inoperableEvents"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        let classes = (0,esm.css)(icon && dropdown["default"].modifiers.icon, isAriaDisabled && dropdown["default"].modifiers.ariaDisabled, className);
        if (component === 'a') {
            additionalProps['aria-disabled'] = isDisabled || isAriaDisabled;
        }
        else if (component === 'button') {
            additionalProps['aria-disabled'] = isDisabled || isAriaDisabled;
            additionalProps.type = additionalProps.type || 'button';
        }
        const renderWithTooltip = (childNode) => tooltip ? (react.createElement(Tooltip, Object.assign({ content: tooltip }, tooltipProps), childNode)) : (childNode);
        const renderClonedComponent = (element) => react.cloneElement(element, Object.assign(Object.assign({}, (styleChildren && {
            className: (0,esm.css)(element.props.className, classes)
        })), (this.props.role !== 'separator' && { role, ref: this.componentRef })));
        const renderDefaultComponent = (tag) => {
            const Component = tag;
            const componentContent = description ? (react.createElement(react.Fragment, null,
                react.createElement("div", { className: dropdown["default"].dropdownMenuItemMain },
                    icon && react.createElement("span", { className: (0,esm.css)(dropdown["default"].dropdownMenuItemIcon) }, icon),
                    children),
                react.createElement("div", { className: dropdown["default"].dropdownMenuItemDescription }, description))) : (react.createElement(react.Fragment, null,
                icon && react.createElement("span", { className: (0,esm.css)(dropdown["default"].dropdownMenuItemIcon) }, icon),
                children));
            return (react.createElement(Component, Object.assign({}, additionalProps, (isDisabled || isAriaDisabled ? preventedEvents(inoperableEvents) : null), { href: href, ref: this.ref, className: classes, id: componentID, role: role }), componentContent));
        };
        return (react.createElement(DropdownContext.Consumer, null, ({ onSelect, itemClass, disabledClass, plainTextClass }) => {
            if (this.props.role !== 'separator') {
                classes = (0,esm.css)(classes, isDisabled && disabledClass, isPlainText && plainTextClass, itemClass, description && dropdown["default"].modifiers.description);
            }
            if (customChild) {
                return react.cloneElement(customChild, {
                    ref: this.ref,
                    onKeyDown: this.onKeyDown
                });
            }
            return (react.createElement("li", Object.assign({}, (listItemClassName && { className: listItemClassName }), { role: "none", onKeyDown: this.onKeyDown, onClick: (event) => {
                    if (!isDisabled && !isAriaDisabled) {
                        onClick === null || onClick === void 0 ? void 0 : onClick(event);
                        onSelect === null || onSelect === void 0 ? void 0 : onSelect(event);
                    }
                }, id: id }),
                renderWithTooltip(react.isValidElement(component)
                    ? renderClonedComponent(component)
                    : renderDefaultComponent(component)),
                additionalChild && this.extendAdditionalChildRef()));
        }));
    }
}
InternalDropdownItem.displayName = 'InternalDropdownItem';
InternalDropdownItem.defaultProps = {
    className: '',
    component: 'a',
    role: 'none',
    isDisabled: false,
    isPlainText: false,
    tooltipProps: {},
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (event) => undefined,
    index: -1,
    context: {
        keyHandler: () => { },
        sendRef: () => { }
    },
    enterTriggersArrowDown: false,
    icon: null,
    styleChildren: true,
    description: null,
    inoperableEvents: ['onClick', 'onKeyPress']
};
//# sourceMappingURL=InternalDropdownItem.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Divider/divider.js
var divider = __webpack_require__(74277);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Divider/Divider.js





var DividerVariant;
(function (DividerVariant) {
    DividerVariant["hr"] = "hr";
    DividerVariant["li"] = "li";
    DividerVariant["div"] = "div";
})(DividerVariant || (DividerVariant = {}));
const Divider = (_a) => {
    var { className, component = DividerVariant.hr, isVertical = false, inset, orientation } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "component", "isVertical", "inset", "orientation"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(divider["default"].divider, isVertical && divider["default"].modifiers.vertical, formatBreakpointMods(inset, divider["default"]), formatBreakpointMods(orientation, divider["default"]), className) }, (component !== 'hr' && { role: 'separator' }), props)));
};
Divider.displayName = 'Divider';
//# sourceMappingURL=Divider.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownSeparator.js






const DropdownSeparator = (_a) => {
    var { className = '', 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref, // Types of Ref are different for React.FunctionComponent vs React.Component
    ouiaId, ouiaSafe } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "ref", "ouiaId", "ouiaSafe"]);
    const ouiaProps = useOUIAProps(DropdownSeparator.displayName, ouiaId, ouiaSafe);
    return (react.createElement(DropdownArrowContext.Consumer, null, context => (react.createElement(InternalDropdownItem, Object.assign({}, props, { context: context, component: react.createElement(Divider, { component: DividerVariant.div }), className: className, role: "separator" }, ouiaProps)))));
};
DropdownSeparator.displayName = 'DropdownSeparator';
//# sourceMappingURL=DropdownSeparator.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherSeparator.js



const ApplicationLauncherSeparator = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    children } = _a, props = (0,tslib_es6.__rest)(_a, ["children"]);
    return react.createElement(DropdownSeparator, Object.assign({}, props));
};
ApplicationLauncherSeparator.displayName = 'ApplicationLauncherSeparator';
//# sourceMappingURL=ApplicationLauncherSeparator.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownItem.js





const DropdownItem = (_a) => {
    var { children, className, component = 'a', isDisabled = false, isAriaDisabled = false, isPlainText = false, href, tooltip, tooltipProps = {}, listItemClassName, onClick, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref, // Types of Ref are different for React.FunctionComponent vs React.Component
    additionalChild, customChild, tabIndex = -1, icon = null, autoFocus, description = null, styleChildren, ouiaId, ouiaSafe } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component", "isDisabled", "isAriaDisabled", "isPlainText", "href", "tooltip", "tooltipProps", "listItemClassName", "onClick", "ref", "additionalChild", "customChild", "tabIndex", "icon", "autoFocus", "description", "styleChildren", "ouiaId", "ouiaSafe"]);
    const ouiaProps = useOUIAProps(DropdownItem.displayName, ouiaId, ouiaSafe);
    return (react.createElement(DropdownArrowContext.Consumer, null, context => (react.createElement(InternalDropdownItem, Object.assign({ context: context, role: "menuitem", tabIndex: tabIndex, className: className, component: component, isDisabled: isDisabled, isAriaDisabled: isAriaDisabled, isPlainText: isPlainText, href: href, tooltip: tooltip, tooltipProps: tooltipProps, listItemClassName: listItemClassName, onClick: onClick, additionalChild: additionalChild, customChild: customChild, icon: icon, autoFocus: autoFocus, styleChildren: styleChildren, description: description }, ouiaProps, props), children))));
};
DropdownItem.displayName = 'DropdownItem';
//# sourceMappingURL=DropdownItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherIcon.js




const ApplicationLauncherIcon = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(app_launcher/* default */.Z.appLauncherMenuItemIcon) }, props), children));
};
ApplicationLauncherIcon.displayName = 'ApplicationLauncherIcon';
//# sourceMappingURL=ApplicationLauncherIcon.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherText.js



const ApplicationLauncherText = (_a) => {
    var { className = '', children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)('pf-c-app-launcher__menu-item-text', className) }, props), children));
};
ApplicationLauncherText.displayName = 'ApplicationLauncherText';
//# sourceMappingURL=ApplicationLauncherText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/external-link-alt-icon.js


const ExternalLinkAltIconConfig = {
  name: 'ExternalLinkAltIcon',
  height: 512,
  width: 512,
  svgPath: 'M432,320H400a16,16,0,0,0-16,16V448H64V128H208a16,16,0,0,0,16-16V80a16,16,0,0,0-16-16H48A48,48,0,0,0,0,112V464a48,48,0,0,0,48,48H400a48,48,0,0,0,48-48V336A16,16,0,0,0,432,320ZM488,0h-128c-21.37,0-32.05,25.91-17,41l35.73,35.73L135,320.37a24,24,0,0,0,0,34L157.67,377a24,24,0,0,0,34,0L435.28,133.32,471,169c15,15,41,4.5,41-17V24A24,24,0,0,0,488,0Z',
  yOffset: 0,
  xOffset: 0,
};

const ExternalLinkAltIcon = createIcon(ExternalLinkAltIconConfig);

/* harmony default export */ const external_link_alt_icon = (ExternalLinkAltIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherItemContext.js

const ApplicationLauncherItemContext = react.createContext({ isExternal: false, icon: null });
//# sourceMappingURL=ApplicationLauncherItemContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherContent.js








const ApplicationLauncherContent = ({ children }) => (react.createElement(ApplicationLauncherItemContext.Consumer, null, ({ isExternal, icon }) => (react.createElement(react.Fragment, null,
    icon && react.createElement(ApplicationLauncherIcon, null, icon),
    icon ? react.createElement(ApplicationLauncherText, null, children) : children,
    isExternal && (react.createElement(react.Fragment, null,
        react.createElement("span", { className: (0,esm.css)(app_launcher/* default */.Z.appLauncherMenuItemExternalIcon) },
            react.createElement(external_link_alt_icon, null)),
        react.createElement("span", { className: (0,esm.css)(accessibility["default"].screenReader) }, "(opens new window)")))))));
ApplicationLauncherContent.displayName = 'ApplicationLauncherContent';
//# sourceMappingURL=ApplicationLauncherContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherContext.js

const ApplicationLauncherContext = react.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onFavorite: (itemId, isFavorite) => { }
});
//# sourceMappingURL=ApplicationLauncherContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/star-icon.js


const StarIconConfig = {
  name: 'StarIcon',
  height: 512,
  width: 576,
  svgPath: 'M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z',
  yOffset: 0,
  xOffset: 0,
};

const StarIcon = createIcon(StarIconConfig);

/* harmony default export */ const star_icon = (StarIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncherItem.js










const ApplicationLauncherItem = (_a) => {
    var { className = '', id, children, icon = null, isExternal = false, href, tooltip = null, tooltipProps = null, component = 'a', isFavorite = null, ariaIsFavoriteLabel = 'starred', ariaIsNotFavoriteLabel = 'not starred', customChild, enterTriggersArrowDown = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "id", "children", "icon", "isExternal", "href", "tooltip", "tooltipProps", "component", "isFavorite", "ariaIsFavoriteLabel", "ariaIsNotFavoriteLabel", "customChild", "enterTriggersArrowDown"]);
    return (react.createElement(ApplicationLauncherItemContext.Provider, { value: { isExternal, icon } },
        react.createElement(ApplicationLauncherContext.Consumer, null, ({ onFavorite }) => (react.createElement(DropdownItem, Object.assign({ id: id, component: component, href: href || null, className: (0,esm.css)(isExternal && app_launcher/* default */.Z.modifiers.external, isFavorite !== null && app_launcher/* default */.Z.modifiers.link, className), listItemClassName: (0,esm.css)(onFavorite && app_launcher/* default */.Z.appLauncherMenuWrapper, isFavorite && app_launcher/* default */.Z.modifiers.favorite), tooltip: tooltip, tooltipProps: tooltipProps }, (enterTriggersArrowDown === true && { enterTriggersArrowDown }), (customChild && { customChild }), (isFavorite !== null && {
            additionalChild: (react.createElement("button", { className: (0,esm.css)(app_launcher/* default */.Z.appLauncherMenuItem, app_launcher/* default */.Z.modifiers.action), "aria-label": isFavorite ? ariaIsFavoriteLabel : ariaIsNotFavoriteLabel, onClick: () => {
                    onFavorite((id || getUniqueId('app-launcher-option')).replace('favorite-', ''), isFavorite);
                } },
                react.createElement(star_icon, null)))
        }), props), children && react.createElement(ApplicationLauncherContent, null, children))))));
};
ApplicationLauncherItem.displayName = 'ApplicationLauncherItem';
//# sourceMappingURL=ApplicationLauncherItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/favorites.js



/**
 * This function is a helper for creating an array of renderable favorite items for the Application launcher or Select
 *
 * @param {object} items The items rendered in Select or Application aLauncher
 * @param {boolean} isGrouped Flag indicating if items are grouped
 * @param {any[]} favorites Array of ids of favorited items
 * @param {boolean} isEnterTriggersArrowDown Flag indicating if we should add isEnterTriggersArrowDown to favorited item
 */
const createRenderableFavorites = (items, isGrouped, favorites, isEnterTriggersArrowDown) => {
    if (isGrouped) {
        const favoriteItems = [];
        items.forEach(group => {
            if (favorites.length > 0) {
                return (group.props.children &&
                    group.props.children
                        .filter(item => favorites.includes(item.props.id))
                        .map(item => {
                        if (isEnterTriggersArrowDown) {
                            return favoriteItems.push(react.cloneElement(item, {
                                isFavorite: true,
                                enterTriggersArrowDown: isEnterTriggersArrowDown,
                                id: `favorite-${item.props.id}`
                            }));
                        }
                        else {
                            return favoriteItems.push(react.cloneElement(item, { isFavorite: true, id: `favorite-${item.props.id}` }));
                        }
                    }));
            }
        });
        return favoriteItems;
    }
    return items
        .filter(item => favorites.includes(item.props.id))
        .map(item => react.cloneElement(item, { isFavorite: true, enterTriggersArrowDown: isEnterTriggersArrowDown }));
};
/**
 * This function is a helper for extending the array of renderable favorite with the select/application launcher items to  render in the Application launcher or Select
 *
 * @param {object} items The items rendered in Select or Application aLauncher
 * @param {boolean} isGrouped Flag indicating if items are grouped
 * @param {any[]} favorites Array of ids of favorited items
 */
const extendItemsWithFavorite = (items, isGrouped, favorites) => {
    if (isGrouped) {
        return items.map(group => react.cloneElement(group, {
            children: react.Children.map(group.props.children, item => {
                if (item.type === ApplicationLauncherSeparator || item.type === Divider) {
                    return item;
                }
                return react.cloneElement(item, {
                    isFavorite: favorites.some(favoriteId => favoriteId === item.props.id || `favorite-${favoriteId}` === item.props.id)
                });
            })
        }));
    }
    return items.map(item => react.cloneElement(item, {
        isFavorite: favorites.some(favoriteId => favoriteId === item.props.id)
    }));
};
//# sourceMappingURL=favorites.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/ApplicationLauncher.js













class ApplicationLauncher extends react.Component {
    constructor() {
        super(...arguments);
        this.createSearchBox = () => {
            const { onSearch, searchPlaceholderText, searchProps } = this.props;
            return (react.createElement("div", { key: "search", className: (0,esm.css)(app_launcher/* default */.Z.appLauncherMenuSearch) },
                react.createElement(ApplicationLauncherItem, { customChild: react.createElement("input", Object.assign({ type: "search", className: (0,esm.css)(form_control["default"].formControl), placeholder: searchPlaceholderText, onChange: e => onSearch(e.target.value) }, searchProps)) })));
        };
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, isOpen, onToggle, toggleIcon, toggleId, onSelect, isDisabled, className, isGrouped, favorites, onFavorite, onSearch, items, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        searchPlaceholderText, searchProps, ref, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        favoritesLabel, searchNoResultsText, menuAppendTo, removeFindDomNode, zIndex = 9999 } = _a, props = (0,tslib_es6.__rest)(_a, ['aria-label', "isOpen", "onToggle", "toggleIcon", "toggleId", "onSelect", "isDisabled", "className", "isGrouped", "favorites", "onFavorite", "onSearch", "items", "searchPlaceholderText", "searchProps", "ref", "favoritesLabel", "searchNoResultsText", "menuAppendTo", "removeFindDomNode", "zIndex"]);
        let renderableItems = [];
        if (onFavorite) {
            let favoritesGroup = [];
            let renderableFavorites = [];
            if (favorites.length > 0) {
                renderableFavorites = createRenderableFavorites(items, isGrouped, favorites, true);
                favoritesGroup = [
                    react.createElement(ApplicationLauncherGroup, { key: "favorites", label: favoritesLabel },
                        renderableFavorites,
                        react.createElement(ApplicationLauncherSeparator, { key: "separator" }))
                ];
            }
            if (renderableFavorites.length > 0) {
                renderableItems = favoritesGroup.concat(extendItemsWithFavorite(items, isGrouped, favorites));
            }
            else {
                renderableItems = extendItemsWithFavorite(items, isGrouped, favorites);
            }
        }
        else {
            renderableItems = items;
        }
        if (items.length === 0) {
            renderableItems = [
                react.createElement(ApplicationLauncherGroup, { key: "no-results-group" },
                    react.createElement(ApplicationLauncherItem, { key: "no-results" }, searchNoResultsText))
            ];
        }
        if (onSearch) {
            renderableItems = [this.createSearchBox(), ...renderableItems];
        }
        return (react.createElement(ApplicationLauncherContext.Provider, { value: { onFavorite } },
            react.createElement(DropdownContext.Provider, { value: {
                    onSelect,
                    menuClass: app_launcher/* default */.Z.appLauncherMenu,
                    itemClass: app_launcher/* default */.Z.appLauncherMenuItem,
                    toggleClass: app_launcher/* default */.Z.appLauncherToggle,
                    baseClass: app_launcher/* default */.Z.appLauncher,
                    baseComponent: 'nav',
                    sectionClass: app_launcher/* default */.Z.appLauncherGroup,
                    sectionTitleClass: app_launcher/* default */.Z.appLauncherGroupTitle,
                    sectionComponent: 'section',
                    disabledClass: app_launcher/* default */.Z.modifiers.disabled,
                    ouiaComponentType: ApplicationLauncher.displayName
                } },
                react.createElement(DropdownWithContext, Object.assign({}, props, { dropdownItems: renderableItems, isOpen: isOpen, className: className, "aria-label": ariaLabel, menuAppendTo: menuAppendTo, removeFindDomNode: removeFindDomNode, zIndex: zIndex, toggle: react.createElement(DropdownToggle, { id: toggleId, toggleIndicator: null, isOpen: isOpen, onToggle: onToggle, isDisabled: isDisabled, "aria-label": ariaLabel }, toggleIcon), isGrouped: isGrouped })))));
    }
}
ApplicationLauncher.displayName = 'ApplicationLauncher';
ApplicationLauncher.defaultProps = {
    className: '',
    isDisabled: false,
    direction: DropdownDirection.down,
    favorites: [],
    items: [],
    isOpen: false,
    position: DropdownPosition.left,
    /* eslint-disable @typescript-eslint/no-unused-vars */
    onSelect: (_event) => undefined,
    onToggle: (_value) => undefined,
    /* eslint-enable @typescript-eslint/no-unused-vars */
    'aria-label': 'Application launcher',
    isGrouped: false,
    toggleIcon: react.createElement(th_icon, null),
    searchPlaceholderText: 'Filter by name...',
    searchNoResultsText: 'No results found',
    favoritesLabel: 'Favorites',
    menuAppendTo: 'inline',
    removeFindDomNode: false
};
//# sourceMappingURL=ApplicationLauncher.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ApplicationLauncher/index.js









//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Avatar/avatar.js
var avatar = __webpack_require__(24163);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Avatar/Avatar.js




const Avatar = (_a) => {
    var { className = '', src = '', alt, border, size } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "src", "alt", "border", "size"]);
    return (react.createElement("img", Object.assign({ src: src, alt: alt, className: (0,esm.css)(avatar["default"].avatar, avatar["default"].modifiers[size], border === 'light' && avatar["default"].modifiers.light, border === 'dark' && avatar["default"].modifiers.dark, className) }, props)));
};
Avatar.displayName = 'Avatar';
//# sourceMappingURL=Avatar.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Avatar/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/BackToTop/back-to-top.js
var back_to_top = __webpack_require__(32753);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/angle-up-icon.js


const AngleUpIconConfig = {
  name: 'AngleUpIcon',
  height: 512,
  width: 320,
  svgPath: 'M177 159.7l136 136c9.4 9.4 9.4 24.6 0 33.9l-22.6 22.6c-9.4 9.4-24.6 9.4-33.9 0L160 255.9l-96.4 96.4c-9.4 9.4-24.6 9.4-33.9 0L7 329.7c-9.4-9.4-9.4-24.6 0-33.9l136-136c9.4-9.5 24.6-9.5 34-.1z',
  yOffset: 0,
  xOffset: 0,
};

const AngleUpIcon = createIcon(AngleUpIconConfig);

/* harmony default export */ const angle_up_icon = (AngleUpIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/BackToTop/BackToTop.js







const BackToTopBase = (_a) => {
    var { className, title = 'Back to top', innerRef, scrollableSelector, isAlwaysVisible = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "title", "innerRef", "scrollableSelector", "isAlwaysVisible"]);
    const [visible, setVisible] = react.useState(isAlwaysVisible);
    react.useEffect(() => {
        setVisible(isAlwaysVisible);
    }, [isAlwaysVisible]);
    const [scrollElement, setScrollElement] = react.useState(null);
    const toggleVisible = () => {
        const scrolled = scrollElement.scrollY ? scrollElement.scrollY : scrollElement.scrollTop;
        if (!isAlwaysVisible) {
            if (scrolled > 400) {
                setVisible(true);
            }
            else {
                setVisible(false);
            }
        }
    };
    react.useEffect(() => {
        const hasScrollSpy = Boolean(scrollableSelector);
        if (hasScrollSpy) {
            const scrollEl = document.querySelector(scrollableSelector);
            if (!canUseDOM || !(scrollEl instanceof HTMLElement)) {
                return;
            }
            setScrollElement(scrollEl);
            scrollEl.addEventListener('scroll', toggleVisible);
            return () => {
                scrollEl.removeEventListener('scroll', toggleVisible);
            };
        }
        else {
            if (!canUseDOM) {
                return;
            }
            const scrollEl = window;
            setScrollElement(scrollEl);
            scrollEl.addEventListener('scroll', toggleVisible);
            return () => {
                scrollEl.removeEventListener('scroll', toggleVisible);
            };
        }
    }, [scrollableSelector, toggleVisible]);
    const handleClick = () => {
        scrollElement.scrollTo({ top: 0, behavior: 'smooth' });
    };
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(back_to_top/* default */.Z.backToTop, !visible && back_to_top/* default */.Z.modifiers.hidden, className), ref: innerRef, onClick: handleClick }, props),
        react.createElement(Button, { variant: "primary", icon: react.createElement(angle_up_icon, { "aria-hidden": "true" }), iconPosition: "right" }, title)));
};
const BackToTop = react.forwardRef((props, ref) => (react.createElement(BackToTopBase, Object.assign({ innerRef: ref }, props))));
BackToTop.displayName = 'BackToTop';
//# sourceMappingURL=BackToTop.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/BackToTop/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Backdrop/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_background_image_BackgroundImage.js
const c_background_image_BackgroundImage = {
  "name": "--pf-c-background-image--BackgroundImage",
  "value": "url(\"../../assets/images/pfbg_576.jpg\")",
  "var": "var(--pf-c-background-image--BackgroundImage)"
};
/* harmony default export */ const esm_c_background_image_BackgroundImage = (c_background_image_BackgroundImage);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_background_image_BackgroundImage_2x.js
const c_background_image_BackgroundImage_2x = {
  "name": "--pf-c-background-image--BackgroundImage-2x",
  "value": "url(\"../../assets/images/pfbg_576@2x.jpg\")",
  "var": "var(--pf-c-background-image--BackgroundImage-2x)"
};
/* harmony default export */ const esm_c_background_image_BackgroundImage_2x = (c_background_image_BackgroundImage_2x);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_background_image_BackgroundImage_sm.js
const c_background_image_BackgroundImage_sm = {
  "name": "--pf-c-background-image--BackgroundImage--sm",
  "value": "url(\"../../assets/images/pfbg_768.jpg\")",
  "var": "var(--pf-c-background-image--BackgroundImage--sm)"
};
/* harmony default export */ const esm_c_background_image_BackgroundImage_sm = (c_background_image_BackgroundImage_sm);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_background_image_BackgroundImage_sm_2x.js
const c_background_image_BackgroundImage_sm_2x = {
  "name": "--pf-c-background-image--BackgroundImage--sm-2x",
  "value": "url(\"../../assets/images/pfbg_768@2x.jpg\")",
  "var": "var(--pf-c-background-image--BackgroundImage--sm-2x)"
};
/* harmony default export */ const esm_c_background_image_BackgroundImage_sm_2x = (c_background_image_BackgroundImage_sm_2x);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_background_image_BackgroundImage_lg.js
const c_background_image_BackgroundImage_lg = {
  "name": "--pf-c-background-image--BackgroundImage--lg",
  "value": "url(\"../../assets/images/pfbg_2000.jpg\")",
  "var": "var(--pf-c-background-image--BackgroundImage--lg)"
};
/* harmony default export */ const esm_c_background_image_BackgroundImage_lg = (c_background_image_BackgroundImage_lg);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_background_image_Filter.js
const c_background_image_Filter = {
  "name": "--pf-c-background-image--Filter",
  "value": "url(\"#image_overlay\")",
  "var": "var(--pf-c-background-image--Filter)"
};
/* harmony default export */ const esm_c_background_image_Filter = (c_background_image_Filter);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/BackgroundImage/background-image.js
var background_image = __webpack_require__(61091);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/BackgroundImage/BackgroundImage.js










const defaultFilter = (react.createElement("filter", null,
    react.createElement("feColorMatrix", { type: "matrix", values: "1 0 0 0 0 1 0 0 0 0 1 0 0 0 0 0 0 0 1 0" }),
    react.createElement("feComponentTransfer", { colorInterpolationFilters: "sRGB", result: "duotone" },
        react.createElement("feFuncR", { type: "table", tableValues: "0.086274509803922 0.43921568627451" }),
        react.createElement("feFuncG", { type: "table", tableValues: "0.086274509803922 0.43921568627451" }),
        react.createElement("feFuncB", { type: "table", tableValues: "0.086274509803922 0.43921568627451" }),
        react.createElement("feFuncA", { type: "table", tableValues: "0 1" }))));
let filterCounter = 0;
const BackgroundImage = (_a) => {
    var { className, src, filter = defaultFilter } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "src", "filter"]);
    const getUrlValue = (size) => {
        if (typeof src === 'string') {
            return `url(${src})`;
        }
        else if (typeof src === 'object') {
            return `url(${src[size]})`;
        }
        return '';
    };
    const filterNum = react.useMemo(() => filterCounter++, []);
    const filterId = `patternfly-background-image-filter-overlay${filterNum}`;
    const style = {
        [esm_c_background_image_BackgroundImage.name]: getUrlValue('xs'),
        [esm_c_background_image_BackgroundImage_2x.name]: getUrlValue('xs2x'),
        [esm_c_background_image_BackgroundImage_sm.name]: getUrlValue('sm'),
        [esm_c_background_image_BackgroundImage_sm_2x.name]: getUrlValue('sm2x'),
        [esm_c_background_image_BackgroundImage_lg.name]: getUrlValue('lg'),
        [esm_c_background_image_Filter.name]: `url(#${filterId})`
    };
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(background_image/* default */.Z.backgroundImage, className), style: style }, props),
        react.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", className: "pf-c-background-image__filter", width: "0", height: "0" }, react.cloneElement(filter, { id: filterId }))));
};
BackgroundImage.displayName = 'BackgroundImage';
//# sourceMappingURL=BackgroundImage.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/BackgroundImage/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Badge/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Banner/banner.js
var banner = __webpack_require__(68144);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Banner/Banner.js




const Banner = (_a) => {
    var { children, className, variant = 'default', screenReaderText, isSticky = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "variant", "screenReaderText", "isSticky"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(banner/* default */.Z.banner, banner/* default */.Z.modifiers[variant], isSticky && banner/* default */.Z.modifiers.sticky, className) }, props),
        screenReaderText && react.createElement("span", { className: "pf-u-screen-reader" }, screenReaderText),
        children));
};
Banner.displayName = 'Banner';
//# sourceMappingURL=Banner.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Banner/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Brand/brand.js
var brand = __webpack_require__(28301);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Brand/Brand.js





const Brand = (_a) => {
    var { className = '', src = '', alt, children, widths, heights, style } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "src", "alt", "children", "widths", "heights", "style"]);
    if (children !== undefined && widths !== undefined) {
        style = Object.assign(Object.assign({}, style), setBreakpointCssVars(widths, '--pf-c-brand--Width'));
    }
    if (children !== undefined && heights !== undefined) {
        style = Object.assign(Object.assign({}, style), setBreakpointCssVars(heights, '--pf-c-brand--Height'));
    }
    return (
    /** the brand component currently contains no styling the 'pf-c-brand' string will be used for the className */
    children !== undefined ? (react.createElement("picture", Object.assign({ className: (0,esm.css)(brand["default"].brand, brand["default"].modifiers.picture, className), style: style }, props),
        children,
        react.createElement("img", { src: src, alt: alt }))) : (react.createElement("img", Object.assign({}, props, { className: (0,esm.css)(brand["default"].brand, className), src: src, alt: alt }))));
};
Brand.displayName = 'Brand';
//# sourceMappingURL=Brand.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Brand/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Breadcrumb/breadcrumb.js
var breadcrumb = __webpack_require__(13499);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/Breadcrumb.js





const Breadcrumb = (_a) => {
    var { children = null, className = '', 'aria-label': ariaLabel = 'Breadcrumb', ouiaId, ouiaSafe = true } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", 'aria-label', "ouiaId", "ouiaSafe"]);
    const ouiaProps = useOUIAProps(Breadcrumb.displayName, ouiaId, ouiaSafe);
    return (react.createElement("nav", Object.assign({}, props, { "aria-label": ariaLabel, className: (0,esm.css)(breadcrumb["default"].breadcrumb, className) }, ouiaProps),
        react.createElement("ol", { className: breadcrumb["default"].breadcrumbList }, react.Children.map(children, (child, index) => {
            const showDivider = index > 0;
            if (react.isValidElement(child)) {
                return react.cloneElement(child, { showDivider });
            }
            return child;
        }))));
};
Breadcrumb.displayName = 'Breadcrumb';
//# sourceMappingURL=Breadcrumb.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/BreadcrumbItem.js





const BreadcrumbItem = (_a) => {
    var { children = null, className: classNameProp = '', to = undefined, isActive = false, isDropdown = false, showDivider, target = undefined, component = 'a', render = undefined } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "to", "isActive", "isDropdown", "showDivider", "target", "component", "render"]);
    const Component = component;
    const ariaCurrent = isActive ? 'page' : undefined;
    const className = (0,esm.css)(breadcrumb["default"].breadcrumbLink, isActive && breadcrumb["default"].modifiers.current);
    return (react.createElement("li", Object.assign({}, props, { className: (0,esm.css)(breadcrumb["default"].breadcrumbItem, classNameProp) }),
        showDivider && (react.createElement("span", { className: breadcrumb["default"].breadcrumbItemDivider },
            react.createElement(angle_right_icon, null))),
        component === 'button' && (react.createElement("button", { className: className, "aria-current": ariaCurrent, type: "button" }, children)),
        isDropdown && react.createElement("span", { className: (0,esm.css)(breadcrumb["default"].breadcrumbDropdown) }, children),
        render && render({ className, ariaCurrent }),
        to && !render && (react.createElement(Component, { href: to, target: target, className: className, "aria-current": ariaCurrent }, children)),
        !to && component !== 'button' && !isDropdown && children));
};
BreadcrumbItem.displayName = 'BreadcrumbItem';
//# sourceMappingURL=BreadcrumbItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/BreadcrumbHeading.js





const BreadcrumbHeading = (_a) => {
    var { children = null, className = '', to = undefined, target = undefined, component = 'a', showDivider } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "to", "target", "component", "showDivider"]);
    const Component = component;
    return (react.createElement("li", Object.assign({}, props, { className: (0,esm.css)(breadcrumb["default"].breadcrumbItem, className) }),
        showDivider && (react.createElement("span", { className: breadcrumb["default"].breadcrumbItemDivider },
            react.createElement(angle_right_icon, null))),
        react.createElement("h1", { className: breadcrumb["default"].breadcrumbHeading },
            !to && component === 'button' && (react.createElement("button", { className: (0,esm.css)(breadcrumb["default"].breadcrumbLink, breadcrumb["default"].modifiers.current), "aria-current": true, type: "button" }, children)),
            to && (react.createElement(Component, { href: to, target: target, className: (0,esm.css)(breadcrumb["default"].breadcrumbLink, breadcrumb["default"].modifiers.current), "aria-current": "page" }, children)),
            !to && component !== 'button' && react.createElement(react.Fragment, null, children))));
};
BreadcrumbHeading.displayName = 'BreadcrumbHeading';
//# sourceMappingURL=BreadcrumbHeading.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Breadcrumb/index.js



//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Button/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/resizeObserver.js

/**
 * This function creates a ResizeObserver used to handle resize events for the given containerRef. If ResizeObserver
 * or the given containerRef are not available, a window resize event listener is used by default.
 *
 * Example 1:
 *
 * private containerRef = React.createRef<HTMLDivElement>();
 * private observer: any = () => {};
 *
 * public componentDidMount() {
 *   this.observer = getResizeObserver(this.containerRef.current, this.handleResize);
 * }
 *
 * public componentWillUnmount() {
 *   this.observer();
 * }
 *
 * private handleResize = () => {
 *   if (this.containerRef.current && this.containerRef.current.clientWidth) {
 *     this.setState({ width: this.containerRef.current.clientWidth });
 *   }
 * };
 *
 * public render() {
 *   return (
 *     <div ref={this.containerRef} >
 *       <Chart width={this.state.width} ... />
 *     </div>
 *   );
 * }
 *
 * Example 2:
 *
 * private inputRef = React.createRef<HTMLInputElement>();
 * private observer: any = () => {};
 *
 * public componentDidMount() {
 *   this.observer = getResizeObserver(this.inputRef.current, this.handleResize);
 * }
 *
 * public componentWillUnmount() {
 *   this.observer();
 * }
 *
 * private handleResize = () => {
 *   if (this.inputRef.current) {
 *     trimLeft(inputRef.current, String(this.props.value));
 *   }
 * };
 *
 * public render() {
 *   return (
 *     <input ref={this.inputRef} ... />
 *   );
 * }
 *
 * Example 3 - With debounced method passed in:
 *
 * public componentDidMount() {
 *   this.observer = getResizeObserver(this.inputRef.current, debounce(this.handleResize, 250), false);
 * }
 *
 * @param {Element} containerRefElement The container reference to observe
 * @param {Function} handleResize The function to call for resize events
 * @param {boolean} useRequestAnimationFrame Whether to pass the handleResize function as a callback to requestAnimationFrame. Pass in false when the function passed in is debounced. Defaults to true.
 * @return {Function} The function used to unobserve resize events
 */
const getResizeObserver = (containerRefElement, handleResize, useRequestAnimationFrame = true) => {
    let unobserve;
    if (canUseDOM) {
        const { ResizeObserver } = window;
        if (containerRefElement && ResizeObserver) {
            const resizeObserver = new ResizeObserver((entries) => {
                // Wrap resize function in requestAnimationFrame to avoid "ResizeObserver loop limit exceeded" errors
                if (useRequestAnimationFrame) {
                    window.requestAnimationFrame(() => {
                        if (Array.isArray(entries) && entries.length > 0) {
                            handleResize();
                        }
                    });
                    // Avoid wrapping function in requestAnimationFrame if the function is debounced
                }
                else {
                    if (Array.isArray(entries) && entries.length > 0) {
                        handleResize();
                    }
                }
            });
            resizeObserver.observe(containerRefElement);
            unobserve = () => resizeObserver.unobserve(containerRefElement);
        }
        else {
            window.addEventListener('resize', handleResize);
            unobserve = () => window.removeEventListener('resize', handleResize);
        }
    }
    return () => {
        if (unobserve) {
            unobserve();
        }
    };
};
//# sourceMappingURL=resizeObserver.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/TextInput/TextInput.js








var TextInputTypes;
(function (TextInputTypes) {
    TextInputTypes["text"] = "text";
    TextInputTypes["date"] = "date";
    TextInputTypes["datetimeLocal"] = "datetime-local";
    TextInputTypes["email"] = "email";
    TextInputTypes["month"] = "month";
    TextInputTypes["number"] = "number";
    TextInputTypes["password"] = "password";
    TextInputTypes["search"] = "search";
    TextInputTypes["tel"] = "tel";
    TextInputTypes["time"] = "time";
    TextInputTypes["url"] = "url";
})(TextInputTypes || (TextInputTypes = {}));
var TextInputReadOnlyVariant;
(function (TextInputReadOnlyVariant) {
    TextInputReadOnlyVariant["default"] = "default";
    TextInputReadOnlyVariant["plain"] = "plain";
})(TextInputReadOnlyVariant || (TextInputReadOnlyVariant = {}));
class TextInputBase extends react.Component {
    constructor(props) {
        super(props);
        this.inputRef = react.createRef();
        this.observer = () => { };
        this.handleChange = (event) => {
            if (this.props.onChange) {
                this.props.onChange(event.currentTarget.value, event);
            }
        };
        this.handleResize = () => {
            const inputRef = this.props.innerRef || this.inputRef;
            if (inputRef && inputRef.current) {
                trimLeft(inputRef.current, String(this.props.value));
            }
        };
        this.restoreText = () => {
            const inputRef = this.props.innerRef || this.inputRef;
            // restore the value
            inputRef.current.value = String(this.props.value);
            // make sure we still see the rightmost value to preserve cursor click position
            inputRef.current.scrollLeft = inputRef.current.scrollWidth;
        };
        this.onFocus = (event) => {
            const { isLeftTruncated, onFocus } = this.props;
            if (isLeftTruncated) {
                this.restoreText();
            }
            onFocus && onFocus(event);
        };
        this.onBlur = (event) => {
            const { isLeftTruncated, onBlur } = this.props;
            if (isLeftTruncated) {
                this.handleResize();
            }
            onBlur && onBlur(event);
        };
        this.sanitizeInputValue = (value) => typeof value === 'string' ? value.replace(/\n/g, ' ') : value;
        if (!props.id && !props['aria-label'] && !props['aria-labelledby']) {
            // eslint-disable-next-line no-console
            console.error('Text input:', 'Text input requires either an id or aria-label to be specified');
        }
        this.state = {
            ouiaStateId: getDefaultOUIAId(TextInputBase.displayName)
        };
    }
    componentDidMount() {
        if (this.props.isLeftTruncated) {
            const inputRef = this.props.innerRef || this.inputRef;
            this.observer = getResizeObserver(inputRef.current, this.handleResize);
            this.handleResize();
        }
    }
    componentWillUnmount() {
        if (this.props.isLeftTruncated) {
            this.observer();
        }
    }
    render() {
        const _a = this.props, { innerRef, className, type, value, validated, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onChange, onFocus, onBlur, isLeftTruncated, isReadOnly, readOnly, readOnlyVariant, isRequired, isDisabled, isIconSprite, iconVariant, customIconUrl, customIconDimensions, ouiaId, ouiaSafe } = _a, props = (0,tslib_es6.__rest)(_a, ["innerRef", "className", "type", "value", "validated", "onChange", "onFocus", "onBlur", "isLeftTruncated", "isReadOnly", "readOnly", "readOnlyVariant", "isRequired", "isDisabled", "isIconSprite", "iconVariant", "customIconUrl", "customIconDimensions", "ouiaId", "ouiaSafe"]);
        const customIconStyle = {};
        if (customIconUrl) {
            customIconStyle.backgroundImage = `url('${customIconUrl}')`;
        }
        if (customIconDimensions) {
            customIconStyle.backgroundSize = customIconDimensions;
        }
        return (react.createElement("input", Object.assign({}, props, { onFocus: this.onFocus, onBlur: this.onBlur, className: (0,esm.css)(form_control["default"].formControl, isIconSprite && form_control["default"].modifiers.iconSprite, readOnlyVariant === 'plain' && form_control["default"].modifiers.plain, validated === ValidatedOptions.success && form_control["default"].modifiers.success, validated === ValidatedOptions.warning && form_control["default"].modifiers.warning, ((iconVariant && iconVariant !== 'search') || customIconUrl) && form_control["default"].modifiers.icon, iconVariant && form_control["default"].modifiers[iconVariant], className), onChange: this.handleChange, type: type, value: this.sanitizeInputValue(value), "aria-invalid": props['aria-invalid'] ? props['aria-invalid'] : validated === ValidatedOptions.error, required: isRequired, disabled: isDisabled, readOnly: !!readOnlyVariant || isReadOnly || readOnly, ref: innerRef || this.inputRef }, ((customIconUrl || customIconDimensions) && { style: customIconStyle }), getOUIAProps(TextInput.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe))));
    }
}
TextInputBase.displayName = 'TextInputBase';
TextInputBase.defaultProps = {
    'aria-label': null,
    className: '',
    isRequired: false,
    validated: 'default',
    isDisabled: false,
    isReadOnly: false,
    isIconSprite: false,
    type: TextInputTypes.text,
    isLeftTruncated: false,
    onChange: () => undefined,
    ouiaSafe: true
};
const TextInput = react.forwardRef((props, ref) => (react.createElement(TextInputBase, Object.assign({}, props, { innerRef: ref }))));
TextInput.displayName = 'TextInput';
//# sourceMappingURL=TextInput.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Select/select.js
var Select_select = __webpack_require__(56341);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/times-circle-icon.js


const TimesCircleIconConfig = {
  name: 'TimesCircleIcon',
  height: 512,
  width: 512,
  svgPath: 'M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm121.6 313.1c4.7 4.7 4.7 12.3 0 17L338 377.6c-4.7 4.7-12.3 4.7-17 0L256 312l-65.1 65.6c-4.7 4.7-12.3 4.7-17 0L134.4 338c-4.7-4.7-4.7-12.3 0-17l65.6-65-65.6-65.1c-4.7-4.7-4.7-12.3 0-17l39.6-39.6c4.7-4.7 12.3-4.7 17 0l65 65.7 65.1-65.6c4.7-4.7 12.3-4.7 17 0l39.6 39.6c4.7 4.7 4.7 12.3 0 17L312 256l65.6 65.1z',
  yOffset: 0,
  xOffset: 0,
};

const TimesCircleIcon = createIcon(TimesCircleIconConfig);

/* harmony default export */ const times_circle_icon = (TimesCircleIcon);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Form/form.js
var Form_form = __webpack_require__(10519);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Check/check.js
var check = __webpack_require__(1432);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/check-icon.js


const CheckIconConfig = {
  name: 'CheckIcon',
  height: 512,
  width: 512,
  svgPath: 'M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z',
  yOffset: 0,
  xOffset: 0,
};

const CheckIcon = createIcon(CheckIconConfig);

/* harmony default export */ const check_icon = (CheckIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Select/selectConstants.js

const SelectContext = react.createContext(null);
const SelectProvider = SelectContext.Provider;
const SelectConsumer = SelectContext.Consumer;
var SelectVariant;
(function (SelectVariant) {
    SelectVariant["single"] = "single";
    SelectVariant["checkbox"] = "checkbox";
    SelectVariant["typeahead"] = "typeahead";
    SelectVariant["typeaheadMulti"] = "typeaheadmulti";
})(SelectVariant || (SelectVariant = {}));
var SelectPosition;
(function (SelectPosition) {
    SelectPosition["right"] = "right";
    SelectPosition["left"] = "left";
})(SelectPosition || (SelectPosition = {}));
var SelectDirection;
(function (SelectDirection) {
    SelectDirection["up"] = "up";
    SelectDirection["down"] = "down";
})(SelectDirection || (SelectDirection = {}));
const SelectFooterTabbableItems = 'input, button, select, textarea, a[href]';
//# sourceMappingURL=selectConstants.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Select/SelectOption.js










class SelectOption extends react.Component {
    constructor() {
        super(...arguments);
        this.ref = react.createRef();
        this.liRef = react.createRef();
        this.favoriteRef = react.createRef();
        this.onKeyDown = (event, innerIndex, onEnter, isCheckbox) => {
            const { index, keyHandler, isLastOptionBeforeFooter } = this.props;
            let isLastItemBeforeFooter = false;
            if (isLastOptionBeforeFooter !== undefined) {
                isLastItemBeforeFooter = isLastOptionBeforeFooter(index);
            }
            if (event.key === KeyTypes.Tab) {
                // More modal-like experience for checkboxes
                if (isCheckbox && !isLastItemBeforeFooter) {
                    if (event.shiftKey) {
                        keyHandler(index, innerIndex, 'up');
                    }
                    else {
                        keyHandler(index, innerIndex, 'down');
                    }
                    event.stopPropagation();
                }
                else {
                    if (event.shiftKey) {
                        keyHandler(index, innerIndex, 'up');
                    }
                    else {
                        keyHandler(index, innerIndex, 'tab');
                    }
                }
            }
            event.preventDefault();
            if (event.key === KeyTypes.ArrowUp) {
                keyHandler(index, innerIndex, 'up');
            }
            else if (event.key === KeyTypes.ArrowDown) {
                keyHandler(index, innerIndex, 'down');
            }
            else if (event.key === KeyTypes.ArrowLeft) {
                keyHandler(index, innerIndex, 'left');
            }
            else if (event.key === KeyTypes.ArrowRight) {
                keyHandler(index, innerIndex, 'right');
            }
            else if (event.key === KeyTypes.Enter) {
                if (onEnter !== undefined) {
                    onEnter();
                }
                else {
                    this.ref.current.click();
                }
            }
        };
    }
    componentDidMount() {
        this.props.sendRef(this.props.isDisabled ? null : this.ref.current, this.props.isDisabled ? null : this.favoriteRef.current, this.props.isDisabled ? null : this.liRef.current, this.props.index);
    }
    componentDidUpdate() {
        this.props.sendRef(this.props.isDisabled ? null : this.ref.current, this.props.isDisabled ? null : this.favoriteRef.current, this.props.isDisabled ? null : this.liRef.current, this.props.index);
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { children, className, id, description, itemCount, value, onClick, isDisabled, isPlaceholder, isNoResultsOption, isSelected, isChecked, isFocused, sendRef, keyHandler, index, component, inputId, isFavorite, ariaIsFavoriteLabel = 'starred', ariaIsNotFavoriteLabel = 'not starred', isLoad, isLoading, setViewMoreNextIndex, 
        // eslint-disable-next-line no-console
        isLastOptionBeforeFooter, isGrouped = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "id", "description", "itemCount", "value", "onClick", "isDisabled", "isPlaceholder", "isNoResultsOption", "isSelected", "isChecked", "isFocused", "sendRef", "keyHandler", "index", "component", "inputId", "isFavorite", "ariaIsFavoriteLabel", "ariaIsNotFavoriteLabel", "isLoad", "isLoading", "setViewMoreNextIndex", "isLastOptionBeforeFooter", "isGrouped"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        const Component = component;
        if (!id && isFavorite !== null) {
            // eslint-disable-next-line no-console
            console.error('Please provide an id to use the favorites feature.');
        }
        const generatedId = id || getUniqueId('select-option');
        const favoriteButton = (onFavorite) => (react.createElement("button", { className: (0,esm.css)(Select_select["default"].selectMenuItem, Select_select["default"].modifiers.action, Select_select["default"].modifiers.favoriteAction), "aria-label": isFavorite ? ariaIsFavoriteLabel : ariaIsNotFavoriteLabel, onClick: () => {
                onFavorite(generatedId.replace('favorite-', ''), isFavorite);
            }, onKeyDown: event => {
                this.onKeyDown(event, 1, () => onFavorite(generatedId.replace('favorite-', ''), isFavorite));
            }, ref: this.favoriteRef },
            react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemActionIcon) },
                react.createElement(star_icon, null))));
        const itemDisplay = itemCount ? (react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemRow) },
            react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemText) }, children || (value && value.toString && value.toString())),
            react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemCount) }, itemCount))) : (children || value.toString());
        const onViewMoreClick = (event) => {
            // Set the index for the next item to focus after view more clicked, then call view more callback
            setViewMoreNextIndex();
            onClick(event);
        };
        const renderOption = (onSelect, onClose, variant, inputIdPrefix, onFavorite, shouldResetOnSelect) => {
            if (variant !== SelectVariant.checkbox && isLoading && isGrouped) {
                return (react.createElement("div", { role: "presentation", className: (0,esm.css)(Select_select["default"].selectListItem, isLoading && Select_select["default"].modifiers.loading, className) }, children));
            }
            else if (variant !== SelectVariant.checkbox && isLoad && isGrouped) {
                return (react.createElement("div", null,
                    react.createElement("button", Object.assign({}, props, { role: "presentation", className: (0,esm.css)(Select_select["default"].selectMenuItem, Select_select["default"].modifiers.load, className), onClick: (event) => {
                            onViewMoreClick(event);
                            event.stopPropagation();
                        }, ref: this.ref, type: "button" }), children || value.toString())));
            }
            else if (variant !== SelectVariant.checkbox) {
                return (react.createElement("li", { id: generatedId, role: "presentation", className: (0,esm.css)(isLoading && Select_select["default"].selectListItem, !isLoading && Select_select["default"].selectMenuWrapper, isFavorite && Select_select["default"].modifiers.favorite, isFocused && Select_select["default"].modifiers.focus, isLoading && Select_select["default"].modifiers.loading), ref: this.liRef },
                    isLoading && children,
                    isLoad && !isGrouped && (react.createElement("button", Object.assign({}, props, { className: (0,esm.css)(Select_select["default"].selectMenuItem, Select_select["default"].modifiers.load, className), onClick: (event) => {
                            onViewMoreClick(event);
                            event.stopPropagation();
                        }, ref: this.ref, onKeyDown: (event) => {
                            this.onKeyDown(event, 0);
                        }, type: "button" }), itemDisplay)),
                    !isLoading && !isLoad && (react.createElement(react.Fragment, null,
                        react.createElement(Component, Object.assign({}, props, { className: (0,esm.css)(Select_select["default"].selectMenuItem, isLoad && Select_select["default"].modifiers.load, isSelected && Select_select["default"].modifiers.selected, isDisabled && Select_select["default"].modifiers.disabled, description && Select_select["default"].modifiers.description, isFavorite !== null && Select_select["default"].modifiers.link, className), onClick: (event) => {
                                if (!isDisabled) {
                                    onClick(event);
                                    onSelect(event, value, isPlaceholder);
                                    shouldResetOnSelect && onClose();
                                }
                            }, role: "option", "aria-selected": isSelected || null, ref: this.ref, onKeyDown: (event) => {
                                this.onKeyDown(event, 0);
                            }, type: "button" }),
                            description && (react.createElement(react.Fragment, null,
                                react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemMain) },
                                    itemDisplay,
                                    isSelected && (react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemIcon) },
                                        react.createElement(check_icon, { "aria-hidden": true })))),
                                react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemDescription) }, description))),
                            !description && (react.createElement(react.Fragment, null,
                                itemDisplay,
                                isSelected && (react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectMenuItemIcon) },
                                    react.createElement(check_icon, { "aria-hidden": true })))))),
                        isFavorite !== null && id && favoriteButton(onFavorite)))));
            }
            else if (variant === SelectVariant.checkbox && isLoad) {
                return (react.createElement("button", { className: (0,esm.css)(Select_select["default"].selectMenuItem, Select_select["default"].modifiers.load, isFocused && Select_select["default"].modifiers.focus, className), onKeyDown: (event) => {
                        this.onKeyDown(event, 0, undefined, true);
                    }, onClick: (event) => {
                        onViewMoreClick(event);
                        event.stopPropagation();
                    }, ref: this.ref }, children || (value && value.toString && value.toString())));
            }
            else if (variant === SelectVariant.checkbox && isLoading) {
                return (react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectListItem, isLoading && Select_select["default"].modifiers.loading, className) }, children));
            }
            else if (variant === SelectVariant.checkbox && !isNoResultsOption && !isLoading && !isLoad) {
                return (react.createElement("label", Object.assign({}, props, { className: (0,esm.css)(check["default"].check, Select_select["default"].selectMenuItem, isDisabled && Select_select["default"].modifiers.disabled, description && Select_select["default"].modifiers.description, className), onKeyDown: (event) => {
                        this.onKeyDown(event, 0, undefined, true);
                    } }),
                    react.createElement("input", { id: inputId || `${inputIdPrefix}-${value.toString()}`, className: (0,esm.css)(check["default"].checkInput), type: "checkbox", onChange: event => {
                            if (!isDisabled) {
                                onClick(event);
                                onSelect(event, value);
                            }
                        }, ref: this.ref, checked: isChecked || false, disabled: isDisabled }),
                    react.createElement("span", { className: (0,esm.css)(check["default"].checkLabel, isDisabled && Select_select["default"].modifiers.disabled) }, itemDisplay),
                    description && react.createElement("div", { className: (0,esm.css)(check["default"].checkDescription) }, description)));
            }
            else if (variant === SelectVariant.checkbox && isNoResultsOption && !isLoading && !isLoad) {
                return (react.createElement("div", null,
                    react.createElement(Component, Object.assign({}, props, { className: (0,esm.css)(Select_select["default"].selectMenuItem, isSelected && Select_select["default"].modifiers.selected, isDisabled && Select_select["default"].modifiers.disabled, className), role: "option", "aria-selected": isSelected || null, ref: this.ref, onKeyDown: (event) => {
                            this.onKeyDown(event, 0, undefined, true);
                        }, type: "button" }), itemDisplay)));
            }
        };
        return (react.createElement(SelectConsumer, null, ({ onSelect, onClose, variant, inputIdPrefix, onFavorite, shouldResetOnSelect }) => (react.createElement(react.Fragment, null, renderOption(onSelect, onClose, variant, inputIdPrefix, onFavorite, shouldResetOnSelect)))));
    }
}
SelectOption.displayName = 'SelectOption';
SelectOption.defaultProps = {
    className: '',
    value: '',
    index: 0,
    isDisabled: false,
    isPlaceholder: false,
    isSelected: false,
    isChecked: false,
    isNoResultsOption: false,
    component: 'button',
    onClick: () => { },
    sendRef: () => { },
    keyHandler: () => { },
    inputId: '',
    isFavorite: null,
    isLoad: false,
    isLoading: false,
    setViewMoreNextIndex: () => { },
    isLastOptionBeforeFooter: () => false
};
//# sourceMappingURL=SelectOption.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Select/SelectGroup.js





const SelectGroup = (_a) => {
    var { children = [], className = '', label = '', titleId = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "label", "titleId"]);
    return (react.createElement(SelectConsumer, null, ({ variant }) => (react.createElement("div", Object.assign({}, props, { className: (0,esm.css)(Select_select["default"].selectMenuGroup, className) }),
        react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectMenuGroupTitle), id: titleId, "aria-hidden": true }, label),
        variant === SelectVariant.checkbox ? children : react.createElement("ul", { role: "listbox" }, children)))));
};
SelectGroup.displayName = 'SelectGroup';
//# sourceMappingURL=SelectGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Select/SelectMenu.js









class SelectMenuWithRef extends react.Component {
    extendChildren(randomId) {
        const { children, hasInlineFilter, isGrouped } = this.props;
        const childrenArray = children;
        let index = hasInlineFilter ? 1 : 0;
        if (isGrouped) {
            return react.Children.map(childrenArray, (group) => {
                if (group.type === SelectGroup) {
                    return react.cloneElement(group, {
                        titleId: group.props.label && group.props.label.replace(/\W/g, '-'),
                        children: react.Children.map(group.props.children, (option) => this.cloneOption(option, index++, randomId))
                    });
                }
                else {
                    return this.cloneOption(group, index++, randomId);
                }
            });
        }
        return react.Children.map(childrenArray, (child) => this.cloneOption(child, index++, randomId));
    }
    cloneOption(child, index, randomId) {
        const { selected, sendRef, keyHandler } = this.props;
        const isSelected = this.checkForValue(child.props.value, selected);
        if (child.type === Divider) {
            return child;
        }
        return react.cloneElement(child, {
            inputId: `${randomId}-${index}`,
            isSelected,
            sendRef,
            keyHandler,
            index
        });
    }
    checkForValue(valueToCheck, options) {
        if (!options || !valueToCheck) {
            return false;
        }
        const isSelectOptionObject = typeof valueToCheck !== 'string' &&
            valueToCheck.toString &&
            valueToCheck.compareTo;
        if (Array.isArray(options)) {
            if (isSelectOptionObject) {
                return options.some(option => option.compareTo(valueToCheck));
            }
            else {
                return options.includes(valueToCheck);
            }
        }
        else {
            if (isSelectOptionObject) {
                return options.compareTo(valueToCheck);
            }
            else {
                return options === valueToCheck;
            }
        }
    }
    extendCheckboxChildren(children) {
        const { isGrouped, checked, sendRef, keyHandler, hasInlineFilter, isLastOptionBeforeFooter } = this.props;
        let index = hasInlineFilter ? 1 : 0;
        if (isGrouped) {
            return react.Children.map(children, (group) => {
                if (group.type === Divider) {
                    return group;
                }
                else if (group.type === SelectOption) {
                    return react.cloneElement(group, {
                        isChecked: this.checkForValue(group.props.value, checked),
                        sendRef,
                        keyHandler,
                        index: index++,
                        isLastOptionBeforeFooter
                    });
                }
                return react.cloneElement(group, {
                    titleId: group.props.label && group.props.label.replace(/\W/g, '-'),
                    children: group.props.children ? (react.createElement("fieldset", { "aria-labelledby": group.props.label && group.props.label.replace(/\W/g, '-'), className: (0,esm.css)(Select_select["default"].selectMenuFieldset) }, react.Children.map(group.props.children, (option) => option.type === Divider
                        ? option
                        : react.cloneElement(option, {
                            isChecked: this.checkForValue(option.props.value, checked),
                            sendRef,
                            keyHandler,
                            index: index++,
                            isLastOptionBeforeFooter
                        })))) : null
                });
            });
        }
        return react.Children.map(children, (child) => child.type === Divider
            ? child
            : react.cloneElement(child, {
                isChecked: this.checkForValue(child.props.value, checked),
                sendRef,
                keyHandler,
                index: index++,
                isLastOptionBeforeFooter
            }));
    }
    renderSelectMenu({ variant, inputIdPrefix }) {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { children, isCustomContent, className, isExpanded, openedOnEnter, selected, checked, isGrouped, position, sendRef, keyHandler, maxHeight, noResultsFoundText, createText, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledBy, hasInlineFilter, innerRef, footer, footerRef, isLastOptionBeforeFooter } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "isCustomContent", "className", "isExpanded", "openedOnEnter", "selected", "checked", "isGrouped", "position", "sendRef", "keyHandler", "maxHeight", "noResultsFoundText", "createText", 'aria-label', 'aria-labelledby', "hasInlineFilter", "innerRef", "footer", "footerRef", "isLastOptionBeforeFooter"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        let Component = 'div';
        const variantProps = Object.assign({ ref: innerRef, className: (0,esm.css)(!footer ? Select_select["default"].selectMenu : 'pf-c-select__menu-list', position === SelectPosition.right && Select_select["default"].modifiers.alignRight, className) }, (maxHeight && { style: { maxHeight, overflow: 'auto' } }));
        const extendedChildren = () => variant === SelectVariant.checkbox
            ? this.extendCheckboxChildren(children)
            : this.extendChildren(inputIdPrefix);
        if (isCustomContent) {
            variantProps.children = children;
        }
        else if (hasInlineFilter) {
            if (react.Children.count(children) === 0) {
                variantProps.children = react.createElement("fieldset", { className: (0,esm.css)(Select_select["default"].selectMenuFieldset) });
            }
            else {
                variantProps.children = (react.createElement("fieldset", { "aria-label": ariaLabel, "aria-labelledby": (!ariaLabel && ariaLabelledBy) || null, className: (0,esm.css)(Form_form["default"].formFieldset) },
                    children.shift(),
                    extendedChildren()));
            }
        }
        else {
            variantProps.children = extendedChildren();
            if (!isGrouped) {
                Component = 'ul';
                variantProps.role = 'listbox';
                variantProps['aria-label'] = ariaLabel;
                variantProps['aria-labelledby'] = (!ariaLabel && ariaLabelledBy) || null;
            }
        }
        return (react.createElement(react.Fragment, null,
            react.createElement(Component, Object.assign({}, variantProps, props)),
            footer && (react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectMenuFooter), ref: footerRef }, footer))));
    }
    render() {
        return react.createElement(SelectConsumer, null, context => this.renderSelectMenu(context));
    }
}
SelectMenuWithRef.displayName = 'SelectMenu';
SelectMenuWithRef.defaultProps = {
    className: '',
    isExpanded: false,
    isGrouped: false,
    openedOnEnter: false,
    selected: '',
    maxHeight: '',
    position: SelectPosition.left,
    sendRef: () => { },
    keyHandler: () => { },
    isCustomContent: false,
    hasInlineFilter: false,
    isLastOptionBeforeFooter: () => { }
};
const SelectMenu = react.forwardRef((props, ref) => (react.createElement(SelectMenuWithRef, Object.assign({ innerRef: ref }, props), props.children)));
//# sourceMappingURL=SelectMenu.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Select/SelectToggle.js









class SelectToggleBase extends react.Component {
    constructor(props) {
        super(props);
        this.onDocClick = (event) => {
            const { parentRef, menuRef, footerRef, isOpen, onToggle, onClose } = this.props;
            const clickedOnToggle = parentRef && parentRef.current && parentRef.current.contains(event.target);
            const clickedWithinMenu = menuRef && menuRef.current && menuRef.current.contains && menuRef.current.contains(event.target);
            const clickedWithinFooter = footerRef && footerRef.current && footerRef.current.contains && footerRef.current.contains(event.target);
            if (isOpen && !(clickedOnToggle || clickedWithinMenu || clickedWithinFooter)) {
                onToggle(false, event);
                onClose();
            }
        };
        this.handleGlobalKeys = (event) => {
            const { parentRef, menuRef, hasFooter, footerRef, isOpen, variant, onToggle, onClose, moveFocusToLastMenuItem } = this.props;
            const escFromToggle = parentRef && parentRef.current && parentRef.current.contains(event.target);
            const escFromWithinMenu = menuRef && menuRef.current && menuRef.current.contains && menuRef.current.contains(event.target);
            if (isOpen &&
                event.key === KeyTypes.Tab &&
                (variant === SelectVariant.typeahead || variant === SelectVariant.typeaheadMulti)) {
                this.props.handleTypeaheadKeys('tab', event.shiftKey);
                event.preventDefault();
                return;
            }
            if (isOpen && event.key === KeyTypes.Tab && hasFooter) {
                const tabbableItems = findTabbableElements(footerRef, SelectFooterTabbableItems);
                // If no tabbable item in footer close select
                if (tabbableItems.length <= 0) {
                    onToggle(false, event);
                    onClose();
                    this.toggle.current.focus();
                    return;
                }
                else {
                    // if current element is not in footer, tab to first tabbable element in footer, or close if shift clicked
                    const currentElementIndex = tabbableItems.findIndex((item) => item === document.activeElement);
                    if (currentElementIndex === -1) {
                        if (event.shiftKey) {
                            if (variant !== 'checkbox') {
                                // only close non checkbox variation on shift clicked
                                onToggle(false, event);
                                onClose();
                                this.toggle.current.focus();
                            }
                        }
                        else {
                            // tab to footer
                            tabbableItems[0].focus();
                            return;
                        }
                    }
                    // Current element is in footer.
                    if (event.shiftKey) {
                        // Move focus back to menu if current tab index is 0
                        if (currentElementIndex === 0) {
                            moveFocusToLastMenuItem();
                            event.preventDefault();
                        }
                        return;
                    }
                    // Tab to next element in footer or close if there are none
                    if (currentElementIndex + 1 < tabbableItems.length) {
                        tabbableItems[currentElementIndex + 1].focus();
                    }
                    else {
                        // no more footer items close menu
                        onToggle(false, event);
                        onClose();
                        this.toggle.current.focus();
                    }
                    event.preventDefault();
                    return;
                }
            }
            if (isOpen &&
                (event.key === KeyTypes.Escape || event.key === KeyTypes.Tab) &&
                (escFromToggle || escFromWithinMenu)) {
                onToggle(false, event);
                onClose();
                this.toggle.current.focus();
            }
        };
        this.onKeyDown = (event) => {
            const { isOpen, onToggle, variant, onClose, onEnter, handleTypeaheadKeys } = this.props;
            if (variant === SelectVariant.typeahead || variant === SelectVariant.typeaheadMulti) {
                if (event.key === KeyTypes.ArrowDown || event.key === KeyTypes.ArrowUp) {
                    handleTypeaheadKeys((event.key === KeyTypes.ArrowDown && 'down') || (event.key === KeyTypes.ArrowUp && 'up'));
                    event.preventDefault();
                }
                else if (event.key === KeyTypes.Enter) {
                    if (isOpen) {
                        handleTypeaheadKeys('enter');
                    }
                    else {
                        onToggle(!isOpen, event);
                    }
                }
            }
            if (variant === SelectVariant.typeahead ||
                variant === SelectVariant.typeaheadMulti ||
                (event.key === KeyTypes.Tab && !isOpen) ||
                (event.key !== KeyTypes.Enter && event.key !== KeyTypes.Space)) {
                return;
            }
            event.preventDefault();
            if ((event.key === KeyTypes.Tab || event.key === KeyTypes.Enter || event.key === KeyTypes.Space) && isOpen) {
                onToggle(!isOpen, event);
                onClose();
                this.toggle.current.focus();
            }
            else if ((event.key === KeyTypes.Enter || event.key === KeyTypes.Space) && !isOpen) {
                onToggle(!isOpen, event);
                onEnter();
            }
        };
        const { variant } = props;
        const isTypeahead = variant === SelectVariant.typeahead || variant === SelectVariant.typeaheadMulti;
        if (this.props.innerRef) {
            this.toggle = this.props.innerRef;
        }
        else {
            this.toggle = isTypeahead ? react.createRef() : react.createRef();
        }
    }
    componentDidMount() {
        document.addEventListener('click', this.onDocClick, { capture: true });
        document.addEventListener('touchstart', this.onDocClick);
        document.addEventListener('keydown', this.handleGlobalKeys);
    }
    componentWillUnmount() {
        document.removeEventListener('click', this.onDocClick);
        document.removeEventListener('touchstart', this.onDocClick);
        document.removeEventListener('keydown', this.handleGlobalKeys);
    }
    render() {
        /* eslint-disable @typescript-eslint/no-unused-vars */
        const _a = this.props, { className, children, isOpen, isActive, isPlain, isDisabled, hasPlaceholderStyle, variant, onToggle, onEnter, onClose, onBlur, onClickTypeaheadToggleButton, handleTypeaheadKeys, moveFocusToLastMenuItem, parentRef, menuRef, id, type, hasClearButton, 'aria-labelledby': ariaLabelledBy, 'aria-label': ariaLabel, hasFooter, footerRef, toggleIndicator, innerRef } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "isOpen", "isActive", "isPlain", "isDisabled", "hasPlaceholderStyle", "variant", "onToggle", "onEnter", "onClose", "onBlur", "onClickTypeaheadToggleButton", "handleTypeaheadKeys", "moveFocusToLastMenuItem", "parentRef", "menuRef", "id", "type", "hasClearButton", 'aria-labelledby', 'aria-label', "hasFooter", "footerRef", "toggleIndicator", "innerRef"]);
        /* eslint-enable @typescript-eslint/no-unused-vars */
        const isTypeahead = variant === SelectVariant.typeahead || variant === SelectVariant.typeaheadMulti || hasClearButton;
        const toggleProps = {
            id,
            'aria-labelledby': ariaLabelledBy,
            'aria-expanded': isOpen,
            'aria-haspopup': (variant !== SelectVariant.checkbox && 'listbox') || null
        };
        return (react.createElement(react.Fragment, null,
            !isTypeahead && (react.createElement("button", Object.assign({}, props, toggleProps, { ref: this.toggle, type: type, className: (0,esm.css)(Select_select["default"].selectToggle, hasPlaceholderStyle && Select_select["default"].modifiers.placeholder, isDisabled && Select_select["default"].modifiers.disabled, isPlain && Select_select["default"].modifiers.plain, isActive && Select_select["default"].modifiers.active, className), "aria-label": ariaLabel, onBlur: onBlur, 
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                onClick: event => {
                    onToggle(!isOpen, event);
                    if (isOpen) {
                        onClose();
                    }
                }, onKeyDown: this.onKeyDown, disabled: isDisabled }),
                children,
                react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleArrow) }, toggleIndicator !== null && toggleIndicator !== void 0 ? toggleIndicator : react.createElement(caret_down_icon, null)))),
            isTypeahead && (react.createElement("div", Object.assign({}, props, { ref: this.toggle, className: (0,esm.css)(Select_select["default"].selectToggle, hasPlaceholderStyle && Select_select["default"].modifiers.placeholder, isDisabled && Select_select["default"].modifiers.disabled, isPlain && Select_select["default"].modifiers.plain, isTypeahead && Select_select["default"].modifiers.typeahead, className), onBlur: onBlur, 
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                onClick: event => {
                    if (!isDisabled) {
                        onToggle(!isOpen, event);
                        if (isOpen) {
                            onClose();
                        }
                    }
                }, onKeyDown: this.onKeyDown }),
                children,
                react.createElement("button", Object.assign({}, toggleProps, { type: type, className: (0,esm.css)(Button_button["default"].button, Select_select["default"].selectToggleButton, Select_select["default"].modifiers.plain), "aria-label": ariaLabel, onClick: event => {
                        onToggle(!isOpen, event);
                        if (isOpen) {
                            onClose();
                        }
                        onClickTypeaheadToggleButton();
                    } }, ((variant === SelectVariant.typeahead || variant === SelectVariant.typeaheadMulti) && {
                    tabIndex: -1
                }), { disabled: isDisabled }), toggleIndicator !== null && toggleIndicator !== void 0 ? toggleIndicator : react.createElement(caret_down_icon, { className: (0,esm.css)(Select_select["default"].selectToggleArrow) }))))));
    }
}
SelectToggleBase.displayName = 'SelectToggle';
SelectToggleBase.defaultProps = {
    className: '',
    isOpen: false,
    isActive: false,
    isPlain: false,
    isDisabled: false,
    hasPlaceholderStyle: false,
    hasClearButton: false,
    hasFooter: false,
    variant: 'single',
    'aria-labelledby': '',
    'aria-label': '',
    type: 'button',
    onToggle: () => { },
    onEnter: () => { },
    onClose: () => { },
    onClickTypeaheadToggleButton: () => { }
};
const SelectToggle = react.forwardRef((props, ref) => (react.createElement(SelectToggleBase, Object.assign({ innerRef: ref }, props))));
//# sourceMappingURL=SelectToggle.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/ChipGroup/chip-group.js
var chip_group = __webpack_require__(75652);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Chip/chip.js
var chip = __webpack_require__(95210);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/GenerateId/GenerateId.js
/** This Component can be used to wrap a functional component in order to generate a random ID
 * Example of how to use this component
 *
 * const Component = ({id}: {id: string}) => (
 *  <GenerateId>{randomId => (
 *     <div id={id || randomId}>
 *       div with random ID
 *     </div>
 *   )}
 *  </GenerateId>
 *  );
 */

let GenerateId_currentId = 0;
class GenerateId extends react.Component {
    constructor() {
        super(...arguments);
        this.id = `${this.props.prefix}${GenerateId_currentId++}`;
    }
    render() {
        return this.props.children(this.id);
    }
}
GenerateId.displayName = 'GenerateId';
GenerateId.defaultProps = {
    prefix: 'pf-random-id-'
};
//# sourceMappingURL=GenerateId.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Chip/Chip.js









class Chip extends react.Component {
    constructor(props) {
        super(props);
        this.span = react.createRef();
        this.setChipStyle = () => ({
            '--pf-c-chip__text--MaxWidth': this.props.textMaxWidth
        });
        this.renderOverflowChip = () => {
            const _a = this.props, { children, className, onClick, ouiaId, textMaxWidth, style, component, 
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            tooltipPosition, 
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            isOverflowChip, 
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            closeBtnAriaLabel, 
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            isReadOnly } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "onClick", "ouiaId", "textMaxWidth", "style", "component", "tooltipPosition", "isOverflowChip", "closeBtnAriaLabel", "isReadOnly"]);
            const Component = component;
            return (react.createElement(Component, Object.assign({ onClick: onClick }, (textMaxWidth && Object.assign({ style: this.setChipStyle() }, style)), { className: (0,esm.css)(chip["default"].chip, chip["default"].modifiers.overflow, className) }, (component === 'button' ? { type: 'button' } : {}), getOUIAProps('OverflowChip', ouiaId !== undefined ? ouiaId : this.state.ouiaStateId), props),
                react.createElement("span", { className: (0,esm.css)(chip["default"].chipText) }, children)));
        };
        this.renderChip = (randomId) => {
            const { children, tooltipPosition } = this.props;
            if (this.state.isTooltipVisible) {
                return (react.createElement(Tooltip, { position: tooltipPosition, content: children }, this.renderInnerChip(randomId)));
            }
            return this.renderInnerChip(randomId);
        };
        this.state = {
            isTooltipVisible: false,
            ouiaStateId: getDefaultOUIAId(Chip.displayName)
        };
    }
    componentDidMount() {
        this.setState({
            isTooltipVisible: Boolean(this.span.current && this.span.current.offsetWidth < this.span.current.scrollWidth)
        });
    }
    renderInnerChip(id) {
        const _a = this.props, { children, className, onClick, closeBtnAriaLabel, isReadOnly, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        isOverflowChip, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        tooltipPosition, component, ouiaId } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "onClick", "closeBtnAriaLabel", "isReadOnly", "isOverflowChip", "tooltipPosition", "component", "ouiaId"]);
        const Component = component;
        return (react.createElement(Component, Object.assign({}, (this.props.textMaxWidth && {
            style: this.setChipStyle()
        }), { className: (0,esm.css)(chip["default"].chip, className) }, (this.state.isTooltipVisible && { tabIndex: 0 }), getOUIAProps(Chip.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId), props),
            react.createElement("span", { ref: this.span, className: (0,esm.css)(chip["default"].chipText), id: id }, children),
            !isReadOnly && (react.createElement(Button, { onClick: onClick, variant: "plain", "aria-label": closeBtnAriaLabel, id: `remove_${id}`, "aria-labelledby": `remove_${id} ${id}`, ouiaId: ouiaId || closeBtnAriaLabel },
                react.createElement(times_icon, { "aria-hidden": "true" })))));
    }
    render() {
        const { isOverflowChip } = this.props;
        return (react.createElement(GenerateId, null, randomId => (isOverflowChip ? this.renderOverflowChip() : this.renderChip(this.props.id || randomId))));
    }
}
Chip.displayName = 'Chip';
Chip.defaultProps = {
    closeBtnAriaLabel: 'close',
    className: '',
    isOverflowChip: false,
    isReadOnly: false,
    tooltipPosition: 'top',
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (_e) => undefined,
    component: 'div'
};
//# sourceMappingURL=Chip.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ChipGroup/ChipGroup.js











class ChipGroup extends react.Component {
    constructor(props) {
        super(props);
        this.headingRef = react.createRef();
        this.toggleCollapse = () => {
            this.setState(prevState => ({
                isOpen: !prevState.isOpen,
                isTooltipVisible: Boolean(this.headingRef.current && this.headingRef.current.offsetWidth < this.headingRef.current.scrollWidth)
            }));
        };
        this.state = {
            isOpen: this.props.defaultIsOpen,
            isTooltipVisible: false
        };
    }
    componentDidMount() {
        this.setState({
            isTooltipVisible: Boolean(this.headingRef.current && this.headingRef.current.offsetWidth < this.headingRef.current.scrollWidth)
        });
    }
    renderLabel(id) {
        const { categoryName, tooltipPosition } = this.props;
        const { isTooltipVisible } = this.state;
        return isTooltipVisible ? (react.createElement(Tooltip, { position: tooltipPosition, content: categoryName },
            react.createElement("span", { tabIndex: 0, ref: this.headingRef, className: (0,esm.css)(chip_group["default"].chipGroupLabel) },
                react.createElement("span", { id: id }, categoryName)))) : (react.createElement("span", { ref: this.headingRef, className: (0,esm.css)(chip_group["default"].chipGroupLabel), id: id }, categoryName));
    }
    render() {
        const _a = this.props, { categoryName, children, className, isClosable, closeBtnAriaLabel, 'aria-label': ariaLabel, onClick, onOverflowChipClick, numChips, expandedText, collapsedText, ouiaId, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        defaultIsOpen, tooltipPosition } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        rest = (0,tslib_es6.__rest)(_a, ["categoryName", "children", "className", "isClosable", "closeBtnAriaLabel", 'aria-label', "onClick", "onOverflowChipClick", "numChips", "expandedText", "collapsedText", "ouiaId", "defaultIsOpen", "tooltipPosition"]);
        const { isOpen } = this.state;
        const numChildren = react.Children.count(children);
        const collapsedTextResult = fillTemplate(collapsedText, {
            remaining: react.Children.count(children) - numChips
        });
        const renderChipGroup = (id) => {
            const chipArray = !isOpen
                ? react.Children.toArray(children).slice(0, numChips)
                : react.Children.toArray(children);
            return (react.createElement("div", Object.assign({ className: (0,esm.css)(chip_group["default"].chipGroup, className, categoryName && chip_group["default"].modifiers.category), role: "group" }, (categoryName && { 'aria-labelledby': id }), (!categoryName && { 'aria-label': ariaLabel }), getOUIAProps(ChipGroup.displayName, ouiaId)),
                react.createElement("div", { className: (0,esm.css)(chip_group["default"].chipGroupMain) },
                    categoryName && this.renderLabel(id),
                    react.createElement("ul", Object.assign({ className: (0,esm.css)(chip_group["default"].chipGroupList) }, (categoryName && { 'aria-labelledby': id }), (!categoryName && { 'aria-label': ariaLabel }), { role: "list" }, rest),
                        chipArray.map((child, i) => (react.createElement("li", { className: (0,esm.css)(chip_group["default"].chipGroupListItem), key: i }, child))),
                        numChildren > numChips && (react.createElement("li", { className: (0,esm.css)(chip_group["default"].chipGroupListItem) },
                            react.createElement(Chip, { isOverflowChip: true, onClick: event => {
                                    this.toggleCollapse();
                                    onOverflowChipClick(event);
                                }, component: "button" }, isOpen ? expandedText : collapsedTextResult))))),
                isClosable && (react.createElement("div", { className: (0,esm.css)(chip_group["default"].chipGroupClose) },
                    react.createElement(Button, { variant: "plain", "aria-label": closeBtnAriaLabel, onClick: onClick, id: `remove_group_${id}`, "aria-labelledby": `remove_group_${id} ${id}`, ouiaId: ouiaId || closeBtnAriaLabel },
                        react.createElement(times_circle_icon, { "aria-hidden": "true" }))))));
        };
        return numChildren === 0 ? null : react.createElement(GenerateId, null, randomId => renderChipGroup(this.props.id || randomId));
    }
}
ChipGroup.displayName = 'ChipGroup';
ChipGroup.defaultProps = {
    expandedText: 'Show Less',
    collapsedText: '${remaining} more',
    categoryName: '',
    defaultIsOpen: false,
    numChips: 3,
    isClosable: false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (_e) => undefined,
    onOverflowChipClick: (_e) => undefined,
    closeBtnAriaLabel: 'Close chip group',
    tooltipPosition: 'top',
    'aria-label': 'Chip group category'
};
//# sourceMappingURL=ChipGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Select/Select.js


























// seed for the aria-labelledby ID
let Select_currentId = 0;
class Select extends react.Component {
    constructor() {
        super(...arguments);
        this.parentRef = react.createRef();
        this.menuComponentRef = react.createRef();
        this.filterRef = react.createRef();
        this.clearRef = react.createRef();
        this.inputRef = react.createRef();
        this.refCollection = [[]];
        this.optionContainerRefCollection = [];
        this.footerRef = react.createRef();
        this.state = {
            focusFirstOption: false,
            typeaheadInputValue: null,
            typeaheadFilteredChildren: react.Children.toArray(this.props.children),
            favoritesGroup: [],
            typeaheadCurrIndex: -1,
            typeaheadStoredIndex: -1,
            creatableValue: '',
            tabbedIntoFavoritesMenu: false,
            ouiaStateId: getDefaultOUIAId(Select.displayName, this.props.variant),
            viewMoreNextIndex: -1
        };
        this.getTypeaheadActiveChild = (typeaheadCurrIndex) => this.refCollection[typeaheadCurrIndex] ? this.refCollection[typeaheadCurrIndex][0] : null;
        this.componentDidUpdate = (prevProps, prevState) => {
            if (this.props.hasInlineFilter) {
                this.refCollection[0][0] = this.filterRef.current;
            }
            // Move focus to top of the menu if state.focusFirstOption was updated to true and the menu does not have custom content
            if (!prevState.focusFirstOption && this.state.focusFirstOption && !this.props.customContent) {
                const firstRef = this.refCollection.find(ref => 
                // If a select option is disabled then ref[0] will be undefined, so we want to return
                // the first ref that both a) is not null and b) is not disabled.
                ref !== null && ref[0]);
                if (firstRef && firstRef[0]) {
                    firstRef[0].focus();
                }
            }
            else if (
            // if viewMoreNextIndex is not -1, view more was clicked, set focus on first newly loaded item
            this.state.viewMoreNextIndex !== -1 &&
                this.refCollection.length > this.state.viewMoreNextIndex &&
                this.props.loadingVariant !== 'spinner' &&
                this.refCollection[this.state.viewMoreNextIndex][0] &&
                this.props.variant !== 'typeahead' && // do not hard focus newly added items for typeahead variants
                this.props.variant !== 'typeaheadmulti') {
                this.refCollection[this.state.viewMoreNextIndex][0].focus();
                this.setState({ viewMoreNextIndex: -1 });
            }
            const checkUpdatedChildren = (prevChildren, currChildren) => Array.from(prevChildren).some((prevChild, index) => {
                const prevChildProps = prevChild.props;
                const currChild = currChildren[index];
                const { props: currChildProps } = currChild;
                if (prevChildProps && currChildProps) {
                    return (prevChildProps.value !== currChildProps.value ||
                        prevChildProps.label !== currChildProps.label ||
                        prevChildProps.isDisabled !== currChildProps.isDisabled ||
                        prevChildProps.isPlaceholder !== currChildProps.isPlaceholder);
                }
                else {
                    return prevChild !== currChild;
                }
            });
            const hasUpdatedChildren = prevProps.children.length !== this.props.children.length ||
                checkUpdatedChildren(prevProps.children, this.props.children) ||
                (this.props.isGrouped &&
                    Array.from(prevProps.children).some((prevChild, index) => prevChild.type === SelectGroup &&
                        prevChild.props.children &&
                        this.props.children[index].props.children &&
                        (prevChild.props.children.length !== this.props.children[index].props.children.length ||
                            checkUpdatedChildren(prevChild.props.children, this.props.children[index].props.children))));
            if (hasUpdatedChildren) {
                this.updateTypeAheadFilteredChildren(prevState.typeaheadInputValue || '', null);
            }
            // for menus with favorites,
            // if the number of favorites or typeahead filtered children has changed, the generated
            // list of favorites needs to be updated
            if (this.props.onFavorite &&
                (this.props.favorites.length !== prevProps.favorites.length ||
                    this.state.typeaheadFilteredChildren !== prevState.typeaheadFilteredChildren)) {
                const tempRenderableChildren = this.props.variant === 'typeahead' || this.props.variant === 'typeaheadmulti'
                    ? this.state.typeaheadFilteredChildren
                    : this.props.children;
                const renderableFavorites = createRenderableFavorites(tempRenderableChildren, this.props.isGrouped, this.props.favorites);
                const favoritesGroup = renderableFavorites.length
                    ? [
                        react.createElement(SelectGroup, { key: "favorites", label: this.props.favoritesLabel }, renderableFavorites),
                        react.createElement(Divider, { key: "favorites-group-divider" })
                    ]
                    : [];
                this.setState({ favoritesGroup });
            }
        };
        this.onEnter = () => {
            this.setState({ focusFirstOption: true });
        };
        this.onToggle = (isExpanded, e) => {
            const { isInputValuePersisted, onSelect, onToggle, hasInlineFilter } = this.props;
            if (!isExpanded && isInputValuePersisted && onSelect) {
                onSelect(undefined, this.inputRef.current ? this.inputRef.current.value : '');
            }
            if (isExpanded && hasInlineFilter) {
                this.setState({
                    focusFirstOption: true
                });
            }
            onToggle(isExpanded, e);
        };
        this.onClose = () => {
            const { isInputFilterPersisted } = this.props;
            this.setState(Object.assign(Object.assign({ focusFirstOption: false, typeaheadInputValue: null }, (!isInputFilterPersisted && {
                typeaheadFilteredChildren: react.Children.toArray(this.props.children)
            })), { typeaheadCurrIndex: -1, tabbedIntoFavoritesMenu: false, viewMoreNextIndex: -1 }));
        };
        this.onChange = (e) => {
            if (e.target.value.toString() !== '' && !this.props.isOpen) {
                this.onToggle(true, e);
            }
            if (this.props.onTypeaheadInputChanged) {
                this.props.onTypeaheadInputChanged(e.target.value.toString());
            }
            this.setState({
                typeaheadCurrIndex: -1,
                typeaheadInputValue: e.target.value,
                creatableValue: e.target.value
            });
            this.updateTypeAheadFilteredChildren(e.target.value.toString(), e);
            this.refCollection = [[]];
        };
        this.updateTypeAheadFilteredChildren = (typeaheadInputValue, e) => {
            let typeaheadFilteredChildren;
            const { onFilter, isCreatable, isCreateOptionOnTop, onCreateOption, createText, noResultsFoundText, children, isGrouped, isCreateSelectOptionObject, loadingVariant } = this.props;
            if (onFilter) {
                /* The updateTypeAheadFilteredChildren callback is not only called on input changes but also when the children change.
                 * In this case the e is null but we can get the typeaheadInputValue from the state.
                 */
                typeaheadFilteredChildren = onFilter(e, e ? e.target.value : typeaheadInputValue) || children;
            }
            else {
                let input;
                try {
                    input = new RegExp(typeaheadInputValue.toString(), 'i');
                }
                catch (err) {
                    input = new RegExp(typeaheadInputValue.toString().replace(/[.*+?^${}()|[\]\\]/g, '\\$&'), 'i');
                }
                const childrenArray = react.Children.toArray(children);
                if (isGrouped) {
                    const childFilter = (child) => child.props.value &&
                        child.props.value.toString &&
                        this.getDisplay(child.props.value.toString(), 'text').search(input) === 0;
                    typeaheadFilteredChildren =
                        typeaheadInputValue.toString() !== ''
                            ? react.Children.map(children, group => {
                                if (react.isValidElement(group) &&
                                    group.type === SelectGroup) {
                                    const filteredGroupChildren = react.Children.toArray(group.props.children).filter(childFilter);
                                    if (filteredGroupChildren.length > 0) {
                                        return react.cloneElement(group, {
                                            titleId: group.props.label && group.props.label.replace(/\W/g, '-'),
                                            children: filteredGroupChildren
                                        });
                                    }
                                }
                                else {
                                    return react.Children.toArray(group).filter(childFilter);
                                }
                            })
                            : childrenArray;
                }
                else {
                    typeaheadFilteredChildren =
                        typeaheadInputValue.toString() !== ''
                            ? childrenArray.filter(child => {
                                const valueToCheck = child.props.value;
                                // Dividers don't have value and should not be filtered
                                if (!valueToCheck) {
                                    return true;
                                }
                                const isSelectOptionObject = typeof valueToCheck !== 'string' &&
                                    valueToCheck.toString &&
                                    valueToCheck.compareTo;
                                // View more option should be returned as not a match
                                if (loadingVariant !== 'spinner' && (loadingVariant === null || loadingVariant === void 0 ? void 0 : loadingVariant.text) === valueToCheck) {
                                    return true;
                                }
                                // spinner should be returned as not a match
                                if (loadingVariant === 'spinner' && valueToCheck === 'loading') {
                                    return true;
                                }
                                if (isSelectOptionObject) {
                                    return valueToCheck.compareTo(typeaheadInputValue);
                                }
                                else {
                                    return this.getDisplay(child.props.value.toString(), 'text').search(input) === 0;
                                }
                            })
                            : childrenArray;
                }
            }
            if (!typeaheadFilteredChildren) {
                typeaheadFilteredChildren = [];
            }
            if (typeaheadFilteredChildren.length === 0) {
                !isCreatable &&
                    typeaheadFilteredChildren.push(react.createElement(SelectOption, { isDisabled: true, key: "no-results", value: noResultsFoundText, isNoResultsOption: true }));
            }
            if (isCreatable && typeaheadInputValue !== '') {
                const newValue = typeaheadInputValue;
                if (!typeaheadFilteredChildren.find((i) => i.props.value && i.props.value.toString().toLowerCase() === newValue.toString().toLowerCase())) {
                    const newOptionValue = isCreateSelectOptionObject
                        ? {
                            toString: () => newValue,
                            compareTo: value => this.toString()
                                .toLowerCase()
                                .includes(value.toString().toLowerCase())
                        }
                        : newValue;
                    const createSelectOption = (react.createElement(SelectOption, { key: `create ${newValue}`, value: newOptionValue, onClick: () => onCreateOption && onCreateOption(newValue) },
                        createText,
                        " \"",
                        newValue,
                        "\""));
                    if (isCreateOptionOnTop) {
                        typeaheadFilteredChildren.unshift(createSelectOption);
                    }
                    else {
                        typeaheadFilteredChildren.push(createSelectOption);
                    }
                }
            }
            this.setState({
                typeaheadFilteredChildren
            });
        };
        this.onClick = (e) => {
            if (!this.props.isOpen) {
                this.onToggle(true, e);
            }
        };
        this.clearSelection = (_e) => {
            this.setState({
                typeaheadInputValue: null,
                typeaheadFilteredChildren: react.Children.toArray(this.props.children),
                typeaheadCurrIndex: -1
            });
        };
        this.sendRef = (optionRef, favoriteRef, optionContainerRef, index) => {
            this.refCollection[index] = [optionRef, favoriteRef];
            this.optionContainerRefCollection[index] = optionContainerRef;
        };
        this.handleMenuKeys = (index, innerIndex, position) => {
            keyHandler(index, innerIndex, position, this.refCollection, this.refCollection);
            if (this.props.variant === SelectVariant.typeahead || this.props.variant === SelectVariant.typeaheadMulti) {
                if (position !== 'tab') {
                    this.handleTypeaheadKeys(position);
                }
            }
        };
        this.moveFocus = (nextIndex, updateCurrentIndex = true) => {
            const { isCreatable, createText } = this.props;
            const hasDescriptionElm = Boolean(this.refCollection[nextIndex][0] && this.refCollection[nextIndex][0].classList.contains('pf-m-description'));
            const isLoad = Boolean(this.refCollection[nextIndex][0] && this.refCollection[nextIndex][0].classList.contains('pf-m-load'));
            const optionTextElm = hasDescriptionElm
                ? this.refCollection[nextIndex][0].firstElementChild
                : this.refCollection[nextIndex][0];
            let typeaheadInputValue = '';
            if (isCreatable && optionTextElm.textContent.includes(createText)) {
                typeaheadInputValue = this.state.creatableValue;
            }
            else if (optionTextElm && !isLoad) {
                // !isLoad prevents the view more button text from appearing the typeahead input
                typeaheadInputValue = optionTextElm.textContent;
            }
            this.setState(prevState => ({
                typeaheadCurrIndex: updateCurrentIndex ? nextIndex : prevState.typeaheadCurrIndex,
                typeaheadStoredIndex: nextIndex,
                typeaheadInputValue
            }));
        };
        this.switchFocusToFavoriteMenu = () => {
            const { typeaheadCurrIndex, typeaheadStoredIndex } = this.state;
            let indexForFocus = 0;
            if (typeaheadCurrIndex !== -1) {
                indexForFocus = typeaheadCurrIndex;
            }
            else if (typeaheadStoredIndex !== -1) {
                indexForFocus = typeaheadStoredIndex;
            }
            if (this.refCollection[indexForFocus] !== null && this.refCollection[indexForFocus][0] !== null) {
                this.refCollection[indexForFocus][0].focus();
            }
            else {
                this.clearRef.current.focus();
            }
            this.setState({
                tabbedIntoFavoritesMenu: true,
                typeaheadCurrIndex: -1
            });
        };
        this.moveFocusToLastMenuItem = () => {
            const refCollectionLen = this.refCollection.length;
            if (refCollectionLen > 0 &&
                this.refCollection[refCollectionLen - 1] !== null &&
                this.refCollection[refCollectionLen - 1][0] !== null) {
                this.refCollection[refCollectionLen - 1][0].focus();
            }
        };
        this.handleTypeaheadKeys = (position, shiftKey = false) => {
            const { isOpen, onFavorite, isCreatable } = this.props;
            const { typeaheadCurrIndex, tabbedIntoFavoritesMenu } = this.state;
            const typeaheadActiveChild = this.getTypeaheadActiveChild(typeaheadCurrIndex);
            if (isOpen) {
                if (position === 'enter') {
                    if ((typeaheadCurrIndex !== -1 || (isCreatable && this.refCollection.length === 1)) && // do not allow selection without moving to an initial option unless it is a single create option
                        (typeaheadActiveChild || (this.refCollection[0] && this.refCollection[0][0]))) {
                        if (typeaheadActiveChild) {
                            if (!typeaheadActiveChild.classList.contains('pf-m-load')) {
                                const hasDescriptionElm = typeaheadActiveChild.childElementCount > 1;
                                const typeaheadActiveChildText = hasDescriptionElm
                                    ? typeaheadActiveChild.firstChild.textContent
                                    : typeaheadActiveChild.textContent;
                                this.setState({
                                    typeaheadInputValue: typeaheadActiveChildText
                                });
                            }
                        }
                        else if (this.refCollection[0] && this.refCollection[0][0]) {
                            this.setState({
                                typeaheadInputValue: this.refCollection[0][0].textContent
                            });
                        }
                        if (typeaheadActiveChild) {
                            typeaheadActiveChild.click();
                        }
                        else {
                            this.refCollection[0][0].click();
                        }
                    }
                }
                else if (position === 'tab') {
                    if (onFavorite) {
                        // if the input has focus, tab to the first item or the last item that was previously focused.
                        if (this.inputRef.current === document.activeElement) {
                            // If shift is also clicked and there is a footer, tab to the last item in tabbable footer
                            if (this.props.footer && shiftKey) {
                                const tabbableItems = findTabbableElements(this.footerRef, SelectFooterTabbableItems);
                                if (tabbableItems.length > 0) {
                                    if (tabbableItems[tabbableItems.length - 1]) {
                                        tabbableItems[tabbableItems.length - 1].focus();
                                    }
                                }
                            }
                            else {
                                this.switchFocusToFavoriteMenu();
                            }
                        }
                        else {
                            // focus is on menu or footer
                            if (this.props.footer) {
                                let tabbedIntoMenu = false;
                                const tabbableItems = findTabbableElements(this.footerRef, SelectFooterTabbableItems);
                                if (tabbableItems.length > 0) {
                                    // if current element is not in footer, tab to first tabbable element in footer,
                                    // if shift was clicked, tab to input since focus is on menu
                                    const currentElementIndex = tabbableItems.findIndex((item) => item === document.activeElement);
                                    if (currentElementIndex === -1) {
                                        if (shiftKey) {
                                            // currently in menu, shift back to input
                                            this.inputRef.current.focus();
                                        }
                                        else {
                                            // currently in menu, tab to first tabbable item in footer
                                            tabbableItems[0].focus();
                                        }
                                    }
                                    else {
                                        // already in footer
                                        if (shiftKey) {
                                            // shift to previous item
                                            if (currentElementIndex === 0) {
                                                // on first footer item, shift back to menu
                                                this.switchFocusToFavoriteMenu();
                                                tabbedIntoMenu = true;
                                            }
                                            else {
                                                // shift to previous footer item
                                                tabbableItems[currentElementIndex - 1].focus();
                                            }
                                        }
                                        else {
                                            // tab to next tabbable item in footer or to input.
                                            if (tabbableItems[currentElementIndex + 1]) {
                                                tabbableItems[currentElementIndex + 1].focus();
                                            }
                                            else {
                                                this.inputRef.current.focus();
                                            }
                                        }
                                    }
                                }
                                else {
                                    // no tabbable items in footer, tab to input
                                    this.inputRef.current.focus();
                                    tabbedIntoMenu = false;
                                }
                                this.setState({ tabbedIntoFavoritesMenu: tabbedIntoMenu });
                            }
                            else {
                                this.inputRef.current.focus();
                                this.setState({ tabbedIntoFavoritesMenu: false });
                            }
                        }
                    }
                    else {
                        // Close if there is no footer
                        if (!this.props.footer) {
                            this.onToggle(false, null);
                            this.onClose();
                        }
                        else {
                            // has footer
                            const tabbableItems = findTabbableElements(this.footerRef, SelectFooterTabbableItems);
                            const currentElementIndex = tabbableItems.findIndex((item) => item === document.activeElement);
                            if (this.inputRef.current === document.activeElement) {
                                if (shiftKey) {
                                    // close toggle if shift key and tab on input
                                    this.onToggle(false, null);
                                    this.onClose();
                                }
                                else {
                                    // tab to first tabbable item in footer
                                    if (tabbableItems[0]) {
                                        tabbableItems[0].focus();
                                    }
                                    else {
                                        this.onToggle(false, null);
                                        this.onClose();
                                    }
                                }
                            }
                            else {
                                // focus is in footer
                                if (shiftKey) {
                                    if (currentElementIndex === 0) {
                                        // shift tab back to input
                                        this.inputRef.current.focus();
                                    }
                                    else {
                                        // shift to previous footer item
                                        tabbableItems[currentElementIndex - 1].focus();
                                    }
                                }
                                else {
                                    // tab to next footer item or close tab if last item
                                    if (tabbableItems[currentElementIndex + 1]) {
                                        tabbableItems[currentElementIndex + 1].focus();
                                    }
                                    else {
                                        // no next item, close toggle
                                        this.onToggle(false, null);
                                        this.inputRef.current.focus();
                                        this.onClose();
                                    }
                                }
                            }
                        }
                    }
                }
                else if (!tabbedIntoFavoritesMenu) {
                    if (this.refCollection[0][0] === null) {
                        return;
                    }
                    let nextIndex;
                    if (typeaheadCurrIndex === -1 && position === 'down') {
                        nextIndex = 0;
                    }
                    else if (typeaheadCurrIndex === -1 && position === 'up') {
                        nextIndex = this.refCollection.length - 1;
                    }
                    else if (position !== 'left' && position !== 'right') {
                        nextIndex = getNextIndex(typeaheadCurrIndex, position, this.refCollection);
                    }
                    else {
                        nextIndex = typeaheadCurrIndex;
                    }
                    if (this.refCollection[nextIndex] === null) {
                        return;
                    }
                    this.moveFocus(nextIndex);
                }
                else {
                    const nextIndex = this.refCollection.findIndex(ref => ref !== undefined && (ref[0] === document.activeElement || ref[1] === document.activeElement));
                    this.moveFocus(nextIndex);
                }
            }
        };
        this.onClickTypeaheadToggleButton = () => {
            if (this.inputRef && this.inputRef.current) {
                this.inputRef.current.focus();
            }
        };
        this.getDisplay = (value, type = 'node') => {
            if (!value) {
                return;
            }
            const item = this.props.isGrouped
                ? react.Children.toArray(this.props.children)
                    .reduce((acc, curr) => [...acc, ...react.Children.toArray(curr.props.children)], [])
                    .find(child => child.props.value.toString() === value.toString())
                : react.Children.toArray(this.props.children).find(child => child.props.value &&
                    child.props.value.toString() === value.toString());
            if (item) {
                if (item && item.props.children) {
                    if (type === 'node') {
                        return item.props.children;
                    }
                    return this.findText(item);
                }
                return item.props.value.toString();
            }
            return value.toString();
        };
        this.findText = (item) => {
            if (typeof item === 'string') {
                return item;
            }
            else if (!react.isValidElement(item)) {
                return '';
            }
            else {
                const multi = [];
                react.Children.toArray(item.props.children).forEach(child => multi.push(this.findText(child)));
                return multi.join('');
            }
        };
        this.generateSelectedBadge = () => {
            const { customBadgeText, selections } = this.props;
            if (customBadgeText !== null) {
                return customBadgeText;
            }
            if (Array.isArray(selections) && selections.length > 0) {
                return selections.length;
            }
            return null;
        };
        this.setVieMoreNextIndex = () => {
            this.setState({ viewMoreNextIndex: this.refCollection.length - 1 });
        };
        this.isLastOptionBeforeFooter = (index) => this.props.footer && index === this.refCollection.length - 1 ? true : false;
    }
    extendTypeaheadChildren(typeaheadCurrIndex, favoritesGroup) {
        const { isGrouped, onFavorite, createText } = this.props;
        const typeaheadChildren = favoritesGroup
            ? favoritesGroup.concat(this.state.typeaheadFilteredChildren)
            : this.state.typeaheadFilteredChildren;
        const activeElement = this.optionContainerRefCollection[typeaheadCurrIndex];
        let typeaheadActiveChild = this.getTypeaheadActiveChild(typeaheadCurrIndex);
        if (typeaheadActiveChild && typeaheadActiveChild.classList.contains('pf-m-description')) {
            typeaheadActiveChild = typeaheadActiveChild.firstElementChild;
        }
        this.refCollection = [[]];
        this.optionContainerRefCollection = [];
        if (isGrouped) {
            return react.Children.map(typeaheadChildren, (group) => {
                if (group.type === Divider) {
                    return group;
                }
                else if (group.type === SelectGroup && onFavorite) {
                    return react.cloneElement(group, {
                        titleId: group.props.label && group.props.label.replace(/\W/g, '-'),
                        children: react.Children.map(group.props.children, (child) => child.type === Divider
                            ? child
                            : react.cloneElement(child, {
                                isFocused: activeElement &&
                                    (activeElement.id === child.props.id ||
                                        (this.props.isCreatable &&
                                            typeaheadActiveChild.textContent ===
                                                `${createText} "${group.props.value}"`))
                            }))
                    });
                }
                else if (group.type === SelectGroup) {
                    return react.cloneElement(group, {
                        titleId: group.props.label && group.props.label.replace(/\W/g, '-'),
                        children: react.Children.map(group.props.children, (child) => child.type === Divider
                            ? child
                            : react.cloneElement(child, {
                                isFocused: typeaheadActiveChild &&
                                    (typeaheadActiveChild.textContent === child.props.value.toString() ||
                                        (this.props.isCreatable &&
                                            typeaheadActiveChild.textContent ===
                                                `${createText} "${child.props.value}"`))
                            }))
                    });
                }
                else {
                    // group has been filtered down to SelectOption
                    return react.cloneElement(group, {
                        isFocused: typeaheadActiveChild &&
                            (typeaheadActiveChild.textContent === group.props.value.toString() ||
                                (this.props.isCreatable && typeaheadActiveChild.textContent === `${createText} "${group.props.value}"`))
                    });
                }
            });
        }
        return typeaheadChildren.map((child, index) => {
            const childElement = child;
            return childElement.type.displayName === 'Divider'
                ? child
                : react.cloneElement(child, {
                    isFocused: typeaheadActiveChild
                        ? typeaheadActiveChild.textContent === child.props.value.toString() ||
                            (this.props.isCreatable &&
                                typeaheadActiveChild.textContent === `${createText} "${child.props.value}"`)
                        : index === typeaheadCurrIndex // fallback for view more + typeahead use cases, when the new expanded list is loaded and refCollection hasn't be updated yet
                });
        });
    }
    render() {
        const _a = this.props, { children, chipGroupProps, chipGroupComponent, className, customContent, variant, direction, onSelect, onClear, onBlur, toggleId, toggleRef, isOpen, isGrouped, isPlain, isDisabled, hasPlaceholderStyle, validated, selections: selectionsProp, typeAheadAriaLabel, typeAheadAriaDescribedby, clearSelectionsAriaLabel, toggleAriaLabel, removeSelectionAriaLabel, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledBy, 'aria-describedby': ariaDescribedby, 'aria-invalid': ariaInvalid, placeholderText, width, maxHeight, toggleIcon, toggleIndicator, ouiaId, ouiaSafe, hasInlineFilter, isCheckboxSelectionBadgeHidden, inlineFilterPlaceholderText, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onFilter, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onTypeaheadInputChanged, onCreateOption, isCreatable, onToggle, createText, noResultsFoundText, customBadgeText, inputIdPrefix, inputAutoComplete, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        isInputValuePersisted, isInputFilterPersisted, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        menuAppendTo, favorites, onFavorite, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        favoritesLabel, footer, loadingVariant, isCreateSelectOptionObject, isCreateOptionOnTop, shouldResetOnSelect, isFlipEnabled, removeFindDomNode, zIndex } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "chipGroupProps", "chipGroupComponent", "className", "customContent", "variant", "direction", "onSelect", "onClear", "onBlur", "toggleId", "toggleRef", "isOpen", "isGrouped", "isPlain", "isDisabled", "hasPlaceholderStyle", "validated", "selections", "typeAheadAriaLabel", "typeAheadAriaDescribedby", "clearSelectionsAriaLabel", "toggleAriaLabel", "removeSelectionAriaLabel", 'aria-label', 'aria-labelledby', 'aria-describedby', 'aria-invalid', "placeholderText", "width", "maxHeight", "toggleIcon", "toggleIndicator", "ouiaId", "ouiaSafe", "hasInlineFilter", "isCheckboxSelectionBadgeHidden", "inlineFilterPlaceholderText", "onFilter", "onTypeaheadInputChanged", "onCreateOption", "isCreatable", "onToggle", "createText", "noResultsFoundText", "customBadgeText", "inputIdPrefix", "inputAutoComplete", "isInputValuePersisted", "isInputFilterPersisted", "menuAppendTo", "favorites", "onFavorite", "favoritesLabel", "footer", "loadingVariant", "isCreateSelectOptionObject", "isCreateOptionOnTop", "shouldResetOnSelect", "isFlipEnabled", "removeFindDomNode", "zIndex"]);
        const { focusFirstOption: openedOnEnter, typeaheadCurrIndex, typeaheadInputValue, typeaheadFilteredChildren, favoritesGroup } = this.state;
        const selectToggleId = toggleId || `pf-select-toggle-id-${Select_currentId++}`;
        const selections = Array.isArray(selectionsProp) ? selectionsProp : [selectionsProp];
        // Find out if the selected option is a placeholder
        const selectedOption = react.Children.toArray(children).find((option) => option.props.value === selections[0]);
        const isSelectedPlaceholder = selectedOption && selectedOption.props.isPlaceholder;
        const hasAnySelections = Boolean(selections[0] && selections[0] !== '');
        const typeaheadActiveChild = this.getTypeaheadActiveChild(typeaheadCurrIndex);
        let childPlaceholderText = null;
        // If onFavorites is set,  add isFavorite prop to children and add a Favorites group to the SelectMenu
        let renderableItems = [];
        if (onFavorite) {
            // if variant is type-ahead call the extendTypeaheadChildren before adding favorites
            let tempExtendedChildren = children;
            if (variant === 'typeahead' || variant === 'typeaheadmulti') {
                tempExtendedChildren = this.extendTypeaheadChildren(typeaheadCurrIndex, favoritesGroup);
            }
            else if (onFavorite) {
                tempExtendedChildren = favoritesGroup.concat(children);
            }
            // mark items that are favorited with isFavorite
            renderableItems = extendItemsWithFavorite(tempExtendedChildren, isGrouped, favorites);
        }
        else {
            renderableItems = children;
        }
        if (!customContent) {
            if (!hasAnySelections && !placeholderText) {
                const childPlaceholder = react.Children.toArray(children).filter((child) => child.props.isPlaceholder === true);
                childPlaceholderText =
                    (childPlaceholder[0] && this.getDisplay(childPlaceholder[0].props.value, 'node')) ||
                        (children[0] && this.getDisplay(children[0].props.value, 'node'));
            }
        }
        if (isOpen) {
            if (renderableItems.find(item => (item === null || item === void 0 ? void 0 : item.key) === 'loading') === undefined) {
                if (loadingVariant === 'spinner') {
                    renderableItems.push(react.createElement(SelectOption, { isLoading: true, key: "loading", value: "loading" },
                        react.createElement(Spinner, { size: "lg" })));
                }
                else if (loadingVariant === null || loadingVariant === void 0 ? void 0 : loadingVariant.text) {
                    renderableItems.push(react.createElement(SelectOption, { isLoad: true, key: "loading", value: loadingVariant.text, setViewMoreNextIndex: this.setVieMoreNextIndex, onClick: loadingVariant === null || loadingVariant === void 0 ? void 0 : loadingVariant.onClick }));
                }
            }
        }
        const hasOnClear = onClear !== Select.defaultProps.onClear;
        const clearBtn = (react.createElement("button", { className: (0,esm.css)(Button_button["default"].button, Button_button["default"].modifiers.plain, Select_select["default"].selectToggleClear), onClick: e => {
                this.clearSelection(e);
                onClear(e);
                e.stopPropagation();
            }, "aria-label": clearSelectionsAriaLabel, type: "button", disabled: isDisabled, ref: this.clearRef, onKeyDown: event => {
                if (event.key === KeyTypes.Enter) {
                    this.clearRef.current.click();
                }
            } },
            react.createElement(times_circle_icon, { "aria-hidden": true })));
        let selectedChips = null;
        if (variant === SelectVariant.typeaheadMulti) {
            selectedChips = chipGroupComponent ? (chipGroupComponent) : (react.createElement(ChipGroup, Object.assign({}, chipGroupProps), selections &&
                selections.map(item => (react.createElement(Chip, { key: item, onClick: (e) => onSelect(e, item), closeBtnAriaLabel: removeSelectionAriaLabel }, this.getDisplay(item, 'node'))))));
        }
        if (hasInlineFilter) {
            const filterBox = (react.createElement(react.Fragment, null,
                react.createElement("div", { key: "inline-filter", className: (0,esm.css)(Select_select["default"].selectMenuSearch) },
                    react.createElement("input", { key: "inline-filter-input", type: "search", className: (0,esm.css)(form_control["default"].formControl, form_control["default"].modifiers.search), onChange: this.onChange, placeholder: inlineFilterPlaceholderText, onKeyDown: event => {
                            if (event.key === KeyTypes.ArrowUp) {
                                this.handleMenuKeys(0, 0, 'up');
                                event.preventDefault();
                            }
                            else if (event.key === KeyTypes.ArrowDown) {
                                this.handleMenuKeys(0, 0, 'down');
                                event.preventDefault();
                            }
                            else if (event.key === KeyTypes.ArrowLeft) {
                                this.handleMenuKeys(0, 0, 'left');
                                event.preventDefault();
                            }
                            else if (event.key === KeyTypes.ArrowRight) {
                                this.handleMenuKeys(0, 0, 'right');
                                event.preventDefault();
                            }
                            else if (event.key === KeyTypes.Tab && variant !== SelectVariant.checkbox && this.props.footer) {
                                // tab to footer or close menu if shift key
                                if (event.shiftKey) {
                                    this.onToggle(false, event);
                                }
                                else {
                                    const tabbableItems = findTabbableElements(this.footerRef, SelectFooterTabbableItems);
                                    if (tabbableItems.length > 0) {
                                        tabbableItems[0].focus();
                                        event.stopPropagation();
                                        event.preventDefault();
                                    }
                                    else {
                                        this.onToggle(false, event);
                                    }
                                }
                            }
                            else if (event.key === KeyTypes.Tab && variant === SelectVariant.checkbox) {
                                // More modal-like experience for checkboxes
                                // Let SelectOption handle this
                                if (event.shiftKey) {
                                    this.handleMenuKeys(0, 0, 'up');
                                }
                                else {
                                    this.handleMenuKeys(0, 0, 'down');
                                }
                                event.stopPropagation();
                                event.preventDefault();
                            }
                        }, ref: this.filterRef, autoComplete: inputAutoComplete })),
                react.createElement(Divider, { key: "inline-filter-divider" })));
            renderableItems = [filterBox, ...typeaheadFilteredChildren].map((option, index) => react.cloneElement(option, { key: index }));
        }
        let variantProps;
        let variantChildren;
        if (customContent) {
            variantProps = {
                selected: selections,
                openedOnEnter,
                isCustomContent: true
            };
            variantChildren = customContent;
        }
        else {
            switch (variant) {
                case 'single':
                    variantProps = {
                        selected: selections[0],
                        hasInlineFilter,
                        openedOnEnter
                    };
                    variantChildren = renderableItems;
                    break;
                case 'checkbox':
                    variantProps = {
                        checked: selections,
                        isGrouped,
                        hasInlineFilter,
                        openedOnEnter
                    };
                    variantChildren = renderableItems;
                    break;
                case 'typeahead':
                    variantProps = {
                        selected: selections[0],
                        openedOnEnter
                    };
                    variantChildren = onFavorite ? renderableItems : this.extendTypeaheadChildren(typeaheadCurrIndex);
                    if (variantChildren.length === 0) {
                        variantChildren.push(react.createElement(SelectOption, { isDisabled: true, key: 0, value: noResultsFoundText, isNoResultsOption: true }));
                    }
                    break;
                case 'typeaheadmulti':
                    variantProps = {
                        selected: selections,
                        openedOnEnter
                    };
                    variantChildren = onFavorite ? renderableItems : this.extendTypeaheadChildren(typeaheadCurrIndex);
                    if (variantChildren.length === 0) {
                        variantChildren.push(react.createElement(SelectOption, { isDisabled: true, key: 0, value: noResultsFoundText, isNoResultsOption: true }));
                    }
                    break;
            }
        }
        const isStatic = isFlipEnabled && menuAppendTo !== 'inline';
        const innerMenu = (react.createElement(SelectMenu, Object.assign({ className: (0,esm.css)(isStatic && Select_select["default"].modifiers.static) }, props, { isGrouped: isGrouped, selected: selections }, variantProps, { openedOnEnter: openedOnEnter, "aria-label": ariaLabel, "aria-labelledby": ariaLabelledBy, sendRef: this.sendRef, keyHandler: this.handleMenuKeys, maxHeight: maxHeight, ref: this.menuComponentRef, footer: footer, footerRef: this.footerRef, isLastOptionBeforeFooter: this.isLastOptionBeforeFooter }), variantChildren));
        const menuContainer = footer ? react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectMenu) },
            " ",
            innerMenu,
            " ") : innerMenu;
        const popperContainer = (react.createElement("div", Object.assign({ className: (0,esm.css)(Select_select["default"].select, isOpen && Select_select["default"].modifiers.expanded, validated === ValidatedOptions.success && Select_select["default"].modifiers.success, validated === ValidatedOptions.warning && Select_select["default"].modifiers.warning, validated === ValidatedOptions.error && Select_select["default"].modifiers.invalid, direction === SelectDirection.up && Select_select["default"].modifiers.top, className) }, (width && { style: { width } }), (validated !== ValidatedOptions.default && { 'aria-invalid': ariaInvalid })), isOpen && menuContainer));
        const mainContainer = (react.createElement("div", Object.assign({ className: (0,esm.css)(Select_select["default"].select, isOpen && Select_select["default"].modifiers.expanded, validated === ValidatedOptions.success && Select_select["default"].modifiers.success, validated === ValidatedOptions.warning && Select_select["default"].modifiers.warning, validated === ValidatedOptions.error && Select_select["default"].modifiers.invalid, direction === SelectDirection.up && Select_select["default"].modifiers.top, className), ref: this.parentRef }, getOUIAProps(Select.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), (width && { style: { width } }), (validated !== ValidatedOptions.default && { 'aria-invalid': ariaInvalid })),
            react.createElement(SelectToggle, Object.assign({ id: selectToggleId, parentRef: this.parentRef, menuRef: this.menuComponentRef, ref: toggleRef }, (footer && { footerRef: this.footerRef }), { isOpen: isOpen, isPlain: isPlain, hasPlaceholderStyle: hasPlaceholderStyle && (!selections.length || selections[0] === null || isSelectedPlaceholder), onToggle: this.onToggle, onEnter: this.onEnter, onClose: this.onClose, onBlur: onBlur, variant: variant, toggleIndicator: toggleIndicator, "aria-labelledby": `${ariaLabelledBy || ''} ${selectToggleId}`, "aria-label": toggleAriaLabel }, (ariaDescribedby && { 'aria-describedby': ariaDescribedby }), { handleTypeaheadKeys: this.handleTypeaheadKeys, moveFocusToLastMenuItem: this.moveFocusToLastMenuItem, isDisabled: isDisabled, hasClearButton: hasOnClear, hasFooter: footer !== undefined, onClickTypeaheadToggleButton: this.onClickTypeaheadToggleButton }),
                customContent && (react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectToggleWrapper) },
                    toggleIcon && react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleIcon) }, toggleIcon),
                    react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleText) }, placeholderText))),
                variant === SelectVariant.single && !customContent && (react.createElement(react.Fragment, null,
                    react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectToggleWrapper) },
                        toggleIcon && react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleIcon) }, toggleIcon),
                        react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleText) }, this.getDisplay(selections[0], 'node') || placeholderText || childPlaceholderText)),
                    hasOnClear && hasAnySelections && clearBtn)),
                variant === SelectVariant.checkbox && !customContent && (react.createElement(react.Fragment, null,
                    react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectToggleWrapper) },
                        toggleIcon && react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleIcon) }, toggleIcon),
                        react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleText) }, placeholderText),
                        !isCheckboxSelectionBadgeHidden && hasAnySelections && (react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectToggleBadge) },
                            react.createElement("span", { className: (0,esm.css)(badge["default"].badge, badge["default"].modifiers.read) }, this.generateSelectedBadge())))),
                    hasOnClear && hasAnySelections && clearBtn)),
                variant === SelectVariant.typeahead && !customContent && (react.createElement(react.Fragment, null,
                    react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectToggleWrapper) },
                        toggleIcon && react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleIcon) }, toggleIcon),
                        react.createElement("input", Object.assign({ className: (0,esm.css)(form_control["default"].formControl, Select_select["default"].selectToggleTypeahead), "aria-activedescendant": typeaheadActiveChild && typeaheadActiveChild.id, id: `${selectToggleId}-select-typeahead`, "aria-label": typeAheadAriaLabel }, (typeAheadAriaDescribedby && { 'aria-describedby': typeAheadAriaDescribedby }), { placeholder: placeholderText, value: typeaheadInputValue !== null
                                ? typeaheadInputValue
                                : this.getDisplay(selections[0], 'text') || '', type: "text", onClick: this.onClick, onChange: this.onChange, autoComplete: inputAutoComplete, disabled: isDisabled, ref: this.inputRef }))),
                    hasOnClear && (selections[0] || typeaheadInputValue) && clearBtn)),
                variant === SelectVariant.typeaheadMulti && !customContent && (react.createElement(react.Fragment, null,
                    react.createElement("div", { className: (0,esm.css)(Select_select["default"].selectToggleWrapper) },
                        toggleIcon && react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleIcon) }, toggleIcon),
                        selections && Array.isArray(selections) && selections.length > 0 && selectedChips,
                        react.createElement("input", Object.assign({ className: (0,esm.css)(form_control["default"].formControl, Select_select["default"].selectToggleTypeahead), "aria-activedescendant": typeaheadActiveChild && typeaheadActiveChild.id, id: `${selectToggleId}-select-multi-typeahead-typeahead`, "aria-label": typeAheadAriaLabel, "aria-invalid": validated === ValidatedOptions.error }, (typeAheadAriaDescribedby && { 'aria-describedby': typeAheadAriaDescribedby }), { placeholder: placeholderText, value: typeaheadInputValue !== null ? typeaheadInputValue : '', type: "text", onChange: this.onChange, onClick: this.onClick, autoComplete: inputAutoComplete, disabled: isDisabled, ref: this.inputRef }))),
                    hasOnClear && ((selections && selections.length > 0) || typeaheadInputValue) && clearBtn)),
                validated === ValidatedOptions.success && (react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleStatusIcon) },
                    react.createElement(check_circle_icon, { "aria-hidden": "true" }))),
                validated === ValidatedOptions.error && (react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleStatusIcon) },
                    react.createElement(exclamation_circle_icon, { "aria-hidden": "true" }))),
                validated === ValidatedOptions.warning && (react.createElement("span", { className: (0,esm.css)(Select_select["default"].selectToggleStatusIcon) },
                    react.createElement(exclamation_triangle_icon, { "aria-hidden": "true" })))),
            isOpen && menuAppendTo === 'inline' && menuContainer));
        const getParentElement = () => {
            if (this.parentRef && this.parentRef.current) {
                return this.parentRef.current.parentElement;
            }
            return null;
        };
        return (react.createElement(GenerateId, null, randomId => (react.createElement(SelectContext.Provider, { value: {
                onSelect,
                onFavorite,
                onClose: this.onClose,
                variant,
                inputIdPrefix: inputIdPrefix || randomId,
                shouldResetOnSelect
            } }, menuAppendTo === 'inline' ? (mainContainer) : (react.createElement(Popper_Popper, { trigger: mainContainer, popper: popperContainer, direction: direction, appendTo: menuAppendTo === 'parent' ? getParentElement() : menuAppendTo, isVisible: isOpen, removeFindDomNode: removeFindDomNode, zIndex: zIndex }))))));
    }
}
Select.displayName = 'Select';
Select.defaultProps = {
    children: [],
    className: '',
    position: SelectPosition.left,
    direction: SelectDirection.down,
    toggleId: null,
    isOpen: false,
    isGrouped: false,
    isPlain: false,
    isDisabled: false,
    hasPlaceholderStyle: false,
    isCreatable: false,
    isCreateOptionOnTop: false,
    validated: 'default',
    'aria-label': '',
    'aria-labelledby': '',
    'aria-describedby': '',
    'aria-invalid': false,
    typeAheadAriaLabel: '',
    typeAheadAriaDescribedby: '',
    clearSelectionsAriaLabel: 'Clear all',
    toggleAriaLabel: 'Options menu',
    removeSelectionAriaLabel: 'Remove',
    selections: [],
    createText: 'Create',
    placeholderText: '',
    noResultsFoundText: 'No results found',
    variant: SelectVariant.single,
    width: '',
    onClear: () => undefined,
    onCreateOption: () => undefined,
    toggleIcon: null,
    toggleIndicator: null,
    onFilter: null,
    onTypeaheadInputChanged: null,
    customContent: null,
    hasInlineFilter: false,
    inlineFilterPlaceholderText: null,
    customBadgeText: null,
    inputIdPrefix: '',
    inputAutoComplete: 'off',
    menuAppendTo: 'inline',
    favorites: [],
    favoritesLabel: 'Favorites',
    ouiaSafe: true,
    chipGroupComponent: null,
    isInputValuePersisted: false,
    isInputFilterPersisted: false,
    isCreateSelectOptionObject: false,
    shouldResetOnSelect: true,
    isFlipEnabled: true,
    removeFindDomNode: false,
    zIndex: 9999
};
//# sourceMappingURL=Select.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/InputGroup/input-group.js
var input_group = __webpack_require__(76754);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FormSelect/FormSelect.js






class FormSelect extends react.Component {
    constructor(props) {
        super(props);
        this.handleChange = (event) => {
            this.props.onChange(event.currentTarget.value, event);
        };
        if (!props.id && !props['aria-label']) {
            // eslint-disable-next-line no-console
            console.error('FormSelect requires either an id or aria-label to be specified');
        }
        this.state = {
            ouiaStateId: getDefaultOUIAId(FormSelect.displayName, props.validated)
        };
    }
    render() {
        const _a = this.props, { children, className, value, validated, isDisabled, isRequired, isIconSprite, ouiaId, ouiaSafe } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "value", "validated", "isDisabled", "isRequired", "isIconSprite", "ouiaId", "ouiaSafe"]);
        /* find selected option and get placeholder flag */
        const selectedOption = react.Children.toArray(children).find((option) => option.props.value === value);
        const isSelectedPlaceholder = selectedOption && selectedOption.props.isPlaceholder;
        return (react.createElement("select", Object.assign({}, props, { className: (0,esm.css)(form_control["default"].formControl, isIconSprite && form_control["default"].modifiers.iconSprite, className, validated === ValidatedOptions.success && form_control["default"].modifiers.success, validated === ValidatedOptions.warning && form_control["default"].modifiers.warning, isSelectedPlaceholder && form_control["default"].modifiers.placeholder), "aria-invalid": validated === ValidatedOptions.error }, getOUIAProps(FormSelect.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), { onChange: this.handleChange, disabled: isDisabled, required: isRequired, value: value }), children));
    }
}
FormSelect.displayName = 'FormSelect';
FormSelect.defaultProps = {
    className: '',
    value: '',
    validated: 'default',
    isDisabled: false,
    isRequired: false,
    isIconSprite: false,
    onBlur: () => undefined,
    onFocus: () => undefined,
    onChange: () => undefined,
    ouiaSafe: true
};
//# sourceMappingURL=FormSelect.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_form_control_textarea_Height.js
const c_form_control_textarea_Height = {
  "name": "--pf-c-form-control--textarea--Height",
  "value": "auto",
  "var": "var(--pf-c-form-control--textarea--Height)"
};
/* harmony default export */ const esm_c_form_control_textarea_Height = (c_form_control_textarea_Height);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/TextArea/TextArea.js






var TextAreResizeOrientation;
(function (TextAreResizeOrientation) {
    TextAreResizeOrientation["horizontal"] = "horizontal";
    TextAreResizeOrientation["vertical"] = "vertical";
    TextAreResizeOrientation["both"] = "both";
})(TextAreResizeOrientation || (TextAreResizeOrientation = {}));
var TextAreaReadOnlyVariant;
(function (TextAreaReadOnlyVariant) {
    TextAreaReadOnlyVariant["default"] = "default";
    TextAreaReadOnlyVariant["plain"] = "plain";
})(TextAreaReadOnlyVariant || (TextAreaReadOnlyVariant = {}));
class TextAreaBase extends react.Component {
    constructor(props) {
        super(props);
        this.inputRef = react.createRef();
        this.setAutoHeight = (field) => {
            field.style.setProperty(esm_c_form_control_textarea_Height.name, 'inherit');
            const computed = window.getComputedStyle(field);
            // Calculate the height
            const height = parseInt(computed.getPropertyValue('border-top-width')) +
                parseInt(computed.getPropertyValue('padding-top')) +
                field.scrollHeight +
                parseInt(computed.getPropertyValue('padding-bottom')) +
                parseInt(computed.getPropertyValue('border-bottom-width'));
            field.style.setProperty(esm_c_form_control_textarea_Height.name, `${height}px`);
        };
        this.handleChange = (event) => {
            // https://gomakethings.com/automatically-expand-a-textarea-as-the-user-types-using-vanilla-javascript/
            const field = event.currentTarget;
            if (this.props.autoResize && canUseDOM) {
                this.setAutoHeight(field);
            }
            if (this.props.onChange) {
                this.props.onChange(field.value, event);
            }
        };
        if (!props.id && !props['aria-label']) {
            // eslint-disable-next-line no-console
            console.error('TextArea: TextArea requires either an id or aria-label to be specified');
        }
    }
    componentDidMount() {
        const inputRef = this.props.innerRef || this.inputRef;
        if (this.props.autoResize && canUseDOM) {
            const field = inputRef.current;
            this.setAutoHeight(field);
        }
    }
    render() {
        const _a = this.props, { className, value, validated, isRequired, isDisabled, isIconSprite, isReadOnly, readOnlyVariant, resizeOrientation, innerRef, disabled, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        autoResize, onChange } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        props = (0,tslib_es6.__rest)(_a, ["className", "value", "validated", "isRequired", "isDisabled", "isIconSprite", "isReadOnly", "readOnlyVariant", "resizeOrientation", "innerRef", "disabled", "autoResize", "onChange"]);
        const orientation = `resize${capitalize(resizeOrientation)}`;
        return (react.createElement("textarea", Object.assign({ className: (0,esm.css)(form_control["default"].formControl, isIconSprite && form_control["default"].modifiers.iconSprite, readOnlyVariant === 'plain' && form_control["default"].modifiers.plain, className, resizeOrientation !== TextAreResizeOrientation.both && form_control["default"].modifiers[orientation], validated === ValidatedOptions.success && form_control["default"].modifiers.success, validated === ValidatedOptions.warning && form_control["default"].modifiers.warning), onChange: this.handleChange }, (typeof this.props.defaultValue !== 'string' && { value }), { "aria-invalid": validated === ValidatedOptions.error, required: isRequired, disabled: isDisabled || disabled, readOnly: !!readOnlyVariant || isReadOnly, ref: innerRef || this.inputRef }, props)));
    }
}
TextAreaBase.displayName = 'TextArea';
TextAreaBase.defaultProps = {
    innerRef: react.createRef(),
    className: '',
    isRequired: false,
    isDisabled: false,
    isIconSprite: false,
    validated: 'default',
    resizeOrientation: 'both',
    'aria-label': null
};
const TextArea = react.forwardRef((props, ref) => (react.createElement(TextAreaBase, Object.assign({}, props, { innerRef: ref }))));
TextArea.displayName = 'TextArea';
//# sourceMappingURL=TextArea.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/InputGroup/InputGroup.js







const InputGroup = (_a) => {
    var { className = '', children, innerRef } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "innerRef"]);
    const formCtrls = [FormSelect, TextArea, TextInput].map(comp => comp.displayName);
    const idItem = react.Children.toArray(children).find((child) => !formCtrls.includes(child.type.displayName) && child.props.id);
    const ref = react.useRef(null);
    const inputGroupRef = innerRef || ref;
    return (react.createElement("div", Object.assign({ ref: inputGroupRef, className: (0,esm.css)(input_group["default"].inputGroup, className) }, props), idItem
        ? react.Children.map(children, (child) => !formCtrls.includes(child.type.displayName) || child.props['aria-describedby']
            ? child
            : react.cloneElement(child, {
                'aria-describedby': child.props['aria-describedby'] === '' ? undefined : idItem.props.id
            }))
        : children));
};
InputGroup.displayName = 'InputGroup';
//# sourceMappingURL=InputGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/angle-left-icon.js


const AngleLeftIconConfig = {
  name: 'AngleLeftIcon',
  height: 512,
  width: 256,
  svgPath: 'M31.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L127.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L201.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34z',
  yOffset: 0,
  xOffset: 0,
};

const AngleLeftIcon = createIcon(AngleLeftIconConfig);

/* harmony default export */ const angle_left_icon = (AngleLeftIcon);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/CalendarMonth/calendar-month.js
var calendar_month = __webpack_require__(5978);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/datetimeUtils.js
/**
 * @param {Date} date - A date to check the validity of
 */
const isValidDate = (date) => Boolean(date && !isNaN(date));
//# sourceMappingURL=datetimeUtils.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/CalendarMonth/CalendarMonth.js












var Weekday;
(function (Weekday) {
    Weekday[Weekday["Sunday"] = 0] = "Sunday";
    Weekday[Weekday["Monday"] = 1] = "Monday";
    Weekday[Weekday["Tuesday"] = 2] = "Tuesday";
    Weekday[Weekday["Wednesday"] = 3] = "Wednesday";
    Weekday[Weekday["Thursday"] = 4] = "Thursday";
    Weekday[Weekday["Friday"] = 5] = "Friday";
    Weekday[Weekday["Saturday"] = 6] = "Saturday";
})(Weekday || (Weekday = {}));
// Must be numeric given current header design
const yearFormat = (date) => date.getFullYear();
const buildCalendar = (year, month, weekStart, validators) => {
    const defaultDate = new Date(year, month);
    const firstDayOfWeek = new Date(defaultDate);
    firstDayOfWeek.setDate(firstDayOfWeek.getDate() - firstDayOfWeek.getDay() + weekStart);
    // We will show a maximum of 6 weeks like Google calendar
    // Assume we just want the numbers for now...
    const calendarWeeks = [];
    if (firstDayOfWeek.getMonth() === defaultDate.getMonth() && firstDayOfWeek.getDate() !== 1) {
        firstDayOfWeek.setDate(firstDayOfWeek.getDate() - 7);
    }
    for (let i = 0; i < 6; i++) {
        const week = [];
        for (let j = 0; j < 7; j++) {
            const date = new Date(firstDayOfWeek);
            week.push({
                date,
                isValid: validators.every(validator => validator(date))
            });
            firstDayOfWeek.setDate(firstDayOfWeek.getDate() + 1);
        }
        calendarWeeks.push(week);
        if (firstDayOfWeek.getMonth() !== defaultDate.getMonth()) {
            break;
        }
    }
    return calendarWeeks;
};
const isSameDate = (d1, d2) => d1.getFullYear() === d2.getFullYear() && d1.getMonth() === d2.getMonth() && d1.getDate() === d2.getDate();
const today = new Date();
/** The main calendar month component. */
const CalendarMonth = (_a) => {
    var { date: dateProp, locale = undefined, monthFormat = date => date.toLocaleDateString(locale, { month: 'long' }), weekdayFormat = date => date.toLocaleDateString(locale, { weekday: 'narrow' }), longWeekdayFormat = date => date.toLocaleDateString(locale, { weekday: 'long' }), dayFormat = date => date.getDate(), weekStart = 0, // Use the American Sunday as a default
    onChange = () => { }, validators = [() => true], className, onSelectToggle = () => { }, onMonthChange = () => { }, rangeStart, prevMonthAriaLabel = 'Previous month', nextMonthAriaLabel = 'Next month', yearInputAriaLabel = 'Select year', cellAriaLabel, isDateFocused = false, inlineProps } = _a, props = (0,tslib_es6.__rest)(_a, ["date", "locale", "monthFormat", "weekdayFormat", "longWeekdayFormat", "dayFormat", "weekStart", "onChange", "validators", "className", "onSelectToggle", "onMonthChange", "rangeStart", "prevMonthAriaLabel", "nextMonthAriaLabel", "yearInputAriaLabel", "cellAriaLabel", "isDateFocused", "inlineProps"]);
    const longMonths = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11].map(monthNum => new Date(1990, monthNum)).map(monthFormat);
    const [isSelectOpen, setIsSelectOpen] = react.useState(false);
    // eslint-disable-next-line prefer-const
    const [focusedDate, setFocusedDate] = react.useState(() => {
        const initDate = new Date(dateProp);
        if (isValidDate(initDate)) {
            return initDate;
        }
        else {
            if (isValidDate(rangeStart)) {
                return rangeStart;
            }
            else {
                return today;
            }
        }
    });
    const [hoveredDate, setHoveredDate] = react.useState(new Date(focusedDate));
    const focusRef = react.useRef();
    const [hiddenMonthId] = react.useState(getUniqueId('hidden-month-span'));
    const [shouldFocus, setShouldFocus] = react.useState(false);
    const isValidated = (date) => validators.every(validator => validator(date));
    const focusedDateValidated = isValidated(focusedDate);
    (0,react.useEffect)(() => {
        if (isValidDate(dateProp) && !isSameDate(focusedDate, dateProp)) {
            setFocusedDate(dateProp);
        }
        else if (!dateProp) {
            setFocusedDate(today);
        }
    }, [dateProp]);
    (0,react.useEffect)(() => {
        // Calendar month should not be focused on page load
        // Datepicker should place focus in calendar month when opened
        if ((shouldFocus || isDateFocused) && focusedDateValidated && focusRef.current) {
            focusRef.current.focus();
        }
        else {
            setShouldFocus(true);
        }
    }, [focusedDate, isDateFocused, focusedDateValidated, focusRef]);
    const onMonthClick = (newDate, ev) => {
        setFocusedDate(newDate);
        setHoveredDate(newDate);
        setShouldFocus(false);
        onMonthChange(newDate, ev);
    };
    const onKeyDown = (ev) => {
        const newDate = new Date(focusedDate);
        if (ev.key === 'ArrowUp') {
            newDate.setDate(newDate.getDate() - 7);
        }
        else if (ev.key === 'ArrowRight') {
            newDate.setDate(newDate.getDate() + 1);
        }
        else if (ev.key === 'ArrowDown') {
            newDate.setDate(newDate.getDate() + 7);
        }
        else if (ev.key === 'ArrowLeft') {
            newDate.setDate(newDate.getDate() - 1);
        }
        if (newDate.getTime() !== focusedDate.getTime() && isValidated(newDate)) {
            ev.preventDefault();
            setFocusedDate(newDate);
            setHoveredDate(newDate);
            setShouldFocus(true);
        }
    };
    const addMonth = (toAdd) => {
        const newDate = new Date(focusedDate);
        newDate.setMonth(newDate.getMonth() + toAdd);
        return newDate;
    };
    const prevMonth = addMonth(-1);
    const nextMonth = addMonth(1);
    const focusedYear = focusedDate.getFullYear();
    const focusedMonth = focusedDate.getMonth();
    const calendar = react.useMemo(() => buildCalendar(focusedYear, focusedMonth, weekStart, validators), [
        focusedYear,
        focusedMonth,
        weekStart,
        validators
    ]);
    if (!focusedDateValidated) {
        const toFocus = calendar
            .reduce((acc, cur) => [...acc, ...cur], [])
            .filter(({ date, isValid }) => isValid && date.getMonth() === focusedMonth)
            .map(({ date }) => ({ date, days: Math.abs(focusedDate.getTime() - date.getTime()) }))
            .sort((o1, o2) => o1.days - o2.days)
            .map(({ date }) => date)[0];
        if (toFocus) {
            setFocusedDate(toFocus);
            setHoveredDate(toFocus);
        }
    }
    const isHoveredDateValid = isValidated(hoveredDate);
    const monthFormatted = monthFormat(focusedDate);
    const yearFormatted = yearFormat(focusedDate);
    const calendarToRender = (react.createElement("div", Object.assign({ className: (0,esm.css)(calendar_month/* default */.Z.calendarMonth, className) }, props),
        react.createElement("div", { className: calendar_month/* default */.Z.calendarMonthHeader },
            react.createElement("div", { className: (0,esm.css)(calendar_month/* default */.Z.calendarMonthHeaderNavControl, calendar_month/* default */.Z.modifiers.prevMonth) },
                react.createElement(Button, { variant: "plain", "aria-label": prevMonthAriaLabel, onClick: (ev) => onMonthClick(prevMonth, ev) },
                    react.createElement(angle_left_icon, { "aria-hidden": true }))),
            react.createElement(InputGroup, null,
                react.createElement("div", { className: calendar_month/* default */.Z.calendarMonthHeaderMonth },
                    react.createElement("span", { id: hiddenMonthId, hidden: true }, "Month"),
                    react.createElement(Select
                    // Max width with "September"
                    , { 
                        // Max width with "September"
                        width: "140px", "aria-labelledby": hiddenMonthId, isOpen: isSelectOpen, onToggle: () => {
                            setIsSelectOpen(!isSelectOpen);
                            onSelectToggle(!isSelectOpen);
                        }, onSelect: (ev, monthNum) => {
                            // When we put CalendarMonth in a Popover we want the Popover's onDocumentClick
                            // to see the SelectOption as a child so it doesn't close the Popover.
                            setTimeout(() => {
                                setIsSelectOpen(false);
                                onSelectToggle(false);
                                const newDate = new Date(focusedDate);
                                newDate.setMonth(Number(monthNum));
                                setFocusedDate(newDate);
                                setHoveredDate(newDate);
                                setShouldFocus(false);
                                onMonthChange(newDate, ev);
                            }, 0);
                        }, variant: "single", selections: monthFormatted }, longMonths.map((longMonth, index) => (react.createElement(SelectOption, { key: index, value: index, isSelected: longMonth === monthFormatted }, longMonth))))),
                react.createElement("div", { className: calendar_month/* default */.Z.calendarMonthHeaderYear },
                    react.createElement(TextInput, { "aria-label": yearInputAriaLabel, type: "number", value: yearFormatted, onChange: (year, ev) => {
                            const newDate = new Date(focusedDate);
                            newDate.setFullYear(+year);
                            setFocusedDate(newDate);
                            setHoveredDate(newDate);
                            setShouldFocus(false);
                            onMonthChange(newDate, ev);
                        } }))),
            react.createElement("div", { className: (0,esm.css)(calendar_month/* default */.Z.calendarMonthHeaderNavControl, calendar_month/* default */.Z.modifiers.nextMonth) },
                react.createElement(Button, { variant: "plain", "aria-label": nextMonthAriaLabel, onClick: (ev) => onMonthClick(nextMonth, ev) },
                    react.createElement(angle_right_icon, { "aria-hidden": true })))),
        react.createElement("table", { className: calendar_month/* default */.Z.calendarMonthCalendar },
            react.createElement("thead", { className: calendar_month/* default */.Z.calendarMonthDays },
                react.createElement("tr", null, calendar[0].map(({ date }, index) => (react.createElement("th", { key: index, className: calendar_month/* default */.Z.calendarMonthDay, scope: "col" },
                    react.createElement("span", { className: "pf-screen-reader" }, longWeekdayFormat(date)),
                    react.createElement("span", { "aria-hidden": true }, weekdayFormat(date))))))),
            react.createElement("tbody", { onKeyDown: onKeyDown }, calendar.map((week, index) => (react.createElement("tr", { key: index, className: calendar_month/* default */.Z.calendarMonthDatesRow }, week.map(({ date, isValid }, index) => {
                const dayFormatted = dayFormat(date);
                const isToday = isSameDate(date, today);
                const isSelected = isValidDate(dateProp) && isSameDate(date, dateProp);
                const isFocused = isSameDate(date, focusedDate);
                const isAdjacentMonth = date.getMonth() !== focusedDate.getMonth();
                const isRangeStart = isValidDate(rangeStart) && isSameDate(date, rangeStart);
                let isInRange = false;
                let isRangeEnd = false;
                if (isValidDate(rangeStart) && isValidDate(dateProp)) {
                    isInRange = date > rangeStart && date < dateProp;
                    isRangeEnd = isSameDate(date, dateProp);
                }
                else if (isValidDate(rangeStart) && isHoveredDateValid) {
                    if (hoveredDate > rangeStart || isSameDate(hoveredDate, rangeStart)) {
                        isInRange = date > rangeStart && date < hoveredDate;
                        isRangeEnd = isSameDate(date, hoveredDate);
                    }
                    // Don't handle focused dates before start dates for now.
                    // Core would likely need new styles
                }
                return (react.createElement("td", { key: index, className: (0,esm.css)(calendar_month/* default */.Z.calendarMonthDatesCell, isAdjacentMonth && calendar_month/* default */.Z.modifiers.adjacentMonth, isToday && calendar_month/* default */.Z.modifiers.current, (isSelected || isRangeStart) && calendar_month/* default */.Z.modifiers.selected, !isValid && calendar_month/* default */.Z.modifiers.disabled, (isInRange || isRangeStart || isRangeEnd) && calendar_month/* default */.Z.modifiers.inRange, isRangeStart && calendar_month/* default */.Z.modifiers.startRange, isRangeEnd && calendar_month/* default */.Z.modifiers.endRange) },
                    react.createElement("button", Object.assign({ className: (0,esm.css)(calendar_month/* default */.Z.calendarMonthDate, isRangeEnd && calendar_month/* default */.Z.modifiers.hover, !isValid && calendar_month/* default */.Z.modifiers.disabled), type: "button", onClick: () => onChange(date), onMouseOver: () => setHoveredDate(date), tabIndex: isFocused ? 0 : -1, disabled: !isValid, "aria-label": cellAriaLabel
                            ? cellAriaLabel(date)
                            : `${dayFormat(date)} ${monthFormat(date)} ${yearFormat(date)}` }, (isFocused && { ref: focusRef })), dayFormatted)));
            }))))))));
    if (inlineProps !== undefined) {
        const Component = (inlineProps.component ? inlineProps.component : 'article');
        return (react.createElement(Component, Object.assign({}, (inlineProps.ariaLabelledby && { 'aria-labelledby': inlineProps.ariaLabelledby })),
            inlineProps.title,
            calendarToRender));
    }
    return calendarToRender;
};
CalendarMonth.displayName = 'CalendarMonth';
//# sourceMappingURL=CalendarMonth.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/CalendarMonth/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Card/card.js
var card = __webpack_require__(45509);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/Card.js





const CardContext = react.createContext({
    cardId: '',
    registerTitleId: () => { },
    isExpanded: false
});
const Card = (_a) => {
    var { children = null, id = '', className = '', component = 'article', isHoverable = false, isCompact = false, isSelectable = false, isSelectableRaised = false, isSelected = false, isDisabledRaised = false, isFlat = false, isExpanded = false, isRounded = false, isLarge = false, isFullHeight = false, isPlain = false, ouiaId, ouiaSafe = true, hasSelectableInput = false, selectableInputAriaLabel, onSelectableInputChange = () => { } } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "id", "className", "component", "isHoverable", "isCompact", "isSelectable", "isSelectableRaised", "isSelected", "isDisabledRaised", "isFlat", "isExpanded", "isRounded", "isLarge", "isFullHeight", "isPlain", "ouiaId", "ouiaSafe", "hasSelectableInput", "selectableInputAriaLabel", "onSelectableInputChange"]);
    const Component = component;
    const ouiaProps = useOUIAProps(Card.displayName, ouiaId, ouiaSafe);
    const [titleId, setTitleId] = react.useState('');
    const [ariaProps, setAriaProps] = react.useState();
    if (isCompact && isLarge) {
        // eslint-disable-next-line no-console
        console.warn('Card: Cannot use isCompact with isLarge. Defaulting to isCompact');
        isLarge = false;
    }
    const getSelectableModifiers = () => {
        if (isDisabledRaised) {
            return (0,esm.css)(card["default"].modifiers.nonSelectableRaised);
        }
        if (isSelectableRaised) {
            return (0,esm.css)(card["default"].modifiers.selectableRaised, isSelected && card["default"].modifiers.selectedRaised);
        }
        if (isSelectable || isHoverable) {
            return (0,esm.css)(card["default"].modifiers.selectable, isSelected && card["default"].modifiers.selected);
        }
        return '';
    };
    const containsCardTitleChildRef = react.useRef(false);
    const registerTitleId = (id) => {
        setTitleId(id);
        containsCardTitleChildRef.current = !!id;
    };
    react.useEffect(() => {
        if (selectableInputAriaLabel) {
            setAriaProps({ 'aria-label': selectableInputAriaLabel });
        }
        else if (titleId) {
            setAriaProps({ 'aria-labelledby': titleId });
        }
        else if (hasSelectableInput && !containsCardTitleChildRef.current) {
            setAriaProps({});
            // eslint-disable-next-line no-console
            console.warn('If no CardTitle component is passed as a child of Card the selectableInputAriaLabel prop must be passed');
        }
    }, [hasSelectableInput, selectableInputAriaLabel, titleId]);
    return (react.createElement(CardContext.Provider, { value: {
            cardId: id,
            registerTitleId,
            isExpanded
        } },
        hasSelectableInput && (react.createElement("input", Object.assign({ className: "pf-screen-reader", id: `${id}-input` }, ariaProps, { type: "checkbox", checked: isSelected, onChange: event => onSelectableInputChange(id, event), disabled: isDisabledRaised, tabIndex: -1 }))),
        react.createElement(Component, Object.assign({ id: id, className: (0,esm.css)(card["default"].card, isCompact && card["default"].modifiers.compact, isExpanded && card["default"].modifiers.expanded, isFlat && card["default"].modifiers.flat, isRounded && card["default"].modifiers.rounded, isLarge && card["default"].modifiers.displayLg, isFullHeight && card["default"].modifiers.fullHeight, isPlain && card["default"].modifiers.plain, getSelectableModifiers(), className), tabIndex: isSelectable || isSelectableRaised ? '0' : undefined }, props, ouiaProps), children)));
};
Card.displayName = 'Card';
//# sourceMappingURL=Card.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardActions.js




const CardActions = (_a) => {
    var { children = null, className = '', hasNoOffset = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "hasNoOffset"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(card["default"].cardActions, hasNoOffset && card["default"].modifiers.noOffset, className) }, props), children));
};
CardActions.displayName = 'CardActions';
//# sourceMappingURL=CardActions.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardBody.js




const CardBody = (_a) => {
    var { children = null, className = '', component = 'div', isFilled = true } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component", "isFilled"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(card["default"].cardBody, !isFilled && card["default"].modifiers.noFill, className) }, props), children));
};
CardBody.displayName = 'CardBody';
//# sourceMappingURL=CardBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardExpandableContent.js





const CardExpandableContent = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement(CardContext.Consumer, null, ({ isExpanded }) => isExpanded ? (react.createElement("div", Object.assign({ className: (0,esm.css)(card["default"].cardExpandableContent, className) }, props), children)) : null));
};
CardExpandableContent.displayName = 'CardExpandableContent';
//# sourceMappingURL=CardExpandableContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardFooter.js




const CardFooter = (_a) => {
    var { children = null, className = '', component = 'div' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(card["default"].cardFooter, className) }, props), children));
};
CardFooter.displayName = 'CardFooter';
//# sourceMappingURL=CardFooter.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardTitle.js





const CardTitle = (_a) => {
    var { children = null, className = '', component = 'div' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component"]);
    const { cardId, registerTitleId } = react.useContext(CardContext);
    const Component = component;
    const titleId = cardId ? `${cardId}-title` : '';
    react.useEffect(() => {
        registerTitleId(titleId);
        return () => registerTitleId('');
    }, [registerTitleId, titleId]);
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(card["default"].cardTitle, className), id: titleId || undefined }, props), children));
};
CardTitle.displayName = 'CardTitle';
//# sourceMappingURL=CardTitle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardHeader.js







const CardHeader = (_a) => {
    var { children = null, className = '', id, onExpand, toggleButtonProps, isToggleRightAligned } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "id", "onExpand", "toggleButtonProps", "isToggleRightAligned"]);
    return (react.createElement(CardContext.Consumer, null, ({ cardId }) => {
        const cardHeaderToggle = (react.createElement("div", { className: (0,esm.css)(card["default"].cardHeaderToggle) },
            react.createElement(Button, Object.assign({ variant: "plain", type: "button", onClick: evt => {
                    onExpand(evt, cardId);
                } }, toggleButtonProps),
                react.createElement("span", { className: (0,esm.css)(card["default"].cardHeaderToggleIcon) },
                    react.createElement(angle_right_icon, { "aria-hidden": "true" })))));
        return (react.createElement("div", Object.assign({ className: (0,esm.css)(card["default"].cardHeader, isToggleRightAligned && card["default"].modifiers.toggleRight, className), id: id }, props),
            onExpand && !isToggleRightAligned && cardHeaderToggle,
            children,
            onExpand && isToggleRightAligned && cardHeaderToggle));
    }));
};
CardHeader.displayName = 'CardHeader';
//# sourceMappingURL=CardHeader.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/CardHeaderMain.js


const CardHeaderMain = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: className }, props), children));
};
CardHeaderMain.displayName = 'CardHeaderMain';
//# sourceMappingURL=CardHeaderMain.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Card/index.js








//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/htmlConstants.js
const ASTERISK = '*';
//# sourceMappingURL=htmlConstants.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Checkbox/Checkbox.js






// tslint:disable-next-line:no-empty
const defaultOnChange = () => { };
class Checkbox extends react.Component {
    constructor(props) {
        super(props);
        this.handleChange = (event) => {
            this.props.onChange(event.currentTarget.checked, event);
        };
        this.state = {
            ouiaStateId: getDefaultOUIAId(Checkbox.displayName)
        };
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, className, onChange, isValid, isDisabled, isRequired, isChecked, label, checked, defaultChecked, description, body, ouiaId, ouiaSafe, component: Component } = _a, props = (0,tslib_es6.__rest)(_a, ['aria-label', "className", "onChange", "isValid", "isDisabled", "isRequired", "isChecked", "label", "checked", "defaultChecked", "description", "body", "ouiaId", "ouiaSafe", "component"]);
        if (!props.id) {
            // eslint-disable-next-line no-console
            console.error('Checkbox:', 'id is required to make input accessible');
        }
        const checkedProps = {};
        if ([true, false].includes(checked) || isChecked === true) {
            checkedProps.checked = checked || isChecked;
        }
        if (onChange !== defaultOnChange) {
            checkedProps.checked = isChecked;
        }
        if ([false, true].includes(defaultChecked)) {
            checkedProps.defaultChecked = defaultChecked;
        }
        checkedProps.checked = checkedProps.checked === null ? false : checkedProps.checked;
        return (react.createElement(Component, { className: (0,esm.css)(check["default"].check, !label && check["default"].modifiers.standalone, className) },
            react.createElement("input", Object.assign({}, props, { className: (0,esm.css)(check["default"].checkInput), type: "checkbox", onChange: this.handleChange, "aria-invalid": !isValid, "aria-label": ariaLabel, disabled: isDisabled, required: isRequired, ref: elem => elem && (elem.indeterminate = isChecked === null) }, checkedProps, getOUIAProps(Checkbox.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe))),
            label && (react.createElement("label", { className: (0,esm.css)(check["default"].checkLabel, isDisabled && check["default"].modifiers.disabled), htmlFor: props.id },
                label,
                isRequired && (react.createElement("span", { className: (0,esm.css)(check["default"].checkLabelRequired), "aria-hidden": "true" }, ASTERISK)))),
            description && react.createElement("span", { className: (0,esm.css)(check["default"].checkDescription) }, description),
            body && react.createElement("span", { className: (0,esm.css)(check["default"].checkBody) }, body)));
    }
}
Checkbox.displayName = 'Checkbox';
Checkbox.defaultProps = {
    className: '',
    isValid: true,
    isDisabled: false,
    isRequired: false,
    isChecked: false,
    onChange: defaultOnChange,
    ouiaSafe: true,
    component: 'div'
};
//# sourceMappingURL=Checkbox.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Checkbox/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Chip/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ChipGroup/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/ClipboardCopy/clipboard-copy.js
var clipboard_copy = __webpack_require__(13846);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Popover/popover.js
var popover = __webpack_require__(7418);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverContext.js

const PopoverContext = react.createContext({});
//# sourceMappingURL=PopoverContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverContent.js




const PopoverContent = (_a) => {
    var { className = null, children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(popover["default"].popoverContent, className) }, props), children));
};
PopoverContent.displayName = 'PopoverContent';
//# sourceMappingURL=PopoverContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverBody.js




const PopoverBody = (_a) => {
    var { children, id, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "id", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(popover["default"].popoverBody, className), id: id }, props), children));
};
PopoverBody.displayName = 'PopoverBody';
//# sourceMappingURL=PopoverBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverHeaderIcon.js




const PopoverHeaderIcon = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(popover["default"].popoverTitleIcon, className) }, props), children));
};
PopoverHeaderIcon.displayName = 'PopoverHeaderIcon';
//# sourceMappingURL=PopoverHeaderIcon.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverHeaderText.js




const PopoverHeaderText = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(popover["default"].popoverTitleText, className) }, props), children));
};
PopoverHeaderText.displayName = 'PopoverHeaderText';
//# sourceMappingURL=PopoverHeaderText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverHeader.js







const PopoverHeader = (_a) => {
    var { children, icon, className, titleHeadingLevel = 'h6', alertSeverityVariant, id, alertSeverityScreenReaderText } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "icon", "className", "titleHeadingLevel", "alertSeverityVariant", "id", "alertSeverityScreenReaderText"]);
    const HeadingLevel = titleHeadingLevel;
    return icon || alertSeverityVariant ? (react.createElement("header", Object.assign({ className: (0,esm.css)('pf-c-popover__header', className), id: id }, props),
        react.createElement(HeadingLevel, { className: (0,esm.css)(popover["default"].popoverTitle, icon && popover["default"].modifiers.icon) },
            icon && react.createElement(PopoverHeaderIcon, null, icon),
            alertSeverityVariant && alertSeverityScreenReaderText && (react.createElement("span", { className: "pf-u-screen-reader" }, alertSeverityScreenReaderText)),
            react.createElement(PopoverHeaderText, null, children)))) : (react.createElement(Title, Object.assign({ headingLevel: titleHeadingLevel, size: TitleSizes.md, id: id, className: className }, props), children));
};
PopoverHeader.displayName = 'PopoverHeader';
//# sourceMappingURL=PopoverHeader.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverFooter.js




const PopoverFooter = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("footer", Object.assign({ className: (0,esm.css)(popover["default"].popoverFooter, className) }, props), children));
};
PopoverFooter.displayName = 'PopoverFooter';
//# sourceMappingURL=PopoverFooter.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverCloseButton.js




const PopoverCloseButton = (_a) => {
    var { onClose = () => undefined } = _a, props = (0,tslib_es6.__rest)(_a, ["onClose"]);
    return (react.createElement(Button, Object.assign({ onClick: onClose, variant: "plain", "aria-label": true }, props, { style: { pointerEvents: 'auto' } }),
        react.createElement(times_icon, null)));
};
PopoverCloseButton.displayName = 'PopoverCloseButton';
//# sourceMappingURL=PopoverCloseButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/PopoverArrow.js




const PopoverArrow = (_a) => {
    var { className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["className"]);
    return react.createElement("div", Object.assign({ className: (0,esm.css)(popover["default"].popoverArrow, className) }, props));
};
PopoverArrow.displayName = 'PopoverArrow';
//# sourceMappingURL=PopoverArrow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_popover_MaxWidth.js
const c_popover_MaxWidth = {
  "name": "--pf-c-popover--MaxWidth",
  "value": "none",
  "var": "var(--pf-c-popover--MaxWidth)"
};
/* harmony default export */ const esm_c_popover_MaxWidth = (c_popover_MaxWidth);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_popover_MinWidth.js
const c_popover_MinWidth = {
  "name": "--pf-c-popover--MinWidth",
  "value": "auto",
  "var": "var(--pf-c-popover--MinWidth)"
};
/* harmony default export */ const esm_c_popover_MinWidth = (c_popover_MinWidth);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Popover/Popover.js

/* eslint-disable no-console */
















var PopoverPosition;
(function (PopoverPosition) {
    PopoverPosition["auto"] = "auto";
    PopoverPosition["top"] = "top";
    PopoverPosition["bottom"] = "bottom";
    PopoverPosition["left"] = "left";
    PopoverPosition["right"] = "right";
    PopoverPosition["topStart"] = "top-start";
    PopoverPosition["topEnd"] = "top-end";
    PopoverPosition["bottomStart"] = "bottom-start";
    PopoverPosition["bottomEnd"] = "bottom-end";
    PopoverPosition["leftStart"] = "left-start";
    PopoverPosition["leftEnd"] = "left-end";
    PopoverPosition["rightStart"] = "right-start";
    PopoverPosition["rightEnd"] = "right-end";
})(PopoverPosition || (PopoverPosition = {}));
const alertStyle = {
    default: popover["default"].modifiers.default,
    info: popover["default"].modifiers.info,
    success: popover["default"].modifiers.success,
    warning: popover["default"].modifiers.warning,
    danger: popover["default"].modifiers.danger
};
const Popover = (_a) => {
    var { children, position = 'top', enableFlip = true, className = '', isVisible = null, shouldClose = () => null, shouldOpen = () => null, 'aria-label': ariaLabel = '', bodyContent, headerContent = null, headerComponent = 'h6', headerIcon = null, alertSeverityVariant, alertSeverityScreenReaderText, footerContent = null, appendTo = () => document.body, hideOnOutsideClick = true, onHide = () => null, onHidden = () => null, onShow = () => null, onShown = () => null, onMount = () => null, zIndex = 9999, minWidth = esm_c_popover_MinWidth && esm_c_popover_MinWidth.value, maxWidth = esm_c_popover_MaxWidth && esm_c_popover_MaxWidth.value, closeBtnAriaLabel = 'Close', showClose = true, distance = 25, flipBehavior = [
        'top',
        'bottom',
        'left',
        'right',
        'top-start',
        'top-end',
        'bottom-start',
        'bottom-end',
        'left-start',
        'left-end',
        'right-start',
        'right-end'
    ], animationDuration = 300, id, withFocusTrap: propWithFocusTrap, boundary, tippyProps, reference, hasNoPadding = false, hasAutoWidth = false, removeFindDomNode = false } = _a, rest = (0,tslib_es6.__rest)(_a, ["children", "position", "enableFlip", "className", "isVisible", "shouldClose", "shouldOpen", 'aria-label', "bodyContent", "headerContent", "headerComponent", "headerIcon", "alertSeverityVariant", "alertSeverityScreenReaderText", "footerContent", "appendTo", "hideOnOutsideClick", "onHide", "onHidden", "onShow", "onShown", "onMount", "zIndex", "minWidth", "maxWidth", "closeBtnAriaLabel", "showClose", "distance", "flipBehavior", "animationDuration", "id", "withFocusTrap", "boundary", "tippyProps", "reference", "hasNoPadding", "hasAutoWidth", "removeFindDomNode"]);
    if (false) {}
    // could make this a prop in the future (true | false | 'toggle')
    // const hideOnClick = true;
    const uniqueId = id || getUniqueId();
    const triggerManually = isVisible !== null;
    const [visible, setVisible] = react.useState(false);
    const [opacity, setOpacity] = react.useState(0);
    const [focusTrapActive, setFocusTrapActive] = react.useState(Boolean(propWithFocusTrap));
    const transitionTimerRef = react.useRef(null);
    const showTimerRef = react.useRef(null);
    const hideTimerRef = react.useRef(null);
    react.useEffect(() => {
        onMount();
    }, []);
    react.useEffect(() => {
        if (triggerManually) {
            if (isVisible) {
                show();
            }
            else {
                hide();
            }
        }
    }, [isVisible, triggerManually]);
    const show = (withFocusTrap) => {
        onShow();
        if (transitionTimerRef.current) {
            clearTimeout(transitionTimerRef.current);
        }
        if (hideTimerRef.current) {
            clearTimeout(hideTimerRef.current);
        }
        showTimerRef.current = setTimeout(() => {
            setVisible(true);
            setOpacity(1);
            propWithFocusTrap !== false && withFocusTrap && setFocusTrapActive(true);
            onShown();
        }, 0);
    };
    const hide = () => {
        onHide();
        if (showTimerRef.current) {
            clearTimeout(showTimerRef.current);
        }
        hideTimerRef.current = setTimeout(() => {
            setVisible(false);
            setOpacity(0);
            setFocusTrapActive(false);
            transitionTimerRef.current = setTimeout(() => {
                onHidden();
            }, animationDuration);
        }, 0);
    };
    const positionModifiers = {
        top: popover["default"].modifiers.top,
        bottom: popover["default"].modifiers.bottom,
        left: popover["default"].modifiers.left,
        right: popover["default"].modifiers.right,
        'top-start': popover["default"].modifiers.topLeft,
        'top-end': popover["default"].modifiers.topRight,
        'bottom-start': popover["default"].modifiers.bottomLeft,
        'bottom-end': popover["default"].modifiers.bottomRight,
        'left-start': popover["default"].modifiers.leftTop,
        'left-end': popover["default"].modifiers.leftBottom,
        'right-start': popover["default"].modifiers.rightTop,
        'right-end': popover["default"].modifiers.rightBottom
    };
    const hasCustomMinWidth = minWidth !== esm_c_popover_MinWidth.value;
    const hasCustomMaxWidth = maxWidth !== esm_c_popover_MaxWidth.value;
    const onDocumentKeyDown = (event) => {
        if (event.key === KeyTypes.Escape && visible) {
            if (triggerManually) {
                shouldClose(null, hide, event);
            }
            else {
                hide();
            }
        }
    };
    const onDocumentClick = (event, triggerElement, popperElement) => {
        if (hideOnOutsideClick && visible) {
            // check if we clicked within the popper, if so don't do anything
            const isChild = popperElement && popperElement.contains(event.target);
            if (isChild) {
                // clicked within the popper
                return;
            }
            if (triggerManually) {
                shouldClose(null, hide, event);
            }
            else {
                hide();
            }
        }
    };
    const onTriggerClick = (event) => {
        if (triggerManually) {
            if (visible) {
                shouldClose(null, hide, event);
            }
            else {
                shouldOpen(show, event);
            }
        }
        else {
            if (visible) {
                hide();
            }
            else {
                show(true);
            }
        }
    };
    const onContentMouseDown = () => {
        if (focusTrapActive) {
            setFocusTrapActive(false);
        }
    };
    const closePopover = (event) => {
        event.stopPropagation();
        if (triggerManually) {
            shouldClose(null, hide, event);
        }
        else {
            hide();
        }
    };
    const content = (react.createElement(FocusTrap, Object.assign({ active: focusTrapActive, focusTrapOptions: {
            returnFocusOnDeactivate: true,
            clickOutsideDeactivates: true,
            tabbableOptions: { displayCheck: 'none' },
            fallbackFocus: () => {
                // If the popover's trigger is focused but scrolled out of view,
                // FocusTrap will throw an error when the Enter button is used on the trigger.
                // That is because the Popover is hidden when its trigger is out of view.
                // Provide a fallback in that case.
                let node = null;
                if (document && document.activeElement) {
                    node = document.activeElement;
                }
                return node;
            }
        }, preventScrollOnDeactivate: true, className: (0,esm.css)(popover["default"].popover, alertSeverityVariant && alertStyle[alertSeverityVariant], hasNoPadding && popover["default"].modifiers.noPadding, hasAutoWidth && popover["default"].modifiers.widthAuto, className), role: "dialog", "aria-modal": "true", "aria-label": headerContent ? undefined : ariaLabel, "aria-labelledby": headerContent ? `popover-${uniqueId}-header` : undefined, "aria-describedby": `popover-${uniqueId}-body`, onMouseDown: onContentMouseDown, style: {
            minWidth: hasCustomMinWidth ? minWidth : null,
            maxWidth: hasCustomMaxWidth ? maxWidth : null,
            opacity,
            transition: getOpacityTransition(animationDuration)
        } }, rest),
        react.createElement(PopoverArrow, null),
        react.createElement(PopoverContent, null,
            showClose && react.createElement(PopoverCloseButton, { onClose: closePopover, "aria-label": closeBtnAriaLabel }),
            headerContent && (react.createElement(PopoverHeader, { id: `popover-${uniqueId}-header`, icon: headerIcon, alertSeverityVariant: alertSeverityVariant, alertSeverityScreenReaderText: alertSeverityScreenReaderText || `${alertSeverityVariant} alert:`, titleHeadingLevel: headerComponent }, typeof headerContent === 'function' ? headerContent(hide) : headerContent)),
            react.createElement(PopoverBody, { id: `popover-${uniqueId}-body` }, typeof bodyContent === 'function' ? bodyContent(hide) : bodyContent),
            footerContent && (react.createElement(PopoverFooter, { id: `popover-${uniqueId}-footer` }, typeof footerContent === 'function' ? footerContent(hide) : footerContent)))));
    return (react.createElement(PopoverContext.Provider, { value: { headerComponent } },
        react.createElement(Popper_Popper, { trigger: children, reference: reference, popper: content, popperMatchesTriggerWidth: false, appendTo: appendTo, isVisible: visible, positionModifiers: positionModifiers, distance: distance, placement: position, onTriggerClick: onTriggerClick, onDocumentClick: onDocumentClick, onDocumentKeyDown: onDocumentKeyDown, enableFlip: enableFlip, zIndex: zIndex, flipBehavior: flipBehavior, removeFindDomNode: removeFindDomNode })));
};
Popover.displayName = 'Popover';
//# sourceMappingURL=Popover.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/copy-icon.js


const CopyIconConfig = {
  name: 'CopyIcon',
  height: 512,
  width: 448,
  svgPath: 'M320 448v40c0 13.255-10.745 24-24 24H24c-13.255 0-24-10.745-24-24V120c0-13.255 10.745-24 24-24h72v296c0 30.879 25.121 56 56 56h168zm0-344V0H152c-13.255 0-24 10.745-24 24v368c0 13.255 10.745 24 24 24h272c13.255 0 24-10.745 24-24V128H344c-13.2 0-24-10.8-24-24zm120.971-31.029L375.029 7.029A24 24 0 0 0 358.059 0H352v96h96v-6.059a24 24 0 0 0-7.029-16.97z',
  yOffset: 0,
  xOffset: 0,
};

const CopyIcon = createIcon(CopyIconConfig);

/* harmony default export */ const copy_icon = (CopyIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyButton.js





const ClipboardCopyButton = (_a) => {
    var { onClick, exitDelay = 0, entryDelay = 300, maxWidth = '100px', position = 'top', 'aria-label': ariaLabel = 'Copyable input', id, textId, children, variant = 'control', onTooltipHidden = () => { }, removeFindDomNode = false } = _a, props = (0,tslib_es6.__rest)(_a, ["onClick", "exitDelay", "entryDelay", "maxWidth", "position", 'aria-label', "id", "textId", "children", "variant", "onTooltipHidden", "removeFindDomNode"]);
    return (react.createElement(Tooltip, { trigger: "mouseenter focus click", exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, "aria-live": "polite", aria: "none", content: react.createElement("div", null, children), onTooltipHidden: onTooltipHidden, removeFindDomNode: removeFindDomNode },
        react.createElement(Button, Object.assign({ type: "button", variant: variant, onClick: onClick, "aria-label": ariaLabel, id: id, "aria-labelledby": `${id} ${textId}` }, props),
            react.createElement(copy_icon, null))));
};
ClipboardCopyButton.displayName = 'ClipboardCopyButton';
//# sourceMappingURL=ClipboardCopyButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/angle-down-icon.js


const AngleDownIconConfig = {
  name: 'AngleDownIcon',
  height: 512,
  width: 320,
  svgPath: 'M143 352.3L7 216.3c-9.4-9.4-9.4-24.6 0-33.9l22.6-22.6c9.4-9.4 24.6-9.4 33.9 0l96.4 96.4 96.4-96.4c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9l-136 136c-9.2 9.4-24.4 9.4-33.8 0z',
  yOffset: 0,
  xOffset: 0,
};

const AngleDownIcon = createIcon(AngleDownIconConfig);

/* harmony default export */ const angle_down_icon = (AngleDownIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyToggle.js





const ClipboardCopyToggle = (_a) => {
    var { onClick, id, textId, contentId, isExpanded = false } = _a, props = (0,tslib_es6.__rest)(_a, ["onClick", "id", "textId", "contentId", "isExpanded"]);
    return (react.createElement(Button, Object.assign({ type: "button", variant: "control", onClick: onClick, id: id, "aria-labelledby": `${id} ${textId}`, "aria-controls": `${id} ${contentId}`, "aria-expanded": isExpanded }, props), isExpanded ? react.createElement(angle_down_icon, { "aria-hidden": "true" }) : react.createElement(angle_right_icon, { "aria-hidden": "true" })));
};
ClipboardCopyToggle.displayName = 'ClipboardCopyToggle';
//# sourceMappingURL=ClipboardCopyToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyExpanded.js




class ClipboardCopyExpanded extends react.Component {
    constructor(props) {
        super(props);
    }
    render() {
        const _a = this.props, { className, children, onChange, isReadOnly, isCode } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "onChange", "isReadOnly", "isCode"]);
        return (react.createElement("div", Object.assign({ suppressContentEditableWarning: true, className: (0,esm.css)(clipboard_copy["default"].clipboardCopyExpandableContent, className), onInput: (e) => onChange(e.target.innerText, e), contentEditable: !isReadOnly }, props), isCode ? react.createElement("pre", null, children) : children));
    }
}
ClipboardCopyExpanded.displayName = 'ClipboardCopyExpanded';
ClipboardCopyExpanded.defaultProps = {
    onChange: () => undefined,
    className: '',
    isReadOnly: false,
    isCode: false
};
//# sourceMappingURL=ClipboardCopyExpanded.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopy.js











const clipboardCopyFunc = (event, text) => {
    navigator.clipboard.writeText(text.toString());
};
var ClipboardCopyVariant;
(function (ClipboardCopyVariant) {
    ClipboardCopyVariant["inline"] = "inline";
    ClipboardCopyVariant["expansion"] = "expansion";
    ClipboardCopyVariant["inlineCompact"] = "inline-compact";
})(ClipboardCopyVariant || (ClipboardCopyVariant = {}));
class ClipboardCopy extends react.Component {
    constructor(props) {
        super(props);
        this.timer = null;
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        this.componentDidUpdate = (prevProps, prevState) => {
            if (prevProps.children !== this.props.children) {
                this.updateText(this.props.children);
            }
        };
        this.componentWillUnmount = () => {
            if (this.timer) {
                window.clearTimeout(this.timer);
            }
        };
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        this.expandContent = (_event) => {
            this.setState(prevState => ({
                expanded: !prevState.expanded
            }));
        };
        this.updateText = (text) => {
            this.setState({ text });
            this.props.onChange(text);
        };
        this.render = () => {
            const _a = this.props, { 
            /* eslint-disable @typescript-eslint/no-unused-vars */
            isExpanded, onChange, // Don't pass to <div>
            switchDelay, 
            /* eslint-enable @typescript-eslint/no-unused-vars */
            isReadOnly, isCode, isBlock, exitDelay, maxWidth, entryDelay, onCopy, hoverTip, clickTip, textAriaLabel, toggleAriaLabel, variant, position, className, additionalActions, ouiaId, ouiaSafe, removeFindDomNode } = _a, divProps = (0,tslib_es6.__rest)(_a, ["isExpanded", "onChange", "switchDelay", "isReadOnly", "isCode", "isBlock", "exitDelay", "maxWidth", "entryDelay", "onCopy", "hoverTip", "clickTip", "textAriaLabel", "toggleAriaLabel", "variant", "position", "className", "additionalActions", "ouiaId", "ouiaSafe", "removeFindDomNode"]);
            const textIdPrefix = 'text-input-';
            const toggleIdPrefix = 'toggle-';
            const contentIdPrefix = 'content-';
            return (react.createElement("div", Object.assign({ className: (0,esm.css)(clipboard_copy["default"].clipboardCopy, variant === 'inline-compact' && clipboard_copy["default"].modifiers.inline, isBlock && clipboard_copy["default"].modifiers.block, this.state.expanded && clipboard_copy["default"].modifiers.expanded, className) }, divProps, getOUIAProps(ClipboardCopy.displayName, ouiaId, ouiaSafe)),
                variant === 'inline-compact' && (react.createElement(GenerateId, { prefix: "" }, id => (react.createElement(react.Fragment, null,
                    !isCode && (react.createElement("span", { className: (0,esm.css)(clipboard_copy["default"].clipboardCopyText), id: `${textIdPrefix}${id}` }, this.state.text)),
                    isCode && (react.createElement("code", { className: (0,esm.css)(clipboard_copy["default"].clipboardCopyText, clipboard_copy["default"].modifiers.code), id: `${textIdPrefix}${id}` }, this.state.text)),
                    react.createElement("span", { className: (0,esm.css)(clipboard_copy["default"].clipboardCopyActions) },
                        react.createElement("span", { className: (0,esm.css)(clipboard_copy["default"].clipboardCopyActionsItem) },
                            react.createElement(ClipboardCopyButton, { variant: "plain", exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, id: `copy-button-${id}`, textId: `text-input-${id}`, "aria-label": hoverTip, onClick: (event) => {
                                    onCopy(event, this.state.text);
                                    this.setState({ copied: true });
                                }, onTooltipHidden: () => this.setState({ copied: false }) }, this.state.copied ? clickTip : hoverTip)),
                        additionalActions && additionalActions))))),
                variant !== 'inline-compact' && (react.createElement(GenerateId, { prefix: "" }, id => (react.createElement(react.Fragment, null,
                    react.createElement("div", { className: (0,esm.css)(clipboard_copy["default"].clipboardCopyGroup) },
                        variant === 'expansion' && (react.createElement(ClipboardCopyToggle, { isExpanded: this.state.expanded, onClick: this.expandContent, id: `${toggleIdPrefix}${id}`, textId: `${textIdPrefix}${id}`, contentId: `${contentIdPrefix}${id}`, "aria-label": toggleAriaLabel })),
                        react.createElement(TextInput, { isReadOnly: isReadOnly || this.state.expanded, onChange: this.updateText, value: this.state.text, id: `text-input-${id}`, "aria-label": textAriaLabel }),
                        react.createElement(ClipboardCopyButton, { exitDelay: exitDelay, entryDelay: entryDelay, maxWidth: maxWidth, position: position, id: `copy-button-${id}`, textId: `text-input-${id}`, "aria-label": hoverTip, onClick: (event) => {
                                onCopy(event, this.state.text);
                                this.setState({ copied: true });
                            }, onTooltipHidden: () => this.setState({ copied: false }), removeFindDomNode: removeFindDomNode }, this.state.copied ? clickTip : hoverTip)),
                    this.state.expanded && (react.createElement(ClipboardCopyExpanded, { isReadOnly: isReadOnly, isCode: isCode, id: `content-${id}`, onChange: this.updateText }, this.state.text))))))));
        };
        this.state = {
            text: Array.isArray(this.props.children)
                ? this.props.children.join('')
                : this.props.children,
            expanded: this.props.isExpanded,
            copied: false
        };
        if (this.props.switchDelay !== undefined) {
            // eslint-disable-next-line no-console
            console.warn('ClipboardCopy: switchDelay prop has been deprecated. ' +
                'The tooltip message will switch back to the hover tip as soon as the tooltip is hidden.');
        }
    }
}
ClipboardCopy.displayName = 'ClipboardCopy';
ClipboardCopy.defaultProps = {
    hoverTip: 'Copy to clipboard',
    clickTip: 'Successfully copied to clipboard!',
    isReadOnly: false,
    isExpanded: false,
    isCode: false,
    variant: 'inline',
    position: PopoverPosition.top,
    maxWidth: '150px',
    exitDelay: 1500,
    entryDelay: 300,
    onCopy: clipboardCopyFunc,
    onChange: () => undefined,
    textAriaLabel: 'Copyable input',
    toggleAriaLabel: 'Show content',
    additionalActions: null,
    ouiaSafe: true,
    removeFindDomNode: false
};
//# sourceMappingURL=ClipboardCopy.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/ClipboardCopyAction.js




const ClipboardCopyAction = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(clipboard_copy["default"].clipboardCopyActionsItem, className) }, props), children));
};
ClipboardCopyAction.displayName = 'ClipboardCopyAction';
//# sourceMappingURL=ClipboardCopyAction.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ClipboardCopy/index.js



//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/CodeBlock/code-block.js
var code_block = __webpack_require__(42564);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlock.js




const CodeBlock = (_a) => {
    var { children = null, className, actions = null } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "actions"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(code_block/* default */.Z.codeBlock, className) }, props),
        react.createElement("div", { className: (0,esm.css)(code_block/* default */.Z.codeBlockHeader) },
            react.createElement("div", { className: (0,esm.css)(code_block/* default */.Z.codeBlockActions) }, actions && actions)),
        react.createElement("div", { className: (0,esm.css)(code_block/* default */.Z.codeBlockContent) }, children)));
};
CodeBlock.displayName = 'CodeBlock';
//# sourceMappingURL=CodeBlock.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlockCode.js




const CodeBlockCode = (_a) => {
    var { children = null, className, codeClassName } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "codeClassName"]);
    return (react.createElement("pre", Object.assign({ className: (0,esm.css)(code_block/* default */.Z.codeBlockPre, className) }, props),
        react.createElement("code", { className: (0,esm.css)(code_block/* default */.Z.codeBlockCode, codeClassName) }, children)));
};
CodeBlockCode.displayName = 'CodeBlockCode';
//# sourceMappingURL=CodeBlockCode.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/CodeBlockAction.js



const CodeBlockAction = (_a) => {
    var { children = null, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)('pf-c-code-block__actions-item', className) }, props), children));
};
CodeBlockAction.displayName = 'CodeBlockAction';
//# sourceMappingURL=CodeBlockAction.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/CodeBlock/index.js



//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/ContextSelector/context-selector.js
var context_selector = __webpack_require__(70388);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/search-icon.js


const SearchIconConfig = {
  name: 'SearchIcon',
  height: 512,
  width: 512,
  svgPath: 'M505 442.7L405.3 343c-4.5-4.5-10.6-7-17-7H372c27.6-35.3 44-79.7 44-128C416 93.1 322.9 0 208 0S0 93.1 0 208s93.1 208 208 208c48.3 0 92.7-16.4 128-44v16.3c0 6.4 2.5 12.5 7 17l99.7 99.7c9.4 9.4 24.6 9.4 33.9 0l28.3-28.3c9.4-9.4 9.4-24.6.1-34zM208 336c-70.7 0-128-57.2-128-128 0-70.7 57.2-128 128-128 70.7 0 128 57.2 128 128 0 70.7-57.2 128-128 128z',
  yOffset: 0,
  xOffset: 0,
};

const SearchIcon = createIcon(SearchIconConfig);

/* harmony default export */ const search_icon = (SearchIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/ContextSelectorToggle.js






class ContextSelectorToggle extends react.Component {
    constructor() {
        super(...arguments);
        this.toggle = react.createRef();
        this.componentDidMount = () => {
            document.addEventListener('mousedown', this.onDocClick);
            document.addEventListener('touchstart', this.onDocClick);
            document.addEventListener('keydown', this.onEscPress);
        };
        this.componentWillUnmount = () => {
            document.removeEventListener('mousedown', this.onDocClick);
            document.removeEventListener('touchstart', this.onDocClick);
            document.removeEventListener('keydown', this.onEscPress);
        };
        this.onDocClick = (event) => {
            const { isOpen, parentRef, onToggle } = this.props;
            if (isOpen && (parentRef === null || parentRef === void 0 ? void 0 : parentRef.current) && !parentRef.current.contains(event.target)) {
                onToggle(null, false);
                this.toggle.current.focus();
            }
        };
        this.onEscPress = (event) => {
            const { isOpen, onToggle } = this.props;
            if (isOpen && event.key === KeyTypes.Escape) {
                onToggle(null, false);
                this.toggle.current.focus();
            }
        };
        this.onKeyDown = (event) => {
            const { isOpen, onToggle, onEnter } = this.props;
            if ((event.key === KeyTypes.Tab && !isOpen) || event.key !== KeyTypes.Enter) {
                return;
            }
            event.preventDefault();
            if ((event.key === KeyTypes.Tab || event.key === KeyTypes.Enter || event.key !== KeyTypes.Space) && isOpen) {
                onToggle(null, !isOpen);
            }
            else if ((event.key === KeyTypes.Enter || event.key === ' ') && !isOpen) {
                onToggle(null, !isOpen);
                onEnter();
            }
        };
    }
    render() {
        const _a = this.props, { className, toggleText, isOpen, onToggle, id, isPlain, isText, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        isActive, onEnter, parentRef } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        props = (0,tslib_es6.__rest)(_a, ["className", "toggleText", "isOpen", "onToggle", "id", "isPlain", "isText", "isActive", "onEnter", "parentRef"]);
        return (react.createElement("button", Object.assign({}, props, { id: id, ref: this.toggle, className: (0,esm.css)(context_selector/* default */.Z.contextSelectorToggle, isActive && context_selector/* default */.Z.modifiers.active, isPlain && context_selector/* default */.Z.modifiers.plain, isText && context_selector/* default */.Z.modifiers.text, className), type: "button", onClick: event => onToggle(event, !isOpen), "aria-expanded": isOpen, onKeyDown: this.onKeyDown }),
            react.createElement("span", { className: (0,esm.css)(context_selector/* default */.Z.contextSelectorToggleText) }, toggleText),
            react.createElement("span", { className: (0,esm.css)(context_selector/* default */.Z.contextSelectorToggleIcon) },
                react.createElement(caret_down_icon, { "aria-hidden": true }))));
    }
}
ContextSelectorToggle.displayName = 'ContextSelectorToggle';
ContextSelectorToggle.defaultProps = {
    className: '',
    toggleText: '',
    isOpen: false,
    onEnter: () => undefined,
    parentRef: null,
    isActive: false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToggle: (event, value) => undefined
};
//# sourceMappingURL=ContextSelectorToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/ContextSelectorMenuList.js




class ContextSelectorMenuList extends react.Component {
    constructor() {
        super(...arguments);
        this.refsCollection = [];
        this.sendRef = (index, ref) => {
            this.refsCollection[index] = ref;
        };
        this.render = () => {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            const _a = this.props, { className, isOpen, children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "isOpen", "children"]);
            return (react.createElement("ul", Object.assign({ className: (0,esm.css)(context_selector/* default */.Z.contextSelectorMenuList, className), hidden: !isOpen, role: "menu" }, props), this.extendChildren()));
        };
    }
    extendChildren() {
        return react.Children.map(this.props.children, (child, index) => react.cloneElement(child, {
            sendRef: this.sendRef,
            index,
            role: 'menuitem'
        }));
    }
}
ContextSelectorMenuList.displayName = 'ContextSelectorMenuList';
ContextSelectorMenuList.defaultProps = {
    children: null,
    className: '',
    isOpen: true
};
//# sourceMappingURL=ContextSelectorMenuList.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/contextSelectorConstants.js

const ContextSelectorContext = react.createContext({
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onSelect: (event, value) => undefined
});
//# sourceMappingURL=contextSelectorConstants.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/ContextSelector.js















class ContextSelector extends react.Component {
    constructor(props) {
        super(props);
        this.parentRef = react.createRef();
        this.popperRef = react.createRef();
        this.onEnterPressed = (event) => {
            if (event.key === KeyTypes.Enter) {
                this.props.onSearchButtonClick();
            }
        };
        this.state = {
            ouiaStateId: getDefaultOUIAId(ContextSelector.displayName)
        };
    }
    render() {
        const _a = this.props, { children, className, isOpen, isFullHeight, onToggle, onSelect, screenReaderLabel, toggleText, searchButtonAriaLabel, searchInputValue, onSearchInputChange, searchInputPlaceholder, onSearchButtonClick, menuAppendTo, ouiaId, ouiaSafe, isPlain, isText, footer, disableFocusTrap, isFlipEnabled, id, removeFindDomNode, zIndex } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "isOpen", "isFullHeight", "onToggle", "onSelect", "screenReaderLabel", "toggleText", "searchButtonAriaLabel", "searchInputValue", "onSearchInputChange", "searchInputPlaceholder", "onSearchButtonClick", "menuAppendTo", "ouiaId", "ouiaSafe", "isPlain", "isText", "footer", "disableFocusTrap", "isFlipEnabled", "id", "removeFindDomNode", "zIndex"]);
        const uniqueId = id || getUniqueId();
        const toggleId = `pf-context-selector-toggle-id-${uniqueId}`;
        const screenReaderLabelId = `pf-context-selector-label-id-${uniqueId}`;
        const isStatic = isFlipEnabled && menuAppendTo !== 'inline';
        const menuContainer = (react.createElement("div", { className: (0,esm.css)(context_selector/* default */.Z.contextSelectorMenu, isStatic && context_selector/* default */.Z.modifiers.static), id: uniqueId }, isOpen && (react.createElement(FocusTrap, { active: !disableFocusTrap, focusTrapOptions: { clickOutsideDeactivates: true, tabbableOptions: { displayCheck: 'none' } } },
            react.createElement("div", { className: (0,esm.css)(context_selector/* default */.Z.contextSelectorMenuSearch) },
                react.createElement(InputGroup, null,
                    react.createElement(TextInput, { value: searchInputValue, type: "search", placeholder: searchInputPlaceholder, onChange: onSearchInputChange, onKeyPress: this.onEnterPressed, "aria-label": searchButtonAriaLabel }),
                    react.createElement(Button, { variant: ButtonVariant.control, "aria-label": searchButtonAriaLabel, onClick: onSearchButtonClick },
                        react.createElement(search_icon, { "aria-hidden": "true" })))),
            react.createElement(ContextSelectorContext.Provider, { value: { onSelect } },
                react.createElement(ContextSelectorMenuList, { isOpen: isOpen }, children)),
            footer))));
        const popperContainer = (react.createElement("div", Object.assign({ className: (0,esm.css)(context_selector/* default */.Z.contextSelector, isOpen && context_selector/* default */.Z.modifiers.expanded, className), ref: this.popperRef }, props), isOpen && menuContainer));
        const mainContainer = (react.createElement("div", Object.assign({ className: (0,esm.css)(context_selector/* default */.Z.contextSelector, isOpen && context_selector/* default */.Z.modifiers.expanded, isFullHeight && context_selector/* default */.Z.modifiers.fullHeight, className), ref: this.parentRef }, getOUIAProps(ContextSelector.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), props),
            screenReaderLabel && (react.createElement("span", { id: screenReaderLabelId, hidden: true }, screenReaderLabel)),
            react.createElement(ContextSelectorToggle, { onToggle: onToggle, isOpen: isOpen, toggleText: toggleText, id: toggleId, parentRef: menuAppendTo === 'inline' ? this.parentRef : this.popperRef, "aria-labelledby": `${screenReaderLabelId} ${toggleId}`, isPlain: isPlain, isText: isText }),
            isOpen && menuAppendTo === 'inline' && menuContainer));
        const getParentElement = () => {
            if (this.parentRef && this.parentRef.current) {
                return this.parentRef.current.parentElement;
            }
            return null;
        };
        return menuAppendTo === 'inline' ? (mainContainer) : (react.createElement(Popper_Popper, { trigger: mainContainer, popper: popperContainer, appendTo: menuAppendTo === 'parent' ? getParentElement() : menuAppendTo, isVisible: isOpen, removeFindDomNode: removeFindDomNode, zIndex: zIndex }));
    }
}
ContextSelector.displayName = 'ContextSelector';
ContextSelector.defaultProps = {
    children: null,
    className: '',
    isOpen: false,
    onToggle: () => undefined,
    onSelect: () => undefined,
    screenReaderLabel: '',
    toggleText: '',
    searchButtonAriaLabel: 'Search menu items',
    searchInputValue: '',
    onSearchInputChange: () => undefined,
    searchInputPlaceholder: 'Search',
    onSearchButtonClick: () => undefined,
    menuAppendTo: 'inline',
    ouiaSafe: true,
    disableFocusTrap: false,
    footer: null,
    isPlain: false,
    isText: false,
    isFlipEnabled: true,
    removeFindDomNode: false,
    zIndex: 9999
};
//# sourceMappingURL=ContextSelector.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/ContextSelectorItem.js





class ContextSelectorItem extends react.Component {
    constructor() {
        super(...arguments);
        this.ref = react.createRef();
    }
    componentDidMount() {
        /* eslint-disable-next-line */
        this.props.sendRef(this.props.index, this.ref.current);
    }
    render() {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _a = this.props, { className, children, onClick, isDisabled, index, sendRef, href } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "onClick", "isDisabled", "index", "sendRef", "href"]);
        const Component = href ? 'a' : 'button';
        const isDisabledLink = href && isDisabled;
        return (react.createElement(ContextSelectorContext.Consumer, null, ({ onSelect }) => (react.createElement("li", { role: "none" },
            react.createElement(Component, Object.assign({ className: (0,esm.css)(context_selector/* default */.Z.contextSelectorMenuListItem, isDisabledLink && context_selector/* default */.Z.modifiers.disabled, className), ref: this.ref, onClick: event => {
                    if (!isDisabled) {
                        onClick(event);
                        onSelect(event, children);
                    }
                }, disabled: isDisabled && !href, href: href }, (isDisabledLink && { 'aria-disabled': true, tabIndex: -1 }), props), children)))));
    }
}
ContextSelectorItem.displayName = 'ContextSelectorItem';
ContextSelectorItem.defaultProps = {
    children: null,
    className: '',
    isDisabled: false,
    onClick: () => undefined,
    index: undefined,
    sendRef: () => { },
    href: null
};
//# sourceMappingURL=ContextSelectorItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/ContextSelectorFooter.js




const ContextSelectorFooter = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({}, props, { className: (0,esm.css)(context_selector/* default */.Z.contextSelectorMenuFooter, className) }), children));
};
ContextSelectorFooter.displayName = 'ContextSelectorFooter';
//# sourceMappingURL=ContextSelectorFooter.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ContextSelector/index.js



//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/DataList/data-list.js
var data_list = __webpack_require__(26922);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/DataList/data-list-grid.js
var data_list_grid = __webpack_require__(8698);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataList.js





const gridBreakpointClasses = {
    none: data_list_grid["default"].modifiers.gridNone,
    always: 'pf-m-grid',
    sm: data_list_grid["default"].modifiers.gridSm,
    md: data_list_grid["default"].modifiers.gridMd,
    lg: data_list_grid["default"].modifiers.gridLg,
    xl: data_list_grid["default"].modifiers.gridXl,
    '2xl': data_list_grid["default"].modifiers.grid_2xl
};
var DataListWrapModifier;
(function (DataListWrapModifier) {
    DataListWrapModifier["nowrap"] = "nowrap";
    DataListWrapModifier["truncate"] = "truncate";
    DataListWrapModifier["breakWord"] = "breakWord";
})(DataListWrapModifier || (DataListWrapModifier = {}));
const DataListContext = react.createContext({
    isSelectable: false
});
const moveItem = (arr, i1, toIndex) => {
    const fromIndex = arr.indexOf(i1);
    if (fromIndex === toIndex) {
        return arr;
    }
    const temp = arr.splice(fromIndex, 1);
    arr.splice(toIndex, 0, temp[0]);
    return arr;
};
class DataList extends react.Component {
    constructor(props) {
        super(props);
        this.dragFinished = false;
        this.html5DragDrop = false;
        this.arrayCopy = react.Children.toArray(this.props.children);
        this.ref = react.createRef();
        this.state = {
            tempItemOrder: [],
            draggedItemId: null,
            draggingToItemIndex: null,
            dragging: false
        };
        this.getIndex = (id) => Array.from(this.ref.current.children).findIndex(item => item.id === id);
        this.move = (itemOrder) => {
            const ulNode = this.ref.current;
            const nodes = Array.from(ulNode.children);
            if (nodes.map(node => node.id).every((id, i) => id === itemOrder[i])) {
                return;
            }
            while (ulNode.firstChild) {
                ulNode.removeChild(ulNode.lastChild);
            }
            itemOrder.forEach(id => {
                ulNode.appendChild(nodes.find(n => n.id === id));
            });
        };
        this.dragStart0 = (el) => {
            const { onDragStart } = this.props;
            const draggedItemId = el.id;
            el.classList.add(data_list["default"].modifiers.ghostRow);
            el.setAttribute('aria-pressed', 'true');
            this.setState({
                draggedItemId,
                dragging: true
            });
            onDragStart && onDragStart(draggedItemId);
        };
        this.dragStart = (evt) => {
            evt.dataTransfer.effectAllowed = 'move';
            evt.dataTransfer.setData('text/plain', evt.currentTarget.id);
            this.dragStart0(evt.currentTarget);
        };
        this.onDragCancel = () => {
            this.move(this.props.itemOrder);
            Array.from(this.ref.current.children).forEach(el => {
                el.classList.remove(data_list["default"].modifiers.ghostRow);
                el.classList.remove(data_list["default"].modifiers.dragOver);
                el.setAttribute('aria-pressed', 'false');
            });
            this.setState({
                draggedItemId: null,
                draggingToItemIndex: null,
                dragging: false
            });
            if (this.props.onDragCancel) {
                this.props.onDragCancel();
            }
        };
        this.dragLeave = (evt) => {
            // This event false fires when we call `this.move()`, so double check we're out of zone
            if (!this.isValidDrop(evt)) {
                this.move(this.props.itemOrder);
                this.setState({
                    draggingToItemIndex: null
                });
            }
        };
        this.dragEnd0 = (el) => {
            el.classList.remove(data_list["default"].modifiers.ghostRow);
            el.classList.remove(data_list["default"].modifiers.dragOver);
            el.setAttribute('aria-pressed', 'false');
            this.setState({
                draggedItemId: null,
                draggingToItemIndex: null,
                dragging: false
            });
        };
        this.dragEnd = (evt) => {
            this.dragEnd0(evt.target);
        };
        this.isValidDrop = (evt) => {
            const ulRect = this.ref.current.getBoundingClientRect();
            return (evt.clientX > ulRect.x &&
                evt.clientX < ulRect.x + ulRect.width &&
                evt.clientY > ulRect.y &&
                evt.clientY < ulRect.y + ulRect.height);
        };
        this.drop = (evt) => {
            if (this.isValidDrop(evt)) {
                this.props.onDragFinish(this.state.tempItemOrder);
            }
            else {
                this.onDragCancel();
            }
        };
        this.dragOver0 = (id) => {
            const draggingToItemIndex = Array.from(this.ref.current.children).findIndex(item => item.id === id);
            if (draggingToItemIndex !== this.state.draggingToItemIndex) {
                const tempItemOrder = moveItem([...this.props.itemOrder], this.state.draggedItemId, draggingToItemIndex);
                this.move(tempItemOrder);
                this.setState({
                    draggingToItemIndex,
                    tempItemOrder
                });
            }
        };
        this.dragOver = (evt) => {
            evt.preventDefault();
            const curListItem = evt.target.closest('li');
            if (!curListItem || !this.ref.current.contains(curListItem) || curListItem.id === this.state.draggedItemId) {
                // We're going nowhere, don't bother calling `dragOver0`
                return null;
            }
            else {
                this.dragOver0(curListItem.id);
            }
        };
        this.handleDragButtonKeys = (evt) => {
            const { dragging } = this.state;
            if (![' ', 'Escape', 'Enter', 'ArrowUp', 'ArrowDown'].includes(evt.key) || !this.html5DragDrop) {
                if (dragging) {
                    evt.preventDefault();
                }
                return;
            }
            evt.preventDefault();
            const dragItem = evt.target.closest('li');
            if (evt.key === ' ' || (evt.key === 'Enter' && !dragging)) {
                this.dragStart0(dragItem);
            }
            else if (dragging) {
                if (evt.key === 'Escape' || evt.key === 'Enter') {
                    this.setState({
                        dragging: false
                    });
                    this.dragFinished = true;
                    if (evt.key === 'Enter') {
                        this.dragEnd0(dragItem);
                        this.props.onDragFinish(this.state.tempItemOrder);
                    }
                    else {
                        this.onDragCancel();
                    }
                }
                else if (evt.key === 'ArrowUp') {
                    const nextSelection = dragItem.previousSibling;
                    if (nextSelection) {
                        this.dragOver0(nextSelection.id);
                        dragItem.querySelector(`.${data_list["default"].dataListItemDraggableButton}`).focus();
                    }
                }
                else if (evt.key === 'ArrowDown') {
                    const nextSelection = dragItem.nextSibling;
                    if (nextSelection) {
                        this.dragOver0(nextSelection.id);
                        dragItem.querySelector(`.${data_list["default"].dataListItemDraggableButton}`).focus();
                    }
                }
            }
        };
        this.html5DragDrop = Boolean(props.onDragFinish || props.onDragStart || props.onDragMove || props.onDragCancel);
        if (this.html5DragDrop) {
            // eslint-disable-next-line no-console
            console.warn("DataList's onDrag API is deprecated. Use DragDrop instead.");
        }
    }
    componentDidUpdate(oldProps) {
        if (this.dragFinished) {
            this.dragFinished = false;
            this.setState({
                tempItemOrder: [...this.props.itemOrder],
                draggedItemId: null,
                dragging: false
            });
        }
        if (oldProps.itemOrder !== this.props.itemOrder) {
            this.move(this.props.itemOrder);
        }
    }
    render() {
        const _a = this.props, { className, children, onSelectDataListItem, selectedDataListItemId, isCompact, wrapModifier, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onDragStart, onDragMove, onDragCancel, onDragFinish, gridBreakpoint, itemOrder, selectableRow } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        props = (0,tslib_es6.__rest)(_a, ["className", "children", "onSelectDataListItem", "selectedDataListItemId", "isCompact", "wrapModifier", "onDragStart", "onDragMove", "onDragCancel", "onDragFinish", "gridBreakpoint", "itemOrder", "selectableRow"]);
        const { dragging } = this.state;
        const isSelectable = onSelectDataListItem !== undefined;
        const updateSelectedDataListItem = (id) => {
            onSelectDataListItem(id);
        };
        const dragProps = this.html5DragDrop && {
            onDragOver: this.dragOver,
            onDrop: this.dragOver,
            onDragLeave: this.dragLeave
        };
        return (react.createElement(DataListContext.Provider, { value: {
                isSelectable,
                selectedDataListItemId,
                updateSelectedDataListItem,
                selectableRow,
                isDraggable: this.html5DragDrop,
                dragStart: this.dragStart,
                dragEnd: this.dragEnd,
                drop: this.drop,
                dragKeyHandler: this.handleDragButtonKeys
            } },
            react.createElement("ul", Object.assign({ className: (0,esm.css)(data_list["default"].dataList, isCompact && data_list["default"].modifiers.compact, gridBreakpointClasses[gridBreakpoint], wrapModifier && data_list["default"].modifiers[wrapModifier], dragging && data_list["default"].modifiers.dragOver, className), style: props.style }, props, dragProps, { ref: this.ref }), children)));
    }
}
DataList.displayName = 'DataList';
DataList.defaultProps = {
    children: null,
    className: '',
    selectedDataListItemId: '',
    isCompact: false,
    gridBreakpoint: 'md',
    wrapModifier: null
};
//# sourceMappingURL=DataList.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListAction.js





const DataListAction = (_a) => {
    var { children, className, visibility, 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    id, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledBy, isPlainButtonAction } = _a, 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    props = (0,tslib_es6.__rest)(_a, ["children", "className", "visibility", "id", 'aria-label', 'aria-labelledby', "isPlainButtonAction"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(data_list["default"].dataListItemAction, formatBreakpointMods(visibility, data_list["default"]), className) }, props), isPlainButtonAction ? react.createElement("div", { className: (0,esm.css)(data_list["default"].dataListAction) }, children) : children));
};
DataListAction.displayName = 'DataListAction';
//# sourceMappingURL=DataListAction.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListCell.js




const DataListCell = (_a) => {
    var { children = null, className = '', width = 1, isFilled = true, alignRight = false, isIcon = false, wrapModifier = null } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "width", "isFilled", "alignRight", "isIcon", "wrapModifier"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(data_list["default"].dataListCell, width > 1 && data_list["default"].modifiers[`flex_${width}`], !isFilled && data_list["default"].modifiers.noFill, alignRight && data_list["default"].modifiers.alignRight, isIcon && data_list["default"].modifiers.icon, className, wrapModifier && data_list["default"].modifiers[wrapModifier]) }, props), children));
};
DataListCell.displayName = 'DataListCell';
//# sourceMappingURL=DataListCell.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListCheck.js




const DataListCheck = (_a) => {
    var { className = '', 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onChange = (checked, event) => { }, isValid = true, isDisabled = false, isChecked = false, checked = false, defaultChecked, otherControls = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "onChange", "isValid", "isDisabled", "isChecked", "checked", "defaultChecked", "otherControls"]);
    const check = (react.createElement("div", { className: (0,esm.css)(data_list["default"].dataListCheck) },
        react.createElement("input", Object.assign({}, props, { type: "checkbox", onChange: event => onChange(event.currentTarget.checked, event), "aria-invalid": !isValid, disabled: isDisabled }, ([true, false].includes(defaultChecked) && { defaultChecked }), (![true, false].includes(defaultChecked) && { checked: isChecked || checked })))));
    return (react.createElement(react.Fragment, null,
        !otherControls && react.createElement("div", { className: (0,esm.css)(data_list["default"].dataListItemControl, className) }, check),
        otherControls && check));
};
DataListCheck.displayName = 'DataListCheck';
//# sourceMappingURL=DataListCheck.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListControl.js




const DataListControl = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(data_list["default"].dataListItemControl, className) }, props), children));
};
DataListControl.displayName = 'DataListControl';
//# sourceMappingURL=DataListControl.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/grip-vertical-icon.js


const GripVerticalIconConfig = {
  name: 'GripVerticalIcon',
  height: 512,
  width: 320,
  svgPath: 'M96 32H32C14.33 32 0 46.33 0 64v64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32zm0 160H32c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-64c0-17.67-14.33-32-32-32zm0 160H32c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-64c0-17.67-14.33-32-32-32zM288 32h-64c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32V64c0-17.67-14.33-32-32-32zm0 160h-64c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-64c0-17.67-14.33-32-32-32zm0 160h-64c-17.67 0-32 14.33-32 32v64c0 17.67 14.33 32 32 32h64c17.67 0 32-14.33 32-32v-64c0-17.67-14.33-32-32-32z',
  yOffset: 0,
  xOffset: 0,
};

const GripVerticalIcon = createIcon(GripVerticalIconConfig);

/* harmony default export */ const grip_vertical_icon = (GripVerticalIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListDragButton.js






const DataListDragButton = (_a) => {
    var { className = '', isDisabled = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "isDisabled"]);
    return (react.createElement(DataListContext.Consumer, null, ({ dragKeyHandler }) => (react.createElement("button", Object.assign({ className: (0,esm.css)(data_list["default"].dataListItemDraggableButton, isDisabled && data_list["default"].modifiers.disabled, className), onKeyDown: dragKeyHandler, type: "button", disabled: isDisabled }, props),
        react.createElement("span", { className: (0,esm.css)(data_list["default"].dataListItemDraggableIcon) },
            react.createElement(grip_vertical_icon, null))))));
};
DataListDragButton.displayName = 'DataListDragButton';
//# sourceMappingURL=DataListDragButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListItem.js







function findDataListDragButton(node) {
    if (!react.isValidElement(node)) {
        return null;
    }
    if (node.type === DataListDragButton) {
        return node;
    }
    if (node.props.children) {
        for (const child of react.Children.toArray(node.props.children)) {
            const button = findDataListDragButton(child);
            if (button) {
                return button;
            }
        }
    }
    return null;
}
class DataListItem extends react.Component {
    render() {
        const _a = this.props, { children, isExpanded, className, id, 'aria-labelledby': ariaLabelledBy, selectableInputAriaLabel } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "isExpanded", "className", "id", 'aria-labelledby', "selectableInputAriaLabel"]);
        return (react.createElement(DataListContext.Consumer, null, ({ isSelectable, selectedDataListItemId, updateSelectedDataListItem, selectableRow, isDraggable, dragStart, dragEnd, drop }) => {
            const selectDataListItem = (event) => {
                let target = event.target;
                while (event.currentTarget !== target) {
                    if (('onclick' in target && target.onclick) ||
                        target.parentNode.classList.contains(data_list["default"].dataListItemAction) ||
                        target.parentNode.classList.contains(data_list["default"].dataListItemControl)) {
                        // check other event handlers are not present.
                        return;
                    }
                    else {
                        target = target.parentNode;
                    }
                }
                updateSelectedDataListItem(id);
            };
            const onKeyDown = (event) => {
                if (event.key === KeyTypes.Enter) {
                    updateSelectedDataListItem(id);
                }
            };
            // We made the DataListDragButton determine if the entire item is draggable instead of
            // DataListItem like we should have.
            // Recursively search children for the DataListDragButton and see if it's disabled...
            const dragButton = findDataListDragButton(children);
            const dragProps = isDraggable && {
                draggable: dragButton ? !dragButton.props.isDisabled : true,
                onDrop: drop,
                onDragEnd: dragEnd,
                onDragStart: dragStart
            };
            const isSelected = selectedDataListItemId === id;
            const selectableInputAriaProps = selectableInputAriaLabel
                ? { 'aria-label': selectableInputAriaLabel }
                : { 'aria-labelledby': ariaLabelledBy };
            return (react.createElement("li", Object.assign({ id: id, className: (0,esm.css)(data_list["default"].dataListItem, isExpanded && data_list["default"].modifiers.expanded, isSelectable && data_list["default"].modifiers.selectable, selectedDataListItemId && isSelected && data_list["default"].modifiers.selected, className), "aria-labelledby": ariaLabelledBy }, (isSelectable && { tabIndex: 0, onClick: selectDataListItem, onKeyDown }), (isSelectable && isSelected && { 'aria-selected': true }), props, dragProps),
                selectableRow && (react.createElement("input", Object.assign({ className: "pf-screen-reader", type: "radio", checked: isSelected, onChange: event => selectableRow.onChange(id, event), tabIndex: -1 }, selectableInputAriaProps))),
                react.Children.map(children, child => react.isValidElement(child) &&
                    react.cloneElement(child, {
                        rowid: ariaLabelledBy
                    }))));
        }));
    }
}
DataListItem.displayName = 'DataListItem';
DataListItem.defaultProps = {
    isExpanded: false,
    className: '',
    id: '',
    children: null,
    'aria-labelledby': ''
};
//# sourceMappingURL=DataListItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListItemCells.js




const DataListItemCells = (_a) => {
    var { className = '', dataListCells, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    rowid = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "dataListCells", "rowid"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(data_list["default"].dataListItemContent, className) }, props), dataListCells));
};
DataListItemCells.displayName = 'DataListItemCells';
//# sourceMappingURL=DataListItemCells.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListItemRow.js




const DataListItemRow = (_a) => {
    var { children, className = '', rowid = '', wrapModifier = null } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "rowid", "wrapModifier"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(data_list["default"].dataListItemRow, className, wrapModifier && data_list["default"].modifiers[wrapModifier]) }, props), react.Children.map(children, child => react.isValidElement(child) &&
        react.cloneElement(child, {
            rowid
        }))));
};
DataListItemRow.displayName = 'DataListItemRow';
//# sourceMappingURL=DataListItemRow.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListToggle.js






const DataListToggle = (_a) => {
    var { className = '', isExpanded = false, 'aria-controls': ariaControls = '', 'aria-label': ariaLabel = 'Details', rowid = '', id, buttonProps } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "isExpanded", 'aria-controls', 'aria-label', "rowid", "id", "buttonProps"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(data_list["default"].dataListItemControl, className) }, props),
        react.createElement("div", { className: (0,esm.css)(data_list["default"].dataListToggle) },
            react.createElement(Button, Object.assign({ id: id, variant: ButtonVariant.plain, "aria-controls": ariaControls !== '' && ariaControls, "aria-label": ariaLabel, "aria-labelledby": ariaLabel !== 'Details' ? null : `${rowid} ${id}`, "aria-expanded": isExpanded }, buttonProps),
                react.createElement("div", { className: (0,esm.css)(data_list["default"].dataListToggleIcon) },
                    react.createElement(angle_right_icon, null))))));
};
DataListToggle.displayName = 'DataListToggle';
//# sourceMappingURL=DataListToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListContent.js




const DataListContent = (_a) => {
    var { className = '', children = null, id = '', isHidden = false, 'aria-label': ariaLabel, hasNoPadding = false, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    rowid = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "id", "isHidden", 'aria-label', "hasNoPadding", "rowid"]);
    return (react.createElement("section", Object.assign({ id: id, className: (0,esm.css)(data_list["default"].dataListExpandableContent, className), hidden: isHidden, "aria-label": ariaLabel }, props),
        react.createElement("div", { className: (0,esm.css)(data_list["default"].dataListExpandableContentBody, hasNoPadding && data_list["default"].modifiers.noPadding) }, children)));
};
DataListContent.displayName = 'DataListContent';
//# sourceMappingURL=DataListContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/DataListText.js





const DataListText = (_a) => {
    var { children = null, className = '', component = 'span', wrapModifier = null, tooltip: tooltipProp = '', onMouseEnter: onMouseEnterProp = () => { } } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component", "wrapModifier", "tooltip", "onMouseEnter"]);
    const Component = component;
    const [tooltip, setTooltip] = react.useState('');
    const onMouseEnter = (event) => {
        if (event.target.offsetWidth < event.target.scrollWidth) {
            setTooltip(tooltipProp || event.target.innerHTML);
        }
        else {
            setTooltip('');
        }
        onMouseEnterProp(event);
    };
    const text = (react.createElement(Component, Object.assign({ onMouseEnter: onMouseEnter, className: (0,esm.css)(className, wrapModifier && data_list["default"].modifiers[wrapModifier], data_list["default"].dataListText) }, props), children));
    return tooltip !== '' ? (react.createElement(Tooltip, { content: tooltip, isVisible: true }, text)) : (text);
};
DataListText.displayName = 'DataListText';
//# sourceMappingURL=DataListText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DataList/index.js












//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/DatePicker/date-picker.js
var date_picker = __webpack_require__(95900);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/outlined-calendar-alt-icon.js


const OutlinedCalendarAltIconConfig = {
  name: 'OutlinedCalendarAltIcon',
  height: 512,
  width: 448,
  svgPath: 'M148 288h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12zm108-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm96 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm-96 96v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm-96 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm192 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm96-260v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z',
  yOffset: 0,
  xOffset: 0,
};

const OutlinedCalendarAltIcon = createIcon(OutlinedCalendarAltIconConfig);

/* harmony default export */ const outlined_calendar_alt_icon = (OutlinedCalendarAltIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DatePicker/DatePicker.js













const yyyyMMddFormat = (date) => `${date.getFullYear()}-${(date.getMonth() + 1).toString().padStart(2, '0')}-${date
    .getDate()
    .toString()
    .padStart(2, '0')}`;
const DatePickerBase = (_a, ref) => {
    var { className, locale = undefined, dateFormat = yyyyMMddFormat, dateParse = (val) => val.split('-').length === 3 && new Date(`${val}T00:00:00`), isDisabled = false, placeholder = 'YYYY-MM-DD', value: valueProp = '', 'aria-label': ariaLabel = 'Date picker', buttonAriaLabel = 'Toggle date picker', onChange = () => undefined, onBlur = () => undefined, invalidFormatText = 'Invalid date', helperText, appendTo = 'parent', popoverProps, monthFormat, weekdayFormat, longWeekdayFormat, dayFormat, weekStart, validators = [], rangeStart, style: styleProps = {}, inputProps = {} } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "locale", "dateFormat", "dateParse", "isDisabled", "placeholder", "value", 'aria-label', "buttonAriaLabel", "onChange", "onBlur", "invalidFormatText", "helperText", "appendTo", "popoverProps", "monthFormat", "weekdayFormat", "longWeekdayFormat", "dayFormat", "weekStart", "validators", "rangeStart", "style", "inputProps"]);
    const [value, setValue] = react.useState(valueProp);
    const [valueDate, setValueDate] = react.useState(dateParse(value));
    const [errorText, setErrorText] = react.useState('');
    const [popoverOpen, setPopoverOpen] = react.useState(false);
    const [selectOpen, setSelectOpen] = react.useState(false);
    const [pristine, setPristine] = react.useState(true);
    const widthChars = react.useMemo(() => Math.max(dateFormat(new Date()).length, placeholder.length), [dateFormat]);
    const style = Object.assign({ '--pf-c-date-picker__input--c-form-control--width-chars': widthChars }, styleProps);
    const buttonRef = react.useRef();
    const datePickerWrapperRef = react.useRef();
    react.useEffect(() => {
        setValue(valueProp);
        setValueDate(dateParse(valueProp));
    }, [valueProp]);
    react.useEffect(() => {
        setPristine(!value);
        const newValueDate = dateParse(value);
        if (errorText && isValidDate(newValueDate)) {
            setError(newValueDate);
        }
    }, [value]);
    const setError = (date) => {
        setErrorText(validators.map(validator => validator(date)).join('\n') || '');
    };
    const onTextInput = (value, event) => {
        setValue(value);
        setErrorText('');
        const newValueDate = dateParse(value);
        setValueDate(newValueDate);
        if (isValidDate(newValueDate)) {
            onChange(event, value, new Date(newValueDate));
        }
        else {
            onChange(event, value);
        }
    };
    const onInputBlur = (event) => {
        if (pristine) {
            return;
        }
        const newValueDate = dateParse(value);
        if (isValidDate(newValueDate)) {
            onBlur(event, value, new Date(newValueDate));
            setError(newValueDate);
        }
        else {
            onBlur(event, value);
            setErrorText(invalidFormatText);
        }
    };
    const onDateClick = (newValueDate) => {
        const newValue = dateFormat(newValueDate);
        setValue(newValue);
        setValueDate(newValueDate);
        setError(newValueDate);
        setPopoverOpen(false);
        onChange(null, newValue, new Date(newValueDate));
    };
    const onKeyPress = (ev) => {
        if (ev.key === 'Enter' && value) {
            if (isValidDate(valueDate)) {
                setError(valueDate);
            }
            else {
                setErrorText(invalidFormatText);
            }
        }
    };
    (0,react.useImperativeHandle)(ref, () => ({
        setCalendarOpen: (isOpen) => setPopoverOpen(isOpen),
        toggleCalendar: (setOpen, eventKey) => {
            if (eventKey === KeyTypes.Escape && popoverOpen && !selectOpen) {
                setPopoverOpen(prev => (setOpen !== undefined ? setOpen : !prev));
            }
        },
        isCalendarOpen: popoverOpen
    }), [setPopoverOpen, popoverOpen, selectOpen]);
    const getParentElement = () => datePickerWrapperRef && datePickerWrapperRef.current ? datePickerWrapperRef.current : null;
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(date_picker/* default */.Z.datePicker, className), ref: datePickerWrapperRef, style: style }, props),
        react.createElement(Popover, Object.assign({ position: "bottom", bodyContent: react.createElement(CalendarMonth, { date: valueDate, onChange: onDateClick, locale: locale, 
                // Use truthy values of strings
                validators: validators.map(validator => (date) => !validator(date)), onSelectToggle: open => setSelectOpen(open), monthFormat: monthFormat, weekdayFormat: weekdayFormat, longWeekdayFormat: longWeekdayFormat, dayFormat: dayFormat, weekStart: weekStart, rangeStart: rangeStart, isDateFocused: true }), showClose: false, isVisible: popoverOpen, shouldClose: (_1, _2, event) => {
                event = event;
                if (event.key === KeyTypes.Escape && selectOpen) {
                    event.stopPropagation();
                    setSelectOpen(false);
                    return false;
                }
                // Let our button handle toggling
                if (buttonRef.current && buttonRef.current.contains(event.target)) {
                    return false;
                }
                setPopoverOpen(false);
                if (event.key === KeyTypes.Escape && popoverOpen) {
                    event.stopPropagation();
                }
                return true;
            }, withFocusTrap: true, hasNoPadding: true, hasAutoWidth: true, appendTo: appendTo === 'parent' ? getParentElement() : appendTo }, popoverProps),
            react.createElement("div", { className: date_picker/* default */.Z.datePickerInput },
                react.createElement(InputGroup, null,
                    react.createElement(TextInput, Object.assign({ isDisabled: isDisabled, "aria-label": ariaLabel, placeholder: placeholder, validated: errorText.trim() ? 'error' : 'default', value: value, onChange: onTextInput, onBlur: onInputBlur, onKeyPress: onKeyPress }, inputProps)),
                    react.createElement("button", { ref: buttonRef, className: (0,esm.css)(Button_button["default"].button, Button_button["default"].modifiers.control), "aria-label": buttonAriaLabel, type: "button", onClick: () => setPopoverOpen(!popoverOpen), disabled: isDisabled },
                        react.createElement(outlined_calendar_alt_icon, null))))),
        helperText && react.createElement("div", { className: date_picker/* default */.Z.datePickerHelperText }, helperText),
        errorText.trim() && react.createElement("div", { className: (0,esm.css)(date_picker/* default */.Z.datePickerHelperText, date_picker/* default */.Z.modifiers.error) }, errorText)));
};
const DatePicker = react.forwardRef(DatePickerBase);
DatePicker.displayName = 'DatePicker';
//# sourceMappingURL=DatePicker.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DatePicker/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/DescriptionList/description-list.js
var description_list = __webpack_require__(17998);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionList.js





const setBreakpointModifiers = (prefix, modifiers) => {
    const mods = modifiers;
    return Object.keys(mods || {}).reduce((acc, curr) => curr === 'default' ? Object.assign(Object.assign({}, acc), { [prefix]: mods[curr] }) : Object.assign(Object.assign({}, acc), { [`${prefix}-on-${curr}`]: mods[curr] }), {});
};
const DescriptionList = (_a) => {
    var { className = '', children = null, isHorizontal = false, isAutoColumnWidths, isAutoFit, isInlineGrid, isCompact, isFluid, isFillColumns, displaySize, columnModifier, autoFitMinModifier, termWidth, horizontalTermWidthModifier, orientation, style } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "isHorizontal", "isAutoColumnWidths", "isAutoFit", "isInlineGrid", "isCompact", "isFluid", "isFillColumns", "displaySize", "columnModifier", "autoFitMinModifier", "termWidth", "horizontalTermWidthModifier", "orientation", "style"]);
    if (isAutoFit && autoFitMinModifier) {
        style = Object.assign(Object.assign({}, style), setBreakpointModifiers('--pf-c-description-list--GridTemplateColumns--min', autoFitMinModifier));
    }
    if (termWidth) {
        style = Object.assign(Object.assign({}, style), { '--pf-c-description-list__term--width': termWidth });
    }
    if (isHorizontal && horizontalTermWidthModifier) {
        style = Object.assign(Object.assign({}, style), setBreakpointModifiers('--pf-c-description-list--m-horizontal__term--width', horizontalTermWidthModifier));
    }
    return (react.createElement("dl", Object.assign({ className: (0,esm.css)(description_list/* default */.Z.descriptionList, (isHorizontal || isFluid) && description_list/* default */.Z.modifiers.horizontal, isAutoColumnWidths && description_list/* default */.Z.modifiers.autoColumnWidths, isAutoFit && description_list/* default */.Z.modifiers.autoFit, formatBreakpointMods(columnModifier, description_list/* default */.Z), formatBreakpointMods(orientation, description_list/* default */.Z), isInlineGrid && description_list/* default */.Z.modifiers.inlineGrid, isCompact && description_list/* default */.Z.modifiers.compact, isFluid && description_list/* default */.Z.modifiers.fluid, isFillColumns && description_list/* default */.Z.modifiers.fillColumns, displaySize === 'lg' && description_list/* default */.Z.modifiers.displayLg, displaySize === '2xl' && description_list/* default */.Z.modifiers.display_2xl, className), style: style }, props), children));
};
DescriptionList.displayName = 'DescriptionList';
//# sourceMappingURL=DescriptionList.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListDescription.js




const DescriptionListDescription = (_a) => {
    var { children = null, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("dd", Object.assign({ className: (0,esm.css)(description_list/* default */.Z.descriptionListDescription, className) }, props),
        react.createElement("div", { className: 'pf-c-description-list__text' }, children)));
};
DescriptionListDescription.displayName = 'DescriptionListDescription';
//# sourceMappingURL=DescriptionListDescription.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListGroup.js




const DescriptionListGroup = (_a) => {
    var { className, children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(description_list/* default */.Z.descriptionListGroup, className) }, props), children));
};
DescriptionListGroup.displayName = 'DescriptionListGroup';
//# sourceMappingURL=DescriptionListGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListTerm.js




const DescriptionListTerm = (_a) => {
    var { children, className, icon } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "icon"]);
    return (react.createElement("dt", Object.assign({ className: (0,esm.css)(description_list/* default */.Z.descriptionListTerm, className) }, props),
        icon ? react.createElement("span", { className: (0,esm.css)(description_list/* default */.Z.descriptionListTermIcon) }, icon) : null,
        react.createElement("span", { className: (0,esm.css)(description_list/* default */.Z.descriptionListText) }, children)));
};
DescriptionListTerm.displayName = 'DescriptionListTerm';
//# sourceMappingURL=DescriptionListTerm.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListTermHelpText.js




const DescriptionListTermHelpText = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("dt", Object.assign({ className: (0,esm.css)(description_list/* default */.Z.descriptionListTerm, className) }, props), children));
};
DescriptionListTermHelpText.displayName = 'DescriptionListTermHelpText';
//# sourceMappingURL=DescriptionListTermHelpText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/DescriptionListTermHelpTextButton.js




const DescriptionListTermHelpTextButton = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(className, description_list/* default */.Z.descriptionListText, description_list/* default */.Z.modifiers.helpText), role: "button", type: "button", tabIndex: 0 }, props), children));
};
DescriptionListTermHelpTextButton.displayName = 'DescriptionListTermHelpTextButton';
//# sourceMappingURL=DescriptionListTermHelpTextButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DescriptionList/index.js






//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Divider/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Drawer/drawer.js
var drawer = __webpack_require__(44413);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/Drawer.js




var DrawerColorVariant;
(function (DrawerColorVariant) {
    DrawerColorVariant["default"] = "default";
    DrawerColorVariant["light200"] = "light-200";
})(DrawerColorVariant || (DrawerColorVariant = {}));
const DrawerContext = react.createContext({
    isExpanded: false,
    isStatic: false,
    onExpand: () => { },
    position: 'right',
    drawerRef: null,
    drawerContentRef: null,
    isInline: false
});
const Drawer = (_a) => {
    var { className = '', children, isExpanded = false, isInline = false, isStatic = false, position = 'right', onExpand = () => { } } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "isExpanded", "isInline", "isStatic", "position", "onExpand"]);
    const drawerRef = react.useRef();
    const drawerContentRef = react.useRef();
    return (react.createElement(DrawerContext.Provider, { value: { isExpanded, isStatic, onExpand, position, drawerRef, drawerContentRef, isInline } },
        react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawer, isExpanded && drawer["default"].modifiers.expanded, isInline && drawer["default"].modifiers.inline, isStatic && drawer["default"].modifiers.static, position === 'left' && drawer["default"].modifiers.panelLeft, position === 'bottom' && drawer["default"].modifiers.panelBottom, className), ref: drawerRef }, props), children)));
};
Drawer.displayName = 'Drawer';
//# sourceMappingURL=Drawer.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerActions.js




const DrawerActions = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerActions, className) }, props), children));
};
DrawerActions.displayName = 'DrawerActions';
//# sourceMappingURL=DrawerActions.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerCloseButton.js






const DrawerCloseButton = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', onClose = () => undefined, 'aria-label': ariaLabel = 'Close drawer panel' } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "onClose", 'aria-label']);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerClose, className) }, props),
        react.createElement(Button, { variant: "plain", onClick: onClose, "aria-label": ariaLabel },
            react.createElement(times_icon, null))));
};
DrawerCloseButton.displayName = 'DrawerCloseButton';
//# sourceMappingURL=DrawerCloseButton.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerMain.js




const DrawerMain = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerMain, className) }, props), children));
};
DrawerMain.displayName = 'DrawerMain';
//# sourceMappingURL=DrawerMain.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerContent.js






const DrawerContent = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, panelContent, colorVariant = DrawerColorVariant.default } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "panelContent", "colorVariant"]);
    const { drawerContentRef } = react.useContext(DrawerContext);
    return (react.createElement(DrawerMain, null,
        react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerContent, colorVariant === DrawerColorVariant.light200 && drawer["default"].modifiers.light_200, className), ref: drawerContentRef }, props), children),
        panelContent));
};
DrawerContent.displayName = 'DrawerContent';
//# sourceMappingURL=DrawerContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerContentBody.js




const DrawerContentBody = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, hasPadding = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "hasPadding"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerBody, hasPadding && drawer["default"].modifiers.padding, className) }, props), children));
};
DrawerContentBody.displayName = 'DrawerContentBody';
//# sourceMappingURL=DrawerContentBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerPanelBody.js




const DrawerPanelBody = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, hasNoPadding = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "hasNoPadding"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerBody, hasNoPadding && drawer["default"].modifiers.noPadding, className) }, props), children));
};
DrawerPanelBody.displayName = 'DrawerPanelBody';
//# sourceMappingURL=DrawerPanelBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerHead.js





const DrawerHead = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, hasNoPadding = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "hasNoPadding"]);
    return (react.createElement(DrawerPanelBody, { hasNoPadding: hasNoPadding },
        react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerHead, className) }, props), children)));
};
DrawerHead.displayName = 'DrawerHead';
//# sourceMappingURL=DrawerHead.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerPanelContent.js







let isResizing = null;
let newSize = 0;
const DrawerPanelContent = (_a) => {
    var { className = '', id, children, hasNoBorder = false, isResizable = false, onResize, minSize, defaultSize, maxSize, increment = 5, resizeAriaLabel = 'Resize', widths, colorVariant = DrawerColorVariant.default } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "id", "children", "hasNoBorder", "isResizable", "onResize", "minSize", "defaultSize", "maxSize", "increment", "resizeAriaLabel", "widths", "colorVariant"]);
    const panel = react.useRef();
    const splitterRef = react.useRef();
    const [separatorValue, setSeparatorValue] = react.useState(0);
    const { position, isExpanded, isStatic, onExpand, drawerRef, drawerContentRef, isInline } = react.useContext(DrawerContext);
    const hidden = isStatic ? false : !isExpanded;
    const [isExpandedInternal, setIsExpandedInternal] = react.useState(!hidden);
    let currWidth = 0;
    let panelRect;
    let right;
    let left;
    let bottom;
    let setInitialVals = true;
    react.useEffect(() => {
        if (!isStatic && isExpanded) {
            setIsExpandedInternal(isExpanded);
        }
    }, [isStatic, isExpanded]);
    const calcValueNow = () => {
        let splitterPos;
        let drawerSize;
        if (isInline && position === 'right') {
            splitterPos = panel.current.getBoundingClientRect().right - splitterRef.current.getBoundingClientRect().left;
            drawerSize = drawerRef.current.getBoundingClientRect().right - drawerRef.current.getBoundingClientRect().left;
        }
        else if (isInline && position === 'left') {
            splitterPos = splitterRef.current.getBoundingClientRect().right - panel.current.getBoundingClientRect().left;
            drawerSize = drawerRef.current.getBoundingClientRect().right - drawerRef.current.getBoundingClientRect().left;
        }
        else if (position === 'right') {
            splitterPos =
                drawerContentRef.current.getBoundingClientRect().right - splitterRef.current.getBoundingClientRect().left;
            drawerSize =
                drawerContentRef.current.getBoundingClientRect().right - drawerContentRef.current.getBoundingClientRect().left;
        }
        else if (position === 'left') {
            splitterPos =
                splitterRef.current.getBoundingClientRect().right - drawerContentRef.current.getBoundingClientRect().left;
            drawerSize =
                drawerContentRef.current.getBoundingClientRect().right - drawerContentRef.current.getBoundingClientRect().left;
        }
        else if (position === 'bottom') {
            splitterPos =
                drawerContentRef.current.getBoundingClientRect().bottom - splitterRef.current.getBoundingClientRect().top;
            drawerSize =
                drawerContentRef.current.getBoundingClientRect().bottom - drawerContentRef.current.getBoundingClientRect().top;
        }
        const newSplitterPos = (splitterPos / drawerSize) * 100;
        return Math.round((newSplitterPos + Number.EPSILON) * 100) / 100;
    };
    const handleTouchStart = (e) => {
        e.stopPropagation();
        document.addEventListener('touchmove', callbackTouchMove, { passive: false });
        document.addEventListener('touchend', callbackTouchEnd);
        isResizing = true;
    };
    const handleMousedown = (e) => {
        e.stopPropagation();
        e.preventDefault();
        document.addEventListener('mousemove', callbackMouseMove);
        document.addEventListener('mouseup', callbackMouseUp);
        drawerRef.current.classList.add((0,esm.css)(drawer["default"].modifiers.resizing));
        isResizing = true;
        setInitialVals = true;
    };
    const handleMouseMove = (e) => {
        const mousePos = position === 'bottom' ? e.clientY : e.clientX;
        handleControlMove(e, mousePos);
    };
    const handleTouchMove = (e) => {
        e.preventDefault();
        e.stopImmediatePropagation();
        const touchPos = position === 'bottom' ? e.touches[0].clientY : e.touches[0].clientX;
        handleControlMove(e, touchPos);
    };
    const handleControlMove = (e, controlPosition) => {
        e.stopPropagation();
        if (!isResizing) {
            return;
        }
        if (setInitialVals) {
            panelRect = panel.current.getBoundingClientRect();
            right = panelRect.right;
            left = panelRect.left;
            bottom = panelRect.bottom;
            setInitialVals = false;
        }
        const mousePos = controlPosition;
        let newSize = 0;
        if (position === 'right') {
            newSize = right - mousePos;
        }
        else if (position === 'left') {
            newSize = mousePos - left;
        }
        else {
            newSize = bottom - mousePos;
        }
        if (position === 'bottom') {
            panel.current.style.overflowAnchor = 'none';
        }
        panel.current.style.setProperty('--pf-c-drawer__panel--md--FlexBasis', newSize + 'px');
        currWidth = newSize;
        setSeparatorValue(calcValueNow());
    };
    const handleMouseup = () => {
        if (!isResizing) {
            return;
        }
        drawerRef.current.classList.remove((0,esm.css)(drawer["default"].modifiers.resizing));
        isResizing = false;
        onResize && onResize(currWidth, id);
        setInitialVals = true;
        document.removeEventListener('mousemove', callbackMouseMove);
        document.removeEventListener('mouseup', callbackMouseUp);
    };
    const handleTouchEnd = (e) => {
        e.stopPropagation();
        if (!isResizing) {
            return;
        }
        isResizing = false;
        onResize && onResize(currWidth, id);
        document.removeEventListener('touchmove', callbackTouchMove);
        document.removeEventListener('touchend', callbackTouchEnd);
    };
    const callbackMouseMove = react.useCallback(handleMouseMove, []);
    const callbackTouchEnd = react.useCallback(handleTouchEnd, []);
    const callbackTouchMove = react.useCallback(handleTouchMove, []);
    const callbackMouseUp = react.useCallback(handleMouseup, []);
    const handleKeys = (e) => {
        const key = e.key;
        if (key !== 'Escape' &&
            key !== 'Enter' &&
            key !== 'ArrowUp' &&
            key !== 'ArrowDown' &&
            key !== 'ArrowLeft' &&
            key !== 'ArrowRight') {
            if (isResizing) {
                e.preventDefault();
            }
            return;
        }
        e.preventDefault();
        if (key === 'Escape' || key === 'Enter') {
            onResize && onResize(currWidth, id);
        }
        const panelRect = panel.current.getBoundingClientRect();
        newSize = position === 'bottom' ? panelRect.height : panelRect.width;
        let delta = 0;
        if (key === 'ArrowRight') {
            delta = position === 'left' ? increment : -increment;
        }
        else if (key === 'ArrowLeft') {
            delta = position === 'left' ? -increment : increment;
        }
        else if (key === 'ArrowUp') {
            delta = increment;
        }
        else if (key === 'ArrowDown') {
            delta = -increment;
        }
        newSize = newSize + delta;
        if (position === 'bottom') {
            panel.current.style.overflowAnchor = 'none';
        }
        panel.current.style.setProperty('--pf-c-drawer__panel--md--FlexBasis', newSize + 'px');
        currWidth = newSize;
        setSeparatorValue(calcValueNow());
    };
    const boundaryCssVars = {};
    if (defaultSize) {
        boundaryCssVars['--pf-c-drawer__panel--md--FlexBasis'] = defaultSize;
    }
    if (minSize) {
        boundaryCssVars['--pf-c-drawer__panel--md--FlexBasis--min'] = minSize;
    }
    if (maxSize) {
        boundaryCssVars['--pf-c-drawer__panel--md--FlexBasis--max'] = maxSize;
    }
    return (react.createElement(GenerateId, { prefix: "pf-drawer-panel-" }, panelId => (react.createElement("div", Object.assign({ id: id || panelId, className: (0,esm.css)(drawer["default"].drawerPanel, isResizable && drawer["default"].modifiers.resizable, hasNoBorder && drawer["default"].modifiers.noBorder, formatBreakpointMods(widths, drawer["default"]), colorVariant === DrawerColorVariant.light200 && drawer["default"].modifiers.light_200, className), ref: panel, onTransitionEnd: ev => {
            if (!hidden && ev.nativeEvent.propertyName === 'transform') {
                onExpand();
            }
            setIsExpandedInternal(!hidden);
        }, hidden: hidden }, ((defaultSize || minSize || maxSize) && {
        style: boundaryCssVars
    }), props), isExpandedInternal && (react.createElement(react.Fragment, null,
        isResizable && (react.createElement(react.Fragment, null,
            react.createElement("div", { className: (0,esm.css)(drawer["default"].drawerSplitter, position !== 'bottom' && drawer["default"].modifiers.vertical), role: "separator", tabIndex: 0, "aria-orientation": position === 'bottom' ? 'horizontal' : 'vertical', "aria-label": resizeAriaLabel, "aria-valuenow": separatorValue, "aria-valuemin": 0, "aria-valuemax": 100, "aria-controls": id || panelId, onMouseDown: handleMousedown, onKeyDown: handleKeys, onTouchStart: handleTouchStart, ref: splitterRef },
                react.createElement("div", { className: (0,esm.css)(drawer["default"].drawerSplitterHandle), "aria-hidden": true })),
            react.createElement("div", { className: (0,esm.css)(drawer["default"].drawerPanelMain) }, children))),
        !isResizable && children))))));
};
DrawerPanelContent.displayName = 'DrawerPanelContent';
//# sourceMappingURL=DrawerPanelContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/DrawerSection.js





const DrawerSection = (_a) => {
    var { 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    className = '', children, colorVariant = DrawerColorVariant.default } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "colorVariant"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(drawer["default"].drawerSection, colorVariant === DrawerColorVariant.light200 && drawer["default"].modifiers.light_200, className) }, props), children));
};
DrawerSection.displayName = 'DrawerSection';
//# sourceMappingURL=DrawerSection.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Drawer/index.js









//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/Dropdown.js






const Dropdown = (_a) => {
    var { onSelect, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref, // Types of Ref are different for React.FunctionComponent vs React.Component
    ouiaId, ouiaSafe, alignments, contextProps, menuAppendTo = 'inline', isFlipEnabled = true, removeFindDomNode = false, zIndex = 9999 } = _a, props = (0,tslib_es6.__rest)(_a, ["onSelect", "ref", "ouiaId", "ouiaSafe", "alignments", "contextProps", "menuAppendTo", "isFlipEnabled", "removeFindDomNode", "zIndex"]);
    return (react.createElement(DropdownContext.Provider, { value: Object.assign({ onSelect: event => onSelect && onSelect(event), toggleTextClass: dropdown["default"].dropdownToggleText, toggleIconClass: dropdown["default"].dropdownToggleImage, toggleIndicatorClass: dropdown["default"].dropdownToggleIcon, menuClass: dropdown["default"].dropdownMenu, itemClass: dropdown["default"].dropdownMenuItem, toggleClass: dropdown["default"].dropdownToggle, baseClass: dropdown["default"].dropdown, baseComponent: 'div', sectionClass: dropdown["default"].dropdownGroup, sectionTitleClass: dropdown["default"].dropdownGroupTitle, sectionComponent: 'section', disabledClass: dropdown["default"].modifiers.disabled, plainTextClass: dropdown["default"].modifiers.text, ouiaId: useOUIAId(Dropdown.displayName, ouiaId), ouiaSafe, ouiaComponentType: Dropdown.displayName, alignments }, contextProps) },
        react.createElement(DropdownWithContext, Object.assign({ menuAppendTo: menuAppendTo, isFlipEnabled: isFlipEnabled, removeFindDomNode: removeFindDomNode, zIndex: zIndex }, props))));
};
Dropdown.displayName = 'Dropdown';
//# sourceMappingURL=Dropdown.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/BadgeToggle.js







const BadgeToggle = (_a) => {
    var { id = '', children = null, badgeProps = { isRead: true }, className = '', isOpen = false, 'aria-label': ariaLabel = 'Actions', parentRef = null, getMenuRef = null, isActive = false, isPlain = null, isDisabled = false, bubbleEvent = false, onToggle = () => undefined, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref } = _a, // Types of Ref are different for React.FunctionComponent vs React.Component
    props = (0,tslib_es6.__rest)(_a, ["id", "children", "badgeProps", "className", "isOpen", 'aria-label', "parentRef", "getMenuRef", "isActive", "isPlain", "isDisabled", "bubbleEvent", "onToggle", "ref"]);
    return (react.createElement(Toggle, Object.assign({ id: id, className: className, isOpen: isOpen, "aria-label": ariaLabel, parentRef: parentRef, getMenuRef: getMenuRef, isActive: isActive, isPlain: isPlain || true, isDisabled: isDisabled, onToggle: onToggle, bubbleEvent: bubbleEvent }, props),
        react.createElement(Badge, Object.assign({}, badgeProps),
            children,
            react.createElement("span", { className: (0,esm.css)(dropdown["default"].dropdownToggleIcon) },
                react.createElement(caret_down_icon, null)))));
};
BadgeToggle.displayName = 'BadgeToggle';
//# sourceMappingURL=BadgeToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/ellipsis-v-icon.js


const EllipsisVIconConfig = {
  name: 'EllipsisVIcon',
  height: 512,
  width: 192,
  svgPath: 'M96 184c39.8 0 72 32.2 72 72s-32.2 72-72 72-72-32.2-72-72 32.2-72 72-72zM24 80c0 39.8 32.2 72 72 72s72-32.2 72-72S135.8 8 96 8 24 40.2 24 80zm0 352c0 39.8 32.2 72 72 72s72-32.2 72-72-32.2-72-72-72-72 32.2-72 72z',
  yOffset: 0,
  xOffset: 0,
};

const EllipsisVIcon = createIcon(EllipsisVIconConfig);

/* harmony default export */ const ellipsis_v_icon = (EllipsisVIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/KebabToggle.js




const KebabToggle = (_a) => {
    var { id = '', 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    children = null, className = '', isOpen = false, 'aria-label': ariaLabel = 'Actions', parentRef = null, getMenuRef = null, isActive = false, isPlain = false, isDisabled = false, bubbleEvent = false, onToggle = () => undefined, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    ref } = _a, // Types of Ref are different for React.FunctionComponent vs React.Component
    props = (0,tslib_es6.__rest)(_a, ["id", "children", "className", "isOpen", 'aria-label', "parentRef", "getMenuRef", "isActive", "isPlain", "isDisabled", "bubbleEvent", "onToggle", "ref"]);
    return (react.createElement(Toggle, Object.assign({ id: id, className: className, isOpen: isOpen, "aria-label": ariaLabel, parentRef: parentRef, getMenuRef: getMenuRef, isActive: isActive, isPlain: isPlain, isDisabled: isDisabled, onToggle: onToggle, bubbleEvent: bubbleEvent }, props),
        react.createElement(ellipsis_v_icon, null)));
};
KebabToggle.displayName = 'KebabToggle';
//# sourceMappingURL=KebabToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggleCheckbox.js






class DropdownToggleCheckbox extends react.Component {
    constructor(props) {
        super(props);
        this.handleChange = (event) => {
            var _a, _b;
            (_b = (_a = this.props).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, event.target.checked, event);
        };
        this.calculateChecked = () => {
            const { isChecked, checked } = this.props;
            if (isChecked === null) {
                // return false here and the indeterminate state will be set to true through the ref
                return false;
            }
            else if (isChecked !== undefined) {
                return isChecked;
            }
            return checked;
        };
        this.state = {
            ouiaStateId: getDefaultOUIAId(DropdownToggleCheckbox.displayName)
        };
    }
    render() {
        const _a = this.props, { className, isValid, isDisabled, isChecked, isInProgress = false, defaultProgressAriaLabel, defaultProgressAriaValueText = 'Loading...', children, ouiaId, ouiaSafe, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        onChange, checked } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        props = (0,tslib_es6.__rest)(_a, ["className", "isValid", "isDisabled", "isChecked", "isInProgress", "defaultProgressAriaLabel", "defaultProgressAriaValueText", "children", "ouiaId", "ouiaSafe", "onChange", "checked"]);
        const spinner = (react.createElement(Spinner, { diameter: "1em", isSVG: true, "aria-valuetext": defaultProgressAriaValueText, "aria-live": "polite", "aria-label": defaultProgressAriaLabel }));
        const text = children && (react.createElement("span", { className: (0,esm.css)(dropdown["default"].dropdownToggleText, className), "aria-hidden": "true", id: `${props.id}-text` }, children));
        return (react.createElement("label", { className: (0,esm.css)(dropdown["default"].dropdownToggleCheck, isInProgress && dropdown["default"].modifiers.inProgress, className), htmlFor: props.id },
            react.createElement("input", Object.assign({}, props, (this.calculateChecked() !== undefined && { onChange: this.handleChange }), { type: "checkbox", ref: elem => elem && (elem.indeterminate = isChecked === null), "aria-invalid": !isValid, disabled: isDisabled, checked: this.calculateChecked() }, getOUIAProps(DropdownToggleCheckbox.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe))),
            isInProgress && react.createElement("span", { className: (0,esm.css)(dropdown["default"].dropdownToggleProgress, className) }, spinner),
            text));
    }
}
DropdownToggleCheckbox.displayName = 'DropdownToggleCheckbox';
DropdownToggleCheckbox.defaultProps = {
    className: '',
    isValid: true,
    isDisabled: false,
    onChange: () => undefined
};
//# sourceMappingURL=DropdownToggleCheckbox.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/DropdownToggleAction.js




class DropdownToggleAction extends react.Component {
    render() {
        const _a = this.props, { id, className, onClick, isDisabled, children } = _a, props = (0,tslib_es6.__rest)(_a, ["id", "className", "onClick", "isDisabled", "children"]);
        return (react.createElement("button", Object.assign({ id: id, className: (0,esm.css)(dropdown["default"].dropdownToggleButton, className), onClick: onClick }, (isDisabled && { disabled: true, 'aria-disabled': true }), props), children));
    }
}
DropdownToggleAction.displayName = 'DropdownToggleAction';
DropdownToggleAction.defaultProps = {
    className: '',
    isDisabled: false,
    onClick: () => { }
};
//# sourceMappingURL=DropdownToggleAction.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Dropdown/index.js












//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/DualListSelector/dual-list-selector.js
var dual_list_selector = __webpack_require__(61534);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/angle-double-left-icon.js


const AngleDoubleLeftIconConfig = {
  name: 'AngleDoubleLeftIcon',
  height: 512,
  width: 448,
  svgPath: 'M223.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L319.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L393.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34zm-192 34l136 136c9.4 9.4 24.6 9.4 33.9 0l22.6-22.6c9.4-9.4 9.4-24.6 0-33.9L127.9 256l96.4-96.4c9.4-9.4 9.4-24.6 0-33.9L201.7 103c-9.4-9.4-24.6-9.4-33.9 0l-136 136c-9.5 9.4-9.5 24.6-.1 34z',
  yOffset: 0,
  xOffset: 0,
};

const AngleDoubleLeftIcon = createIcon(AngleDoubleLeftIconConfig);

/* harmony default export */ const angle_double_left_icon = (AngleDoubleLeftIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/angle-double-right-icon.js


const AngleDoubleRightIconConfig = {
  name: 'AngleDoubleRightIcon',
  height: 512,
  width: 448,
  svgPath: 'M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34zm192-34l-136-136c-9.4-9.4-24.6-9.4-33.9 0l-22.6 22.6c-9.4 9.4-9.4 24.6 0 33.9l96.4 96.4-96.4 96.4c-9.4 9.4-9.4 24.6 0 33.9l22.6 22.6c9.4 9.4 24.6 9.4 33.9 0l136-136c9.4-9.2 9.4-24.4 0-33.8z',
  yOffset: 0,
  xOffset: 0,
};

const AngleDoubleRightIcon = createIcon(AngleDoubleRightIconConfig);

/* harmony default export */ const angle_double_right_icon = (AngleDoubleRightIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/treeUtils.js
function flattenTree(tree) {
    let result = [];
    tree.forEach(item => {
        if (item.children) {
            result = result.concat(flattenTree(item.children));
        }
        else {
            result.push(item.id);
        }
    });
    return result;
}
function flattenTreeWithFolders(tree) {
    let result = [];
    tree.forEach(item => {
        result.push(item.id);
        if (item.children) {
            result = result.concat(flattenTreeWithFolders(item.children));
        }
    });
    return result;
}
function filterFolders(tree, inputList) {
    let result = [];
    tree.forEach(item => {
        if (item.children) {
            result = result.concat(filterFolders(item.children, inputList));
        }
        else {
            if (inputList.includes(item.id)) {
                result.push(item.id);
            }
        }
    });
    return result;
}
function filterTreeItems(item, inputList) {
    if (inputList.includes(item.id)) {
        return true;
    }
    if (item.children) {
        return ((item.children = item.children
            .map(opt => Object.assign({}, opt))
            .filter(child => filterTreeItems(child, inputList))).length > 0);
    }
}
function filterTreeItemsWithoutFolders(item, inputList) {
    if (item.children) {
        return ((item.children = item.children
            .map(opt => Object.assign({}, opt))
            .filter(child => child.children ? filterTreeItemsWithoutFolders(child, inputList) : filterTreeItems(child, inputList))).length > 0);
    }
    if (inputList.includes(item.id)) {
        return true;
    }
}
function filterRestTreeItems(item, inputList) {
    if (item.children) {
        const child = (item.children = item.children
            .map(opt => Object.assign({}, opt))
            .filter(child => filterRestTreeItems(child, inputList))).length > 0;
        return child;
    }
    if (!inputList.includes(item.id)) {
        return true;
    }
}
//# sourceMappingURL=treeUtils.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorContext.js

const DualListSelectorContext = react.createContext({ isTree: false });
const DualListSelectorListContext = react.createContext({});
const DualListSelectorPaneContext = react.createContext({ isChosen: false });
//# sourceMappingURL=DualListSelectorContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorTreeItem.js








const DualListSelectorTreeItemBase = (_a) => {
    var { onOptionCheck, children, className, id, text, defaultExpanded, hasBadge, isChecked, checkProps, badgeProps, itemData, isDisabled = false, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    useMemo } = _a, props = (0,tslib_es6.__rest)(_a, ["onOptionCheck", "children", "className", "id", "text", "defaultExpanded", "hasBadge", "isChecked", "checkProps", "badgeProps", "itemData", "isDisabled", "useMemo"]);
    const ref = react.useRef(null);
    const [isExpanded, setIsExpanded] = react.useState(defaultExpanded || false);
    const { setFocusedOption } = react.useContext(DualListSelectorListContext);
    react.useEffect(() => {
        setIsExpanded(defaultExpanded);
    }, [defaultExpanded]);
    return (react.createElement("li", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorListItem, className, children && dual_list_selector/* default */.Z.modifiers.expandable, isExpanded && dual_list_selector/* default */.Z.modifiers.expanded, isDisabled && dual_list_selector/* default */.Z.modifiers.disabled), id: id }, props, { "aria-selected": isChecked, role: "treeitem" }, (isExpanded && { 'aria-expanded': 'true' })),
        react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorListItemRow, isChecked && dual_list_selector/* default */.Z.modifiers.selected, dual_list_selector/* default */.Z.modifiers.check) },
            react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItem), ref: ref, tabIndex: -1, onClick: isDisabled
                    ? undefined
                    : evt => {
                        onOptionCheck && onOptionCheck(evt, !isChecked, itemData);
                        setFocusedOption(id);
                    } },
                react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemMain) },
                    children && (react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemToggle), onClick: e => {
                            if (children) {
                                setIsExpanded(!isExpanded);
                            }
                            e.stopPropagation();
                        }, onKeyDown: (e) => {
                            if (e.key === ' ' || e.key === 'Enter') {
                                document.activeElement.click();
                                e.preventDefault();
                            }
                        }, tabIndex: -1 },
                        react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemToggleIcon) },
                            react.createElement(angle_right_icon, { "aria-hidden": true })))),
                    react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemCheck) },
                        react.createElement("input", Object.assign({ type: "checkbox", onChange: (evt) => {
                                onOptionCheck && onOptionCheck(evt, !isChecked, itemData);
                                setFocusedOption(id);
                            }, onClick: (evt) => evt.stopPropagation(), onKeyDown: (e) => {
                                if (e.key === ' ' || e.key === 'Enter') {
                                    onOptionCheck && onOptionCheck(e, !isChecked, itemData);
                                    setFocusedOption(id);
                                    e.preventDefault();
                                }
                            }, ref: elem => elem && (elem.indeterminate = isChecked === null), checked: isChecked || false, tabIndex: -1 }, checkProps))),
                    react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemText) }, text),
                    hasBadge && children && (react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemCount) },
                        react.createElement(Badge, Object.assign({}, badgeProps), flattenTree(children.props.data).length)))))),
        isExpanded && children));
};
const DualListSelectorTreeItem = react.memo(DualListSelectorTreeItemBase, (prevProps, nextProps) => {
    if (!nextProps.useMemo) {
        return false;
    }
    if (prevProps.className !== nextProps.className ||
        prevProps.text !== nextProps.text ||
        prevProps.id !== nextProps.id ||
        prevProps.defaultExpanded !== nextProps.defaultExpanded ||
        prevProps.checkProps !== nextProps.checkProps ||
        prevProps.hasBadge !== nextProps.hasBadge ||
        prevProps.badgeProps !== nextProps.badgeProps ||
        prevProps.isChecked !== nextProps.isChecked ||
        prevProps.itemData !== nextProps.itemData) {
        return false;
    }
    return true;
});
DualListSelectorTreeItem.displayName = 'DualListSelectorTreeItem';
//# sourceMappingURL=DualListSelectorTreeItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorTree.js





const DualListSelectorTree = (_a) => {
    var { data, hasBadges = false, isNested = false, defaultAllExpanded = false, onOptionCheck, isDisabled = false } = _a, props = (0,tslib_es6.__rest)(_a, ["data", "hasBadges", "isNested", "defaultAllExpanded", "onOptionCheck", "isDisabled"]);
    const dataToRender = typeof data === 'function' ? data() : data;
    const tree = dataToRender.map(item => (react.createElement(DualListSelectorTreeItem, Object.assign({ key: item.id, text: item.text, id: item.id, defaultExpanded: item.defaultExpanded !== undefined ? item.defaultExpanded : defaultAllExpanded, onOptionCheck: onOptionCheck, isChecked: item.isChecked, checkProps: item.checkProps, hasBadge: item.hasBadge !== undefined ? item.hasBadge : hasBadges, badgeProps: item.badgeProps, itemData: item, isDisabled: isDisabled, useMemo: true }, (item.children && {
        children: (react.createElement(DualListSelectorTree, { isNested: true, data: item.children, hasBadges: hasBadges, defaultAllExpanded: defaultAllExpanded, onOptionCheck: onOptionCheck, isDisabled: isDisabled }))
    })))));
    return isNested ? (react.createElement("ul", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorList), role: "group" }, props), tree)) : (react.createElement(react.Fragment, null, tree));
};
DualListSelectorTree.displayName = 'DualListSelectorTree';
//# sourceMappingURL=DualListSelectorTree.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/KeyboardHandler.js


/**
 * This function is a helper for handling basic arrow keyboard interactions. If a component already has its own key handler and event start up/tear down, this function may be easier to integrate in over the full component.
 *
 * @param {event} event Event triggered by the keyboard
 * @param {element[]} navigableElements Valid traversable elements of the container
 * @param {function} isActiveElement Callback to determine if a given element from the navigable elements array is the active element of the page
 * @param {function} getFocusableElement Callback returning the focusable element of a given element from the navigable elements array
 * @param {string[]} validSiblingTags Valid sibling tags that horizontal arrow handling will focus
 * @param {boolean} noVerticalArrowHandling Flag indicating that the included vertical arrow key handling should be ignored
 * @param {boolean} noHorizontalArrowHandling Flag indicating that the included horizontal arrow key handling should be ignored
 * @param {boolean} updateTabIndex Flag indicating that the tabIndex of the currently focused element and next focused element should be updated, in the case of using a roving tabIndex
 * @param {boolean} onlyTraverseSiblings Flag indicating that next focusable element of a horizontal movement will be this element's sibling
 */
const handleArrows = (event, navigableElements, isActiveElement = element => document.activeElement.contains(element), getFocusableElement = element => element, validSiblingTags = ['A', 'BUTTON', 'INPUT'], noVerticalArrowHandling = false, noHorizontalArrowHandling = false, updateTabIndex = true, onlyTraverseSiblings = true) => {
    const activeElement = document.activeElement;
    const key = event.key;
    let moveTarget = null;
    // Handle vertical arrow keys. If noVerticalArrowHandling is passed, skip this block
    if (!noVerticalArrowHandling) {
        if (['ArrowUp', 'ArrowDown'].includes(key)) {
            event.preventDefault();
            event.stopImmediatePropagation(); // For menus in menus
            // Traverse navigableElements to find the element which is currently active
            let currentIndex = -1;
            // while (currentIndex === -1) {
            navigableElements.forEach((element, index) => {
                if (isActiveElement(element)) {
                    // Once found, move up or down the array by 1. Determined by the vertical arrow key direction
                    let increment = 0;
                    // keep increasing the increment until you've tried the whole navigableElement
                    while (!moveTarget && increment < navigableElements.length && increment * -1 < navigableElements.length) {
                        key === 'ArrowUp' ? increment-- : increment++;
                        currentIndex = index + increment;
                        if (currentIndex >= navigableElements.length) {
                            currentIndex = 0;
                        }
                        if (currentIndex < 0) {
                            currentIndex = navigableElements.length - 1;
                        }
                        // Set the next target element (undefined if none found)
                        moveTarget = getFocusableElement(navigableElements[currentIndex]);
                    }
                }
            });
            // }
        }
    }
    // Handle horizontal arrow keys. If noHorizontalArrowHandling is passed, skip this block
    if (!noHorizontalArrowHandling) {
        if (['ArrowLeft', 'ArrowRight'].includes(key)) {
            event.preventDefault();
            event.stopImmediatePropagation(); // For menus in menus
            let currentIndex = -1;
            navigableElements.forEach((element, index) => {
                if (isActiveElement(element)) {
                    const activeRow = navigableElements[index].querySelectorAll(validSiblingTags.join(',')); // all focusable elements in my row
                    if (!activeRow.length || onlyTraverseSiblings) {
                        let nextSibling = activeElement;
                        // While a sibling exists, check each sibling to determine if it should be focussed
                        while (nextSibling) {
                            // Set the next checked sibling, determined by the horizontal arrow key direction
                            nextSibling = key === 'ArrowLeft' ? nextSibling.previousElementSibling : nextSibling.nextElementSibling;
                            if (nextSibling) {
                                if (validSiblingTags.includes(nextSibling.tagName)) {
                                    // If the sibling's tag is included in validSiblingTags, set the next target element and break the loop
                                    moveTarget = nextSibling;
                                    break;
                                }
                                // If the sibling's tag is not valid, skip to the next sibling if possible
                            }
                        }
                    }
                    else {
                        activeRow.forEach((focusableElement, index) => {
                            if (event.target === focusableElement) {
                                // Once found, move up or down the array by 1. Determined by the vertical arrow key direction
                                const increment = key === 'ArrowLeft' ? -1 : 1;
                                currentIndex = index + increment;
                                if (currentIndex >= activeRow.length) {
                                    currentIndex = 0;
                                }
                                if (currentIndex < 0) {
                                    currentIndex = activeRow.length - 1;
                                }
                                // Set the next target element
                                moveTarget = activeRow[currentIndex];
                            }
                        });
                    }
                }
            });
        }
    }
    if (moveTarget) {
        // If updateTabIndex is true, set the previously focussed element's tabIndex to -1 and the next focussed element's tabIndex to 0
        // This updates the tabIndex for a roving tabIndex
        if (updateTabIndex) {
            activeElement.tabIndex = -1;
            moveTarget.tabIndex = 0;
        }
        // If a move target has been set by either arrow handler, focus that target
        moveTarget.focus();
    }
};
/**
 * This function is a helper for setting the initial tabIndexes in a roving tabIndex
 *
 * @param {HTMLElement[]} options Array of elements which should have a tabIndex of -1, except for the first element which will have a tabIndex of 0
 */
const setTabIndex = (options) => {
    if (options && options.length > 0) {
        // Iterate the options and set the tabIndex to -1 on every option
        options.forEach((option) => {
            option.tabIndex = -1;
        });
        // Manually set the tabIndex of the first option to 0
        options[0].tabIndex = 0;
    }
};
class KeyboardHandler extends react.Component {
    constructor() {
        super(...arguments);
        this.keyHandler = (event) => {
            const { isEventFromContainer } = this.props;
            // If the passed keyboard event is not from the container, ignore the event by returning
            if (isEventFromContainer ? !isEventFromContainer(event) : !this._isEventFromContainer(event)) {
                return;
            }
            const { isActiveElement, getFocusableElement, noVerticalArrowHandling, noHorizontalArrowHandling, noEnterHandling, noSpaceHandling, updateTabIndex, validSiblingTags, additionalKeyHandler, createNavigableElements, onlyTraverseSiblings } = this.props;
            // Pass the event off to be handled by any custom handler
            additionalKeyHandler && additionalKeyHandler(event);
            // Initalize navigableElements from the createNavigableElements callback
            const navigableElements = createNavigableElements();
            if (!navigableElements) {
                // eslint-disable-next-line no-console
                console.warn('No navigable elements have been passed to the KeyboardHandler. Keyboard navigation provided by this component will be ignored.');
                return;
            }
            const key = event.key;
            // Handle enter key. If noEnterHandling is passed, skip this block
            if (!noEnterHandling) {
                if (key === 'Enter') {
                    event.preventDefault();
                    event.stopImmediatePropagation(); // For menus in menus
                    document.activeElement.click();
                }
            }
            // Handle space key. If noSpaceHandling is passed, skip this block
            if (!noSpaceHandling) {
                if (key === ' ') {
                    event.preventDefault();
                    event.stopImmediatePropagation(); // For menus in menus
                    document.activeElement.click();
                }
            }
            // Inject helper handler for arrow navigation
            handleArrows(event, navigableElements, isActiveElement, getFocusableElement, validSiblingTags, noVerticalArrowHandling, noHorizontalArrowHandling, updateTabIndex, onlyTraverseSiblings);
        };
        this._isEventFromContainer = (event) => {
            const { containerRef } = this.props;
            return containerRef.current && containerRef.current.contains(event.target);
        };
    }
    componentDidMount() {
        if (canUseDOM) {
            window.addEventListener('keydown', this.keyHandler);
        }
    }
    componentWillUnmount() {
        if (canUseDOM) {
            window.removeEventListener('keydown', this.keyHandler);
        }
    }
    render() {
        return null;
    }
}
KeyboardHandler.displayName = 'KeyboardHandler';
KeyboardHandler.defaultProps = {
    containerRef: null,
    createNavigableElements: () => null,
    isActiveElement: (navigableElement) => document.activeElement === navigableElement,
    getFocusableElement: (navigableElement) => navigableElement,
    validSiblingTags: ['BUTTON', 'A'],
    onlyTraverseSiblings: true,
    updateTabIndex: true,
    noHorizontalArrowHandling: false,
    noVerticalArrowHandling: false,
    noEnterHandling: false,
    noSpaceHandling: false
};
//# sourceMappingURL=KeyboardHandler.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorListItem.js








const DualListSelectorListItemBase = (_a) => {
    var { onOptionSelect, orderIndex, children, className, id = getUniqueId('dual-list-selector-list-item'), isSelected, innerRef, isDraggable = false, isDisabled, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    draggableButtonAriaLabel = 'Reorder option' } = _a, props = (0,tslib_es6.__rest)(_a, ["onOptionSelect", "orderIndex", "children", "className", "id", "isSelected", "innerRef", "isDraggable", "isDisabled", "draggableButtonAriaLabel"]);
    const privateRef = react.useRef(null);
    const ref = innerRef || privateRef;
    const { setFocusedOption } = react.useContext(DualListSelectorListContext);
    return (react.createElement("li", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorListItem, className, isDisabled && dual_list_selector/* default */.Z.modifiers.disabled), key: orderIndex, onClick: isDisabled
            ? undefined
            : (e) => {
                setFocusedOption(id);
                onOptionSelect(e, id);
            }, onKeyDown: (e) => {
            if (e.key === ' ' || e.key === 'Enter') {
                document.activeElement.click();
                e.preventDefault();
            }
        }, "aria-selected": isSelected, id: id, ref: ref, role: "option", tabIndex: -1 }, props),
        react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorListItemRow, isSelected && dual_list_selector/* default */.Z.modifiers.selected) },
            isDraggable && !isDisabled && (react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorDraggable) },
                react.createElement(Button, { variant: ButtonVariant.plain, component: "span" },
                    react.createElement(grip_vertical_icon, { style: { verticalAlign: '-0.3em' } })))),
            react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItem) },
                react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemMain) },
                    react.createElement("span", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorItemText) }, children))))));
};
DualListSelectorListItemBase.displayName = 'DualListSelectorListItemBase';
const DualListSelectorListItem = react.forwardRef((props, ref) => (react.createElement(DualListSelectorListItemBase, Object.assign({ innerRef: ref }, props))));
DualListSelectorListItem.displayName = 'DualListSelectorListItem';
//# sourceMappingURL=DualListSelectorListItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorList.js






const DualListSelectorList = (_a) => {
    var { children } = _a, props = (0,tslib_es6.__rest)(_a, ["children"]);
    const { setFocusedOption, isTree, ariaLabelledBy, focusedOption, displayOption, selectedOptions, id, onOptionSelect, options, isDisabled } = react.useContext(DualListSelectorListContext);
    // only called when options are passed via options prop
    const onOptionClick = (e, index, id) => {
        setFocusedOption(id);
        onOptionSelect(e, index, id);
    };
    const hasOptions = () => options.length !== 0 || (children !== undefined && children.length !== 0);
    return (react.createElement("ul", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorList) }, (hasOptions() && {
        role: isTree ? 'tree' : 'listbox',
        'aria-multiselectable': true,
        'aria-labelledby': ariaLabelledBy,
        'aria-activedescendant': focusedOption
    }), { "aria-disabled": isDisabled ? 'true' : undefined }, props), options.length === 0
        ? children
        : options.map((option, index) => {
            if (displayOption(option)) {
                return (react.createElement(DualListSelectorListItem, { key: index, isSelected: selectedOptions.indexOf(index) !== -1, id: `${id}-option-${index}`, onOptionSelect: (e, id) => onOptionClick(e, index, id), orderIndex: index, isDisabled: isDisabled }, option));
            }
            return;
        })));
};
DualListSelectorList.displayName = 'DualListSelectorList';
//# sourceMappingURL=DualListSelectorList.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorListWrapper.js







const DualListSelectorListWrapperBase = (_a) => {
    var { className, children, 'aria-labelledby': ariaLabelledBy, innerRef, options = [], selectedOptions = [], onOptionSelect, displayOption, id = getUniqueId('dual-list-selector-list'), isDisabled = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", 'aria-labelledby', "innerRef", "options", "selectedOptions", "onOptionSelect", "displayOption", "id", "isDisabled"]);
    const [focusedOption, setFocusedOption] = react.useState('');
    const ref = react.useRef(null);
    const menuRef = innerRef || ref;
    const { isTree } = react.useContext(DualListSelectorContext);
    // sets up keyboard focus handling for the dual list selector menu child of the pane. This keyboard
    // handling is applied whether the pane is dynamically built or passed via the children prop.
    const handleKeys = (event) => {
        if (!menuRef.current ||
            (menuRef.current !== event.target.closest('.pf-c-dual-list-selector__menu') &&
                !Array.from(menuRef.current.getElementsByClassName('pf-c-dual-list-selector__menu')).includes(event.target.closest('.pf-c-dual-list-selector__menu')))) {
            return;
        }
        event.stopImmediatePropagation();
        const validOptions = isTree
            ? Array.from(menuRef.current.querySelectorAll('.pf-c-dual-list-selector__item-toggle, .pf-c-dual-list-selector__item-check > input'))
            : Array.from(menuRef.current.getElementsByTagName('LI')).filter(el => !el.classList.contains('pf-m-disabled'));
        const activeElement = document.activeElement;
        handleArrows(event, validOptions, (element) => activeElement.contains(element), (element) => {
            if (element.classList.contains('.pf-c-dual-list-selector__list-item')) {
                setFocusedOption(element.id);
            }
            else {
                setFocusedOption(element.closest('.pf-c-dual-list-selector__list-item').id);
            }
            return element;
        }, ['.pf-c-dual-list-selector__item-toggle', '.pf-c-dual-list-selector__item-check > input'], undefined, false, false, false);
    };
    react.useEffect(() => {
        window.addEventListener('keydown', handleKeys);
        return () => {
            window.removeEventListener('keydown', handleKeys);
        };
    }, [menuRef.current]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorMenu, className), ref: menuRef, tabIndex: 0 }, props),
        react.createElement(DualListSelectorListContext.Provider, { value: {
                setFocusedOption,
                isTree,
                focusedOption,
                ariaLabelledBy,
                displayOption,
                selectedOptions,
                id,
                options,
                onOptionSelect,
                isDisabled
            } }, children ? children : react.createElement(DualListSelectorList, null))));
};
DualListSelectorListWrapperBase.displayName = 'DualListSelectorListWrapperBase';
const DualListSelectorListWrapper = react.forwardRef((props, ref) => (react.createElement(DualListSelectorListWrapperBase, Object.assign({ innerRef: ref }, props))));
DualListSelectorListWrapper.displayName = 'DualListSelectorListWrapper';
//# sourceMappingURL=DualListSelectorListWrapper.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/arrow-right-icon.js


const ArrowRightIconConfig = {
  name: 'ArrowRightIcon',
  height: 512,
  width: 448,
  svgPath: 'M190.5 66.9l22.2-22.2c9.4-9.4 24.6-9.4 33.9 0L441 239c9.4 9.4 9.4 24.6 0 33.9L246.6 467.3c-9.4 9.4-24.6 9.4-33.9 0l-22.2-22.2c-9.5-9.5-9.3-25 .4-34.3L311.4 296H24c-13.3 0-24-10.7-24-24v-32c0-13.3 10.7-24 24-24h287.4L190.9 101.2c-9.8-9.3-10-24.8-.4-34.3z',
  yOffset: 0,
  xOffset: 0,
};

const ArrowRightIcon = createIcon(ArrowRightIconConfig);

/* harmony default export */ const arrow_right_icon = (ArrowRightIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormGroup.js







const FormGroup = (_a) => {
    var { children = null, className = '', label, labelInfo, labelIcon, isRequired = false, validated = 'default', isInline = false, hasNoPaddingTop = false, isStack = false, helperText, isHelperTextBeforeField = false, helperTextInvalid, helperTextIcon, helperTextInvalidIcon, fieldId, role } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "label", "labelInfo", "labelIcon", "isRequired", "validated", "isInline", "hasNoPaddingTop", "isStack", "helperText", "isHelperTextBeforeField", "helperTextInvalid", "helperTextIcon", "helperTextInvalidIcon", "fieldId", "role"]);
    const validHelperText = typeof helperText !== 'string' ? (helperText) : (react.createElement("div", { className: (0,esm.css)(Form_form["default"].formHelperText, validated === ValidatedOptions.success && Form_form["default"].modifiers.success, validated === ValidatedOptions.warning && Form_form["default"].modifiers.warning), id: `${fieldId}-helper`, "aria-live": "polite" },
        helperTextIcon && react.createElement("span", { className: (0,esm.css)(Form_form["default"].formHelperTextIcon) }, helperTextIcon),
        helperText));
    const inValidHelperText = typeof helperTextInvalid !== 'string' ? (helperTextInvalid) : (react.createElement("div", { className: (0,esm.css)(Form_form["default"].formHelperText, Form_form["default"].modifiers.error), id: `${fieldId}-helper`, "aria-live": "polite" },
        helperTextInvalidIcon && react.createElement("span", { className: (0,esm.css)(Form_form["default"].formHelperTextIcon) }, helperTextInvalidIcon),
        helperTextInvalid));
    const showValidHelperTxt = (validationType) => validationType !== ValidatedOptions.error && helperText ? validHelperText : '';
    const helperTextToDisplay = validated === ValidatedOptions.error && helperTextInvalid ? inValidHelperText : showValidHelperTxt(validated);
    const isGroupOrRadioGroup = role === 'group' || role === 'radiogroup';
    const LabelComponent = isGroupOrRadioGroup ? 'span' : 'label';
    const labelContent = (react.createElement(react.Fragment, null,
        react.createElement(LabelComponent, Object.assign({ className: (0,esm.css)(Form_form["default"].formLabel) }, (!isGroupOrRadioGroup && { htmlFor: fieldId })),
            react.createElement("span", { className: (0,esm.css)(Form_form["default"].formLabelText) }, label),
            isRequired && (react.createElement("span", { className: (0,esm.css)(Form_form["default"].formLabelRequired), "aria-hidden": "true" },
                ' ',
                ASTERISK))),
        ' ',
        react.isValidElement(labelIcon) && labelIcon));
    return (react.createElement(GenerateId, null, randomId => (react.createElement("div", Object.assign({ className: (0,esm.css)(Form_form["default"].formGroup, className) }, (role && { role }), (isGroupOrRadioGroup && { 'aria-labelledby': `${fieldId || randomId}-legend` }), props),
        label && (react.createElement("div", Object.assign({ className: (0,esm.css)(Form_form["default"].formGroupLabel, labelInfo && Form_form["default"].modifiers.info, hasNoPaddingTop && Form_form["default"].modifiers.noPaddingTop) }, (isGroupOrRadioGroup && { id: `${fieldId || randomId}-legend` })),
            labelInfo && (react.createElement(react.Fragment, null,
                react.createElement("div", { className: (0,esm.css)(Form_form["default"].formGroupLabelMain) }, labelContent),
                react.createElement("div", { className: (0,esm.css)(Form_form["default"].formGroupLabelInfo) }, labelInfo))),
            !labelInfo && labelContent)),
        react.createElement("div", { className: (0,esm.css)(Form_form["default"].formGroupControl, isInline && Form_form["default"].modifiers.inline, isStack && Form_form["default"].modifiers.stack) },
            isHelperTextBeforeField && helperTextToDisplay,
            children,
            !isHelperTextBeforeField && helperTextToDisplay)))));
};
FormGroup.displayName = 'FormGroup';
//# sourceMappingURL=FormGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/Form.js




const FormBase = (_a) => {
    var { children = null, className = '', isHorizontal = false, isWidthLimited = false, maxWidth = '', innerRef } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "isHorizontal", "isWidthLimited", "maxWidth", "innerRef"]);
    return (react.createElement("form", Object.assign({ noValidate: true }, (maxWidth && {
        style: Object.assign({ '--pf-c-form--m-limit-width--MaxWidth': maxWidth }, props.style)
    }), props, { className: (0,esm.css)(Form_form["default"].form, isHorizontal && Form_form["default"].modifiers.horizontal, (isWidthLimited || maxWidth) && Form_form["default"].modifiers.limitWidth, className), ref: innerRef }), children));
};
const Form = react.forwardRef((props, ref) => react.createElement(FormBase, Object.assign({ innerRef: ref }, props)));
Form.displayName = 'Form';
//# sourceMappingURL=Form.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/ActionGroup.js




const ActionGroup = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    const customClassName = (0,esm.css)(Form_form["default"].formGroup, Form_form["default"].modifiers.action, className);
    const formActionsComponent = react.createElement("div", { className: (0,esm.css)(Form_form["default"].formActions) }, children);
    return (react.createElement("div", Object.assign({}, props, { className: customClassName }),
        react.createElement("div", { className: (0,esm.css)(Form_form["default"].formGroupControl) }, formActionsComponent)));
};
ActionGroup.displayName = 'ActionGroup';
//# sourceMappingURL=ActionGroup.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Panel/panel.js
var panel = __webpack_require__(31420);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Panel/Panel.js




const PanelBase = (_a) => {
    var { className, children, variant, isScrollable, innerRef } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "variant", "isScrollable", "innerRef"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(panel/* default */.Z.panel, variant === 'raised' && panel/* default */.Z.modifiers.raised, variant === 'bordered' && panel/* default */.Z.modifiers.bordered, isScrollable && panel/* default */.Z.modifiers.scrollable, className), ref: innerRef }, props), children));
};
const Panel = react.forwardRef((props, ref) => (react.createElement(PanelBase, Object.assign({ innerRef: ref }, props))));
Panel.displayName = 'Panel';
//# sourceMappingURL=Panel.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Panel/PanelMain.js




const PanelMain = (_a) => {
    var { className, children, maxHeight } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "maxHeight"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(panel/* default */.Z.panelMain, className), style: { '--pf-c-panel__main--MaxHeight': maxHeight } }, props), children));
};
PanelMain.displayName = 'PanelMain';
//# sourceMappingURL=PanelMain.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Panel/PanelMainBody.js




const PanelMainBody = (_a) => {
    var { className, children } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(panel/* default */.Z.panelMainBody, className) }, props), children));
};
PanelMainBody.displayName = 'PanelMainBody';
//# sourceMappingURL=PanelMainBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/SearchInput/AdvancedSearchMenu.js







const AdvancedSearchMenu = ({ className, parentRef, parentInputRef, value = '', attributes = [], formAdditionalItems, hasWordsAttrLabel = 'Has words', advancedSearchDelimiter, getAttrValueMap, onChange, onSearch, onClear, resetButtonLabel = 'Reset', submitSearchButtonLabel = 'Search', isSearchMenuOpen, onToggleAdvancedMenu }) => {
    const firstAttrRef = react.useRef(null);
    const [putFocusBackOnInput, setPutFocusBackOnInput] = react.useState(false);
    react.useEffect(() => {
        if (attributes.length > 0 && !advancedSearchDelimiter) {
            // eslint-disable-next-line no-console
            console.error('AdvancedSearchMenu: An advancedSearchDelimiter prop is required when advanced search attributes are provided using the attributes prop');
        }
    });
    react.useEffect(() => {
        if (isSearchMenuOpen && firstAttrRef && firstAttrRef.current) {
            firstAttrRef.current.focus();
            setPutFocusBackOnInput(true);
        }
        else if (!isSearchMenuOpen && putFocusBackOnInput && parentInputRef && parentInputRef.current) {
            parentInputRef.current.focus();
        }
    }, [isSearchMenuOpen]);
    react.useEffect(() => {
        document.addEventListener('mousedown', onDocClick);
        document.addEventListener('touchstart', onDocClick);
        document.addEventListener('keydown', onEscPress);
        return function cleanup() {
            document.removeEventListener('mousedown', onDocClick);
            document.removeEventListener('touchstart', onDocClick);
            document.removeEventListener('keydown', onEscPress);
        };
    });
    const onDocClick = (event) => {
        const clickedWithinSearchInput = parentRef && parentRef.current.contains(event.target);
        if (isSearchMenuOpen && !clickedWithinSearchInput) {
            onToggleAdvancedMenu(event);
        }
    };
    const onEscPress = (event) => {
        if (isSearchMenuOpen &&
            event.key === KeyTypes.Escape &&
            parentRef &&
            parentRef.current.contains(event.target)) {
            onToggleAdvancedMenu(event);
            if (parentInputRef) {
                parentInputRef.current.focus();
            }
        }
    };
    const onSearchHandler = (event) => {
        event.preventDefault();
        if (onSearch) {
            onSearch(event, value, getAttrValueMap());
        }
        if (isSearchMenuOpen) {
            onToggleAdvancedMenu(event);
        }
    };
    const handleValueChange = (attribute, newValue, event) => {
        const newMap = getAttrValueMap();
        newMap[attribute] = newValue;
        let updatedValue = '';
        Object.entries(newMap).forEach(([k, v]) => {
            if (v.trim() !== '') {
                /* Wrap the value in quotes if it contains spaces */
                const quoteWrappedValue = v.includes(' ') ? `'${v.replace(/(^'|'$)/g, '')}'` : v;
                if (k !== 'haswords') {
                    updatedValue = `${updatedValue} ${k}${advancedSearchDelimiter}${quoteWrappedValue}`;
                }
                else {
                    updatedValue = `${updatedValue} ${quoteWrappedValue}`;
                }
            }
        });
        if (onChange) {
            onChange(event, updatedValue.replace(/^\s+/g, ''));
        }
    };
    const getValue = (attribute) => {
        const map = getAttrValueMap();
        return map.hasOwnProperty(attribute) ? map[attribute] : '';
    };
    const buildFormGroups = () => {
        const formGroups = [];
        attributes.forEach((attribute, index) => {
            const display = typeof attribute === 'string' ? attribute : attribute.display;
            const queryAttr = typeof attribute === 'string' ? attribute : attribute.attr;
            if (index === 0) {
                formGroups.push(react.createElement(FormGroup, { label: display, fieldId: `${queryAttr}_${index}`, key: `${attribute}_${index}` },
                    react.createElement(TextInput, { ref: firstAttrRef, type: "text", id: `${queryAttr}_${index}`, value: getValue(queryAttr), onChange: (value, evt) => handleValueChange(queryAttr, value, evt) })));
            }
            else {
                formGroups.push(react.createElement(FormGroup, { label: display, fieldId: `${queryAttr}_${index}`, key: `${attribute}_${index}` },
                    react.createElement(TextInput, { type: "text", id: `${queryAttr}_${index}`, value: getValue(queryAttr), onChange: (value, evt) => handleValueChange(queryAttr, value, evt) })));
            }
        });
        formGroups.push(react.createElement(GenerateId, { key: 'hasWords' }, randomId => (react.createElement(FormGroup, { label: hasWordsAttrLabel, fieldId: randomId },
            react.createElement(TextInput, { type: "text", id: randomId, value: getValue('haswords'), onChange: (value, evt) => handleValueChange('haswords', value, evt) })))));
        return formGroups;
    };
    return isSearchMenuOpen ? (react.createElement(Panel, { variant: "raised", className: (0,esm.css)(className) },
        react.createElement(PanelMain, null,
            react.createElement(PanelMainBody, null,
                react.createElement(Form, null,
                    buildFormGroups(),
                    formAdditionalItems ? formAdditionalItems : null,
                    react.createElement(ActionGroup, null,
                        react.createElement(Button, { variant: "primary", type: "submit", onClick: onSearchHandler, isDisabled: !value }, submitSearchButtonLabel),
                        !!onClear && (react.createElement(Button, { variant: "link", type: "reset", onClick: onClear }, resetButtonLabel)))))))) : null;
};
AdvancedSearchMenu.displayName = 'SearchInput';
//# sourceMappingURL=AdvancedSearchMenu.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/TextInputGroup/text-input-group.js
var text_input_group = __webpack_require__(49171);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/TextInputGroup/TextInputGroup.js




const TextInputGroupContext = react.createContext({
    isDisabled: false
});
const TextInputGroup = (_a) => {
    var { children, className, isDisabled, isPlain, innerRef } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "isDisabled", "isPlain", "innerRef"]);
    const ref = react.useRef(null);
    const textInputGroupRef = innerRef || ref;
    return (react.createElement(TextInputGroupContext.Provider, { value: { isDisabled } },
        react.createElement("div", Object.assign({ ref: textInputGroupRef, className: (0,esm.css)(text_input_group/* default */.Z.textInputGroup, isDisabled && text_input_group/* default */.Z.modifiers.disabled, isPlain && text_input_group/* default */.Z.modifiers.plain, className) }, props), children)));
};
TextInputGroup.displayName = 'TextInputGroup';
//# sourceMappingURL=TextInputGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/TextInputGroup/TextInputGroupMain.js





const TextInputGroupMain = (_a) => {
    var { children, className, icon, type = 'text', hint, onChange = () => undefined, onFocus, onBlur, 'aria-label': ariaLabel = 'Type to filter', value: inputValue, placeholder: inputPlaceHolder, innerRef, name } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "icon", "type", "hint", "onChange", "onFocus", "onBlur", 'aria-label', "value", "placeholder", "innerRef", "name"]);
    const { isDisabled } = react.useContext(TextInputGroupContext);
    const ref = react.useRef(null);
    const textInputGroupInputInputRef = innerRef || ref;
    const handleChange = (event) => {
        onChange(event, event.currentTarget.value);
    };
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(text_input_group/* default */.Z.textInputGroupMain, icon && text_input_group/* default */.Z.modifiers.icon, className) }, props),
        children,
        react.createElement("span", { className: (0,esm.css)(text_input_group/* default */.Z.textInputGroupText) },
            hint && (react.createElement("input", { className: (0,esm.css)(text_input_group/* default */.Z.textInputGroupTextInput, text_input_group/* default */.Z.modifiers.hint), type: "text", disabled: true, "aria-hidden": "true", value: hint })),
            icon && react.createElement("span", { className: (0,esm.css)(text_input_group/* default */.Z.textInputGroupIcon) }, icon),
            react.createElement("input", { ref: textInputGroupInputInputRef, type: type, className: (0,esm.css)(text_input_group/* default */.Z.textInputGroupTextInput), "aria-label": ariaLabel, disabled: isDisabled, onChange: handleChange, onFocus: onFocus, onBlur: onBlur, value: inputValue || '', placeholder: inputPlaceHolder, name: name }))));
};
TextInputGroupMain.displayName = 'TextInputGroupMain';
//# sourceMappingURL=TextInputGroupMain.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/TextInputGroup/TextInputGroupUtilities.js




const TextInputGroupUtilities = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(text_input_group/* default */.Z.textInputGroupUtilities, className) }, props), children));
};
TextInputGroupUtilities.displayName = 'TextInputGroupUtilities';
//# sourceMappingURL=TextInputGroupUtilities.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/SearchInput/SearchInput.js















const SearchInputBase = (_a) => {
    var { className, value = '', attributes = [], formAdditionalItems, hasWordsAttrLabel = 'Has words', advancedSearchDelimiter, placeholder, hint, onChange, onSearch, onClear, onToggleAdvancedSearch, isAdvancedSearchOpen, resultsCount, onNextClick, onPreviousClick, innerRef, expandableInput, 'aria-label': ariaLabel = 'Search input', resetButtonLabel = 'Reset', openMenuButtonAriaLabel = 'Open advanced search', previousNavigationButtonAriaLabel = 'Previous', isPreviousNavigationButtonDisabled = false, isNextNavigationButtonDisabled = false, nextNavigationButtonAriaLabel = 'Next', submitSearchButtonLabel = 'Search', isDisabled = false, appendTo, removeFindDomNode = false, zIndex = 9999, type = 'text', name } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "value", "attributes", "formAdditionalItems", "hasWordsAttrLabel", "advancedSearchDelimiter", "placeholder", "hint", "onChange", "onSearch", "onClear", "onToggleAdvancedSearch", "isAdvancedSearchOpen", "resultsCount", "onNextClick", "onPreviousClick", "innerRef", "expandableInput", 'aria-label', "resetButtonLabel", "openMenuButtonAriaLabel", "previousNavigationButtonAriaLabel", "isPreviousNavigationButtonDisabled", "isNextNavigationButtonDisabled", "nextNavigationButtonAriaLabel", "submitSearchButtonLabel", "isDisabled", "appendTo", "removeFindDomNode", "zIndex", "type", "name"]);
    const [isSearchMenuOpen, setIsSearchMenuOpen] = react.useState(false);
    const [searchValue, setSearchValue] = react.useState(value);
    const searchInputRef = react.useRef(null);
    const ref = react.useRef(null);
    const searchInputInputRef = innerRef || ref;
    const searchInputExpandableToggleRef = react.useRef(null);
    const [focusAfterExpandChange, setFocusAfterExpandChange] = react.useState(false);
    const { isExpanded, onToggleExpand, toggleAriaLabel } = expandableInput || {};
    react.useEffect(() => {
        var _a, _b;
        // this effect and the focusAfterExpandChange variable are needed to focus the input/toggle as needed when the
        // expansion toggle is fired without focusing on mount
        if (!focusAfterExpandChange) {
            return;
        }
        else if (isExpanded) {
            (_a = searchInputInputRef === null || searchInputInputRef === void 0 ? void 0 : searchInputInputRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
        else {
            (_b = searchInputExpandableToggleRef === null || searchInputExpandableToggleRef === void 0 ? void 0 : searchInputExpandableToggleRef.current) === null || _b === void 0 ? void 0 : _b.focus();
        }
        setFocusAfterExpandChange(false);
    }, [focusAfterExpandChange, isExpanded, searchInputInputRef, searchInputExpandableToggleRef]);
    react.useEffect(() => {
        setSearchValue(value);
    }, [value]);
    react.useEffect(() => {
        if (attributes.length > 0 && !advancedSearchDelimiter) {
            // eslint-disable-next-line no-console
            console.error('An advancedSearchDelimiter prop is required when advanced search attributes are provided using the attributes prop');
        }
    });
    react.useEffect(() => {
        setIsSearchMenuOpen(isAdvancedSearchOpen);
    }, [isAdvancedSearchOpen]);
    const onChangeHandler = (event, value) => {
        if (onChange) {
            onChange(event, value);
        }
        setSearchValue(value);
    };
    const onToggle = (e) => {
        const isOpen = !isSearchMenuOpen;
        setIsSearchMenuOpen(isOpen);
        if (onToggleAdvancedSearch) {
            onToggleAdvancedSearch(e, isOpen);
        }
    };
    const onSearchHandler = (event) => {
        event.preventDefault();
        if (onSearch) {
            onSearch(event, value, getAttrValueMap());
        }
        setIsSearchMenuOpen(false);
    };
    const splitStringExceptInQuotes = (str) => {
        let quoteType;
        return str.match(/\\?.|^$/g).reduce((p, c) => {
            if (c === "'" || c === '"') {
                if (!quoteType) {
                    quoteType = c;
                }
                if (c === quoteType) {
                    p.quote = !p.quote;
                }
            }
            else if (!p.quote && c === ' ') {
                p.a.push('');
            }
            else {
                p.a[p.a.length - 1] += c.replace(/\\(.)/, '$1');
            }
            return p;
        }, { a: [''] }).a;
    };
    const getAttrValueMap = () => {
        const attrValue = {};
        const pairs = splitStringExceptInQuotes(searchValue);
        pairs.map((pair) => {
            const splitPair = pair.split(advancedSearchDelimiter);
            if (splitPair.length === 2) {
                attrValue[splitPair[0]] = splitPair[1].replace(/(^'|'$)/g, '');
            }
            else if (splitPair.length === 1) {
                attrValue.haswords = attrValue.hasOwnProperty('haswords')
                    ? `${attrValue.haswords} ${splitPair[0]}`
                    : splitPair[0];
            }
        });
        return attrValue;
    };
    const onEnter = (event) => {
        if (event.key === 'Enter') {
            onSearchHandler(event);
        }
    };
    const onClearInput = (e) => {
        if (onClear) {
            onClear(e);
        }
        if (searchInputInputRef && searchInputInputRef.current) {
            searchInputInputRef.current.focus();
        }
    };
    const onExpandHandler = (event) => {
        setSearchValue('');
        onToggleExpand(event, isExpanded);
        setFocusAfterExpandChange(true);
    };
    const renderUtilities = value && (resultsCount || (!!onNextClick && !!onPreviousClick) || (!!onClear && !expandableInput));
    const buildTextInputGroup = (_a = {}) => {
        var searchInputProps = (0,tslib_es6.__rest)(_a, []);
        return (react.createElement(TextInputGroup, Object.assign({ isDisabled: isDisabled }, searchInputProps),
            react.createElement(TextInputGroupMain, { hint: hint, icon: react.createElement(search_icon, null), innerRef: searchInputInputRef, value: searchValue, placeholder: placeholder, "aria-label": ariaLabel, onKeyDown: onEnter, onChange: onChangeHandler, type: type, name: name }),
            renderUtilities && (react.createElement(TextInputGroupUtilities, null,
                resultsCount && react.createElement(Badge, { isRead: true }, resultsCount),
                !!onNextClick && !!onPreviousClick && (react.createElement("div", { className: "pf-c-text-input-group__group" },
                    react.createElement(Button, { variant: ButtonVariant.plain, "aria-label": previousNavigationButtonAriaLabel, isDisabled: isDisabled || isPreviousNavigationButtonDisabled, onClick: onPreviousClick },
                        react.createElement(angle_up_icon, null)),
                    react.createElement(Button, { variant: ButtonVariant.plain, "aria-label": nextNavigationButtonAriaLabel, isDisabled: isDisabled || isNextNavigationButtonDisabled, onClick: onNextClick },
                        react.createElement(angle_down_icon, null)))),
                !!onClear && !expandableInput && (react.createElement(Button, { variant: ButtonVariant.plain, isDisabled: isDisabled, "aria-label": resetButtonLabel, onClick: onClearInput },
                    react.createElement(times_icon, null)))))));
    };
    const expandableToggle = (react.createElement(Button, { variant: ButtonVariant.plain, "aria-label": toggleAriaLabel, "aria-expanded": isExpanded, icon: isExpanded ? react.createElement(times_icon, null) : react.createElement(search_icon, null), onClick: onExpandHandler, ref: searchInputExpandableToggleRef }));
    const buildExpandableSearchInput = (_a = {}) => {
        var searchInputProps = (0,tslib_es6.__rest)(_a, []);
        return (react.createElement(InputGroup, Object.assign({}, searchInputProps),
            buildTextInputGroup(),
            expandableToggle));
    };
    const buildSearchTextInputGroup = (_a = {}) => {
        var searchInputProps = (0,tslib_es6.__rest)(_a, []);
        if (expandableInput) {
            return buildExpandableSearchInput(Object.assign({}, searchInputProps));
        }
        return buildTextInputGroup(Object.assign({}, searchInputProps));
    };
    const buildSearchTextInputGroupWithExtraButtons = (_a = {}) => {
        var searchInputProps = (0,tslib_es6.__rest)(_a, []);
        return (react.createElement(InputGroup, Object.assign({}, searchInputProps),
            buildTextInputGroup(),
            (attributes.length > 0 || onToggleAdvancedSearch) && (react.createElement(Button, { className: isSearchMenuOpen && 'pf-m-expanded', variant: ButtonVariant.control, "aria-label": openMenuButtonAriaLabel, onClick: onToggle, isDisabled: isDisabled, "aria-expanded": isSearchMenuOpen },
                react.createElement(caret_down_icon, null))),
            !!onSearch && (react.createElement(Button, { type: "submit", variant: ButtonVariant.control, "aria-label": submitSearchButtonLabel, onClick: onSearchHandler, isDisabled: isDisabled || !searchValue },
                react.createElement(arrow_right_icon, null))),
            expandableInput && expandableToggle));
    };
    const searchInputProps = Object.assign(Object.assign({}, props), { className: className && (0,esm.css)(className), innerRef: searchInputRef });
    if (!!expandableInput && !isExpanded) {
        return react.createElement(InputGroup, Object.assign({}, searchInputProps), expandableToggle);
    }
    if (!!onSearch || attributes.length > 0 || !!onToggleAdvancedSearch) {
        if (attributes.length > 0) {
            const AdvancedSearch = (react.createElement("div", null,
                react.createElement(AdvancedSearchMenu, { value: value, parentRef: searchInputRef, parentInputRef: searchInputInputRef, onSearch: onSearch, onClear: onClear, onChange: onChange, onToggleAdvancedMenu: onToggle, resetButtonLabel: resetButtonLabel, submitSearchButtonLabel: submitSearchButtonLabel, attributes: attributes, formAdditionalItems: formAdditionalItems, hasWordsAttrLabel: hasWordsAttrLabel, advancedSearchDelimiter: advancedSearchDelimiter, getAttrValueMap: getAttrValueMap, isSearchMenuOpen: isSearchMenuOpen })));
            const AdvancedSearchWithPopper = (react.createElement("div", Object.assign({ className: (0,esm.css)(className), ref: searchInputRef }, props),
                react.createElement(Popper_Popper, { trigger: buildSearchTextInputGroupWithExtraButtons(), popper: AdvancedSearch, isVisible: isSearchMenuOpen, enableFlip: true, appendTo: () => appendTo || searchInputRef.current, removeFindDomNode: removeFindDomNode, zIndex: zIndex })));
            const AdvancedSearchInline = (react.createElement("div", Object.assign({ className: (0,esm.css)(className), ref: searchInputRef }, props),
                buildSearchTextInputGroupWithExtraButtons(),
                AdvancedSearch));
            return appendTo !== 'inline' ? AdvancedSearchWithPopper : AdvancedSearchInline;
        }
        return buildSearchTextInputGroupWithExtraButtons(Object.assign({}, searchInputProps));
    }
    return buildSearchTextInputGroup(searchInputProps);
};
SearchInputBase.displayName = 'SearchInputBase';
const SearchInput = react.forwardRef((props, ref) => (react.createElement(SearchInputBase, Object.assign({}, props, { innerRef: ref }))));
SearchInput.displayName = 'SearchInput';
//# sourceMappingURL=SearchInput.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorPane.js










const DualListSelectorPane = (_a) => {
    var { isChosen = false, className = '', status = '', actions, searchInput, children, onOptionSelect, onOptionCheck, title = '', options = [], selectedOptions = [], isSearchable = false, searchInputAriaLabel = '', onFilterUpdate, onSearchInputChanged, onSearchInputClear, filterOption, id = getUniqueId('dual-list-selector-pane'), isDisabled = false, listMinHeight } = _a, props = (0,tslib_es6.__rest)(_a, ["isChosen", "className", "status", "actions", "searchInput", "children", "onOptionSelect", "onOptionCheck", "title", "options", "selectedOptions", "isSearchable", "searchInputAriaLabel", "onFilterUpdate", "onSearchInputChanged", "onSearchInputClear", "filterOption", "id", "isDisabled", "listMinHeight"]);
    const [input, setInput] = react.useState('');
    const { isTree } = react.useContext(DualListSelectorContext);
    // only called when search input is dynamically built
    const onChange = (e, newValue) => {
        let filtered;
        if (isTree) {
            filtered = options
                .map(opt => Object.assign({}, opt))
                .filter(item => filterInput(item, newValue));
        }
        else {
            filtered = options.filter(option => {
                if (displayOption(option)) {
                    return option;
                }
            });
        }
        onFilterUpdate(filtered, isChosen ? 'chosen' : 'available', newValue === '');
        if (onSearchInputChanged) {
            onSearchInputChanged(newValue, e);
        }
        setInput(newValue);
    };
    // only called when options are passed via options prop and isTree === true
    const filterInput = (item, input) => {
        if (filterOption) {
            return filterOption(item, input);
        }
        else {
            if (item.text.toLowerCase().includes(input.toLowerCase()) || input === '') {
                return true;
            }
        }
        if (item.children) {
            return ((item.children = item.children.map(opt => Object.assign({}, opt)).filter(child => filterInput(child, input)))
                .length > 0);
        }
    };
    // only called when options are passed via options prop and isTree === false
    const displayOption = (option) => {
        if (filterOption) {
            return filterOption(option, input);
        }
        else {
            return option
                .toString()
                .toLowerCase()
                .includes(input.toLowerCase());
        }
    };
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorPane, isChosen ? dual_list_selector/* default */.Z.modifiers.chosen : 'pf-m-available', className) }, props),
        title && (react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorHeader) },
            react.createElement("div", { className: "pf-c-dual-list-selector__title" },
                react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorTitleText) }, title)))),
        (actions || searchInput || isSearchable) && (react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorTools) },
            (isSearchable || searchInput) && (react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorToolsFilter) }, searchInput ? (searchInput) : (react.createElement(SearchInput, { onChange: isDisabled ? undefined : onChange, onClear: onSearchInputClear ? onSearchInputClear : e => onChange(e, ''), isDisabled: isDisabled, "aria-label": searchInputAriaLabel, type: "search" })))),
            actions && react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorToolsActions) }, actions))),
        status && (react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorStatus) },
            react.createElement("div", { className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorStatusText), id: `${id}-status` }, status))),
        react.createElement(DualListSelectorPaneContext.Provider, { value: { isChosen } },
            !isTree && (react.createElement(DualListSelectorListWrapper, Object.assign({ "aria-labelledby": `${id}-status`, options: options, selectedOptions: selectedOptions, onOptionSelect: (e, index, id) => onOptionSelect(e, index, isChosen, id), displayOption: displayOption, id: `${id}-list`, isDisabled: isDisabled }, (listMinHeight && {
                style: { '--pf-c-dual-list-selector__menu--MinHeight': listMinHeight }
            })), children)),
            isTree && (react.createElement(DualListSelectorListWrapper, Object.assign({ "aria-labelledby": `${id}-status`, id: `${id}-list` }, (listMinHeight && {
                style: { '--pf-c-dual-list-selector__menu--MinHeight': listMinHeight }
            })), options.length > 0 ? (react.createElement(DualListSelectorList, null,
                react.createElement(DualListSelectorTree, { data: isSearchable
                        ? options
                            .map(opt => Object.assign({}, opt))
                            .filter(item => filterInput(item, input))
                        : options, onOptionCheck: onOptionCheck, id: `${id}-tree`, isDisabled: isDisabled }))) : (children))))));
};
DualListSelectorPane.displayName = 'DualListSelectorPane';
//# sourceMappingURL=DualListSelectorPane.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorControlsWrapper.js





const DualListSelectorControlsWrapperBase = (_a) => {
    var { innerRef, children = null, className, 'aria-label': ariaLabel = 'Controls for moving options between lists' } = _a, props = (0,tslib_es6.__rest)(_a, ["innerRef", "children", "className", 'aria-label']);
    const ref = react.useRef(null);
    const wrapperRef = innerRef || ref;
    // Adds keyboard navigation to the dynamically built dual list selector controls. Works when controls are dynamically built
    // as well as when they are passed in via children.
    const handleKeys = (event) => {
        if (!wrapperRef.current ||
            (wrapperRef.current !== event.target.closest('.pf-c-dual-list-selector__controls') &&
                !Array.from(wrapperRef.current.getElementsByClassName('pf-c-dual-list-selector__controls')).includes(event.target.closest('.pf-c-dual-list-selector__controls')))) {
            return;
        }
        event.stopImmediatePropagation();
        const controls = Array.from(wrapperRef.current.getElementsByTagName('BUTTON')).filter(el => !el.classList.contains('pf-m-disabled'));
        const activeElement = document.activeElement;
        handleArrows(event, controls, (element) => activeElement.contains(element), (element) => element, undefined, undefined, true, false);
    };
    react.useEffect(() => {
        window.addEventListener('keydown', handleKeys);
        return () => {
            window.removeEventListener('keydown', handleKeys);
        };
    }, [wrapperRef.current]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelectorControls, className), tabIndex: 0, ref: wrapperRef, "aria-label": ariaLabel }, props), children));
};
DualListSelectorControlsWrapperBase.displayName = 'DualListSelectorControlsWrapperBase';
const DualListSelectorControlsWrapper = react.forwardRef((props, ref) => (react.createElement(DualListSelectorControlsWrapperBase, Object.assign({ innerRef: ref, role: "group" }, props))));
DualListSelectorControlsWrapper.displayName = 'DualListSelectorControlsWrapper';
//# sourceMappingURL=DualListSelectorControlsWrapper.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelectorControl.js





const DualListSelectorControlBase = (_a) => {
    var { innerRef, children = null, className, 'aria-label': ariaLabel, isDisabled = true, onClick = () => { }, tooltipContent, tooltipProps = {} } = _a, props = (0,tslib_es6.__rest)(_a, ["innerRef", "children", "className", 'aria-label', "isDisabled", "onClick", "tooltipContent", "tooltipProps"]);
    const privateRef = react.useRef(null);
    const ref = innerRef || privateRef;
    return (react.createElement("div", Object.assign({ className: (0,esm.css)('pf-c-dual-list-selector__controls-item', className) }, props),
        react.createElement(Button, { isDisabled: isDisabled, "aria-disabled": isDisabled, variant: ButtonVariant.plain, onClick: onClick, "aria-label": ariaLabel, tabIndex: -1, ref: ref }, children),
        tooltipContent && react.createElement(Tooltip, Object.assign({ content: tooltipContent, position: "left", reference: ref }, tooltipProps))));
};
DualListSelectorControlBase.displayName = 'DualListSelectorControlBase';
const DualListSelectorControl = react.forwardRef((props, ref) => (react.createElement(DualListSelectorControlBase, Object.assign({ innerRef: ref }, props))));
DualListSelectorControl.displayName = 'DualListSelectorControl';
//# sourceMappingURL=DualListSelectorControl.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/DualListSelector.js














class DualListSelector extends react.Component {
    constructor(props) {
        super(props);
        this.addAllButtonRef = react.createRef();
        this.addSelectedButtonRef = react.createRef();
        this.removeSelectedButtonRef = react.createRef();
        this.removeAllButtonRef = react.createRef();
        /** In dev environment, prevents circular structure during JSON stringification when
         * options passed in to the dual list selector include HTML elements.
         */
        this.replacer = (key, value) => {
            if (key[0] === '_') {
                return undefined;
            }
            return value;
        };
        this.onFilterUpdate = (newFilteredOptions, paneType, isSearchReset) => {
            const { isTree } = this.props;
            if (paneType === 'available') {
                if (isSearchReset) {
                    this.setState({
                        availableFilteredOptions: null,
                        availableTreeFilteredOptions: null
                    });
                    return;
                }
                if (isTree) {
                    this.setState({
                        availableTreeFilteredOptions: flattenTreeWithFolders(newFilteredOptions)
                    });
                }
                else {
                    this.setState({
                        availableFilteredOptions: newFilteredOptions
                    });
                }
            }
            else if (paneType === 'chosen') {
                if (isSearchReset) {
                    this.setState({
                        chosenFilteredOptions: null,
                        chosenTreeFilteredOptions: null
                    });
                    return;
                }
                if (isTree) {
                    this.setState({
                        chosenTreeFilteredOptions: flattenTreeWithFolders(newFilteredOptions)
                    });
                }
                else {
                    this.setState({
                        chosenFilteredOptions: newFilteredOptions
                    });
                }
            }
        };
        this.addAllVisible = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newAvailable = [];
                const movedOptions = prevState.availableFilteredOptions || prevState.availableOptions;
                prevState.availableOptions.forEach(value => {
                    if (movedOptions.indexOf(value) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newAvailable.push(value);
                    }
                });
                const newChosen = [...prevState.chosenOptions, ...itemsToRemove];
                this.props.addAll && this.props.addAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable,
                    chosenOptionsSelected: [],
                    availableOptionsSelected: []
                };
            });
        };
        this.addAllTreeVisible = () => {
            this.setState(prevState => {
                const movedOptions = prevState.availableTreeFilteredOptions ||
                    flattenTreeWithFolders(prevState.availableOptions);
                const newAvailable = prevState.availableOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterRestTreeItems(item, movedOptions));
                const currChosen = flattenTree(prevState.chosenOptions);
                const nextChosenOptions = currChosen.concat(movedOptions);
                const newChosen = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterTreeItemsWithoutFolders(item, nextChosenOptions));
                this.props.addAll && this.props.addAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable,
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: []
                };
            });
        };
        this.addSelected = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newAvailable = [];
                prevState.availableOptions.forEach((value, index) => {
                    if (prevState.availableOptionsSelected.indexOf(index) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newAvailable.push(value);
                    }
                });
                const newChosen = [...prevState.chosenOptions, ...itemsToRemove];
                this.props.addSelected && this.props.addSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptionsSelected: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable
                };
            });
        };
        this.addTreeSelected = () => {
            this.setState(prevState => {
                // Remove selected available nodes from current available nodes
                const newAvailable = prevState.availableOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterRestTreeItems(item, prevState.availableTreeOptionsChecked));
                // Get next chosen options from current + new nodes and remap from base
                const currChosen = flattenTree(prevState.chosenOptions);
                const nextChosenOptions = currChosen.concat(prevState.availableTreeOptionsChecked);
                const newChosen = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterTreeItemsWithoutFolders(item, nextChosenOptions));
                this.props.addSelected && this.props.addSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: [],
                    availableOptions: newAvailable,
                    chosenOptions: newChosen
                };
            });
        };
        this.removeAllVisible = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newChosen = [];
                const movedOptions = prevState.chosenFilteredOptions || prevState.chosenOptions;
                prevState.chosenOptions.forEach(value => {
                    if (movedOptions.indexOf(value) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newChosen.push(value);
                    }
                });
                const newAvailable = [...prevState.availableOptions, ...itemsToRemove];
                this.props.removeAll && this.props.removeAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable,
                    chosenOptionsSelected: [],
                    availableOptionsSelected: []
                };
            });
        };
        this.removeAllTreeVisible = () => {
            this.setState(prevState => {
                const movedOptions = prevState.chosenTreeFilteredOptions ||
                    flattenTreeWithFolders(prevState.chosenOptions);
                const newChosen = prevState.chosenOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterRestTreeItems(item, movedOptions));
                const currAvailable = flattenTree(prevState.availableOptions);
                const nextAvailableOptions = currAvailable.concat(movedOptions);
                const newAvailable = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterTreeItemsWithoutFolders(item, nextAvailableOptions));
                this.props.removeAll && this.props.removeAll(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptions: newChosen,
                    availableOptions: newAvailable,
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: []
                };
            });
        };
        this.removeSelected = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newChosen = [];
                prevState.chosenOptions.forEach((value, index) => {
                    if (prevState.chosenOptionsSelected.indexOf(index) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newChosen.push(value);
                    }
                });
                const newAvailable = [...prevState.availableOptions, ...itemsToRemove];
                this.props.removeSelected && this.props.removeSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    chosenOptionsSelected: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    chosenFilteredOptions: newChosen,
                    availableOptions: newAvailable,
                    availableFilteredOptions: newAvailable
                };
            });
        };
        this.removeTreeSelected = () => {
            this.setState(prevState => {
                // Remove selected chosen nodes from current chosen nodes
                const newChosen = prevState.chosenOptions
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterRestTreeItems(item, prevState.chosenTreeOptionsChecked));
                // Get next chosen options from current and remap from base
                const currAvailable = flattenTree(prevState.availableOptions);
                const nextAvailableOptions = currAvailable.concat(prevState.chosenTreeOptionsChecked);
                const newAvailable = this.createMergedCopy()
                    .map(opt => Object.assign({}, opt))
                    .filter(item => filterTreeItemsWithoutFolders(item, nextAvailableOptions));
                this.props.removeSelected && this.props.removeSelected(newAvailable, newChosen);
                this.props.onListChange && this.props.onListChange(newAvailable, newChosen);
                return {
                    availableTreeOptionsChecked: [],
                    chosenTreeOptionsChecked: [],
                    availableOptions: newAvailable,
                    chosenOptions: newChosen
                };
            });
        };
        this.onOptionSelect = (e, index, isChosen, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        id, itemData, parentData
        /* eslint-enable @typescript-eslint/no-unused-vars */
        ) => {
            this.setState(prevState => {
                const originalArray = isChosen ? prevState.chosenOptionsSelected : prevState.availableOptionsSelected;
                let updatedArray = null;
                if (originalArray.indexOf(index) !== -1) {
                    updatedArray = originalArray.filter(value => value !== index);
                }
                else {
                    updatedArray = [...originalArray, index];
                }
                return {
                    chosenOptionsSelected: isChosen ? updatedArray : prevState.chosenOptionsSelected,
                    availableOptionsSelected: isChosen ? prevState.availableOptionsSelected : updatedArray
                };
            });
            this.props.onOptionSelect && this.props.onOptionSelect(e, index, isChosen, id, itemData, parentData);
        };
        this.isChecked = (treeItem, isChosen) => isChosen
            ? this.state.chosenTreeOptionsChecked.includes(treeItem.id)
            : this.state.availableTreeOptionsChecked.includes(treeItem.id);
        this.areAllDescendantsChecked = (treeItem, isChosen) => treeItem.children
            ? treeItem.children.every(child => this.areAllDescendantsChecked(child, isChosen))
            : this.isChecked(treeItem, isChosen);
        this.areSomeDescendantsChecked = (treeItem, isChosen) => treeItem.children
            ? treeItem.children.some(child => this.areSomeDescendantsChecked(child, isChosen))
            : this.isChecked(treeItem, isChosen);
        this.mapChecked = (item, isChosen) => {
            const hasCheck = this.areAllDescendantsChecked(item, isChosen);
            item.isChecked = false;
            if (hasCheck) {
                item.isChecked = true;
            }
            else {
                const hasPartialCheck = this.areSomeDescendantsChecked(item, isChosen);
                if (hasPartialCheck) {
                    item.isChecked = null;
                }
            }
            if (item.children) {
                return Object.assign(Object.assign({}, item), { children: item.children.map(child => this.mapChecked(child, isChosen)) });
            }
            return item;
        };
        this.onTreeOptionCheck = (evt, isChecked, itemData, isChosen) => {
            const { availableOptions, availableTreeFilteredOptions, chosenOptions, chosenTreeFilteredOptions } = this.state;
            let panelOptions;
            if (isChosen) {
                if (chosenTreeFilteredOptions) {
                    panelOptions = chosenOptions
                        .map(opt => Object.assign({}, opt))
                        .filter(item => filterTreeItemsWithoutFolders(item, chosenTreeFilteredOptions));
                }
                else {
                    panelOptions = chosenOptions;
                }
            }
            else {
                if (availableTreeFilteredOptions) {
                    panelOptions = availableOptions
                        .map(opt => Object.assign({}, opt))
                        .filter(item => filterTreeItemsWithoutFolders(item, availableTreeFilteredOptions));
                }
                else {
                    panelOptions = availableOptions;
                }
            }
            const checkedOptionTree = panelOptions
                .map(opt => Object.assign({}, opt))
                .filter(item => filterTreeItems(item, [itemData.id]));
            const flatTree = flattenTreeWithFolders(checkedOptionTree);
            const prevChecked = isChosen ? this.state.chosenTreeOptionsChecked : this.state.availableTreeOptionsChecked;
            let updatedChecked = [];
            if (isChecked) {
                updatedChecked = prevChecked.concat(flatTree.filter(id => !prevChecked.includes(id)));
            }
            else {
                updatedChecked = prevChecked.filter(id => !flatTree.includes(id));
            }
            this.setState(prevState => ({
                availableTreeOptionsChecked: isChosen ? prevState.availableTreeOptionsChecked : updatedChecked,
                chosenTreeOptionsChecked: isChosen ? updatedChecked : prevState.chosenTreeOptionsChecked
            }), () => {
                this.props.onOptionCheck && this.props.onOptionCheck(evt, isChecked, itemData.id, updatedChecked);
            });
        };
        this.state = {
            availableOptions: [...this.props.availableOptions],
            availableOptionsSelected: [],
            availableFilteredOptions: null,
            availableTreeFilteredOptions: null,
            chosenOptions: [...this.props.chosenOptions],
            chosenOptionsSelected: [],
            chosenFilteredOptions: null,
            chosenTreeFilteredOptions: null,
            availableTreeOptionsChecked: [],
            chosenTreeOptionsChecked: []
        };
    }
    // If the DualListSelector uses trees, concat the two initial arrays and merge duplicate folder IDs
    createMergedCopy() {
        const copyOfAvailable = JSON.parse(JSON.stringify(this.props.availableOptions));
        const copyOfChosen = JSON.parse(JSON.stringify(this.props.chosenOptions));
        return this.props.isTree
            ? Object.values(copyOfAvailable
                .concat(copyOfChosen)
                .reduce((mapObj, item) => {
                const key = item.id;
                if (mapObj[key]) {
                    // If map already has an item ID, add the dupe ID's children to the existing map
                    mapObj[key].children.push(...item.children);
                }
                else {
                    // Else clone the item data
                    mapObj[key] = Object.assign({}, item);
                }
                return mapObj;
            }, {}))
            : null;
    }
    componentDidUpdate() {
        if (JSON.stringify(this.props.availableOptions, this.replacer) !==
            JSON.stringify(this.state.availableOptions, this.replacer) ||
            JSON.stringify(this.props.chosenOptions, this.replacer) !==
                JSON.stringify(this.state.chosenOptions, this.replacer)) {
            this.setState({
                availableOptions: [...this.props.availableOptions],
                chosenOptions: [...this.props.chosenOptions]
            });
        }
    }
    render() {
        const _a = this.props, { availableOptionsTitle, availableOptionsActions, availableOptionsSearchAriaLabel, className, children, chosenOptionsTitle, chosenOptionsActions, chosenOptionsSearchAriaLabel, filterOption, isSearchable, chosenOptionsStatus, availableOptionsStatus, controlsAriaLabel, addAllAriaLabel, addSelectedAriaLabel, removeSelectedAriaLabel, removeAllAriaLabel, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        availableOptions: consumerPassedAvailableOptions, chosenOptions: consumerPassedChosenOptions, removeSelected, addAll, removeAll, addSelected, onListChange, onAvailableOptionsSearchInputChanged, onChosenOptionsSearchInputChanged, onOptionSelect, onOptionCheck, id, isTree, isDisabled, addAllTooltip, addAllTooltipProps, addSelectedTooltip, addSelectedTooltipProps, removeAllTooltip, removeAllTooltipProps, removeSelectedTooltip, removeSelectedTooltipProps } = _a, props = (0,tslib_es6.__rest)(_a, ["availableOptionsTitle", "availableOptionsActions", "availableOptionsSearchAriaLabel", "className", "children", "chosenOptionsTitle", "chosenOptionsActions", "chosenOptionsSearchAriaLabel", "filterOption", "isSearchable", "chosenOptionsStatus", "availableOptionsStatus", "controlsAriaLabel", "addAllAriaLabel", "addSelectedAriaLabel", "removeSelectedAriaLabel", "removeAllAriaLabel", "availableOptions", "chosenOptions", "removeSelected", "addAll", "removeAll", "addSelected", "onListChange", "onAvailableOptionsSearchInputChanged", "onChosenOptionsSearchInputChanged", "onOptionSelect", "onOptionCheck", "id", "isTree", "isDisabled", "addAllTooltip", "addAllTooltipProps", "addSelectedTooltip", "addSelectedTooltipProps", "removeAllTooltip", "removeAllTooltipProps", "removeSelectedTooltip", "removeSelectedTooltipProps"]);
        const { availableOptions, chosenOptions, chosenOptionsSelected, availableOptionsSelected, chosenTreeOptionsChecked, availableTreeOptionsChecked } = this.state;
        const availableOptionsStatusToDisplay = availableOptionsStatus ||
            (isTree
                ? `${filterFolders(availableOptions, availableTreeOptionsChecked)
                    .length} of ${flattenTree(availableOptions).length} items selected`
                : `${availableOptionsSelected.length} of ${availableOptions.length} items selected`);
        const chosenOptionsStatusToDisplay = chosenOptionsStatus ||
            (isTree
                ? `${filterFolders(chosenOptions, chosenTreeOptionsChecked).length} of ${flattenTree(chosenOptions).length} items selected`
                : `${chosenOptionsSelected.length} of ${chosenOptions.length} items selected`);
        const available = (isTree
            ? availableOptions.map(item => this.mapChecked(item, false))
            : availableOptions);
        const chosen = (isTree
            ? chosenOptions.map(item => this.mapChecked(item, true))
            : chosenOptions);
        return (react.createElement(DualListSelectorContext.Provider, { value: { isTree } },
            react.createElement(GenerateId, null, randomId => (react.createElement("div", Object.assign({ className: (0,esm.css)(dual_list_selector/* default */.Z.dualListSelector, className), id: id || randomId }, props), children === '' ? (react.createElement(react.Fragment, null,
                react.createElement(DualListSelectorPane, { isSearchable: isSearchable, onFilterUpdate: this.onFilterUpdate, searchInputAriaLabel: availableOptionsSearchAriaLabel, filterOption: filterOption, onSearchInputChanged: onAvailableOptionsSearchInputChanged, status: availableOptionsStatusToDisplay, title: availableOptionsTitle, options: available, selectedOptions: isTree ? availableTreeOptionsChecked : availableOptionsSelected, onOptionSelect: this.onOptionSelect, onOptionCheck: (e, isChecked, itemData) => this.onTreeOptionCheck(e, isChecked, itemData, false), actions: availableOptionsActions, id: `${id || randomId}-available-pane`, isDisabled: isDisabled }),
                react.createElement(DualListSelectorControlsWrapper, { "aria-label": controlsAriaLabel },
                    react.createElement(DualListSelectorControl, { isDisabled: (isTree ? availableTreeOptionsChecked.length === 0 : availableOptionsSelected.length === 0) ||
                            isDisabled, onClick: isTree ? this.addTreeSelected : this.addSelected, ref: this.addSelectedButtonRef, "aria-label": addSelectedAriaLabel, tooltipContent: addSelectedTooltip, tooltipProps: addSelectedTooltipProps },
                        react.createElement(angle_right_icon, null)),
                    react.createElement(DualListSelectorControl, { isDisabled: availableOptions.length === 0 || isDisabled, onClick: isTree ? this.addAllTreeVisible : this.addAllVisible, ref: this.addAllButtonRef, "aria-label": addAllAriaLabel, tooltipContent: addAllTooltip, tooltipProps: addAllTooltipProps },
                        react.createElement(angle_double_right_icon, null)),
                    react.createElement(DualListSelectorControl, { isDisabled: chosenOptions.length === 0 || isDisabled, onClick: isTree ? this.removeAllTreeVisible : this.removeAllVisible, "aria-label": removeAllAriaLabel, ref: this.removeAllButtonRef, tooltipContent: removeAllTooltip, tooltipProps: removeAllTooltipProps },
                        react.createElement(angle_double_left_icon, null)),
                    react.createElement(DualListSelectorControl, { onClick: isTree ? this.removeTreeSelected : this.removeSelected, isDisabled: (isTree ? chosenTreeOptionsChecked.length === 0 : chosenOptionsSelected.length === 0) ||
                            isDisabled, ref: this.removeSelectedButtonRef, "aria-label": removeSelectedAriaLabel, tooltipContent: removeSelectedTooltip, tooltipProps: removeSelectedTooltipProps },
                        react.createElement(angle_left_icon, null))),
                react.createElement(DualListSelectorPane, { isChosen: true, isSearchable: isSearchable, onFilterUpdate: this.onFilterUpdate, searchInputAriaLabel: chosenOptionsSearchAriaLabel, filterOption: filterOption, onSearchInputChanged: onChosenOptionsSearchInputChanged, title: chosenOptionsTitle, status: chosenOptionsStatusToDisplay, options: chosen, selectedOptions: isTree ? chosenTreeOptionsChecked : chosenOptionsSelected, onOptionSelect: this.onOptionSelect, onOptionCheck: (e, isChecked, itemData) => this.onTreeOptionCheck(e, isChecked, itemData, true), actions: chosenOptionsActions, id: `${id || randomId}-chosen-pane`, isDisabled: isDisabled }))) : (children))))));
    }
}
DualListSelector.displayName = 'DualListSelector';
DualListSelector.defaultProps = {
    children: '',
    availableOptions: [],
    availableOptionsTitle: 'Available options',
    availableOptionsSearchAriaLabel: 'Available search input',
    chosenOptions: [],
    chosenOptionsTitle: 'Chosen options',
    chosenOptionsSearchAriaLabel: 'Chosen search input',
    controlsAriaLabel: 'Selector controls',
    addAllAriaLabel: 'Add all',
    addSelectedAriaLabel: 'Add selected',
    removeSelectedAriaLabel: 'Remove selected',
    removeAllAriaLabel: 'Remove all',
    isTree: false,
    isDisabled: false
};
//# sourceMappingURL=DualListSelector.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/DualListSelector/index.js







//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/EmptyState/empty-state.js
var empty_state = __webpack_require__(49621);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/EmptyState/EmptyState.js




var EmptyStateVariant;
(function (EmptyStateVariant) {
    EmptyStateVariant["xs"] = "xs";
    EmptyStateVariant["small"] = "small";
    EmptyStateVariant["large"] = "large";
    EmptyStateVariant["xl"] = "xl";
    EmptyStateVariant["full"] = "full";
})(EmptyStateVariant || (EmptyStateVariant = {}));
const EmptyState = (_a) => {
    var { children, className = '', variant = EmptyStateVariant.full, isFullHeight } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "variant", "isFullHeight"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(empty_state["default"].emptyState, variant === 'xs' && empty_state["default"].modifiers.xs, variant === 'small' && empty_state["default"].modifiers.sm, variant === 'large' && empty_state["default"].modifiers.lg, variant === 'xl' && empty_state["default"].modifiers.xl, isFullHeight && empty_state["default"].modifiers.fullHeight, className) }, props),
        react.createElement("div", { className: (0,esm.css)(empty_state["default"].emptyStateContent) }, children)));
};
EmptyState.displayName = 'EmptyState';
//# sourceMappingURL=EmptyState.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateBody.js




const EmptyStateBody = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(empty_state["default"].emptyStateBody, className) }, props), children));
};
EmptyStateBody.displayName = 'EmptyStateBody';
//# sourceMappingURL=EmptyStateBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateIcon.js




const EmptyStateIcon = (_a) => {
    var { className = '', icon: IconComponent, component: AnyComponent, variant = 'icon' } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "icon", "component", "variant"]);
    const classNames = (0,esm.css)(empty_state["default"].emptyStateIcon, className);
    return variant === 'icon' ? (react.createElement(IconComponent, Object.assign({ className: classNames }, props, { "aria-hidden": "true" }))) : (react.createElement("div", { className: classNames },
        react.createElement(AnyComponent, null)));
};
EmptyStateIcon.displayName = 'EmptyStateIcon';
//# sourceMappingURL=EmptyStateIcon.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/EmptyState/EmptyStateSecondaryActions.js




const EmptyStateSecondaryActions = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(empty_state["default"].emptyStateSecondary, className) }, props), children));
};
EmptyStateSecondaryActions.displayName = 'EmptyStateSecondaryActions';
//# sourceMappingURL=EmptyStateSecondaryActions.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/EmptyState/EmptyStatePrimary.js




const EmptyStatePrimary = (_a) => {
    var { children, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(empty_state["default"].emptyStatePrimary, className) }, props), children));
};
EmptyStatePrimary.displayName = 'EmptyStatePrimary';
//# sourceMappingURL=EmptyStatePrimary.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/EmptyState/index.js





//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/ExpandableSection/expandable-section.js
var expandable_section = __webpack_require__(21049);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_expandable_section_m_truncate__content_LineClamp.js
const c_expandable_section_m_truncate__content_LineClamp = {
  "name": "--pf-c-expandable-section--m-truncate__content--LineClamp",
  "value": "3",
  "var": "var(--pf-c-expandable-section--m-truncate__content--LineClamp)"
};
/* harmony default export */ const c_expandable_section_m_truncate_content_LineClamp = (c_expandable_section_m_truncate__content_LineClamp);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ExpandableSection/ExpandableSection.js








var ExpandableSectionVariant;
(function (ExpandableSectionVariant) {
    ExpandableSectionVariant["default"] = "default";
    ExpandableSectionVariant["truncate"] = "truncate";
})(ExpandableSectionVariant || (ExpandableSectionVariant = {}));
const setLineClamp = (lines, element) => {
    if (!element || lines < 1) {
        return;
    }
    element.style.setProperty(c_expandable_section_m_truncate_content_LineClamp.name, lines.toString());
};
class ExpandableSection extends react.Component {
    constructor(props) {
        super(props);
        this.expandableContentRef = react.createRef();
        this.observer = () => { };
        this.checkToggleVisibility = () => {
            var _a;
            if ((_a = this.expandableContentRef) === null || _a === void 0 ? void 0 : _a.current) {
                const maxLines = this.props.truncateMaxLines || parseInt(c_expandable_section_m_truncate_content_LineClamp.value);
                const totalLines = this.expandableContentRef.current.scrollHeight /
                    parseInt(getComputedStyle(this.expandableContentRef.current).lineHeight);
                this.setState({
                    hasToggle: totalLines > maxLines
                });
            }
        };
        this.resize = () => {
            const { offsetWidth } = this.expandableContentRef.current;
            if (this.state.previousWidth !== offsetWidth) {
                this.setState({ previousWidth: offsetWidth });
                this.checkToggleVisibility();
            }
        };
        this.handleResize = debounce(this.resize, 250);
        this.state = {
            isExpanded: props.isExpanded,
            hasToggle: true,
            previousWidth: undefined
        };
    }
    calculateToggleText(toggleText, toggleTextExpanded, toggleTextCollapsed, propOrStateIsExpanded) {
        if (propOrStateIsExpanded && toggleTextExpanded !== '') {
            return toggleTextExpanded;
        }
        if (!propOrStateIsExpanded && toggleTextCollapsed !== '') {
            return toggleTextCollapsed;
        }
        return toggleText;
    }
    componentDidMount() {
        if (this.props.variant === ExpandableSectionVariant.truncate) {
            const expandableContent = this.expandableContentRef.current;
            this.setState({ previousWidth: expandableContent.offsetWidth });
            this.observer = getResizeObserver(expandableContent, this.handleResize, false);
            if (this.props.truncateMaxLines) {
                setLineClamp(this.props.truncateMaxLines, expandableContent);
            }
            this.checkToggleVisibility();
        }
    }
    componentDidUpdate(prevProps) {
        if (this.props.variant === ExpandableSectionVariant.truncate &&
            prevProps.truncateMaxLines !== this.props.truncateMaxLines) {
            const expandableContent = this.expandableContentRef.current;
            setLineClamp(this.props.truncateMaxLines, expandableContent);
            this.checkToggleVisibility();
        }
    }
    componentWillUnmount() {
        if (this.props.variant === ExpandableSectionVariant.truncate) {
            this.observer();
        }
    }
    render() {
        const _a = this.props, { onToggle: onToggleProp, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        isActive, className, toggleText, toggleTextExpanded, toggleTextCollapsed, toggleContent, children, isExpanded, isDetached, displaySize, isWidthLimited, isIndented, contentId, variant, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        truncateMaxLines } = _a, props = (0,tslib_es6.__rest)(_a, ["onToggle", "isActive", "className", "toggleText", "toggleTextExpanded", "toggleTextCollapsed", "toggleContent", "children", "isExpanded", "isDetached", "displaySize", "isWidthLimited", "isIndented", "contentId", "variant", "truncateMaxLines"]);
        let onToggle = onToggleProp;
        let propOrStateIsExpanded = isExpanded;
        // uncontrolled
        if (isExpanded === undefined) {
            propOrStateIsExpanded = this.state.isExpanded;
            onToggle = isOpen => {
                this.setState({ isExpanded: isOpen }, () => onToggleProp(this.state.isExpanded));
            };
        }
        const computedToggleText = this.calculateToggleText(toggleText, toggleTextExpanded, toggleTextCollapsed, propOrStateIsExpanded);
        const expandableToggle = !isDetached && (react.createElement("button", { className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionToggle), type: "button", "aria-expanded": propOrStateIsExpanded, onClick: () => onToggle(!propOrStateIsExpanded) },
            variant !== ExpandableSectionVariant.truncate && (react.createElement("span", { className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionToggleIcon) },
                react.createElement(angle_right_icon, { "aria-hidden": true }))),
            react.createElement("span", { className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionToggleText) }, toggleContent || computedToggleText)));
        return (react.createElement("div", Object.assign({ className: (0,esm.css)(expandable_section/* default */.Z.expandableSection, propOrStateIsExpanded && expandable_section/* default */.Z.modifiers.expanded, isActive && expandable_section/* default */.Z.modifiers.active, isDetached && expandable_section/* default */.Z.modifiers.detached, displaySize === 'large' && expandable_section/* default */.Z.modifiers.displayLg, isWidthLimited && expandable_section/* default */.Z.modifiers.limitWidth, isIndented && expandable_section/* default */.Z.modifiers.indented, variant === ExpandableSectionVariant.truncate && expandable_section/* default */.Z.modifiers.truncate, className) }, props),
            variant === ExpandableSectionVariant.default && expandableToggle,
            react.createElement("div", { ref: this.expandableContentRef, className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionContent), hidden: variant !== ExpandableSectionVariant.truncate && !propOrStateIsExpanded, id: contentId }, children),
            variant === ExpandableSectionVariant.truncate && this.state.hasToggle && expandableToggle));
    }
}
ExpandableSection.displayName = 'ExpandableSection';
ExpandableSection.defaultProps = {
    className: '',
    toggleText: '',
    toggleTextExpanded: '',
    toggleTextCollapsed: '',
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onToggle: (isExpanded) => undefined,
    isActive: false,
    isDetached: false,
    displaySize: 'default',
    isWidthLimited: false,
    isIndented: false,
    contentId: '',
    variant: 'default'
};
//# sourceMappingURL=ExpandableSection.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ExpandableSection/ExpandableSectionToggle.js





const ExpandableSectionToggle = (_a) => {
    var { children, className = '', isExpanded = false, onToggle, contentId, direction = 'down', hasTruncatedContent = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "isExpanded", "onToggle", "contentId", "direction", "hasTruncatedContent"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(expandable_section/* default */.Z.expandableSection, isExpanded && expandable_section/* default */.Z.modifiers.expanded, expandable_section/* default */.Z.modifiers.detached, hasTruncatedContent && expandable_section/* default */.Z.modifiers.truncate, className) }, props),
        react.createElement("button", { className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionToggle), type: "button", "aria-expanded": isExpanded, "aria-controls": contentId, onClick: () => onToggle(!isExpanded) },
            !hasTruncatedContent && (react.createElement("span", { className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionToggleIcon, isExpanded && direction === 'up' && expandable_section/* default */.Z.modifiers.expandTop) },
                react.createElement(angle_right_icon, { "aria-hidden": true }))),
            react.createElement("span", { className: (0,esm.css)(expandable_section/* default */.Z.expandableSectionToggleText) }, children))));
};
ExpandableSectionToggle.displayName = 'ExpandableSectionToggle';
//# sourceMappingURL=ExpandableSectionToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/ExpandableSection/index.js


//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/FileUpload/file-upload.js
var file_upload = __webpack_require__(43142);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/helpers/fileUtils.js
var fileReaderType;
(function (fileReaderType) {
    fileReaderType["text"] = "text";
    fileReaderType["dataURL"] = "dataURL";
})(fileReaderType || (fileReaderType = {}));
/**
 * Read a file using the FileReader API, either as a plain text string or as a DataURL string.
 * Returns a promise which will resolve with the file contents as a string or reject with a DOMException.
 *
 * @param {File} fileHandle - File object to read
 * @param {fileReaderType} type - How to read it
 */
function readFile(fileHandle, type) {
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.onload = () => resolve(reader.result);
        reader.onerror = () => reject(reader.error);
        if (type === fileReaderType.text) {
            reader.readAsText(fileHandle);
        }
        else if (type === fileReaderType.dataURL) {
            reader.readAsDataURL(fileHandle);
        }
        else {
            reject('unknown type');
        }
    });
}
//# sourceMappingURL=fileUtils.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FileUpload/FileUploadField.js










const FileUploadField = (_a) => {
    var { id, type, value = '', filename = '', onChange = () => { }, onBrowseButtonClick = () => { }, onClearButtonClick = () => { }, onTextAreaClick, onTextChange, onTextAreaBlur, textAreaPlaceholder = '', className = '', isDisabled = false, isReadOnly = false, isLoading = false, spinnerAriaValueText, isRequired = false, isDragActive = false, validated = 'default', 'aria-label': ariaLabel = 'File upload', filenamePlaceholder = 'Drag a file here or browse to upload', filenameAriaLabel = filename ? 'Read only filename' : filenamePlaceholder, browseButtonText = 'Browse...', clearButtonText = 'Clear', isClearButtonDisabled = !filename && !value, containerRef = null, allowEditingUploadedText = false, hideDefaultPreview = false, children = null } = _a, props = (0,tslib_es6.__rest)(_a, ["id", "type", "value", "filename", "onChange", "onBrowseButtonClick", "onClearButtonClick", "onTextAreaClick", "onTextChange", "onTextAreaBlur", "textAreaPlaceholder", "className", "isDisabled", "isReadOnly", "isLoading", "spinnerAriaValueText", "isRequired", "isDragActive", "validated", 'aria-label', "filenamePlaceholder", "filenameAriaLabel", "browseButtonText", "clearButtonText", "isClearButtonDisabled", "containerRef", "allowEditingUploadedText", "hideDefaultPreview", "children"]);
    const onTextAreaChange = (newValue, event) => {
        onChange(newValue, filename, event);
        onTextChange === null || onTextChange === void 0 ? void 0 : onTextChange(newValue);
    };
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(file_upload/* default */.Z.fileUpload, isDragActive && file_upload/* default */.Z.modifiers.dragHover, isLoading && file_upload/* default */.Z.modifiers.loading, className), ref: containerRef }, props),
        react.createElement("div", { className: file_upload/* default */.Z.fileUploadFileSelect },
            react.createElement(InputGroup, null,
                react.createElement(TextInput, { isReadOnly // Always read-only regardless of isReadOnly prop (which is just for the TextArea)
                    : true, isDisabled: isDisabled, id: `${id}-filename`, name: `${id}-filename`, "aria-label": filenameAriaLabel, placeholder: filenamePlaceholder, "aria-describedby": `${id}-browse-button`, value: filename }),
                react.createElement(Button, { id: `${id}-browse-button`, variant: ButtonVariant.control, onClick: onBrowseButtonClick, isDisabled: isDisabled }, browseButtonText),
                react.createElement(Button, { variant: ButtonVariant.control, isDisabled: isDisabled || isClearButtonDisabled, onClick: onClearButtonClick }, clearButtonText))),
        react.createElement("div", { className: file_upload/* default */.Z.fileUploadFileDetails },
            !hideDefaultPreview && type === fileReaderType.text && (react.createElement(TextArea, { readOnly: isReadOnly || (!!filename && !allowEditingUploadedText), disabled: isDisabled, isRequired: isRequired, resizeOrientation: TextAreResizeOrientation.vertical, validated: validated, id: id, name: id, "aria-label": ariaLabel, value: value, onChange: onTextAreaChange, onClick: onTextAreaClick, onBlur: onTextAreaBlur, placeholder: textAreaPlaceholder })),
            isLoading && (react.createElement("div", { className: file_upload/* default */.Z.fileUploadFileDetailsSpinner },
                react.createElement(Spinner, { size: spinnerSize.lg, "aria-valuetext": spinnerAriaValueText })))),
        children));
};
FileUploadField.displayName = 'FileUploadField';
//# sourceMappingURL=FileUploadField.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/file-selector@0.1.19/node_modules/file-selector/dist/es5/file.js
var COMMON_MIME_TYPES = new Map([
    ['avi', 'video/avi'],
    ['gif', 'image/gif'],
    ['ico', 'image/x-icon'],
    ['jpeg', 'image/jpeg'],
    ['jpg', 'image/jpeg'],
    ['mkv', 'video/x-matroska'],
    ['mov', 'video/quicktime'],
    ['mp4', 'video/mp4'],
    ['pdf', 'application/pdf'],
    ['png', 'image/png'],
    ['zip', 'application/zip'],
    ['doc', 'application/msword'],
    ['docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document']
]);
function toFileWithPath(file, path) {
    var f = withMimeType(file);
    if (typeof f.path !== 'string') { // on electron, path is already set to the absolute path
        var webkitRelativePath = file.webkitRelativePath;
        Object.defineProperty(f, 'path', {
            value: typeof path === 'string'
                ? path
                // If <input webkitdirectory> is set,
                // the File will have a {webkitRelativePath} property
                // https://developer.mozilla.org/en-US/docs/Web/API/HTMLInputElement/webkitdirectory
                : typeof webkitRelativePath === 'string' && webkitRelativePath.length > 0
                    ? webkitRelativePath
                    : file.name,
            writable: false,
            configurable: false,
            enumerable: true
        });
    }
    return f;
}
function withMimeType(file) {
    var name = file.name;
    var hasExtension = name && name.lastIndexOf('.') !== -1;
    if (hasExtension && !file.type) {
        var ext = name.split('.')
            .pop().toLowerCase();
        var type = COMMON_MIME_TYPES.get(ext);
        if (type) {
            Object.defineProperty(file, 'type', {
                value: type,
                writable: false,
                configurable: false,
                enumerable: true
            });
        }
    }
    return file;
}
//# sourceMappingURL=file.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/file-selector@0.1.19/node_modules/file-selector/dist/es5/file-selector.js


var FILES_TO_IGNORE = [
    // Thumbnail cache files for macOS and Windows
    '.DS_Store',
    'Thumbs.db' // Windows
];
/**
 * Convert a DragEvent's DataTrasfer object to a list of File objects
 * NOTE: If some of the items are folders,
 * everything will be flattened and placed in the same list but the paths will be kept as a {path} property.
 * @param evt
 */
function fromEvent(evt) {
    return (0,tslib_es6.__awaiter)(this, void 0, void 0, function () {
        return (0,tslib_es6.__generator)(this, function (_a) {
            return [2 /*return*/, isDragEvt(evt) && evt.dataTransfer
                    ? getDataTransferFiles(evt.dataTransfer, evt.type)
                    : getInputFiles(evt)];
        });
    });
}
function isDragEvt(value) {
    return !!value.dataTransfer;
}
function getInputFiles(evt) {
    var files = isInput(evt.target)
        ? evt.target.files
            ? fromList(evt.target.files)
            : []
        : [];
    return files.map(function (file) { return toFileWithPath(file); });
}
function isInput(value) {
    return value !== null;
}
function getDataTransferFiles(dt, type) {
    return (0,tslib_es6.__awaiter)(this, void 0, void 0, function () {
        var items, files;
        return (0,tslib_es6.__generator)(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!dt.items) return [3 /*break*/, 2];
                    items = fromList(dt.items)
                        .filter(function (item) { return item.kind === 'file'; });
                    // According to https://html.spec.whatwg.org/multipage/dnd.html#dndevents,
                    // only 'dragstart' and 'drop' has access to the data (source node)
                    if (type !== 'drop') {
                        return [2 /*return*/, items];
                    }
                    return [4 /*yield*/, Promise.all(items.map(toFilePromises))];
                case 1:
                    files = _a.sent();
                    return [2 /*return*/, noIgnoredFiles(flatten(files))];
                case 2: return [2 /*return*/, noIgnoredFiles(fromList(dt.files)
                        .map(function (file) { return toFileWithPath(file); }))];
            }
        });
    });
}
function noIgnoredFiles(files) {
    return files.filter(function (file) { return FILES_TO_IGNORE.indexOf(file.name) === -1; });
}
// IE11 does not support Array.from()
// https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/from#Browser_compatibility
// https://developer.mozilla.org/en-US/docs/Web/API/FileList
// https://developer.mozilla.org/en-US/docs/Web/API/DataTransferItemList
function fromList(items) {
    var files = [];
    // tslint:disable: prefer-for-of
    for (var i = 0; i < items.length; i++) {
        var file = items[i];
        files.push(file);
    }
    return files;
}
// https://developer.mozilla.org/en-US/docs/Web/API/DataTransferItem
function toFilePromises(item) {
    if (typeof item.webkitGetAsEntry !== 'function') {
        return fromDataTransferItem(item);
    }
    var entry = item.webkitGetAsEntry();
    // Safari supports dropping an image node from a different window and can be retrieved using
    // the DataTransferItem.getAsFile() API
    // NOTE: FileSystemEntry.file() throws if trying to get the file
    if (entry && entry.isDirectory) {
        return fromDirEntry(entry);
    }
    return fromDataTransferItem(item);
}
function flatten(items) {
    return items.reduce(function (acc, files) { return (0,tslib_es6.__spread)(acc, (Array.isArray(files) ? flatten(files) : [files])); }, []);
}
function fromDataTransferItem(item) {
    var file = item.getAsFile();
    if (!file) {
        return Promise.reject(item + " is not a File");
    }
    var fwp = toFileWithPath(file);
    return Promise.resolve(fwp);
}
// https://developer.mozilla.org/en-US/docs/Web/API/FileSystemEntry
function fromEntry(entry) {
    return (0,tslib_es6.__awaiter)(this, void 0, void 0, function () {
        return (0,tslib_es6.__generator)(this, function (_a) {
            return [2 /*return*/, entry.isDirectory ? fromDirEntry(entry) : fromFileEntry(entry)];
        });
    });
}
// https://developer.mozilla.org/en-US/docs/Web/API/FileSystemDirectoryEntry
function fromDirEntry(entry) {
    var reader = entry.createReader();
    return new Promise(function (resolve, reject) {
        var entries = [];
        function readEntries() {
            var _this = this;
            // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemDirectoryEntry/createReader
            // https://developer.mozilla.org/en-US/docs/Web/API/FileSystemDirectoryReader/readEntries
            reader.readEntries(function (batch) { return (0,tslib_es6.__awaiter)(_this, void 0, void 0, function () {
                var files, err_1, items;
                return (0,tslib_es6.__generator)(this, function (_a) {
                    switch (_a.label) {
                        case 0:
                            if (!!batch.length) return [3 /*break*/, 5];
                            _a.label = 1;
                        case 1:
                            _a.trys.push([1, 3, , 4]);
                            return [4 /*yield*/, Promise.all(entries)];
                        case 2:
                            files = _a.sent();
                            resolve(files);
                            return [3 /*break*/, 4];
                        case 3:
                            err_1 = _a.sent();
                            reject(err_1);
                            return [3 /*break*/, 4];
                        case 4: return [3 /*break*/, 6];
                        case 5:
                            items = Promise.all(batch.map(fromEntry));
                            entries.push(items);
                            // Continue reading
                            readEntries();
                            _a.label = 6;
                        case 6: return [2 /*return*/];
                    }
                });
            }); }, function (err) {
                reject(err);
            });
        }
        readEntries();
    });
}
// https://developer.mozilla.org/en-US/docs/Web/API/FileSystemFileEntry
function fromFileEntry(entry) {
    return (0,tslib_es6.__awaiter)(this, void 0, void 0, function () {
        return (0,tslib_es6.__generator)(this, function (_a) {
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    entry.file(function (file) {
                        var fwp = toFileWithPath(file, entry.fullPath);
                        resolve(fwp);
                    }, function (err) {
                        reject(err);
                    });
                })];
        });
    });
}
//# sourceMappingURL=file-selector.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/file-selector@0.1.19/node_modules/file-selector/dist/es5/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js
var prop_types = __webpack_require__(7862);
var prop_types_default = /*#__PURE__*/__webpack_require__.n(prop_types);
// EXTERNAL MODULE: ../../node_modules/.pnpm/attr-accept@1.1.3/node_modules/attr-accept/dist/index.js
var dist = __webpack_require__(49519);
var dist_default = /*#__PURE__*/__webpack_require__.n(dist);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/react-dropzone@9.0.0_react@17.0.2/node_modules/react-dropzone/dist/es/utils/index.js
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };



var supportMultiple = typeof document !== 'undefined' && document && document.createElement ? 'multiple' in document.createElement('input') : true;

// Firefox versions prior to 53 return a bogus MIME type for every file drag, so dragovers with
// that MIME type will always be accepted
function fileAccepted(file, accept) {
  return file.type === 'application/x-moz-file' || dist_default()(file, accept);
}

function fileMatchSize(file, maxSize, minSize) {
  return file.size <= maxSize && file.size >= minSize;
}

function allFilesAccepted(files, accept) {
  return files.every(function (file) {
    return fileAccepted(file, accept);
  });
}

// React's synthetic events has evt.isPropagationStopped,
// but to remain compatibility with other libs (Preact) fall back
// to check evt.cancelBubble
function isPropagationStopped(evt) {
  if (typeof evt.isPropagationStopped === 'function') {
    return evt.isPropagationStopped();
  } else if (typeof evt.cancelBubble !== 'undefined') {
    return evt.cancelBubble;
  }
  return false;
}

// React's synthetic events has evt.isDefaultPrevented,
// but to remain compatibility with other libs (Preact) first
// check evt.defaultPrevented
function isDefaultPrevented(evt) {
  if (typeof evt.defaultPrevented !== 'undefined') {
    return evt.defaultPrevented;
  } else if (typeof evt.isDefaultPrevented === 'function') {
    return evt.isDefaultPrevented();
  }
  return false;
}

function isDragDataWithFiles(evt) {
  if (!evt.dataTransfer) {
    return true;
  }
  // https://developer.mozilla.org/en-US/docs/Web/API/DataTransfer/types
  // https://developer.mozilla.org/en-US/docs/Web/API/HTML_Drag_and_Drop_API/Recommended_drag_types#file
  return Array.prototype.some.call(evt.dataTransfer.types, function (type) {
    return type === 'Files' || type === 'application/x-moz-file';
  });
}

function isKindFile(item) {
  return (typeof item === 'undefined' ? 'undefined' : _typeof(item)) === 'object' && item !== null && item.kind === 'file';
}

// allow the entire document to be a drag target
function onDocumentDragOver(evt) {
  evt.preventDefault();
}

function isIe(userAgent) {
  return userAgent.indexOf('MSIE') !== -1 || userAgent.indexOf('Trident/') !== -1;
}

function isEdge(userAgent) {
  return userAgent.indexOf('Edge/') !== -1;
}

function isIeOrEdge() {
  var userAgent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window.navigator.userAgent;

  return isIe(userAgent) || isEdge(userAgent);
}

/**
 * This is intended to be used to compose event handlers
 * They are executed in order until one of them calls `event.preventDefault()`.
 * Not sure this is the best way to do this, but it seems legit.
 * @param {Function} fns the event hanlder functions
 * @return {Function} the event handler to add to an element
 */
function composeEventHandlers() {
  for (var _len = arguments.length, fns = Array(_len), _key = 0; _key < _len; _key++) {
    fns[_key] = arguments[_key];
  }

  return function (event) {
    for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
      args[_key2 - 1] = arguments[_key2];
    }

    return fns.some(function (fn) {
      fn && fn.apply(undefined, [event].concat(args));
      return event.defaultPrevented;
    });
  };
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/react-dropzone@9.0.0_react@17.0.2/node_modules/react-dropzone/dist/es/index.js
var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/* eslint prefer-template: 0 */






var Dropzone = function (_React$Component) {
  _inherits(Dropzone, _React$Component);

  function Dropzone() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Dropzone);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Dropzone.__proto__ || Object.getPrototypeOf(Dropzone)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      draggedFiles: [],
      acceptedFiles: [],
      rejectedFiles: []
    }, _this.isFileDialogActive = false, _this.onDocumentDrop = function (evt) {
      if (_this.node && _this.node.contains(evt.target)) {
        // if we intercepted an event for our instance, let it propagate down to the instance's onDrop handler
        return;
      }
      evt.preventDefault();
      _this.dragTargets = [];
    }, _this.onDragStart = function (evt) {
      evt.persist();
      if (_this.props.onDragStart && isDragDataWithFiles(evt)) {
        _this.props.onDragStart.call(_this, evt);
      }
    }, _this.onDragEnter = function (evt) {
      evt.preventDefault();

      // Count the dropzone and any children that are entered.
      if (_this.dragTargets.indexOf(evt.target) === -1) {
        _this.dragTargets.push(evt.target);
      }

      evt.persist();

      if (isDragDataWithFiles(evt)) {
        Promise.resolve(_this.props.getDataTransferItems(evt)).then(function (draggedFiles) {
          if (isPropagationStopped(evt)) {
            return;
          }

          _this.setState({
            draggedFiles: draggedFiles,
            // Do not rely on files for the drag state. It doesn't work in Safari.
            isDragActive: true
          });
        });

        if (_this.props.onDragEnter) {
          _this.props.onDragEnter.call(_this, evt);
        }
      }
    }, _this.onDragOver = function (evt) {
      // eslint-disable-line class-methods-use-this
      evt.preventDefault();
      evt.persist();

      if (evt.dataTransfer) {
        evt.dataTransfer.dropEffect = 'copy';
      }

      if (_this.props.onDragOver && isDragDataWithFiles(evt)) {
        _this.props.onDragOver.call(_this, evt);
      }

      return false;
    }, _this.onDragLeave = function (evt) {
      evt.preventDefault();
      evt.persist();

      // Only deactivate once the dropzone and all children have been left.
      _this.dragTargets = _this.dragTargets.filter(function (el) {
        return el !== evt.target && _this.node.contains(el);
      });
      if (_this.dragTargets.length > 0) {
        return;
      }

      // Clear dragging files state
      _this.setState({
        isDragActive: false,
        draggedFiles: []
      });

      if (_this.props.onDragLeave && isDragDataWithFiles(evt)) {
        _this.props.onDragLeave.call(_this, evt);
      }
    }, _this.onDrop = function (evt) {
      var _this$props = _this.props,
          onDrop = _this$props.onDrop,
          onDropAccepted = _this$props.onDropAccepted,
          onDropRejected = _this$props.onDropRejected,
          multiple = _this$props.multiple,
          accept = _this$props.accept,
          getDataTransferItems = _this$props.getDataTransferItems;

      // Stop default browser behavior

      evt.preventDefault();

      // Persist event for later usage
      evt.persist();

      // Reset the counter along with the drag on a drop.
      _this.dragTargets = [];
      _this.isFileDialogActive = false;

      // Clear files value
      _this.draggedFiles = null;

      // Reset drag state
      _this.setState({
        isDragActive: false,
        draggedFiles: []
      });

      if (isDragDataWithFiles(evt)) {
        Promise.resolve(getDataTransferItems(evt)).then(function (fileList) {
          var acceptedFiles = [];
          var rejectedFiles = [];

          if (isPropagationStopped(evt)) {
            return;
          }

          fileList.forEach(function (file) {
            if (fileAccepted(file, accept) && fileMatchSize(file, _this.props.maxSize, _this.props.minSize)) {
              acceptedFiles.push(file);
            } else {
              rejectedFiles.push(file);
            }
          });

          if (!multiple && acceptedFiles.length > 1) {
            // if not in multi mode add any extra accepted files to rejected.
            // This will allow end users to easily ignore a multi file drop in "single" mode.
            rejectedFiles.push.apply(rejectedFiles, _toConsumableArray(acceptedFiles.splice(0)));
          }

          // Update `acceptedFiles` and `rejectedFiles` state
          // This will make children render functions receive the appropriate
          // values
          _this.setState({ acceptedFiles: acceptedFiles, rejectedFiles: rejectedFiles }, function () {
            if (onDrop) {
              onDrop.call(_this, acceptedFiles, rejectedFiles, evt);
            }

            if (rejectedFiles.length > 0 && onDropRejected) {
              onDropRejected.call(_this, rejectedFiles, evt);
            }

            if (acceptedFiles.length > 0 && onDropAccepted) {
              onDropAccepted.call(_this, acceptedFiles, evt);
            }
          });
        });
      }
    }, _this.onClick = function (evt) {
      var onClick = _this.props.onClick;

      // if onClick prop is given, run it first

      if (onClick) {
        onClick.call(_this, evt);
      }

      // If the event hasn't been default prevented from within
      // the onClick listener, open the file dialog
      if (!isDefaultPrevented(evt)) {
        evt.stopPropagation();

        // in IE11/Edge the file-browser dialog is blocking, ensure this is behind setTimeout
        // this is so react can handle state changes in the onClick prop above above
        // see: https://github.com/react-dropzone/react-dropzone/issues/450
        if (isIeOrEdge()) {
          setTimeout(_this.open, 0);
        } else {
          _this.open();
        }
      }
    }, _this.onInputElementClick = function (evt) {
      evt.stopPropagation();
    }, _this.onFileDialogCancel = function () {
      // timeout will not recognize context of this method
      var onFileDialogCancel = _this.props.onFileDialogCancel;
      // execute the timeout only if the FileDialog is opened in the browser

      if (_this.isFileDialogActive) {
        setTimeout(function () {
          if (_this.input != null) {
            // Returns an object as FileList
            var files = _this.input.files;


            if (!files.length) {
              _this.isFileDialogActive = false;

              if (typeof onFileDialogCancel === 'function') {
                onFileDialogCancel();
              }
            }
          }
        }, 300);
      }
    }, _this.onFocus = function (evt) {
      var onFocus = _this.props.onFocus;

      if (onFocus) {
        onFocus.call(_this, evt);
      }
      if (!isDefaultPrevented(evt)) {
        _this.setState({ isFocused: true });
      }
    }, _this.onBlur = function (evt) {
      var onBlur = _this.props.onBlur;

      if (onBlur) {
        onBlur.call(_this, evt);
      }
      if (!isDefaultPrevented(evt)) {
        _this.setState({ isFocused: false });
      }
    }, _this.onKeyDown = function (evt) {
      var onKeyDown = _this.props.onKeyDown;

      if (!_this.node.isEqualNode(evt.target)) {
        return;
      }

      if (onKeyDown) {
        onKeyDown.call(_this, evt);
      }

      if (!isDefaultPrevented(evt) && (evt.keyCode === 32 || evt.keyCode === 13)) {
        evt.preventDefault();
        _this.open();
      }
    }, _this.composeHandler = function (handler) {
      if (_this.props.disabled) {
        return null;
      }
      return handler;
    }, _this.getRootProps = function () {
      var _extends2;

      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var _ref2$refKey = _ref2.refKey,
          refKey = _ref2$refKey === undefined ? 'ref' : _ref2$refKey,
          onKeyDown = _ref2.onKeyDown,
          onFocus = _ref2.onFocus,
          onBlur = _ref2.onBlur,
          onClick = _ref2.onClick,
          onDragStart = _ref2.onDragStart,
          onDragEnter = _ref2.onDragEnter,
          onDragOver = _ref2.onDragOver,
          onDragLeave = _ref2.onDragLeave,
          onDrop = _ref2.onDrop,
          rest = _objectWithoutProperties(_ref2, ['refKey', 'onKeyDown', 'onFocus', 'onBlur', 'onClick', 'onDragStart', 'onDragEnter', 'onDragOver', 'onDragLeave', 'onDrop']);

      return _extends((_extends2 = {
        onKeyDown: _this.composeHandler(onKeyDown ? composeEventHandlers(onKeyDown, _this.onKeyDown) : _this.onKeyDown),
        onFocus: _this.composeHandler(onFocus ? composeEventHandlers(onFocus, _this.onFocus) : _this.onFocus),
        onBlur: _this.composeHandler(onBlur ? composeEventHandlers(onBlur, _this.onBlur) : _this.onBlur),
        onClick: _this.composeHandler(onClick ? composeEventHandlers(onClick, _this.onClick) : _this.onClick),
        onDragStart: _this.composeHandler(onDragStart ? composeEventHandlers(onDragStart, _this.onDragStart) : _this.onDragStart),
        onDragEnter: _this.composeHandler(onDragEnter ? composeEventHandlers(onDragEnter, _this.onDragEnter) : _this.onDragEnter),
        onDragOver: _this.composeHandler(onDragOver ? composeEventHandlers(onDragOver, _this.onDragOver) : _this.onDragOver),
        onDragLeave: _this.composeHandler(onDragLeave ? composeEventHandlers(onDragLeave, _this.onDragLeave) : _this.onDragLeave),
        onDrop: _this.composeHandler(onDrop ? composeEventHandlers(onDrop, _this.onDrop) : _this.onDrop)
      }, _defineProperty(_extends2, refKey, _this.setNodeRef), _defineProperty(_extends2, 'tabIndex', _this.props.disabled ? -1 : 0), _extends2), rest);
    }, _this.getInputProps = function () {
      var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var _ref3$refKey = _ref3.refKey,
          refKey = _ref3$refKey === undefined ? 'ref' : _ref3$refKey,
          onChange = _ref3.onChange,
          onClick = _ref3.onClick,
          rest = _objectWithoutProperties(_ref3, ['refKey', 'onChange', 'onClick']);

      var _this$props2 = _this.props,
          accept = _this$props2.accept,
          multiple = _this$props2.multiple,
          name = _this$props2.name;

      var inputProps = _defineProperty({
        accept: accept,
        type: 'file',
        style: { display: 'none' },
        multiple: supportMultiple && multiple,
        onChange: composeEventHandlers(onChange, _this.onDrop),
        onClick: composeEventHandlers(onClick, _this.onInputElementClick),
        autoComplete: 'off',
        tabIndex: -1
      }, refKey, _this.setInputRef);
      if (name && name.length) {
        inputProps.name = name;
      }
      return _extends({}, inputProps, rest);
    }, _this.setNodeRef = function (node) {
      _this.node = node;
    }, _this.setInputRef = function (input) {
      _this.input = input;
    }, _this.open = function () {
      _this.isFileDialogActive = true;
      if (_this.input) {
        _this.input.value = null;
        _this.input.click();
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Dropzone, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var preventDropOnDocument = this.props.preventDropOnDocument;

      this.dragTargets = [];

      if (preventDropOnDocument) {
        document.addEventListener('dragover', onDocumentDragOver, false);
        document.addEventListener('drop', this.onDocumentDrop, false);
      }

      window.addEventListener('focus', this.onFileDialogCancel, false);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      var preventDropOnDocument = this.props.preventDropOnDocument;

      if (preventDropOnDocument) {
        document.removeEventListener('dragover', onDocumentDragOver);
        document.removeEventListener('drop', this.onDocumentDrop);
      }

      window.removeEventListener('focus', this.onFileDialogCancel, false);
    }

    /**
     * Open system file upload dialog.
     *
     * @public
     */

  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          multiple = _props.multiple,
          disabled = _props.disabled;
      var _state = this.state,
          isDragActive = _state.isDragActive,
          isFocused = _state.isFocused,
          draggedFiles = _state.draggedFiles,
          acceptedFiles = _state.acceptedFiles,
          rejectedFiles = _state.rejectedFiles;


      var filesCount = draggedFiles.length;
      var isMultipleAllowed = multiple || filesCount <= 1;
      var isDragAccept = filesCount > 0 && allFilesAccepted(draggedFiles, this.props.accept);
      var isDragReject = filesCount > 0 && (!isDragAccept || !isMultipleAllowed);

      return children({
        isDragActive: isDragActive,
        isDragAccept: isDragAccept,
        isDragReject: isDragReject,
        draggedFiles: draggedFiles,
        acceptedFiles: acceptedFiles,
        rejectedFiles: rejectedFiles,
        isFocused: isFocused && !disabled,
        getRootProps: this.getRootProps,
        getInputProps: this.getInputProps,
        open: this.open
      });
    }
  }]);

  return Dropzone;
}(react.Component);

/* harmony default export */ const es = (Dropzone);

Dropzone.propTypes = {
  /**
   * Allow specific types of files. See https://github.com/okonet/attr-accept for more information.
   * Keep in mind that mime type determination is not reliable across platforms. CSV files,
   * for example, are reported as text/plain under macOS but as application/vnd.ms-excel under
   * Windows. In some cases there might not be a mime type set at all.
   * See: https://github.com/react-dropzone/react-dropzone/issues/276
   */
  accept: prop_types_default().oneOfType([(prop_types_default()).string, prop_types_default().arrayOf((prop_types_default()).string)]),

  /**
   * Render function that renders the actual component
   *
   * @param {Object} props
   * @param {Function} props.getRootProps Returns the props you should apply to the root drop container you render
   * @param {Function} props.getInputProps Returns the props you should apply to hidden file input you render
   * @param {Function} props.open Open the native file selection dialog
   * @param {Boolean} props.isFocused Dropzone area is in focus
   * @param {Boolean} props.isDragActive Active drag is in progress
   * @param {Boolean} props.isDragAccept Dragged files are accepted
   * @param {Boolean} props.isDragReject Some dragged files are rejected
   * @param {Array} props.draggedFiles Files in active drag
   * @param {Array} props.acceptedFiles Accepted files
   * @param {Array} props.rejectedFiles Rejected files
   */
  children: (prop_types_default()).func,

  /**
   * Enable/disable the dropzone entirely
   */
  disabled: (prop_types_default()).bool,

  /**
   * If false, allow dropped items to take over the current browser window
   */
  preventDropOnDocument: (prop_types_default()).bool,

  /**
   * Allow dropping multiple files
   */
  multiple: (prop_types_default()).bool,

  /**
   * `name` attribute for the input tag
   */
  name: (prop_types_default()).string,

  /**
   * Maximum file size (in bytes)
   */
  maxSize: (prop_types_default()).number,

  /**
   * Minimum file size (in bytes)
   */
  minSize: (prop_types_default()).number,

  /**
   * getDataTransferItems handler
   * @param {Event} event
   * @returns {Array} array of File objects
   */
  getDataTransferItems: (prop_types_default()).func,

  /**
   * onClick callback
   * @param {Event} event
   */
  onClick: (prop_types_default()).func,

  /**
   * onFocus callback
   */
  onFocus: (prop_types_default()).func,

  /**
   * onBlur callback
   */
  onBlur: (prop_types_default()).func,

  /**
   * onKeyDown callback
   */
  onKeyDown: (prop_types_default()).func,

  /**
   * The `onDrop` method that accepts two arguments.
   * The first argument represents the accepted files and the second argument the rejected files.
   *
   * ```javascript
   * function onDrop(acceptedFiles, rejectedFiles) {
   *   // do stuff with files...
   * }
   * ```
   *
   * Files are accepted or rejected based on the `accept` prop.
   * This must be a valid [MIME type](http://www.iana.org/assignments/media-types/media-types.xhtml) according to [input element specification](https://www.w3.org/wiki/HTML/Elements/input/file) or a valid file extension.
   *
   * Note that the `onDrop` callback will always be called regardless if the dropped files were accepted or rejected.
   * You can use the `onDropAccepted`/`onDropRejected` props if you'd like to react to a specific event instead of the `onDrop` prop.
   *
   * The `onDrop` callback will provide you with an array of [Files](https://developer.mozilla.org/en-US/docs/Web/API/File) which you can then process and send to a server.
   * For example, with [SuperAgent](https://github.com/visionmedia/superagent) as a http/ajax library:
   *
   * ```javascript
   * function onDrop(acceptedFiles) {
   *   const req = request.post('/upload')
   *   acceptedFiles.forEach(file => {
   *     req.attach(file.name, file)
   *   })
   *   req.end(callback)
   * }
   * ```
   */
  onDrop: (prop_types_default()).func,

  /**
   * onDropAccepted callback
   */
  onDropAccepted: (prop_types_default()).func,

  /**
   * onDropRejected callback
   */
  onDropRejected: (prop_types_default()).func,

  /**
   * onDragStart callback
   */
  onDragStart: (prop_types_default()).func,

  /**
   * onDragEnter callback
   */
  onDragEnter: (prop_types_default()).func,

  /**
   * onDragOver callback
   */
  onDragOver: (prop_types_default()).func,

  /**
   * onDragLeave callback
   */
  onDragLeave: (prop_types_default()).func,

  /**
   * Provide a callback on clicking the cancel button of the file dialog
   */
  onFileDialogCancel: (prop_types_default()).func
};

Dropzone.defaultProps = {
  preventDropOnDocument: true,
  disabled: false,
  multiple: true,
  maxSize: Infinity,
  minSize: 0,
  getDataTransferItems: fromEvent
};
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FileUpload/FileUpload.js






const FileUpload = (_a) => {
    var { id, type, value = type === fileReaderType.text || type === fileReaderType.dataURL ? '' : null, filename = '', children = null, onChange = () => { }, onFileInputChange = null, onReadStarted = () => { }, onReadFinished = () => { }, onReadFailed = () => { }, onClearClick, onClick = event => event.preventDefault(), onTextChange, onDataChange, dropzoneProps = {} } = _a, props = (0,tslib_es6.__rest)(_a, ["id", "type", "value", "filename", "children", "onChange", "onFileInputChange", "onReadStarted", "onReadFinished", "onReadFailed", "onClearClick", "onClick", "onTextChange", "onDataChange", "dropzoneProps"]);
    const onDropAccepted = (acceptedFiles, event) => {
        if (acceptedFiles.length > 0) {
            const fileHandle = acceptedFiles[0];
            if (event.type === 'drop') {
                onFileInputChange === null || onFileInputChange === void 0 ? void 0 : onFileInputChange(event, fileHandle);
            }
            if (type === fileReaderType.text || type === fileReaderType.dataURL) {
                onChange('', fileHandle.name, event); // Show the filename while reading
                onReadStarted(fileHandle);
                readFile(fileHandle, type)
                    .then(data => {
                    onReadFinished(fileHandle);
                    onChange(data, fileHandle.name, event);
                    onDataChange === null || onDataChange === void 0 ? void 0 : onDataChange(data);
                })
                    .catch((error) => {
                    onReadFailed(error, fileHandle);
                    onReadFinished(fileHandle);
                    onChange('', '', event); // Clear the filename field on a failure
                    onDataChange === null || onDataChange === void 0 ? void 0 : onDataChange('');
                });
            }
            else {
                onChange(fileHandle, fileHandle.name, event);
            }
        }
        dropzoneProps.onDropAccepted && dropzoneProps.onDropAccepted(acceptedFiles, event);
    };
    const onDropRejected = (rejectedFiles, event) => {
        if (rejectedFiles.length > 0) {
            onChange('', rejectedFiles[0].name, event);
        }
        dropzoneProps.onDropRejected && dropzoneProps.onDropRejected(rejectedFiles, event);
    };
    const fileInputRef = react.useRef();
    const setFileValue = (filename) => {
        fileInputRef.current.value = filename;
    };
    const onClearButtonClick = (event) => {
        onChange('', '', event);
        onClearClick === null || onClearClick === void 0 ? void 0 : onClearClick(event);
        setFileValue(null);
    };
    return (react.createElement(es, Object.assign({ multiple: false }, dropzoneProps, { onDropAccepted: onDropAccepted, onDropRejected: onDropRejected }), ({ getRootProps, getInputProps, isDragActive, open }) => {
        const oldInputProps = getInputProps();
        const inputProps = Object.assign(Object.assign({}, oldInputProps), { onChange: (e) => (0,tslib_es6.__awaiter)(void 0, void 0, void 0, function* () {
                var _a;
                (_a = oldInputProps.onChange) === null || _a === void 0 ? void 0 : _a.call(oldInputProps, e);
                const files = yield fromEvent(e.nativeEvent);
                if (files.length === 1) {
                    onFileInputChange === null || onFileInputChange === void 0 ? void 0 : onFileInputChange(e, files[0]);
                }
            }) });
        return (react.createElement(FileUploadField, Object.assign({}, getRootProps(Object.assign(Object.assign({}, props), { refKey: 'containerRef', onClick: event => event.preventDefault() })), { tabIndex: null, id: id, type: type, filename: filename, value: value, onChange: onChange, isDragActive: isDragActive, onBrowseButtonClick: open, onClearButtonClick: onClearButtonClick, onTextAreaClick: onClick, onTextChange: onTextChange }),
            react.createElement("input", Object.assign({}, inputProps, { ref: input => {
                    fileInputRef.current = input;
                    inputProps.ref(input);
                } })),
            children));
    }));
};
FileUpload.displayName = 'FileUpload';
//# sourceMappingURL=FileUpload.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FileUpload/index.js


//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormAlert.js



const FormAlert = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (
    // There are currently no associated styles with the pf-c-form_alert class.
    // Therefore, it does not exist in react-styles
    react.createElement("div", Object.assign({}, props, { className: (0,esm.css)('pf-c-form__alert', className) }), children));
};
FormAlert.displayName = 'FormAlert';
//# sourceMappingURL=FormAlert.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormFieldGroupToggle.js






const FormFieldGroupToggle = (_a) => {
    var { className, onToggle, isExpanded, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledby, toggleId } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "onToggle", "isExpanded", 'aria-label', 'aria-labelledby', "toggleId"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(Form_form["default"].formFieldGroupToggle, className) }, props),
        react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupToggleButton) },
            react.createElement(Button, { variant: "plain", "aria-label": ariaLabel, onClick: onToggle, "aria-expanded": isExpanded, "aria-labelledby": ariaLabelledby, id: toggleId },
                react.createElement("span", { className: (0,esm.css)(Form_form["default"].formFieldGroupToggleIcon) },
                    react.createElement(angle_right_icon, { "aria-hidden": "true" }))))));
};
FormFieldGroupToggle.displayName = 'FormFieldGroupToggle';
//# sourceMappingURL=FormFieldGroupToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/InternalFormFieldGroup.js






const InternalFormFieldGroup = (_a) => {
    var { children, className, header, isExpandable, isExpanded, onToggle, toggleAriaLabel } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "header", "isExpandable", "isExpanded", "onToggle", "toggleAriaLabel"]);
    const headerTitleText = header ? header.props.titleText : null;
    if (isExpandable && !toggleAriaLabel && !headerTitleText) {
        // eslint-disable-next-line no-console
        console.error('FormFieldGroupExpandable:', 'toggleAriaLabel or the titleText prop of FormFieldGroupHeader is required to make the toggle button accessible');
    }
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(Form_form["default"].formFieldGroup, isExpanded && isExpandable && Form_form["default"].modifiers.expanded, className), role: "group" }, (headerTitleText && { 'aria-labelledby': `${header.props.titleText.id}` }), props),
        isExpandable && (react.createElement(GenerateId, { prefix: "form-field-group-toggle" }, id => (react.createElement(FormFieldGroupToggle, Object.assign({ onToggle: onToggle, isExpanded: isExpanded, "aria-label": toggleAriaLabel, toggleId: id }, (headerTitleText && { 'aria-labelledby': `${header.props.titleText.id} ${id}` })))))),
        header && header,
        (!isExpandable || (isExpandable && isExpanded)) && (react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupBody) }, children))));
};
InternalFormFieldGroup.displayName = 'InternalFormFieldGroup';
//# sourceMappingURL=InternalFormFieldGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormFieldGroup.js



const FormFieldGroup = (_a) => {
    var { children, className, header } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "header"]);
    return (react.createElement(InternalFormFieldGroup, Object.assign({ className: className, header: header }, props), children));
};
FormFieldGroup.displayName = 'FormFieldGroup';
//# sourceMappingURL=FormFieldGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormFieldGroupExpandable.js




const FormFieldGroupExpandable = (_a) => {
    var { children, className, header, isExpanded = false, toggleAriaLabel } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "header", "isExpanded", "toggleAriaLabel"]);
    const [localIsExpanded, setIsExpanded] = (0,react.useState)(isExpanded);
    return (react.createElement(InternalFormFieldGroup, Object.assign({ className: className, header: header, isExpandable: true, isExpanded: localIsExpanded, toggleAriaLabel: toggleAriaLabel, onToggle: () => setIsExpanded(!localIsExpanded) }, props), children));
};
FormFieldGroupExpandable.displayName = 'FormFieldGroupExpandable';
//# sourceMappingURL=FormFieldGroupExpandable.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormFieldGroupHeader.js




const FormFieldGroupHeader = (_a) => {
    var { className, titleText, titleDescription, actions } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "titleText", "titleDescription", "actions"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(Form_form["default"].formFieldGroupHeader, className) }, props),
        react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupHeaderMain) },
            titleText && (react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupHeaderTitle) },
                react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupHeaderTitleText), id: titleText.id }, titleText.text))),
            titleDescription && react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupHeaderDescription) }, titleDescription)),
        react.createElement("div", { className: (0,esm.css)(Form_form["default"].formFieldGroupHeaderActions) }, actions && actions)));
};
FormFieldGroupHeader.displayName = 'FormFieldGroupHeader';
//# sourceMappingURL=FormFieldGroupHeader.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormHelperText.js




const FormHelperText = (_a) => {
    var { children = null, isError = false, isHidden = true, className = '', icon = null, component = 'p' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "isError", "isHidden", "className", "icon", "component"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(Form_form["default"].formHelperText, isError && Form_form["default"].modifiers.error, isHidden && Form_form["default"].modifiers.hidden, className) }, props),
        icon && react.createElement("span", { className: (0,esm.css)(Form_form["default"].formHelperTextIcon) }, icon),
        children));
};
FormHelperText.displayName = 'FormHelperText';
//# sourceMappingURL=FormHelperText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/FormSection.js





const FormSection = (_a) => {
    var { className = '', children, title = '', titleElement: TitleElement = 'div' } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "title", "titleElement"]);
    return (react.createElement(GenerateId, { prefix: "pf-form-section-title" }, sectionId => (react.createElement("section", Object.assign({ className: (0,esm.css)(Form_form["default"].formSection, className), role: "group" }, (title && { 'aria-labelledby': sectionId }), props),
        title && (react.createElement(TitleElement, { id: sectionId, className: (0,esm.css)(Form_form["default"].formSectionTitle, className) }, title)),
        children))));
};
FormSection.displayName = 'FormSection';
//# sourceMappingURL=FormSection.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Form/index.js









//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FormSelect/FormSelectOption.js


const FormSelectOption = (_a) => {
    var { className = '', value = '', isDisabled = false, label, 
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    isPlaceholder = false } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "value", "isDisabled", "label", "isPlaceholder"]);
    return (react.createElement("option", Object.assign({}, props, { className: className, value: value, disabled: isDisabled }), label));
};
FormSelectOption.displayName = 'FormSelectOption';
//# sourceMappingURL=FormSelectOption.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FormSelect/FormSelectOptionGroup.js


const FormSelectOptionGroup = (_a) => {
    var { children = null, className = '', isDisabled = false, label } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "isDisabled", "label"]);
    return (react.createElement("optgroup", Object.assign({}, props, { disabled: !!isDisabled, className: className, label: label }), children));
};
FormSelectOptionGroup.displayName = 'FormSelectOptionGroup';
//# sourceMappingURL=FormSelectOptionGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/FormSelect/index.js



//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/HelperText/helper-text.js
var helper_text = __webpack_require__(50727);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/HelperText/HelperText.js




const HelperText = (_a) => {
    var { children, className, component = 'div', id, isLiveRegion = false } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component", "id", "isLiveRegion"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ id: id, className: (0,esm.css)(helper_text/* default */.Z.helperText, className) }, (isLiveRegion && { 'aria-live': 'polite' }), props), children));
};
HelperText.displayName = 'HelperText';
//# sourceMappingURL=HelperText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/minus-icon.js


const MinusIconConfig = {
  name: 'MinusIcon',
  height: 512,
  width: 448,
  svgPath: 'M416 208H32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h384c17.67 0 32-14.33 32-32v-32c0-17.67-14.33-32-32-32z',
  yOffset: 0,
  xOffset: 0,
};

const MinusIcon = createIcon(MinusIconConfig);

/* harmony default export */ const minus_icon = (MinusIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/HelperText/HelperTextItem.js








const variantStyle = {
    default: '',
    indeterminate: helper_text/* default */.Z.modifiers.indeterminate,
    warning: helper_text/* default */.Z.modifiers.warning,
    success: helper_text/* default */.Z.modifiers.success,
    error: helper_text/* default */.Z.modifiers.error
};
const HelperTextItem = (_a) => {
    var { children, className, component = 'div', variant = 'default', icon, isDynamic = false, hasIcon = isDynamic, id, screenReaderText = `${variant} status` } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component", "variant", "icon", "isDynamic", "hasIcon", "id", "screenReaderText"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(helper_text/* default */.Z.helperTextItem, variantStyle[variant], isDynamic && helper_text/* default */.Z.modifiers.dynamic, className), id: id }, props),
        icon && (react.createElement("span", { className: (0,esm.css)(helper_text/* default */.Z.helperTextItemIcon), "aria-hidden": true }, icon)),
        hasIcon && !icon && (react.createElement("span", { className: (0,esm.css)(helper_text/* default */.Z.helperTextItemIcon), "aria-hidden": true },
            (variant === 'default' || variant === 'indeterminate') && react.createElement(minus_icon, null),
            variant === 'warning' && react.createElement(exclamation_triangle_icon, null),
            variant === 'success' && react.createElement(check_circle_icon, null),
            variant === 'error' && react.createElement(exclamation_circle_icon, null))),
        react.createElement("span", { className: (0,esm.css)(helper_text/* default */.Z.helperTextItemText) },
            children,
            isDynamic && react.createElement("span", { className: "pf-u-screen-reader" },
                ": ",
                screenReaderText,
                ";"))));
};
HelperTextItem.displayName = 'HelperTextItem';
//# sourceMappingURL=HelperTextItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/HelperText/index.js


//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Hint/hint.js
var hint = __webpack_require__(73513);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Hint/Hint.js




const Hint = (_a) => {
    var { children, className, actions } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "actions"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(hint/* default */.Z.hint, className) }, props),
        react.createElement("div", { className: (0,esm.css)(hint/* default */.Z.hintActions) }, actions),
        children));
};
Hint.displayName = 'Hint';
//# sourceMappingURL=Hint.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Hint/HintBody.js




const HintBody = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(hint/* default */.Z.hintBody, className) }, props), children));
};
HintBody.displayName = 'HintBody';
//# sourceMappingURL=HintBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Hint/HintFooter.js




const HintFooter = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(hint/* default */.Z.hintFooter, className) }, props), children));
};
HintFooter.displayName = 'HintFooter';
//# sourceMappingURL=HintFooter.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Hint/HintTitle.js




const HintTitle = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(hint/* default */.Z.hintTitle, className) }, props), children));
};
HintTitle.displayName = 'HintTitle';
//# sourceMappingURL=HintTitle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Hint/index.js




//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Icon/icon.js
var icon = __webpack_require__(24425);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Icon/Icon.js





const Icon = (_a) => {
    var { children, className, progressIcon, size, iconSize, progressIconSize, status, isInline = false, isInProgress = false, defaultProgressArialabel = 'Loading...' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "progressIcon", "size", "iconSize", "progressIconSize", "status", "isInline", "isInProgress", "defaultProgressArialabel"]);
    const _progressIcon = progressIcon ? (progressIcon) : (react.createElement(Spinner, { diameter: "1em", isSVG: true, "aria-label": defaultProgressArialabel }));
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(icon/* default */.Z.icon, isInline && icon/* default */.Z.modifiers.inline, isInProgress && icon/* default */.Z.modifiers.inProgress, icon/* default */.Z.modifiers[size], className) }, props),
        react.createElement("span", { className: (0,esm.css)(icon/* default */.Z.iconContent, icon/* default */.Z.modifiers[iconSize], icon/* default */.Z.modifiers[status]) }, children),
        isInProgress && (react.createElement("span", { className: (0,esm.css)(icon/* default */.Z.iconProgress, icon/* default */.Z.modifiers[progressIconSize], className) }, _progressIcon))));
};
Icon.displayName = 'Icon';
//# sourceMappingURL=Icon.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Icon/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/InputGroup/InputGroupText.js




var InputGroupTextVariant;
(function (InputGroupTextVariant) {
    InputGroupTextVariant["default"] = "default";
    InputGroupTextVariant["plain"] = "plain";
})(InputGroupTextVariant || (InputGroupTextVariant = {}));
const InputGroupText = (_a) => {
    var { className = '', component = 'span', children, variant = InputGroupTextVariant.default } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "component", "children", "variant"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(input_group["default"].inputGroupText, variant === InputGroupTextVariant.plain && input_group["default"].modifiers.plain, className) }, props), children));
};
InputGroupText.displayName = 'InputGroupText';
//# sourceMappingURL=InputGroupText.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/InputGroup/index.js


//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/JumpLinks/jump-links.js
var jump_links = __webpack_require__(37183);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Sidebar/sidebar.js
var sidebar = __webpack_require__(58122);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/JumpLinks/JumpLinksList.js




const JumpLinksList = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("ul", Object.assign({ className: (0,esm.css)(jump_links/* default */.Z.jumpLinksList, className) }, props), children));
};
JumpLinksList.displayName = 'JumpLinksList';
//# sourceMappingURL=JumpLinksList.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/JumpLinks/JumpLinksItem.js





const JumpLinksItem = (_a) => {
    var { isActive, href, 
    // eslint-disable-next-line
    node, children, onClick, className } = _a, props = (0,tslib_es6.__rest)(_a, ["isActive", "href", "node", "children", "onClick", "className"]);
    const childrenArr = react.Children.toArray(children);
    const sublists = childrenArr.filter(child => child.type === JumpLinksList);
    children = childrenArr.filter(child => child.type !== JumpLinksList);
    return (react.createElement("li", Object.assign({ className: (0,esm.css)(jump_links/* default */.Z.jumpLinksItem, isActive && jump_links/* default */.Z.modifiers.current, className) }, (isActive && { 'aria-current': 'location' }), props),
        react.createElement("a", { className: jump_links/* default */.Z.jumpLinksLink, href: href, onClick: onClick },
            react.createElement("span", { className: jump_links/* default */.Z.jumpLinksLinkText }, children)),
        sublists));
};
JumpLinksItem.displayName = 'JumpLinksItem';
//# sourceMappingURL=JumpLinksItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-tokens@4.94.6/node_modules/@patternfly/react-tokens/dist/esm/c_jump_links__toggle_Display.js
const c_jump_links__toggle_Display = {
  "name": "--pf-c-jump-links__toggle--Display",
  "value": "none",
  "var": "var(--pf-c-jump-links__toggle--Display)"
};
/* harmony default export */ const c_jump_links_toggle_Display = (c_jump_links__toggle_Display);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/JumpLinks/JumpLinks.js












// Recursively find JumpLinkItems and return an array of all their scrollNodes
const getScrollItems = (children, res) => {
    react.Children.forEach(children, (child) => {
        if (canUseDOM && document.getElementById && document.querySelector && child.type === JumpLinksItem) {
            const scrollNode = child.props.node || child.props.href;
            if (typeof scrollNode === 'string') {
                if (scrollNode.startsWith('#')) {
                    // Allow spaces and other special characters as `id`s to be nicer to consumers
                    // https://stackoverflow.com/questions/70579/what-are-valid-values-for-the-id-attribute-in-html
                    res.push(document.getElementById(scrollNode.substr(1)));
                }
                else {
                    res.push(document.querySelector(scrollNode));
                }
            }
            else if (scrollNode instanceof HTMLElement) {
                res.push(scrollNode);
            }
        }
        if ([react.Fragment, JumpLinksList, JumpLinksItem].includes(child.type)) {
            getScrollItems(child.props.children, res);
        }
    });
    return res;
};
function isResponsive(jumpLinks) {
    // https://github.com/patternfly/patternfly/blob/main/src/patternfly/components/JumpLinks/jump-links.scss#L103
    return (jumpLinks &&
        getComputedStyle(jumpLinks)
            .getPropertyValue(c_jump_links_toggle_Display.name)
            .includes('block'));
}
const JumpLinks = (_a) => {
    var { isCentered, isVertical, children, label, 'aria-label': ariaLabel = typeof label === 'string' ? label : null, scrollableSelector, activeIndex: activeIndexProp = 0, offset = 0, expandable, isExpanded: isExpandedProp = false, alwaysShowLabel = true, toggleAriaLabel = 'Toggle jump links', className } = _a, props = (0,tslib_es6.__rest)(_a, ["isCentered", "isVertical", "children", "label", 'aria-label', "scrollableSelector", "activeIndex", "offset", "expandable", "isExpanded", "alwaysShowLabel", "toggleAriaLabel", "className"]);
    const hasScrollSpy = Boolean(scrollableSelector);
    const [scrollItems, setScrollItems] = react.useState(hasScrollSpy ? getScrollItems(children, []) : []);
    const [activeIndex, setActiveIndex] = react.useState(activeIndexProp);
    const [isExpanded, setIsExpanded] = react.useState(isExpandedProp);
    // Boolean to disable scroll listener from overriding active state of clicked jumplink
    const isLinkClicked = react.useRef(false);
    // Allow expanding to be controlled for a niche use case
    react.useEffect(() => setIsExpanded(isExpandedProp), [isExpandedProp]);
    const navRef = react.useRef();
    let scrollableElement;
    const scrollSpy = react.useCallback(() => {
        if (!canUseDOM || !hasScrollSpy || !(scrollableElement instanceof HTMLElement)) {
            return;
        }
        if (isLinkClicked.current) {
            isLinkClicked.current = false;
            return;
        }
        const scrollPosition = Math.ceil(scrollableElement.scrollTop + offset);
        window.requestAnimationFrame(() => {
            let newScrollItems = scrollItems;
            // Items might have rendered after this component. Do a quick refresh.
            if (!newScrollItems[0] || newScrollItems.includes(null)) {
                newScrollItems = getScrollItems(children, []);
                setScrollItems(newScrollItems);
            }
            const scrollElements = newScrollItems
                .map((e, index) => ({
                y: e ? e.offsetTop : null,
                index
            }))
                .filter(({ y }) => y !== null)
                .sort((e1, e2) => e2.y - e1.y);
            for (const { y, index } of scrollElements) {
                if (scrollPosition >= y) {
                    return setActiveIndex(index);
                }
            }
        });
    }, [scrollItems, hasScrollSpy, scrollableElement, offset]);
    react.useEffect(() => {
        scrollableElement = document.querySelector(scrollableSelector);
        if (!(scrollableElement instanceof HTMLElement)) {
            return;
        }
        scrollableElement.addEventListener('scroll', scrollSpy);
        return () => scrollableElement.removeEventListener('scroll', scrollSpy);
    }, [scrollableSelector, scrollSpy]);
    react.useEffect(() => {
        scrollSpy();
    }, []);
    let jumpLinkIndex = 0;
    const cloneChildren = (children) => !hasScrollSpy
        ? children
        : react.Children.map(children, (child) => {
            if (child.type === JumpLinksItem) {
                const { onClick: onClickProp, isActive: isActiveProp } = child.props;
                const itemIndex = jumpLinkIndex++;
                const scrollItem = scrollItems[itemIndex];
                return react.cloneElement(child, {
                    onClick(ev) {
                        isLinkClicked.current = true;
                        // Items might have rendered after this component. Do a quick refresh.
                        let newScrollItems;
                        if (!scrollItem) {
                            newScrollItems = getScrollItems(children, []);
                            setScrollItems(newScrollItems);
                        }
                        const newScrollItem = scrollItem || newScrollItems[itemIndex];
                        if (newScrollItem) {
                            // we have to support scrolling to an offset due to sticky sidebar
                            const scrollableElement = document.querySelector(scrollableSelector);
                            if (scrollableElement instanceof HTMLElement) {
                                if (isResponsive(navRef.current)) {
                                    // Remove class immediately so we can get collapsed height
                                    if (navRef.current) {
                                        navRef.current.classList.remove(jump_links/* default */.Z.modifiers.expanded);
                                    }
                                    let stickyParent = navRef.current && navRef.current.parentElement;
                                    while (stickyParent && !stickyParent.classList.contains(sidebar/* default */.Z.modifiers.sticky)) {
                                        stickyParent = stickyParent.parentElement;
                                    }
                                    setIsExpanded(false);
                                    if (stickyParent) {
                                        offset += stickyParent.scrollHeight;
                                    }
                                }
                                scrollableElement.scrollTo(0, newScrollItem.offsetTop - offset);
                            }
                            newScrollItem.focus();
                            ev.preventDefault();
                            setActiveIndex(itemIndex);
                        }
                        if (onClickProp) {
                            onClickProp(ev);
                        }
                    },
                    isActive: isActiveProp || activeIndex === itemIndex,
                    children: cloneChildren(child.props.children)
                });
            }
            else if (child.type === react.Fragment) {
                return cloneChildren(child.props.children);
            }
            else if (child.type === JumpLinksList) {
                return react.cloneElement(child, { children: cloneChildren(child.props.children) });
            }
            return child;
        });
    return (react.createElement("nav", Object.assign({ className: (0,esm.css)(jump_links/* default */.Z.jumpLinks, isCentered && jump_links/* default */.Z.modifiers.center, isVertical && jump_links/* default */.Z.modifiers.vertical, formatBreakpointMods(expandable, jump_links/* default */.Z), isExpanded && jump_links/* default */.Z.modifiers.expanded, className), "aria-label": ariaLabel, ref: navRef }, props),
        react.createElement("div", { className: jump_links/* default */.Z.jumpLinksMain },
            react.createElement("div", { className: (0,esm.css)('pf-c-jump-links__header') },
                expandable && (react.createElement("div", { className: jump_links/* default */.Z.jumpLinksToggle },
                    react.createElement(Button, { variant: "plain", onClick: () => setIsExpanded(!isExpanded), "aria-label": toggleAriaLabel, "aria-expanded": isExpanded },
                        react.createElement("span", { className: jump_links/* default */.Z.jumpLinksToggleIcon },
                            react.createElement(angle_right_icon, null)),
                        label && react.createElement("span", { className: (0,esm.css)(jump_links/* default */.Z.jumpLinksToggleText) },
                            " ",
                            label,
                            " ")))),
                label && alwaysShowLabel && react.createElement("div", { className: (0,esm.css)(jump_links/* default */.Z.jumpLinksLabel) }, label)),
            react.createElement("ul", { className: jump_links/* default */.Z.jumpLinksList }, cloneChildren(children)))));
};
JumpLinks.displayName = 'JumpLinks';
//# sourceMappingURL=JumpLinks.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/JumpLinks/index.js



//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Label/label.js
var label = __webpack_require__(90119);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/LabelGroup/label-group.js
var label_group = __webpack_require__(8885);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Label/Label.js










const colorStyles = {
    blue: label["default"].modifiers.blue,
    cyan: label["default"].modifiers.cyan,
    green: label["default"].modifiers.green,
    orange: label["default"].modifiers.orange,
    purple: label["default"].modifiers.purple,
    red: label["default"].modifiers.red,
    gold: label["default"].modifiers.gold,
    grey: ''
};
const Label = (_a) => {
    var { children, className = '', color = 'grey', variant = 'filled', isCompact = false, isEditable = false, editableProps, isTruncated = false, tooltipPosition, icon, onClose, onEditCancel, onEditComplete, closeBtn, closeBtnAriaLabel, closeBtnProps, href, isOverflowLabel, render } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "color", "variant", "isCompact", "isEditable", "editableProps", "isTruncated", "tooltipPosition", "icon", "onClose", "onEditCancel", "onEditComplete", "closeBtn", "closeBtnAriaLabel", "closeBtnProps", "href", "isOverflowLabel", "render"]);
    const [isEditableActive, setIsEditableActive] = (0,react.useState)(false);
    const [currValue, setCurrValue] = (0,react.useState)(children);
    const editableButtonRef = react.useRef();
    const editableInputRef = react.useRef();
    react.useEffect(() => {
        document.addEventListener('mousedown', onDocMouseDown);
        document.addEventListener('keydown', onKeyDown);
        return () => {
            document.removeEventListener('mousedown', onDocMouseDown);
            document.removeEventListener('keydown', onKeyDown);
        };
    });
    const onDocMouseDown = (event) => {
        if (isEditableActive &&
            editableInputRef &&
            editableInputRef.current &&
            !editableInputRef.current.contains(event.target)) {
            if (editableInputRef.current.value) {
                onEditComplete && onEditComplete(event, editableInputRef.current.value);
            }
            setIsEditableActive(false);
        }
    };
    const onKeyDown = (event) => {
        var _a, _b;
        const key = event.key;
        if ((!isEditableActive &&
            (!editableButtonRef ||
                !editableButtonRef.current ||
                !editableButtonRef.current.contains(event.target))) ||
            (isEditableActive &&
                (!editableInputRef || !editableInputRef.current || !editableInputRef.current.contains(event.target)))) {
            return;
        }
        if (isEditableActive && (key === 'Enter' || key === 'Tab')) {
            event.preventDefault();
            event.stopImmediatePropagation();
            if (editableInputRef.current.value) {
                onEditComplete && onEditComplete(event, editableInputRef.current.value);
            }
            setIsEditableActive(false);
            (_a = editableButtonRef === null || editableButtonRef === void 0 ? void 0 : editableButtonRef.current) === null || _a === void 0 ? void 0 : _a.focus();
        }
        if (isEditableActive && key === 'Escape') {
            event.preventDefault();
            event.stopImmediatePropagation();
            // Reset div text to initial children prop - pre-edit
            if (editableInputRef.current.value) {
                editableInputRef.current.value = children;
                onEditCancel && onEditCancel(event, children);
            }
            setIsEditableActive(false);
            (_b = editableButtonRef === null || editableButtonRef === void 0 ? void 0 : editableButtonRef.current) === null || _b === void 0 ? void 0 : _b.focus();
        }
        if (!isEditableActive && key === 'Enter') {
            event.preventDefault();
            event.stopImmediatePropagation();
            setIsEditableActive(true);
            // Set cursor position to end of text
            const el = event.target;
            const range = document.createRange();
            const sel = window.getSelection();
            range.selectNodeContents(el);
            range.collapse(false);
            sel.removeAllRanges();
            sel.addRange(range);
        }
    };
    const LabelComponent = (isOverflowLabel ? 'button' : 'span');
    const button = closeBtn ? (closeBtn) : (react.createElement(Button, Object.assign({ type: "button", variant: "plain", onClick: onClose, "aria-label": closeBtnAriaLabel || `Close ${children}` }, closeBtnProps),
        react.createElement(times_icon, null)));
    const textRef = react.createRef();
    // ref to apply tooltip when rendered is used
    const componentRef = react.useRef();
    const [isTooltipVisible, setIsTooltipVisible] = react.useState(false);
    useIsomorphicLayoutEffect(() => {
        const currTextRef = isEditable ? editableButtonRef : textRef;
        if (!isEditableActive) {
            setIsTooltipVisible(currTextRef.current && currTextRef.current.offsetWidth < currTextRef.current.scrollWidth);
        }
    }, [isEditableActive]);
    const content = (react.createElement(react.Fragment, null,
        icon && react.createElement("span", { className: (0,esm.css)(label["default"].labelIcon) }, icon),
        isTruncated && (react.createElement("span", { ref: textRef, className: (0,esm.css)(label["default"].labelText) }, children)),
        !isTruncated && children));
    react.useEffect(() => {
        if (isEditableActive && editableInputRef) {
            editableInputRef.current && editableInputRef.current.focus();
        }
    }, [editableInputRef, isEditableActive]);
    const updateVal = () => {
        setCurrValue(editableInputRef.current.value);
    };
    let labelComponentChild = react.createElement("span", { className: (0,esm.css)(label["default"].labelContent) }, content);
    if (href) {
        labelComponentChild = (react.createElement("a", { className: (0,esm.css)(label["default"].labelContent), href: href }, content));
    }
    else if (isEditable) {
        labelComponentChild = (react.createElement("button", Object.assign({ ref: editableButtonRef, className: (0,esm.css)(label["default"].labelContent), onClick: (e) => {
                setIsEditableActive(true);
                e.stopPropagation();
            } }, editableProps), content));
    }
    if (render) {
        labelComponentChild = (react.createElement(react.Fragment, null,
            isTooltipVisible && react.createElement(Tooltip, { reference: componentRef, content: children, position: tooltipPosition }),
            render({
                className: label["default"].labelContent,
                content,
                componentRef
            })));
    }
    else if (isTooltipVisible) {
        labelComponentChild = (react.createElement(Tooltip, { content: children, position: tooltipPosition }, labelComponentChild));
    }
    return (react.createElement(LabelComponent, Object.assign({}, props, { className: (0,esm.css)(label["default"].label, colorStyles[color], variant === 'outline' && label["default"].modifiers.outline, isOverflowLabel && label["default"].modifiers.overflow, isCompact && label["default"].modifiers.compact, isEditable && label_group["default"].modifiers.editable, isEditableActive && label["default"].modifiers.editableActive, className) }),
        !isEditableActive && labelComponentChild,
        !isEditableActive && onClose && button,
        isEditableActive && (react.createElement("input", Object.assign({ className: (0,esm.css)(label["default"].labelContent), type: "text", id: "editable-input", ref: editableInputRef, value: currValue, onChange: updateVal }, editableProps)))));
};
Label.displayName = 'Label';
//# sourceMappingURL=Label.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Label/index.js

//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LabelGroup/LabelGroup.js











class LabelGroup extends react.Component {
    constructor(props) {
        super(props);
        this.headingRef = react.createRef();
        this.toggleCollapse = () => {
            this.setState(prevState => ({
                isOpen: !prevState.isOpen,
                isTooltipVisible: Boolean(this.headingRef.current && this.headingRef.current.offsetWidth < this.headingRef.current.scrollWidth)
            }));
        };
        this.state = {
            isOpen: this.props.defaultIsOpen,
            isTooltipVisible: false
        };
    }
    componentDidMount() {
        this.setState({
            isTooltipVisible: Boolean(this.headingRef.current && this.headingRef.current.offsetWidth < this.headingRef.current.scrollWidth)
        });
    }
    renderLabel(id) {
        const { categoryName, tooltipPosition } = this.props;
        const { isTooltipVisible } = this.state;
        return isTooltipVisible ? (react.createElement(Tooltip, { position: tooltipPosition, content: categoryName },
            react.createElement("span", { tabIndex: 0, ref: this.headingRef, className: (0,esm.css)(label_group["default"].labelGroupLabel) },
                react.createElement("span", { "aria-hidden": "true", id: id }, categoryName)))) : (react.createElement("span", { ref: this.headingRef, className: (0,esm.css)(label_group["default"].labelGroupLabel), "aria-hidden": "true", id: id }, categoryName));
    }
    render() {
        const _a = this.props, { categoryName, children, className, isClosable, isCompact, closeBtnAriaLabel, 'aria-label': ariaLabel, onClick, numLabels, expandedText, collapsedText, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        defaultIsOpen, tooltipPosition, isVertical, isEditable, hasEditableTextArea, editableTextAreaProps, addLabelControl } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        rest = (0,tslib_es6.__rest)(_a, ["categoryName", "children", "className", "isClosable", "isCompact", "closeBtnAriaLabel", 'aria-label', "onClick", "numLabels", "expandedText", "collapsedText", "defaultIsOpen", "tooltipPosition", "isVertical", "isEditable", "hasEditableTextArea", "editableTextAreaProps", "addLabelControl"]);
        const { isOpen } = this.state;
        const renderedChildren = react.Children.toArray(children);
        const numChildren = renderedChildren.length;
        const collapsedTextResult = fillTemplate(collapsedText, {
            remaining: numChildren - numLabels
        });
        const renderLabelGroup = (id) => {
            const labelArray = !isOpen ? renderedChildren.slice(0, numLabels) : renderedChildren;
            const content = (react.createElement(react.Fragment, null,
                categoryName && this.renderLabel(id),
                react.createElement("ul", Object.assign({ className: (0,esm.css)(label_group["default"].labelGroupList) }, (categoryName && { 'aria-labelledby': id }), (!categoryName && { 'aria-label': ariaLabel }), { role: "list" }, rest),
                    labelArray.map((child, i) => (react.createElement("li", { className: (0,esm.css)(label_group["default"].labelGroupListItem), key: i }, child))),
                    numChildren > numLabels && (react.createElement("li", { className: (0,esm.css)(label_group["default"].labelGroupListItem) },
                        react.createElement(Label, { isOverflowLabel: true, onClick: this.toggleCollapse, className: (0,esm.css)(isCompact && label["default"].modifiers.compact) }, isOpen ? expandedText : collapsedTextResult))),
                    addLabelControl && react.createElement("li", { className: (0,esm.css)(label_group["default"].labelGroupListItem) }, addLabelControl),
                    isEditable && hasEditableTextArea && (react.createElement("li", { className: (0,esm.css)(label_group["default"].labelGroupListItem, label_group["default"].modifiers.textarea) },
                        react.createElement("textarea", Object.assign({ className: (0,esm.css)(label_group["default"].labelGroupTextarea), rows: 1, tabIndex: 0 }, editableTextAreaProps)))))));
            const close = (react.createElement("div", { className: (0,esm.css)(label_group["default"].labelGroupClose) },
                react.createElement(Button, { variant: "plain", "aria-label": closeBtnAriaLabel, onClick: onClick, id: `remove_group_${id}`, "aria-labelledby": `remove_group_${id} ${id}` },
                    react.createElement(times_circle_icon, { "aria-hidden": "true" }))));
            return (react.createElement("div", { className: (0,esm.css)(label_group["default"].labelGroup, className, categoryName && label_group["default"].modifiers.category, isVertical && label_group["default"].modifiers.vertical, isEditable && label_group["default"].modifiers.editable) },
                react.createElement("div", { className: (0,esm.css)(label_group["default"].labelGroupMain) }, content),
                isClosable && close));
        };
        return numChildren === 0 && addLabelControl === undefined ? null : (react.createElement(GenerateId, null, randomId => renderLabelGroup(this.props.id || randomId)));
    }
}
LabelGroup.displayName = 'LabelGroup';
LabelGroup.defaultProps = {
    expandedText: 'Show Less',
    collapsedText: '${remaining} more',
    categoryName: '',
    defaultIsOpen: false,
    numLabels: 3,
    isClosable: false,
    isCompact: false,
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    onClick: (_e) => undefined,
    closeBtnAriaLabel: 'Close label group',
    tooltipPosition: 'top',
    'aria-label': 'Label group category',
    isVertical: false,
    isEditable: false,
    hasEditableTextArea: false
};
//# sourceMappingURL=LabelGroup.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LabelGroup/index.js

//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/List/list.js
var list = __webpack_require__(17812);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/List/List.js




var OrderType;
(function (OrderType) {
    OrderType["number"] = "1";
    OrderType["lowercaseLetter"] = "a";
    OrderType["uppercaseLetter"] = "A";
    OrderType["lowercaseRomanNumber"] = "i";
    OrderType["uppercaseRomanNumber"] = "I";
})(OrderType || (OrderType = {}));
var ListVariant;
(function (ListVariant) {
    ListVariant["inline"] = "inline";
})(ListVariant || (ListVariant = {}));
var ListComponent;
(function (ListComponent) {
    ListComponent["ol"] = "ol";
    ListComponent["ul"] = "ul";
})(ListComponent || (ListComponent = {}));
const List = (_a) => {
    var { className = '', children = null, variant = null, isBordered = false, isPlain = false, iconSize = 'default', type = OrderType.number, ref = null, component = ListComponent.ul } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "variant", "isBordered", "isPlain", "iconSize", "type", "ref", "component"]);
    return component === ListComponent.ol ? (react.createElement("ol", Object.assign({ ref: ref, type: type }, props, { className: (0,esm.css)(list/* default */.Z.list, variant && list/* default */.Z.modifiers[variant], isBordered && list/* default */.Z.modifiers.bordered, isPlain && list/* default */.Z.modifiers.plain, iconSize && iconSize === 'large' && list/* default */.Z.modifiers.iconLg, className) }), children)) : (react.createElement("ul", Object.assign({ ref: ref }, props, { className: (0,esm.css)(list/* default */.Z.list, variant && list/* default */.Z.modifiers[variant], isBordered && list/* default */.Z.modifiers.bordered, isPlain && list/* default */.Z.modifiers.plain, iconSize && iconSize === 'large' && list/* default */.Z.modifiers.iconLg, className) }), children));
};
List.displayName = 'List';
//# sourceMappingURL=List.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/List/ListItem.js




const ListItem = (_a) => {
    var { icon = null, children = null } = _a, props = (0,tslib_es6.__rest)(_a, ["icon", "children"]);
    return (react.createElement("li", Object.assign({ className: (0,esm.css)(icon && list/* default */.Z.listItem) }, props),
        icon && react.createElement("span", { className: (0,esm.css)(list/* default */.Z.listItemIcon) }, icon),
        children));
};
ListItem.displayName = 'ListItem';
//# sourceMappingURL=ListItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/List/index.js


//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Login/login.js
var login = __webpack_require__(94601);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/Login.js




const Login = (_a) => {
    var { className = '', children = null, footer = null, header = null } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "footer", "header"]);
    return (react.createElement("div", Object.assign({}, props, { className: (0,esm.css)(login/* default */.Z.login, className) }),
        react.createElement("div", { className: (0,esm.css)(login/* default */.Z.loginContainer) },
            header,
            react.createElement("main", { className: (0,esm.css)(login/* default */.Z.loginMain) }, children),
            footer)));
};
Login.displayName = 'Login';
//# sourceMappingURL=Login.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginHeader.js




const LoginHeader = (_a) => {
    var { className = '', children = null, headerBrand = null } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children", "headerBrand"]);
    return (react.createElement("header", Object.assign({ className: (0,esm.css)(login/* default */.Z.loginHeader, className) }, props),
        headerBrand,
        children));
};
LoginHeader.displayName = 'LoginHeader';
//# sourceMappingURL=LoginHeader.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginFooter.js




const LoginFooter = (_a) => {
    var { className = '', children = null } = _a, props = (0,tslib_es6.__rest)(_a, ["className", "children"]);
    return (react.createElement("footer", Object.assign({ className: (0,esm.css)(login/* default */.Z.loginFooter, className) }, props), children));
};
LoginFooter.displayName = 'LoginFooter';
//# sourceMappingURL=LoginFooter.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginMainHeader.js





const LoginMainHeader = (_a) => {
    var { children = null, className = '', title = '', subtitle = '', headerUtilities = null } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "title", "subtitle", "headerUtilities"]);
    return (react.createElement("header", Object.assign({ className: (0,esm.css)(login/* default */.Z.loginMainHeader, className) }, props),
        title && (react.createElement(Title, { headingLevel: "h2", size: TitleSizes['3xl'] }, title)),
        subtitle && react.createElement("p", { className: (0,esm.css)(login/* default */.Z.loginMainHeaderDesc) }, subtitle),
        headerUtilities && react.createElement("div", { className: (0,esm.css)(login/* default */.Z.loginMainHeaderUtilities) }, headerUtilities),
        children));
};
LoginMainHeader.displayName = 'LoginMainHeader';
//# sourceMappingURL=LoginMainHeader.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginMainBody.js




const LoginMainBody = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(login/* default */.Z.loginMainBody, className) }, props), children));
};
LoginMainBody.displayName = 'LoginMainBody';
//# sourceMappingURL=LoginMainBody.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginMainFooter.js




const LoginMainFooter = (_a) => {
    var { children = null, socialMediaLoginContent = null, signUpForAccountMessage = null, forgotCredentials = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "socialMediaLoginContent", "signUpForAccountMessage", "forgotCredentials", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(login/* default */.Z.loginMainFooter, className) }, props),
        children,
        socialMediaLoginContent && react.createElement("ul", { className: (0,esm.css)(login/* default */.Z.loginMainFooterLinks) }, socialMediaLoginContent),
        (signUpForAccountMessage || forgotCredentials) && (react.createElement("div", { className: (0,esm.css)(login/* default */.Z.loginMainFooterBand) },
            signUpForAccountMessage,
            forgotCredentials))));
};
LoginMainFooter.displayName = 'LoginMainFooter';
//# sourceMappingURL=LoginMainFooter.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginPage.js












const LoginPage = (_a) => {
    var { children = null, className = '', brandImgSrc = '', brandImgAlt = '', backgroundImgSrc = '', backgroundImgAlt = '', footerListItems = null, textContent = '', footerListVariants, loginTitle, loginSubtitle, headerUtilities, signUpForAccountMessage = null, forgotCredentials = null, socialMediaLoginContent = null } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "brandImgSrc", "brandImgAlt", "backgroundImgSrc", "backgroundImgAlt", "footerListItems", "textContent", "footerListVariants", "loginTitle", "loginSubtitle", "headerUtilities", "signUpForAccountMessage", "forgotCredentials", "socialMediaLoginContent"]);
    const HeaderBrand = (react.createElement(react.Fragment, null,
        react.createElement(Brand, { src: brandImgSrc, alt: brandImgAlt })));
    const Header = react.createElement(LoginHeader, { headerBrand: HeaderBrand });
    const Footer = (react.createElement(LoginFooter, null,
        react.createElement("p", null, textContent),
        react.createElement(List, { variant: footerListVariants }, footerListItems)));
    return (react.createElement(react.Fragment, null,
        backgroundImgSrc && react.createElement(BackgroundImage, { src: backgroundImgSrc, alt: backgroundImgAlt }),
        react.createElement(Login, Object.assign({ header: Header, footer: Footer, className: (0,esm.css)(className) }, props),
            react.createElement(LoginMainHeader, { title: loginTitle, subtitle: loginSubtitle, headerUtilities: headerUtilities }),
            react.createElement(LoginMainBody, null, children),
            (socialMediaLoginContent || forgotCredentials || signUpForAccountMessage) && (react.createElement(LoginMainFooter, { socialMediaLoginContent: socialMediaLoginContent, forgotCredentials: forgotCredentials, signUpForAccountMessage: signUpForAccountMessage })))));
};
LoginPage.displayName = 'LoginPage';
//# sourceMappingURL=LoginPage.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/eye-slash-icon.js


const EyeSlashIconConfig = {
  name: 'EyeSlashIcon',
  height: 512,
  width: 640,
  svgPath: 'M320 400c-75.85 0-137.25-58.71-142.9-133.11L72.2 185.82c-13.79 17.3-26.48 35.59-36.72 55.59a32.35 32.35 0 0 0 0 29.19C89.71 376.41 197.07 448 320 448c26.91 0 52.87-4 77.89-10.46L346 397.39a144.13 144.13 0 0 1-26 2.61zm313.82 58.1l-110.55-85.44a331.25 331.25 0 0 0 81.25-102.07 32.35 32.35 0 0 0 0-29.19C550.29 135.59 442.93 64 320 64a308.15 308.15 0 0 0-147.32 37.7L45.46 3.37A16 16 0 0 0 23 6.18L3.37 31.45A16 16 0 0 0 6.18 53.9l588.36 454.73a16 16 0 0 0 22.46-2.81l19.64-25.27a16 16 0 0 0-2.82-22.45zm-183.72-142l-39.3-30.38A94.75 94.75 0 0 0 416 256a94.76 94.76 0 0 0-121.31-92.21A47.65 47.65 0 0 1 304 192a46.64 46.64 0 0 1-1.54 10l-73.61-56.89A142.31 142.31 0 0 1 320 112a143.92 143.92 0 0 1 144 144c0 21.63-5.29 41.79-13.9 60.11z',
  yOffset: 0,
  xOffset: 0,
};

const EyeSlashIcon = createIcon(EyeSlashIconConfig);

/* harmony default export */ const eye_slash_icon = (EyeSlashIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-icons@4.93.6_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-icons/dist/esm/icons/eye-icon.js


const EyeIconConfig = {
  name: 'EyeIcon',
  height: 512,
  width: 576,
  svgPath: 'M572.52 241.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288 400a144 144 0 1 1 144-144 143.93 143.93 0 0 1-144 144zm0-240a95.31 95.31 0 0 0-25.31 3.79 47.85 47.85 0 0 1-66.9 66.9A95.78 95.78 0 1 0 288 160z',
  yOffset: 0,
  xOffset: 0,
};

const EyeIcon = createIcon(EyeIconConfig);

/* harmony default export */ const eye_icon = (EyeIcon);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginForm.js










const LoginForm = (_a) => {
    var { noAutoFocus = false, className = '', showHelperText = false, helperText = null, helperTextIcon = null, usernameLabel = 'Username', usernameValue = '', onChangeUsername = () => undefined, isValidUsername = true, passwordLabel = 'Password', passwordValue = '', onChangePassword = () => undefined, isShowPasswordEnabled = false, hidePasswordAriaLabel = 'Hide password', showPasswordAriaLabel = 'Show password', isValidPassword = true, loginButtonLabel = 'Log In', isLoginButtonDisabled = false, onLoginButtonClick = () => undefined, rememberMeLabel = '', isRememberMeChecked = false, onChangeRememberMe = () => undefined } = _a, props = (0,tslib_es6.__rest)(_a, ["noAutoFocus", "className", "showHelperText", "helperText", "helperTextIcon", "usernameLabel", "usernameValue", "onChangeUsername", "isValidUsername", "passwordLabel", "passwordValue", "onChangePassword", "isShowPasswordEnabled", "hidePasswordAriaLabel", "showPasswordAriaLabel", "isValidPassword", "loginButtonLabel", "isLoginButtonDisabled", "onLoginButtonClick", "rememberMeLabel", "isRememberMeChecked", "onChangeRememberMe"]);
    const [passwordHidden, setPasswordHidden] = react.useState(true);
    const passwordInput = (react.createElement(TextInput, { isRequired: true, type: passwordHidden ? 'password' : 'text', id: "pf-login-password-id", name: "pf-login-password-id", validated: isValidPassword ? ValidatedOptions.default : ValidatedOptions.error, value: passwordValue, onChange: onChangePassword }));
    return (react.createElement(Form, Object.assign({ className: className }, props),
        react.createElement(FormHelperText, { isError: !isValidUsername || !isValidPassword, isHidden: !showHelperText, icon: helperTextIcon }, helperText),
        react.createElement(FormGroup, { label: usernameLabel, isRequired: true, validated: isValidUsername ? ValidatedOptions.default : ValidatedOptions.error, fieldId: "pf-login-username-id" },
            react.createElement(TextInput, { autoFocus: !noAutoFocus, id: "pf-login-username-id", isRequired: true, validated: isValidUsername ? ValidatedOptions.default : ValidatedOptions.error, type: "text", name: "pf-login-username-id", value: usernameValue, onChange: onChangeUsername })),
        react.createElement(FormGroup, { label: passwordLabel, isRequired: true, validated: isValidPassword ? ValidatedOptions.default : ValidatedOptions.error, fieldId: "pf-login-password-id" },
            isShowPasswordEnabled && (react.createElement(InputGroup, null,
                passwordInput,
                react.createElement(Button, { variant: "control", onClick: () => setPasswordHidden(!passwordHidden), "aria-label": passwordHidden ? showPasswordAriaLabel : hidePasswordAriaLabel }, passwordHidden ? react.createElement(eye_icon, null) : react.createElement(eye_slash_icon, null)))),
            !isShowPasswordEnabled && passwordInput),
        rememberMeLabel.length > 0 && (react.createElement(FormGroup, { fieldId: "pf-login-remember-me-id" },
            react.createElement(Checkbox, { id: "pf-login-remember-me-id", label: rememberMeLabel, isChecked: isRememberMeChecked, onChange: onChangeRememberMe }))),
        react.createElement(ActionGroup, null,
            react.createElement(Button, { variant: "primary", type: "submit", onClick: onLoginButtonClick, isBlock: true, isDisabled: isLoginButtonDisabled }, loginButtonLabel))));
};
LoginForm.displayName = 'LoginForm';
//# sourceMappingURL=LoginForm.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginFooterItem.js


const LoginFooterItem = (_a) => {
    var { children = null, href = '#', target = '_blank' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "href", "target"]);
    return react.isValidElement(children) ? (children) : (react.createElement("a", Object.assign({ target: target, href: href }, props), children));
};
LoginFooterItem.displayName = 'LoginFooterItem';
//# sourceMappingURL=LoginFooterItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginMainFooterBandItem.js




const LoginMainFooterBandItem = (_a) => {
    var { children = null, className = '' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("p", Object.assign({ className: (0,esm.css)(`${login/* default */.Z.loginMainFooterBand}-item`, className) }, props), children));
};
LoginMainFooterBandItem.displayName = 'LoginMainFooterBandItem';
//# sourceMappingURL=LoginMainFooterBandItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/LoginMainFooterLinksItem.js




const LoginMainFooterLinksItem = (_a) => {
    var { children = null, href = '', target = '', className = '', linkComponent = 'a', linkComponentProps } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "href", "target", "className", "linkComponent", "linkComponentProps"]);
    const LinkComponent = linkComponent;
    return (react.createElement("li", Object.assign({ className: (0,esm.css)(login/* default */.Z.loginMainFooterLinksItem, className) }, props),
        react.createElement(LinkComponent, Object.assign({ className: (0,esm.css)(login/* default */.Z.loginMainFooterLinksItemLink), href: href, target: target }, linkComponentProps), children)));
};
LoginMainFooterLinksItem.displayName = 'LoginMainFooterLinksItem';
//# sourceMappingURL=LoginMainFooterLinksItem.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/LoginPage/index.js











//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Masthead/masthead.js
var masthead = __webpack_require__(41771);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Page/PageContext.js


const pageContextDefaults = {
    isManagedSidebar: false,
    isNavOpen: false,
    onNavToggle: () => null,
    width: null,
    height: null,
    getBreakpoint: getBreakpoint,
    getVerticalBreakpoint: getVerticalBreakpoint
};
const PageContext = react.createContext(pageContextDefaults);
const PageContextProvider = PageContext.Provider;
const PageContextConsumer = PageContext.Consumer;
//# sourceMappingURL=PageContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Masthead/Masthead.js






const Masthead = (_a) => {
    var { children, className, backgroundColor = 'dark', display = {
        md: 'inline'
    }, inset } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "backgroundColor", "display", "inset"]);
    const { width, getBreakpoint } = react.useContext(PageContext);
    return (react.createElement("header", Object.assign({ className: (0,esm.css)(masthead/* default */.Z.masthead, formatBreakpointMods(display, masthead/* default */.Z, 'display-', getBreakpoint(width)), formatBreakpointMods(inset, masthead/* default */.Z, '', getBreakpoint(width)), backgroundColor === 'light' && masthead/* default */.Z.modifiers.light, backgroundColor === 'light200' && masthead/* default */.Z.modifiers.light_200, className) }, props), children));
};
Masthead.displayName = 'Masthead';
//# sourceMappingURL=Masthead.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Masthead/MastheadBrand.js




const MastheadBrand = (_a) => {
    var { children, className, component = 'a' } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className", "component"]);
    const Component = component;
    return (react.createElement(Component, Object.assign({ className: (0,esm.css)(masthead/* default */.Z.mastheadBrand, className), tabIndex: 0 }, props), children));
};
MastheadBrand.displayName = 'MastheadBrand';
//# sourceMappingURL=MastheadBrand.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Masthead/MastheadContent.js




const MastheadContent = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(masthead/* default */.Z.mastheadContent, className) }, props), children));
};
MastheadContent.displayName = 'MastheadContent';
//# sourceMappingURL=MastheadContent.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Masthead/MastheadMain.js




const MastheadMain = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("div", Object.assign({ className: (0,esm.css)(masthead/* default */.Z.mastheadMain, className) }, props), children));
};
MastheadMain.displayName = 'MastheadMain';
//# sourceMappingURL=MastheadMain.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Masthead/MastheadToggle.js




const MastheadToggle = (_a) => {
    var { children, className } = _a, props = (0,tslib_es6.__rest)(_a, ["children", "className"]);
    return (react.createElement("span", Object.assign({ className: (0,esm.css)(masthead/* default */.Z.mastheadToggle, className) }, props), children));
};
MastheadToggle.displayName = 'MastheadToggle';
//# sourceMappingURL=MastheadToggle.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Masthead/index.js





//# sourceMappingURL=index.js.map
// EXTERNAL MODULE: ../../node_modules/.pnpm/@patternfly+react-styles@4.92.6/node_modules/@patternfly/react-styles/css/components/Menu/menu.js
var menu = __webpack_require__(26802);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Menu/MenuContext.js

const MenuContext = react.createContext({
    menuId: null,
    parentMenu: null,
    onActionClick: () => null,
    onSelect: () => null,
    activeItemId: null,
    selected: null,
    drilledInMenus: [],
    drilldownItemPath: [],
    onDrillIn: null,
    onDrillOut: null,
    onGetMenuHeight: () => null,
    flyoutRef: null,
    setFlyoutRef: () => null,
    disableHover: false,
    role: 'menu'
});
const MenuItemContext = react.createContext({
    itemId: null,
    isDisabled: false
});
//# sourceMappingURL=MenuContext.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Menu/Menu.js








class MenuBase extends react.Component {
    constructor(props) {
        super(props);
        this.menuRef = react.createRef();
        this.activeMenu = null;
        this.state = {
            ouiaStateId: getDefaultOUIAId(Menu.displayName),
            searchInputValue: '',
            transitionMoveTarget: null,
            flyoutRef: null,
            disableHover: false,
            currentDrilldownMenuId: this.props.id
        };
        this.handleDrilldownTransition = (event) => {
            const current = this.menuRef.current;
            if (!current ||
                (current !== event.target.closest('.pf-c-menu') &&
                    !Array.from(current.getElementsByClassName('pf-c-menu')).includes(event.target.closest('.pf-c-menu')))) {
                return;
            }
            if (this.state.transitionMoveTarget) {
                this.state.transitionMoveTarget.focus();
                this.setState({ transitionMoveTarget: null });
            }
            else {
                const nextMenu = current.querySelector('#' + this.props.activeMenu) || current || null;
                const nextMenuChildren = Array.from(nextMenu.getElementsByTagName('UL')[0].children);
                if (!this.state.currentDrilldownMenuId || nextMenu.id !== this.state.currentDrilldownMenuId) {
                    this.setState({ currentDrilldownMenuId: nextMenu.id });
                }
                else {
                    // if the drilldown transition ends on the same menu, do not focus the first item
                    return;
                }
                const nextTarget = nextMenuChildren.filter(el => !(el.classList.contains('pf-m-disabled') || el.classList.contains('pf-c-divider')))[0].firstChild;
                nextTarget.focus();
                nextTarget.tabIndex = 0;
            }
        };
        this.handleExtraKeys = (event) => {
            const isDrilldown = this.props.containsDrilldown;
            const activeElement = document.activeElement;
            if (event.target.closest('.pf-c-menu') !== this.activeMenu &&
                !event.target.classList.contains('pf-c-breadcrumb__link')) {
                this.activeMenu = event.target.closest('.pf-c-menu');
                this.setState({ disableHover: true });
            }
            if (event.target.tagName === 'INPUT') {
                return;
            }
            const parentMenu = this.activeMenu;
            const key = event.key;
            const isFromBreadcrumb = activeElement.classList.contains('pf-c-breadcrumb__link') ||
                activeElement.classList.contains('pf-c-dropdown__toggle');
            if (key === ' ' || key === 'Enter') {
                event.preventDefault();
                if (isDrilldown && !isFromBreadcrumb) {
                    const isDrillingOut = activeElement.closest('li').classList.contains('pf-m-current-path');
                    if (isDrillingOut && parentMenu.parentElement.tagName === 'LI') {
                        activeElement.tabIndex = -1;
                        parentMenu.parentElement.firstChild.tabIndex = 0;
                        this.setState({ transitionMoveTarget: parentMenu.parentElement.firstChild });
                    }
                    else {
                        if (activeElement.nextElementSibling && activeElement.nextElementSibling.classList.contains('pf-c-menu')) {
                            const childItems = Array.from(activeElement.nextElementSibling.getElementsByTagName('UL')[0].children).filter(el => !(el.classList.contains('pf-m-disabled') || el.classList.contains('pf-c-divider')));
                            activeElement.tabIndex = -1;
                            childItems[0].firstChild.tabIndex = 0;
                            this.setState({ transitionMoveTarget: childItems[0].firstChild });
                        }
                    }
                }
                document.activeElement.click();
            }
        };
        this.createNavigableElements = () => {
            const isDrilldown = this.props.containsDrilldown;
            if (isDrilldown) {
                return this.activeMenu
                    ? Array.from(this.activeMenu.getElementsByTagName('UL')[0].children).filter(el => !(el.classList.contains('pf-m-disabled') || el.classList.contains('pf-c-divider')))
                    : [];
            }
            else {
                return this.menuRef.current
                    ? Array.from(this.menuRef.current.getElementsByTagName('LI')).filter(el => !(el.classList.contains('pf-m-disabled') || el.classList.contains('pf-c-divider')))
                    : [];
            }
        };
        if (props.innerRef) {
            this.menuRef = props.innerRef;
        }
    }
    allowTabFirstItem() {
        // Allow tabbing to first menu item
        const current = this.menuRef.current;
        if (current) {
            const first = current.querySelector('ul button:not(:disabled), ul a:not(:disabled)');
            if (first) {
                first.tabIndex = 0;
            }
        }
    }
    componentDidMount() {
        if (this.context) {
            this.setState({ disableHover: this.context.disableHover });
        }
        if (canUseDOM) {
            window.addEventListener('transitionend', this.props.isRootMenu ? this.handleDrilldownTransition : null);
        }
        this.allowTabFirstItem();
    }
    componentWillUnmount() {
        if (canUseDOM) {
            window.removeEventListener('transitionend', this.handleDrilldownTransition);
        }
    }
    componentDidUpdate(prevProps) {
        if (prevProps.children !== this.props.children) {
            this.allowTabFirstItem();
        }
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, id, children, className, onSelect, selected = null, onActionClick, ouiaId, ouiaSafe, containsFlyout, isNavFlyout, containsDrilldown, isMenuDrilledIn, isPlain, isScrollable, drilldownItemPath, drilledInMenus, onDrillIn, onDrillOut, onGetMenuHeight, parentMenu = null, activeItemId = null, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        innerRef, isRootMenu, activeMenu, role } = _a, 
        /* eslint-enable @typescript-eslint/no-unused-vars */
        props = (0,tslib_es6.__rest)(_a, ['aria-label', "id", "children", "className", "onSelect", "selected", "onActionClick", "ouiaId", "ouiaSafe", "containsFlyout", "isNavFlyout", "containsDrilldown", "isMenuDrilledIn", "isPlain", "isScrollable", "drilldownItemPath", "drilledInMenus", "onDrillIn", "onDrillOut", "onGetMenuHeight", "parentMenu", "activeItemId", "innerRef", "isRootMenu", "activeMenu", "role"]);
        const _isMenuDrilledIn = isMenuDrilledIn || (drilledInMenus && drilledInMenus.includes(id)) || false;
        return (react.createElement(MenuContext.Provider, { value: {
                menuId: id,
                parentMenu: parentMenu || id,
                onSelect,
                onActionClick,
                activeItemId,
                selected,
                drilledInMenus,
                drilldownItemPath,
                onDrillIn,
                onDrillOut,
                onGetMenuHeight,
                flyoutRef: this.state.flyoutRef,
                setFlyoutRef: flyoutRef => this.setState({ flyoutRef }),
                disableHover: this.state.disableHover,
                role
            } },
            isRootMenu && (react.createElement(KeyboardHandler, { containerRef: this.menuRef || null, additionalKeyHandler: this.handleExtraKeys, createNavigableElements: this.createNavigableElements, isActiveElement: (element) => document.activeElement.closest('li') === element || // if element is a basic MenuItem
                    document.activeElement.parentElement === element ||
                    document.activeElement.closest('.pf-c-menu__search') === element || // if element is a MenuInput
                    (document.activeElement.closest('ol') && document.activeElement.closest('ol').firstChild === element), getFocusableElement: (navigableElement) => (navigableElement.tagName === 'DIV' && navigableElement.querySelector('input')) || // for MenuInput
                    (navigableElement.firstChild.tagName === 'LABEL' &&
                        navigableElement.querySelector('input')) || // for MenuItem checkboxes
                    navigableElement.firstChild, noHorizontalArrowHandling: document.activeElement &&
                    (document.activeElement.classList.contains('pf-c-breadcrumb__link') ||
                        document.activeElement.classList.contains('pf-c-dropdown__toggle')), noEnterHandling: true, noSpaceHandling: true })),
            react.createElement("div", Object.assign({ id: id, className: (0,esm.css)(menu/* default */.Z.menu, isPlain && menu/* default */.Z.modifiers.plain, isScrollable && menu/* default */.Z.modifiers.scrollable, containsFlyout && menu/* default */.Z.modifiers.flyout, isNavFlyout && menu/* default */.Z.modifiers.nav, containsDrilldown && menu/* default */.Z.modifiers.drilldown, _isMenuDrilledIn && menu/* default */.Z.modifiers.drilledIn, className), "aria-label": ariaLabel, ref: this.menuRef }, getOUIAProps(Menu.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), props), children)));
    }
}
MenuBase.displayName = 'Menu';
MenuBase.contextType = MenuContext;
MenuBase.defaultProps = {
    ouiaSafe: true,
    isRootMenu: true,
    isPlain: false,
    isScrollable: false,
    role: 'menu'
};
const Menu = react.forwardRef((props, ref) => (react.createElement(MenuBase, Object.assign({}, props, { innerRef: ref }))));
Menu.displayName = 'Menu';
//# sourceMappingURL=Menu.js.map
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@patternfly+react-core@4.276.8_react-dom@17.0.2_react@17.0.2/node_modules/@patternfly/react-core/dist/esm/components/Menu/MenuContent.js





const MenuContent = react.forwardRef((props, ref) => {
    const { getHeight, children, menuHeight, maxMenuHeight } = props, rest = (0,tslib_es6.__rest)(props, ["getHeight", "children", "menuHeight", "maxMenuHeight"]);
    const menuContentRef = react.createRef();
    const refCallback = (el, menuId, onGetMenuHeight) => {
        if (el) {
            let clientHeight = el.clientHeight;
            // if this menu is a submenu, we need to account for the root menu list's padding and root menu content's border.
            let rootMenuList = null;
            let parentEl = el.closest(`.${menu/* default */.Z.menuList}`);
            while (parentEl !== null && parentEl.nodeType === 1) {
                if (parentEl.classList.contains(menu/* default */.Z.menuList)) {
                    rootMenuList = parentEl;
                }
                parentEl = parentEl.parentElement;
            }
            if (rootMenuList) {
                const rootMenuListStyles = getComputedStyle(rootMenuList);
                const rootMenuListPaddingOffset = parseFloat(rootMenuListStyles.getPropertyValue('padding-top').replace(/px/g, '')) +
                    parseFloat(rootMenuListStyles.getPropertyValue('padding-bottom').replace(/px/g, '')) +
                    parseFloat(getComputedStyle(rootMenuList.parentElement)
                        .getPropertyValue('border-bottom-width')
                        .replace(/px/g, ''));
                clientHeight = clientHeight + rootMenuListPaddingOffset;
            }
            onGetMenuHeight && onGetMenuHeight(menuId, clientHeight);
            getHeight && getHeight(clientHeight.toString());
        }
        return ref || menuContentRef;
    };
    return (react.createElement(MenuContext.Consumer, null, ({ menuId, onGetMenuHeight }) => (react.createElement("div", Object.assign({}