/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.kie.kogito.persistence.infinispan.QuarkusTestResourceWithCleanupLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public abstract class InfinispanServerTestResource
implements QuarkusTestResourceWithCleanupLifecycleManager {
    private static final String LOCALHOST = "127.0.0.1";
    private static final int PORT = 11232;
    private static final String SASL_DIGEST_MD5 = "DIGEST-MD5";
    private static final String SERVER_NAME_INFINISPAN = "infinispan";
    private static final String REALM_DEFAULT = "default";
    private static final String ADMIN = "admin";
    private static final String INFINISPAN_IMAGE = System.getProperty("container.image.infinispan");
    private static final Logger LOGGER = LoggerFactory.getLogger(InfinispanServerTestResource.class);
    private GenericContainer infinispan;
    private RemoteCacheManager cacheManager;

    public Map<String, String> start() {
        if (INFINISPAN_IMAGE == null) {
            LOGGER.warn("System property container.image.infinispan is not set. The test is started without the infinispan container.");
            return Collections.emptyMap();
        }
        LOGGER.info("Using Infinispan image: {}", (Object)INFINISPAN_IMAGE);
        this.infinispan = new FixedHostPortGenericContainer(INFINISPAN_IMAGE).withFixedExposedPort(11232, 11222).withReuse(false).withEnv("USER", ADMIN).withEnv("PASS", ADMIN).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forHttp((String)"/"));
        this.infinispan.start();
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
        this.infinispan.stop();
    }

    private RemoteCacheManager getCacheManager() {
        if (this.cacheManager == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.addServer().host(LOCALHOST).port(11232).security().authentication().username(ADMIN).password(ADMIN).realm(REALM_DEFAULT).serverName(SERVER_NAME_INFINISPAN).saslMechanism(SASL_DIGEST_MD5).clientIntelligence(ClientIntelligence.BASIC);
            this.cacheManager = new RemoteCacheManager(builder.build());
        }
        return this.cacheManager;
    }

    public abstract boolean shouldCleanCache(String var1);

    @Override
    public void cleanup() {
        if (!this.infinispan.isRunning()) {
            return;
        }
        for (String cacheName : this.getCacheManager().getCacheNames()) {
            if (!this.shouldCleanCache(cacheName)) continue;
            LOGGER.debug("Cleaning cache " + cacheName);
            this.getCacheManager().getCache(cacheName).clear();
        }
    }
}

