/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.infinispan.cache.InfinispanCacheManager;
import org.kie.kogito.persistence.infinispan.cache.InfinispanCacheShutdownObserver;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class InfinispanCacheShutdownObserverTest {
    StorageService nonInfinispanStorageService = (StorageService)Mockito.mock(StorageService.class);
    InfinispanCacheManager infinispanStorageService = (InfinispanCacheManager)Mockito.mock(InfinispanCacheManager.class);
    String nonInfinispanStorageType = "testStorage";
    InfinispanCacheShutdownObserver observer = new InfinispanCacheShutdownObserver();

    InfinispanCacheShutdownObserverTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.reset((Object[])new StorageService[]{this.nonInfinispanStorageService, this.infinispanStorageService});
    }

    @Test
    void testStop_nonInfinispanStorageType() {
        this.observer.cacheService = this.infinispanStorageService;
        this.observer.storageType = this.nonInfinispanStorageType;
        this.observer.stop(null);
        ((InfinispanCacheManager)Mockito.verify((Object)this.infinispanStorageService, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    void testStop_nonInfinispanStorageService() {
        this.observer.cacheService = this.nonInfinispanStorageService;
        this.observer.storageType = "infinispan";
        this.observer.stop(null);
        ((InfinispanCacheManager)Mockito.verify((Object)this.infinispanStorageService, (VerificationMode)Mockito.never())).destroy();
    }

    @Test
    void testStop_infinispanStorageService() {
        this.observer.cacheService = this.infinispanStorageService;
        this.observer.storageType = "infinispan";
        this.observer.stop(null);
        ((InfinispanCacheManager)Mockito.verify((Object)this.infinispanStorageService, (VerificationMode)Mockito.times((int)1))).destroy();
    }
}

