/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.client.hotrod.DefaultTemplate;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.infinispan.cache.InfinispanStorage;
import org.kie.kogito.testcontainers.quarkus.InfinispanQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=InfinispanQuarkusTestResource.class)
class InfinispanStorageIT {
    RemoteCache<String, String> cache;
    @Inject
    RemoteCacheManager remoteCacheManager;
    InfinispanStorage<String, String> storage;

    InfinispanStorageIT() {
    }

    @BeforeEach
    void setup() {
        this.cache = this.remoteCacheManager.administration().createCache("test", DefaultTemplate.LOCAL);
        this.storage = new InfinispanStorage(this.cache, String.class.getName());
    }

    @AfterEach
    void tearDown() {
        this.cache.clear();
        this.remoteCacheManager.administration().removeCache("test");
    }

    @Test
    void testContainsKey() {
        String key = "akey";
        String value = "avalue";
        this.cache.put((Object)key, (Object)value);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.storage.containsKey((Object)key));
    }

    @Test
    void testGet() {
        String key = "testGet";
        String value = "testValue";
        this.cache.put((Object)key, (Object)value);
        Assertions.assertThat((String)((String)this.storage.get((Object)key))).isEqualTo(value);
    }

    @Test
    void testPut() {
        String key = "testPut";
        String value = "testValue";
        this.storage.put((Object)key, (Object)value);
        Assertions.assertThat((String)((String)this.cache.get((Object)key))).isEqualTo(value);
    }

    @Test
    void testClear() {
        String key = "testClear";
        String value = "testValue";
        this.cache.put((Object)key, (Object)value);
        this.storage.clear();
        Assertions.assertThat((int)this.cache.size()).isZero();
    }

    @Test
    void testRemove() {
        String key = "testRemove";
        String value = "testValue";
        this.cache.put((Object)key, (Object)value);
        this.storage.remove((Object)key);
        Assertions.assertThat((int)this.cache.size()).isZero();
    }

    @Test
    void testObjectCreatedListener() throws Exception {
        CountDownLatch latch = new CountDownLatch(3);
        ArrayList values = new ArrayList();
        this.storage.objectCreatedListener().subscribe().with(v -> {
            values.add(v);
            latch.countDown();
        });
        this.storage.put((Object)"testKey_insert_1", (Object)"testValue1");
        this.storage.put((Object)"testKey_insert_2", (Object)"testValue2");
        this.storage.put((Object)"testKey_insert_3", (Object)"testValue3");
        latch.await(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(values).hasSize(3)).containsExactlyInAnyOrder((Object[])new String[]{"testValue3", "testValue2", "testValue1"});
    }

    @Test
    void testObjectUpdatedListener() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        ArrayList values = new ArrayList();
        this.storage.objectUpdatedListener().subscribe().with(v -> {
            values.add(v);
            latch.countDown();
        });
        this.storage.put((Object)"testKey_update_1", (Object)"testValue1");
        this.storage.put((Object)"testKey_update_1", (Object)"testValue2");
        this.storage.put((Object)"testKey_update_2", (Object)"testValue3");
        this.storage.put((Object)"testKey_update_2", (Object)"testValue4");
        latch.await(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(values).hasSize(2)).containsExactlyInAnyOrder((Object[])new String[]{"testValue2", "testValue4"});
    }

    @Test
    void testObjectRemovedListener() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        ArrayList values = new ArrayList();
        this.storage.objectRemovedListener().subscribe().with(v -> {
            values.add(v);
            latch.countDown();
        });
        this.storage.put((Object)"testKey_remove_1", (Object)"testValue1");
        this.storage.put((Object)"testKey_remove_2", (Object)"testValue2");
        this.storage.remove((Object)"testKey_remove_1");
        this.storage.remove((Object)"testKey_remove_2");
        latch.await(1L, TimeUnit.MINUTES);
        ((ListAssert)Assertions.assertThat(values).hasSize(2)).containsExactlyInAnyOrder((Object[])new String[]{"testKey_remove_1", "testKey_remove_2"});
    }
}

