/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.infinispan.query.InfinispanQuery;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InfinispanQueryTest {
    private static final String rootType = "org.kie.kogito.index.model.ProcessInstance";
    @Mock
    QueryFactory factory;
    @Mock
    Query mockQuery;
    @Mock
    QueryResult queryResult;

    InfinispanQueryTest() {
    }

    private static Stream<Arguments> provideFilters() {
        return Stream.of(Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.like((String)"name", (String)"test%")), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.name like 'test%'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.in((String)"id", Arrays.asList("8035b580-6ae4-4aa8-9ec0-e18e19809e0b", "a1e139d5-4e77-48c9-84ae-34578e904e5a"))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.id in ('8035b580-6ae4-4aa8-9ec0-e18e19809e0b', 'a1e139d5-4e77-48c9-84ae-34578e904e5a')"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.equalTo((String)"id", (Object)"8035b580-6ae4-4aa8-9ec0-e18e19809e0b")), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.id = '8035b580-6ae4-4aa8-9ec0-e18e19809e0b'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.contains((String)"name", (String)"test")), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.name = 'test'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.containsAll((String)"name", Arrays.asList("name1", "name2"))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.name = 'name1' and o.name = 'name2'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.containsAny((String)"name", Arrays.asList("name1", "name2"))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.name = 'name1' or o.name = 'name2'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.isNull((String)"name")), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.name is null"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.notNull((String)"name")), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.name is not null"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.between((String)"start", (Object)"2019-01-01", (Object)"2020-01-01")), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.start between '2019-01-01' and '2020-01-01'"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.greaterThan((String)"priority", (Object)1)), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.priority > 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.greaterThanEqual((String)"priority", (Object)1)), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.priority >= 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.lessThan((String)"priority", (Object)1)), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.priority < 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1)), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE o.priority <= 1"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE (o.priority <= 1 and o.priority > 1)"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE (o.priority <= 1 or o.priority > 1)"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.notNull((String)"name"), QueryFilterFactory.contains((String)"name", (String)"test"))), QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE (o.name is not null and o.name = 'test') and (o.priority <= 1 or o.priority > 1)"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.isNull((String)"name"), QueryFilterFactory.contains((String)"name", (String)"test"))), QueryFilterFactory.and(Arrays.asList(QueryFilterFactory.between((String)"start", (Object)"2019-01-01", (Object)"2020-01-01"), QueryFilterFactory.or(Arrays.asList(QueryFilterFactory.lessThanEqual((String)"priority", (Object)1), QueryFilterFactory.greaterThan((String)"priority", (Object)1)))))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE (o.name is null or o.name = 'test') and (o.start between '2019-01-01' and '2020-01-01' and (o.priority <= 1 or o.priority > 1))"}), Arguments.of((Object[])new Object[]{Arrays.asList(QueryFilterFactory.not((AttributeFilter)QueryFilterFactory.equalTo((String)"priority", (Object)1))), "FROM org.kie.kogito.index.model.ProcessInstance o WHERE not o.priority = 1"}));
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.factory.create((String)ArgumentMatchers.any())).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockQuery.execute()).thenReturn((Object)this.queryResult);
    }

    @Test
    void testNoParameters() {
        InfinispanQuery query = new InfinispanQuery(this.factory, rootType);
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("FROM org.kie.kogito.index.model.ProcessInstance o");
        ((QueryResult)Mockito.verify((Object)this.queryResult)).list();
    }

    @Test
    void testEmptyParameters() {
        InfinispanQuery query = new InfinispanQuery(this.factory, rootType);
        query.filter(Collections.emptyList());
        query.sort(Collections.emptyList());
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("FROM org.kie.kogito.index.model.ProcessInstance o");
        ((QueryResult)Mockito.verify((Object)this.queryResult)).list();
    }

    @Test
    void testPagination() {
        InfinispanQuery query = new InfinispanQuery(this.factory, rootType);
        query.limit(Integer.valueOf(10));
        query.offset(Integer.valueOf(0));
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("FROM org.kie.kogito.index.model.ProcessInstance o");
        ((Query)Mockito.verify((Object)this.mockQuery)).startOffset(0L);
        ((Query)Mockito.verify((Object)this.mockQuery)).maxResults(10);
        ((QueryResult)Mockito.verify((Object)this.queryResult)).list();
    }

    @Test
    void testOrderBy() {
        InfinispanQuery query = new InfinispanQuery(this.factory, rootType);
        query.sort(Arrays.asList(QueryFilterFactory.orderBy((String)"name", (SortDirection)SortDirection.DESC), QueryFilterFactory.orderBy((String)"date", (SortDirection)SortDirection.ASC)));
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create("FROM org.kie.kogito.index.model.ProcessInstance o ORDER BY o.name DESC, o.date ASC");
        ((QueryResult)Mockito.verify((Object)this.queryResult)).list();
    }

    @ParameterizedTest
    @MethodSource(value={"provideFilters"})
    void assertQueryFilters(List<AttributeFilter<?>> filters, String queryString) {
        InfinispanQuery query = new InfinispanQuery(this.factory, rootType);
        query.filter(filters);
        query.execute();
        ((QueryFactory)Mockito.verify((Object)this.factory)).create(queryString);
        ((QueryResult)Mockito.verify((Object)this.queryResult)).list();
    }
}

