/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.infinispan.cache;

import java.io.InputStream;
import java.util.Scanner;
import org.infinispan.commons.configuration.XMLStringConfiguration;

public class KogitoCacheDefaultConfiguration
extends XMLStringConfiguration {
    private static final String CACHE_CONFIG_PATH = "META-INF/kogito-cache-default.xml";
    private static final String CACHE_NAME_PLACEHOLDER = "${cache_name}";

    public KogitoCacheDefaultConfiguration(String cacheName) {
        super(KogitoCacheDefaultConfiguration.defaultCacheTemplate(cacheName));
    }

    private static final String defaultCacheTemplate(String cacheName) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CACHE_CONFIG_PATH);
        if (is == null) {
            throw new IllegalArgumentException(String.format("Cache configuration file %s not found", CACHE_CONFIG_PATH));
        }
        try (Scanner s = new Scanner(is);){
            s.useDelimiter("\\A");
            String xmlCacheConfig = s.hasNext() ? s.next() : "";
            String string = xmlCacheConfig.replace(CACHE_NAME_PLACEHOLDER, cacheName);
            return string;
        }
    }
}

