/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import javax.enterprise.event.Event;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.api.proto.DomainModelRegisteredEvent;
import org.kie.kogito.persistence.protobuf.FileDescriptorRegisteredEvent;
import org.kie.kogito.persistence.protobuf.TestUtils;
import org.kie.kogito.persistence.protobuf.domain.ProtoDomainModelProducer;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ProtoDomainModelProducerTest {
    @Mock
    Event<DomainModelRegisteredEvent> domainEvent;
    @InjectMocks
    ProtoDomainModelProducer protoDomainModelProducer;

    ProtoDomainModelProducerTest() {
    }

    @Test
    void onFileDescriptorRegistered() {
        FileDescriptor fileDescriptor = ProtoDomainModelProducerTest.getTestFileDescriptor();
        FileDescriptorRegisteredEvent event = new FileDescriptorRegisteredEvent(fileDescriptor);
        this.protoDomainModelProducer.onFileDescriptorRegistered(event);
        ((Event)Mockito.verify(this.domainEvent)).fire((Object)((DomainModelRegisteredEvent)ArgumentMatchers.eq((Object)new DomainModelRegisteredEvent("travels", TestUtils.DOMAIN_DESCRIPTOR, TestUtils.ADDITIONAL_DESCRIPTORS))));
    }

    static FileDescriptor getTestFileDescriptor() {
        String content = TestUtils.getTestFileContent();
        SerializationContextImpl ctx = new SerializationContextImpl(Configuration.builder().build());
        ctx.registerProtoFiles(FileDescriptorSource.fromString((String)"domainModel", (String)content));
        return (FileDescriptor)ctx.getFileDescriptors().get("domainModel");
    }
}

