/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.persistence.api.proto.DomainDescriptor;
import org.kie.kogito.persistence.api.schema.AttributeDescriptor;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.api.schema.IndexDescriptor;

public class TestUtils {
    static final String PROCESS_ID = "travels";
    static final String PROCESS_TYPE = "org.acme.travels.travels.Travels";
    static final DomainDescriptor DOMAIN_DESCRIPTOR = new DomainDescriptor();
    static final List<DomainDescriptor> ADDITIONAL_DESCRIPTORS;

    static FileDescriptor getTestFileDescriptor() {
        String content = TestUtils.getTestFileContent();
        SerializationContextImpl ctx = new SerializationContextImpl(Configuration.builder().build());
        ctx.registerProtoFiles(FileDescriptorSource.fromString((String)"domainModel", (String)content));
        return (FileDescriptor)ctx.getFileDescriptors().get("domainModel");
    }

    static String getTestFileContent() {
        return TestUtils.getTestFileContent("test.proto");
    }

    static String getTestFileInvalidContent() {
        return TestUtils.getTestFileContent("test_invalid.proto");
    }

    static String getTestFileContent(String protofile) {
        try {
            Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(protofile).toURI());
            return new String(Files.readAllBytes(path));
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    static Map<String, EntityIndexDescriptor> getValidEntityIndexDescriptors(boolean includeUnindexedAttribute) {
        AttributeDescriptor flightNumber = new AttributeDescriptor("flightNumber", "string", true);
        EntityIndexDescriptor flightEntityIndexDescriptor = new EntityIndexDescriptor("org.acme.travels.travels.Flight", Collections.emptyList(), List.of(flightNumber));
        AttributeDescriptor hotelName = new AttributeDescriptor("name", "string", true);
        AttributeDescriptor hotelRoom = new AttributeDescriptor("room", "string", true);
        EntityIndexDescriptor hotelEntityIndexDescriptor = new EntityIndexDescriptor("org.acme.travels.travels.Hotel", Collections.emptyList(), includeUnindexedAttribute ? List.of(hotelName, hotelRoom) : List.of(hotelName));
        AttributeDescriptor flight = new AttributeDescriptor("flight", "Flight", false);
        AttributeDescriptor hotel = new AttributeDescriptor("hotel", "Hotel", false);
        AttributeDescriptor id = new AttributeDescriptor("id", "string", true);
        AttributeDescriptor metadata = new AttributeDescriptor("metadata", "string", true);
        IndexDescriptor idIndex = new IndexDescriptor("id", List.of("id"));
        EntityIndexDescriptor travelEntityIndexDescriptor = new EntityIndexDescriptor(PROCESS_TYPE, List.of(idIndex), List.of(flight, hotel, id, metadata));
        HashMap<String, EntityIndexDescriptor> entityIndexDescriptorMap = new HashMap<String, EntityIndexDescriptor>();
        entityIndexDescriptorMap.put(flightEntityIndexDescriptor.getName(), flightEntityIndexDescriptor);
        entityIndexDescriptorMap.put(hotelEntityIndexDescriptor.getName(), hotelEntityIndexDescriptor);
        entityIndexDescriptorMap.put(travelEntityIndexDescriptor.getName(), travelEntityIndexDescriptor);
        return entityIndexDescriptorMap;
    }

    static {
        DOMAIN_DESCRIPTOR.setTypeName(PROCESS_TYPE);
        DOMAIN_DESCRIPTOR.setAttributes(List.of(new org.kie.kogito.persistence.api.proto.AttributeDescriptor("flight", "org.acme.travels.travels.Flight"), new org.kie.kogito.persistence.api.proto.AttributeDescriptor("hotel", "org.acme.travels.travels.Hotel"), new org.kie.kogito.persistence.api.proto.AttributeDescriptor("id", "java.lang.String"), new org.kie.kogito.persistence.api.proto.AttributeDescriptor("metadata", "java.lang.String")));
        DomainDescriptor flight = new DomainDescriptor();
        flight.setTypeName("org.acme.travels.travels.Flight");
        flight.setAttributes(List.of(new org.kie.kogito.persistence.api.proto.AttributeDescriptor("flightNumber", "java.lang.String")));
        DomainDescriptor hotel = new DomainDescriptor();
        hotel.setTypeName("org.acme.travels.travels.Hotel");
        hotel.setAttributes(List.of(new org.kie.kogito.persistence.api.proto.AttributeDescriptor("name", "java.lang.String"), new org.kie.kogito.persistence.api.proto.AttributeDescriptor("room", "java.lang.String")));
        ADDITIONAL_DESCRIPTORS = List.of(flight, hotel);
    }
}

