/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.protobuf.ProtobufMonitorService;
import org.kie.kogito.persistence.protobuf.ProtobufService;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ProtobufMonitorServiceTest {
    @Mock
    ProtobufService protobufService;
    @InjectMocks
    ProtobufMonitorService protobufMonitorService;

    ProtobufMonitorServiceTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLoadingAndUpdatingFiles() throws Exception {
        Path dir = null;
        try {
            dir = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
            Path sub = Files.createDirectory(dir.resolve("proto"), new FileAttribute[0]);
            Files.createFile(dir.resolve("kogito-application.proto"), new FileAttribute[0]);
            Path file1 = Files.createFile(dir.resolve("test1.proto"), new FileAttribute[0]);
            Path file2 = Files.createFile(sub.resolve("test2.proto"), new FileAttribute[0]);
            CountDownLatch latch = new CountDownLatch(4);
            ((ProtobufService)Mockito.doAnswer(args -> {
                latch.countDown();
                return null;
            }).when((Object)this.protobufService)).registerProtoBufferType((String)ArgumentMatchers.any());
            this.protobufMonitorService.monitor = true;
            this.protobufMonitorService.protoFiles = Optional.of(dir.toAbsolutePath().toString());
            this.protobufMonitorService.onFolderWatch = path -> {
                try {
                    Files.write(file2, "test".getBytes(), new OpenOption[0]);
                    Files.write(file1, "test".getBytes(), new OpenOption[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            this.protobufMonitorService.startMonitoring();
            latch.await(1L, TimeUnit.MINUTES);
            Assertions.assertEquals((long)0L, (long)latch.getCount());
        }
        finally {
            if (dir != null) {
                try {
                    Files.deleteIfExists(dir);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testAddingSubFolderAfterStart() throws Exception {
        Path dir = null;
        try {
            dir = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
            Files.createFile(dir.resolve("kogito-application.proto"), new FileAttribute[0]);
            Files.createFile(dir.resolve("test1.proto"), new FileAttribute[0]);
            CountDownLatch latch = new CountDownLatch(2);
            Path proto = dir.resolve("proto");
            ((ProtobufService)Mockito.doAnswer(args -> {
                latch.countDown();
                return null;
            }).when((Object)this.protobufService)).registerProtoBufferType((String)ArgumentMatchers.any());
            this.protobufMonitorService.monitor = true;
            this.protobufMonitorService.protoFiles = Optional.of(dir.toAbsolutePath().toString());
            this.protobufMonitorService.onFolderWatch = path -> {
                try {
                    Path sub = Files.createDirectory(proto, new FileAttribute[0]);
                    Files.createFile(sub.resolve("test2.txt"), new FileAttribute[0]);
                    Files.createFile(sub.resolve("test2.proto"), new FileAttribute[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            };
            this.protobufMonitorService.startMonitoring();
            latch.await(1L, TimeUnit.MINUTES);
            Assertions.assertEquals((long)0L, (long)latch.getCount());
        }
        finally {
            if (dir != null) {
                try {
                    Files.deleteIfExists(dir);
                }
                catch (IOException iOException) {}
            }
        }
    }
}

