/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.kogito.quarkus.example;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.kie.pmml.kogito.quarkus.example.CommonTestUtils;

@QuarkusTest
class MiningModelTest {
    private static final String BASE_PATH = "/PredicatesMining";
    private static final String TARGET = "categoricalResult";

    MiningModelTest() {
    }

    @Test
    void testEvaluatePredicatesMiningResult() {
        String inputData = "{\"residenceState\":\"AP\", \"validLicense\":true, \"occupation\":\"ASTRONAUT\", \"categoricalY\":\"classA\", \"categoricalX\":\"red\", \"variable\":6.6, \"age\":25.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, Float.valueOf(1.3816667f));
    }

    @Test
    void testEvaluatePredicatesMiningDescriptive() {
        String inputData = "{\"residenceState\":\"AP\", \"validLicense\":true, \"occupation\":\"ASTRONAUT\", \"categoricalY\":\"classA\", \"categoricalX\":\"red\", \"variable\":6.6, \"age\":25.0}";
        Map<String, Object> expectedResultMap = Collections.singletonMap(TARGET, Float.valueOf(1.3816667f));
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }
}

