/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.kogito.quarkus.example;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import java.util.HashMap;
import org.junit.jupiter.api.Test;
import org.kie.pmml.kogito.quarkus.example.CommonTestUtils;

@QuarkusTest
class SampleMineTest {
    private static final String BASE_PATH = "/SampleMine";
    private static final String TARGET = "decision";

    SampleMineTest() {
    }

    @Test
    void testEvaluateSampleMineResult() {
        String inputData = "{\"temperature\":30.0, \"humidity\":10.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, "sunglasses");
    }

    @Test
    void testEvaluateSampleMineDescriptive() {
        String inputData = "{\"temperature\":30.0, \"humidity\":10.0}";
        HashMap<String, Object> expectedResultMap = new HashMap<String, Object>();
        expectedResultMap.put(TARGET, "sunglasses");
        expectedResultMap.put("weatherdecision", "sunglasses");
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

