/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.kogito.quarkus.example;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import org.junit.jupiter.api.Test;
import org.kie.pmml.kogito.quarkus.example.CommonTestUtils;

@QuarkusTest
class SimpleScorecardTest {
    private static final String BASE_PATH = "/SimpleScorecard";
    private static final String TARGET = "score";

    SimpleScorecardTest() {
    }

    @Test
    void testEvaluateSimpleScorecardResult() {
        String inputData = "{\"input1\":5.0, \"input2\":-10.0}";
        CommonTestUtils.testResult(inputData, BASE_PATH, TARGET, Float.valueOf(-15.0f));
    }

    @Test
    void testEvaluateSimpleScorecardDescriptive() {
        String inputData = "{\"input1\":5.0, \"input2\":-10.0}";
        HashMap<String, Object> expectedResultMap = new HashMap<String, Object>();
        expectedResultMap.put(TARGET, Float.valueOf(-15.0f));
        expectedResultMap.put("Reason Code 1", "Input1ReasonCode");
        expectedResultMap.put("Reason Code 2", "Input2ReasonCode");
        CommonTestUtils.testDescriptive(inputData, BASE_PATH, TARGET, expectedResultMap);
    }
}

