/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.HashMap;
import java.util.List;
import org.acme.travels.Person;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.tests.KogitoInfinispanSpringbootApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoInfinispanSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class PersonsProcessTest {
    @Autowired
    @Qualifier(value="persons")
    Process<? extends Model> personProcess;

    @Test
    public void testAdult() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("John Doe", 20));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assert.assertEquals((long)2L, (long)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assert.assertEquals((long)1L, (long)result.toMap().size());
        Assert.assertTrue((boolean)((Person)result.toMap().get("person")).isAdult());
    }

    @Test
    public void testChild() {
        Model m = (Model)this.personProcess.createModel();
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("Jenny Quark", 14));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.personProcess.createInstance(m);
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assert.assertEquals((long)1L, (long)result.toMap().size());
        Assert.assertFalse((boolean)((Person)result.toMap().get("person")).isAdult());
        List workItems = processInstance.workItems(new Policy[0]);
        Assert.assertEquals((long)1L, (long)workItems.size());
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), null, new Policy[0]);
        Assert.assertEquals((long)2L, (long)processInstance.status());
    }
}

