/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

@Path(value="/management/processes")
public class ProcessInstanceManagementResource {
    @Inject
    Processes processes;
    @Inject
    Application application;
    private static final String PROCESS_AND_INSTANCE_REQUIRED = "Process id and Process instance id must be given";
    private static final String PROCESS_NOT_FOUND = "Process with id %s not found";
    private static final String PROCESS_INSTANCE_NOT_FOUND = "Process instance with id %s not found";
    private static final String PROCESS_INSTANCE_NOT_IN_ERROR = "Process instance with id %s is not in error state";

    @GET
    @Path(value="{processId}/instances/{processInstanceId}/error")
    @Produces(value={"application/json"})
    public Response getInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ProcessError error = (ProcessError)processInstance.error().get();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", processInstance.id());
            data.put("failedNodeId", error.failedNodeId());
            data.put("message", error.errorMessage());
            return Response.status((Response.Status)Response.Status.OK).entity(data).build();
        });
    }

    @GET
    @Path(value="{processId}/instances/{processInstanceId}/nodeInstances")
    @Produces(value={"application/json"})
    public Response getWorkItemsInProcessInstance(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstance(processId, processInstanceId, processInstance -> {
            List workItems = processInstance.workItems(new Policy[0]);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)workItems).build();
        });
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/retrigger")
    @Produces(value={"application/json"})
    public Response retriggerInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessError)processInstance.error().get()).retrigger();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/skip")
    @Produces(value={"application/json"})
    public Response skipInstanceInError(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessError)processInstance.error().get()).skip();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/nodes/{nodeId}")
    @Produces(value={"application/json"})
    public Response triggerNodeInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="nodeId") String nodeId) {
        return this.executeOnInstance(processId, processInstanceId, processInstance -> {
            processInstance.triggerNode(nodeId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    @POST
    @Path(value="{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}")
    @Produces(value={"application/json"})
    public Response retriggerNodeInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="nodeInstanceId") String nodeInstanceId) {
        return this.executeOnInstance(processId, processInstanceId, processInstance -> {
            processInstance.retriggerNodeInstance(nodeInstanceId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    @DELETE
    @Path(value="{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}")
    @Produces(value={"application/json"})
    public Response cancelNodeInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId, @PathParam(value="nodeInstanceId") String nodeInstanceId) {
        return this.executeOnInstance(processId, processInstanceId, processInstance -> {
            processInstance.cancelNodeInstance(nodeInstanceId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    @DELETE
    @Path(value="{processId}/instances/{processInstanceId}")
    @Produces(value={"application/json"})
    public Response cancelProcessInstanceId(@PathParam(value="processId") String processId, @PathParam(value="processInstanceId") String processInstanceId) {
        return this.executeOnInstance(processId, processInstanceId, processInstance -> {
            processInstance.abort();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return Response.status((Response.Status)Response.Status.OK).entity(processInstance.variables()).build();
        });
    }

    protected Response executeOnInstanceInError(String processId, String processInstanceId, Function<ProcessInstance<?>, Response> supplier) {
        if (processId == null || processInstanceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)PROCESS_AND_INSTANCE_REQUIRED).build();
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format(PROCESS_NOT_FOUND, processId)).build();
        }
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId);
            if (processInstanceFound.isPresent()) {
                ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                if (processInstance.error().isPresent()) {
                    return (Response)supplier.apply(processInstance);
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format(PROCESS_INSTANCE_NOT_IN_ERROR, processInstanceId)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format(PROCESS_INSTANCE_NOT_FOUND, processInstanceId)).build();
        });
    }

    protected Response executeOnInstance(String processId, String processInstanceId, Function<ProcessInstance<?>, Response> supplier) {
        if (processId == null || processInstanceId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)PROCESS_AND_INSTANCE_REQUIRED).build();
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format(PROCESS_NOT_FOUND, processId)).build();
        }
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId);
            if (processInstanceFound.isPresent()) {
                ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                return (Response)supplier.apply(processInstance);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format(PROCESS_INSTANCE_NOT_FOUND, processInstanceId)).build();
        });
    }
}

