/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.management.ProcessInstanceManagementResource;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ProcessInstanceManagementResourceTest {
    private static RuntimeDelegate runtimeDelegate;
    private Response.ResponseBuilder responseBuilder;
    private Processes processes;
    private ProcessInstance processInstance;
    private ProcessError error;
    private Application application;

    @BeforeAll
    public static void configureEnvironment() {
        runtimeDelegate = (RuntimeDelegate)Mockito.mock(RuntimeDelegate.class);
        RuntimeDelegate.setInstance((RuntimeDelegate)runtimeDelegate);
    }

    @BeforeEach
    public void setup() {
        this.responseBuilder = (Response.ResponseBuilder)Mockito.mock(Response.ResponseBuilder.class);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)runtimeDelegate.createResponseBuilder()).thenReturn((Object)this.responseBuilder);
        Mockito.when((Object)this.responseBuilder.status((Response.StatusType)Matchers.any(Response.StatusType.class))).thenReturn((Object)this.responseBuilder);
        Mockito.when((Object)this.responseBuilder.entity(Matchers.any())).thenReturn((Object)this.responseBuilder);
        Mockito.when((Object)this.responseBuilder.build()).thenReturn((Object)response);
        this.application = (Application)Mockito.mock(Application.class);
        this.processes = (Processes)Mockito.mock(Processes.class);
        Process process = (Process)Mockito.mock(Process.class);
        ProcessInstances instances = (ProcessInstances)Mockito.mock(ProcessInstances.class);
        this.processInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        this.error = (ProcessError)Mockito.mock(ProcessError.class);
        Mockito.when((Object)this.processes.processById(Matchers.anyString())).thenReturn((Object)process);
        Mockito.when((Object)process.instances()).thenReturn((Object)instances);
        Mockito.when((Object)instances.findById(Matchers.anyString())).thenReturn(Optional.of(this.processInstance));
        Mockito.when((Object)this.processInstance.error()).thenReturn(Optional.of(this.error));
        Mockito.when((Object)this.processInstance.id()).thenReturn((Object)"abc-def");
        Mockito.when((Object)this.processInstance.status()).thenReturn((Object)5);
        Mockito.when((Object)this.error.failedNodeId()).thenReturn((Object)"xxxxx");
        Mockito.when((Object)this.error.errorMessage()).thenReturn((Object)"Test error message");
        Mockito.when((Object)this.application.unitOfWorkManager()).thenReturn((Object)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
    }

    @Test
    public void testGetErrorInfo() {
        ProcessInstanceManagementResource resource = new ProcessInstanceManagementResource();
        resource.processes = this.processes;
        resource.application = this.application;
        Response response = resource.getInstanceInError("test", "xxxxx");
        Assertions.assertThat((Object)response).isNotNull();
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).status((Response.StatusType)Response.Status.OK);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).entity(Matchers.any());
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).skip();
    }

    @Test
    public void testRetriggerErrorInfo() {
        ProcessInstanceManagementResource resource = new ProcessInstanceManagementResource();
        resource.processes = this.processes;
        resource.application = this.application;
        ((ProcessError)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Mockito.when((Object)ProcessInstanceManagementResourceTest.this.processInstance.status()).thenReturn((Object)1);
                return null;
            }
        }).when((Object)this.error)).retrigger();
        Response response = resource.retriggerInstanceInError("test", "xxxxx");
        Assertions.assertThat((Object)response).isNotNull();
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).status((Response.StatusType)Response.Status.OK);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).entity(Matchers.any());
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)1))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).skip();
    }

    @Test
    public void testSkipErrorInfo() {
        ProcessInstanceManagementResource resource = new ProcessInstanceManagementResource();
        resource.processes = this.processes;
        resource.application = this.application;
        ((ProcessError)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Mockito.when((Object)ProcessInstanceManagementResourceTest.this.processInstance.status()).thenReturn((Object)1);
                return null;
            }
        }).when((Object)this.error)).skip();
        Response response = resource.skipInstanceInError("test", "xxxxx");
        Assertions.assertThat((Object)response).isNotNull();
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).status((Response.StatusType)Response.Status.OK);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).entity(Matchers.any());
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)1))).skip();
    }
}

