/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.management.ProcessInstanceManagementResource;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class ProcessInstanceManagementResourceTest {
    public static final String MESSAGE = "message";
    public static final String PROCESS_ID = "test";
    public static final String PROCESS_INSTANCE_ID = "xxxxx";
    public static final String NODE_ID = "abc-def";
    private static RuntimeDelegate runtimeDelegate;
    private Response.ResponseBuilder responseBuilder;
    private Processes processes;
    private ProcessInstance processInstance;
    private ProcessError error;
    private Application application;
    private ProcessInstanceManagementResource resource;

    @BeforeAll
    public static void configureEnvironment() {
        runtimeDelegate = (RuntimeDelegate)Mockito.mock(RuntimeDelegate.class);
        RuntimeDelegate.setInstance((RuntimeDelegate)runtimeDelegate);
    }

    @BeforeEach
    public void setup() {
        this.responseBuilder = (Response.ResponseBuilder)Mockito.mock(Response.ResponseBuilder.class);
        Response response = (Response)Mockito.mock(Response.class);
        Mockito.when((Object)runtimeDelegate.createResponseBuilder()).thenReturn((Object)this.responseBuilder);
        Mockito.lenient().when((Object)this.responseBuilder.status((Response.StatusType)Matchers.any(Response.StatusType.class))).thenReturn((Object)this.responseBuilder);
        Mockito.lenient().when((Object)this.responseBuilder.entity(Matchers.any())).thenReturn((Object)this.responseBuilder);
        Mockito.lenient().when((Object)this.responseBuilder.build()).thenReturn((Object)response);
        this.application = (Application)Mockito.mock(Application.class);
        this.processes = (Processes)Mockito.mock(Processes.class);
        Process process = (Process)Mockito.mock(Process.class);
        ProcessInstances instances = (ProcessInstances)Mockito.mock(ProcessInstances.class);
        this.processInstance = (ProcessInstance)Mockito.mock(ProcessInstance.class);
        this.error = (ProcessError)Mockito.mock(ProcessError.class);
        Mockito.lenient().when((Object)this.processes.processById(Matchers.anyString())).thenReturn((Object)process);
        Mockito.lenient().when((Object)process.instances()).thenReturn((Object)instances);
        Mockito.lenient().when((Object)instances.findById(Matchers.anyString())).thenReturn(Optional.of(this.processInstance));
        Mockito.lenient().when((Object)this.processInstance.error()).thenReturn(Optional.of(this.error));
        Mockito.lenient().when((Object)this.processInstance.id()).thenReturn((Object)NODE_ID);
        Mockito.lenient().when((Object)this.processInstance.status()).thenReturn((Object)1);
        Mockito.lenient().when((Object)this.error.failedNodeId()).thenReturn((Object)PROCESS_INSTANCE_ID);
        Mockito.lenient().when((Object)this.error.errorMessage()).thenReturn((Object)"Test error message");
        Mockito.lenient().when((Object)this.application.unitOfWorkManager()).thenReturn((Object)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.resource = (ProcessInstanceManagementResource)Mockito.spy((Object)new ProcessInstanceManagementResource(this.processes, this.application));
    }

    @Test
    public void testGetErrorInfo() {
        Response response = this.resource.getInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
        Assertions.assertThat((Object)response).isNotNull();
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).status((Response.StatusType)Response.Status.OK);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).entity(Matchers.any());
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).skip();
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doGetInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
    }

    @Test
    public void testRetriggerErrorInfo() {
        ((ProcessError)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Mockito.when((Object)ProcessInstanceManagementResourceTest.this.processInstance.status()).thenReturn((Object)1);
                return null;
            }
        }).when((Object)this.error)).retrigger();
        Response response = this.resource.retriggerInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
        Assertions.assertThat((Object)response).isNotNull();
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).status((Response.StatusType)Response.Status.OK);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder, (VerificationMode)Mockito.times((int)1))).entity(Matchers.any());
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)1))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).skip();
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doRetriggerInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
    }

    @Test
    public void testGetWorkItemsInProcessInstance() {
        this.resource.getWorkItemsInProcessInstance(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doGetWorkItemsInProcessInstance(PROCESS_ID, PROCESS_INSTANCE_ID);
    }

    @Test
    public void testSkipInstanceInError() {
        this.resource.skipInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doSkipInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
    }

    @Test
    public void testTriggerNodeInstanceId() {
        this.resource.triggerNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doTriggerNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
    }

    @Test
    public void testRetriggerNodeInstanceId() {
        this.resource.retriggerNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doRetriggerNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
    }

    @Test
    public void testCancelNodeInstanceId() {
        this.resource.cancelNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doCancelNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
    }

    @Test
    public void testCancelProcessInstanceId() {
        this.resource.cancelProcessInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstanceManagementResource)Mockito.verify((Object)this.resource)).doCancelProcessInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID);
    }

    @Test
    public void testBubildOkResponse(@Mock Object body) {
        Response response = this.resource.buildOkResponse(body);
        this.assertResponse(body, Response.Status.OK);
    }

    public void assertResponse(Object body, Response.Status status) {
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder)).status((Response.StatusType)status);
        ((Response.ResponseBuilder)Mockito.verify((Object)this.responseBuilder)).entity(body);
    }

    @Test
    public void testBadRequestResponse() {
        Response response = this.resource.badRequestResponse(MESSAGE);
        this.assertResponse(MESSAGE, Response.Status.BAD_REQUEST);
    }

    @Test
    public void testNotFoundResponse() {
        Response response = this.resource.notFoundResponse(MESSAGE);
        this.assertResponse(MESSAGE, Response.Status.NOT_FOUND);
    }
}

