/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.context.variable.Variable;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.MarshallerReaderContext;
import org.kie.kogito.serialization.process.MarshallerWriterContext;
import org.kie.kogito.serialization.process.ObjectMarshallerStrategy;
import org.kie.kogito.serialization.process.impl.ProtobufMarshallerReaderContext;
import org.kie.kogito.serialization.process.impl.ProtobufProcessMarshallerWriteContext;
import org.kie.kogito.serialization.process.impl.ProtobufVariableReader;
import org.kie.kogito.serialization.process.impl.ProtobufVariableWriter;

public class ProcessInstanceMarshallTest {
    @Test
    public void testRoundtripIntVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("integer", 1);
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripStringVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("string", "hello");
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripBoolVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("bool", Boolean.TRUE);
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripFloatVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("float", Float.valueOf(2.0f));
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripDoubleVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("double", 3.0);
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripDateVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("date", new Date());
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripTimestampVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("timestamp", new Timestamp(System.currentTimeMillis()));
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripLongVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("long", 5L);
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripCustomObjectVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("object", new MarshableObject("henry"));
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    @Test
    public void testRoundtripNullVarMarshaller() {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("object", null);
        Map<String, Object> out = this.roundtrip(in);
        Assertions.assertThat(in).isEqualTo(out);
    }

    private Map<String, Object> roundtrip(Map<String, Object> toMarshall) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ProtobufProcessMarshallerWriteContext ctxOut = new ProtobufProcessMarshallerWriteContext((OutputStream)out);
        ctxOut.set(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES, (Object)this.defaultStrategies());
        ProtobufVariableWriter writer = new ProtobufVariableWriter((MarshallerWriterContext)ctxOut);
        List variables = writer.buildVariables(toMarshall.entrySet().stream().collect(Collectors.toList()));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ProtobufMarshallerReaderContext ctxIn = new ProtobufMarshallerReaderContext((InputStream)in);
        ctxIn.set(MarshallerContextName.OBJECT_MARSHALLING_STRATEGIES, (Object)this.defaultStrategies());
        ProtobufVariableReader reader = new ProtobufVariableReader((MarshallerReaderContext)ctxIn);
        List unmarshalledVars = reader.buildVariables(variables);
        HashMap<String, Object> outcome = new HashMap<String, Object>();
        for (Variable var : unmarshalledVars) {
            outcome.put(var.getName(), var.getValue());
        }
        return outcome;
    }

    private ObjectMarshallerStrategy[] defaultStrategies() {
        ArrayList<ObjectMarshallerStrategy> strats = new ArrayList<ObjectMarshallerStrategy>();
        ServiceLoader<ObjectMarshallerStrategy> loader = ServiceLoader.load(ObjectMarshallerStrategy.class);
        for (ObjectMarshallerStrategy strategy : loader) {
            strats.add(strategy);
        }
        Collections.sort(strats);
        return (ObjectMarshallerStrategy[])strats.stream().toArray(ObjectMarshallerStrategy[]::new);
    }

    public static class MarshableObject
    implements Serializable {
        private static final long serialVersionUID = 1481370154514125687L;
        private String name;

        public MarshableObject() {
        }

        public MarshableObject(String name) {
            this.name = name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MarshableObject) {
                return this.name.equals(((MarshableObject)obj).name);
            }
            return false;
        }
    }
}

