/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serialization.process.protobuf;

import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serialization.process.protobuf.ProtostreamProtobufAdapterTypeProvider;

public class ProtostreamProtobufAdapterTypeProviderTest {
    List<String> msgDescriptors = Arrays.asList("kogito.String", "kogito.Integer", "kogito.Long", "kogito.Double", "kogito.Float", "kogito.Boolean", "kogito.Date", "org.kie.kogito.app.Address", "org.kie.kogito.app.Traveller");

    @Test
    public void testSuccessConversionProtostreamToProtobuf() {
        ProtostreamProtobufAdapterTypeProvider prov = new ProtostreamProtobufAdapterTypeProvider();
        Collection descriptors = prov.descriptors();
        Assertions.assertThat(descriptors.stream().map(Descriptors.Descriptor::getFullName)).hasSameElementsAs(this.msgDescriptors);
    }

    @Test
    public void testFileDescriptorSortWithKogitoFirstInOrigList() {
        ProtostreamProtobufAdapterTypeProvider prov = new ProtostreamProtobufAdapterTypeProvider();
        FileDescriptor fd1 = new FileDescriptor.Builder().withPackageName("kogito").build();
        FileDescriptor fd2 = new FileDescriptor.Builder().withPackageName("org.kie.kogito.app").build();
        List<FileDescriptor> fdCollectionKogitoOrder1 = Arrays.asList(fd1, fd2);
        List fdCollectionSorted = prov.sortFds(fdCollectionKogitoOrder1);
        Assertions.assertThat((List)fdCollectionSorted).hasSameElementsAs(fdCollectionKogitoOrder1);
        Assertions.assertThat((Object)((FileDescriptor)fdCollectionSorted.get(0))).isEqualTo((Object)fd1);
    }

    @Test
    public void testFileDescriptorSortWithKogitoLastInOrigList() {
        ProtostreamProtobufAdapterTypeProvider prov = new ProtostreamProtobufAdapterTypeProvider();
        FileDescriptor fd1 = new FileDescriptor.Builder().withPackageName("kogito").build();
        FileDescriptor fd2 = new FileDescriptor.Builder().withPackageName("org.kie.kogito.app").build();
        List<FileDescriptor> fdCollectionKogitoOrder2 = Arrays.asList(fd2, fd1);
        List fdCollectionSorted2 = prov.sortFds(fdCollectionKogitoOrder2);
        Assertions.assertThat((List)fdCollectionSorted2).hasSameElementsAs(fdCollectionKogitoOrder2);
        Assertions.assertThat((Object)((FileDescriptor)fdCollectionSorted2.get(0))).isEqualTo((Object)fd1);
    }
}

