/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.util.StringUtils;
import org.jbpm.marshalling.impl.ProcessInstanceMarshaller;
import org.jbpm.process.core.Context;
import org.jbpm.process.instance.ContextInstance;
import org.jbpm.process.instance.context.exclusive.ExclusiveGroupInstance;
import org.jbpm.process.instance.context.swimlane.SwimlaneContextInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.EventNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.jbpm.workflow.instance.node.JoinInstance;
import org.jbpm.workflow.instance.node.MilestoneNodeInstance;
import org.jbpm.workflow.instance.node.RuleSetNodeInstance;
import org.jbpm.workflow.instance.node.StateNodeInstance;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.jbpm.workflow.instance.node.TimerNodeInstance;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.definition.process.Process;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.NodeInstanceContainer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;

public abstract class AbstractProcessInstanceMarshaller
implements ProcessInstanceMarshaller {
    @Override
    public Object writeProcessInstance(MarshallerWriteContext context, ProcessInstance processInstance) throws IOException {
        WorkflowProcessInstanceImpl workFlow = (WorkflowProcessInstanceImpl)processInstance;
        ObjectOutputStream stream = (ObjectOutputStream)context;
        stream.writeUTF(workFlow.getStringId());
        stream.writeUTF(workFlow.getProcessId());
        stream.writeInt(workFlow.getState());
        SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)workFlow.getContextInstance("SwimlaneScope");
        if (swimlaneContextInstance != null) {
            Map swimlaneActors = swimlaneContextInstance.getSwimlaneActors();
            stream.writeInt(swimlaneActors.size());
            for (Map.Entry entry : swimlaneActors.entrySet()) {
                stream.writeUTF((String)entry.getKey());
                stream.writeUTF((String)entry.getValue());
            }
        } else {
            stream.writeInt(0);
        }
        ArrayList nodeInstances = new ArrayList(workFlow.getNodeInstances());
        Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

            @Override
            public int compare(NodeInstance o1, NodeInstance o2) {
                return ((KogitoNodeInstance)o1).getStringId().compareTo(((KogitoNodeInstance)o2).getStringId());
            }
        });
        for (Object nodeInstance : nodeInstances) {
            stream.writeShort(18);
            this.writeNodeInstance(context, (NodeInstance)nodeInstance);
        }
        stream.writeShort(1);
        List exclusiveGroupInstances = workFlow.getContextInstances("ExclusiveGroup");
        if (exclusiveGroupInstances == null) {
            stream.writeInt(0);
        } else {
            stream.writeInt(exclusiveGroupInstances.size());
            for (ContextInstance contextInstance : exclusiveGroupInstances) {
                ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                Collection groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                stream.writeInt(groupNodeInstances.size());
                for (KogitoNodeInstance nodeInstance : groupNodeInstances) {
                    stream.writeUTF(nodeInstance.getStringId());
                }
            }
        }
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)workFlow.getContextInstance("VariableScope");
        Map variables = variableScopeInstance.getVariables();
        ArrayList keys = new ArrayList(variables.keySet());
        Collection values = variables.values();
        Collections.sort(keys);
        ArrayList notNullValues = new ArrayList();
        for (Object value : values) {
            if (value == null) continue;
            notNullValues.add(value);
        }
        stream.writeInt(notNullValues.size());
        for (String key : keys) {
            Object object = variables.get(key);
            if (object == null) continue;
            stream.writeUTF(key);
            int useNewMarshallingStrategyAlgorithm = -2;
            stream.writeInt(useNewMarshallingStrategyAlgorithm);
            ObjectMarshallingStrategy strategy = context.getObjectMarshallingStrategyStore().getStrategyObject(object);
            stream.writeUTF(strategy.getClass().getName());
            strategy.write(stream, object);
        }
        return null;
    }

    @Override
    public Object writeNodeInstance(MarshallerWriteContext context, NodeInstance nodeInstance) throws IOException {
        ObjectOutputStream stream = (ObjectOutputStream)context;
        stream.writeUTF(((KogitoNodeInstance)nodeInstance).getStringId());
        stream.writeLong(nodeInstance.getNodeId());
        this.writeNodeInstanceContent(stream, nodeInstance, context);
        return null;
    }

    protected void writeNodeInstanceContent(ObjectOutputStream stream, NodeInstance nodeInstance, MarshallerWriteContext context) throws IOException {
        if (nodeInstance instanceof RuleSetNodeInstance) {
            stream.writeShort(20);
            List timerInstances = ((RuleSetNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof HumanTaskNodeInstance) {
            stream.writeShort(27);
            stream.writeUTF(((HumanTaskNodeInstance)nodeInstance).getWorkItemId());
            List timerInstances = ((HumanTaskNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof WorkItemNodeInstance) {
            stream.writeShort(21);
            stream.writeUTF(((WorkItemNodeInstance)nodeInstance).getWorkItemId());
            List timerInstances = ((WorkItemNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof SubProcessNodeInstance) {
            stream.writeShort(22);
            stream.writeUTF(((SubProcessNodeInstance)nodeInstance).getProcessInstanceId());
            List timerInstances = ((SubProcessNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof MilestoneNodeInstance) {
            stream.writeShort(23);
            List timerInstances = ((MilestoneNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof EventNodeInstance) {
            stream.writeShort(32);
        } else if (nodeInstance instanceof TimerNodeInstance) {
            stream.writeShort(24);
            stream.writeUTF(((TimerNodeInstance)nodeInstance).getTimerId());
        } else if (nodeInstance instanceof JoinInstance) {
            stream.writeShort(25);
            Map triggers = ((JoinInstance)nodeInstance).getTriggers();
            stream.writeInt(triggers.size());
            ArrayList keys = new ArrayList(triggers.keySet());
            Collections.sort(keys, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o1.compareTo(o2);
                }
            });
            for (Long key : keys) {
                stream.writeLong(key);
                stream.writeInt((Integer)triggers.get(key));
            }
        } else if (nodeInstance instanceof StateNodeInstance) {
            stream.writeShort(30);
            List timerInstances = ((StateNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
        } else if (nodeInstance instanceof CompositeContextNodeInstance) {
            if (nodeInstance instanceof DynamicNodeInstance) {
                stream.writeShort(31);
            } else {
                stream.writeShort(26);
            }
            CompositeContextNodeInstance compositeNodeInstance = (CompositeContextNodeInstance)nodeInstance;
            List timerInstances = ((CompositeContextNodeInstance)nodeInstance).getTimerInstances();
            if (timerInstances != null) {
                stream.writeInt(timerInstances.size());
                for (String id : timerInstances) {
                    stream.writeUTF(id);
                }
            } else {
                stream.writeInt(0);
            }
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)compositeNodeInstance.getContextInstance("VariableScope");
            if (variableScopeInstance == null) {
                stream.writeInt(0);
            } else {
                Map variables = variableScopeInstance.getVariables();
                ArrayList keys = new ArrayList(variables.keySet());
                Collections.sort(keys, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareTo(o2);
                    }
                });
                stream.writeInt(keys.size());
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    stream.writeUTF(key);
                    stream.writeObject(variables.get(key));
                }
            }
            ArrayList nodeInstances = new ArrayList(compositeNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return ((KogitoNodeInstance)o1).getStringId().compareTo(((KogitoNodeInstance)o2).getStringId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
            List exclusiveGroupInstances = compositeNodeInstance.getContextInstances("ExclusiveGroup");
            if (exclusiveGroupInstances == null) {
                stream.writeInt(0);
            } else {
                stream.writeInt(exclusiveGroupInstances.size());
                for (ContextInstance contextInstance : exclusiveGroupInstances) {
                    ExclusiveGroupInstance exclusiveGroupInstance = (ExclusiveGroupInstance)contextInstance;
                    Collection groupNodeInstances = exclusiveGroupInstance.getNodeInstances();
                    stream.writeInt(groupNodeInstances.size());
                    for (KogitoNodeInstance groupNodeInstance : groupNodeInstances) {
                        stream.writeUTF(groupNodeInstance.getStringId());
                    }
                }
            }
        } else if (nodeInstance instanceof ForEachNodeInstance) {
            stream.writeShort(28);
            ForEachNodeInstance forEachNodeInstance = (ForEachNodeInstance)nodeInstance;
            ArrayList nodeInstances = new ArrayList(forEachNodeInstance.getNodeInstances());
            Collections.sort(nodeInstances, new Comparator<NodeInstance>(){

                @Override
                public int compare(NodeInstance o1, NodeInstance o2) {
                    return ((KogitoNodeInstance)o1).getStringId().compareTo(((KogitoNodeInstance)o2).getStringId());
                }
            });
            for (NodeInstance subNodeInstance : nodeInstances) {
                if (!(subNodeInstance instanceof CompositeContextNodeInstance)) continue;
                stream.writeShort(18);
                this.writeNodeInstance(context, subNodeInstance);
            }
            stream.writeShort(1);
        } else {
            throw new IllegalArgumentException("Unknown node instance type: " + nodeInstance);
        }
    }

    @Override
    public ProcessInstance readProcessInstance(MarshallerReaderContext context) throws IOException {
        ObjectInputStream stream = (ObjectInputStream)context;
        InternalKnowledgeBase kBase = context.getKnowledgeBase();
        InternalWorkingMemory wm = context.getWorkingMemory();
        WorkflowProcessInstanceImpl processInstance = this.createProcessInstance();
        processInstance.setId(stream.readUTF());
        String processId = stream.readUTF();
        processInstance.setProcessId(processId);
        Process process = kBase.getProcess(processId);
        if (kBase != null) {
            processInstance.setProcess(process);
        }
        processInstance.setState(stream.readInt());
        long nodeInstanceCounter = stream.readLong();
        processInstance.setKnowledgeRuntime(wm.getKnowledgeRuntime());
        int nbSwimlanes = stream.readInt();
        if (nbSwimlanes > 0) {
            Context swimlaneContext = ((org.jbpm.process.core.Process)process).getDefaultContext("SwimlaneScope");
            SwimlaneContextInstance swimlaneContextInstance = (SwimlaneContextInstance)processInstance.getContextInstance(swimlaneContext);
            for (int i = 0; i < nbSwimlanes; ++i) {
                String name = stream.readUTF();
                String value = stream.readUTF();
                swimlaneContextInstance.setActorId(name, value);
            }
        }
        while (stream.readShort() == 18) {
            this.readNodeInstance(context, (NodeInstanceContainer)processInstance, (org.kie.api.runtime.process.WorkflowProcessInstance)processInstance);
        }
        int exclusiveGroupInstances = stream.readInt();
        for (int i = 0; i < exclusiveGroupInstances; ++i) {
            ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
            processInstance.addContextInstance("ExclusiveGroup", (ContextInstance)exclusiveGroupInstance);
            int nodeInstances = stream.readInt();
            for (int j = 0; j < nodeInstances; ++j) {
                String nodeInstanceId = stream.readUTF();
                KogitoNodeInstance nodeInstance = processInstance.getNodeInstance(nodeInstanceId);
                if (nodeInstance == null) {
                    throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                }
                exclusiveGroupInstance.addNodeInstance(nodeInstance);
            }
        }
        int nbVariables = stream.readInt();
        if (nbVariables > 0) {
            Context variableScope = ((org.jbpm.process.core.Process)process).getDefaultContext("VariableScope");
            VariableScopeInstance variableScopeInstance = (VariableScopeInstance)processInstance.getContextInstance(variableScope);
            for (int i = 0; i < nbVariables; ++i) {
                String name = stream.readUTF();
                try {
                    String strategyClassName;
                    ObjectMarshallingStrategy strategy = null;
                    int index = stream.readInt();
                    if (index >= 0) {
                        strategy = context.getResolverStrategyFactory().getStrategy(index);
                    } else if (index == -2 && !StringUtils.isEmpty((CharSequence)(strategyClassName = context.readUTF())) && (strategy = context.getResolverStrategyFactory().getStrategyObject(strategyClassName)) == null) {
                        throw new IllegalStateException("No strategy of type " + strategyClassName + " available.");
                    }
                    Object value = null;
                    if (strategy != null) {
                        value = strategy.read(stream);
                    }
                    variableScopeInstance.internalSetVariable(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload variable " + name);
                }
            }
        }
        if (wm != null) {
            processInstance.reconnect();
        }
        return processInstance;
    }

    protected abstract WorkflowProcessInstanceImpl createProcessInstance();

    @Override
    public NodeInstance readNodeInstance(MarshallerReaderContext context, NodeInstanceContainer nodeInstanceContainer, org.kie.api.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        ObjectInputStream stream = (ObjectInputStream)context;
        String id = stream.readUTF();
        long nodeId = stream.readLong();
        short nodeType = stream.readShort();
        NodeInstanceImpl nodeInstance = this.readNodeInstanceContent(nodeType, stream, context, processInstance);
        nodeInstance.setNodeId(nodeId);
        nodeInstance.setNodeInstanceContainer(nodeInstanceContainer);
        nodeInstance.setProcessInstance((WorkflowProcessInstance)processInstance);
        nodeInstance.setId(id);
        switch (nodeType) {
            case 26: 
            case 31: {
                int nbVariables = stream.readInt();
                if (nbVariables > 0) {
                    Context variableScope = ((org.jbpm.process.core.Process)((org.jbpm.process.instance.ProcessInstance)processInstance).getProcess()).getDefaultContext("VariableScope");
                    VariableScopeInstance variableScopeInstance = (VariableScopeInstance)((CompositeContextNodeInstance)nodeInstance).getContextInstance(variableScope);
                    for (int i = 0; i < nbVariables; ++i) {
                        String name = stream.readUTF();
                        try {
                            Object value = stream.readObject();
                            variableScopeInstance.internalSetVariable(name, value);
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not reload variable " + name);
                        }
                    }
                }
                while (stream.readShort() == 18) {
                    this.readNodeInstance(context, (NodeInstanceContainer)((CompositeContextNodeInstance)nodeInstance), processInstance);
                }
                int exclusiveGroupInstances = stream.readInt();
                for (int i = 0; i < exclusiveGroupInstances; ++i) {
                    ExclusiveGroupInstance exclusiveGroupInstance = new ExclusiveGroupInstance();
                    ((org.jbpm.process.instance.ProcessInstance)processInstance).addContextInstance("ExclusiveGroup", (ContextInstance)exclusiveGroupInstance);
                    int nodeInstances = stream.readInt();
                    for (int j = 0; j < nodeInstances; ++j) {
                        String nodeInstanceId = stream.readUTF();
                        KogitoNodeInstance groupNodeInstance = ((KogitoNodeInstanceContainer)processInstance).getNodeInstance(nodeInstanceId);
                        if (groupNodeInstance == null) {
                            throw new IllegalArgumentException("Could not find node instance when deserializing exclusive group instance: " + nodeInstanceId);
                        }
                        exclusiveGroupInstance.addNodeInstance(groupNodeInstance);
                    }
                }
                break;
            }
            case 28: {
                while (stream.readShort() == 18) {
                    this.readNodeInstance(context, (NodeInstanceContainer)((ForEachNodeInstance)nodeInstance), processInstance);
                }
                break;
            }
        }
        return nodeInstance;
    }

    protected NodeInstanceImpl readNodeInstanceContent(int nodeType, ObjectInputStream stream, MarshallerReaderContext context, org.kie.api.runtime.process.WorkflowProcessInstance processInstance) throws IOException {
        RuleSetNodeInstance nodeInstance = null;
        switch (nodeType) {
            case 20: {
                nodeInstance = new RuleSetNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                nodeInstance.internalSetTimerInstances(timerInstances);
                break;
            }
            case 27: {
                nodeInstance = new HumanTaskNodeInstance();
                ((HumanTaskNodeInstance)nodeInstance).internalSetWorkItemId(stream.readUTF());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((HumanTaskNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 21: {
                nodeInstance = new WorkItemNodeInstance();
                ((WorkItemNodeInstance)nodeInstance).internalSetWorkItemId(stream.readUTF());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((WorkItemNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 22: {
                nodeInstance = new SubProcessNodeInstance();
                ((SubProcessNodeInstance)nodeInstance).internalSetProcessInstanceId(stream.readUTF());
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((SubProcessNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 23: {
                nodeInstance = new MilestoneNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((MilestoneNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 24: {
                nodeInstance = new TimerNodeInstance();
                ((TimerNodeInstance)nodeInstance).internalSetTimerId(stream.readUTF());
                break;
            }
            case 32: {
                nodeInstance = new EventNodeInstance();
                break;
            }
            case 25: {
                nodeInstance = new JoinInstance();
                int number = stream.readInt();
                if (number <= 0) break;
                HashMap<Long, Integer> triggers = new HashMap<Long, Integer>();
                for (int i = 0; i < number; ++i) {
                    long l = stream.readLong();
                    int count = stream.readInt();
                    triggers.put(l, count);
                }
                ((JoinInstance)nodeInstance).internalSetTriggers(triggers);
                break;
            }
            case 26: {
                nodeInstance = new CompositeContextNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 28: {
                nodeInstance = new ForEachNodeInstance();
                break;
            }
            case 31: {
                nodeInstance = new DynamicNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            case 30: {
                nodeInstance = new StateNodeInstance();
                int nbTimerInstances = stream.readInt();
                if (nbTimerInstances <= 0) break;
                ArrayList<String> timerInstances = new ArrayList<String>();
                for (int i = 0; i < nbTimerInstances; ++i) {
                    timerInstances.add(stream.readUTF());
                }
                ((CompositeContextNodeInstance)nodeInstance).internalSetTimerInstances(timerInstances);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + nodeType);
            }
        }
        return nodeInstance;
    }
}

