/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Address;
import org.acme.travels.Traveller;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

@QuarkusTest
public class TravellersProcessTest {
    @Named(value="travellers")
    @Inject
    Process<? extends Model> travellersProcess;

    @Test
    public void testNewTraveller() {
        Assertions.assertNotNull(this.travellersProcess);
        Model m = (Model)this.travellersProcess.createModel();
        HashMap<String, Traveller> parameters = new HashMap<String, Traveller>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.travellersProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        Assertions.assertEquals(result.toMap().get("stored"), (Object)true);
    }
}

