/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.User;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;

@Disabled(value="depends on https://petstore.swagger.io existing users")
@QuarkusTest
public class UsersProcessTest {
    @Named(value="users")
    @Inject
    Process<? extends Model> usersProcess;

    @Test
    public void testExistingUser() {
        Assertions.assertNotNull(this.usersProcess);
        Model m = (Model)this.usersProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", "test");
        m.fromMap(parameters);
        ProcessInstance processInstance = this.usersProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        User user = (User)result.toMap().get("traveller");
        Assertions.assertNotNull((Object)user);
        Assertions.assertEquals((Object)"test", (Object)user.getUsername());
        Assertions.assertEquals((Object)"Test", (Object)user.getFirstName());
        Assertions.assertEquals((Object)"Test", (Object)user.getLastName());
        Assertions.assertEquals((Object)"test@test.com", (Object)user.getEmail());
    }

    @Test
    public void testNotExistingUser() {
        Assertions.assertNotNull(this.usersProcess);
        Model m = (Model)this.usersProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", "notexisting");
        m.fromMap(parameters);
        ProcessInstance processInstance = this.usersProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)2, (int)result.toMap().size());
        User user = (User)result.toMap().get("traveller");
        Assertions.assertNull((Object)user);
    }
}

