/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import io.quarkus.test.junit.QuarkusTest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.acme.travels.Address;
import org.acme.travels.Traveller;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;

@QuarkusTest
public class ApprovalsProcessTest {
    @Named(value="approvals")
    @Inject
    Process<? extends Model> approvalsProcess;

    @Test
    public void testApprovalProcess() {
        Assertions.assertNotNull(this.approvalsProcess);
        Model m = (Model)this.approvalsProcess.createModel();
        HashMap<String, Traveller> parameters = new HashMap<String, Traveller>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.approvalsProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"admin", Collections.singletonList("managers")));
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("approved", true);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), results, new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        Assertions.assertEquals((int)0, (int)workItems.size());
        policy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john", Collections.singletonList("managers")));
        processInstance.workItems(new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        results.put("approved", false);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), results, new Policy[]{policy});
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)4, (int)result.toMap().size());
        Assertions.assertEquals(result.toMap().get("approver"), (Object)"admin");
        Assertions.assertEquals(result.toMap().get("firstLineApproval"), (Object)true);
        Assertions.assertEquals(result.toMap().get("secondLineApproval"), (Object)false);
    }

    @Test
    public void testApprovalProcessViaPhases() {
        Assertions.assertNotNull(this.approvalsProcess);
        Model m = (Model)this.approvalsProcess.createModel();
        HashMap<String, Traveller> parameters = new HashMap<String, Traveller>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.approvalsProcess.createInstance(m);
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", null, new Policy[]{policy}));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", Collections.singletonMap("approved", true), new Policy[]{policy}));
        workItems = processInstance.workItems(new Policy[]{policy});
        Assertions.assertEquals((int)0, (int)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        Assertions.assertEquals((int)1, (int)workItems.size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", null, new Policy[]{policy}));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", Collections.singletonMap("approved", false), new Policy[]{policy}));
        Assertions.assertEquals((int)2, (int)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assertions.assertEquals((int)4, (int)result.toMap().size());
        Assertions.assertEquals(result.toMap().get("approver"), (Object)"admin");
        Assertions.assertEquals(result.toMap().get("firstLineApproval"), (Object)true);
        Assertions.assertEquals(result.toMap().get("secondLineApproval"), (Object)false);
    }
}

