/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.acme.travels.ApprovalsModel;
import org.acme.travels.ApprovalsModelInput;
import org.acme.travels.ApprovalsModelOutput;
import org.acme.travels.Approvals_1_TaskInput;
import org.acme.travels.Approvals_1_TaskOutput;
import org.acme.travels.Approvals_2_TaskInput;
import org.acme.travels.Approvals_2_TaskOutput;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/approvals")
@Component
public class ApprovalsResource {
    @Autowired
    @Qualifier(value="approvals")
    Process<ApprovalsModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ApprovalsModelOutput createResource_approvals(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull ApprovalsModelInput resource) {
        if (resource == null) {
            resource = new ApprovalsModelInput();
        }
        ApprovalsModelInput value = resource;
        return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)this.mapInput(value, new ApprovalsModel()));
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return this.getModel(pi);
        });
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public List<ApprovalsModelOutput> getResources_approvals() {
        return this.process.instances().values().stream().map(pi -> this.mapOutput(new ApprovalsModelOutput(), (ApprovalsModel)pi.variables())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ApprovalsModelOutput getResource_approvals(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(pi -> this.mapOutput(new ApprovalsModelOutput(), (ApprovalsModel)pi.variables())).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ApprovalsModelOutput deleteResource_approvals(@PathParam(value="id") String id) {
        return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel(pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ApprovalsModelOutput updateModel_approvals(@PathParam(value="id") String id, ApprovalsModel resource) {
        return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return this.mapOutput(new ApprovalsModelOutput(), (ApprovalsModel)pi.variables());
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public Map<String, String> getTasks_approvals(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected ApprovalsModelOutput getModel(ProcessInstance<ApprovalsModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return this.mapOutput(new ApprovalsModelOutput(), (ApprovalsModel)pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    protected ApprovalsModel mapInput(@Valid @NotNull ApprovalsModelInput input, ApprovalsModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected ApprovalsModelOutput mapOutput(ApprovalsModelOutput output, ApprovalsModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }

    @POST
    @Path(value="/{id}/firstLineApproval/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ApprovalsModelOutput completeTask_1(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Approvals_1_TaskOutput model) {
        try {
            return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/firstLineApproval/{workItemId}")
    @Produces(value={"application/json"})
    public Approvals_1_TaskInput getTask_1(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Approvals_1_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/{id}/firstLineApproval/{workItemId}")
    @Produces(value={"application/json"})
    public ApprovalsModelOutput abortTask_1(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST
    @Path(value="/{id}/secondLineApproval/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ApprovalsModelOutput completeTask_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Approvals_2_TaskOutput model) {
        try {
            return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/secondLineApproval/{workItemId}")
    @Produces(value={"application/json"})
    public Approvals_2_TaskInput getTask_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return Approvals_2_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @DELETE
    @Path(value="/{id}/secondLineApproval/{workItemId}")
    @Produces(value={"application/json"})
    public ApprovalsModelOutput abortTask_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (ApprovalsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

