/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.acme.travels.ApprovalsModel;
import org.acme.travels.ApprovalsModelInput;
import org.acme.travels.ApprovalsModelOutput;
import org.acme.travels.Approvals_3_TaskInput;
import org.acme.travels.Approvals_3_TaskOutput;
import org.acme.travels.Approvals_4_TaskInput;
import org.acme.travels.Approvals_4_TaskOutput;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/approvals"})
@Component
public class ApprovalsResource {
    @Autowired
    @Qualifier(value="approvals")
    Process<ApprovalsModel> process;
    @Autowired
    Application application;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ResponseEntity<ApprovalsModelOutput> createResource_approvals(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull ApprovalsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ApprovalsModelInput inputModel = resource != null ? resource : new ApprovalsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            List startFromNode = httpHeaders.get((Object)"X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom((String)startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/approvals/{id}").buildAndExpand(new Object[]{pi.id()});
            URI location = uriComponents.toUri();
            return ResponseEntity.created((URI)location).body((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        });
    }

    @GetMapping(produces={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public List<ApprovalsModelOutput> getResources_approvals() {
        return this.process.instances().values().stream().map(pi -> ((ApprovalsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ResponseEntity<ApprovalsModelOutput> getResource_approvals(@PathVariable(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok((Object)((ApprovalsModel)m.variables()).toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ResponseEntity<ApprovalsModelOutput> deleteResource_approvals(@PathVariable(value="id") String id) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((ApprovalsModel)pi.checkError().variables()).toOutput();
        }).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ResponseEntity<ApprovalsModelOutput> updateModel_approvals(@PathVariable(value="id") String id, @RequestBody(required=false) ApprovalsModel resource) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((ApprovalsModel)pi.updateVariables((Object)resource)).toOutput()).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    @RolesAllowed(value={"employees", "managers"})
    public ResponseEntity<List<WorkItem>> getTasks_approvals(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{id}/firstLineApproval/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> completeTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups, @RequestBody(required=false) Approvals_3_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<Approvals_3_TaskInput> getTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Approvals_3_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"firstLineApproval/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_firstLineApproval_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"firstLineApproval");
    }

    @GetMapping(value={"/{id}/firstLineApproval/{workItemId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"firstLineApproval"));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> abortTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{workItemId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> completeTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups, @RequestBody(required=false) Approvals_4_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<Approvals_4_TaskInput> getTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Approvals_4_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"secondLineApproval/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_secondLineApproval_1() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"secondLineApproval");
    }

    @GetMapping(value={"/{id}/secondLineApproval/{workItemId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"secondLineApproval"));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{workItemId}"}, produces={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> abortTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="workItemId") String workItemId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false, defaultValue="") List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }
}

