/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.acme.travels.Address;
import org.acme.travels.Traveller;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.tests.KogitoInfinispanSpringbootApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoInfinispanSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class ApprovalsProcessTest {
    @Autowired
    @Qualifier(value="approvals")
    Process<? extends Model> approvalsProcess;

    @Test
    public void testApprovalProcess() {
        Assert.assertNotNull(this.approvalsProcess);
        Model m = (Model)this.approvalsProcess.createModel();
        HashMap<String, Traveller> parameters = new HashMap<String, Traveller>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.approvalsProcess.createInstance(m);
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        Assert.assertEquals((long)1L, (long)workItems.size());
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("approved", true);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), results, new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        Assert.assertEquals((long)0L, (long)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        Assert.assertEquals((long)1L, (long)workItems.size());
        results.put("approved", false);
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), results, new Policy[]{policy});
        Assert.assertEquals((long)2L, (long)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assert.assertEquals((long)4L, (long)result.toMap().size());
        Assert.assertEquals(result.toMap().get("approver"), (Object)"admin");
        Assert.assertEquals(result.toMap().get("firstLineApproval"), (Object)true);
        Assert.assertEquals(result.toMap().get("secondLineApproval"), (Object)false);
    }

    @Test
    public void testApprovalProcessViaPhases() {
        Assert.assertNotNull(this.approvalsProcess);
        Model m = (Model)this.approvalsProcess.createModel();
        HashMap<String, Traveller> parameters = new HashMap<String, Traveller>();
        parameters.put("traveller", new Traveller("John", "Doe", "john.doe@example.com", "American", new Address("main street", "Boston", "10005", "US")));
        m.fromMap(parameters);
        ProcessInstance processInstance = this.approvalsProcess.createInstance(m);
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        StaticIdentityProvider identity = new StaticIdentityProvider("admin", Collections.singletonList("managers"));
        SecurityPolicy policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        List workItems = processInstance.workItems(new Policy[]{policy});
        Assert.assertEquals((long)1L, (long)workItems.size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", null, new Policy[]{policy}));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", Collections.singletonMap("approved", true), new Policy[]{policy}));
        workItems = processInstance.workItems(new Policy[]{policy});
        Assert.assertEquals((long)0L, (long)workItems.size());
        identity = new StaticIdentityProvider("john", Collections.singletonList("managers"));
        policy = SecurityPolicy.of((IdentityProvider)identity);
        processInstance.workItems(new Policy[]{policy});
        workItems = processInstance.workItems(new Policy[]{policy});
        Assert.assertEquals((long)1L, (long)workItems.size());
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("claim", null, new Policy[]{policy}));
        processInstance.transitionWorkItem(((WorkItem)workItems.get(0)).getId(), (Transition)new HumanTaskTransition("complete", Collections.singletonMap("approved", false), new Policy[]{policy}));
        Assert.assertEquals((long)2L, (long)processInstance.status());
        Model result = (Model)processInstance.variables();
        Assert.assertEquals((long)4L, (long)result.toMap().size());
        Assert.assertEquals(result.toMap().get("approver"), (Object)"admin");
        Assert.assertEquals(result.toMap().get("firstLineApproval"), (Object)true);
        Assert.assertEquals(result.toMap().get("secondLineApproval"), (Object)false);
    }
}

