/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.workitems.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.kie.kogito.process.workitems.impl.WorkItemParamResolver;

public class KogitoWorkItemImplTest {
    @Test
    public void testPutParameters() {
        KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        workItem.getParameters().put("name", "javierito");
        workItem.getParameters().put("resolver", new MyWorkItemHandlerParamResolver());
        this.assertWI((KogitoWorkItem)workItem);
    }

    @Test
    public void testSetParameters() {
        KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "javierito");
        map.put("resolver", new MyWorkItemHandlerParamResolver());
        workItem.setParameters(map);
        this.assertWI((KogitoWorkItem)workItem);
    }

    @Test
    public void testSetParameter() {
        KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        workItem.setParameter("name", (Object)"javierito");
        workItem.setParameter("resolver", (Object)new MyWorkItemHandlerParamResolver());
        this.assertWI((KogitoWorkItem)workItem);
    }

    private void assertWI(KogitoWorkItem workItem) {
        this.assertEqualsWI(workItem, "javierito", "name");
        this.assertEqualsWI(workItem, "javierito is the best", "resolver");
    }

    private void assertEqualsWI(KogitoWorkItem workItem, Object expected, String parameter) {
        Assertions.assertEquals((Object)expected, (Object)workItem.getParameter(parameter));
        HashMap map = new HashMap(workItem.getParameters());
        Assertions.assertEquals((Object)expected, map.get(parameter));
        Assertions.assertEquals((Object)expected, map.entrySet().stream().filter(p -> ((String)p.getKey()).equals(parameter)).findFirst().orElseThrow(IllegalStateException::new).getValue());
    }

    private static class MyWorkItemHandlerParamResolver
    implements WorkItemParamResolver {
        private MyWorkItemHandlerParamResolver() {
        }

        public Object apply(KogitoWorkItem t) {
            return t.getParameter("name").toString().concat(" is the best");
        }
    }
}

