/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.workitems.impl.expr;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.process.workitems.impl.expr.ExpressionHandler;

public class ExpressionHandlerFactory {
    private static final Map<String, String> expHandlerClasses = new HashMap<String, String>();
    private static final Map<String, ExpressionHandler> expHandlerInstances = new ConcurrentHashMap<String, ExpressionHandler>();
    private static final String JSONPATH_CLASSNAME = "org.kie.kogito.expr.jsonpath.JsonPathExpressionHandler";
    private static final String JSONPATH_LANG = "jsonpath";
    private static final String JQ_CLASSNAME = "org.kie.kogito.expr.jq.JqExpressionHandler";
    private static final String JQ_LANG = "jq";

    private ExpressionHandlerFactory() {
    }

    public static ExpressionHandler get(String lang) {
        return expHandlerInstances.computeIfAbsent(lang, c -> {
            try {
                return Class.forName(expHandlerClasses.getOrDefault(c, JSONPATH_CLASSNAME)).asSubclass(ExpressionHandler.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public static boolean isSupported(String lang) {
        return lang != null && expHandlerClasses.containsKey(lang);
    }

    static {
        expHandlerClasses.put(JSONPATH_LANG, JSONPATH_CLASSNAME);
        expHandlerClasses.put(JQ_LANG, JQ_CLASSNAME);
    }
}

