/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import java.util.Date;
import org.infinispan.protostream.BaseMarshaller;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.protobuf.ProtoStreamObjectMarshallingStrategy;

public class ProtoStreamObjectMarshallingStrategyTest {
    private ProtoStreamObjectMarshallingStrategy protoStreamMarshallerStrategy = new ProtoStreamObjectMarshallingStrategy(null, new BaseMarshaller[0]);

    @Test
    public void testStringMarshalling() throws Exception {
        String value = "here is simple string value";
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"String type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.String", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }

    @Test
    public void testIntegerMarshalling() throws Exception {
        Integer value = 25;
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"Integer type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.Integer", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }

    @Test
    public void testLongMarshalling() throws Exception {
        Long value = 555L;
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"Long type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.Long", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }

    @Test
    public void testDoubleMarshalling() throws Exception {
        Double value = 55.5;
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"Double type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.Double", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }

    @Test
    public void testFloatMarshalling() throws Exception {
        Float value = Float.valueOf(55.5f);
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"Float type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.Float", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }

    @Test
    public void testBooleanMarshalling() throws Exception {
        Boolean value = true;
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"Boolean type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.Boolean", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }

    @Test
    public void testDateMarshalling() throws Exception {
        Date value = new Date();
        boolean accepted = this.protoStreamMarshallerStrategy.accept((Object)value);
        Assertions.assertTrue((boolean)accepted, (String)"Date type should be accepted");
        byte[] data = this.protoStreamMarshallerStrategy.marshal(null, null, (Object)value);
        Assertions.assertNotNull((Object)data, (String)"Marshalled content should not be null");
        Object returned = this.protoStreamMarshallerStrategy.unmarshal("kogito.Date", null, null, data, this.getClass().getClassLoader());
        Assertions.assertNotNull((Object)returned, (String)"Unmarshalled value should not be null");
        Assertions.assertEquals((Object)value, (Object)returned, (String)"Values should be the same");
    }
}

